#include <cxxtest/TestSuite.h>

#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif

#include "common/memstream.h"
#include "image/gif.h"
#include "graphics/surface.h"

class GIFDecoderTestSuite : public CxxTest::TestSuite {
public:
	void test_load_gif_2x2() {
#ifdef USE_GIF
		const uint8 gifBuf[63] = {
			0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x02, 0x00, 0x02, 0x00, 0xa1,
			0x03, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x14, 0x82, 0x31,
			0xff, 0xff, 0xff, 0x21, 0xfe, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74,
			0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x47, 0x49, 0x4d,
			0x50, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00,
			0x00, 0x02, 0x03, 0x54, 0x06, 0x05, 0x00, 0x3b
		};

		Image::GIFDecoder decoder;
		Common::MemoryReadStream stream(gifBuf, sizeof(gifBuf));
		const bool status = decoder.loadStream(stream);
		TS_ASSERT(status);
		if (!status) {
			return;
		}
		const Graphics::Surface *surface = decoder.getSurface();
		TS_ASSERT(surface != 0);
		if (surface == 0) {
			return;
		}
		TS_ASSERT_EQUALS(surface->w, 2);
		TS_ASSERT_EQUALS(surface->h, 2);
		TS_ASSERT_EQUALS(surface->format.bytesPerPixel, 1);
#endif
	}
};
