/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SLUDGE_CURSORS_H
#define SLUDGE_CURSORS_H

namespace Common {
class SeekableReadStream;
class WriteStream;
}

namespace Sludge {

class SludgeEngine;

struct FrozenStuffStruct;

class CursorManager {
public:
	CursorManager(SludgeEngine *vm);
	virtual ~CursorManager();

	void init();
	void kill();

	// cursor
	void pickAnimCursor(struct PersonaAnimation  *pp);
	void displayCursor();
	void pasteCursor(int x, int y, struct PersonaAnimation  *c);

	// freeze
	void freeze(FrozenStuffStruct *frozenStuff);
	void resotre(FrozenStuffStruct *frozenStuff);

	// load & save
	void saveCursor(Common::WriteStream *stream);
	bool loadCursor(Common::SeekableReadStream *stream);

private:
	SludgeEngine *_vm;

	PersonaAnimation *_mouseCursorAnim;
	int _mouseCursorFrameNum;
	int _mouseCursorCountUp;
};

} // End of namespace Sludge

#endif
