% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deployments.R
\name{forgetDeployment}
\alias{forgetDeployment}
\title{Forget Application Deployment}
\usage{
forgetDeployment(
  appPath = getwd(),
  name = NULL,
  account = NULL,
  server = NULL,
  dryRun = FALSE,
  force = !interactive()
)
}
\arguments{
\item{appPath}{The path to the content that was deployed, either a directory
or an individual document.}

\item{name}{The name of the content that was deployed (optional)}

\item{account}{The name of the account to which the content was deployed
(optional)}

\item{server}{The name of the server to which the content was deployed
(optional)}

\item{dryRun}{Set to TRUE to preview the files/directories to be removed
instead of actually removing them. Defaults to FALSE.}

\item{force}{Set to TRUE to remove files and directories without prompting.
Defaults to FALSE in interactive sessions.}
}
\value{
NULL, invisibly.
}
\description{
Forgets about an application deployment. This is useful if the application
has been deleted on the server, or the local deployment information needs to
be reset.
}
\details{
This method removes from disk the file containing deployment
metadata. If "name", "account", and "server" are all NULL, then all of the
deployments for the application are forgotten; otherwise, only the
specified deployment is forgotten.
}
