% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{Date-arithmetic}
\alias{Date-arithmetic}
\alias{add_years.Date}
\alias{add_quarters.Date}
\alias{add_months.Date}
\alias{add_weeks.Date}
\alias{add_days.Date}
\title{Arithmetic: date}
\usage{
\method{add_years}{Date}(x, n, ..., invalid = NULL)

\method{add_quarters}{Date}(x, n, ..., invalid = NULL)

\method{add_months}{Date}(x, n, ..., invalid = NULL)

\method{add_weeks}{Date}(x, n, ...)

\method{add_days}{Date}(x, n, ...)
}
\arguments{
\item{x}{\verb{[Date]}

A Date vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
\code{x} after performing the arithmetic.
}
\description{
These are Date methods for the
\link[=clock-arithmetic]{arithmetic generics}.

Calendrical based arithmetic:

These functions convert to a year-month-day calendar, perform
the arithmetic, then convert back to a Date.
\itemize{
\item \code{add_years()}
\item \code{add_quarters()}
\item \code{add_months()}
}

Time point based arithmetic:

These functions convert to a time point, perform the arithmetic, then
convert back to a Date.
\itemize{
\item \code{add_weeks()}
\item \code{add_days()}
}
}
\details{
Adding a single quarter with \code{add_quarters()} is equivalent to adding
3 months.

\code{x} and \code{n} are recycled against each other using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.

Only calendrical based arithmetic has the potential to generate invalid
dates. Time point based arithmetic, like adding days, will always generate
a valid date.
}
\examples{
x <- as.Date("2019-01-01")

add_years(x, 1:5)

y <- as.Date("2019-01-31")

# Adding 1 month to `y` generates an invalid date. Unlike year-month-day
# types, R's native Date type cannot handle invalid dates, so you must
# resolve them immediately. If you don't you get an error:
try(add_months(y, 1:2))
add_months(as_year_month_day(y), 1:2)

# Resolve invalid dates by specifying an invalid date resolution strategy
# with the `invalid` argument. Using `"previous"` here sets the date to
# the previous valid date - i.e. the end of the month.
add_months(y, 1:2, invalid = "previous")
}
