/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_PROFILE_HPP)
#define FIT_PROFILE_HPP

#include <string>
#include "fit.hpp"
#include "fit_config.hpp"
#if defined(FIT_CPP_INCLUDE_C)
#include "fit_product.h"
#endif


///////////////////////////////////////////////////////////////////////
// Public Definitions
///////////////////////////////////////////////////////////////////////

#if !defined(FIT_CPP_INCLUDE_C) // Types defined in fit_product.h if including C code.

///////////////////////////////////////////////////////////////////////
// Types
///////////////////////////////////////////////////////////////////////


typedef FIT_ENUM FIT_FILE;
#define FIT_FILE_INVALID                                                         FIT_ENUM_INVALID
#define FIT_FILE_DEVICE                                                          ((FIT_FILE)1) // Read only, single file. Must be in root directory.
#define FIT_FILE_SETTINGS                                                        ((FIT_FILE)2) // Read/write, single file. Directory=Settings
#define FIT_FILE_SPORT                                                           ((FIT_FILE)3) // Read/write, multiple files, file number = sport type. Directory=Sports
#define FIT_FILE_ACTIVITY                                                        ((FIT_FILE)4) // Read/erase, multiple files. Directory=Activities
#define FIT_FILE_WORKOUT                                                         ((FIT_FILE)5) // Read/write/erase, multiple files. Directory=Workouts
#define FIT_FILE_COURSE                                                          ((FIT_FILE)6) // Read/write/erase, multiple files. Directory=Courses
#define FIT_FILE_SCHEDULES                                                       ((FIT_FILE)7) // Read/write, single file. Directory=Schedules
#define FIT_FILE_WEIGHT                                                          ((FIT_FILE)9) // Read only, single file. Circular buffer. All message definitions at start of file. Directory=Weight
#define FIT_FILE_TOTALS                                                          ((FIT_FILE)10) // Read only, single file. Directory=Totals
#define FIT_FILE_GOALS                                                           ((FIT_FILE)11) // Read/write, single file. Directory=Goals
#define FIT_FILE_BLOOD_PRESSURE                                                  ((FIT_FILE)14) // Read only. Directory=Blood Pressure
#define FIT_FILE_MONITORING_A                                                    ((FIT_FILE)15) // Read only. Directory=Monitoring. File number=sub type.
#define FIT_FILE_ACTIVITY_SUMMARY                                                ((FIT_FILE)20) // Read/erase, multiple files. Directory=Activities
#define FIT_FILE_MONITORING_DAILY                                                ((FIT_FILE)28)
#define FIT_FILE_MONITORING_B                                                    ((FIT_FILE)32) // Read only. Directory=Monitoring. File number=identifier
#define FIT_FILE_SEGMENT                                                         ((FIT_FILE)34) // Read/write/erase. Multiple Files. Directory=Segments
#define FIT_FILE_SEGMENT_LIST                                                    ((FIT_FILE)35) // Read/write/erase. Single File. Directory=Segments
#define FIT_FILE_EXD_CONFIGURATION                                               ((FIT_FILE)40) // Read/write/erase. Single File. Directory=Settings
#define FIT_FILE_MFG_RANGE_MIN                                                   ((FIT_FILE)0xF7) // 0xF7 - 0xFE reserved for manufacturer specific file types
#define FIT_FILE_MFG_RANGE_MAX                                                   ((FIT_FILE)0xFE) // 0xF7 - 0xFE reserved for manufacturer specific file types
#define FIT_FILE_COUNT                                                           20

typedef FIT_UINT16 FIT_MESG_NUM;
#define FIT_MESG_NUM_INVALID                                                     FIT_UINT16_INVALID
#define FIT_MESG_NUM_FILE_ID                                                     ((FIT_MESG_NUM)0)
#define FIT_MESG_NUM_CAPABILITIES                                                ((FIT_MESG_NUM)1)
#define FIT_MESG_NUM_DEVICE_SETTINGS                                             ((FIT_MESG_NUM)2)
#define FIT_MESG_NUM_USER_PROFILE                                                ((FIT_MESG_NUM)3)
#define FIT_MESG_NUM_HRM_PROFILE                                                 ((FIT_MESG_NUM)4)
#define FIT_MESG_NUM_SDM_PROFILE                                                 ((FIT_MESG_NUM)5)
#define FIT_MESG_NUM_BIKE_PROFILE                                                ((FIT_MESG_NUM)6)
#define FIT_MESG_NUM_ZONES_TARGET                                                ((FIT_MESG_NUM)7)
#define FIT_MESG_NUM_HR_ZONE                                                     ((FIT_MESG_NUM)8)
#define FIT_MESG_NUM_POWER_ZONE                                                  ((FIT_MESG_NUM)9)
#define FIT_MESG_NUM_MET_ZONE                                                    ((FIT_MESG_NUM)10)
#define FIT_MESG_NUM_SPORT                                                       ((FIT_MESG_NUM)12)
#define FIT_MESG_NUM_GOAL                                                        ((FIT_MESG_NUM)15)
#define FIT_MESG_NUM_SESSION                                                     ((FIT_MESG_NUM)18)
#define FIT_MESG_NUM_LAP                                                         ((FIT_MESG_NUM)19)
#define FIT_MESG_NUM_RECORD                                                      ((FIT_MESG_NUM)20)
#define FIT_MESG_NUM_EVENT                                                       ((FIT_MESG_NUM)21)
#define FIT_MESG_NUM_DEVICE_INFO                                                 ((FIT_MESG_NUM)23)
#define FIT_MESG_NUM_WORKOUT                                                     ((FIT_MESG_NUM)26)
#define FIT_MESG_NUM_WORKOUT_STEP                                                ((FIT_MESG_NUM)27)
#define FIT_MESG_NUM_SCHEDULE                                                    ((FIT_MESG_NUM)28)
#define FIT_MESG_NUM_WEIGHT_SCALE                                                ((FIT_MESG_NUM)30)
#define FIT_MESG_NUM_COURSE                                                      ((FIT_MESG_NUM)31)
#define FIT_MESG_NUM_COURSE_POINT                                                ((FIT_MESG_NUM)32)
#define FIT_MESG_NUM_TOTALS                                                      ((FIT_MESG_NUM)33)
#define FIT_MESG_NUM_ACTIVITY                                                    ((FIT_MESG_NUM)34)
#define FIT_MESG_NUM_SOFTWARE                                                    ((FIT_MESG_NUM)35)
#define FIT_MESG_NUM_FILE_CAPABILITIES                                           ((FIT_MESG_NUM)37)
#define FIT_MESG_NUM_MESG_CAPABILITIES                                           ((FIT_MESG_NUM)38)
#define FIT_MESG_NUM_FIELD_CAPABILITIES                                          ((FIT_MESG_NUM)39)
#define FIT_MESG_NUM_FILE_CREATOR                                                ((FIT_MESG_NUM)49)
#define FIT_MESG_NUM_BLOOD_PRESSURE                                              ((FIT_MESG_NUM)51)
#define FIT_MESG_NUM_SPEED_ZONE                                                  ((FIT_MESG_NUM)53)
#define FIT_MESG_NUM_MONITORING                                                  ((FIT_MESG_NUM)55)
#define FIT_MESG_NUM_TRAINING_FILE                                               ((FIT_MESG_NUM)72)
#define FIT_MESG_NUM_HRV                                                         ((FIT_MESG_NUM)78)
#define FIT_MESG_NUM_ANT_RX                                                      ((FIT_MESG_NUM)80)
#define FIT_MESG_NUM_ANT_TX                                                      ((FIT_MESG_NUM)81)
#define FIT_MESG_NUM_ANT_CHANNEL_ID                                              ((FIT_MESG_NUM)82)
#define FIT_MESG_NUM_LENGTH                                                      ((FIT_MESG_NUM)101)
#define FIT_MESG_NUM_MONITORING_INFO                                             ((FIT_MESG_NUM)103)
#define FIT_MESG_NUM_PAD                                                         ((FIT_MESG_NUM)105)
#define FIT_MESG_NUM_SLAVE_DEVICE                                                ((FIT_MESG_NUM)106)
#define FIT_MESG_NUM_CONNECTIVITY                                                ((FIT_MESG_NUM)127)
#define FIT_MESG_NUM_WEATHER_CONDITIONS                                          ((FIT_MESG_NUM)128)
#define FIT_MESG_NUM_WEATHER_ALERT                                               ((FIT_MESG_NUM)129)
#define FIT_MESG_NUM_CADENCE_ZONE                                                ((FIT_MESG_NUM)131)
#define FIT_MESG_NUM_HR                                                          ((FIT_MESG_NUM)132)
#define FIT_MESG_NUM_SEGMENT_LAP                                                 ((FIT_MESG_NUM)142)
#define FIT_MESG_NUM_MEMO_GLOB                                                   ((FIT_MESG_NUM)145)
#define FIT_MESG_NUM_SEGMENT_ID                                                  ((FIT_MESG_NUM)148)
#define FIT_MESG_NUM_SEGMENT_LEADERBOARD_ENTRY                                   ((FIT_MESG_NUM)149)
#define FIT_MESG_NUM_SEGMENT_POINT                                               ((FIT_MESG_NUM)150)
#define FIT_MESG_NUM_SEGMENT_FILE                                                ((FIT_MESG_NUM)151)
#define FIT_MESG_NUM_WORKOUT_SESSION                                             ((FIT_MESG_NUM)158)
#define FIT_MESG_NUM_WATCHFACE_SETTINGS                                          ((FIT_MESG_NUM)159)
#define FIT_MESG_NUM_GPS_METADATA                                                ((FIT_MESG_NUM)160)
#define FIT_MESG_NUM_CAMERA_EVENT                                                ((FIT_MESG_NUM)161)
#define FIT_MESG_NUM_TIMESTAMP_CORRELATION                                       ((FIT_MESG_NUM)162)
#define FIT_MESG_NUM_GYROSCOPE_DATA                                              ((FIT_MESG_NUM)164)
#define FIT_MESG_NUM_ACCELEROMETER_DATA                                          ((FIT_MESG_NUM)165)
#define FIT_MESG_NUM_THREE_D_SENSOR_CALIBRATION                                  ((FIT_MESG_NUM)167)
#define FIT_MESG_NUM_VIDEO_FRAME                                                 ((FIT_MESG_NUM)169)
#define FIT_MESG_NUM_OBDII_DATA                                                  ((FIT_MESG_NUM)174)
#define FIT_MESG_NUM_NMEA_SENTENCE                                               ((FIT_MESG_NUM)177)
#define FIT_MESG_NUM_AVIATION_ATTITUDE                                           ((FIT_MESG_NUM)178)
#define FIT_MESG_NUM_VIDEO                                                       ((FIT_MESG_NUM)184)
#define FIT_MESG_NUM_VIDEO_TITLE                                                 ((FIT_MESG_NUM)185)
#define FIT_MESG_NUM_VIDEO_DESCRIPTION                                           ((FIT_MESG_NUM)186)
#define FIT_MESG_NUM_VIDEO_CLIP                                                  ((FIT_MESG_NUM)187)
#define FIT_MESG_NUM_OHR_SETTINGS                                                ((FIT_MESG_NUM)188)
#define FIT_MESG_NUM_EXD_SCREEN_CONFIGURATION                                    ((FIT_MESG_NUM)200)
#define FIT_MESG_NUM_EXD_DATA_FIELD_CONFIGURATION                                ((FIT_MESG_NUM)201)
#define FIT_MESG_NUM_EXD_DATA_CONCEPT_CONFIGURATION                              ((FIT_MESG_NUM)202)
#define FIT_MESG_NUM_FIELD_DESCRIPTION                                           ((FIT_MESG_NUM)206)
#define FIT_MESG_NUM_DEVELOPER_DATA_ID                                           ((FIT_MESG_NUM)207)
#define FIT_MESG_NUM_MAGNETOMETER_DATA                                           ((FIT_MESG_NUM)208)
#define FIT_MESG_NUM_BAROMETER_DATA                                              ((FIT_MESG_NUM)209)
#define FIT_MESG_NUM_ONE_D_SENSOR_CALIBRATION                                    ((FIT_MESG_NUM)210)
#define FIT_MESG_NUM_MONITORING_HR_DATA                                          ((FIT_MESG_NUM)211)
#define FIT_MESG_NUM_TIME_IN_ZONE                                                ((FIT_MESG_NUM)216)
#define FIT_MESG_NUM_SET                                                         ((FIT_MESG_NUM)225)
#define FIT_MESG_NUM_STRESS_LEVEL                                                ((FIT_MESG_NUM)227)
#define FIT_MESG_NUM_MAX_MET_DATA                                                ((FIT_MESG_NUM)229)
#define FIT_MESG_NUM_DIVE_SETTINGS                                               ((FIT_MESG_NUM)258)
#define FIT_MESG_NUM_DIVE_GAS                                                    ((FIT_MESG_NUM)259)
#define FIT_MESG_NUM_DIVE_ALARM                                                  ((FIT_MESG_NUM)262)
#define FIT_MESG_NUM_EXERCISE_TITLE                                              ((FIT_MESG_NUM)264)
#define FIT_MESG_NUM_DIVE_SUMMARY                                                ((FIT_MESG_NUM)268)
#define FIT_MESG_NUM_SPO2_DATA                                                   ((FIT_MESG_NUM)269)
#define FIT_MESG_NUM_SLEEP_LEVEL                                                 ((FIT_MESG_NUM)275)
#define FIT_MESG_NUM_JUMP                                                        ((FIT_MESG_NUM)285)
#define FIT_MESG_NUM_AAD_ACCEL_FEATURES                                          ((FIT_MESG_NUM)289)
#define FIT_MESG_NUM_BEAT_INTERVALS                                              ((FIT_MESG_NUM)290)
#define FIT_MESG_NUM_RESPIRATION_RATE                                            ((FIT_MESG_NUM)297)
#define FIT_MESG_NUM_HSA_ACCELEROMETER_DATA                                      ((FIT_MESG_NUM)302)
#define FIT_MESG_NUM_HSA_STEP_DATA                                               ((FIT_MESG_NUM)304)
#define FIT_MESG_NUM_HSA_SPO2_DATA                                               ((FIT_MESG_NUM)305)
#define FIT_MESG_NUM_HSA_STRESS_DATA                                             ((FIT_MESG_NUM)306)
#define FIT_MESG_NUM_HSA_RESPIRATION_DATA                                        ((FIT_MESG_NUM)307)
#define FIT_MESG_NUM_HSA_HEART_RATE_DATA                                         ((FIT_MESG_NUM)308)
#define FIT_MESG_NUM_SPLIT                                                       ((FIT_MESG_NUM)312)
#define FIT_MESG_NUM_SPLIT_SUMMARY                                               ((FIT_MESG_NUM)313)
#define FIT_MESG_NUM_HSA_BODY_BATTERY_DATA                                       ((FIT_MESG_NUM)314)
#define FIT_MESG_NUM_HSA_EVENT                                                   ((FIT_MESG_NUM)315)
#define FIT_MESG_NUM_CLIMB_PRO                                                   ((FIT_MESG_NUM)317)
#define FIT_MESG_NUM_TANK_UPDATE                                                 ((FIT_MESG_NUM)319)
#define FIT_MESG_NUM_TANK_SUMMARY                                                ((FIT_MESG_NUM)323)
#define FIT_MESG_NUM_SLEEP_ASSESSMENT                                            ((FIT_MESG_NUM)346)
#define FIT_MESG_NUM_HRV_STATUS_SUMMARY                                          ((FIT_MESG_NUM)370)
#define FIT_MESG_NUM_HRV_VALUE                                                   ((FIT_MESG_NUM)371)
#define FIT_MESG_NUM_RAW_BBI                                                     ((FIT_MESG_NUM)372)
#define FIT_MESG_NUM_DEVICE_AUX_BATTERY_INFO                                     ((FIT_MESG_NUM)375)
#define FIT_MESG_NUM_HSA_GYROSCOPE_DATA                                          ((FIT_MESG_NUM)376)
#define FIT_MESG_NUM_CHRONO_SHOT_SESSION                                         ((FIT_MESG_NUM)387)
#define FIT_MESG_NUM_CHRONO_SHOT_DATA                                            ((FIT_MESG_NUM)388)
#define FIT_MESG_NUM_HSA_CONFIGURATION_DATA                                      ((FIT_MESG_NUM)389)
#define FIT_MESG_NUM_DIVE_APNEA_ALARM                                            ((FIT_MESG_NUM)393)
#define FIT_MESG_NUM_SKIN_TEMP_OVERNIGHT                                         ((FIT_MESG_NUM)398)
#define FIT_MESG_NUM_HSA_WRIST_TEMPERATURE_DATA                                  ((FIT_MESG_NUM)409) // Message number for the HSA wrist temperature data message
#define FIT_MESG_NUM_MFG_RANGE_MIN                                               ((FIT_MESG_NUM)0xFF00) // 0xFF00 - 0xFFFE reserved for manufacturer specific messages
#define FIT_MESG_NUM_MFG_RANGE_MAX                                               ((FIT_MESG_NUM)0xFFFE) // 0xFF00 - 0xFFFE reserved for manufacturer specific messages
#define FIT_MESG_NUM_COUNT                                                       122

typedef FIT_UINT8 FIT_CHECKSUM;
#define FIT_CHECKSUM_INVALID                                                     FIT_UINT8_INVALID
#define FIT_CHECKSUM_CLEAR                                                       ((FIT_CHECKSUM)0) // Allows clear of checksum for flash memory where can only write 1 to 0 without erasing sector.
#define FIT_CHECKSUM_OK                                                          ((FIT_CHECKSUM)1) // Set to mark checksum as valid if computes to invalid values 0 or 0xFF. Checksum can also be set to ok to save encoding computation time.
#define FIT_CHECKSUM_COUNT                                                       2

typedef FIT_UINT8Z FIT_FILE_FLAGS;
#define FIT_FILE_FLAGS_INVALID                                                   FIT_UINT8Z_INVALID
#define FIT_FILE_FLAGS_READ                                                      ((FIT_FILE_FLAGS)0x02)
#define FIT_FILE_FLAGS_WRITE                                                     ((FIT_FILE_FLAGS)0x04)
#define FIT_FILE_FLAGS_ERASE                                                     ((FIT_FILE_FLAGS)0x08)
#define FIT_FILE_FLAGS_COUNT                                                     3

typedef FIT_ENUM FIT_MESG_COUNT;
#define FIT_MESG_COUNT_INVALID                                                   FIT_ENUM_INVALID
#define FIT_MESG_COUNT_NUM_PER_FILE                                              ((FIT_MESG_COUNT)0)
#define FIT_MESG_COUNT_MAX_PER_FILE                                              ((FIT_MESG_COUNT)1)
#define FIT_MESG_COUNT_MAX_PER_FILE_TYPE                                         ((FIT_MESG_COUNT)2)
#define FIT_MESG_COUNT_COUNT                                                     3

typedef FIT_UINT32 FIT_DATE_TIME; // seconds since UTC 00:00 Dec 31 1989
#define FIT_DATE_TIME_INVALID                                                    FIT_UINT32_INVALID
#define FIT_DATE_TIME_MIN                                                        ((FIT_DATE_TIME)0x10000000) // if date_time is < 0x10000000 then it is system time (seconds from device power on)
#define FIT_DATE_TIME_COUNT                                                      1

typedef FIT_UINT32 FIT_LOCAL_DATE_TIME; // seconds since 00:00 Dec 31 1989 in local time zone
#define FIT_LOCAL_DATE_TIME_INVALID                                              FIT_UINT32_INVALID
#define FIT_LOCAL_DATE_TIME_MIN                                                  ((FIT_LOCAL_DATE_TIME)0x10000000) // if date_time is < 0x10000000 then it is system time (seconds from device power on)
#define FIT_LOCAL_DATE_TIME_COUNT                                                1

typedef FIT_UINT16 FIT_MESSAGE_INDEX;
#define FIT_MESSAGE_INDEX_INVALID                                                FIT_UINT16_INVALID
#define FIT_MESSAGE_INDEX_SELECTED                                               ((FIT_MESSAGE_INDEX)0x8000) // message is selected if set
#define FIT_MESSAGE_INDEX_RESERVED                                               ((FIT_MESSAGE_INDEX)0x7000) // reserved (default 0)
#define FIT_MESSAGE_INDEX_MASK                                                   ((FIT_MESSAGE_INDEX)0x0FFF) // index
#define FIT_MESSAGE_INDEX_COUNT                                                  3

typedef FIT_UINT8 FIT_DEVICE_INDEX;
#define FIT_DEVICE_INDEX_INVALID                                                 FIT_UINT8_INVALID
#define FIT_DEVICE_INDEX_CREATOR                                                 ((FIT_DEVICE_INDEX)0) // Creator of the file is always device index 0.
#define FIT_DEVICE_INDEX_COUNT                                                   1

typedef FIT_ENUM FIT_GENDER;
#define FIT_GENDER_INVALID                                                       FIT_ENUM_INVALID
#define FIT_GENDER_FEMALE                                                        ((FIT_GENDER)0)
#define FIT_GENDER_MALE                                                          ((FIT_GENDER)1)
#define FIT_GENDER_COUNT                                                         2

typedef FIT_ENUM FIT_LANGUAGE;
#define FIT_LANGUAGE_INVALID                                                     FIT_ENUM_INVALID
#define FIT_LANGUAGE_ENGLISH                                                     ((FIT_LANGUAGE)0)
#define FIT_LANGUAGE_FRENCH                                                      ((FIT_LANGUAGE)1)
#define FIT_LANGUAGE_ITALIAN                                                     ((FIT_LANGUAGE)2)
#define FIT_LANGUAGE_GERMAN                                                      ((FIT_LANGUAGE)3)
#define FIT_LANGUAGE_SPANISH                                                     ((FIT_LANGUAGE)4)
#define FIT_LANGUAGE_CROATIAN                                                    ((FIT_LANGUAGE)5)
#define FIT_LANGUAGE_CZECH                                                       ((FIT_LANGUAGE)6)
#define FIT_LANGUAGE_DANISH                                                      ((FIT_LANGUAGE)7)
#define FIT_LANGUAGE_DUTCH                                                       ((FIT_LANGUAGE)8)
#define FIT_LANGUAGE_FINNISH                                                     ((FIT_LANGUAGE)9)
#define FIT_LANGUAGE_GREEK                                                       ((FIT_LANGUAGE)10)
#define FIT_LANGUAGE_HUNGARIAN                                                   ((FIT_LANGUAGE)11)
#define FIT_LANGUAGE_NORWEGIAN                                                   ((FIT_LANGUAGE)12)
#define FIT_LANGUAGE_POLISH                                                      ((FIT_LANGUAGE)13)
#define FIT_LANGUAGE_PORTUGUESE                                                  ((FIT_LANGUAGE)14)
#define FIT_LANGUAGE_SLOVAKIAN                                                   ((FIT_LANGUAGE)15)
#define FIT_LANGUAGE_SLOVENIAN                                                   ((FIT_LANGUAGE)16)
#define FIT_LANGUAGE_SWEDISH                                                     ((FIT_LANGUAGE)17)
#define FIT_LANGUAGE_RUSSIAN                                                     ((FIT_LANGUAGE)18)
#define FIT_LANGUAGE_TURKISH                                                     ((FIT_LANGUAGE)19)
#define FIT_LANGUAGE_LATVIAN                                                     ((FIT_LANGUAGE)20)
#define FIT_LANGUAGE_UKRAINIAN                                                   ((FIT_LANGUAGE)21)
#define FIT_LANGUAGE_ARABIC                                                      ((FIT_LANGUAGE)22)
#define FIT_LANGUAGE_FARSI                                                       ((FIT_LANGUAGE)23)
#define FIT_LANGUAGE_BULGARIAN                                                   ((FIT_LANGUAGE)24)
#define FIT_LANGUAGE_ROMANIAN                                                    ((FIT_LANGUAGE)25)
#define FIT_LANGUAGE_CHINESE                                                     ((FIT_LANGUAGE)26)
#define FIT_LANGUAGE_JAPANESE                                                    ((FIT_LANGUAGE)27)
#define FIT_LANGUAGE_KOREAN                                                      ((FIT_LANGUAGE)28)
#define FIT_LANGUAGE_TAIWANESE                                                   ((FIT_LANGUAGE)29)
#define FIT_LANGUAGE_THAI                                                        ((FIT_LANGUAGE)30)
#define FIT_LANGUAGE_HEBREW                                                      ((FIT_LANGUAGE)31)
#define FIT_LANGUAGE_BRAZILIAN_PORTUGUESE                                        ((FIT_LANGUAGE)32)
#define FIT_LANGUAGE_INDONESIAN                                                  ((FIT_LANGUAGE)33)
#define FIT_LANGUAGE_MALAYSIAN                                                   ((FIT_LANGUAGE)34)
#define FIT_LANGUAGE_VIETNAMESE                                                  ((FIT_LANGUAGE)35)
#define FIT_LANGUAGE_BURMESE                                                     ((FIT_LANGUAGE)36)
#define FIT_LANGUAGE_MONGOLIAN                                                   ((FIT_LANGUAGE)37)
#define FIT_LANGUAGE_CUSTOM                                                      ((FIT_LANGUAGE)254)
#define FIT_LANGUAGE_COUNT                                                       39

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_0; // Bit field corresponding to language enum type (1 << language).
#define FIT_LANGUAGE_BITS_0_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_0_ENGLISH                                              ((FIT_LANGUAGE_BITS_0)0x01)
#define FIT_LANGUAGE_BITS_0_FRENCH                                               ((FIT_LANGUAGE_BITS_0)0x02)
#define FIT_LANGUAGE_BITS_0_ITALIAN                                              ((FIT_LANGUAGE_BITS_0)0x04)
#define FIT_LANGUAGE_BITS_0_GERMAN                                               ((FIT_LANGUAGE_BITS_0)0x08)
#define FIT_LANGUAGE_BITS_0_SPANISH                                              ((FIT_LANGUAGE_BITS_0)0x10)
#define FIT_LANGUAGE_BITS_0_CROATIAN                                             ((FIT_LANGUAGE_BITS_0)0x20)
#define FIT_LANGUAGE_BITS_0_CZECH                                                ((FIT_LANGUAGE_BITS_0)0x40)
#define FIT_LANGUAGE_BITS_0_DANISH                                               ((FIT_LANGUAGE_BITS_0)0x80)
#define FIT_LANGUAGE_BITS_0_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_1;
#define FIT_LANGUAGE_BITS_1_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_1_DUTCH                                                ((FIT_LANGUAGE_BITS_1)0x01)
#define FIT_LANGUAGE_BITS_1_FINNISH                                              ((FIT_LANGUAGE_BITS_1)0x02)
#define FIT_LANGUAGE_BITS_1_GREEK                                                ((FIT_LANGUAGE_BITS_1)0x04)
#define FIT_LANGUAGE_BITS_1_HUNGARIAN                                            ((FIT_LANGUAGE_BITS_1)0x08)
#define FIT_LANGUAGE_BITS_1_NORWEGIAN                                            ((FIT_LANGUAGE_BITS_1)0x10)
#define FIT_LANGUAGE_BITS_1_POLISH                                               ((FIT_LANGUAGE_BITS_1)0x20)
#define FIT_LANGUAGE_BITS_1_PORTUGUESE                                           ((FIT_LANGUAGE_BITS_1)0x40)
#define FIT_LANGUAGE_BITS_1_SLOVAKIAN                                            ((FIT_LANGUAGE_BITS_1)0x80)
#define FIT_LANGUAGE_BITS_1_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_2;
#define FIT_LANGUAGE_BITS_2_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_2_SLOVENIAN                                            ((FIT_LANGUAGE_BITS_2)0x01)
#define FIT_LANGUAGE_BITS_2_SWEDISH                                              ((FIT_LANGUAGE_BITS_2)0x02)
#define FIT_LANGUAGE_BITS_2_RUSSIAN                                              ((FIT_LANGUAGE_BITS_2)0x04)
#define FIT_LANGUAGE_BITS_2_TURKISH                                              ((FIT_LANGUAGE_BITS_2)0x08)
#define FIT_LANGUAGE_BITS_2_LATVIAN                                              ((FIT_LANGUAGE_BITS_2)0x10)
#define FIT_LANGUAGE_BITS_2_UKRAINIAN                                            ((FIT_LANGUAGE_BITS_2)0x20)
#define FIT_LANGUAGE_BITS_2_ARABIC                                               ((FIT_LANGUAGE_BITS_2)0x40)
#define FIT_LANGUAGE_BITS_2_FARSI                                                ((FIT_LANGUAGE_BITS_2)0x80)
#define FIT_LANGUAGE_BITS_2_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_3;
#define FIT_LANGUAGE_BITS_3_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_3_BULGARIAN                                            ((FIT_LANGUAGE_BITS_3)0x01)
#define FIT_LANGUAGE_BITS_3_ROMANIAN                                             ((FIT_LANGUAGE_BITS_3)0x02)
#define FIT_LANGUAGE_BITS_3_CHINESE                                              ((FIT_LANGUAGE_BITS_3)0x04)
#define FIT_LANGUAGE_BITS_3_JAPANESE                                             ((FIT_LANGUAGE_BITS_3)0x08)
#define FIT_LANGUAGE_BITS_3_KOREAN                                               ((FIT_LANGUAGE_BITS_3)0x10)
#define FIT_LANGUAGE_BITS_3_TAIWANESE                                            ((FIT_LANGUAGE_BITS_3)0x20)
#define FIT_LANGUAGE_BITS_3_THAI                                                 ((FIT_LANGUAGE_BITS_3)0x40)
#define FIT_LANGUAGE_BITS_3_HEBREW                                               ((FIT_LANGUAGE_BITS_3)0x80)
#define FIT_LANGUAGE_BITS_3_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_4;
#define FIT_LANGUAGE_BITS_4_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_4_BRAZILIAN_PORTUGUESE                                 ((FIT_LANGUAGE_BITS_4)0x01)
#define FIT_LANGUAGE_BITS_4_INDONESIAN                                           ((FIT_LANGUAGE_BITS_4)0x02)
#define FIT_LANGUAGE_BITS_4_MALAYSIAN                                            ((FIT_LANGUAGE_BITS_4)0x04)
#define FIT_LANGUAGE_BITS_4_VIETNAMESE                                           ((FIT_LANGUAGE_BITS_4)0x08)
#define FIT_LANGUAGE_BITS_4_BURMESE                                              ((FIT_LANGUAGE_BITS_4)0x10)
#define FIT_LANGUAGE_BITS_4_MONGOLIAN                                            ((FIT_LANGUAGE_BITS_4)0x20)
#define FIT_LANGUAGE_BITS_4_COUNT                                                6

typedef FIT_ENUM FIT_TIME_ZONE;
#define FIT_TIME_ZONE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_TIME_ZONE_ALMATY                                                     ((FIT_TIME_ZONE)0)
#define FIT_TIME_ZONE_BANGKOK                                                    ((FIT_TIME_ZONE)1)
#define FIT_TIME_ZONE_BOMBAY                                                     ((FIT_TIME_ZONE)2)
#define FIT_TIME_ZONE_BRASILIA                                                   ((FIT_TIME_ZONE)3)
#define FIT_TIME_ZONE_CAIRO                                                      ((FIT_TIME_ZONE)4)
#define FIT_TIME_ZONE_CAPE_VERDE_IS                                              ((FIT_TIME_ZONE)5)
#define FIT_TIME_ZONE_DARWIN                                                     ((FIT_TIME_ZONE)6)
#define FIT_TIME_ZONE_ENIWETOK                                                   ((FIT_TIME_ZONE)7)
#define FIT_TIME_ZONE_FIJI                                                       ((FIT_TIME_ZONE)8)
#define FIT_TIME_ZONE_HONG_KONG                                                  ((FIT_TIME_ZONE)9)
#define FIT_TIME_ZONE_ISLAMABAD                                                  ((FIT_TIME_ZONE)10)
#define FIT_TIME_ZONE_KABUL                                                      ((FIT_TIME_ZONE)11)
#define FIT_TIME_ZONE_MAGADAN                                                    ((FIT_TIME_ZONE)12)
#define FIT_TIME_ZONE_MID_ATLANTIC                                               ((FIT_TIME_ZONE)13)
#define FIT_TIME_ZONE_MOSCOW                                                     ((FIT_TIME_ZONE)14)
#define FIT_TIME_ZONE_MUSCAT                                                     ((FIT_TIME_ZONE)15)
#define FIT_TIME_ZONE_NEWFOUNDLAND                                               ((FIT_TIME_ZONE)16)
#define FIT_TIME_ZONE_SAMOA                                                      ((FIT_TIME_ZONE)17)
#define FIT_TIME_ZONE_SYDNEY                                                     ((FIT_TIME_ZONE)18)
#define FIT_TIME_ZONE_TEHRAN                                                     ((FIT_TIME_ZONE)19)
#define FIT_TIME_ZONE_TOKYO                                                      ((FIT_TIME_ZONE)20)
#define FIT_TIME_ZONE_US_ALASKA                                                  ((FIT_TIME_ZONE)21)
#define FIT_TIME_ZONE_US_ATLANTIC                                                ((FIT_TIME_ZONE)22)
#define FIT_TIME_ZONE_US_CENTRAL                                                 ((FIT_TIME_ZONE)23)
#define FIT_TIME_ZONE_US_EASTERN                                                 ((FIT_TIME_ZONE)24)
#define FIT_TIME_ZONE_US_HAWAII                                                  ((FIT_TIME_ZONE)25)
#define FIT_TIME_ZONE_US_MOUNTAIN                                                ((FIT_TIME_ZONE)26)
#define FIT_TIME_ZONE_US_PACIFIC                                                 ((FIT_TIME_ZONE)27)
#define FIT_TIME_ZONE_OTHER                                                      ((FIT_TIME_ZONE)28)
#define FIT_TIME_ZONE_AUCKLAND                                                   ((FIT_TIME_ZONE)29)
#define FIT_TIME_ZONE_KATHMANDU                                                  ((FIT_TIME_ZONE)30)
#define FIT_TIME_ZONE_EUROPE_WESTERN_WET                                         ((FIT_TIME_ZONE)31)
#define FIT_TIME_ZONE_EUROPE_CENTRAL_CET                                         ((FIT_TIME_ZONE)32)
#define FIT_TIME_ZONE_EUROPE_EASTERN_EET                                         ((FIT_TIME_ZONE)33)
#define FIT_TIME_ZONE_JAKARTA                                                    ((FIT_TIME_ZONE)34)
#define FIT_TIME_ZONE_PERTH                                                      ((FIT_TIME_ZONE)35)
#define FIT_TIME_ZONE_ADELAIDE                                                   ((FIT_TIME_ZONE)36)
#define FIT_TIME_ZONE_BRISBANE                                                   ((FIT_TIME_ZONE)37)
#define FIT_TIME_ZONE_TASMANIA                                                   ((FIT_TIME_ZONE)38)
#define FIT_TIME_ZONE_ICELAND                                                    ((FIT_TIME_ZONE)39)
#define FIT_TIME_ZONE_AMSTERDAM                                                  ((FIT_TIME_ZONE)40)
#define FIT_TIME_ZONE_ATHENS                                                     ((FIT_TIME_ZONE)41)
#define FIT_TIME_ZONE_BARCELONA                                                  ((FIT_TIME_ZONE)42)
#define FIT_TIME_ZONE_BERLIN                                                     ((FIT_TIME_ZONE)43)
#define FIT_TIME_ZONE_BRUSSELS                                                   ((FIT_TIME_ZONE)44)
#define FIT_TIME_ZONE_BUDAPEST                                                   ((FIT_TIME_ZONE)45)
#define FIT_TIME_ZONE_COPENHAGEN                                                 ((FIT_TIME_ZONE)46)
#define FIT_TIME_ZONE_DUBLIN                                                     ((FIT_TIME_ZONE)47)
#define FIT_TIME_ZONE_HELSINKI                                                   ((FIT_TIME_ZONE)48)
#define FIT_TIME_ZONE_LISBON                                                     ((FIT_TIME_ZONE)49)
#define FIT_TIME_ZONE_LONDON                                                     ((FIT_TIME_ZONE)50)
#define FIT_TIME_ZONE_MADRID                                                     ((FIT_TIME_ZONE)51)
#define FIT_TIME_ZONE_MUNICH                                                     ((FIT_TIME_ZONE)52)
#define FIT_TIME_ZONE_OSLO                                                       ((FIT_TIME_ZONE)53)
#define FIT_TIME_ZONE_PARIS                                                      ((FIT_TIME_ZONE)54)
#define FIT_TIME_ZONE_PRAGUE                                                     ((FIT_TIME_ZONE)55)
#define FIT_TIME_ZONE_REYKJAVIK                                                  ((FIT_TIME_ZONE)56)
#define FIT_TIME_ZONE_ROME                                                       ((FIT_TIME_ZONE)57)
#define FIT_TIME_ZONE_STOCKHOLM                                                  ((FIT_TIME_ZONE)58)
#define FIT_TIME_ZONE_VIENNA                                                     ((FIT_TIME_ZONE)59)
#define FIT_TIME_ZONE_WARSAW                                                     ((FIT_TIME_ZONE)60)
#define FIT_TIME_ZONE_ZURICH                                                     ((FIT_TIME_ZONE)61)
#define FIT_TIME_ZONE_QUEBEC                                                     ((FIT_TIME_ZONE)62)
#define FIT_TIME_ZONE_ONTARIO                                                    ((FIT_TIME_ZONE)63)
#define FIT_TIME_ZONE_MANITOBA                                                   ((FIT_TIME_ZONE)64)
#define FIT_TIME_ZONE_SASKATCHEWAN                                               ((FIT_TIME_ZONE)65)
#define FIT_TIME_ZONE_ALBERTA                                                    ((FIT_TIME_ZONE)66)
#define FIT_TIME_ZONE_BRITISH_COLUMBIA                                           ((FIT_TIME_ZONE)67)
#define FIT_TIME_ZONE_BOISE                                                      ((FIT_TIME_ZONE)68)
#define FIT_TIME_ZONE_BOSTON                                                     ((FIT_TIME_ZONE)69)
#define FIT_TIME_ZONE_CHICAGO                                                    ((FIT_TIME_ZONE)70)
#define FIT_TIME_ZONE_DALLAS                                                     ((FIT_TIME_ZONE)71)
#define FIT_TIME_ZONE_DENVER                                                     ((FIT_TIME_ZONE)72)
#define FIT_TIME_ZONE_KANSAS_CITY                                                ((FIT_TIME_ZONE)73)
#define FIT_TIME_ZONE_LAS_VEGAS                                                  ((FIT_TIME_ZONE)74)
#define FIT_TIME_ZONE_LOS_ANGELES                                                ((FIT_TIME_ZONE)75)
#define FIT_TIME_ZONE_MIAMI                                                      ((FIT_TIME_ZONE)76)
#define FIT_TIME_ZONE_MINNEAPOLIS                                                ((FIT_TIME_ZONE)77)
#define FIT_TIME_ZONE_NEW_YORK                                                   ((FIT_TIME_ZONE)78)
#define FIT_TIME_ZONE_NEW_ORLEANS                                                ((FIT_TIME_ZONE)79)
#define FIT_TIME_ZONE_PHOENIX                                                    ((FIT_TIME_ZONE)80)
#define FIT_TIME_ZONE_SANTA_FE                                                   ((FIT_TIME_ZONE)81)
#define FIT_TIME_ZONE_SEATTLE                                                    ((FIT_TIME_ZONE)82)
#define FIT_TIME_ZONE_WASHINGTON_DC                                              ((FIT_TIME_ZONE)83)
#define FIT_TIME_ZONE_US_ARIZONA                                                 ((FIT_TIME_ZONE)84)
#define FIT_TIME_ZONE_CHITA                                                      ((FIT_TIME_ZONE)85)
#define FIT_TIME_ZONE_EKATERINBURG                                               ((FIT_TIME_ZONE)86)
#define FIT_TIME_ZONE_IRKUTSK                                                    ((FIT_TIME_ZONE)87)
#define FIT_TIME_ZONE_KALININGRAD                                                ((FIT_TIME_ZONE)88)
#define FIT_TIME_ZONE_KRASNOYARSK                                                ((FIT_TIME_ZONE)89)
#define FIT_TIME_ZONE_NOVOSIBIRSK                                                ((FIT_TIME_ZONE)90)
#define FIT_TIME_ZONE_PETROPAVLOVSK_KAMCHATSKIY                                  ((FIT_TIME_ZONE)91)
#define FIT_TIME_ZONE_SAMARA                                                     ((FIT_TIME_ZONE)92)
#define FIT_TIME_ZONE_VLADIVOSTOK                                                ((FIT_TIME_ZONE)93)
#define FIT_TIME_ZONE_MEXICO_CENTRAL                                             ((FIT_TIME_ZONE)94)
#define FIT_TIME_ZONE_MEXICO_MOUNTAIN                                            ((FIT_TIME_ZONE)95)
#define FIT_TIME_ZONE_MEXICO_PACIFIC                                             ((FIT_TIME_ZONE)96)
#define FIT_TIME_ZONE_CAPE_TOWN                                                  ((FIT_TIME_ZONE)97)
#define FIT_TIME_ZONE_WINKHOEK                                                   ((FIT_TIME_ZONE)98)
#define FIT_TIME_ZONE_LAGOS                                                      ((FIT_TIME_ZONE)99)
#define FIT_TIME_ZONE_RIYAHD                                                     ((FIT_TIME_ZONE)100)
#define FIT_TIME_ZONE_VENEZUELA                                                  ((FIT_TIME_ZONE)101)
#define FIT_TIME_ZONE_AUSTRALIA_LH                                               ((FIT_TIME_ZONE)102)
#define FIT_TIME_ZONE_SANTIAGO                                                   ((FIT_TIME_ZONE)103)
#define FIT_TIME_ZONE_MANUAL                                                     ((FIT_TIME_ZONE)253)
#define FIT_TIME_ZONE_AUTOMATIC                                                  ((FIT_TIME_ZONE)254)
#define FIT_TIME_ZONE_COUNT                                                      106

typedef FIT_ENUM FIT_DISPLAY_MEASURE;
#define FIT_DISPLAY_MEASURE_INVALID                                              FIT_ENUM_INVALID
#define FIT_DISPLAY_MEASURE_METRIC                                               ((FIT_DISPLAY_MEASURE)0)
#define FIT_DISPLAY_MEASURE_STATUTE                                              ((FIT_DISPLAY_MEASURE)1)
#define FIT_DISPLAY_MEASURE_NAUTICAL                                             ((FIT_DISPLAY_MEASURE)2)
#define FIT_DISPLAY_MEASURE_COUNT                                                3

typedef FIT_ENUM FIT_DISPLAY_HEART;
#define FIT_DISPLAY_HEART_INVALID                                                FIT_ENUM_INVALID
#define FIT_DISPLAY_HEART_BPM                                                    ((FIT_DISPLAY_HEART)0)
#define FIT_DISPLAY_HEART_MAX                                                    ((FIT_DISPLAY_HEART)1)
#define FIT_DISPLAY_HEART_RESERVE                                                ((FIT_DISPLAY_HEART)2)
#define FIT_DISPLAY_HEART_COUNT                                                  3

typedef FIT_ENUM FIT_DISPLAY_POWER;
#define FIT_DISPLAY_POWER_INVALID                                                FIT_ENUM_INVALID
#define FIT_DISPLAY_POWER_WATTS                                                  ((FIT_DISPLAY_POWER)0)
#define FIT_DISPLAY_POWER_PERCENT_FTP                                            ((FIT_DISPLAY_POWER)1)
#define FIT_DISPLAY_POWER_COUNT                                                  2

typedef FIT_ENUM FIT_DISPLAY_POSITION;
#define FIT_DISPLAY_POSITION_INVALID                                             FIT_ENUM_INVALID
#define FIT_DISPLAY_POSITION_DEGREE                                              ((FIT_DISPLAY_POSITION)0) // dd.dddddd
#define FIT_DISPLAY_POSITION_DEGREE_MINUTE                                       ((FIT_DISPLAY_POSITION)1) // dddmm.mmm
#define FIT_DISPLAY_POSITION_DEGREE_MINUTE_SECOND                                ((FIT_DISPLAY_POSITION)2) // dddmmss
#define FIT_DISPLAY_POSITION_AUSTRIAN_GRID                                       ((FIT_DISPLAY_POSITION)3) // Austrian Grid (BMN)
#define FIT_DISPLAY_POSITION_BRITISH_GRID                                        ((FIT_DISPLAY_POSITION)4) // British National Grid
#define FIT_DISPLAY_POSITION_DUTCH_GRID                                          ((FIT_DISPLAY_POSITION)5) // Dutch grid system
#define FIT_DISPLAY_POSITION_HUNGARIAN_GRID                                      ((FIT_DISPLAY_POSITION)6) // Hungarian grid system
#define FIT_DISPLAY_POSITION_FINNISH_GRID                                        ((FIT_DISPLAY_POSITION)7) // Finnish grid system Zone3 KKJ27
#define FIT_DISPLAY_POSITION_GERMAN_GRID                                         ((FIT_DISPLAY_POSITION)8) // Gausss Krueger (German)
#define FIT_DISPLAY_POSITION_ICELANDIC_GRID                                      ((FIT_DISPLAY_POSITION)9) // Icelandic Grid
#define FIT_DISPLAY_POSITION_INDONESIAN_EQUATORIAL                               ((FIT_DISPLAY_POSITION)10) // Indonesian Equatorial LCO
#define FIT_DISPLAY_POSITION_INDONESIAN_IRIAN                                    ((FIT_DISPLAY_POSITION)11) // Indonesian Irian LCO
#define FIT_DISPLAY_POSITION_INDONESIAN_SOUTHERN                                 ((FIT_DISPLAY_POSITION)12) // Indonesian Southern LCO
#define FIT_DISPLAY_POSITION_INDIA_ZONE_0                                        ((FIT_DISPLAY_POSITION)13) // India zone 0
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IA                                       ((FIT_DISPLAY_POSITION)14) // India zone IA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IB                                       ((FIT_DISPLAY_POSITION)15) // India zone IB
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIA                                      ((FIT_DISPLAY_POSITION)16) // India zone IIA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIB                                      ((FIT_DISPLAY_POSITION)17) // India zone IIB
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIIA                                     ((FIT_DISPLAY_POSITION)18) // India zone IIIA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIIB                                     ((FIT_DISPLAY_POSITION)19) // India zone IIIB
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IVA                                      ((FIT_DISPLAY_POSITION)20) // India zone IVA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IVB                                      ((FIT_DISPLAY_POSITION)21) // India zone IVB
#define FIT_DISPLAY_POSITION_IRISH_TRANSVERSE                                    ((FIT_DISPLAY_POSITION)22) // Irish Transverse Mercator
#define FIT_DISPLAY_POSITION_IRISH_GRID                                          ((FIT_DISPLAY_POSITION)23) // Irish Grid
#define FIT_DISPLAY_POSITION_LORAN                                               ((FIT_DISPLAY_POSITION)24) // Loran TD
#define FIT_DISPLAY_POSITION_MAIDENHEAD_GRID                                     ((FIT_DISPLAY_POSITION)25) // Maidenhead grid system
#define FIT_DISPLAY_POSITION_MGRS_GRID                                           ((FIT_DISPLAY_POSITION)26) // MGRS grid system
#define FIT_DISPLAY_POSITION_NEW_ZEALAND_GRID                                    ((FIT_DISPLAY_POSITION)27) // New Zealand grid system
#define FIT_DISPLAY_POSITION_NEW_ZEALAND_TRANSVERSE                              ((FIT_DISPLAY_POSITION)28) // New Zealand Transverse Mercator
#define FIT_DISPLAY_POSITION_QATAR_GRID                                          ((FIT_DISPLAY_POSITION)29) // Qatar National Grid
#define FIT_DISPLAY_POSITION_MODIFIED_SWEDISH_GRID                               ((FIT_DISPLAY_POSITION)30) // Modified RT-90 (Sweden)
#define FIT_DISPLAY_POSITION_SWEDISH_GRID                                        ((FIT_DISPLAY_POSITION)31) // RT-90 (Sweden)
#define FIT_DISPLAY_POSITION_SOUTH_AFRICAN_GRID                                  ((FIT_DISPLAY_POSITION)32) // South African Grid
#define FIT_DISPLAY_POSITION_SWISS_GRID                                          ((FIT_DISPLAY_POSITION)33) // Swiss CH-1903 grid
#define FIT_DISPLAY_POSITION_TAIWAN_GRID                                         ((FIT_DISPLAY_POSITION)34) // Taiwan Grid
#define FIT_DISPLAY_POSITION_UNITED_STATES_GRID                                  ((FIT_DISPLAY_POSITION)35) // United States National Grid
#define FIT_DISPLAY_POSITION_UTM_UPS_GRID                                        ((FIT_DISPLAY_POSITION)36) // UTM/UPS grid system
#define FIT_DISPLAY_POSITION_WEST_MALAYAN                                        ((FIT_DISPLAY_POSITION)37) // West Malayan RSO
#define FIT_DISPLAY_POSITION_BORNEO_RSO                                          ((FIT_DISPLAY_POSITION)38) // Borneo RSO
#define FIT_DISPLAY_POSITION_ESTONIAN_GRID                                       ((FIT_DISPLAY_POSITION)39) // Estonian grid system
#define FIT_DISPLAY_POSITION_LATVIAN_GRID                                        ((FIT_DISPLAY_POSITION)40) // Latvian Transverse Mercator
#define FIT_DISPLAY_POSITION_SWEDISH_REF_99_GRID                                 ((FIT_DISPLAY_POSITION)41) // Reference Grid 99 TM (Swedish)
#define FIT_DISPLAY_POSITION_COUNT                                               42

typedef FIT_ENUM FIT_SWITCH;
#define FIT_SWITCH_INVALID                                                       FIT_ENUM_INVALID
#define FIT_SWITCH_OFF                                                           ((FIT_SWITCH)0)
#define FIT_SWITCH_ON                                                            ((FIT_SWITCH)1)
#define FIT_SWITCH_AUTO                                                          ((FIT_SWITCH)2)
#define FIT_SWITCH_COUNT                                                         3

typedef FIT_ENUM FIT_SPORT;
#define FIT_SPORT_INVALID                                                        FIT_ENUM_INVALID
#define FIT_SPORT_GENERIC                                                        ((FIT_SPORT)0)
#define FIT_SPORT_RUNNING                                                        ((FIT_SPORT)1)
#define FIT_SPORT_CYCLING                                                        ((FIT_SPORT)2)
#define FIT_SPORT_TRANSITION                                                     ((FIT_SPORT)3) // Mulitsport transition
#define FIT_SPORT_FITNESS_EQUIPMENT                                              ((FIT_SPORT)4)
#define FIT_SPORT_SWIMMING                                                       ((FIT_SPORT)5)
#define FIT_SPORT_BASKETBALL                                                     ((FIT_SPORT)6)
#define FIT_SPORT_SOCCER                                                         ((FIT_SPORT)7)
#define FIT_SPORT_TENNIS                                                         ((FIT_SPORT)8)
#define FIT_SPORT_AMERICAN_FOOTBALL                                              ((FIT_SPORT)9)
#define FIT_SPORT_TRAINING                                                       ((FIT_SPORT)10)
#define FIT_SPORT_WALKING                                                        ((FIT_SPORT)11)
#define FIT_SPORT_CROSS_COUNTRY_SKIING                                           ((FIT_SPORT)12)
#define FIT_SPORT_ALPINE_SKIING                                                  ((FIT_SPORT)13)
#define FIT_SPORT_SNOWBOARDING                                                   ((FIT_SPORT)14)
#define FIT_SPORT_ROWING                                                         ((FIT_SPORT)15)
#define FIT_SPORT_MOUNTAINEERING                                                 ((FIT_SPORT)16)
#define FIT_SPORT_HIKING                                                         ((FIT_SPORT)17)
#define FIT_SPORT_MULTISPORT                                                     ((FIT_SPORT)18)
#define FIT_SPORT_PADDLING                                                       ((FIT_SPORT)19)
#define FIT_SPORT_FLYING                                                         ((FIT_SPORT)20)
#define FIT_SPORT_E_BIKING                                                       ((FIT_SPORT)21)
#define FIT_SPORT_MOTORCYCLING                                                   ((FIT_SPORT)22)
#define FIT_SPORT_BOATING                                                        ((FIT_SPORT)23)
#define FIT_SPORT_DRIVING                                                        ((FIT_SPORT)24)
#define FIT_SPORT_GOLF                                                           ((FIT_SPORT)25)
#define FIT_SPORT_HANG_GLIDING                                                   ((FIT_SPORT)26)
#define FIT_SPORT_HORSEBACK_RIDING                                               ((FIT_SPORT)27)
#define FIT_SPORT_HUNTING                                                        ((FIT_SPORT)28)
#define FIT_SPORT_FISHING                                                        ((FIT_SPORT)29)
#define FIT_SPORT_INLINE_SKATING                                                 ((FIT_SPORT)30)
#define FIT_SPORT_ROCK_CLIMBING                                                  ((FIT_SPORT)31)
#define FIT_SPORT_SAILING                                                        ((FIT_SPORT)32)
#define FIT_SPORT_ICE_SKATING                                                    ((FIT_SPORT)33)
#define FIT_SPORT_SKY_DIVING                                                     ((FIT_SPORT)34)
#define FIT_SPORT_SNOWSHOEING                                                    ((FIT_SPORT)35)
#define FIT_SPORT_SNOWMOBILING                                                   ((FIT_SPORT)36)
#define FIT_SPORT_STAND_UP_PADDLEBOARDING                                        ((FIT_SPORT)37)
#define FIT_SPORT_SURFING                                                        ((FIT_SPORT)38)
#define FIT_SPORT_WAKEBOARDING                                                   ((FIT_SPORT)39)
#define FIT_SPORT_WATER_SKIING                                                   ((FIT_SPORT)40)
#define FIT_SPORT_KAYAKING                                                       ((FIT_SPORT)41)
#define FIT_SPORT_RAFTING                                                        ((FIT_SPORT)42)
#define FIT_SPORT_WINDSURFING                                                    ((FIT_SPORT)43)
#define FIT_SPORT_KITESURFING                                                    ((FIT_SPORT)44)
#define FIT_SPORT_TACTICAL                                                       ((FIT_SPORT)45)
#define FIT_SPORT_JUMPMASTER                                                     ((FIT_SPORT)46)
#define FIT_SPORT_BOXING                                                         ((FIT_SPORT)47)
#define FIT_SPORT_FLOOR_CLIMBING                                                 ((FIT_SPORT)48)
#define FIT_SPORT_BASEBALL                                                       ((FIT_SPORT)49)
#define FIT_SPORT_DIVING                                                         ((FIT_SPORT)53)
#define FIT_SPORT_HIIT                                                           ((FIT_SPORT)62)
#define FIT_SPORT_RACKET                                                         ((FIT_SPORT)64)
#define FIT_SPORT_WHEELCHAIR_PUSH_WALK                                           ((FIT_SPORT)65)
#define FIT_SPORT_WHEELCHAIR_PUSH_RUN                                            ((FIT_SPORT)66)
#define FIT_SPORT_MEDITATION                                                     ((FIT_SPORT)67)
#define FIT_SPORT_DISC_GOLF                                                      ((FIT_SPORT)69)
#define FIT_SPORT_CRICKET                                                        ((FIT_SPORT)71)
#define FIT_SPORT_RUGBY                                                          ((FIT_SPORT)72)
#define FIT_SPORT_HOCKEY                                                         ((FIT_SPORT)73)
#define FIT_SPORT_LACROSSE                                                       ((FIT_SPORT)74)
#define FIT_SPORT_VOLLEYBALL                                                     ((FIT_SPORT)75)
#define FIT_SPORT_WATER_TUBING                                                   ((FIT_SPORT)76)
#define FIT_SPORT_WAKESURFING                                                    ((FIT_SPORT)77)
#define FIT_SPORT_MIXED_MARTIAL_ARTS                                             ((FIT_SPORT)80)
#define FIT_SPORT_SNORKELING                                                     ((FIT_SPORT)82)
#define FIT_SPORT_DANCE                                                          ((FIT_SPORT)83)
#define FIT_SPORT_JUMP_ROPE                                                      ((FIT_SPORT)84)
#define FIT_SPORT_ALL                                                            ((FIT_SPORT)254) // All is for goals only to include all sports.
#define FIT_SPORT_COUNT                                                          69

typedef FIT_UINT8Z FIT_SPORT_BITS_0; // Bit field corresponding to sport enum type (1 << sport).
#define FIT_SPORT_BITS_0_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_0_GENERIC                                                 ((FIT_SPORT_BITS_0)0x01)
#define FIT_SPORT_BITS_0_RUNNING                                                 ((FIT_SPORT_BITS_0)0x02)
#define FIT_SPORT_BITS_0_CYCLING                                                 ((FIT_SPORT_BITS_0)0x04)
#define FIT_SPORT_BITS_0_TRANSITION                                              ((FIT_SPORT_BITS_0)0x08) // Mulitsport transition
#define FIT_SPORT_BITS_0_FITNESS_EQUIPMENT                                       ((FIT_SPORT_BITS_0)0x10)
#define FIT_SPORT_BITS_0_SWIMMING                                                ((FIT_SPORT_BITS_0)0x20)
#define FIT_SPORT_BITS_0_BASKETBALL                                              ((FIT_SPORT_BITS_0)0x40)
#define FIT_SPORT_BITS_0_SOCCER                                                  ((FIT_SPORT_BITS_0)0x80)
#define FIT_SPORT_BITS_0_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_1; // Bit field corresponding to sport enum type (1 << (sport-8)).
#define FIT_SPORT_BITS_1_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_1_TENNIS                                                  ((FIT_SPORT_BITS_1)0x01)
#define FIT_SPORT_BITS_1_AMERICAN_FOOTBALL                                       ((FIT_SPORT_BITS_1)0x02)
#define FIT_SPORT_BITS_1_TRAINING                                                ((FIT_SPORT_BITS_1)0x04)
#define FIT_SPORT_BITS_1_WALKING                                                 ((FIT_SPORT_BITS_1)0x08)
#define FIT_SPORT_BITS_1_CROSS_COUNTRY_SKIING                                    ((FIT_SPORT_BITS_1)0x10)
#define FIT_SPORT_BITS_1_ALPINE_SKIING                                           ((FIT_SPORT_BITS_1)0x20)
#define FIT_SPORT_BITS_1_SNOWBOARDING                                            ((FIT_SPORT_BITS_1)0x40)
#define FIT_SPORT_BITS_1_ROWING                                                  ((FIT_SPORT_BITS_1)0x80)
#define FIT_SPORT_BITS_1_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_2; // Bit field corresponding to sport enum type (1 << (sport-16)).
#define FIT_SPORT_BITS_2_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_2_MOUNTAINEERING                                          ((FIT_SPORT_BITS_2)0x01)
#define FIT_SPORT_BITS_2_HIKING                                                  ((FIT_SPORT_BITS_2)0x02)
#define FIT_SPORT_BITS_2_MULTISPORT                                              ((FIT_SPORT_BITS_2)0x04)
#define FIT_SPORT_BITS_2_PADDLING                                                ((FIT_SPORT_BITS_2)0x08)
#define FIT_SPORT_BITS_2_FLYING                                                  ((FIT_SPORT_BITS_2)0x10)
#define FIT_SPORT_BITS_2_E_BIKING                                                ((FIT_SPORT_BITS_2)0x20)
#define FIT_SPORT_BITS_2_MOTORCYCLING                                            ((FIT_SPORT_BITS_2)0x40)
#define FIT_SPORT_BITS_2_BOATING                                                 ((FIT_SPORT_BITS_2)0x80)
#define FIT_SPORT_BITS_2_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_3; // Bit field corresponding to sport enum type (1 << (sport-24)).
#define FIT_SPORT_BITS_3_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_3_DRIVING                                                 ((FIT_SPORT_BITS_3)0x01)
#define FIT_SPORT_BITS_3_GOLF                                                    ((FIT_SPORT_BITS_3)0x02)
#define FIT_SPORT_BITS_3_HANG_GLIDING                                            ((FIT_SPORT_BITS_3)0x04)
#define FIT_SPORT_BITS_3_HORSEBACK_RIDING                                        ((FIT_SPORT_BITS_3)0x08)
#define FIT_SPORT_BITS_3_HUNTING                                                 ((FIT_SPORT_BITS_3)0x10)
#define FIT_SPORT_BITS_3_FISHING                                                 ((FIT_SPORT_BITS_3)0x20)
#define FIT_SPORT_BITS_3_INLINE_SKATING                                          ((FIT_SPORT_BITS_3)0x40)
#define FIT_SPORT_BITS_3_ROCK_CLIMBING                                           ((FIT_SPORT_BITS_3)0x80)
#define FIT_SPORT_BITS_3_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_4; // Bit field corresponding to sport enum type (1 << (sport-32)).
#define FIT_SPORT_BITS_4_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_4_SAILING                                                 ((FIT_SPORT_BITS_4)0x01)
#define FIT_SPORT_BITS_4_ICE_SKATING                                             ((FIT_SPORT_BITS_4)0x02)
#define FIT_SPORT_BITS_4_SKY_DIVING                                              ((FIT_SPORT_BITS_4)0x04)
#define FIT_SPORT_BITS_4_SNOWSHOEING                                             ((FIT_SPORT_BITS_4)0x08)
#define FIT_SPORT_BITS_4_SNOWMOBILING                                            ((FIT_SPORT_BITS_4)0x10)
#define FIT_SPORT_BITS_4_STAND_UP_PADDLEBOARDING                                 ((FIT_SPORT_BITS_4)0x20)
#define FIT_SPORT_BITS_4_SURFING                                                 ((FIT_SPORT_BITS_4)0x40)
#define FIT_SPORT_BITS_4_WAKEBOARDING                                            ((FIT_SPORT_BITS_4)0x80)
#define FIT_SPORT_BITS_4_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_5; // Bit field corresponding to sport enum type (1 << (sport-40)).
#define FIT_SPORT_BITS_5_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_5_WATER_SKIING                                            ((FIT_SPORT_BITS_5)0x01)
#define FIT_SPORT_BITS_5_KAYAKING                                                ((FIT_SPORT_BITS_5)0x02)
#define FIT_SPORT_BITS_5_RAFTING                                                 ((FIT_SPORT_BITS_5)0x04)
#define FIT_SPORT_BITS_5_WINDSURFING                                             ((FIT_SPORT_BITS_5)0x08)
#define FIT_SPORT_BITS_5_KITESURFING                                             ((FIT_SPORT_BITS_5)0x10)
#define FIT_SPORT_BITS_5_TACTICAL                                                ((FIT_SPORT_BITS_5)0x20)
#define FIT_SPORT_BITS_5_JUMPMASTER                                              ((FIT_SPORT_BITS_5)0x40)
#define FIT_SPORT_BITS_5_BOXING                                                  ((FIT_SPORT_BITS_5)0x80)
#define FIT_SPORT_BITS_5_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_6; // Bit field corresponding to sport enum type (1 << (sport-48)).
#define FIT_SPORT_BITS_6_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_6_FLOOR_CLIMBING                                          ((FIT_SPORT_BITS_6)0x01)
#define FIT_SPORT_BITS_6_COUNT                                                   1

typedef FIT_ENUM FIT_SUB_SPORT;
#define FIT_SUB_SPORT_INVALID                                                    FIT_ENUM_INVALID
#define FIT_SUB_SPORT_GENERIC                                                    ((FIT_SUB_SPORT)0)
#define FIT_SUB_SPORT_TREADMILL                                                  ((FIT_SUB_SPORT)1) // Run/Fitness Equipment
#define FIT_SUB_SPORT_STREET                                                     ((FIT_SUB_SPORT)2) // Run
#define FIT_SUB_SPORT_TRAIL                                                      ((FIT_SUB_SPORT)3) // Run
#define FIT_SUB_SPORT_TRACK                                                      ((FIT_SUB_SPORT)4) // Run
#define FIT_SUB_SPORT_SPIN                                                       ((FIT_SUB_SPORT)5) // Cycling
#define FIT_SUB_SPORT_INDOOR_CYCLING                                             ((FIT_SUB_SPORT)6) // Cycling/Fitness Equipment
#define FIT_SUB_SPORT_ROAD                                                       ((FIT_SUB_SPORT)7) // Cycling
#define FIT_SUB_SPORT_MOUNTAIN                                                   ((FIT_SUB_SPORT)8) // Cycling
#define FIT_SUB_SPORT_DOWNHILL                                                   ((FIT_SUB_SPORT)9) // Cycling
#define FIT_SUB_SPORT_RECUMBENT                                                  ((FIT_SUB_SPORT)10) // Cycling
#define FIT_SUB_SPORT_CYCLOCROSS                                                 ((FIT_SUB_SPORT)11) // Cycling
#define FIT_SUB_SPORT_HAND_CYCLING                                               ((FIT_SUB_SPORT)12) // Cycling
#define FIT_SUB_SPORT_TRACK_CYCLING                                              ((FIT_SUB_SPORT)13) // Cycling
#define FIT_SUB_SPORT_INDOOR_ROWING                                              ((FIT_SUB_SPORT)14) // Fitness Equipment
#define FIT_SUB_SPORT_ELLIPTICAL                                                 ((FIT_SUB_SPORT)15) // Fitness Equipment
#define FIT_SUB_SPORT_STAIR_CLIMBING                                             ((FIT_SUB_SPORT)16) // Fitness Equipment
#define FIT_SUB_SPORT_LAP_SWIMMING                                               ((FIT_SUB_SPORT)17) // Swimming
#define FIT_SUB_SPORT_OPEN_WATER                                                 ((FIT_SUB_SPORT)18) // Swimming
#define FIT_SUB_SPORT_FLEXIBILITY_TRAINING                                       ((FIT_SUB_SPORT)19) // Training
#define FIT_SUB_SPORT_STRENGTH_TRAINING                                          ((FIT_SUB_SPORT)20) // Training
#define FIT_SUB_SPORT_WARM_UP                                                    ((FIT_SUB_SPORT)21) // Tennis
#define FIT_SUB_SPORT_MATCH                                                      ((FIT_SUB_SPORT)22) // Tennis
#define FIT_SUB_SPORT_EXERCISE                                                   ((FIT_SUB_SPORT)23) // Tennis
#define FIT_SUB_SPORT_CHALLENGE                                                  ((FIT_SUB_SPORT)24)
#define FIT_SUB_SPORT_INDOOR_SKIING                                              ((FIT_SUB_SPORT)25) // Fitness Equipment
#define FIT_SUB_SPORT_CARDIO_TRAINING                                            ((FIT_SUB_SPORT)26) // Training
#define FIT_SUB_SPORT_INDOOR_WALKING                                             ((FIT_SUB_SPORT)27) // Walking/Fitness Equipment
#define FIT_SUB_SPORT_E_BIKE_FITNESS                                             ((FIT_SUB_SPORT)28) // E-Biking
#define FIT_SUB_SPORT_BMX                                                        ((FIT_SUB_SPORT)29) // Cycling
#define FIT_SUB_SPORT_CASUAL_WALKING                                             ((FIT_SUB_SPORT)30) // Walking
#define FIT_SUB_SPORT_SPEED_WALKING                                              ((FIT_SUB_SPORT)31) // Walking
#define FIT_SUB_SPORT_BIKE_TO_RUN_TRANSITION                                     ((FIT_SUB_SPORT)32) // Transition
#define FIT_SUB_SPORT_RUN_TO_BIKE_TRANSITION                                     ((FIT_SUB_SPORT)33) // Transition
#define FIT_SUB_SPORT_SWIM_TO_BIKE_TRANSITION                                    ((FIT_SUB_SPORT)34) // Transition
#define FIT_SUB_SPORT_ATV                                                        ((FIT_SUB_SPORT)35) // Motorcycling
#define FIT_SUB_SPORT_MOTOCROSS                                                  ((FIT_SUB_SPORT)36) // Motorcycling
#define FIT_SUB_SPORT_BACKCOUNTRY                                                ((FIT_SUB_SPORT)37) // Alpine Skiing/Snowboarding
#define FIT_SUB_SPORT_RESORT                                                     ((FIT_SUB_SPORT)38) // Alpine Skiing/Snowboarding
#define FIT_SUB_SPORT_RC_DRONE                                                   ((FIT_SUB_SPORT)39) // Flying
#define FIT_SUB_SPORT_WINGSUIT                                                   ((FIT_SUB_SPORT)40) // Flying
#define FIT_SUB_SPORT_WHITEWATER                                                 ((FIT_SUB_SPORT)41) // Kayaking/Rafting
#define FIT_SUB_SPORT_SKATE_SKIING                                               ((FIT_SUB_SPORT)42) // Cross Country Skiing
#define FIT_SUB_SPORT_YOGA                                                       ((FIT_SUB_SPORT)43) // Training
#define FIT_SUB_SPORT_PILATES                                                    ((FIT_SUB_SPORT)44) // Fitness Equipment
#define FIT_SUB_SPORT_INDOOR_RUNNING                                             ((FIT_SUB_SPORT)45) // Run
#define FIT_SUB_SPORT_GRAVEL_CYCLING                                             ((FIT_SUB_SPORT)46) // Cycling
#define FIT_SUB_SPORT_E_BIKE_MOUNTAIN                                            ((FIT_SUB_SPORT)47) // Cycling
#define FIT_SUB_SPORT_COMMUTING                                                  ((FIT_SUB_SPORT)48) // Cycling
#define FIT_SUB_SPORT_MIXED_SURFACE                                              ((FIT_SUB_SPORT)49) // Cycling
#define FIT_SUB_SPORT_NAVIGATE                                                   ((FIT_SUB_SPORT)50)
#define FIT_SUB_SPORT_TRACK_ME                                                   ((FIT_SUB_SPORT)51)
#define FIT_SUB_SPORT_MAP                                                        ((FIT_SUB_SPORT)52)
#define FIT_SUB_SPORT_SINGLE_GAS_DIVING                                          ((FIT_SUB_SPORT)53) // Diving
#define FIT_SUB_SPORT_MULTI_GAS_DIVING                                           ((FIT_SUB_SPORT)54) // Diving
#define FIT_SUB_SPORT_GAUGE_DIVING                                               ((FIT_SUB_SPORT)55) // Diving
#define FIT_SUB_SPORT_APNEA_DIVING                                               ((FIT_SUB_SPORT)56) // Diving
#define FIT_SUB_SPORT_APNEA_HUNTING                                              ((FIT_SUB_SPORT)57) // Diving
#define FIT_SUB_SPORT_VIRTUAL_ACTIVITY                                           ((FIT_SUB_SPORT)58)
#define FIT_SUB_SPORT_OBSTACLE                                                   ((FIT_SUB_SPORT)59) // Used for events where participants run, crawl through mud, climb over walls, etc.
#define FIT_SUB_SPORT_BREATHING                                                  ((FIT_SUB_SPORT)62)
#define FIT_SUB_SPORT_SAIL_RACE                                                  ((FIT_SUB_SPORT)65) // Sailing
#define FIT_SUB_SPORT_ULTRA                                                      ((FIT_SUB_SPORT)67) // Ultramarathon
#define FIT_SUB_SPORT_INDOOR_CLIMBING                                            ((FIT_SUB_SPORT)68) // Climbing
#define FIT_SUB_SPORT_BOULDERING                                                 ((FIT_SUB_SPORT)69) // Climbing
#define FIT_SUB_SPORT_HIIT                                                       ((FIT_SUB_SPORT)70) // High Intensity Interval Training
#define FIT_SUB_SPORT_AMRAP                                                      ((FIT_SUB_SPORT)73) // HIIT
#define FIT_SUB_SPORT_EMOM                                                       ((FIT_SUB_SPORT)74) // HIIT
#define FIT_SUB_SPORT_TABATA                                                     ((FIT_SUB_SPORT)75) // HIIT
#define FIT_SUB_SPORT_PICKLEBALL                                                 ((FIT_SUB_SPORT)84) // Racket
#define FIT_SUB_SPORT_PADEL                                                      ((FIT_SUB_SPORT)85) // Racket
#define FIT_SUB_SPORT_INDOOR_WHEELCHAIR_WALK                                     ((FIT_SUB_SPORT)86)
#define FIT_SUB_SPORT_INDOOR_WHEELCHAIR_RUN                                      ((FIT_SUB_SPORT)87)
#define FIT_SUB_SPORT_INDOOR_HAND_CYCLING                                        ((FIT_SUB_SPORT)88)
#define FIT_SUB_SPORT_SQUASH                                                     ((FIT_SUB_SPORT)94)
#define FIT_SUB_SPORT_BADMINTON                                                  ((FIT_SUB_SPORT)95)
#define FIT_SUB_SPORT_RACQUETBALL                                                ((FIT_SUB_SPORT)96)
#define FIT_SUB_SPORT_TABLE_TENNIS                                               ((FIT_SUB_SPORT)97)
#define FIT_SUB_SPORT_FLY_CANOPY                                                 ((FIT_SUB_SPORT)110) // Flying
#define FIT_SUB_SPORT_FLY_PARAGLIDE                                              ((FIT_SUB_SPORT)111) // Flying
#define FIT_SUB_SPORT_FLY_PARAMOTOR                                              ((FIT_SUB_SPORT)112) // Flying
#define FIT_SUB_SPORT_FLY_PRESSURIZED                                            ((FIT_SUB_SPORT)113) // Flying
#define FIT_SUB_SPORT_FLY_NAVIGATE                                               ((FIT_SUB_SPORT)114) // Flying
#define FIT_SUB_SPORT_FLY_TIMER                                                  ((FIT_SUB_SPORT)115) // Flying
#define FIT_SUB_SPORT_FLY_ALTIMETER                                              ((FIT_SUB_SPORT)116) // Flying
#define FIT_SUB_SPORT_FLY_WX                                                     ((FIT_SUB_SPORT)117) // Flying
#define FIT_SUB_SPORT_FLY_VFR                                                    ((FIT_SUB_SPORT)118) // Flying
#define FIT_SUB_SPORT_FLY_IFR                                                    ((FIT_SUB_SPORT)119) // Flying
#define FIT_SUB_SPORT_ALL                                                        ((FIT_SUB_SPORT)254)
#define FIT_SUB_SPORT_COUNT                                                      89

typedef FIT_ENUM FIT_SPORT_EVENT;
#define FIT_SPORT_EVENT_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SPORT_EVENT_UNCATEGORIZED                                            ((FIT_SPORT_EVENT)0)
#define FIT_SPORT_EVENT_GEOCACHING                                               ((FIT_SPORT_EVENT)1)
#define FIT_SPORT_EVENT_FITNESS                                                  ((FIT_SPORT_EVENT)2)
#define FIT_SPORT_EVENT_RECREATION                                               ((FIT_SPORT_EVENT)3)
#define FIT_SPORT_EVENT_RACE                                                     ((FIT_SPORT_EVENT)4)
#define FIT_SPORT_EVENT_SPECIAL_EVENT                                            ((FIT_SPORT_EVENT)5)
#define FIT_SPORT_EVENT_TRAINING                                                 ((FIT_SPORT_EVENT)6)
#define FIT_SPORT_EVENT_TRANSPORTATION                                           ((FIT_SPORT_EVENT)7)
#define FIT_SPORT_EVENT_TOURING                                                  ((FIT_SPORT_EVENT)8)
#define FIT_SPORT_EVENT_COUNT                                                    9

typedef FIT_ENUM FIT_ACTIVITY;
#define FIT_ACTIVITY_INVALID                                                     FIT_ENUM_INVALID
#define FIT_ACTIVITY_MANUAL                                                      ((FIT_ACTIVITY)0)
#define FIT_ACTIVITY_AUTO_MULTI_SPORT                                            ((FIT_ACTIVITY)1)
#define FIT_ACTIVITY_COUNT                                                       2

typedef FIT_ENUM FIT_INTENSITY;
#define FIT_INTENSITY_INVALID                                                    FIT_ENUM_INVALID
#define FIT_INTENSITY_ACTIVE                                                     ((FIT_INTENSITY)0)
#define FIT_INTENSITY_REST                                                       ((FIT_INTENSITY)1)
#define FIT_INTENSITY_WARMUP                                                     ((FIT_INTENSITY)2)
#define FIT_INTENSITY_COOLDOWN                                                   ((FIT_INTENSITY)3)
#define FIT_INTENSITY_RECOVERY                                                   ((FIT_INTENSITY)4)
#define FIT_INTENSITY_INTERVAL                                                   ((FIT_INTENSITY)5)
#define FIT_INTENSITY_OTHER                                                      ((FIT_INTENSITY)6)
#define FIT_INTENSITY_COUNT                                                      7

typedef FIT_ENUM FIT_SESSION_TRIGGER;
#define FIT_SESSION_TRIGGER_INVALID                                              FIT_ENUM_INVALID
#define FIT_SESSION_TRIGGER_ACTIVITY_END                                         ((FIT_SESSION_TRIGGER)0)
#define FIT_SESSION_TRIGGER_MANUAL                                               ((FIT_SESSION_TRIGGER)1) // User changed sport.
#define FIT_SESSION_TRIGGER_AUTO_MULTI_SPORT                                     ((FIT_SESSION_TRIGGER)2) // Auto multi-sport feature is enabled and user pressed lap button to advance session.
#define FIT_SESSION_TRIGGER_FITNESS_EQUIPMENT                                    ((FIT_SESSION_TRIGGER)3) // Auto sport change caused by user linking to fitness equipment.
#define FIT_SESSION_TRIGGER_COUNT                                                4

typedef FIT_ENUM FIT_AUTOLAP_TRIGGER;
#define FIT_AUTOLAP_TRIGGER_INVALID                                              FIT_ENUM_INVALID
#define FIT_AUTOLAP_TRIGGER_TIME                                                 ((FIT_AUTOLAP_TRIGGER)0)
#define FIT_AUTOLAP_TRIGGER_DISTANCE                                             ((FIT_AUTOLAP_TRIGGER)1)
#define FIT_AUTOLAP_TRIGGER_POSITION_START                                       ((FIT_AUTOLAP_TRIGGER)2)
#define FIT_AUTOLAP_TRIGGER_POSITION_LAP                                         ((FIT_AUTOLAP_TRIGGER)3)
#define FIT_AUTOLAP_TRIGGER_POSITION_WAYPOINT                                    ((FIT_AUTOLAP_TRIGGER)4)
#define FIT_AUTOLAP_TRIGGER_POSITION_MARKED                                      ((FIT_AUTOLAP_TRIGGER)5)
#define FIT_AUTOLAP_TRIGGER_OFF                                                  ((FIT_AUTOLAP_TRIGGER)6)
#define FIT_AUTOLAP_TRIGGER_AUTO_SELECT                                          ((FIT_AUTOLAP_TRIGGER)13)
#define FIT_AUTOLAP_TRIGGER_COUNT                                                8

typedef FIT_ENUM FIT_LAP_TRIGGER;
#define FIT_LAP_TRIGGER_INVALID                                                  FIT_ENUM_INVALID
#define FIT_LAP_TRIGGER_MANUAL                                                   ((FIT_LAP_TRIGGER)0)
#define FIT_LAP_TRIGGER_TIME                                                     ((FIT_LAP_TRIGGER)1)
#define FIT_LAP_TRIGGER_DISTANCE                                                 ((FIT_LAP_TRIGGER)2)
#define FIT_LAP_TRIGGER_POSITION_START                                           ((FIT_LAP_TRIGGER)3)
#define FIT_LAP_TRIGGER_POSITION_LAP                                             ((FIT_LAP_TRIGGER)4)
#define FIT_LAP_TRIGGER_POSITION_WAYPOINT                                        ((FIT_LAP_TRIGGER)5)
#define FIT_LAP_TRIGGER_POSITION_MARKED                                          ((FIT_LAP_TRIGGER)6)
#define FIT_LAP_TRIGGER_SESSION_END                                              ((FIT_LAP_TRIGGER)7)
#define FIT_LAP_TRIGGER_FITNESS_EQUIPMENT                                        ((FIT_LAP_TRIGGER)8)
#define FIT_LAP_TRIGGER_COUNT                                                    9

typedef FIT_ENUM FIT_TIME_MODE;
#define FIT_TIME_MODE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_TIME_MODE_HOUR12                                                     ((FIT_TIME_MODE)0)
#define FIT_TIME_MODE_HOUR24                                                     ((FIT_TIME_MODE)1) // Does not use a leading zero and has a colon
#define FIT_TIME_MODE_MILITARY                                                   ((FIT_TIME_MODE)2) // Uses a leading zero and does not have a colon
#define FIT_TIME_MODE_HOUR_12_WITH_SECONDS                                       ((FIT_TIME_MODE)3)
#define FIT_TIME_MODE_HOUR_24_WITH_SECONDS                                       ((FIT_TIME_MODE)4)
#define FIT_TIME_MODE_UTC                                                        ((FIT_TIME_MODE)5)
#define FIT_TIME_MODE_COUNT                                                      6

typedef FIT_ENUM FIT_BACKLIGHT_MODE;
#define FIT_BACKLIGHT_MODE_INVALID                                               FIT_ENUM_INVALID
#define FIT_BACKLIGHT_MODE_OFF                                                   ((FIT_BACKLIGHT_MODE)0)
#define FIT_BACKLIGHT_MODE_MANUAL                                                ((FIT_BACKLIGHT_MODE)1)
#define FIT_BACKLIGHT_MODE_KEY_AND_MESSAGES                                      ((FIT_BACKLIGHT_MODE)2)
#define FIT_BACKLIGHT_MODE_AUTO_BRIGHTNESS                                       ((FIT_BACKLIGHT_MODE)3)
#define FIT_BACKLIGHT_MODE_SMART_NOTIFICATIONS                                   ((FIT_BACKLIGHT_MODE)4)
#define FIT_BACKLIGHT_MODE_KEY_AND_MESSAGES_NIGHT                                ((FIT_BACKLIGHT_MODE)5)
#define FIT_BACKLIGHT_MODE_KEY_AND_MESSAGES_AND_SMART_NOTIFICATIONS              ((FIT_BACKLIGHT_MODE)6)
#define FIT_BACKLIGHT_MODE_COUNT                                                 7

typedef FIT_ENUM FIT_DATE_MODE;
#define FIT_DATE_MODE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_DATE_MODE_DAY_MONTH                                                  ((FIT_DATE_MODE)0)
#define FIT_DATE_MODE_MONTH_DAY                                                  ((FIT_DATE_MODE)1)
#define FIT_DATE_MODE_COUNT                                                      2

typedef FIT_UINT8 FIT_BACKLIGHT_TIMEOUT; // Timeout in seconds.
#define FIT_BACKLIGHT_TIMEOUT_INVALID                                            FIT_UINT8_INVALID
#define FIT_BACKLIGHT_TIMEOUT_INFINITE                                           ((FIT_BACKLIGHT_TIMEOUT)0) // Backlight stays on forever.
#define FIT_BACKLIGHT_TIMEOUT_COUNT                                              1

typedef FIT_ENUM FIT_EVENT;
#define FIT_EVENT_INVALID                                                        FIT_ENUM_INVALID
#define FIT_EVENT_TIMER                                                          ((FIT_EVENT)0) // Group 0. Start / stop_all
#define FIT_EVENT_WORKOUT                                                        ((FIT_EVENT)3) // start / stop
#define FIT_EVENT_WORKOUT_STEP                                                   ((FIT_EVENT)4) // Start at beginning of workout. Stop at end of each step.
#define FIT_EVENT_POWER_DOWN                                                     ((FIT_EVENT)5) // stop_all group 0
#define FIT_EVENT_POWER_UP                                                       ((FIT_EVENT)6) // stop_all group 0
#define FIT_EVENT_OFF_COURSE                                                     ((FIT_EVENT)7) // start / stop group 0
#define FIT_EVENT_SESSION                                                        ((FIT_EVENT)8) // Stop at end of each session.
#define FIT_EVENT_LAP                                                            ((FIT_EVENT)9) // Stop at end of each lap.
#define FIT_EVENT_COURSE_POINT                                                   ((FIT_EVENT)10) // marker
#define FIT_EVENT_BATTERY                                                        ((FIT_EVENT)11) // marker
#define FIT_EVENT_VIRTUAL_PARTNER_PACE                                           ((FIT_EVENT)12) // Group 1. Start at beginning of activity if VP enabled, when VP pace is changed during activity or VP enabled mid activity. stop_disable when VP disabled.
#define FIT_EVENT_HR_HIGH_ALERT                                                  ((FIT_EVENT)13) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_HR_LOW_ALERT                                                   ((FIT_EVENT)14) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_SPEED_HIGH_ALERT                                               ((FIT_EVENT)15) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_SPEED_LOW_ALERT                                                ((FIT_EVENT)16) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_CAD_HIGH_ALERT                                                 ((FIT_EVENT)17) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_CAD_LOW_ALERT                                                  ((FIT_EVENT)18) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_POWER_HIGH_ALERT                                               ((FIT_EVENT)19) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_POWER_LOW_ALERT                                                ((FIT_EVENT)20) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_RECOVERY_HR                                                    ((FIT_EVENT)21) // marker
#define FIT_EVENT_BATTERY_LOW                                                    ((FIT_EVENT)22) // marker
#define FIT_EVENT_TIME_DURATION_ALERT                                            ((FIT_EVENT)23) // Group 1. Start if enabled mid activity (not required at start of activity). Stop when duration is reached. stop_disable if disabled.
#define FIT_EVENT_DISTANCE_DURATION_ALERT                                        ((FIT_EVENT)24) // Group 1. Start if enabled mid activity (not required at start of activity). Stop when duration is reached. stop_disable if disabled.
#define FIT_EVENT_CALORIE_DURATION_ALERT                                         ((FIT_EVENT)25) // Group 1. Start if enabled mid activity (not required at start of activity). Stop when duration is reached. stop_disable if disabled.
#define FIT_EVENT_ACTIVITY                                                       ((FIT_EVENT)26) // Group 1.. Stop at end of activity.
#define FIT_EVENT_FITNESS_EQUIPMENT                                              ((FIT_EVENT)27) // marker
#define FIT_EVENT_LENGTH                                                         ((FIT_EVENT)28) // Stop at end of each length.
#define FIT_EVENT_USER_MARKER                                                    ((FIT_EVENT)32) // marker
#define FIT_EVENT_SPORT_POINT                                                    ((FIT_EVENT)33) // marker
#define FIT_EVENT_CALIBRATION                                                    ((FIT_EVENT)36) // start/stop/marker
#define FIT_EVENT_FRONT_GEAR_CHANGE                                              ((FIT_EVENT)42) // marker
#define FIT_EVENT_REAR_GEAR_CHANGE                                               ((FIT_EVENT)43) // marker
#define FIT_EVENT_RIDER_POSITION_CHANGE                                          ((FIT_EVENT)44) // marker
#define FIT_EVENT_ELEV_HIGH_ALERT                                                ((FIT_EVENT)45) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_ELEV_LOW_ALERT                                                 ((FIT_EVENT)46) // Group 0. Start / stop when in alert condition.
#define FIT_EVENT_COMM_TIMEOUT                                                   ((FIT_EVENT)47) // marker
#define FIT_EVENT_AUTO_ACTIVITY_DETECT                                           ((FIT_EVENT)54) // marker
#define FIT_EVENT_DIVE_ALERT                                                     ((FIT_EVENT)56) // marker
#define FIT_EVENT_DIVE_GAS_SWITCHED                                              ((FIT_EVENT)57) // marker
#define FIT_EVENT_TANK_PRESSURE_RESERVE                                          ((FIT_EVENT)71) // marker
#define FIT_EVENT_TANK_PRESSURE_CRITICAL                                         ((FIT_EVENT)72) // marker
#define FIT_EVENT_TANK_LOST                                                      ((FIT_EVENT)73) // marker
#define FIT_EVENT_RADAR_THREAT_ALERT                                             ((FIT_EVENT)75) // start/stop/marker
#define FIT_EVENT_TANK_BATTERY_LOW                                               ((FIT_EVENT)76) // marker
#define FIT_EVENT_TANK_POD_CONNECTED                                             ((FIT_EVENT)81) // marker - tank pod has connected
#define FIT_EVENT_TANK_POD_DISCONNECTED                                          ((FIT_EVENT)82) // marker - tank pod has lost connection
#define FIT_EVENT_COUNT                                                          46

typedef FIT_ENUM FIT_EVENT_TYPE;
#define FIT_EVENT_TYPE_INVALID                                                   FIT_ENUM_INVALID
#define FIT_EVENT_TYPE_START                                                     ((FIT_EVENT_TYPE)0)
#define FIT_EVENT_TYPE_STOP                                                      ((FIT_EVENT_TYPE)1)
#define FIT_EVENT_TYPE_CONSECUTIVE_DEPRECIATED                                   ((FIT_EVENT_TYPE)2)
#define FIT_EVENT_TYPE_MARKER                                                    ((FIT_EVENT_TYPE)3)
#define FIT_EVENT_TYPE_STOP_ALL                                                  ((FIT_EVENT_TYPE)4)
#define FIT_EVENT_TYPE_BEGIN_DEPRECIATED                                         ((FIT_EVENT_TYPE)5)
#define FIT_EVENT_TYPE_END_DEPRECIATED                                           ((FIT_EVENT_TYPE)6)
#define FIT_EVENT_TYPE_END_ALL_DEPRECIATED                                       ((FIT_EVENT_TYPE)7)
#define FIT_EVENT_TYPE_STOP_DISABLE                                              ((FIT_EVENT_TYPE)8)
#define FIT_EVENT_TYPE_STOP_DISABLE_ALL                                          ((FIT_EVENT_TYPE)9)
#define FIT_EVENT_TYPE_COUNT                                                     10

typedef FIT_ENUM FIT_TIMER_TRIGGER; // timer event data
#define FIT_TIMER_TRIGGER_INVALID                                                FIT_ENUM_INVALID
#define FIT_TIMER_TRIGGER_MANUAL                                                 ((FIT_TIMER_TRIGGER)0)
#define FIT_TIMER_TRIGGER_AUTO                                                   ((FIT_TIMER_TRIGGER)1)
#define FIT_TIMER_TRIGGER_FITNESS_EQUIPMENT                                      ((FIT_TIMER_TRIGGER)2)
#define FIT_TIMER_TRIGGER_COUNT                                                  3

typedef FIT_ENUM FIT_FITNESS_EQUIPMENT_STATE; // fitness equipment event data
#define FIT_FITNESS_EQUIPMENT_STATE_INVALID                                      FIT_ENUM_INVALID
#define FIT_FITNESS_EQUIPMENT_STATE_READY                                        ((FIT_FITNESS_EQUIPMENT_STATE)0)
#define FIT_FITNESS_EQUIPMENT_STATE_IN_USE                                       ((FIT_FITNESS_EQUIPMENT_STATE)1)
#define FIT_FITNESS_EQUIPMENT_STATE_PAUSED                                       ((FIT_FITNESS_EQUIPMENT_STATE)2)
#define FIT_FITNESS_EQUIPMENT_STATE_UNKNOWN                                      ((FIT_FITNESS_EQUIPMENT_STATE)3) // lost connection to fitness equipment
#define FIT_FITNESS_EQUIPMENT_STATE_COUNT                                        4

typedef FIT_ENUM FIT_TONE;
#define FIT_TONE_INVALID                                                         FIT_ENUM_INVALID
#define FIT_TONE_OFF                                                             ((FIT_TONE)0)
#define FIT_TONE_TONE                                                            ((FIT_TONE)1)
#define FIT_TONE_VIBRATE                                                         ((FIT_TONE)2)
#define FIT_TONE_TONE_AND_VIBRATE                                                ((FIT_TONE)3)
#define FIT_TONE_COUNT                                                           4

typedef FIT_ENUM FIT_AUTOSCROLL;
#define FIT_AUTOSCROLL_INVALID                                                   FIT_ENUM_INVALID
#define FIT_AUTOSCROLL_NONE                                                      ((FIT_AUTOSCROLL)0)
#define FIT_AUTOSCROLL_SLOW                                                      ((FIT_AUTOSCROLL)1)
#define FIT_AUTOSCROLL_MEDIUM                                                    ((FIT_AUTOSCROLL)2)
#define FIT_AUTOSCROLL_FAST                                                      ((FIT_AUTOSCROLL)3)
#define FIT_AUTOSCROLL_COUNT                                                     4

typedef FIT_ENUM FIT_ACTIVITY_CLASS;
#define FIT_ACTIVITY_CLASS_INVALID                                               FIT_ENUM_INVALID
#define FIT_ACTIVITY_CLASS_LEVEL                                                 ((FIT_ACTIVITY_CLASS)0x7F) // 0 to 100
#define FIT_ACTIVITY_CLASS_LEVEL_MAX                                             ((FIT_ACTIVITY_CLASS)100)
#define FIT_ACTIVITY_CLASS_ATHLETE                                               ((FIT_ACTIVITY_CLASS)0x80)
#define FIT_ACTIVITY_CLASS_COUNT                                                 3

typedef FIT_ENUM FIT_HR_ZONE_CALC;
#define FIT_HR_ZONE_CALC_INVALID                                                 FIT_ENUM_INVALID
#define FIT_HR_ZONE_CALC_CUSTOM                                                  ((FIT_HR_ZONE_CALC)0)
#define FIT_HR_ZONE_CALC_PERCENT_MAX_HR                                          ((FIT_HR_ZONE_CALC)1)
#define FIT_HR_ZONE_CALC_PERCENT_HRR                                             ((FIT_HR_ZONE_CALC)2)
#define FIT_HR_ZONE_CALC_PERCENT_LTHR                                            ((FIT_HR_ZONE_CALC)3)
#define FIT_HR_ZONE_CALC_COUNT                                                   4

typedef FIT_ENUM FIT_PWR_ZONE_CALC;
#define FIT_PWR_ZONE_CALC_INVALID                                                FIT_ENUM_INVALID
#define FIT_PWR_ZONE_CALC_CUSTOM                                                 ((FIT_PWR_ZONE_CALC)0)
#define FIT_PWR_ZONE_CALC_PERCENT_FTP                                            ((FIT_PWR_ZONE_CALC)1)
#define FIT_PWR_ZONE_CALC_COUNT                                                  2

typedef FIT_ENUM FIT_WKT_STEP_DURATION;
#define FIT_WKT_STEP_DURATION_INVALID                                            FIT_ENUM_INVALID
#define FIT_WKT_STEP_DURATION_TIME                                               ((FIT_WKT_STEP_DURATION)0)
#define FIT_WKT_STEP_DURATION_DISTANCE                                           ((FIT_WKT_STEP_DURATION)1)
#define FIT_WKT_STEP_DURATION_HR_LESS_THAN                                       ((FIT_WKT_STEP_DURATION)2)
#define FIT_WKT_STEP_DURATION_HR_GREATER_THAN                                    ((FIT_WKT_STEP_DURATION)3)
#define FIT_WKT_STEP_DURATION_CALORIES                                           ((FIT_WKT_STEP_DURATION)4)
#define FIT_WKT_STEP_DURATION_OPEN                                               ((FIT_WKT_STEP_DURATION)5)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_STEPS_CMPLT                           ((FIT_WKT_STEP_DURATION)6)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_TIME                                  ((FIT_WKT_STEP_DURATION)7)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_DISTANCE                              ((FIT_WKT_STEP_DURATION)8)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_CALORIES                              ((FIT_WKT_STEP_DURATION)9)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_HR_LESS_THAN                          ((FIT_WKT_STEP_DURATION)10)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_HR_GREATER_THAN                       ((FIT_WKT_STEP_DURATION)11)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_POWER_LESS_THAN                       ((FIT_WKT_STEP_DURATION)12)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_POWER_GREATER_THAN                    ((FIT_WKT_STEP_DURATION)13)
#define FIT_WKT_STEP_DURATION_POWER_LESS_THAN                                    ((FIT_WKT_STEP_DURATION)14)
#define FIT_WKT_STEP_DURATION_POWER_GREATER_THAN                                 ((FIT_WKT_STEP_DURATION)15)
#define FIT_WKT_STEP_DURATION_TRAINING_PEAKS_TSS                                 ((FIT_WKT_STEP_DURATION)16)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_POWER_LAST_LAP_LESS_THAN              ((FIT_WKT_STEP_DURATION)17)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_MAX_POWER_LAST_LAP_LESS_THAN          ((FIT_WKT_STEP_DURATION)18)
#define FIT_WKT_STEP_DURATION_POWER_3S_LESS_THAN                                 ((FIT_WKT_STEP_DURATION)19)
#define FIT_WKT_STEP_DURATION_POWER_10S_LESS_THAN                                ((FIT_WKT_STEP_DURATION)20)
#define FIT_WKT_STEP_DURATION_POWER_30S_LESS_THAN                                ((FIT_WKT_STEP_DURATION)21)
#define FIT_WKT_STEP_DURATION_POWER_3S_GREATER_THAN                              ((FIT_WKT_STEP_DURATION)22)
#define FIT_WKT_STEP_DURATION_POWER_10S_GREATER_THAN                             ((FIT_WKT_STEP_DURATION)23)
#define FIT_WKT_STEP_DURATION_POWER_30S_GREATER_THAN                             ((FIT_WKT_STEP_DURATION)24)
#define FIT_WKT_STEP_DURATION_POWER_LAP_LESS_THAN                                ((FIT_WKT_STEP_DURATION)25)
#define FIT_WKT_STEP_DURATION_POWER_LAP_GREATER_THAN                             ((FIT_WKT_STEP_DURATION)26)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_TRAINING_PEAKS_TSS                    ((FIT_WKT_STEP_DURATION)27)
#define FIT_WKT_STEP_DURATION_REPETITION_TIME                                    ((FIT_WKT_STEP_DURATION)28)
#define FIT_WKT_STEP_DURATION_REPS                                               ((FIT_WKT_STEP_DURATION)29)
#define FIT_WKT_STEP_DURATION_TIME_ONLY                                          ((FIT_WKT_STEP_DURATION)31)
#define FIT_WKT_STEP_DURATION_COUNT                                              31

typedef FIT_ENUM FIT_WKT_STEP_TARGET;
#define FIT_WKT_STEP_TARGET_INVALID                                              FIT_ENUM_INVALID
#define FIT_WKT_STEP_TARGET_SPEED                                                ((FIT_WKT_STEP_TARGET)0)
#define FIT_WKT_STEP_TARGET_HEART_RATE                                           ((FIT_WKT_STEP_TARGET)1)
#define FIT_WKT_STEP_TARGET_OPEN                                                 ((FIT_WKT_STEP_TARGET)2)
#define FIT_WKT_STEP_TARGET_CADENCE                                              ((FIT_WKT_STEP_TARGET)3)
#define FIT_WKT_STEP_TARGET_POWER                                                ((FIT_WKT_STEP_TARGET)4)
#define FIT_WKT_STEP_TARGET_GRADE                                                ((FIT_WKT_STEP_TARGET)5)
#define FIT_WKT_STEP_TARGET_RESISTANCE                                           ((FIT_WKT_STEP_TARGET)6)
#define FIT_WKT_STEP_TARGET_POWER_3S                                             ((FIT_WKT_STEP_TARGET)7)
#define FIT_WKT_STEP_TARGET_POWER_10S                                            ((FIT_WKT_STEP_TARGET)8)
#define FIT_WKT_STEP_TARGET_POWER_30S                                            ((FIT_WKT_STEP_TARGET)9)
#define FIT_WKT_STEP_TARGET_POWER_LAP                                            ((FIT_WKT_STEP_TARGET)10)
#define FIT_WKT_STEP_TARGET_SWIM_STROKE                                          ((FIT_WKT_STEP_TARGET)11)
#define FIT_WKT_STEP_TARGET_SPEED_LAP                                            ((FIT_WKT_STEP_TARGET)12)
#define FIT_WKT_STEP_TARGET_HEART_RATE_LAP                                       ((FIT_WKT_STEP_TARGET)13)
#define FIT_WKT_STEP_TARGET_COUNT                                                14

typedef FIT_ENUM FIT_GOAL;
#define FIT_GOAL_INVALID                                                         FIT_ENUM_INVALID
#define FIT_GOAL_TIME                                                            ((FIT_GOAL)0)
#define FIT_GOAL_DISTANCE                                                        ((FIT_GOAL)1)
#define FIT_GOAL_CALORIES                                                        ((FIT_GOAL)2)
#define FIT_GOAL_FREQUENCY                                                       ((FIT_GOAL)3)
#define FIT_GOAL_STEPS                                                           ((FIT_GOAL)4)
#define FIT_GOAL_ASCENT                                                          ((FIT_GOAL)5)
#define FIT_GOAL_ACTIVE_MINUTES                                                  ((FIT_GOAL)6)
#define FIT_GOAL_COUNT                                                           7

typedef FIT_ENUM FIT_GOAL_RECURRENCE;
#define FIT_GOAL_RECURRENCE_INVALID                                              FIT_ENUM_INVALID
#define FIT_GOAL_RECURRENCE_OFF                                                  ((FIT_GOAL_RECURRENCE)0)
#define FIT_GOAL_RECURRENCE_DAILY                                                ((FIT_GOAL_RECURRENCE)1)
#define FIT_GOAL_RECURRENCE_WEEKLY                                               ((FIT_GOAL_RECURRENCE)2)
#define FIT_GOAL_RECURRENCE_MONTHLY                                              ((FIT_GOAL_RECURRENCE)3)
#define FIT_GOAL_RECURRENCE_YEARLY                                               ((FIT_GOAL_RECURRENCE)4)
#define FIT_GOAL_RECURRENCE_CUSTOM                                               ((FIT_GOAL_RECURRENCE)5)
#define FIT_GOAL_RECURRENCE_COUNT                                                6

typedef FIT_ENUM FIT_GOAL_SOURCE;
#define FIT_GOAL_SOURCE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_GOAL_SOURCE_AUTO                                                     ((FIT_GOAL_SOURCE)0) // Device generated
#define FIT_GOAL_SOURCE_COMMUNITY                                                ((FIT_GOAL_SOURCE)1) // Social network sourced goal
#define FIT_GOAL_SOURCE_USER                                                     ((FIT_GOAL_SOURCE)2) // Manually generated
#define FIT_GOAL_SOURCE_COUNT                                                    3

typedef FIT_ENUM FIT_SCHEDULE;
#define FIT_SCHEDULE_INVALID                                                     FIT_ENUM_INVALID
#define FIT_SCHEDULE_WORKOUT                                                     ((FIT_SCHEDULE)0)
#define FIT_SCHEDULE_COURSE                                                      ((FIT_SCHEDULE)1)
#define FIT_SCHEDULE_COUNT                                                       2

typedef FIT_ENUM FIT_COURSE_POINT;
#define FIT_COURSE_POINT_INVALID                                                 FIT_ENUM_INVALID
#define FIT_COURSE_POINT_GENERIC                                                 ((FIT_COURSE_POINT)0)
#define FIT_COURSE_POINT_SUMMIT                                                  ((FIT_COURSE_POINT)1)
#define FIT_COURSE_POINT_VALLEY                                                  ((FIT_COURSE_POINT)2)
#define FIT_COURSE_POINT_WATER                                                   ((FIT_COURSE_POINT)3)
#define FIT_COURSE_POINT_FOOD                                                    ((FIT_COURSE_POINT)4)
#define FIT_COURSE_POINT_DANGER                                                  ((FIT_COURSE_POINT)5)
#define FIT_COURSE_POINT_LEFT                                                    ((FIT_COURSE_POINT)6)
#define FIT_COURSE_POINT_RIGHT                                                   ((FIT_COURSE_POINT)7)
#define FIT_COURSE_POINT_STRAIGHT                                                ((FIT_COURSE_POINT)8)
#define FIT_COURSE_POINT_FIRST_AID                                               ((FIT_COURSE_POINT)9)
#define FIT_COURSE_POINT_FOURTH_CATEGORY                                         ((FIT_COURSE_POINT)10)
#define FIT_COURSE_POINT_THIRD_CATEGORY                                          ((FIT_COURSE_POINT)11)
#define FIT_COURSE_POINT_SECOND_CATEGORY                                         ((FIT_COURSE_POINT)12)
#define FIT_COURSE_POINT_FIRST_CATEGORY                                          ((FIT_COURSE_POINT)13)
#define FIT_COURSE_POINT_HORS_CATEGORY                                           ((FIT_COURSE_POINT)14)
#define FIT_COURSE_POINT_SPRINT                                                  ((FIT_COURSE_POINT)15)
#define FIT_COURSE_POINT_LEFT_FORK                                               ((FIT_COURSE_POINT)16)
#define FIT_COURSE_POINT_RIGHT_FORK                                              ((FIT_COURSE_POINT)17)
#define FIT_COURSE_POINT_MIDDLE_FORK                                             ((FIT_COURSE_POINT)18)
#define FIT_COURSE_POINT_SLIGHT_LEFT                                             ((FIT_COURSE_POINT)19)
#define FIT_COURSE_POINT_SHARP_LEFT                                              ((FIT_COURSE_POINT)20)
#define FIT_COURSE_POINT_SLIGHT_RIGHT                                            ((FIT_COURSE_POINT)21)
#define FIT_COURSE_POINT_SHARP_RIGHT                                             ((FIT_COURSE_POINT)22)
#define FIT_COURSE_POINT_U_TURN                                                  ((FIT_COURSE_POINT)23)
#define FIT_COURSE_POINT_SEGMENT_START                                           ((FIT_COURSE_POINT)24)
#define FIT_COURSE_POINT_SEGMENT_END                                             ((FIT_COURSE_POINT)25)
#define FIT_COURSE_POINT_CAMPSITE                                                ((FIT_COURSE_POINT)27)
#define FIT_COURSE_POINT_AID_STATION                                             ((FIT_COURSE_POINT)28)
#define FIT_COURSE_POINT_REST_AREA                                               ((FIT_COURSE_POINT)29)
#define FIT_COURSE_POINT_GENERAL_DISTANCE                                        ((FIT_COURSE_POINT)30) // Used with UpAhead
#define FIT_COURSE_POINT_SERVICE                                                 ((FIT_COURSE_POINT)31)
#define FIT_COURSE_POINT_ENERGY_GEL                                              ((FIT_COURSE_POINT)32)
#define FIT_COURSE_POINT_SPORTS_DRINK                                            ((FIT_COURSE_POINT)33)
#define FIT_COURSE_POINT_MILE_MARKER                                             ((FIT_COURSE_POINT)34)
#define FIT_COURSE_POINT_CHECKPOINT                                              ((FIT_COURSE_POINT)35)
#define FIT_COURSE_POINT_SHELTER                                                 ((FIT_COURSE_POINT)36)
#define FIT_COURSE_POINT_MEETING_SPOT                                            ((FIT_COURSE_POINT)37)
#define FIT_COURSE_POINT_OVERLOOK                                                ((FIT_COURSE_POINT)38)
#define FIT_COURSE_POINT_TOILET                                                  ((FIT_COURSE_POINT)39)
#define FIT_COURSE_POINT_SHOWER                                                  ((FIT_COURSE_POINT)40)
#define FIT_COURSE_POINT_GEAR                                                    ((FIT_COURSE_POINT)41)
#define FIT_COURSE_POINT_SHARP_CURVE                                             ((FIT_COURSE_POINT)42)
#define FIT_COURSE_POINT_STEEP_INCLINE                                           ((FIT_COURSE_POINT)43)
#define FIT_COURSE_POINT_TUNNEL                                                  ((FIT_COURSE_POINT)44)
#define FIT_COURSE_POINT_BRIDGE                                                  ((FIT_COURSE_POINT)45)
#define FIT_COURSE_POINT_OBSTACLE                                                ((FIT_COURSE_POINT)46)
#define FIT_COURSE_POINT_CROSSING                                                ((FIT_COURSE_POINT)47)
#define FIT_COURSE_POINT_STORE                                                   ((FIT_COURSE_POINT)48)
#define FIT_COURSE_POINT_TRANSITION                                              ((FIT_COURSE_POINT)49)
#define FIT_COURSE_POINT_NAVAID                                                  ((FIT_COURSE_POINT)50)
#define FIT_COURSE_POINT_TRANSPORT                                               ((FIT_COURSE_POINT)51)
#define FIT_COURSE_POINT_ALERT                                                   ((FIT_COURSE_POINT)52)
#define FIT_COURSE_POINT_INFO                                                    ((FIT_COURSE_POINT)53)
#define FIT_COURSE_POINT_COUNT                                                   53

typedef FIT_UINT16 FIT_MANUFACTURER;
#define FIT_MANUFACTURER_INVALID                                                 FIT_UINT16_INVALID
#define FIT_MANUFACTURER_GARMIN                                                  ((FIT_MANUFACTURER)1)
#define FIT_MANUFACTURER_GARMIN_FR405_ANTFS                                      ((FIT_MANUFACTURER)2) // Do not use. Used by FR405 for ANTFS man id.
#define FIT_MANUFACTURER_ZEPHYR                                                  ((FIT_MANUFACTURER)3)
#define FIT_MANUFACTURER_DAYTON                                                  ((FIT_MANUFACTURER)4)
#define FIT_MANUFACTURER_IDT                                                     ((FIT_MANUFACTURER)5)
#define FIT_MANUFACTURER_SRM                                                     ((FIT_MANUFACTURER)6)
#define FIT_MANUFACTURER_QUARQ                                                   ((FIT_MANUFACTURER)7)
#define FIT_MANUFACTURER_IBIKE                                                   ((FIT_MANUFACTURER)8)
#define FIT_MANUFACTURER_SARIS                                                   ((FIT_MANUFACTURER)9)
#define FIT_MANUFACTURER_SPARK_HK                                                ((FIT_MANUFACTURER)10)
#define FIT_MANUFACTURER_TANITA                                                  ((FIT_MANUFACTURER)11)
#define FIT_MANUFACTURER_ECHOWELL                                                ((FIT_MANUFACTURER)12)
#define FIT_MANUFACTURER_DYNASTREAM_OEM                                          ((FIT_MANUFACTURER)13)
#define FIT_MANUFACTURER_NAUTILUS                                                ((FIT_MANUFACTURER)14)
#define FIT_MANUFACTURER_DYNASTREAM                                              ((FIT_MANUFACTURER)15)
#define FIT_MANUFACTURER_TIMEX                                                   ((FIT_MANUFACTURER)16)
#define FIT_MANUFACTURER_METRIGEAR                                               ((FIT_MANUFACTURER)17)
#define FIT_MANUFACTURER_XELIC                                                   ((FIT_MANUFACTURER)18)
#define FIT_MANUFACTURER_BEURER                                                  ((FIT_MANUFACTURER)19)
#define FIT_MANUFACTURER_CARDIOSPORT                                             ((FIT_MANUFACTURER)20)
#define FIT_MANUFACTURER_A_AND_D                                                 ((FIT_MANUFACTURER)21)
#define FIT_MANUFACTURER_HMM                                                     ((FIT_MANUFACTURER)22)
#define FIT_MANUFACTURER_SUUNTO                                                  ((FIT_MANUFACTURER)23)
#define FIT_MANUFACTURER_THITA_ELEKTRONIK                                        ((FIT_MANUFACTURER)24)
#define FIT_MANUFACTURER_GPULSE                                                  ((FIT_MANUFACTURER)25)
#define FIT_MANUFACTURER_CLEAN_MOBILE                                            ((FIT_MANUFACTURER)26)
#define FIT_MANUFACTURER_PEDAL_BRAIN                                             ((FIT_MANUFACTURER)27)
#define FIT_MANUFACTURER_PEAKSWARE                                               ((FIT_MANUFACTURER)28)
#define FIT_MANUFACTURER_SAXONAR                                                 ((FIT_MANUFACTURER)29)
#define FIT_MANUFACTURER_LEMOND_FITNESS                                          ((FIT_MANUFACTURER)30)
#define FIT_MANUFACTURER_DEXCOM                                                  ((FIT_MANUFACTURER)31)
#define FIT_MANUFACTURER_WAHOO_FITNESS                                           ((FIT_MANUFACTURER)32)
#define FIT_MANUFACTURER_OCTANE_FITNESS                                          ((FIT_MANUFACTURER)33)
#define FIT_MANUFACTURER_ARCHINOETICS                                            ((FIT_MANUFACTURER)34)
#define FIT_MANUFACTURER_THE_HURT_BOX                                            ((FIT_MANUFACTURER)35)
#define FIT_MANUFACTURER_CITIZEN_SYSTEMS                                         ((FIT_MANUFACTURER)36)
#define FIT_MANUFACTURER_MAGELLAN                                                ((FIT_MANUFACTURER)37)
#define FIT_MANUFACTURER_OSYNCE                                                  ((FIT_MANUFACTURER)38)
#define FIT_MANUFACTURER_HOLUX                                                   ((FIT_MANUFACTURER)39)
#define FIT_MANUFACTURER_CONCEPT2                                                ((FIT_MANUFACTURER)40)
#define FIT_MANUFACTURER_SHIMANO                                                 ((FIT_MANUFACTURER)41)
#define FIT_MANUFACTURER_ONE_GIANT_LEAP                                          ((FIT_MANUFACTURER)42)
#define FIT_MANUFACTURER_ACE_SENSOR                                              ((FIT_MANUFACTURER)43)
#define FIT_MANUFACTURER_BRIM_BROTHERS                                           ((FIT_MANUFACTURER)44)
#define FIT_MANUFACTURER_XPLOVA                                                  ((FIT_MANUFACTURER)45)
#define FIT_MANUFACTURER_PERCEPTION_DIGITAL                                      ((FIT_MANUFACTURER)46)
#define FIT_MANUFACTURER_BF1SYSTEMS                                              ((FIT_MANUFACTURER)47)
#define FIT_MANUFACTURER_PIONEER                                                 ((FIT_MANUFACTURER)48)
#define FIT_MANUFACTURER_SPANTEC                                                 ((FIT_MANUFACTURER)49)
#define FIT_MANUFACTURER_METALOGICS                                              ((FIT_MANUFACTURER)50)
#define FIT_MANUFACTURER_4IIIIS                                                  ((FIT_MANUFACTURER)51)
#define FIT_MANUFACTURER_SEIKO_EPSON                                             ((FIT_MANUFACTURER)52)
#define FIT_MANUFACTURER_SEIKO_EPSON_OEM                                         ((FIT_MANUFACTURER)53)
#define FIT_MANUFACTURER_IFOR_POWELL                                             ((FIT_MANUFACTURER)54)
#define FIT_MANUFACTURER_MAXWELL_GUIDER                                          ((FIT_MANUFACTURER)55)
#define FIT_MANUFACTURER_STAR_TRAC                                               ((FIT_MANUFACTURER)56)
#define FIT_MANUFACTURER_BREAKAWAY                                               ((FIT_MANUFACTURER)57)
#define FIT_MANUFACTURER_ALATECH_TECHNOLOGY_LTD                                  ((FIT_MANUFACTURER)58)
#define FIT_MANUFACTURER_MIO_TECHNOLOGY_EUROPE                                   ((FIT_MANUFACTURER)59)
#define FIT_MANUFACTURER_ROTOR                                                   ((FIT_MANUFACTURER)60)
#define FIT_MANUFACTURER_GEONAUTE                                                ((FIT_MANUFACTURER)61)
#define FIT_MANUFACTURER_ID_BIKE                                                 ((FIT_MANUFACTURER)62)
#define FIT_MANUFACTURER_SPECIALIZED                                             ((FIT_MANUFACTURER)63)
#define FIT_MANUFACTURER_WTEK                                                    ((FIT_MANUFACTURER)64)
#define FIT_MANUFACTURER_PHYSICAL_ENTERPRISES                                    ((FIT_MANUFACTURER)65)
#define FIT_MANUFACTURER_NORTH_POLE_ENGINEERING                                  ((FIT_MANUFACTURER)66)
#define FIT_MANUFACTURER_BKOOL                                                   ((FIT_MANUFACTURER)67)
#define FIT_MANUFACTURER_CATEYE                                                  ((FIT_MANUFACTURER)68)
#define FIT_MANUFACTURER_STAGES_CYCLING                                          ((FIT_MANUFACTURER)69)
#define FIT_MANUFACTURER_SIGMASPORT                                              ((FIT_MANUFACTURER)70)
#define FIT_MANUFACTURER_TOMTOM                                                  ((FIT_MANUFACTURER)71)
#define FIT_MANUFACTURER_PERIPEDAL                                               ((FIT_MANUFACTURER)72)
#define FIT_MANUFACTURER_WATTBIKE                                                ((FIT_MANUFACTURER)73)
#define FIT_MANUFACTURER_MOXY                                                    ((FIT_MANUFACTURER)76)
#define FIT_MANUFACTURER_CICLOSPORT                                              ((FIT_MANUFACTURER)77)
#define FIT_MANUFACTURER_POWERBAHN                                               ((FIT_MANUFACTURER)78)
#define FIT_MANUFACTURER_ACORN_PROJECTS_APS                                      ((FIT_MANUFACTURER)79)
#define FIT_MANUFACTURER_LIFEBEAM                                                ((FIT_MANUFACTURER)80)
#define FIT_MANUFACTURER_BONTRAGER                                               ((FIT_MANUFACTURER)81)
#define FIT_MANUFACTURER_WELLGO                                                  ((FIT_MANUFACTURER)82)
#define FIT_MANUFACTURER_SCOSCHE                                                 ((FIT_MANUFACTURER)83)
#define FIT_MANUFACTURER_MAGURA                                                  ((FIT_MANUFACTURER)84)
#define FIT_MANUFACTURER_WOODWAY                                                 ((FIT_MANUFACTURER)85)
#define FIT_MANUFACTURER_ELITE                                                   ((FIT_MANUFACTURER)86)
#define FIT_MANUFACTURER_NIELSEN_KELLERMAN                                       ((FIT_MANUFACTURER)87)
#define FIT_MANUFACTURER_DK_CITY                                                 ((FIT_MANUFACTURER)88)
#define FIT_MANUFACTURER_TACX                                                    ((FIT_MANUFACTURER)89)
#define FIT_MANUFACTURER_DIRECTION_TECHNOLOGY                                    ((FIT_MANUFACTURER)90)
#define FIT_MANUFACTURER_MAGTONIC                                                ((FIT_MANUFACTURER)91)
#define FIT_MANUFACTURER_1PARTCARBON                                             ((FIT_MANUFACTURER)92)
#define FIT_MANUFACTURER_INSIDE_RIDE_TECHNOLOGIES                                ((FIT_MANUFACTURER)93)
#define FIT_MANUFACTURER_SOUND_OF_MOTION                                         ((FIT_MANUFACTURER)94)
#define FIT_MANUFACTURER_STRYD                                                   ((FIT_MANUFACTURER)95)
#define FIT_MANUFACTURER_ICG                                                     ((FIT_MANUFACTURER)96) // Indoorcycling Group
#define FIT_MANUFACTURER_MIPULSE                                                 ((FIT_MANUFACTURER)97)
#define FIT_MANUFACTURER_BSX_ATHLETICS                                           ((FIT_MANUFACTURER)98)
#define FIT_MANUFACTURER_LOOK                                                    ((FIT_MANUFACTURER)99)
#define FIT_MANUFACTURER_CAMPAGNOLO_SRL                                          ((FIT_MANUFACTURER)100)
#define FIT_MANUFACTURER_BODY_BIKE_SMART                                         ((FIT_MANUFACTURER)101)
#define FIT_MANUFACTURER_PRAXISWORKS                                             ((FIT_MANUFACTURER)102)
#define FIT_MANUFACTURER_LIMITS_TECHNOLOGY                                       ((FIT_MANUFACTURER)103) // Limits Technology Ltd.
#define FIT_MANUFACTURER_TOPACTION_TECHNOLOGY                                    ((FIT_MANUFACTURER)104) // TopAction Technology Inc.
#define FIT_MANUFACTURER_COSINUSS                                                ((FIT_MANUFACTURER)105)
#define FIT_MANUFACTURER_FITCARE                                                 ((FIT_MANUFACTURER)106)
#define FIT_MANUFACTURER_MAGENE                                                  ((FIT_MANUFACTURER)107)
#define FIT_MANUFACTURER_GIANT_MANUFACTURING_CO                                  ((FIT_MANUFACTURER)108)
#define FIT_MANUFACTURER_TIGRASPORT                                              ((FIT_MANUFACTURER)109) // Tigrasport
#define FIT_MANUFACTURER_SALUTRON                                                ((FIT_MANUFACTURER)110)
#define FIT_MANUFACTURER_TECHNOGYM                                               ((FIT_MANUFACTURER)111)
#define FIT_MANUFACTURER_BRYTON_SENSORS                                          ((FIT_MANUFACTURER)112)
#define FIT_MANUFACTURER_LATITUDE_LIMITED                                        ((FIT_MANUFACTURER)113)
#define FIT_MANUFACTURER_SOARING_TECHNOLOGY                                      ((FIT_MANUFACTURER)114)
#define FIT_MANUFACTURER_IGPSPORT                                                ((FIT_MANUFACTURER)115)
#define FIT_MANUFACTURER_THINKRIDER                                              ((FIT_MANUFACTURER)116)
#define FIT_MANUFACTURER_GOPHER_SPORT                                            ((FIT_MANUFACTURER)117)
#define FIT_MANUFACTURER_WATERROWER                                              ((FIT_MANUFACTURER)118)
#define FIT_MANUFACTURER_ORANGETHEORY                                            ((FIT_MANUFACTURER)119)
#define FIT_MANUFACTURER_INPEAK                                                  ((FIT_MANUFACTURER)120)
#define FIT_MANUFACTURER_KINETIC                                                 ((FIT_MANUFACTURER)121)
#define FIT_MANUFACTURER_JOHNSON_HEALTH_TECH                                     ((FIT_MANUFACTURER)122)
#define FIT_MANUFACTURER_POLAR_ELECTRO                                           ((FIT_MANUFACTURER)123)
#define FIT_MANUFACTURER_SEESENSE                                                ((FIT_MANUFACTURER)124)
#define FIT_MANUFACTURER_NCI_TECHNOLOGY                                          ((FIT_MANUFACTURER)125)
#define FIT_MANUFACTURER_IQSQUARE                                                ((FIT_MANUFACTURER)126)
#define FIT_MANUFACTURER_LEOMO                                                   ((FIT_MANUFACTURER)127)
#define FIT_MANUFACTURER_IFIT_COM                                                ((FIT_MANUFACTURER)128)
#define FIT_MANUFACTURER_COROS_BYTE                                              ((FIT_MANUFACTURER)129)
#define FIT_MANUFACTURER_VERSA_DESIGN                                            ((FIT_MANUFACTURER)130)
#define FIT_MANUFACTURER_CHILEAF                                                 ((FIT_MANUFACTURER)131)
#define FIT_MANUFACTURER_CYCPLUS                                                 ((FIT_MANUFACTURER)132)
#define FIT_MANUFACTURER_GRAVAA_BYTE                                             ((FIT_MANUFACTURER)133)
#define FIT_MANUFACTURER_SIGEYI                                                  ((FIT_MANUFACTURER)134)
#define FIT_MANUFACTURER_COOSPO                                                  ((FIT_MANUFACTURER)135)
#define FIT_MANUFACTURER_GEOID                                                   ((FIT_MANUFACTURER)136)
#define FIT_MANUFACTURER_BOSCH                                                   ((FIT_MANUFACTURER)137)
#define FIT_MANUFACTURER_KYTO                                                    ((FIT_MANUFACTURER)138)
#define FIT_MANUFACTURER_KINETIC_SPORTS                                          ((FIT_MANUFACTURER)139)
#define FIT_MANUFACTURER_DECATHLON_BYTE                                          ((FIT_MANUFACTURER)140)
#define FIT_MANUFACTURER_TQ_SYSTEMS                                              ((FIT_MANUFACTURER)141)
#define FIT_MANUFACTURER_TAG_HEUER                                               ((FIT_MANUFACTURER)142)
#define FIT_MANUFACTURER_KEISER_FITNESS                                          ((FIT_MANUFACTURER)143)
#define FIT_MANUFACTURER_ZWIFT_BYTE                                              ((FIT_MANUFACTURER)144)
#define FIT_MANUFACTURER_PORSCHE_EP                                              ((FIT_MANUFACTURER)145)
#define FIT_MANUFACTURER_BLACKBIRD                                               ((FIT_MANUFACTURER)146)
#define FIT_MANUFACTURER_MEILAN_BYTE                                             ((FIT_MANUFACTURER)147)
#define FIT_MANUFACTURER_EZON                                                    ((FIT_MANUFACTURER)148)
#define FIT_MANUFACTURER_LAISI                                                   ((FIT_MANUFACTURER)149)
#define FIT_MANUFACTURER_MYZONE                                                  ((FIT_MANUFACTURER)150)
#define FIT_MANUFACTURER_ABAWO                                                   ((FIT_MANUFACTURER)151)
#define FIT_MANUFACTURER_BAFANG                                                  ((FIT_MANUFACTURER)152)
#define FIT_MANUFACTURER_DEVELOPMENT                                             ((FIT_MANUFACTURER)255)
#define FIT_MANUFACTURER_HEALTHANDLIFE                                           ((FIT_MANUFACTURER)257)
#define FIT_MANUFACTURER_LEZYNE                                                  ((FIT_MANUFACTURER)258)
#define FIT_MANUFACTURER_SCRIBE_LABS                                             ((FIT_MANUFACTURER)259)
#define FIT_MANUFACTURER_ZWIFT                                                   ((FIT_MANUFACTURER)260)
#define FIT_MANUFACTURER_WATTEAM                                                 ((FIT_MANUFACTURER)261)
#define FIT_MANUFACTURER_RECON                                                   ((FIT_MANUFACTURER)262)
#define FIT_MANUFACTURER_FAVERO_ELECTRONICS                                      ((FIT_MANUFACTURER)263)
#define FIT_MANUFACTURER_DYNOVELO                                                ((FIT_MANUFACTURER)264)
#define FIT_MANUFACTURER_STRAVA                                                  ((FIT_MANUFACTURER)265)
#define FIT_MANUFACTURER_PRECOR                                                  ((FIT_MANUFACTURER)266) // Amer Sports
#define FIT_MANUFACTURER_BRYTON                                                  ((FIT_MANUFACTURER)267)
#define FIT_MANUFACTURER_SRAM                                                    ((FIT_MANUFACTURER)268)
#define FIT_MANUFACTURER_NAVMAN                                                  ((FIT_MANUFACTURER)269) // MiTAC Global Corporation (Mio Technology)
#define FIT_MANUFACTURER_COBI                                                    ((FIT_MANUFACTURER)270) // COBI GmbH
#define FIT_MANUFACTURER_SPIVI                                                   ((FIT_MANUFACTURER)271)
#define FIT_MANUFACTURER_MIO_MAGELLAN                                            ((FIT_MANUFACTURER)272)
#define FIT_MANUFACTURER_EVESPORTS                                               ((FIT_MANUFACTURER)273)
#define FIT_MANUFACTURER_SENSITIVUS_GAUGE                                        ((FIT_MANUFACTURER)274)
#define FIT_MANUFACTURER_PODOON                                                  ((FIT_MANUFACTURER)275)
#define FIT_MANUFACTURER_LIFE_TIME_FITNESS                                       ((FIT_MANUFACTURER)276)
#define FIT_MANUFACTURER_FALCO_E_MOTORS                                          ((FIT_MANUFACTURER)277) // Falco eMotors Inc.
#define FIT_MANUFACTURER_MINOURA                                                 ((FIT_MANUFACTURER)278)
#define FIT_MANUFACTURER_CYCLIQ                                                  ((FIT_MANUFACTURER)279)
#define FIT_MANUFACTURER_LUXOTTICA                                               ((FIT_MANUFACTURER)280)
#define FIT_MANUFACTURER_TRAINER_ROAD                                            ((FIT_MANUFACTURER)281)
#define FIT_MANUFACTURER_THE_SUFFERFEST                                          ((FIT_MANUFACTURER)282)
#define FIT_MANUFACTURER_FULLSPEEDAHEAD                                          ((FIT_MANUFACTURER)283)
#define FIT_MANUFACTURER_VIRTUALTRAINING                                         ((FIT_MANUFACTURER)284)
#define FIT_MANUFACTURER_FEEDBACKSPORTS                                          ((FIT_MANUFACTURER)285)
#define FIT_MANUFACTURER_OMATA                                                   ((FIT_MANUFACTURER)286)
#define FIT_MANUFACTURER_VDO                                                     ((FIT_MANUFACTURER)287)
#define FIT_MANUFACTURER_MAGNETICDAYS                                            ((FIT_MANUFACTURER)288)
#define FIT_MANUFACTURER_HAMMERHEAD                                              ((FIT_MANUFACTURER)289)
#define FIT_MANUFACTURER_KINETIC_BY_KURT                                         ((FIT_MANUFACTURER)290)
#define FIT_MANUFACTURER_SHAPELOG                                                ((FIT_MANUFACTURER)291)
#define FIT_MANUFACTURER_DABUZIDUO                                               ((FIT_MANUFACTURER)292)
#define FIT_MANUFACTURER_JETBLACK                                                ((FIT_MANUFACTURER)293)
#define FIT_MANUFACTURER_COROS                                                   ((FIT_MANUFACTURER)294)
#define FIT_MANUFACTURER_VIRTUGO                                                 ((FIT_MANUFACTURER)295)
#define FIT_MANUFACTURER_VELOSENSE                                               ((FIT_MANUFACTURER)296)
#define FIT_MANUFACTURER_CYCLIGENTINC                                            ((FIT_MANUFACTURER)297)
#define FIT_MANUFACTURER_TRAILFORKS                                              ((FIT_MANUFACTURER)298)
#define FIT_MANUFACTURER_MAHLE_EBIKEMOTION                                       ((FIT_MANUFACTURER)299)
#define FIT_MANUFACTURER_NURVV                                                   ((FIT_MANUFACTURER)300)
#define FIT_MANUFACTURER_MICROPROGRAM                                            ((FIT_MANUFACTURER)301)
#define FIT_MANUFACTURER_ZONE5CLOUD                                              ((FIT_MANUFACTURER)302)
#define FIT_MANUFACTURER_GREENTEG                                                ((FIT_MANUFACTURER)303)
#define FIT_MANUFACTURER_YAMAHA_MOTORS                                           ((FIT_MANUFACTURER)304)
#define FIT_MANUFACTURER_WHOOP                                                   ((FIT_MANUFACTURER)305)
#define FIT_MANUFACTURER_GRAVAA                                                  ((FIT_MANUFACTURER)306)
#define FIT_MANUFACTURER_ONELAP                                                  ((FIT_MANUFACTURER)307)
#define FIT_MANUFACTURER_MONARK_EXERCISE                                         ((FIT_MANUFACTURER)308)
#define FIT_MANUFACTURER_FORM                                                    ((FIT_MANUFACTURER)309)
#define FIT_MANUFACTURER_DECATHLON                                               ((FIT_MANUFACTURER)310)
#define FIT_MANUFACTURER_SYNCROS                                                 ((FIT_MANUFACTURER)311)
#define FIT_MANUFACTURER_HEATUP                                                  ((FIT_MANUFACTURER)312)
#define FIT_MANUFACTURER_CANNONDALE                                              ((FIT_MANUFACTURER)313)
#define FIT_MANUFACTURER_TRUE_FITNESS                                            ((FIT_MANUFACTURER)314)
#define FIT_MANUFACTURER_RGT_CYCLING                                             ((FIT_MANUFACTURER)315)
#define FIT_MANUFACTURER_VASA                                                    ((FIT_MANUFACTURER)316)
#define FIT_MANUFACTURER_RACE_REPUBLIC                                           ((FIT_MANUFACTURER)317)
#define FIT_MANUFACTURER_FAZUA                                                   ((FIT_MANUFACTURER)318)
#define FIT_MANUFACTURER_OREKA_TRAINING                                          ((FIT_MANUFACTURER)319)
#define FIT_MANUFACTURER_LSEC                                                    ((FIT_MANUFACTURER)320) // Lishun Electric & Communication
#define FIT_MANUFACTURER_LULULEMON_STUDIO                                        ((FIT_MANUFACTURER)321)
#define FIT_MANUFACTURER_SHANYUE                                                 ((FIT_MANUFACTURER)322)
#define FIT_MANUFACTURER_SPINNING_MDA                                            ((FIT_MANUFACTURER)323)
#define FIT_MANUFACTURER_HILLDATING                                              ((FIT_MANUFACTURER)324)
#define FIT_MANUFACTURER_AERO_SENSOR                                             ((FIT_MANUFACTURER)325)
#define FIT_MANUFACTURER_NIKE                                                    ((FIT_MANUFACTURER)326)
#define FIT_MANUFACTURER_MAGICSHINE                                              ((FIT_MANUFACTURER)327)
#define FIT_MANUFACTURER_ICTRAINER                                               ((FIT_MANUFACTURER)328)
#define FIT_MANUFACTURER_ABSOLUTE_CYCLING                                        ((FIT_MANUFACTURER)329)
#define FIT_MANUFACTURER_EO_SWIMBETTER                                           ((FIT_MANUFACTURER)330)
#define FIT_MANUFACTURER_MYWHOOSH                                                ((FIT_MANUFACTURER)331)
#define FIT_MANUFACTURER_RAVEMEN                                                 ((FIT_MANUFACTURER)332)
#define FIT_MANUFACTURER_ACTIGRAPHCORP                                           ((FIT_MANUFACTURER)5759)
#define FIT_MANUFACTURER_COUNT                                                   228

typedef FIT_UINT16 FIT_GARMIN_PRODUCT;
#define FIT_GARMIN_PRODUCT_INVALID                                               FIT_UINT16_INVALID
#define FIT_GARMIN_PRODUCT_HRM1                                                  ((FIT_GARMIN_PRODUCT)1)
#define FIT_GARMIN_PRODUCT_AXH01                                                 ((FIT_GARMIN_PRODUCT)2) // AXH01 HRM chipset
#define FIT_GARMIN_PRODUCT_AXB01                                                 ((FIT_GARMIN_PRODUCT)3)
#define FIT_GARMIN_PRODUCT_AXB02                                                 ((FIT_GARMIN_PRODUCT)4)
#define FIT_GARMIN_PRODUCT_HRM2SS                                                ((FIT_GARMIN_PRODUCT)5)
#define FIT_GARMIN_PRODUCT_DSI_ALF02                                             ((FIT_GARMIN_PRODUCT)6)
#define FIT_GARMIN_PRODUCT_HRM3SS                                                ((FIT_GARMIN_PRODUCT)7)
#define FIT_GARMIN_PRODUCT_HRM_RUN_SINGLE_BYTE_PRODUCT_ID                        ((FIT_GARMIN_PRODUCT)8) // hrm_run model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_BSM                                                   ((FIT_GARMIN_PRODUCT)9) // BSM model for ANT+ messaging
#define FIT_GARMIN_PRODUCT_BCM                                                   ((FIT_GARMIN_PRODUCT)10) // BCM model for ANT+ messaging
#define FIT_GARMIN_PRODUCT_AXS01                                                 ((FIT_GARMIN_PRODUCT)11) // AXS01 HRM Bike Chipset model for ANT+ messaging
#define FIT_GARMIN_PRODUCT_HRM_TRI_SINGLE_BYTE_PRODUCT_ID                        ((FIT_GARMIN_PRODUCT)12) // hrm_tri model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_HRM4_RUN_SINGLE_BYTE_PRODUCT_ID                       ((FIT_GARMIN_PRODUCT)13) // hrm4 run model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_FR225_SINGLE_BYTE_PRODUCT_ID                          ((FIT_GARMIN_PRODUCT)14) // fr225 model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_GEN3_BSM_SINGLE_BYTE_PRODUCT_ID                       ((FIT_GARMIN_PRODUCT)15) // gen3_bsm model for Bike Speed ANT+ messaging
#define FIT_GARMIN_PRODUCT_GEN3_BCM_SINGLE_BYTE_PRODUCT_ID                       ((FIT_GARMIN_PRODUCT)16) // gen3_bcm model for Bike Cadence ANT+ messaging
#define FIT_GARMIN_PRODUCT_HRM_FIT_SINGLE_BYTE_PRODUCT_ID                        ((FIT_GARMIN_PRODUCT)22)
#define FIT_GARMIN_PRODUCT_OHR                                                   ((FIT_GARMIN_PRODUCT)255) // Garmin Wearable Optical Heart Rate Sensor for ANT+ HR Profile Broadcasting
#define FIT_GARMIN_PRODUCT_FR301_CHINA                                           ((FIT_GARMIN_PRODUCT)473)
#define FIT_GARMIN_PRODUCT_FR301_JAPAN                                           ((FIT_GARMIN_PRODUCT)474)
#define FIT_GARMIN_PRODUCT_FR301_KOREA                                           ((FIT_GARMIN_PRODUCT)475)
#define FIT_GARMIN_PRODUCT_FR301_TAIWAN                                          ((FIT_GARMIN_PRODUCT)494)
#define FIT_GARMIN_PRODUCT_FR405                                                 ((FIT_GARMIN_PRODUCT)717) // Forerunner 405
#define FIT_GARMIN_PRODUCT_FR50                                                  ((FIT_GARMIN_PRODUCT)782) // Forerunner 50
#define FIT_GARMIN_PRODUCT_FR405_JAPAN                                           ((FIT_GARMIN_PRODUCT)987)
#define FIT_GARMIN_PRODUCT_FR60                                                  ((FIT_GARMIN_PRODUCT)988) // Forerunner 60
#define FIT_GARMIN_PRODUCT_DSI_ALF01                                             ((FIT_GARMIN_PRODUCT)1011)
#define FIT_GARMIN_PRODUCT_FR310XT                                               ((FIT_GARMIN_PRODUCT)1018) // Forerunner 310
#define FIT_GARMIN_PRODUCT_EDGE500                                               ((FIT_GARMIN_PRODUCT)1036)
#define FIT_GARMIN_PRODUCT_FR110                                                 ((FIT_GARMIN_PRODUCT)1124) // Forerunner 110
#define FIT_GARMIN_PRODUCT_EDGE800                                               ((FIT_GARMIN_PRODUCT)1169)
#define FIT_GARMIN_PRODUCT_EDGE500_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1199)
#define FIT_GARMIN_PRODUCT_EDGE500_JAPAN                                         ((FIT_GARMIN_PRODUCT)1213)
#define FIT_GARMIN_PRODUCT_CHIRP                                                 ((FIT_GARMIN_PRODUCT)1253)
#define FIT_GARMIN_PRODUCT_FR110_JAPAN                                           ((FIT_GARMIN_PRODUCT)1274)
#define FIT_GARMIN_PRODUCT_EDGE200                                               ((FIT_GARMIN_PRODUCT)1325)
#define FIT_GARMIN_PRODUCT_FR910XT                                               ((FIT_GARMIN_PRODUCT)1328)
#define FIT_GARMIN_PRODUCT_EDGE800_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1333)
#define FIT_GARMIN_PRODUCT_EDGE800_JAPAN                                         ((FIT_GARMIN_PRODUCT)1334)
#define FIT_GARMIN_PRODUCT_ALF04                                                 ((FIT_GARMIN_PRODUCT)1341)
#define FIT_GARMIN_PRODUCT_FR610                                                 ((FIT_GARMIN_PRODUCT)1345)
#define FIT_GARMIN_PRODUCT_FR210_JAPAN                                           ((FIT_GARMIN_PRODUCT)1360)
#define FIT_GARMIN_PRODUCT_VECTOR_SS                                             ((FIT_GARMIN_PRODUCT)1380)
#define FIT_GARMIN_PRODUCT_VECTOR_CP                                             ((FIT_GARMIN_PRODUCT)1381)
#define FIT_GARMIN_PRODUCT_EDGE800_CHINA                                         ((FIT_GARMIN_PRODUCT)1386)
#define FIT_GARMIN_PRODUCT_EDGE500_CHINA                                         ((FIT_GARMIN_PRODUCT)1387)
#define FIT_GARMIN_PRODUCT_APPROACH_G10                                          ((FIT_GARMIN_PRODUCT)1405)
#define FIT_GARMIN_PRODUCT_FR610_JAPAN                                           ((FIT_GARMIN_PRODUCT)1410)
#define FIT_GARMIN_PRODUCT_EDGE500_KOREA                                         ((FIT_GARMIN_PRODUCT)1422)
#define FIT_GARMIN_PRODUCT_FR70                                                  ((FIT_GARMIN_PRODUCT)1436)
#define FIT_GARMIN_PRODUCT_FR310XT_4T                                            ((FIT_GARMIN_PRODUCT)1446)
#define FIT_GARMIN_PRODUCT_AMX                                                   ((FIT_GARMIN_PRODUCT)1461)
#define FIT_GARMIN_PRODUCT_FR10                                                  ((FIT_GARMIN_PRODUCT)1482)
#define FIT_GARMIN_PRODUCT_EDGE800_KOREA                                         ((FIT_GARMIN_PRODUCT)1497)
#define FIT_GARMIN_PRODUCT_SWIM                                                  ((FIT_GARMIN_PRODUCT)1499)
#define FIT_GARMIN_PRODUCT_FR910XT_CHINA                                         ((FIT_GARMIN_PRODUCT)1537)
#define FIT_GARMIN_PRODUCT_FENIX                                                 ((FIT_GARMIN_PRODUCT)1551)
#define FIT_GARMIN_PRODUCT_EDGE200_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1555)
#define FIT_GARMIN_PRODUCT_EDGE510                                               ((FIT_GARMIN_PRODUCT)1561)
#define FIT_GARMIN_PRODUCT_EDGE810                                               ((FIT_GARMIN_PRODUCT)1567)
#define FIT_GARMIN_PRODUCT_TEMPE                                                 ((FIT_GARMIN_PRODUCT)1570)
#define FIT_GARMIN_PRODUCT_FR910XT_JAPAN                                         ((FIT_GARMIN_PRODUCT)1600)
#define FIT_GARMIN_PRODUCT_FR620                                                 ((FIT_GARMIN_PRODUCT)1623)
#define FIT_GARMIN_PRODUCT_FR220                                                 ((FIT_GARMIN_PRODUCT)1632)
#define FIT_GARMIN_PRODUCT_FR910XT_KOREA                                         ((FIT_GARMIN_PRODUCT)1664)
#define FIT_GARMIN_PRODUCT_FR10_JAPAN                                            ((FIT_GARMIN_PRODUCT)1688)
#define FIT_GARMIN_PRODUCT_EDGE810_JAPAN                                         ((FIT_GARMIN_PRODUCT)1721)
#define FIT_GARMIN_PRODUCT_VIRB_ELITE                                            ((FIT_GARMIN_PRODUCT)1735)
#define FIT_GARMIN_PRODUCT_EDGE_TOURING                                          ((FIT_GARMIN_PRODUCT)1736) // Also Edge Touring Plus
#define FIT_GARMIN_PRODUCT_EDGE510_JAPAN                                         ((FIT_GARMIN_PRODUCT)1742)
#define FIT_GARMIN_PRODUCT_HRM_TRI                                               ((FIT_GARMIN_PRODUCT)1743) // Also HRM-Swim
#define FIT_GARMIN_PRODUCT_HRM_RUN                                               ((FIT_GARMIN_PRODUCT)1752)
#define FIT_GARMIN_PRODUCT_FR920XT                                               ((FIT_GARMIN_PRODUCT)1765)
#define FIT_GARMIN_PRODUCT_EDGE510_ASIA                                          ((FIT_GARMIN_PRODUCT)1821)
#define FIT_GARMIN_PRODUCT_EDGE810_CHINA                                         ((FIT_GARMIN_PRODUCT)1822)
#define FIT_GARMIN_PRODUCT_EDGE810_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1823)
#define FIT_GARMIN_PRODUCT_EDGE1000                                              ((FIT_GARMIN_PRODUCT)1836)
#define FIT_GARMIN_PRODUCT_VIVO_FIT                                              ((FIT_GARMIN_PRODUCT)1837)
#define FIT_GARMIN_PRODUCT_VIRB_REMOTE                                           ((FIT_GARMIN_PRODUCT)1853)
#define FIT_GARMIN_PRODUCT_VIVO_KI                                               ((FIT_GARMIN_PRODUCT)1885)
#define FIT_GARMIN_PRODUCT_FR15                                                  ((FIT_GARMIN_PRODUCT)1903)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE                                           ((FIT_GARMIN_PRODUCT)1907)
#define FIT_GARMIN_PRODUCT_EDGE510_KOREA                                         ((FIT_GARMIN_PRODUCT)1918)
#define FIT_GARMIN_PRODUCT_FR620_JAPAN                                           ((FIT_GARMIN_PRODUCT)1928)
#define FIT_GARMIN_PRODUCT_FR620_CHINA                                           ((FIT_GARMIN_PRODUCT)1929)
#define FIT_GARMIN_PRODUCT_FR220_JAPAN                                           ((FIT_GARMIN_PRODUCT)1930)
#define FIT_GARMIN_PRODUCT_FR220_CHINA                                           ((FIT_GARMIN_PRODUCT)1931)
#define FIT_GARMIN_PRODUCT_APPROACH_S6                                           ((FIT_GARMIN_PRODUCT)1936)
#define FIT_GARMIN_PRODUCT_VIVO_SMART                                            ((FIT_GARMIN_PRODUCT)1956)
#define FIT_GARMIN_PRODUCT_FENIX2                                                ((FIT_GARMIN_PRODUCT)1967)
#define FIT_GARMIN_PRODUCT_EPIX                                                  ((FIT_GARMIN_PRODUCT)1988)
#define FIT_GARMIN_PRODUCT_FENIX3                                                ((FIT_GARMIN_PRODUCT)2050)
#define FIT_GARMIN_PRODUCT_EDGE1000_TAIWAN                                       ((FIT_GARMIN_PRODUCT)2052)
#define FIT_GARMIN_PRODUCT_EDGE1000_JAPAN                                        ((FIT_GARMIN_PRODUCT)2053)
#define FIT_GARMIN_PRODUCT_FR15_JAPAN                                            ((FIT_GARMIN_PRODUCT)2061)
#define FIT_GARMIN_PRODUCT_EDGE520                                               ((FIT_GARMIN_PRODUCT)2067)
#define FIT_GARMIN_PRODUCT_EDGE1000_CHINA                                        ((FIT_GARMIN_PRODUCT)2070)
#define FIT_GARMIN_PRODUCT_FR620_RUSSIA                                          ((FIT_GARMIN_PRODUCT)2072)
#define FIT_GARMIN_PRODUCT_FR220_RUSSIA                                          ((FIT_GARMIN_PRODUCT)2073)
#define FIT_GARMIN_PRODUCT_VECTOR_S                                              ((FIT_GARMIN_PRODUCT)2079)
#define FIT_GARMIN_PRODUCT_EDGE1000_KOREA                                        ((FIT_GARMIN_PRODUCT)2100)
#define FIT_GARMIN_PRODUCT_FR920XT_TAIWAN                                        ((FIT_GARMIN_PRODUCT)2130)
#define FIT_GARMIN_PRODUCT_FR920XT_CHINA                                         ((FIT_GARMIN_PRODUCT)2131)
#define FIT_GARMIN_PRODUCT_FR920XT_JAPAN                                         ((FIT_GARMIN_PRODUCT)2132)
#define FIT_GARMIN_PRODUCT_VIRBX                                                 ((FIT_GARMIN_PRODUCT)2134)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_APAC                                       ((FIT_GARMIN_PRODUCT)2135)
#define FIT_GARMIN_PRODUCT_ETREX_TOUCH                                           ((FIT_GARMIN_PRODUCT)2140)
#define FIT_GARMIN_PRODUCT_EDGE25                                                ((FIT_GARMIN_PRODUCT)2147)
#define FIT_GARMIN_PRODUCT_FR25                                                  ((FIT_GARMIN_PRODUCT)2148)
#define FIT_GARMIN_PRODUCT_VIVO_FIT2                                             ((FIT_GARMIN_PRODUCT)2150)
#define FIT_GARMIN_PRODUCT_FR225                                                 ((FIT_GARMIN_PRODUCT)2153)
#define FIT_GARMIN_PRODUCT_FR630                                                 ((FIT_GARMIN_PRODUCT)2156)
#define FIT_GARMIN_PRODUCT_FR230                                                 ((FIT_GARMIN_PRODUCT)2157)
#define FIT_GARMIN_PRODUCT_FR735XT                                               ((FIT_GARMIN_PRODUCT)2158)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE_APAC                                      ((FIT_GARMIN_PRODUCT)2160)
#define FIT_GARMIN_PRODUCT_VECTOR_2                                              ((FIT_GARMIN_PRODUCT)2161)
#define FIT_GARMIN_PRODUCT_VECTOR_2S                                             ((FIT_GARMIN_PRODUCT)2162)
#define FIT_GARMIN_PRODUCT_VIRBXE                                                ((FIT_GARMIN_PRODUCT)2172)
#define FIT_GARMIN_PRODUCT_FR620_TAIWAN                                          ((FIT_GARMIN_PRODUCT)2173)
#define FIT_GARMIN_PRODUCT_FR220_TAIWAN                                          ((FIT_GARMIN_PRODUCT)2174)
#define FIT_GARMIN_PRODUCT_TRUSWING                                              ((FIT_GARMIN_PRODUCT)2175)
#define FIT_GARMIN_PRODUCT_D2AIRVENU                                             ((FIT_GARMIN_PRODUCT)2187)
#define FIT_GARMIN_PRODUCT_FENIX3_CHINA                                          ((FIT_GARMIN_PRODUCT)2188)
#define FIT_GARMIN_PRODUCT_FENIX3_TWN                                            ((FIT_GARMIN_PRODUCT)2189)
#define FIT_GARMIN_PRODUCT_VARIA_HEADLIGHT                                       ((FIT_GARMIN_PRODUCT)2192)
#define FIT_GARMIN_PRODUCT_VARIA_TAILLIGHT_OLD                                   ((FIT_GARMIN_PRODUCT)2193)
#define FIT_GARMIN_PRODUCT_EDGE_EXPLORE_1000                                     ((FIT_GARMIN_PRODUCT)2204)
#define FIT_GARMIN_PRODUCT_FR225_ASIA                                            ((FIT_GARMIN_PRODUCT)2219)
#define FIT_GARMIN_PRODUCT_VARIA_RADAR_TAILLIGHT                                 ((FIT_GARMIN_PRODUCT)2225)
#define FIT_GARMIN_PRODUCT_VARIA_RADAR_DISPLAY                                   ((FIT_GARMIN_PRODUCT)2226)
#define FIT_GARMIN_PRODUCT_EDGE20                                                ((FIT_GARMIN_PRODUCT)2238)
#define FIT_GARMIN_PRODUCT_EDGE520_ASIA                                          ((FIT_GARMIN_PRODUCT)2260)
#define FIT_GARMIN_PRODUCT_EDGE520_JAPAN                                         ((FIT_GARMIN_PRODUCT)2261)
#define FIT_GARMIN_PRODUCT_D2_BRAVO                                              ((FIT_GARMIN_PRODUCT)2262)
#define FIT_GARMIN_PRODUCT_APPROACH_S20                                          ((FIT_GARMIN_PRODUCT)2266)
#define FIT_GARMIN_PRODUCT_VIVO_SMART2                                           ((FIT_GARMIN_PRODUCT)2271)
#define FIT_GARMIN_PRODUCT_EDGE1000_THAI                                         ((FIT_GARMIN_PRODUCT)2274)
#define FIT_GARMIN_PRODUCT_VARIA_REMOTE                                          ((FIT_GARMIN_PRODUCT)2276)
#define FIT_GARMIN_PRODUCT_EDGE25_ASIA                                           ((FIT_GARMIN_PRODUCT)2288)
#define FIT_GARMIN_PRODUCT_EDGE25_JPN                                            ((FIT_GARMIN_PRODUCT)2289)
#define FIT_GARMIN_PRODUCT_EDGE20_ASIA                                           ((FIT_GARMIN_PRODUCT)2290)
#define FIT_GARMIN_PRODUCT_APPROACH_X40                                          ((FIT_GARMIN_PRODUCT)2292)
#define FIT_GARMIN_PRODUCT_FENIX3_JAPAN                                          ((FIT_GARMIN_PRODUCT)2293)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_EMEA                                       ((FIT_GARMIN_PRODUCT)2294)
#define FIT_GARMIN_PRODUCT_FR630_ASIA                                            ((FIT_GARMIN_PRODUCT)2310)
#define FIT_GARMIN_PRODUCT_FR630_JPN                                             ((FIT_GARMIN_PRODUCT)2311)
#define FIT_GARMIN_PRODUCT_FR230_JPN                                             ((FIT_GARMIN_PRODUCT)2313)
#define FIT_GARMIN_PRODUCT_HRM4_RUN                                              ((FIT_GARMIN_PRODUCT)2327)
#define FIT_GARMIN_PRODUCT_EPIX_JAPAN                                            ((FIT_GARMIN_PRODUCT)2332)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE_HR                                        ((FIT_GARMIN_PRODUCT)2337)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_GPS_HR                                     ((FIT_GARMIN_PRODUCT)2347)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_HR                                         ((FIT_GARMIN_PRODUCT)2348)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_HR_ASIA                                    ((FIT_GARMIN_PRODUCT)2361)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_GPS_HR_ASIA                                ((FIT_GARMIN_PRODUCT)2362)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE                                             ((FIT_GARMIN_PRODUCT)2368)
#define FIT_GARMIN_PRODUCT_VARIA_TAILLIGHT                                       ((FIT_GARMIN_PRODUCT)2379)
#define FIT_GARMIN_PRODUCT_FR235_ASIA                                            ((FIT_GARMIN_PRODUCT)2396)
#define FIT_GARMIN_PRODUCT_FR235_JAPAN                                           ((FIT_GARMIN_PRODUCT)2397)
#define FIT_GARMIN_PRODUCT_VARIA_VISION                                          ((FIT_GARMIN_PRODUCT)2398)
#define FIT_GARMIN_PRODUCT_VIVO_FIT3                                             ((FIT_GARMIN_PRODUCT)2406)
#define FIT_GARMIN_PRODUCT_FENIX3_KOREA                                          ((FIT_GARMIN_PRODUCT)2407)
#define FIT_GARMIN_PRODUCT_FENIX3_SEA                                            ((FIT_GARMIN_PRODUCT)2408)
#define FIT_GARMIN_PRODUCT_FENIX3_HR                                             ((FIT_GARMIN_PRODUCT)2413)
#define FIT_GARMIN_PRODUCT_VIRB_ULTRA_30                                         ((FIT_GARMIN_PRODUCT)2417)
#define FIT_GARMIN_PRODUCT_INDEX_SMART_SCALE                                     ((FIT_GARMIN_PRODUCT)2429)
#define FIT_GARMIN_PRODUCT_FR235                                                 ((FIT_GARMIN_PRODUCT)2431)
#define FIT_GARMIN_PRODUCT_FENIX3_CHRONOS                                        ((FIT_GARMIN_PRODUCT)2432)
#define FIT_GARMIN_PRODUCT_OREGON7XX                                             ((FIT_GARMIN_PRODUCT)2441)
#define FIT_GARMIN_PRODUCT_RINO7XX                                               ((FIT_GARMIN_PRODUCT)2444)
#define FIT_GARMIN_PRODUCT_EPIX_KOREA                                            ((FIT_GARMIN_PRODUCT)2457)
#define FIT_GARMIN_PRODUCT_FENIX3_HR_CHN                                         ((FIT_GARMIN_PRODUCT)2473)
#define FIT_GARMIN_PRODUCT_FENIX3_HR_TWN                                         ((FIT_GARMIN_PRODUCT)2474)
#define FIT_GARMIN_PRODUCT_FENIX3_HR_JPN                                         ((FIT_GARMIN_PRODUCT)2475)
#define FIT_GARMIN_PRODUCT_FENIX3_HR_SEA                                         ((FIT_GARMIN_PRODUCT)2476)
#define FIT_GARMIN_PRODUCT_FENIX3_HR_KOR                                         ((FIT_GARMIN_PRODUCT)2477)
#define FIT_GARMIN_PRODUCT_NAUTIX                                                ((FIT_GARMIN_PRODUCT)2496)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE_HR_APAC                                   ((FIT_GARMIN_PRODUCT)2497)
#define FIT_GARMIN_PRODUCT_FR35                                                  ((FIT_GARMIN_PRODUCT)2503)
#define FIT_GARMIN_PRODUCT_OREGON7XX_WW                                          ((FIT_GARMIN_PRODUCT)2512)
#define FIT_GARMIN_PRODUCT_EDGE_820                                              ((FIT_GARMIN_PRODUCT)2530)
#define FIT_GARMIN_PRODUCT_EDGE_EXPLORE_820                                      ((FIT_GARMIN_PRODUCT)2531)
#define FIT_GARMIN_PRODUCT_FR735XT_APAC                                          ((FIT_GARMIN_PRODUCT)2533)
#define FIT_GARMIN_PRODUCT_FR735XT_JAPAN                                         ((FIT_GARMIN_PRODUCT)2534)
#define FIT_GARMIN_PRODUCT_FENIX5S                                               ((FIT_GARMIN_PRODUCT)2544)
#define FIT_GARMIN_PRODUCT_D2_BRAVO_TITANIUM                                     ((FIT_GARMIN_PRODUCT)2547)
#define FIT_GARMIN_PRODUCT_VARIA_UT800                                           ((FIT_GARMIN_PRODUCT)2567) // Varia UT 800 SW
#define FIT_GARMIN_PRODUCT_RUNNING_DYNAMICS_POD                                  ((FIT_GARMIN_PRODUCT)2593)
#define FIT_GARMIN_PRODUCT_EDGE_820_CHINA                                        ((FIT_GARMIN_PRODUCT)2599)
#define FIT_GARMIN_PRODUCT_EDGE_820_JAPAN                                        ((FIT_GARMIN_PRODUCT)2600)
#define FIT_GARMIN_PRODUCT_FENIX5X                                               ((FIT_GARMIN_PRODUCT)2604)
#define FIT_GARMIN_PRODUCT_VIVO_FIT_JR                                           ((FIT_GARMIN_PRODUCT)2606)
#define FIT_GARMIN_PRODUCT_VIVO_SMART3                                           ((FIT_GARMIN_PRODUCT)2622)
#define FIT_GARMIN_PRODUCT_VIVO_SPORT                                            ((FIT_GARMIN_PRODUCT)2623)
#define FIT_GARMIN_PRODUCT_EDGE_820_TAIWAN                                       ((FIT_GARMIN_PRODUCT)2628)
#define FIT_GARMIN_PRODUCT_EDGE_820_KOREA                                        ((FIT_GARMIN_PRODUCT)2629)
#define FIT_GARMIN_PRODUCT_EDGE_820_SEA                                          ((FIT_GARMIN_PRODUCT)2630)
#define FIT_GARMIN_PRODUCT_FR35_HEBREW                                           ((FIT_GARMIN_PRODUCT)2650)
#define FIT_GARMIN_PRODUCT_APPROACH_S60                                          ((FIT_GARMIN_PRODUCT)2656)
#define FIT_GARMIN_PRODUCT_FR35_APAC                                             ((FIT_GARMIN_PRODUCT)2667)
#define FIT_GARMIN_PRODUCT_FR35_JAPAN                                            ((FIT_GARMIN_PRODUCT)2668)
#define FIT_GARMIN_PRODUCT_FENIX3_CHRONOS_ASIA                                   ((FIT_GARMIN_PRODUCT)2675)
#define FIT_GARMIN_PRODUCT_VIRB_360                                              ((FIT_GARMIN_PRODUCT)2687)
#define FIT_GARMIN_PRODUCT_FR935                                                 ((FIT_GARMIN_PRODUCT)2691)
#define FIT_GARMIN_PRODUCT_FENIX5                                                ((FIT_GARMIN_PRODUCT)2697)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE3                                           ((FIT_GARMIN_PRODUCT)2700)
#define FIT_GARMIN_PRODUCT_FR235_CHINA_NFC                                       ((FIT_GARMIN_PRODUCT)2733)
#define FIT_GARMIN_PRODUCT_FORETREX_601_701                                      ((FIT_GARMIN_PRODUCT)2769)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE_HR                                          ((FIT_GARMIN_PRODUCT)2772)
#define FIT_GARMIN_PRODUCT_EDGE_1030                                             ((FIT_GARMIN_PRODUCT)2713)
#define FIT_GARMIN_PRODUCT_FR35_SEA                                              ((FIT_GARMIN_PRODUCT)2727)
#define FIT_GARMIN_PRODUCT_VECTOR_3                                              ((FIT_GARMIN_PRODUCT)2787)
#define FIT_GARMIN_PRODUCT_FENIX5_ASIA                                           ((FIT_GARMIN_PRODUCT)2796)
#define FIT_GARMIN_PRODUCT_FENIX5S_ASIA                                          ((FIT_GARMIN_PRODUCT)2797)
#define FIT_GARMIN_PRODUCT_FENIX5X_ASIA                                          ((FIT_GARMIN_PRODUCT)2798)
#define FIT_GARMIN_PRODUCT_APPROACH_Z80                                          ((FIT_GARMIN_PRODUCT)2806)
#define FIT_GARMIN_PRODUCT_FR35_KOREA                                            ((FIT_GARMIN_PRODUCT)2814)
#define FIT_GARMIN_PRODUCT_D2CHARLIE                                             ((FIT_GARMIN_PRODUCT)2819)
#define FIT_GARMIN_PRODUCT_VIVO_SMART3_APAC                                      ((FIT_GARMIN_PRODUCT)2831)
#define FIT_GARMIN_PRODUCT_VIVO_SPORT_APAC                                       ((FIT_GARMIN_PRODUCT)2832)
#define FIT_GARMIN_PRODUCT_FR935_ASIA                                            ((FIT_GARMIN_PRODUCT)2833)
#define FIT_GARMIN_PRODUCT_DESCENT                                               ((FIT_GARMIN_PRODUCT)2859)
#define FIT_GARMIN_PRODUCT_VIVO_FIT4                                             ((FIT_GARMIN_PRODUCT)2878)
#define FIT_GARMIN_PRODUCT_FR645                                                 ((FIT_GARMIN_PRODUCT)2886)
#define FIT_GARMIN_PRODUCT_FR645M                                                ((FIT_GARMIN_PRODUCT)2888)
#define FIT_GARMIN_PRODUCT_FR30                                                  ((FIT_GARMIN_PRODUCT)2891)
#define FIT_GARMIN_PRODUCT_FENIX5S_PLUS                                          ((FIT_GARMIN_PRODUCT)2900)
#define FIT_GARMIN_PRODUCT_EDGE_130                                              ((FIT_GARMIN_PRODUCT)2909)
#define FIT_GARMIN_PRODUCT_EDGE_1030_ASIA                                        ((FIT_GARMIN_PRODUCT)2924)
#define FIT_GARMIN_PRODUCT_VIVOSMART_4                                           ((FIT_GARMIN_PRODUCT)2927)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE_HR_ASIA                                     ((FIT_GARMIN_PRODUCT)2945)
#define FIT_GARMIN_PRODUCT_APPROACH_X10                                          ((FIT_GARMIN_PRODUCT)2962)
#define FIT_GARMIN_PRODUCT_FR30_ASIA                                             ((FIT_GARMIN_PRODUCT)2977)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE3M_W                                        ((FIT_GARMIN_PRODUCT)2988)
#define FIT_GARMIN_PRODUCT_FR645_ASIA                                            ((FIT_GARMIN_PRODUCT)3003)
#define FIT_GARMIN_PRODUCT_FR645M_ASIA                                           ((FIT_GARMIN_PRODUCT)3004)
#define FIT_GARMIN_PRODUCT_EDGE_EXPLORE                                          ((FIT_GARMIN_PRODUCT)3011)
#define FIT_GARMIN_PRODUCT_GPSMAP66                                              ((FIT_GARMIN_PRODUCT)3028)
#define FIT_GARMIN_PRODUCT_APPROACH_S10                                          ((FIT_GARMIN_PRODUCT)3049)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE3M_L                                        ((FIT_GARMIN_PRODUCT)3066)
#define FIT_GARMIN_PRODUCT_APPROACH_G80                                          ((FIT_GARMIN_PRODUCT)3085)
#define FIT_GARMIN_PRODUCT_EDGE_130_ASIA                                         ((FIT_GARMIN_PRODUCT)3092)
#define FIT_GARMIN_PRODUCT_EDGE_1030_BONTRAGER                                   ((FIT_GARMIN_PRODUCT)3095)
#define FIT_GARMIN_PRODUCT_FENIX5_PLUS                                           ((FIT_GARMIN_PRODUCT)3110)
#define FIT_GARMIN_PRODUCT_FENIX5X_PLUS                                          ((FIT_GARMIN_PRODUCT)3111)
#define FIT_GARMIN_PRODUCT_EDGE_520_PLUS                                         ((FIT_GARMIN_PRODUCT)3112)
#define FIT_GARMIN_PRODUCT_FR945                                                 ((FIT_GARMIN_PRODUCT)3113)
#define FIT_GARMIN_PRODUCT_EDGE_530                                              ((FIT_GARMIN_PRODUCT)3121)
#define FIT_GARMIN_PRODUCT_EDGE_830                                              ((FIT_GARMIN_PRODUCT)3122)
#define FIT_GARMIN_PRODUCT_INSTINCT_ESPORTS                                      ((FIT_GARMIN_PRODUCT)3126)
#define FIT_GARMIN_PRODUCT_FENIX5S_PLUS_APAC                                     ((FIT_GARMIN_PRODUCT)3134)
#define FIT_GARMIN_PRODUCT_FENIX5X_PLUS_APAC                                     ((FIT_GARMIN_PRODUCT)3135)
#define FIT_GARMIN_PRODUCT_EDGE_520_PLUS_APAC                                    ((FIT_GARMIN_PRODUCT)3142)
#define FIT_GARMIN_PRODUCT_DESCENT_T1                                            ((FIT_GARMIN_PRODUCT)3143)
#define FIT_GARMIN_PRODUCT_FR235L_ASIA                                           ((FIT_GARMIN_PRODUCT)3144)
#define FIT_GARMIN_PRODUCT_FR245_ASIA                                            ((FIT_GARMIN_PRODUCT)3145)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE3M_APAC                                    ((FIT_GARMIN_PRODUCT)3163)
#define FIT_GARMIN_PRODUCT_GEN3_BSM                                              ((FIT_GARMIN_PRODUCT)3192) // gen3 bike speed sensor
#define FIT_GARMIN_PRODUCT_GEN3_BCM                                              ((FIT_GARMIN_PRODUCT)3193) // gen3 bike cadence sensor
#define FIT_GARMIN_PRODUCT_VIVO_SMART4_ASIA                                      ((FIT_GARMIN_PRODUCT)3218)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE4_SMALL                                     ((FIT_GARMIN_PRODUCT)3224)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE4_LARGE                                     ((FIT_GARMIN_PRODUCT)3225)
#define FIT_GARMIN_PRODUCT_VENU                                                  ((FIT_GARMIN_PRODUCT)3226)
#define FIT_GARMIN_PRODUCT_MARQ_DRIVER                                           ((FIT_GARMIN_PRODUCT)3246)
#define FIT_GARMIN_PRODUCT_MARQ_AVIATOR                                          ((FIT_GARMIN_PRODUCT)3247)
#define FIT_GARMIN_PRODUCT_MARQ_CAPTAIN                                          ((FIT_GARMIN_PRODUCT)3248)
#define FIT_GARMIN_PRODUCT_MARQ_COMMANDER                                        ((FIT_GARMIN_PRODUCT)3249)
#define FIT_GARMIN_PRODUCT_MARQ_EXPEDITION                                       ((FIT_GARMIN_PRODUCT)3250)
#define FIT_GARMIN_PRODUCT_MARQ_ATHLETE                                          ((FIT_GARMIN_PRODUCT)3251)
#define FIT_GARMIN_PRODUCT_DESCENT_MK2                                           ((FIT_GARMIN_PRODUCT)3258)
#define FIT_GARMIN_PRODUCT_GPSMAP66I                                             ((FIT_GARMIN_PRODUCT)3284)
#define FIT_GARMIN_PRODUCT_FENIX6S_SPORT                                         ((FIT_GARMIN_PRODUCT)3287)
#define FIT_GARMIN_PRODUCT_FENIX6S                                               ((FIT_GARMIN_PRODUCT)3288)
#define FIT_GARMIN_PRODUCT_FENIX6_SPORT                                          ((FIT_GARMIN_PRODUCT)3289)
#define FIT_GARMIN_PRODUCT_FENIX6                                                ((FIT_GARMIN_PRODUCT)3290)
#define FIT_GARMIN_PRODUCT_FENIX6X                                               ((FIT_GARMIN_PRODUCT)3291)
#define FIT_GARMIN_PRODUCT_HRM_DUAL                                              ((FIT_GARMIN_PRODUCT)3299) // HRM-Dual
#define FIT_GARMIN_PRODUCT_HRM_PRO                                               ((FIT_GARMIN_PRODUCT)3300) // HRM-Pro
#define FIT_GARMIN_PRODUCT_VIVO_MOVE3_PREMIUM                                    ((FIT_GARMIN_PRODUCT)3308)
#define FIT_GARMIN_PRODUCT_APPROACH_S40                                          ((FIT_GARMIN_PRODUCT)3314)
#define FIT_GARMIN_PRODUCT_FR245M_ASIA                                           ((FIT_GARMIN_PRODUCT)3321)
#define FIT_GARMIN_PRODUCT_EDGE_530_APAC                                         ((FIT_GARMIN_PRODUCT)3349)
#define FIT_GARMIN_PRODUCT_EDGE_830_APAC                                         ((FIT_GARMIN_PRODUCT)3350)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE3                                            ((FIT_GARMIN_PRODUCT)3378)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE4_SMALL_ASIA                               ((FIT_GARMIN_PRODUCT)3387)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE4_LARGE_ASIA                               ((FIT_GARMIN_PRODUCT)3388)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE4_OLED_ASIA                                ((FIT_GARMIN_PRODUCT)3389)
#define FIT_GARMIN_PRODUCT_SWIM2                                                 ((FIT_GARMIN_PRODUCT)3405)
#define FIT_GARMIN_PRODUCT_MARQ_DRIVER_ASIA                                      ((FIT_GARMIN_PRODUCT)3420)
#define FIT_GARMIN_PRODUCT_MARQ_AVIATOR_ASIA                                     ((FIT_GARMIN_PRODUCT)3421)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE3_ASIA                                       ((FIT_GARMIN_PRODUCT)3422)
#define FIT_GARMIN_PRODUCT_FR945_ASIA                                            ((FIT_GARMIN_PRODUCT)3441)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE3T_CHN                                     ((FIT_GARMIN_PRODUCT)3446)
#define FIT_GARMIN_PRODUCT_MARQ_CAPTAIN_ASIA                                     ((FIT_GARMIN_PRODUCT)3448)
#define FIT_GARMIN_PRODUCT_MARQ_COMMANDER_ASIA                                   ((FIT_GARMIN_PRODUCT)3449)
#define FIT_GARMIN_PRODUCT_MARQ_EXPEDITION_ASIA                                  ((FIT_GARMIN_PRODUCT)3450)
#define FIT_GARMIN_PRODUCT_MARQ_ATHLETE_ASIA                                     ((FIT_GARMIN_PRODUCT)3451)
#define FIT_GARMIN_PRODUCT_INDEX_SMART_SCALE_2                                   ((FIT_GARMIN_PRODUCT)3461)
#define FIT_GARMIN_PRODUCT_INSTINCT_SOLAR                                        ((FIT_GARMIN_PRODUCT)3466)
#define FIT_GARMIN_PRODUCT_FR45_ASIA                                             ((FIT_GARMIN_PRODUCT)3469)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE3_DAIMLER                                   ((FIT_GARMIN_PRODUCT)3473)
#define FIT_GARMIN_PRODUCT_LEGACY_REY                                            ((FIT_GARMIN_PRODUCT)3498)
#define FIT_GARMIN_PRODUCT_LEGACY_DARTH_VADER                                    ((FIT_GARMIN_PRODUCT)3499)
#define FIT_GARMIN_PRODUCT_LEGACY_CAPTAIN_MARVEL                                 ((FIT_GARMIN_PRODUCT)3500)
#define FIT_GARMIN_PRODUCT_LEGACY_FIRST_AVENGER                                  ((FIT_GARMIN_PRODUCT)3501)
#define FIT_GARMIN_PRODUCT_FENIX6S_SPORT_ASIA                                    ((FIT_GARMIN_PRODUCT)3512)
#define FIT_GARMIN_PRODUCT_FENIX6S_ASIA                                          ((FIT_GARMIN_PRODUCT)3513)
#define FIT_GARMIN_PRODUCT_FENIX6_SPORT_ASIA                                     ((FIT_GARMIN_PRODUCT)3514)
#define FIT_GARMIN_PRODUCT_FENIX6_ASIA                                           ((FIT_GARMIN_PRODUCT)3515)
#define FIT_GARMIN_PRODUCT_FENIX6X_ASIA                                          ((FIT_GARMIN_PRODUCT)3516)
#define FIT_GARMIN_PRODUCT_LEGACY_CAPTAIN_MARVEL_ASIA                            ((FIT_GARMIN_PRODUCT)3535)
#define FIT_GARMIN_PRODUCT_LEGACY_FIRST_AVENGER_ASIA                             ((FIT_GARMIN_PRODUCT)3536)
#define FIT_GARMIN_PRODUCT_LEGACY_REY_ASIA                                       ((FIT_GARMIN_PRODUCT)3537)
#define FIT_GARMIN_PRODUCT_LEGACY_DARTH_VADER_ASIA                               ((FIT_GARMIN_PRODUCT)3538)
#define FIT_GARMIN_PRODUCT_DESCENT_MK2S                                          ((FIT_GARMIN_PRODUCT)3542)
#define FIT_GARMIN_PRODUCT_EDGE_130_PLUS                                         ((FIT_GARMIN_PRODUCT)3558)
#define FIT_GARMIN_PRODUCT_EDGE_1030_PLUS                                        ((FIT_GARMIN_PRODUCT)3570)
#define FIT_GARMIN_PRODUCT_RALLY_200                                             ((FIT_GARMIN_PRODUCT)3578) // Rally 100/200 Power Meter Series
#define FIT_GARMIN_PRODUCT_FR745                                                 ((FIT_GARMIN_PRODUCT)3589)
#define FIT_GARMIN_PRODUCT_VENUSQ                                                ((FIT_GARMIN_PRODUCT)3600)
#define FIT_GARMIN_PRODUCT_LILY                                                  ((FIT_GARMIN_PRODUCT)3615)
#define FIT_GARMIN_PRODUCT_MARQ_ADVENTURER                                       ((FIT_GARMIN_PRODUCT)3624)
#define FIT_GARMIN_PRODUCT_ENDURO                                                ((FIT_GARMIN_PRODUCT)3638)
#define FIT_GARMIN_PRODUCT_SWIM2_APAC                                            ((FIT_GARMIN_PRODUCT)3639)
#define FIT_GARMIN_PRODUCT_MARQ_ADVENTURER_ASIA                                  ((FIT_GARMIN_PRODUCT)3648)
#define FIT_GARMIN_PRODUCT_FR945_LTE                                             ((FIT_GARMIN_PRODUCT)3652)
#define FIT_GARMIN_PRODUCT_DESCENT_MK2_ASIA                                      ((FIT_GARMIN_PRODUCT)3702) // Mk2 and Mk2i
#define FIT_GARMIN_PRODUCT_VENU2                                                 ((FIT_GARMIN_PRODUCT)3703)
#define FIT_GARMIN_PRODUCT_VENU2S                                                ((FIT_GARMIN_PRODUCT)3704)
#define FIT_GARMIN_PRODUCT_VENU_DAIMLER_ASIA                                     ((FIT_GARMIN_PRODUCT)3737)
#define FIT_GARMIN_PRODUCT_MARQ_GOLFER                                           ((FIT_GARMIN_PRODUCT)3739)
#define FIT_GARMIN_PRODUCT_VENU_DAIMLER                                          ((FIT_GARMIN_PRODUCT)3740)
#define FIT_GARMIN_PRODUCT_FR745_ASIA                                            ((FIT_GARMIN_PRODUCT)3794)
#define FIT_GARMIN_PRODUCT_VARIA_RCT715                                          ((FIT_GARMIN_PRODUCT)3808)
#define FIT_GARMIN_PRODUCT_LILY_ASIA                                             ((FIT_GARMIN_PRODUCT)3809)
#define FIT_GARMIN_PRODUCT_EDGE_1030_PLUS_ASIA                                   ((FIT_GARMIN_PRODUCT)3812)
#define FIT_GARMIN_PRODUCT_EDGE_130_PLUS_ASIA                                    ((FIT_GARMIN_PRODUCT)3813)
#define FIT_GARMIN_PRODUCT_APPROACH_S12                                          ((FIT_GARMIN_PRODUCT)3823)
#define FIT_GARMIN_PRODUCT_ENDURO_ASIA                                           ((FIT_GARMIN_PRODUCT)3872)
#define FIT_GARMIN_PRODUCT_VENUSQ_ASIA                                           ((FIT_GARMIN_PRODUCT)3837)
#define FIT_GARMIN_PRODUCT_EDGE_1040                                             ((FIT_GARMIN_PRODUCT)3843)
#define FIT_GARMIN_PRODUCT_MARQ_GOLFER_ASIA                                      ((FIT_GARMIN_PRODUCT)3850)
#define FIT_GARMIN_PRODUCT_VENU2_PLUS                                            ((FIT_GARMIN_PRODUCT)3851)
#define FIT_GARMIN_PRODUCT_GNSS                                                  ((FIT_GARMIN_PRODUCT)3865)
#define FIT_GARMIN_PRODUCT_FR55                                                  ((FIT_GARMIN_PRODUCT)3869)
#define FIT_GARMIN_PRODUCT_INSTINCT_2                                            ((FIT_GARMIN_PRODUCT)3888)
#define FIT_GARMIN_PRODUCT_FENIX7S                                               ((FIT_GARMIN_PRODUCT)3905)
#define FIT_GARMIN_PRODUCT_FENIX7                                                ((FIT_GARMIN_PRODUCT)3906)
#define FIT_GARMIN_PRODUCT_FENIX7X                                               ((FIT_GARMIN_PRODUCT)3907)
#define FIT_GARMIN_PRODUCT_FENIX7S_APAC                                          ((FIT_GARMIN_PRODUCT)3908)
#define FIT_GARMIN_PRODUCT_FENIX7_APAC                                           ((FIT_GARMIN_PRODUCT)3909)
#define FIT_GARMIN_PRODUCT_FENIX7X_APAC                                          ((FIT_GARMIN_PRODUCT)3910)
#define FIT_GARMIN_PRODUCT_APPROACH_G12                                          ((FIT_GARMIN_PRODUCT) 3927)
#define FIT_GARMIN_PRODUCT_DESCENT_MK2S_ASIA                                     ((FIT_GARMIN_PRODUCT)3930)
#define FIT_GARMIN_PRODUCT_APPROACH_S42                                          ((FIT_GARMIN_PRODUCT)3934)
#define FIT_GARMIN_PRODUCT_EPIX_GEN2                                             ((FIT_GARMIN_PRODUCT)3943)
#define FIT_GARMIN_PRODUCT_EPIX_GEN2_APAC                                        ((FIT_GARMIN_PRODUCT)3944)
#define FIT_GARMIN_PRODUCT_VENU2S_ASIA                                           ((FIT_GARMIN_PRODUCT)3949)
#define FIT_GARMIN_PRODUCT_VENU2_ASIA                                            ((FIT_GARMIN_PRODUCT)3950)
#define FIT_GARMIN_PRODUCT_FR945_LTE_ASIA                                        ((FIT_GARMIN_PRODUCT)3978)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE_SPORT                                       ((FIT_GARMIN_PRODUCT)3982)
#define FIT_GARMIN_PRODUCT_VIVOMOVE_TREND                                        ((FIT_GARMIN_PRODUCT)3983)
#define FIT_GARMIN_PRODUCT_APPROACH_S12_ASIA                                     ((FIT_GARMIN_PRODUCT)3986)
#define FIT_GARMIN_PRODUCT_FR255_MUSIC                                           ((FIT_GARMIN_PRODUCT)3990)
#define FIT_GARMIN_PRODUCT_FR255_SMALL_MUSIC                                     ((FIT_GARMIN_PRODUCT)3991)
#define FIT_GARMIN_PRODUCT_FR255                                                 ((FIT_GARMIN_PRODUCT)3992)
#define FIT_GARMIN_PRODUCT_FR255_SMALL                                           ((FIT_GARMIN_PRODUCT)3993)
#define FIT_GARMIN_PRODUCT_APPROACH_G12_ASIA                                     ((FIT_GARMIN_PRODUCT) 4001)
#define FIT_GARMIN_PRODUCT_APPROACH_S42_ASIA                                     ((FIT_GARMIN_PRODUCT)4002)
#define FIT_GARMIN_PRODUCT_DESCENT_G1                                            ((FIT_GARMIN_PRODUCT)4005)
#define FIT_GARMIN_PRODUCT_VENU2_PLUS_ASIA                                       ((FIT_GARMIN_PRODUCT)4017)
#define FIT_GARMIN_PRODUCT_FR955                                                 ((FIT_GARMIN_PRODUCT)4024)
#define FIT_GARMIN_PRODUCT_FR55_ASIA                                             ((FIT_GARMIN_PRODUCT)4033)
#define FIT_GARMIN_PRODUCT_EDGE_540                                              ((FIT_GARMIN_PRODUCT)4061)
#define FIT_GARMIN_PRODUCT_EDGE_840                                              ((FIT_GARMIN_PRODUCT)4062)
#define FIT_GARMIN_PRODUCT_VIVOSMART_5                                           ((FIT_GARMIN_PRODUCT)4063)
#define FIT_GARMIN_PRODUCT_INSTINCT_2_ASIA                                       ((FIT_GARMIN_PRODUCT)4071)
#define FIT_GARMIN_PRODUCT_MARQ_GEN2                                             ((FIT_GARMIN_PRODUCT)4105) // Adventurer, Athlete, Captain, Golfer
#define FIT_GARMIN_PRODUCT_VENUSQ2                                               ((FIT_GARMIN_PRODUCT)4115)
#define FIT_GARMIN_PRODUCT_VENUSQ2MUSIC                                          ((FIT_GARMIN_PRODUCT)4116)
#define FIT_GARMIN_PRODUCT_MARQ_GEN2_AVIATOR                                     ((FIT_GARMIN_PRODUCT)4124)
#define FIT_GARMIN_PRODUCT_D2_AIR_X10                                            ((FIT_GARMIN_PRODUCT)4125)
#define FIT_GARMIN_PRODUCT_HRM_PRO_PLUS                                          ((FIT_GARMIN_PRODUCT)4130)
#define FIT_GARMIN_PRODUCT_DESCENT_G1_ASIA                                       ((FIT_GARMIN_PRODUCT)4132)
#define FIT_GARMIN_PRODUCT_TACTIX7                                               ((FIT_GARMIN_PRODUCT)4135)
#define FIT_GARMIN_PRODUCT_INSTINCT_CROSSOVER                                    ((FIT_GARMIN_PRODUCT)4155)
#define FIT_GARMIN_PRODUCT_EDGE_EXPLORE2                                         ((FIT_GARMIN_PRODUCT)4169)
#define FIT_GARMIN_PRODUCT_DESCENT_MK3                                           ((FIT_GARMIN_PRODUCT)4222)
#define FIT_GARMIN_PRODUCT_DESCENT_MK3I                                          ((FIT_GARMIN_PRODUCT)4223)
#define FIT_GARMIN_PRODUCT_APPROACH_S70                                          ((FIT_GARMIN_PRODUCT)4233)
#define FIT_GARMIN_PRODUCT_FR265_LARGE                                           ((FIT_GARMIN_PRODUCT)4257)
#define FIT_GARMIN_PRODUCT_FR265_SMALL                                           ((FIT_GARMIN_PRODUCT)4258)
#define FIT_GARMIN_PRODUCT_VENU3                                                 ((FIT_GARMIN_PRODUCT)4260)
#define FIT_GARMIN_PRODUCT_VENU3S                                                ((FIT_GARMIN_PRODUCT)4261)
#define FIT_GARMIN_PRODUCT_TACX_NEO_SMART                                        ((FIT_GARMIN_PRODUCT)4265) // Neo Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_NEO2_SMART                                       ((FIT_GARMIN_PRODUCT)4266) // Neo 2 Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_NEO2_T_SMART                                     ((FIT_GARMIN_PRODUCT)4267) // Neo 2T Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_NEO_SMART_BIKE                                   ((FIT_GARMIN_PRODUCT)4268) // Neo Smart Bike, Tacx
#define FIT_GARMIN_PRODUCT_TACX_SATORI_SMART                                     ((FIT_GARMIN_PRODUCT)4269) // Satori Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_FLOW_SMART                                       ((FIT_GARMIN_PRODUCT)4270) // Flow Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_VORTEX_SMART                                     ((FIT_GARMIN_PRODUCT)4271) // Vortex Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_BUSHIDO_SMART                                    ((FIT_GARMIN_PRODUCT)4272) // Bushido Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_GENIUS_SMART                                     ((FIT_GARMIN_PRODUCT)4273) // Genius Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_FLUX_FLUX_S_SMART                                ((FIT_GARMIN_PRODUCT)4274) // Flux/Flux S Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_FLUX2_SMART                                      ((FIT_GARMIN_PRODUCT)4275) // Flux 2 Smart, Tacx
#define FIT_GARMIN_PRODUCT_TACX_MAGNUM                                           ((FIT_GARMIN_PRODUCT)4276) // Magnum, Tacx
#define FIT_GARMIN_PRODUCT_EDGE_1040_ASIA                                        ((FIT_GARMIN_PRODUCT)4305)
#define FIT_GARMIN_PRODUCT_EPIX_GEN2_PRO_42                                      ((FIT_GARMIN_PRODUCT)4312)
#define FIT_GARMIN_PRODUCT_EPIX_GEN2_PRO_47                                      ((FIT_GARMIN_PRODUCT)4313)
#define FIT_GARMIN_PRODUCT_EPIX_GEN2_PRO_51                                      ((FIT_GARMIN_PRODUCT)4314)
#define FIT_GARMIN_PRODUCT_FR965                                                 ((FIT_GARMIN_PRODUCT)4315)
#define FIT_GARMIN_PRODUCT_ENDURO2                                               ((FIT_GARMIN_PRODUCT)4341)
#define FIT_GARMIN_PRODUCT_FENIX7S_PRO_SOLAR                                     ((FIT_GARMIN_PRODUCT)4374)
#define FIT_GARMIN_PRODUCT_FENIX7_PRO_SOLAR                                      ((FIT_GARMIN_PRODUCT)4375)
#define FIT_GARMIN_PRODUCT_FENIX7X_PRO_SOLAR                                     ((FIT_GARMIN_PRODUCT)4376)
#define FIT_GARMIN_PRODUCT_LILY2                                                 ((FIT_GARMIN_PRODUCT)4380)
#define FIT_GARMIN_PRODUCT_INSTINCT_2X                                           ((FIT_GARMIN_PRODUCT)4394)
#define FIT_GARMIN_PRODUCT_VIVOACTIVE5                                           ((FIT_GARMIN_PRODUCT)4426)
#define FIT_GARMIN_PRODUCT_FR165                                                 ((FIT_GARMIN_PRODUCT)4432)
#define FIT_GARMIN_PRODUCT_FR165_MUSIC                                           ((FIT_GARMIN_PRODUCT)4433)
#define FIT_GARMIN_PRODUCT_EDGE_1050                                             ((FIT_GARMIN_PRODUCT)4440)
#define FIT_GARMIN_PRODUCT_DESCENT_T2                                            ((FIT_GARMIN_PRODUCT)4442)
#define FIT_GARMIN_PRODUCT_HRM_FIT                                               ((FIT_GARMIN_PRODUCT)4446)
#define FIT_GARMIN_PRODUCT_MARQ_GEN2_COMMANDER                                   ((FIT_GARMIN_PRODUCT)4472)
#define FIT_GARMIN_PRODUCT_LILY_ATHLETE                                          ((FIT_GARMIN_PRODUCT)4477) // aka the Lily 2 Active
#define FIT_GARMIN_PRODUCT_FENIX8_SOLAR                                          ((FIT_GARMIN_PRODUCT)4532)
#define FIT_GARMIN_PRODUCT_FENIX8_SOLAR_LARGE                                    ((FIT_GARMIN_PRODUCT)4533)
#define FIT_GARMIN_PRODUCT_FENIX8_SMALL                                          ((FIT_GARMIN_PRODUCT)4534)
#define FIT_GARMIN_PRODUCT_FENIX8                                                ((FIT_GARMIN_PRODUCT)4536)
#define FIT_GARMIN_PRODUCT_D2_MACH1_PRO                                          ((FIT_GARMIN_PRODUCT)4556)
#define FIT_GARMIN_PRODUCT_ENDURO3                                               ((FIT_GARMIN_PRODUCT)4575)
#define FIT_GARMIN_PRODUCT_FENIX_E                                               ((FIT_GARMIN_PRODUCT)4666)
#define FIT_GARMIN_PRODUCT_SDM4                                                  ((FIT_GARMIN_PRODUCT)10007) // SDM4 footpod
#define FIT_GARMIN_PRODUCT_EDGE_REMOTE                                           ((FIT_GARMIN_PRODUCT)10014)
#define FIT_GARMIN_PRODUCT_TACX_TRAINING_APP_WIN                                 ((FIT_GARMIN_PRODUCT)20533)
#define FIT_GARMIN_PRODUCT_TACX_TRAINING_APP_MAC                                 ((FIT_GARMIN_PRODUCT)20534)
#define FIT_GARMIN_PRODUCT_TACX_TRAINING_APP_MAC_CATALYST                        ((FIT_GARMIN_PRODUCT)20565)
#define FIT_GARMIN_PRODUCT_TRAINING_CENTER                                       ((FIT_GARMIN_PRODUCT)20119)
#define FIT_GARMIN_PRODUCT_TACX_TRAINING_APP_ANDROID                             ((FIT_GARMIN_PRODUCT)30045)
#define FIT_GARMIN_PRODUCT_TACX_TRAINING_APP_IOS                                 ((FIT_GARMIN_PRODUCT)30046)
#define FIT_GARMIN_PRODUCT_TACX_TRAINING_APP_LEGACY                              ((FIT_GARMIN_PRODUCT)30047)
#define FIT_GARMIN_PRODUCT_CONNECTIQ_SIMULATOR                                   ((FIT_GARMIN_PRODUCT)65531)
#define FIT_GARMIN_PRODUCT_ANDROID_ANTPLUS_PLUGIN                                ((FIT_GARMIN_PRODUCT)65532)
#define FIT_GARMIN_PRODUCT_CONNECT                                               ((FIT_GARMIN_PRODUCT)65534) // Garmin Connect website
#define FIT_GARMIN_PRODUCT_COUNT                                                 443

typedef FIT_UINT8 FIT_ANTPLUS_DEVICE_TYPE;
#define FIT_ANTPLUS_DEVICE_TYPE_INVALID                                          FIT_UINT8_INVALID
#define FIT_ANTPLUS_DEVICE_TYPE_ANTFS                                            ((FIT_ANTPLUS_DEVICE_TYPE)1)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_POWER                                       ((FIT_ANTPLUS_DEVICE_TYPE)11)
#define FIT_ANTPLUS_DEVICE_TYPE_ENVIRONMENT_SENSOR_LEGACY                        ((FIT_ANTPLUS_DEVICE_TYPE)12)
#define FIT_ANTPLUS_DEVICE_TYPE_MULTI_SPORT_SPEED_DISTANCE                       ((FIT_ANTPLUS_DEVICE_TYPE)15)
#define FIT_ANTPLUS_DEVICE_TYPE_CONTROL                                          ((FIT_ANTPLUS_DEVICE_TYPE)16)
#define FIT_ANTPLUS_DEVICE_TYPE_FITNESS_EQUIPMENT                                ((FIT_ANTPLUS_DEVICE_TYPE)17)
#define FIT_ANTPLUS_DEVICE_TYPE_BLOOD_PRESSURE                                   ((FIT_ANTPLUS_DEVICE_TYPE)18)
#define FIT_ANTPLUS_DEVICE_TYPE_GEOCACHE_NODE                                    ((FIT_ANTPLUS_DEVICE_TYPE)19)
#define FIT_ANTPLUS_DEVICE_TYPE_LIGHT_ELECTRIC_VEHICLE                           ((FIT_ANTPLUS_DEVICE_TYPE)20)
#define FIT_ANTPLUS_DEVICE_TYPE_ENV_SENSOR                                       ((FIT_ANTPLUS_DEVICE_TYPE)25)
#define FIT_ANTPLUS_DEVICE_TYPE_RACQUET                                          ((FIT_ANTPLUS_DEVICE_TYPE)26)
#define FIT_ANTPLUS_DEVICE_TYPE_CONTROL_HUB                                      ((FIT_ANTPLUS_DEVICE_TYPE)27)
#define FIT_ANTPLUS_DEVICE_TYPE_MUSCLE_OXYGEN                                    ((FIT_ANTPLUS_DEVICE_TYPE)31)
#define FIT_ANTPLUS_DEVICE_TYPE_SHIFTING                                         ((FIT_ANTPLUS_DEVICE_TYPE)34)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_LIGHT_MAIN                                  ((FIT_ANTPLUS_DEVICE_TYPE)35)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_LIGHT_SHARED                                ((FIT_ANTPLUS_DEVICE_TYPE)36)
#define FIT_ANTPLUS_DEVICE_TYPE_EXD                                              ((FIT_ANTPLUS_DEVICE_TYPE)38)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_RADAR                                       ((FIT_ANTPLUS_DEVICE_TYPE)40)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_AERO                                        ((FIT_ANTPLUS_DEVICE_TYPE)46)
#define FIT_ANTPLUS_DEVICE_TYPE_WEIGHT_SCALE                                     ((FIT_ANTPLUS_DEVICE_TYPE)119)
#define FIT_ANTPLUS_DEVICE_TYPE_HEART_RATE                                       ((FIT_ANTPLUS_DEVICE_TYPE)120)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_SPEED_CADENCE                               ((FIT_ANTPLUS_DEVICE_TYPE)121)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_CADENCE                                     ((FIT_ANTPLUS_DEVICE_TYPE)122)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_SPEED                                       ((FIT_ANTPLUS_DEVICE_TYPE)123)
#define FIT_ANTPLUS_DEVICE_TYPE_STRIDE_SPEED_DISTANCE                            ((FIT_ANTPLUS_DEVICE_TYPE)124)
#define FIT_ANTPLUS_DEVICE_TYPE_COUNT                                            25

typedef FIT_ENUM FIT_ANT_NETWORK;
#define FIT_ANT_NETWORK_INVALID                                                  FIT_ENUM_INVALID
#define FIT_ANT_NETWORK_PUBLIC                                                   ((FIT_ANT_NETWORK)0)
#define FIT_ANT_NETWORK_ANTPLUS                                                  ((FIT_ANT_NETWORK)1)
#define FIT_ANT_NETWORK_ANTFS                                                    ((FIT_ANT_NETWORK)2)
#define FIT_ANT_NETWORK_PRIVATE                                                  ((FIT_ANT_NETWORK)3)
#define FIT_ANT_NETWORK_COUNT                                                    4

typedef FIT_UINT32Z FIT_WORKOUT_CAPABILITIES;
#define FIT_WORKOUT_CAPABILITIES_INVALID                                         FIT_UINT32Z_INVALID
#define FIT_WORKOUT_CAPABILITIES_INTERVAL                                        ((FIT_WORKOUT_CAPABILITIES)0x00000001)
#define FIT_WORKOUT_CAPABILITIES_CUSTOM                                          ((FIT_WORKOUT_CAPABILITIES)0x00000002)
#define FIT_WORKOUT_CAPABILITIES_FITNESS_EQUIPMENT                               ((FIT_WORKOUT_CAPABILITIES)0x00000004)
#define FIT_WORKOUT_CAPABILITIES_FIRSTBEAT                                       ((FIT_WORKOUT_CAPABILITIES)0x00000008)
#define FIT_WORKOUT_CAPABILITIES_NEW_LEAF                                        ((FIT_WORKOUT_CAPABILITIES)0x00000010)
#define FIT_WORKOUT_CAPABILITIES_TCX                                             ((FIT_WORKOUT_CAPABILITIES)0x00000020) // For backwards compatibility. Watch should add missing id fields then clear flag.
#define FIT_WORKOUT_CAPABILITIES_SPEED                                           ((FIT_WORKOUT_CAPABILITIES)0x00000080) // Speed source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_HEART_RATE                                      ((FIT_WORKOUT_CAPABILITIES)0x00000100) // Heart rate source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_DISTANCE                                        ((FIT_WORKOUT_CAPABILITIES)0x00000200) // Distance source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_CADENCE                                         ((FIT_WORKOUT_CAPABILITIES)0x00000400) // Cadence source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_POWER                                           ((FIT_WORKOUT_CAPABILITIES)0x00000800) // Power source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_GRADE                                           ((FIT_WORKOUT_CAPABILITIES)0x00001000) // Grade source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_RESISTANCE                                      ((FIT_WORKOUT_CAPABILITIES)0x00002000) // Resistance source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_PROTECTED                                       ((FIT_WORKOUT_CAPABILITIES)0x00004000)
#define FIT_WORKOUT_CAPABILITIES_COUNT                                           14

typedef FIT_UINT8 FIT_BATTERY_STATUS;
#define FIT_BATTERY_STATUS_INVALID                                               FIT_UINT8_INVALID
#define FIT_BATTERY_STATUS_NEW                                                   ((FIT_BATTERY_STATUS)1)
#define FIT_BATTERY_STATUS_GOOD                                                  ((FIT_BATTERY_STATUS)2)
#define FIT_BATTERY_STATUS_OK                                                    ((FIT_BATTERY_STATUS)3)
#define FIT_BATTERY_STATUS_LOW                                                   ((FIT_BATTERY_STATUS)4)
#define FIT_BATTERY_STATUS_CRITICAL                                              ((FIT_BATTERY_STATUS)5)
#define FIT_BATTERY_STATUS_CHARGING                                              ((FIT_BATTERY_STATUS)6)
#define FIT_BATTERY_STATUS_UNKNOWN                                               ((FIT_BATTERY_STATUS)7)
#define FIT_BATTERY_STATUS_COUNT                                                 7

typedef FIT_ENUM FIT_HR_TYPE;
#define FIT_HR_TYPE_INVALID                                                      FIT_ENUM_INVALID
#define FIT_HR_TYPE_NORMAL                                                       ((FIT_HR_TYPE)0)
#define FIT_HR_TYPE_IRREGULAR                                                    ((FIT_HR_TYPE)1)
#define FIT_HR_TYPE_COUNT                                                        2

typedef FIT_UINT32Z FIT_COURSE_CAPABILITIES;
#define FIT_COURSE_CAPABILITIES_INVALID                                          FIT_UINT32Z_INVALID
#define FIT_COURSE_CAPABILITIES_PROCESSED                                        ((FIT_COURSE_CAPABILITIES)0x00000001)
#define FIT_COURSE_CAPABILITIES_VALID                                            ((FIT_COURSE_CAPABILITIES)0x00000002)
#define FIT_COURSE_CAPABILITIES_TIME                                             ((FIT_COURSE_CAPABILITIES)0x00000004)
#define FIT_COURSE_CAPABILITIES_DISTANCE                                         ((FIT_COURSE_CAPABILITIES)0x00000008)
#define FIT_COURSE_CAPABILITIES_POSITION                                         ((FIT_COURSE_CAPABILITIES)0x00000010)
#define FIT_COURSE_CAPABILITIES_HEART_RATE                                       ((FIT_COURSE_CAPABILITIES)0x00000020)
#define FIT_COURSE_CAPABILITIES_POWER                                            ((FIT_COURSE_CAPABILITIES)0x00000040)
#define FIT_COURSE_CAPABILITIES_CADENCE                                          ((FIT_COURSE_CAPABILITIES)0x00000080)
#define FIT_COURSE_CAPABILITIES_TRAINING                                         ((FIT_COURSE_CAPABILITIES)0x00000100)
#define FIT_COURSE_CAPABILITIES_NAVIGATION                                       ((FIT_COURSE_CAPABILITIES)0x00000200)
#define FIT_COURSE_CAPABILITIES_BIKEWAY                                          ((FIT_COURSE_CAPABILITIES)0x00000400)
#define FIT_COURSE_CAPABILITIES_AVIATION                                         ((FIT_COURSE_CAPABILITIES)0x00001000) // Denote course files to be used as flight plans
#define FIT_COURSE_CAPABILITIES_COUNT                                            12

typedef FIT_UINT16 FIT_WEIGHT;
#define FIT_WEIGHT_INVALID                                                       FIT_UINT16_INVALID
#define FIT_WEIGHT_CALCULATING                                                   ((FIT_WEIGHT)0xFFFE)
#define FIT_WEIGHT_COUNT                                                         1

typedef FIT_UINT32 FIT_WORKOUT_HR; // 0 - 100 indicates% of max hr; >100 indicates bpm (255 max) plus 100
#define FIT_WORKOUT_HR_INVALID                                                   FIT_UINT32_INVALID
#define FIT_WORKOUT_HR_BPM_OFFSET                                                ((FIT_WORKOUT_HR)100)
#define FIT_WORKOUT_HR_COUNT                                                     1

typedef FIT_UINT32 FIT_WORKOUT_POWER; // 0 - 1000 indicates % of functional threshold power; >1000 indicates watts plus 1000.
#define FIT_WORKOUT_POWER_INVALID                                                FIT_UINT32_INVALID
#define FIT_WORKOUT_POWER_WATTS_OFFSET                                           ((FIT_WORKOUT_POWER)1000)
#define FIT_WORKOUT_POWER_COUNT                                                  1

typedef FIT_ENUM FIT_BP_STATUS;
#define FIT_BP_STATUS_INVALID                                                    FIT_ENUM_INVALID
#define FIT_BP_STATUS_NO_ERROR                                                   ((FIT_BP_STATUS)0)
#define FIT_BP_STATUS_ERROR_INCOMPLETE_DATA                                      ((FIT_BP_STATUS)1)
#define FIT_BP_STATUS_ERROR_NO_MEASUREMENT                                       ((FIT_BP_STATUS)2)
#define FIT_BP_STATUS_ERROR_DATA_OUT_OF_RANGE                                    ((FIT_BP_STATUS)3)
#define FIT_BP_STATUS_ERROR_IRREGULAR_HEART_RATE                                 ((FIT_BP_STATUS)4)
#define FIT_BP_STATUS_COUNT                                                      5

typedef FIT_UINT16 FIT_USER_LOCAL_ID;
#define FIT_USER_LOCAL_ID_INVALID                                                FIT_UINT16_INVALID
#define FIT_USER_LOCAL_ID_LOCAL_MIN                                              ((FIT_USER_LOCAL_ID)0x0000)
#define FIT_USER_LOCAL_ID_LOCAL_MAX                                              ((FIT_USER_LOCAL_ID)0x000F)
#define FIT_USER_LOCAL_ID_STATIONARY_MIN                                         ((FIT_USER_LOCAL_ID)0x0010)
#define FIT_USER_LOCAL_ID_STATIONARY_MAX                                         ((FIT_USER_LOCAL_ID)0x00FF)
#define FIT_USER_LOCAL_ID_PORTABLE_MIN                                           ((FIT_USER_LOCAL_ID)0x0100)
#define FIT_USER_LOCAL_ID_PORTABLE_MAX                                           ((FIT_USER_LOCAL_ID)0xFFFE)
#define FIT_USER_LOCAL_ID_COUNT                                                  6

typedef FIT_ENUM FIT_SWIM_STROKE;
#define FIT_SWIM_STROKE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SWIM_STROKE_FREESTYLE                                                ((FIT_SWIM_STROKE)0)
#define FIT_SWIM_STROKE_BACKSTROKE                                               ((FIT_SWIM_STROKE)1)
#define FIT_SWIM_STROKE_BREASTSTROKE                                             ((FIT_SWIM_STROKE)2)
#define FIT_SWIM_STROKE_BUTTERFLY                                                ((FIT_SWIM_STROKE)3)
#define FIT_SWIM_STROKE_DRILL                                                    ((FIT_SWIM_STROKE)4)
#define FIT_SWIM_STROKE_MIXED                                                    ((FIT_SWIM_STROKE)5)
#define FIT_SWIM_STROKE_IM                                                       ((FIT_SWIM_STROKE)6) // IM is a mixed interval containing the same number of lengths for each of: Butterfly, Backstroke, Breaststroke, Freestyle, swam in that order.
#define FIT_SWIM_STROKE_COUNT                                                    7

typedef FIT_ENUM FIT_ACTIVITY_TYPE;
#define FIT_ACTIVITY_TYPE_INVALID                                                FIT_ENUM_INVALID
#define FIT_ACTIVITY_TYPE_GENERIC                                                ((FIT_ACTIVITY_TYPE)0)
#define FIT_ACTIVITY_TYPE_RUNNING                                                ((FIT_ACTIVITY_TYPE)1)
#define FIT_ACTIVITY_TYPE_CYCLING                                                ((FIT_ACTIVITY_TYPE)2)
#define FIT_ACTIVITY_TYPE_TRANSITION                                             ((FIT_ACTIVITY_TYPE)3) // Mulitsport transition
#define FIT_ACTIVITY_TYPE_FITNESS_EQUIPMENT                                      ((FIT_ACTIVITY_TYPE)4)
#define FIT_ACTIVITY_TYPE_SWIMMING                                               ((FIT_ACTIVITY_TYPE)5)
#define FIT_ACTIVITY_TYPE_WALKING                                                ((FIT_ACTIVITY_TYPE)6)
#define FIT_ACTIVITY_TYPE_SEDENTARY                                              ((FIT_ACTIVITY_TYPE)8)
#define FIT_ACTIVITY_TYPE_ALL                                                    ((FIT_ACTIVITY_TYPE)254) // All is for goals only to include all sports.
#define FIT_ACTIVITY_TYPE_COUNT                                                  9

typedef FIT_ENUM FIT_ACTIVITY_SUBTYPE;
#define FIT_ACTIVITY_SUBTYPE_INVALID                                             FIT_ENUM_INVALID
#define FIT_ACTIVITY_SUBTYPE_GENERIC                                             ((FIT_ACTIVITY_SUBTYPE)0)
#define FIT_ACTIVITY_SUBTYPE_TREADMILL                                           ((FIT_ACTIVITY_SUBTYPE)1) // Run
#define FIT_ACTIVITY_SUBTYPE_STREET                                              ((FIT_ACTIVITY_SUBTYPE)2) // Run
#define FIT_ACTIVITY_SUBTYPE_TRAIL                                               ((FIT_ACTIVITY_SUBTYPE)3) // Run
#define FIT_ACTIVITY_SUBTYPE_TRACK                                               ((FIT_ACTIVITY_SUBTYPE)4) // Run
#define FIT_ACTIVITY_SUBTYPE_SPIN                                                ((FIT_ACTIVITY_SUBTYPE)5) // Cycling
#define FIT_ACTIVITY_SUBTYPE_INDOOR_CYCLING                                      ((FIT_ACTIVITY_SUBTYPE)6) // Cycling
#define FIT_ACTIVITY_SUBTYPE_ROAD                                                ((FIT_ACTIVITY_SUBTYPE)7) // Cycling
#define FIT_ACTIVITY_SUBTYPE_MOUNTAIN                                            ((FIT_ACTIVITY_SUBTYPE)8) // Cycling
#define FIT_ACTIVITY_SUBTYPE_DOWNHILL                                            ((FIT_ACTIVITY_SUBTYPE)9) // Cycling
#define FIT_ACTIVITY_SUBTYPE_RECUMBENT                                           ((FIT_ACTIVITY_SUBTYPE)10) // Cycling
#define FIT_ACTIVITY_SUBTYPE_CYCLOCROSS                                          ((FIT_ACTIVITY_SUBTYPE)11) // Cycling
#define FIT_ACTIVITY_SUBTYPE_HAND_CYCLING                                        ((FIT_ACTIVITY_SUBTYPE)12) // Cycling
#define FIT_ACTIVITY_SUBTYPE_TRACK_CYCLING                                       ((FIT_ACTIVITY_SUBTYPE)13) // Cycling
#define FIT_ACTIVITY_SUBTYPE_INDOOR_ROWING                                       ((FIT_ACTIVITY_SUBTYPE)14) // Fitness Equipment
#define FIT_ACTIVITY_SUBTYPE_ELLIPTICAL                                          ((FIT_ACTIVITY_SUBTYPE)15) // Fitness Equipment
#define FIT_ACTIVITY_SUBTYPE_STAIR_CLIMBING                                      ((FIT_ACTIVITY_SUBTYPE)16) // Fitness Equipment
#define FIT_ACTIVITY_SUBTYPE_LAP_SWIMMING                                        ((FIT_ACTIVITY_SUBTYPE)17) // Swimming
#define FIT_ACTIVITY_SUBTYPE_OPEN_WATER                                          ((FIT_ACTIVITY_SUBTYPE)18) // Swimming
#define FIT_ACTIVITY_SUBTYPE_ALL                                                 ((FIT_ACTIVITY_SUBTYPE)254)
#define FIT_ACTIVITY_SUBTYPE_COUNT                                               20

typedef FIT_ENUM FIT_ACTIVITY_LEVEL;
#define FIT_ACTIVITY_LEVEL_INVALID                                               FIT_ENUM_INVALID
#define FIT_ACTIVITY_LEVEL_LOW                                                   ((FIT_ACTIVITY_LEVEL)0)
#define FIT_ACTIVITY_LEVEL_MEDIUM                                                ((FIT_ACTIVITY_LEVEL)1)
#define FIT_ACTIVITY_LEVEL_HIGH                                                  ((FIT_ACTIVITY_LEVEL)2)
#define FIT_ACTIVITY_LEVEL_COUNT                                                 3

typedef FIT_ENUM FIT_SIDE;
#define FIT_SIDE_INVALID                                                         FIT_ENUM_INVALID
#define FIT_SIDE_RIGHT                                                           ((FIT_SIDE)0)
#define FIT_SIDE_LEFT                                                            ((FIT_SIDE)1)
#define FIT_SIDE_COUNT                                                           2

typedef FIT_UINT8 FIT_LEFT_RIGHT_BALANCE;
#define FIT_LEFT_RIGHT_BALANCE_INVALID                                           FIT_UINT8_INVALID
#define FIT_LEFT_RIGHT_BALANCE_MASK                                              ((FIT_LEFT_RIGHT_BALANCE)0x7F) // % contribution
#define FIT_LEFT_RIGHT_BALANCE_RIGHT                                             ((FIT_LEFT_RIGHT_BALANCE)0x80) // data corresponds to right if set, otherwise unknown
#define FIT_LEFT_RIGHT_BALANCE_COUNT                                             2

typedef FIT_UINT16 FIT_LEFT_RIGHT_BALANCE_100;
#define FIT_LEFT_RIGHT_BALANCE_100_INVALID                                       FIT_UINT16_INVALID
#define FIT_LEFT_RIGHT_BALANCE_100_MASK                                          ((FIT_LEFT_RIGHT_BALANCE_100)0x3FFF) // % contribution scaled by 100
#define FIT_LEFT_RIGHT_BALANCE_100_RIGHT                                         ((FIT_LEFT_RIGHT_BALANCE_100)0x8000) // data corresponds to right if set, otherwise unknown
#define FIT_LEFT_RIGHT_BALANCE_100_COUNT                                         2

typedef FIT_ENUM FIT_LENGTH_TYPE;
#define FIT_LENGTH_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_LENGTH_TYPE_IDLE                                                     ((FIT_LENGTH_TYPE)0) // Rest period. Length with no strokes
#define FIT_LENGTH_TYPE_ACTIVE                                                   ((FIT_LENGTH_TYPE)1) // Length with strokes.
#define FIT_LENGTH_TYPE_COUNT                                                    2

typedef FIT_ENUM FIT_DAY_OF_WEEK;
#define FIT_DAY_OF_WEEK_INVALID                                                  FIT_ENUM_INVALID
#define FIT_DAY_OF_WEEK_SUNDAY                                                   ((FIT_DAY_OF_WEEK)0)
#define FIT_DAY_OF_WEEK_MONDAY                                                   ((FIT_DAY_OF_WEEK)1)
#define FIT_DAY_OF_WEEK_TUESDAY                                                  ((FIT_DAY_OF_WEEK)2)
#define FIT_DAY_OF_WEEK_WEDNESDAY                                                ((FIT_DAY_OF_WEEK)3)
#define FIT_DAY_OF_WEEK_THURSDAY                                                 ((FIT_DAY_OF_WEEK)4)
#define FIT_DAY_OF_WEEK_FRIDAY                                                   ((FIT_DAY_OF_WEEK)5)
#define FIT_DAY_OF_WEEK_SATURDAY                                                 ((FIT_DAY_OF_WEEK)6)
#define FIT_DAY_OF_WEEK_COUNT                                                    7

typedef FIT_UINT32Z FIT_CONNECTIVITY_CAPABILITIES;
#define FIT_CONNECTIVITY_CAPABILITIES_INVALID                                    FIT_UINT32Z_INVALID
#define FIT_CONNECTIVITY_CAPABILITIES_BLUETOOTH                                  ((FIT_CONNECTIVITY_CAPABILITIES)0x00000001)
#define FIT_CONNECTIVITY_CAPABILITIES_BLUETOOTH_LE                               ((FIT_CONNECTIVITY_CAPABILITIES)0x00000002)
#define FIT_CONNECTIVITY_CAPABILITIES_ANT                                        ((FIT_CONNECTIVITY_CAPABILITIES)0x00000004)
#define FIT_CONNECTIVITY_CAPABILITIES_ACTIVITY_UPLOAD                            ((FIT_CONNECTIVITY_CAPABILITIES)0x00000008)
#define FIT_CONNECTIVITY_CAPABILITIES_COURSE_DOWNLOAD                            ((FIT_CONNECTIVITY_CAPABILITIES)0x00000010)
#define FIT_CONNECTIVITY_CAPABILITIES_WORKOUT_DOWNLOAD                           ((FIT_CONNECTIVITY_CAPABILITIES)0x00000020)
#define FIT_CONNECTIVITY_CAPABILITIES_LIVE_TRACK                                 ((FIT_CONNECTIVITY_CAPABILITIES)0x00000040)
#define FIT_CONNECTIVITY_CAPABILITIES_WEATHER_CONDITIONS                         ((FIT_CONNECTIVITY_CAPABILITIES)0x00000080)
#define FIT_CONNECTIVITY_CAPABILITIES_WEATHER_ALERTS                             ((FIT_CONNECTIVITY_CAPABILITIES)0x00000100)
#define FIT_CONNECTIVITY_CAPABILITIES_GPS_EPHEMERIS_DOWNLOAD                     ((FIT_CONNECTIVITY_CAPABILITIES)0x00000200)
#define FIT_CONNECTIVITY_CAPABILITIES_EXPLICIT_ARCHIVE                           ((FIT_CONNECTIVITY_CAPABILITIES)0x00000400)
#define FIT_CONNECTIVITY_CAPABILITIES_SETUP_INCOMPLETE                           ((FIT_CONNECTIVITY_CAPABILITIES)0x00000800)
#define FIT_CONNECTIVITY_CAPABILITIES_CONTINUE_SYNC_AFTER_SOFTWARE_UPDATE        ((FIT_CONNECTIVITY_CAPABILITIES)0x00001000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_APP_DOWNLOAD                    ((FIT_CONNECTIVITY_CAPABILITIES)0x00002000)
#define FIT_CONNECTIVITY_CAPABILITIES_GOLF_COURSE_DOWNLOAD                       ((FIT_CONNECTIVITY_CAPABILITIES)0x00004000)
#define FIT_CONNECTIVITY_CAPABILITIES_DEVICE_INITIATES_SYNC                      ((FIT_CONNECTIVITY_CAPABILITIES)0x00008000) // Indicates device is in control of initiating all syncs
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_WATCH_APP_DOWNLOAD              ((FIT_CONNECTIVITY_CAPABILITIES)0x00010000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_WIDGET_DOWNLOAD                 ((FIT_CONNECTIVITY_CAPABILITIES)0x00020000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_WATCH_FACE_DOWNLOAD             ((FIT_CONNECTIVITY_CAPABILITIES)0x00040000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_DATA_FIELD_DOWNLOAD             ((FIT_CONNECTIVITY_CAPABILITIES)0x00080000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_APP_MANAGMENT                   ((FIT_CONNECTIVITY_CAPABILITIES)0x00100000) // Device supports delete and reorder of apps via GCM
#define FIT_CONNECTIVITY_CAPABILITIES_SWING_SENSOR                               ((FIT_CONNECTIVITY_CAPABILITIES)0x00200000)
#define FIT_CONNECTIVITY_CAPABILITIES_SWING_SENSOR_REMOTE                        ((FIT_CONNECTIVITY_CAPABILITIES)0x00400000)
#define FIT_CONNECTIVITY_CAPABILITIES_INCIDENT_DETECTION                         ((FIT_CONNECTIVITY_CAPABILITIES)0x00800000) // Device supports incident detection
#define FIT_CONNECTIVITY_CAPABILITIES_AUDIO_PROMPTS                              ((FIT_CONNECTIVITY_CAPABILITIES)0x01000000)
#define FIT_CONNECTIVITY_CAPABILITIES_WIFI_VERIFICATION                          ((FIT_CONNECTIVITY_CAPABILITIES)0x02000000) // Device supports reporting wifi verification via GCM
#define FIT_CONNECTIVITY_CAPABILITIES_TRUE_UP                                    ((FIT_CONNECTIVITY_CAPABILITIES)0x04000000) // Device supports True Up
#define FIT_CONNECTIVITY_CAPABILITIES_FIND_MY_WATCH                              ((FIT_CONNECTIVITY_CAPABILITIES)0x08000000) // Device supports Find My Watch
#define FIT_CONNECTIVITY_CAPABILITIES_REMOTE_MANUAL_SYNC                         ((FIT_CONNECTIVITY_CAPABILITIES)0x10000000)
#define FIT_CONNECTIVITY_CAPABILITIES_LIVE_TRACK_AUTO_START                      ((FIT_CONNECTIVITY_CAPABILITIES)0x20000000) // Device supports LiveTrack auto start
#define FIT_CONNECTIVITY_CAPABILITIES_LIVE_TRACK_MESSAGING                       ((FIT_CONNECTIVITY_CAPABILITIES)0x40000000) // Device supports LiveTrack Messaging
#define FIT_CONNECTIVITY_CAPABILITIES_INSTANT_INPUT                              ((FIT_CONNECTIVITY_CAPABILITIES)0x80000000) // Device supports instant input feature
#define FIT_CONNECTIVITY_CAPABILITIES_COUNT                                      32

typedef FIT_ENUM FIT_WEATHER_REPORT;
#define FIT_WEATHER_REPORT_INVALID                                               FIT_ENUM_INVALID
#define FIT_WEATHER_REPORT_CURRENT                                               ((FIT_WEATHER_REPORT)0)
#define FIT_WEATHER_REPORT_FORECAST                                              ((FIT_WEATHER_REPORT)1) // Deprecated use hourly_forecast instead
#define FIT_WEATHER_REPORT_HOURLY_FORECAST                                       ((FIT_WEATHER_REPORT)1)
#define FIT_WEATHER_REPORT_DAILY_FORECAST                                        ((FIT_WEATHER_REPORT)2)
#define FIT_WEATHER_REPORT_COUNT                                                 4

typedef FIT_ENUM FIT_WEATHER_STATUS;
#define FIT_WEATHER_STATUS_INVALID                                               FIT_ENUM_INVALID
#define FIT_WEATHER_STATUS_CLEAR                                                 ((FIT_WEATHER_STATUS)0)
#define FIT_WEATHER_STATUS_PARTLY_CLOUDY                                         ((FIT_WEATHER_STATUS)1)
#define FIT_WEATHER_STATUS_MOSTLY_CLOUDY                                         ((FIT_WEATHER_STATUS)2)
#define FIT_WEATHER_STATUS_RAIN                                                  ((FIT_WEATHER_STATUS)3)
#define FIT_WEATHER_STATUS_SNOW                                                  ((FIT_WEATHER_STATUS)4)
#define FIT_WEATHER_STATUS_WINDY                                                 ((FIT_WEATHER_STATUS)5)
#define FIT_WEATHER_STATUS_THUNDERSTORMS                                         ((FIT_WEATHER_STATUS)6)
#define FIT_WEATHER_STATUS_WINTRY_MIX                                            ((FIT_WEATHER_STATUS)7)
#define FIT_WEATHER_STATUS_FOG                                                   ((FIT_WEATHER_STATUS)8)
#define FIT_WEATHER_STATUS_HAZY                                                  ((FIT_WEATHER_STATUS)11)
#define FIT_WEATHER_STATUS_HAIL                                                  ((FIT_WEATHER_STATUS)12)
#define FIT_WEATHER_STATUS_SCATTERED_SHOWERS                                     ((FIT_WEATHER_STATUS)13)
#define FIT_WEATHER_STATUS_SCATTERED_THUNDERSTORMS                               ((FIT_WEATHER_STATUS)14)
#define FIT_WEATHER_STATUS_UNKNOWN_PRECIPITATION                                 ((FIT_WEATHER_STATUS)15)
#define FIT_WEATHER_STATUS_LIGHT_RAIN                                            ((FIT_WEATHER_STATUS)16)
#define FIT_WEATHER_STATUS_HEAVY_RAIN                                            ((FIT_WEATHER_STATUS)17)
#define FIT_WEATHER_STATUS_LIGHT_SNOW                                            ((FIT_WEATHER_STATUS)18)
#define FIT_WEATHER_STATUS_HEAVY_SNOW                                            ((FIT_WEATHER_STATUS)19)
#define FIT_WEATHER_STATUS_LIGHT_RAIN_SNOW                                       ((FIT_WEATHER_STATUS)20)
#define FIT_WEATHER_STATUS_HEAVY_RAIN_SNOW                                       ((FIT_WEATHER_STATUS)21)
#define FIT_WEATHER_STATUS_CLOUDY                                                ((FIT_WEATHER_STATUS)22)
#define FIT_WEATHER_STATUS_COUNT                                                 21

typedef FIT_ENUM FIT_WEATHER_SEVERITY;
#define FIT_WEATHER_SEVERITY_INVALID                                             FIT_ENUM_INVALID
#define FIT_WEATHER_SEVERITY_UNKNOWN                                             ((FIT_WEATHER_SEVERITY)0)
#define FIT_WEATHER_SEVERITY_WARNING                                             ((FIT_WEATHER_SEVERITY)1)
#define FIT_WEATHER_SEVERITY_WATCH                                               ((FIT_WEATHER_SEVERITY)2)
#define FIT_WEATHER_SEVERITY_ADVISORY                                            ((FIT_WEATHER_SEVERITY)3)
#define FIT_WEATHER_SEVERITY_STATEMENT                                           ((FIT_WEATHER_SEVERITY)4)
#define FIT_WEATHER_SEVERITY_COUNT                                               5

typedef FIT_ENUM FIT_WEATHER_SEVERE_TYPE;
#define FIT_WEATHER_SEVERE_TYPE_INVALID                                          FIT_ENUM_INVALID
#define FIT_WEATHER_SEVERE_TYPE_UNSPECIFIED                                      ((FIT_WEATHER_SEVERE_TYPE)0)
#define FIT_WEATHER_SEVERE_TYPE_TORNADO                                          ((FIT_WEATHER_SEVERE_TYPE)1)
#define FIT_WEATHER_SEVERE_TYPE_TSUNAMI                                          ((FIT_WEATHER_SEVERE_TYPE)2)
#define FIT_WEATHER_SEVERE_TYPE_HURRICANE                                        ((FIT_WEATHER_SEVERE_TYPE)3)
#define FIT_WEATHER_SEVERE_TYPE_EXTREME_WIND                                     ((FIT_WEATHER_SEVERE_TYPE)4)
#define FIT_WEATHER_SEVERE_TYPE_TYPHOON                                          ((FIT_WEATHER_SEVERE_TYPE)5)
#define FIT_WEATHER_SEVERE_TYPE_INLAND_HURRICANE                                 ((FIT_WEATHER_SEVERE_TYPE)6)
#define FIT_WEATHER_SEVERE_TYPE_HURRICANE_FORCE_WIND                             ((FIT_WEATHER_SEVERE_TYPE)7)
#define FIT_WEATHER_SEVERE_TYPE_WATERSPOUT                                       ((FIT_WEATHER_SEVERE_TYPE)8)
#define FIT_WEATHER_SEVERE_TYPE_SEVERE_THUNDERSTORM                              ((FIT_WEATHER_SEVERE_TYPE)9)
#define FIT_WEATHER_SEVERE_TYPE_WRECKHOUSE_WINDS                                 ((FIT_WEATHER_SEVERE_TYPE)10)
#define FIT_WEATHER_SEVERE_TYPE_LES_SUETES_WIND                                  ((FIT_WEATHER_SEVERE_TYPE)11)
#define FIT_WEATHER_SEVERE_TYPE_AVALANCHE                                        ((FIT_WEATHER_SEVERE_TYPE)12)
#define FIT_WEATHER_SEVERE_TYPE_FLASH_FLOOD                                      ((FIT_WEATHER_SEVERE_TYPE)13)
#define FIT_WEATHER_SEVERE_TYPE_TROPICAL_STORM                                   ((FIT_WEATHER_SEVERE_TYPE)14)
#define FIT_WEATHER_SEVERE_TYPE_INLAND_TROPICAL_STORM                            ((FIT_WEATHER_SEVERE_TYPE)15)
#define FIT_WEATHER_SEVERE_TYPE_BLIZZARD                                         ((FIT_WEATHER_SEVERE_TYPE)16)
#define FIT_WEATHER_SEVERE_TYPE_ICE_STORM                                        ((FIT_WEATHER_SEVERE_TYPE)17)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_RAIN                                    ((FIT_WEATHER_SEVERE_TYPE)18)
#define FIT_WEATHER_SEVERE_TYPE_DEBRIS_FLOW                                      ((FIT_WEATHER_SEVERE_TYPE)19)
#define FIT_WEATHER_SEVERE_TYPE_FLASH_FREEZE                                     ((FIT_WEATHER_SEVERE_TYPE)20)
#define FIT_WEATHER_SEVERE_TYPE_DUST_STORM                                       ((FIT_WEATHER_SEVERE_TYPE)21)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_WIND                                        ((FIT_WEATHER_SEVERE_TYPE)22)
#define FIT_WEATHER_SEVERE_TYPE_WINTER_STORM                                     ((FIT_WEATHER_SEVERE_TYPE)23)
#define FIT_WEATHER_SEVERE_TYPE_HEAVY_FREEZING_SPRAY                             ((FIT_WEATHER_SEVERE_TYPE)24)
#define FIT_WEATHER_SEVERE_TYPE_EXTREME_COLD                                     ((FIT_WEATHER_SEVERE_TYPE)25)
#define FIT_WEATHER_SEVERE_TYPE_WIND_CHILL                                       ((FIT_WEATHER_SEVERE_TYPE)26)
#define FIT_WEATHER_SEVERE_TYPE_COLD_WAVE                                        ((FIT_WEATHER_SEVERE_TYPE)27)
#define FIT_WEATHER_SEVERE_TYPE_HEAVY_SNOW_ALERT                                 ((FIT_WEATHER_SEVERE_TYPE)28)
#define FIT_WEATHER_SEVERE_TYPE_LAKE_EFFECT_BLOWING_SNOW                         ((FIT_WEATHER_SEVERE_TYPE)29)
#define FIT_WEATHER_SEVERE_TYPE_SNOW_SQUALL                                      ((FIT_WEATHER_SEVERE_TYPE)30)
#define FIT_WEATHER_SEVERE_TYPE_LAKE_EFFECT_SNOW                                 ((FIT_WEATHER_SEVERE_TYPE)31)
#define FIT_WEATHER_SEVERE_TYPE_WINTER_WEATHER                                   ((FIT_WEATHER_SEVERE_TYPE)32)
#define FIT_WEATHER_SEVERE_TYPE_SLEET                                            ((FIT_WEATHER_SEVERE_TYPE)33)
#define FIT_WEATHER_SEVERE_TYPE_SNOWFALL                                         ((FIT_WEATHER_SEVERE_TYPE)34)
#define FIT_WEATHER_SEVERE_TYPE_SNOW_AND_BLOWING_SNOW                            ((FIT_WEATHER_SEVERE_TYPE)35)
#define FIT_WEATHER_SEVERE_TYPE_BLOWING_SNOW                                     ((FIT_WEATHER_SEVERE_TYPE)36)
#define FIT_WEATHER_SEVERE_TYPE_SNOW_ALERT                                       ((FIT_WEATHER_SEVERE_TYPE)37)
#define FIT_WEATHER_SEVERE_TYPE_ARCTIC_OUTFLOW                                   ((FIT_WEATHER_SEVERE_TYPE)38)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_DRIZZLE                                 ((FIT_WEATHER_SEVERE_TYPE)39)
#define FIT_WEATHER_SEVERE_TYPE_STORM                                            ((FIT_WEATHER_SEVERE_TYPE)40)
#define FIT_WEATHER_SEVERE_TYPE_STORM_SURGE                                      ((FIT_WEATHER_SEVERE_TYPE)41)
#define FIT_WEATHER_SEVERE_TYPE_RAINFALL                                         ((FIT_WEATHER_SEVERE_TYPE)42)
#define FIT_WEATHER_SEVERE_TYPE_AREAL_FLOOD                                      ((FIT_WEATHER_SEVERE_TYPE)43)
#define FIT_WEATHER_SEVERE_TYPE_COASTAL_FLOOD                                    ((FIT_WEATHER_SEVERE_TYPE)44)
#define FIT_WEATHER_SEVERE_TYPE_LAKESHORE_FLOOD                                  ((FIT_WEATHER_SEVERE_TYPE)45)
#define FIT_WEATHER_SEVERE_TYPE_EXCESSIVE_HEAT                                   ((FIT_WEATHER_SEVERE_TYPE)46)
#define FIT_WEATHER_SEVERE_TYPE_HEAT                                             ((FIT_WEATHER_SEVERE_TYPE)47)
#define FIT_WEATHER_SEVERE_TYPE_WEATHER                                          ((FIT_WEATHER_SEVERE_TYPE)48)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_HEAT_AND_HUMIDITY                           ((FIT_WEATHER_SEVERE_TYPE)49)
#define FIT_WEATHER_SEVERE_TYPE_HUMIDEX_AND_HEALTH                               ((FIT_WEATHER_SEVERE_TYPE)50)
#define FIT_WEATHER_SEVERE_TYPE_HUMIDEX                                          ((FIT_WEATHER_SEVERE_TYPE)51)
#define FIT_WEATHER_SEVERE_TYPE_GALE                                             ((FIT_WEATHER_SEVERE_TYPE)52)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_SPRAY                                   ((FIT_WEATHER_SEVERE_TYPE)53)
#define FIT_WEATHER_SEVERE_TYPE_SPECIAL_MARINE                                   ((FIT_WEATHER_SEVERE_TYPE)54)
#define FIT_WEATHER_SEVERE_TYPE_SQUALL                                           ((FIT_WEATHER_SEVERE_TYPE)55)
#define FIT_WEATHER_SEVERE_TYPE_STRONG_WIND                                      ((FIT_WEATHER_SEVERE_TYPE)56)
#define FIT_WEATHER_SEVERE_TYPE_LAKE_WIND                                        ((FIT_WEATHER_SEVERE_TYPE)57)
#define FIT_WEATHER_SEVERE_TYPE_MARINE_WEATHER                                   ((FIT_WEATHER_SEVERE_TYPE)58)
#define FIT_WEATHER_SEVERE_TYPE_WIND                                             ((FIT_WEATHER_SEVERE_TYPE)59)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT_HAZARDOUS_SEAS                       ((FIT_WEATHER_SEVERE_TYPE)60)
#define FIT_WEATHER_SEVERE_TYPE_HAZARDOUS_SEAS                                   ((FIT_WEATHER_SEVERE_TYPE)61)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT                                      ((FIT_WEATHER_SEVERE_TYPE)62)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT_WINDS                                ((FIT_WEATHER_SEVERE_TYPE)63)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT_ROUGH_BAR                            ((FIT_WEATHER_SEVERE_TYPE)64)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_WATER_LEVEL                                 ((FIT_WEATHER_SEVERE_TYPE)65)
#define FIT_WEATHER_SEVERE_TYPE_ASHFALL                                          ((FIT_WEATHER_SEVERE_TYPE)66)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_FOG                                     ((FIT_WEATHER_SEVERE_TYPE)67)
#define FIT_WEATHER_SEVERE_TYPE_DENSE_FOG                                        ((FIT_WEATHER_SEVERE_TYPE)68)
#define FIT_WEATHER_SEVERE_TYPE_DENSE_SMOKE                                      ((FIT_WEATHER_SEVERE_TYPE)69)
#define FIT_WEATHER_SEVERE_TYPE_BLOWING_DUST                                     ((FIT_WEATHER_SEVERE_TYPE)70)
#define FIT_WEATHER_SEVERE_TYPE_HARD_FREEZE                                      ((FIT_WEATHER_SEVERE_TYPE)71)
#define FIT_WEATHER_SEVERE_TYPE_FREEZE                                           ((FIT_WEATHER_SEVERE_TYPE)72)
#define FIT_WEATHER_SEVERE_TYPE_FROST                                            ((FIT_WEATHER_SEVERE_TYPE)73)
#define FIT_WEATHER_SEVERE_TYPE_FIRE_WEATHER                                     ((FIT_WEATHER_SEVERE_TYPE)74)
#define FIT_WEATHER_SEVERE_TYPE_FLOOD                                            ((FIT_WEATHER_SEVERE_TYPE)75)
#define FIT_WEATHER_SEVERE_TYPE_RIP_TIDE                                         ((FIT_WEATHER_SEVERE_TYPE)76)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_SURF                                        ((FIT_WEATHER_SEVERE_TYPE)77)
#define FIT_WEATHER_SEVERE_TYPE_SMOG                                             ((FIT_WEATHER_SEVERE_TYPE)78)
#define FIT_WEATHER_SEVERE_TYPE_AIR_QUALITY                                      ((FIT_WEATHER_SEVERE_TYPE)79)
#define FIT_WEATHER_SEVERE_TYPE_BRISK_WIND                                       ((FIT_WEATHER_SEVERE_TYPE)80)
#define FIT_WEATHER_SEVERE_TYPE_AIR_STAGNATION                                   ((FIT_WEATHER_SEVERE_TYPE)81)
#define FIT_WEATHER_SEVERE_TYPE_LOW_WATER                                        ((FIT_WEATHER_SEVERE_TYPE)82)
#define FIT_WEATHER_SEVERE_TYPE_HYDROLOGICAL                                     ((FIT_WEATHER_SEVERE_TYPE)83)
#define FIT_WEATHER_SEVERE_TYPE_SPECIAL_WEATHER                                  ((FIT_WEATHER_SEVERE_TYPE)84)
#define FIT_WEATHER_SEVERE_TYPE_COUNT                                            85

typedef FIT_UINT32 FIT_TIME_INTO_DAY; // number of seconds into the day since 00:00:00 UTC
#define FIT_TIME_INTO_DAY_INVALID                                                FIT_UINT32_INVALID
#define FIT_TIME_INTO_DAY_COUNT                                                  0

typedef FIT_UINT32 FIT_LOCALTIME_INTO_DAY; // number of seconds into the day since local 00:00:00
#define FIT_LOCALTIME_INTO_DAY_INVALID                                           FIT_UINT32_INVALID
#define FIT_LOCALTIME_INTO_DAY_COUNT                                             0

typedef FIT_ENUM FIT_STROKE_TYPE;
#define FIT_STROKE_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_STROKE_TYPE_NO_EVENT                                                 ((FIT_STROKE_TYPE)0)
#define FIT_STROKE_TYPE_OTHER                                                    ((FIT_STROKE_TYPE)1) // stroke was detected but cannot be identified
#define FIT_STROKE_TYPE_SERVE                                                    ((FIT_STROKE_TYPE)2)
#define FIT_STROKE_TYPE_FOREHAND                                                 ((FIT_STROKE_TYPE)3)
#define FIT_STROKE_TYPE_BACKHAND                                                 ((FIT_STROKE_TYPE)4)
#define FIT_STROKE_TYPE_SMASH                                                    ((FIT_STROKE_TYPE)5)
#define FIT_STROKE_TYPE_COUNT                                                    6

typedef FIT_ENUM FIT_BODY_LOCATION;
#define FIT_BODY_LOCATION_INVALID                                                FIT_ENUM_INVALID
#define FIT_BODY_LOCATION_LEFT_LEG                                               ((FIT_BODY_LOCATION)0)
#define FIT_BODY_LOCATION_LEFT_CALF                                              ((FIT_BODY_LOCATION)1)
#define FIT_BODY_LOCATION_LEFT_SHIN                                              ((FIT_BODY_LOCATION)2)
#define FIT_BODY_LOCATION_LEFT_HAMSTRING                                         ((FIT_BODY_LOCATION)3)
#define FIT_BODY_LOCATION_LEFT_QUAD                                              ((FIT_BODY_LOCATION)4)
#define FIT_BODY_LOCATION_LEFT_GLUTE                                             ((FIT_BODY_LOCATION)5)
#define FIT_BODY_LOCATION_RIGHT_LEG                                              ((FIT_BODY_LOCATION)6)
#define FIT_BODY_LOCATION_RIGHT_CALF                                             ((FIT_BODY_LOCATION)7)
#define FIT_BODY_LOCATION_RIGHT_SHIN                                             ((FIT_BODY_LOCATION)8)
#define FIT_BODY_LOCATION_RIGHT_HAMSTRING                                        ((FIT_BODY_LOCATION)9)
#define FIT_BODY_LOCATION_RIGHT_QUAD                                             ((FIT_BODY_LOCATION)10)
#define FIT_BODY_LOCATION_RIGHT_GLUTE                                            ((FIT_BODY_LOCATION)11)
#define FIT_BODY_LOCATION_TORSO_BACK                                             ((FIT_BODY_LOCATION)12)
#define FIT_BODY_LOCATION_LEFT_LOWER_BACK                                        ((FIT_BODY_LOCATION)13)
#define FIT_BODY_LOCATION_LEFT_UPPER_BACK                                        ((FIT_BODY_LOCATION)14)
#define FIT_BODY_LOCATION_RIGHT_LOWER_BACK                                       ((FIT_BODY_LOCATION)15)
#define FIT_BODY_LOCATION_RIGHT_UPPER_BACK                                       ((FIT_BODY_LOCATION)16)
#define FIT_BODY_LOCATION_TORSO_FRONT                                            ((FIT_BODY_LOCATION)17)
#define FIT_BODY_LOCATION_LEFT_ABDOMEN                                           ((FIT_BODY_LOCATION)18)
#define FIT_BODY_LOCATION_LEFT_CHEST                                             ((FIT_BODY_LOCATION)19)
#define FIT_BODY_LOCATION_RIGHT_ABDOMEN                                          ((FIT_BODY_LOCATION)20)
#define FIT_BODY_LOCATION_RIGHT_CHEST                                            ((FIT_BODY_LOCATION)21)
#define FIT_BODY_LOCATION_LEFT_ARM                                               ((FIT_BODY_LOCATION)22)
#define FIT_BODY_LOCATION_LEFT_SHOULDER                                          ((FIT_BODY_LOCATION)23)
#define FIT_BODY_LOCATION_LEFT_BICEP                                             ((FIT_BODY_LOCATION)24)
#define FIT_BODY_LOCATION_LEFT_TRICEP                                            ((FIT_BODY_LOCATION)25)
#define FIT_BODY_LOCATION_LEFT_BRACHIORADIALIS                                   ((FIT_BODY_LOCATION)26) // Left anterior forearm
#define FIT_BODY_LOCATION_LEFT_FOREARM_EXTENSORS                                 ((FIT_BODY_LOCATION)27) // Left posterior forearm
#define FIT_BODY_LOCATION_RIGHT_ARM                                              ((FIT_BODY_LOCATION)28)
#define FIT_BODY_LOCATION_RIGHT_SHOULDER                                         ((FIT_BODY_LOCATION)29)
#define FIT_BODY_LOCATION_RIGHT_BICEP                                            ((FIT_BODY_LOCATION)30)
#define FIT_BODY_LOCATION_RIGHT_TRICEP                                           ((FIT_BODY_LOCATION)31)
#define FIT_BODY_LOCATION_RIGHT_BRACHIORADIALIS                                  ((FIT_BODY_LOCATION)32) // Right anterior forearm
#define FIT_BODY_LOCATION_RIGHT_FOREARM_EXTENSORS                                ((FIT_BODY_LOCATION)33) // Right posterior forearm
#define FIT_BODY_LOCATION_NECK                                                   ((FIT_BODY_LOCATION)34)
#define FIT_BODY_LOCATION_THROAT                                                 ((FIT_BODY_LOCATION)35)
#define FIT_BODY_LOCATION_WAIST_MID_BACK                                         ((FIT_BODY_LOCATION)36)
#define FIT_BODY_LOCATION_WAIST_FRONT                                            ((FIT_BODY_LOCATION)37)
#define FIT_BODY_LOCATION_WAIST_LEFT                                             ((FIT_BODY_LOCATION)38)
#define FIT_BODY_LOCATION_WAIST_RIGHT                                            ((FIT_BODY_LOCATION)39)
#define FIT_BODY_LOCATION_COUNT                                                  40

typedef FIT_ENUM FIT_SEGMENT_LAP_STATUS;
#define FIT_SEGMENT_LAP_STATUS_INVALID                                           FIT_ENUM_INVALID
#define FIT_SEGMENT_LAP_STATUS_END                                               ((FIT_SEGMENT_LAP_STATUS)0)
#define FIT_SEGMENT_LAP_STATUS_FAIL                                              ((FIT_SEGMENT_LAP_STATUS)1)
#define FIT_SEGMENT_LAP_STATUS_COUNT                                             2

typedef FIT_ENUM FIT_SEGMENT_LEADERBOARD_TYPE;
#define FIT_SEGMENT_LEADERBOARD_TYPE_INVALID                                     FIT_ENUM_INVALID
#define FIT_SEGMENT_LEADERBOARD_TYPE_OVERALL                                     ((FIT_SEGMENT_LEADERBOARD_TYPE)0)
#define FIT_SEGMENT_LEADERBOARD_TYPE_PERSONAL_BEST                               ((FIT_SEGMENT_LEADERBOARD_TYPE)1)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CONNECTIONS                                 ((FIT_SEGMENT_LEADERBOARD_TYPE)2)
#define FIT_SEGMENT_LEADERBOARD_TYPE_GROUP                                       ((FIT_SEGMENT_LEADERBOARD_TYPE)3)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CHALLENGER                                  ((FIT_SEGMENT_LEADERBOARD_TYPE)4)
#define FIT_SEGMENT_LEADERBOARD_TYPE_KOM                                         ((FIT_SEGMENT_LEADERBOARD_TYPE)5)
#define FIT_SEGMENT_LEADERBOARD_TYPE_QOM                                         ((FIT_SEGMENT_LEADERBOARD_TYPE)6)
#define FIT_SEGMENT_LEADERBOARD_TYPE_PR                                          ((FIT_SEGMENT_LEADERBOARD_TYPE)7)
#define FIT_SEGMENT_LEADERBOARD_TYPE_GOAL                                        ((FIT_SEGMENT_LEADERBOARD_TYPE)8)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CARROT                                      ((FIT_SEGMENT_LEADERBOARD_TYPE)9)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CLUB_LEADER                                 ((FIT_SEGMENT_LEADERBOARD_TYPE)10)
#define FIT_SEGMENT_LEADERBOARD_TYPE_RIVAL                                       ((FIT_SEGMENT_LEADERBOARD_TYPE)11)
#define FIT_SEGMENT_LEADERBOARD_TYPE_LAST                                        ((FIT_SEGMENT_LEADERBOARD_TYPE)12)
#define FIT_SEGMENT_LEADERBOARD_TYPE_RECENT_BEST                                 ((FIT_SEGMENT_LEADERBOARD_TYPE)13)
#define FIT_SEGMENT_LEADERBOARD_TYPE_COURSE_RECORD                               ((FIT_SEGMENT_LEADERBOARD_TYPE)14)
#define FIT_SEGMENT_LEADERBOARD_TYPE_COUNT                                       15

typedef FIT_ENUM FIT_SEGMENT_DELETE_STATUS;
#define FIT_SEGMENT_DELETE_STATUS_INVALID                                        FIT_ENUM_INVALID
#define FIT_SEGMENT_DELETE_STATUS_DO_NOT_DELETE                                  ((FIT_SEGMENT_DELETE_STATUS)0)
#define FIT_SEGMENT_DELETE_STATUS_DELETE_ONE                                     ((FIT_SEGMENT_DELETE_STATUS)1)
#define FIT_SEGMENT_DELETE_STATUS_DELETE_ALL                                     ((FIT_SEGMENT_DELETE_STATUS)2)
#define FIT_SEGMENT_DELETE_STATUS_COUNT                                          3

typedef FIT_ENUM FIT_SEGMENT_SELECTION_TYPE;
#define FIT_SEGMENT_SELECTION_TYPE_INVALID                                       FIT_ENUM_INVALID
#define FIT_SEGMENT_SELECTION_TYPE_STARRED                                       ((FIT_SEGMENT_SELECTION_TYPE)0)
#define FIT_SEGMENT_SELECTION_TYPE_SUGGESTED                                     ((FIT_SEGMENT_SELECTION_TYPE)1)
#define FIT_SEGMENT_SELECTION_TYPE_COUNT                                         2

typedef FIT_ENUM FIT_SOURCE_TYPE;
#define FIT_SOURCE_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SOURCE_TYPE_ANT                                                      ((FIT_SOURCE_TYPE)0) // External device connected with ANT
#define FIT_SOURCE_TYPE_ANTPLUS                                                  ((FIT_SOURCE_TYPE)1) // External device connected with ANT+
#define FIT_SOURCE_TYPE_BLUETOOTH                                                ((FIT_SOURCE_TYPE)2) // External device connected with BT
#define FIT_SOURCE_TYPE_BLUETOOTH_LOW_ENERGY                                     ((FIT_SOURCE_TYPE)3) // External device connected with BLE
#define FIT_SOURCE_TYPE_WIFI                                                     ((FIT_SOURCE_TYPE)4) // External device connected with Wifi
#define FIT_SOURCE_TYPE_LOCAL                                                    ((FIT_SOURCE_TYPE)5) // Onboard device
#define FIT_SOURCE_TYPE_COUNT                                                    6

typedef FIT_UINT8 FIT_LOCAL_DEVICE_TYPE;
#define FIT_LOCAL_DEVICE_TYPE_INVALID                                            FIT_UINT8_INVALID
#define FIT_LOCAL_DEVICE_TYPE_GPS                                                ((FIT_LOCAL_DEVICE_TYPE)0) // Onboard gps receiver
#define FIT_LOCAL_DEVICE_TYPE_GLONASS                                            ((FIT_LOCAL_DEVICE_TYPE)1) // Onboard glonass receiver
#define FIT_LOCAL_DEVICE_TYPE_GPS_GLONASS                                        ((FIT_LOCAL_DEVICE_TYPE)2) // Onboard gps glonass receiver
#define FIT_LOCAL_DEVICE_TYPE_ACCELEROMETER                                      ((FIT_LOCAL_DEVICE_TYPE)3) // Onboard sensor
#define FIT_LOCAL_DEVICE_TYPE_BAROMETER                                          ((FIT_LOCAL_DEVICE_TYPE)4) // Onboard sensor
#define FIT_LOCAL_DEVICE_TYPE_TEMPERATURE                                        ((FIT_LOCAL_DEVICE_TYPE)5) // Onboard sensor
#define FIT_LOCAL_DEVICE_TYPE_WHR                                                ((FIT_LOCAL_DEVICE_TYPE)10) // Onboard wrist HR sensor
#define FIT_LOCAL_DEVICE_TYPE_SENSOR_HUB                                         ((FIT_LOCAL_DEVICE_TYPE)12) // Onboard software package
#define FIT_LOCAL_DEVICE_TYPE_COUNT                                              8

typedef FIT_UINT8 FIT_BLE_DEVICE_TYPE;
#define FIT_BLE_DEVICE_TYPE_INVALID                                              FIT_UINT8_INVALID
#define FIT_BLE_DEVICE_TYPE_CONNECTED_GPS                                        ((FIT_BLE_DEVICE_TYPE)0) // GPS that is provided over a proprietary bluetooth service
#define FIT_BLE_DEVICE_TYPE_HEART_RATE                                           ((FIT_BLE_DEVICE_TYPE)1)
#define FIT_BLE_DEVICE_TYPE_BIKE_POWER                                           ((FIT_BLE_DEVICE_TYPE)2)
#define FIT_BLE_DEVICE_TYPE_BIKE_SPEED_CADENCE                                   ((FIT_BLE_DEVICE_TYPE)3)
#define FIT_BLE_DEVICE_TYPE_BIKE_SPEED                                           ((FIT_BLE_DEVICE_TYPE)4)
#define FIT_BLE_DEVICE_TYPE_BIKE_CADENCE                                         ((FIT_BLE_DEVICE_TYPE)5)
#define FIT_BLE_DEVICE_TYPE_FOOTPOD                                              ((FIT_BLE_DEVICE_TYPE)6)
#define FIT_BLE_DEVICE_TYPE_BIKE_TRAINER                                         ((FIT_BLE_DEVICE_TYPE)7) // Indoor-Bike FTMS protocol
#define FIT_BLE_DEVICE_TYPE_COUNT                                                8

typedef FIT_UINT32Z FIT_ANT_CHANNEL_ID;
#define FIT_ANT_CHANNEL_ID_INVALID                                               FIT_UINT32Z_INVALID
#define FIT_ANT_CHANNEL_ID_ANT_EXTENDED_DEVICE_NUMBER_UPPER_NIBBLE               ((FIT_ANT_CHANNEL_ID)0xF0000000)
#define FIT_ANT_CHANNEL_ID_ANT_TRANSMISSION_TYPE_LOWER_NIBBLE                    ((FIT_ANT_CHANNEL_ID)0x0F000000)
#define FIT_ANT_CHANNEL_ID_ANT_DEVICE_TYPE                                       ((FIT_ANT_CHANNEL_ID)0x00FF0000)
#define FIT_ANT_CHANNEL_ID_ANT_DEVICE_NUMBER                                     ((FIT_ANT_CHANNEL_ID)0x0000FFFF)
#define FIT_ANT_CHANNEL_ID_COUNT                                                 4

typedef FIT_ENUM FIT_DISPLAY_ORIENTATION;
#define FIT_DISPLAY_ORIENTATION_INVALID                                          FIT_ENUM_INVALID
#define FIT_DISPLAY_ORIENTATION_AUTO                                             ((FIT_DISPLAY_ORIENTATION)0) // automatic if the device supports it
#define FIT_DISPLAY_ORIENTATION_PORTRAIT                                         ((FIT_DISPLAY_ORIENTATION)1)
#define FIT_DISPLAY_ORIENTATION_LANDSCAPE                                        ((FIT_DISPLAY_ORIENTATION)2)
#define FIT_DISPLAY_ORIENTATION_PORTRAIT_FLIPPED                                 ((FIT_DISPLAY_ORIENTATION)3) // portrait mode but rotated 180 degrees
#define FIT_DISPLAY_ORIENTATION_LANDSCAPE_FLIPPED                                ((FIT_DISPLAY_ORIENTATION)4) // landscape mode but rotated 180 degrees
#define FIT_DISPLAY_ORIENTATION_COUNT                                            5

typedef FIT_ENUM FIT_WORKOUT_EQUIPMENT;
#define FIT_WORKOUT_EQUIPMENT_INVALID                                            FIT_ENUM_INVALID
#define FIT_WORKOUT_EQUIPMENT_NONE                                               ((FIT_WORKOUT_EQUIPMENT)0)
#define FIT_WORKOUT_EQUIPMENT_SWIM_FINS                                          ((FIT_WORKOUT_EQUIPMENT)1)
#define FIT_WORKOUT_EQUIPMENT_SWIM_KICKBOARD                                     ((FIT_WORKOUT_EQUIPMENT)2)
#define FIT_WORKOUT_EQUIPMENT_SWIM_PADDLES                                       ((FIT_WORKOUT_EQUIPMENT)3)
#define FIT_WORKOUT_EQUIPMENT_SWIM_PULL_BUOY                                     ((FIT_WORKOUT_EQUIPMENT)4)
#define FIT_WORKOUT_EQUIPMENT_SWIM_SNORKEL                                       ((FIT_WORKOUT_EQUIPMENT)5)
#define FIT_WORKOUT_EQUIPMENT_COUNT                                              6

typedef FIT_ENUM FIT_WATCHFACE_MODE;
#define FIT_WATCHFACE_MODE_INVALID                                               FIT_ENUM_INVALID
#define FIT_WATCHFACE_MODE_DIGITAL                                               ((FIT_WATCHFACE_MODE)0)
#define FIT_WATCHFACE_MODE_ANALOG                                                ((FIT_WATCHFACE_MODE)1)
#define FIT_WATCHFACE_MODE_CONNECT_IQ                                            ((FIT_WATCHFACE_MODE)2)
#define FIT_WATCHFACE_MODE_DISABLED                                              ((FIT_WATCHFACE_MODE)3)
#define FIT_WATCHFACE_MODE_COUNT                                                 4

typedef FIT_ENUM FIT_DIGITAL_WATCHFACE_LAYOUT;
#define FIT_DIGITAL_WATCHFACE_LAYOUT_INVALID                                     FIT_ENUM_INVALID
#define FIT_DIGITAL_WATCHFACE_LAYOUT_TRADITIONAL                                 ((FIT_DIGITAL_WATCHFACE_LAYOUT)0)
#define FIT_DIGITAL_WATCHFACE_LAYOUT_MODERN                                      ((FIT_DIGITAL_WATCHFACE_LAYOUT)1)
#define FIT_DIGITAL_WATCHFACE_LAYOUT_BOLD                                        ((FIT_DIGITAL_WATCHFACE_LAYOUT)2)
#define FIT_DIGITAL_WATCHFACE_LAYOUT_COUNT                                       3

typedef FIT_ENUM FIT_ANALOG_WATCHFACE_LAYOUT;
#define FIT_ANALOG_WATCHFACE_LAYOUT_INVALID                                      FIT_ENUM_INVALID
#define FIT_ANALOG_WATCHFACE_LAYOUT_MINIMAL                                      ((FIT_ANALOG_WATCHFACE_LAYOUT)0)
#define FIT_ANALOG_WATCHFACE_LAYOUT_TRADITIONAL                                  ((FIT_ANALOG_WATCHFACE_LAYOUT)1)
#define FIT_ANALOG_WATCHFACE_LAYOUT_MODERN                                       ((FIT_ANALOG_WATCHFACE_LAYOUT)2)
#define FIT_ANALOG_WATCHFACE_LAYOUT_COUNT                                        3

typedef FIT_ENUM FIT_RIDER_POSITION_TYPE;
#define FIT_RIDER_POSITION_TYPE_INVALID                                          FIT_ENUM_INVALID
#define FIT_RIDER_POSITION_TYPE_SEATED                                           ((FIT_RIDER_POSITION_TYPE)0)
#define FIT_RIDER_POSITION_TYPE_STANDING                                         ((FIT_RIDER_POSITION_TYPE)1)
#define FIT_RIDER_POSITION_TYPE_TRANSITION_TO_SEATED                             ((FIT_RIDER_POSITION_TYPE)2)
#define FIT_RIDER_POSITION_TYPE_TRANSITION_TO_STANDING                           ((FIT_RIDER_POSITION_TYPE)3)
#define FIT_RIDER_POSITION_TYPE_COUNT                                            4

typedef FIT_ENUM FIT_POWER_PHASE_TYPE;
#define FIT_POWER_PHASE_TYPE_INVALID                                             FIT_ENUM_INVALID
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_START_ANGLE                             ((FIT_POWER_PHASE_TYPE)0)
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_END_ANGLE                               ((FIT_POWER_PHASE_TYPE)1)
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_ARC_LENGTH                              ((FIT_POWER_PHASE_TYPE)2)
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_CENTER                                  ((FIT_POWER_PHASE_TYPE)3)
#define FIT_POWER_PHASE_TYPE_COUNT                                               4

typedef FIT_ENUM FIT_CAMERA_EVENT_TYPE;
#define FIT_CAMERA_EVENT_TYPE_INVALID                                            FIT_ENUM_INVALID
#define FIT_CAMERA_EVENT_TYPE_VIDEO_START                                        ((FIT_CAMERA_EVENT_TYPE)0) // Start of video recording
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SPLIT                                        ((FIT_CAMERA_EVENT_TYPE)1) // Mark of video file split (end of one file, beginning of the other)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_END                                          ((FIT_CAMERA_EVENT_TYPE)2) // End of video recording
#define FIT_CAMERA_EVENT_TYPE_PHOTO_TAKEN                                        ((FIT_CAMERA_EVENT_TYPE)3) // Still photo taken
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_START                          ((FIT_CAMERA_EVENT_TYPE)4)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_SPLIT                          ((FIT_CAMERA_EVENT_TYPE)5)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_END                            ((FIT_CAMERA_EVENT_TYPE)6)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SPLIT_START                                  ((FIT_CAMERA_EVENT_TYPE)7) // Mark of video file split start
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_SPLIT_START                    ((FIT_CAMERA_EVENT_TYPE)8)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_PAUSE                                        ((FIT_CAMERA_EVENT_TYPE)11) // Mark when a video recording has been paused
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_PAUSE                          ((FIT_CAMERA_EVENT_TYPE)12)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_RESUME                                       ((FIT_CAMERA_EVENT_TYPE)13) // Mark when a video recording has been resumed
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_RESUME                         ((FIT_CAMERA_EVENT_TYPE)14)
#define FIT_CAMERA_EVENT_TYPE_COUNT                                              13

typedef FIT_ENUM FIT_SENSOR_TYPE;
#define FIT_SENSOR_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SENSOR_TYPE_ACCELEROMETER                                            ((FIT_SENSOR_TYPE)0)
#define FIT_SENSOR_TYPE_GYROSCOPE                                                ((FIT_SENSOR_TYPE)1)
#define FIT_SENSOR_TYPE_COMPASS                                                  ((FIT_SENSOR_TYPE)2) // Magnetometer
#define FIT_SENSOR_TYPE_BAROMETER                                                ((FIT_SENSOR_TYPE)3)
#define FIT_SENSOR_TYPE_COUNT                                                    4

typedef FIT_ENUM FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE;
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_INVALID                               FIT_ENUM_INVALID
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_AUTO                                  ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)0)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_INDIVIDUAL                            ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)4)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_HIGH_VISIBILITY                       ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)5)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_TRAIL                                 ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)6)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_COUNT                                 4

typedef FIT_UINT16 FIT_COMM_TIMEOUT_TYPE;
#define FIT_COMM_TIMEOUT_TYPE_INVALID                                            FIT_UINT16_INVALID
#define FIT_COMM_TIMEOUT_TYPE_WILDCARD_PAIRING_TIMEOUT                           ((FIT_COMM_TIMEOUT_TYPE)0) // Timeout pairing to any device
#define FIT_COMM_TIMEOUT_TYPE_PAIRING_TIMEOUT                                    ((FIT_COMM_TIMEOUT_TYPE)1) // Timeout pairing to previously paired device
#define FIT_COMM_TIMEOUT_TYPE_CONNECTION_LOST                                    ((FIT_COMM_TIMEOUT_TYPE)2) // Temporary loss of communications
#define FIT_COMM_TIMEOUT_TYPE_CONNECTION_TIMEOUT                                 ((FIT_COMM_TIMEOUT_TYPE)3) // Connection closed due to extended bad communications
#define FIT_COMM_TIMEOUT_TYPE_COUNT                                              4

typedef FIT_ENUM FIT_CAMERA_ORIENTATION_TYPE;
#define FIT_CAMERA_ORIENTATION_TYPE_INVALID                                      FIT_ENUM_INVALID
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_0                         ((FIT_CAMERA_ORIENTATION_TYPE)0)
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_90                        ((FIT_CAMERA_ORIENTATION_TYPE)1)
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_180                       ((FIT_CAMERA_ORIENTATION_TYPE)2)
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_270                       ((FIT_CAMERA_ORIENTATION_TYPE)3)
#define FIT_CAMERA_ORIENTATION_TYPE_COUNT                                        4

typedef FIT_ENUM FIT_ATTITUDE_STAGE;
#define FIT_ATTITUDE_STAGE_INVALID                                               FIT_ENUM_INVALID
#define FIT_ATTITUDE_STAGE_FAILED                                                ((FIT_ATTITUDE_STAGE)0)
#define FIT_ATTITUDE_STAGE_ALIGNING                                              ((FIT_ATTITUDE_STAGE)1)
#define FIT_ATTITUDE_STAGE_DEGRADED                                              ((FIT_ATTITUDE_STAGE)2)
#define FIT_ATTITUDE_STAGE_VALID                                                 ((FIT_ATTITUDE_STAGE)3)
#define FIT_ATTITUDE_STAGE_COUNT                                                 4

typedef FIT_UINT16 FIT_ATTITUDE_VALIDITY;
#define FIT_ATTITUDE_VALIDITY_INVALID                                            FIT_UINT16_INVALID
#define FIT_ATTITUDE_VALIDITY_TRACK_ANGLE_HEADING_VALID                          ((FIT_ATTITUDE_VALIDITY)0x0001)
#define FIT_ATTITUDE_VALIDITY_PITCH_VALID                                        ((FIT_ATTITUDE_VALIDITY)0x0002)
#define FIT_ATTITUDE_VALIDITY_ROLL_VALID                                         ((FIT_ATTITUDE_VALIDITY)0x0004)
#define FIT_ATTITUDE_VALIDITY_LATERAL_BODY_ACCEL_VALID                           ((FIT_ATTITUDE_VALIDITY)0x0008)
#define FIT_ATTITUDE_VALIDITY_NORMAL_BODY_ACCEL_VALID                            ((FIT_ATTITUDE_VALIDITY)0x0010)
#define FIT_ATTITUDE_VALIDITY_TURN_RATE_VALID                                    ((FIT_ATTITUDE_VALIDITY)0x0020)
#define FIT_ATTITUDE_VALIDITY_HW_FAIL                                            ((FIT_ATTITUDE_VALIDITY)0x0040)
#define FIT_ATTITUDE_VALIDITY_MAG_INVALID                                        ((FIT_ATTITUDE_VALIDITY)0x0080)
#define FIT_ATTITUDE_VALIDITY_NO_GPS                                             ((FIT_ATTITUDE_VALIDITY)0x0100)
#define FIT_ATTITUDE_VALIDITY_GPS_INVALID                                        ((FIT_ATTITUDE_VALIDITY)0x0200)
#define FIT_ATTITUDE_VALIDITY_SOLUTION_COASTING                                  ((FIT_ATTITUDE_VALIDITY)0x0400)
#define FIT_ATTITUDE_VALIDITY_TRUE_TRACK_ANGLE                                   ((FIT_ATTITUDE_VALIDITY)0x0800)
#define FIT_ATTITUDE_VALIDITY_MAGNETIC_HEADING                                   ((FIT_ATTITUDE_VALIDITY)0x1000)
#define FIT_ATTITUDE_VALIDITY_COUNT                                              13

typedef FIT_ENUM FIT_AUTO_SYNC_FREQUENCY;
#define FIT_AUTO_SYNC_FREQUENCY_INVALID                                          FIT_ENUM_INVALID
#define FIT_AUTO_SYNC_FREQUENCY_NEVER                                            ((FIT_AUTO_SYNC_FREQUENCY)0)
#define FIT_AUTO_SYNC_FREQUENCY_OCCASIONALLY                                     ((FIT_AUTO_SYNC_FREQUENCY)1)
#define FIT_AUTO_SYNC_FREQUENCY_FREQUENT                                         ((FIT_AUTO_SYNC_FREQUENCY)2)
#define FIT_AUTO_SYNC_FREQUENCY_ONCE_A_DAY                                       ((FIT_AUTO_SYNC_FREQUENCY)3)
#define FIT_AUTO_SYNC_FREQUENCY_REMOTE                                           ((FIT_AUTO_SYNC_FREQUENCY)4)
#define FIT_AUTO_SYNC_FREQUENCY_COUNT                                            5

typedef FIT_ENUM FIT_EXD_LAYOUT;
#define FIT_EXD_LAYOUT_INVALID                                                   FIT_ENUM_INVALID
#define FIT_EXD_LAYOUT_FULL_SCREEN                                               ((FIT_EXD_LAYOUT)0)
#define FIT_EXD_LAYOUT_HALF_VERTICAL                                             ((FIT_EXD_LAYOUT)1)
#define FIT_EXD_LAYOUT_HALF_HORIZONTAL                                           ((FIT_EXD_LAYOUT)2)
#define FIT_EXD_LAYOUT_HALF_VERTICAL_RIGHT_SPLIT                                 ((FIT_EXD_LAYOUT)3)
#define FIT_EXD_LAYOUT_HALF_HORIZONTAL_BOTTOM_SPLIT                              ((FIT_EXD_LAYOUT)4)
#define FIT_EXD_LAYOUT_FULL_QUARTER_SPLIT                                        ((FIT_EXD_LAYOUT)5)
#define FIT_EXD_LAYOUT_HALF_VERTICAL_LEFT_SPLIT                                  ((FIT_EXD_LAYOUT)6)
#define FIT_EXD_LAYOUT_HALF_HORIZONTAL_TOP_SPLIT                                 ((FIT_EXD_LAYOUT)7)
#define FIT_EXD_LAYOUT_DYNAMIC                                                   ((FIT_EXD_LAYOUT)8) // The EXD may display the configured concepts in any layout it sees fit.
#define FIT_EXD_LAYOUT_COUNT                                                     9

typedef FIT_ENUM FIT_EXD_DISPLAY_TYPE;
#define FIT_EXD_DISPLAY_TYPE_INVALID                                             FIT_ENUM_INVALID
#define FIT_EXD_DISPLAY_TYPE_NUMERICAL                                           ((FIT_EXD_DISPLAY_TYPE)0)
#define FIT_EXD_DISPLAY_TYPE_SIMPLE                                              ((FIT_EXD_DISPLAY_TYPE)1)
#define FIT_EXD_DISPLAY_TYPE_GRAPH                                               ((FIT_EXD_DISPLAY_TYPE)2)
#define FIT_EXD_DISPLAY_TYPE_BAR                                                 ((FIT_EXD_DISPLAY_TYPE)3)
#define FIT_EXD_DISPLAY_TYPE_CIRCLE_GRAPH                                        ((FIT_EXD_DISPLAY_TYPE)4)
#define FIT_EXD_DISPLAY_TYPE_VIRTUAL_PARTNER                                     ((FIT_EXD_DISPLAY_TYPE)5)
#define FIT_EXD_DISPLAY_TYPE_BALANCE                                             ((FIT_EXD_DISPLAY_TYPE)6)
#define FIT_EXD_DISPLAY_TYPE_STRING_LIST                                         ((FIT_EXD_DISPLAY_TYPE)7)
#define FIT_EXD_DISPLAY_TYPE_STRING                                              ((FIT_EXD_DISPLAY_TYPE)8)
#define FIT_EXD_DISPLAY_TYPE_SIMPLE_DYNAMIC_ICON                                 ((FIT_EXD_DISPLAY_TYPE)9)
#define FIT_EXD_DISPLAY_TYPE_GAUGE                                               ((FIT_EXD_DISPLAY_TYPE)10)
#define FIT_EXD_DISPLAY_TYPE_COUNT                                               11

typedef FIT_ENUM FIT_EXD_DATA_UNITS;
#define FIT_EXD_DATA_UNITS_INVALID                                               FIT_ENUM_INVALID
#define FIT_EXD_DATA_UNITS_NO_UNITS                                              ((FIT_EXD_DATA_UNITS)0)
#define FIT_EXD_DATA_UNITS_LAPS                                                  ((FIT_EXD_DATA_UNITS)1)
#define FIT_EXD_DATA_UNITS_MILES_PER_HOUR                                        ((FIT_EXD_DATA_UNITS)2)
#define FIT_EXD_DATA_UNITS_KILOMETERS_PER_HOUR                                   ((FIT_EXD_DATA_UNITS)3)
#define FIT_EXD_DATA_UNITS_FEET_PER_HOUR                                         ((FIT_EXD_DATA_UNITS)4)
#define FIT_EXD_DATA_UNITS_METERS_PER_HOUR                                       ((FIT_EXD_DATA_UNITS)5)
#define FIT_EXD_DATA_UNITS_DEGREES_CELSIUS                                       ((FIT_EXD_DATA_UNITS)6)
#define FIT_EXD_DATA_UNITS_DEGREES_FARENHEIT                                     ((FIT_EXD_DATA_UNITS)7)
#define FIT_EXD_DATA_UNITS_ZONE                                                  ((FIT_EXD_DATA_UNITS)8)
#define FIT_EXD_DATA_UNITS_GEAR                                                  ((FIT_EXD_DATA_UNITS)9)
#define FIT_EXD_DATA_UNITS_RPM                                                   ((FIT_EXD_DATA_UNITS)10)
#define FIT_EXD_DATA_UNITS_BPM                                                   ((FIT_EXD_DATA_UNITS)11)
#define FIT_EXD_DATA_UNITS_DEGREES                                               ((FIT_EXD_DATA_UNITS)12)
#define FIT_EXD_DATA_UNITS_MILLIMETERS                                           ((FIT_EXD_DATA_UNITS)13)
#define FIT_EXD_DATA_UNITS_METERS                                                ((FIT_EXD_DATA_UNITS)14)
#define FIT_EXD_DATA_UNITS_KILOMETERS                                            ((FIT_EXD_DATA_UNITS)15)
#define FIT_EXD_DATA_UNITS_FEET                                                  ((FIT_EXD_DATA_UNITS)16)
#define FIT_EXD_DATA_UNITS_YARDS                                                 ((FIT_EXD_DATA_UNITS)17)
#define FIT_EXD_DATA_UNITS_KILOFEET                                              ((FIT_EXD_DATA_UNITS)18)
#define FIT_EXD_DATA_UNITS_MILES                                                 ((FIT_EXD_DATA_UNITS)19)
#define FIT_EXD_DATA_UNITS_TIME                                                  ((FIT_EXD_DATA_UNITS)20)
#define FIT_EXD_DATA_UNITS_ENUM_TURN_TYPE                                        ((FIT_EXD_DATA_UNITS)21)
#define FIT_EXD_DATA_UNITS_PERCENT                                               ((FIT_EXD_DATA_UNITS)22)
#define FIT_EXD_DATA_UNITS_WATTS                                                 ((FIT_EXD_DATA_UNITS)23)
#define FIT_EXD_DATA_UNITS_WATTS_PER_KILOGRAM                                    ((FIT_EXD_DATA_UNITS)24)
#define FIT_EXD_DATA_UNITS_ENUM_BATTERY_STATUS                                   ((FIT_EXD_DATA_UNITS)25)
#define FIT_EXD_DATA_UNITS_ENUM_BIKE_LIGHT_BEAM_ANGLE_MODE                       ((FIT_EXD_DATA_UNITS)26)
#define FIT_EXD_DATA_UNITS_ENUM_BIKE_LIGHT_BATTERY_STATUS                        ((FIT_EXD_DATA_UNITS)27)
#define FIT_EXD_DATA_UNITS_ENUM_BIKE_LIGHT_NETWORK_CONFIG_TYPE                   ((FIT_EXD_DATA_UNITS)28)
#define FIT_EXD_DATA_UNITS_LIGHTS                                                ((FIT_EXD_DATA_UNITS)29)
#define FIT_EXD_DATA_UNITS_SECONDS                                               ((FIT_EXD_DATA_UNITS)30)
#define FIT_EXD_DATA_UNITS_MINUTES                                               ((FIT_EXD_DATA_UNITS)31)
#define FIT_EXD_DATA_UNITS_HOURS                                                 ((FIT_EXD_DATA_UNITS)32)
#define FIT_EXD_DATA_UNITS_CALORIES                                              ((FIT_EXD_DATA_UNITS)33)
#define FIT_EXD_DATA_UNITS_KILOJOULES                                            ((FIT_EXD_DATA_UNITS)34)
#define FIT_EXD_DATA_UNITS_MILLISECONDS                                          ((FIT_EXD_DATA_UNITS)35)
#define FIT_EXD_DATA_UNITS_SECOND_PER_MILE                                       ((FIT_EXD_DATA_UNITS)36)
#define FIT_EXD_DATA_UNITS_SECOND_PER_KILOMETER                                  ((FIT_EXD_DATA_UNITS)37)
#define FIT_EXD_DATA_UNITS_CENTIMETER                                            ((FIT_EXD_DATA_UNITS)38)
#define FIT_EXD_DATA_UNITS_ENUM_COURSE_POINT                                     ((FIT_EXD_DATA_UNITS)39)
#define FIT_EXD_DATA_UNITS_BRADIANS                                              ((FIT_EXD_DATA_UNITS)40)
#define FIT_EXD_DATA_UNITS_ENUM_SPORT                                            ((FIT_EXD_DATA_UNITS)41)
#define FIT_EXD_DATA_UNITS_INCHES_HG                                             ((FIT_EXD_DATA_UNITS)42)
#define FIT_EXD_DATA_UNITS_MM_HG                                                 ((FIT_EXD_DATA_UNITS)43)
#define FIT_EXD_DATA_UNITS_MBARS                                                 ((FIT_EXD_DATA_UNITS)44)
#define FIT_EXD_DATA_UNITS_HECTO_PASCALS                                         ((FIT_EXD_DATA_UNITS)45)
#define FIT_EXD_DATA_UNITS_FEET_PER_MIN                                          ((FIT_EXD_DATA_UNITS)46)
#define FIT_EXD_DATA_UNITS_METERS_PER_MIN                                        ((FIT_EXD_DATA_UNITS)47)
#define FIT_EXD_DATA_UNITS_METERS_PER_SEC                                        ((FIT_EXD_DATA_UNITS)48)
#define FIT_EXD_DATA_UNITS_EIGHT_CARDINAL                                        ((FIT_EXD_DATA_UNITS)49)
#define FIT_EXD_DATA_UNITS_COUNT                                                 50

typedef FIT_ENUM FIT_EXD_QUALIFIERS;
#define FIT_EXD_QUALIFIERS_INVALID                                               FIT_ENUM_INVALID
#define FIT_EXD_QUALIFIERS_NO_QUALIFIER                                          ((FIT_EXD_QUALIFIERS)0)
#define FIT_EXD_QUALIFIERS_INSTANTANEOUS                                         ((FIT_EXD_QUALIFIERS)1)
#define FIT_EXD_QUALIFIERS_AVERAGE                                               ((FIT_EXD_QUALIFIERS)2)
#define FIT_EXD_QUALIFIERS_LAP                                                   ((FIT_EXD_QUALIFIERS)3)
#define FIT_EXD_QUALIFIERS_MAXIMUM                                               ((FIT_EXD_QUALIFIERS)4)
#define FIT_EXD_QUALIFIERS_MAXIMUM_AVERAGE                                       ((FIT_EXD_QUALIFIERS)5)
#define FIT_EXD_QUALIFIERS_MAXIMUM_LAP                                           ((FIT_EXD_QUALIFIERS)6)
#define FIT_EXD_QUALIFIERS_LAST_LAP                                              ((FIT_EXD_QUALIFIERS)7)
#define FIT_EXD_QUALIFIERS_AVERAGE_LAP                                           ((FIT_EXD_QUALIFIERS)8)
#define FIT_EXD_QUALIFIERS_TO_DESTINATION                                        ((FIT_EXD_QUALIFIERS)9)
#define FIT_EXD_QUALIFIERS_TO_GO                                                 ((FIT_EXD_QUALIFIERS)10)
#define FIT_EXD_QUALIFIERS_TO_NEXT                                               ((FIT_EXD_QUALIFIERS)11)
#define FIT_EXD_QUALIFIERS_NEXT_COURSE_POINT                                     ((FIT_EXD_QUALIFIERS)12)
#define FIT_EXD_QUALIFIERS_TOTAL                                                 ((FIT_EXD_QUALIFIERS)13)
#define FIT_EXD_QUALIFIERS_THREE_SECOND_AVERAGE                                  ((FIT_EXD_QUALIFIERS)14)
#define FIT_EXD_QUALIFIERS_TEN_SECOND_AVERAGE                                    ((FIT_EXD_QUALIFIERS)15)
#define FIT_EXD_QUALIFIERS_THIRTY_SECOND_AVERAGE                                 ((FIT_EXD_QUALIFIERS)16)
#define FIT_EXD_QUALIFIERS_PERCENT_MAXIMUM                                       ((FIT_EXD_QUALIFIERS)17)
#define FIT_EXD_QUALIFIERS_PERCENT_MAXIMUM_AVERAGE                               ((FIT_EXD_QUALIFIERS)18)
#define FIT_EXD_QUALIFIERS_LAP_PERCENT_MAXIMUM                                   ((FIT_EXD_QUALIFIERS)19)
#define FIT_EXD_QUALIFIERS_ELAPSED                                               ((FIT_EXD_QUALIFIERS)20)
#define FIT_EXD_QUALIFIERS_SUNRISE                                               ((FIT_EXD_QUALIFIERS)21)
#define FIT_EXD_QUALIFIERS_SUNSET                                                ((FIT_EXD_QUALIFIERS)22)
#define FIT_EXD_QUALIFIERS_COMPARED_TO_VIRTUAL_PARTNER                           ((FIT_EXD_QUALIFIERS)23)
#define FIT_EXD_QUALIFIERS_MAXIMUM_24H                                           ((FIT_EXD_QUALIFIERS)24)
#define FIT_EXD_QUALIFIERS_MINIMUM_24H                                           ((FIT_EXD_QUALIFIERS)25)
#define FIT_EXD_QUALIFIERS_MINIMUM                                               ((FIT_EXD_QUALIFIERS)26)
#define FIT_EXD_QUALIFIERS_FIRST                                                 ((FIT_EXD_QUALIFIERS)27)
#define FIT_EXD_QUALIFIERS_SECOND                                                ((FIT_EXD_QUALIFIERS)28)
#define FIT_EXD_QUALIFIERS_THIRD                                                 ((FIT_EXD_QUALIFIERS)29)
#define FIT_EXD_QUALIFIERS_SHIFTER                                               ((FIT_EXD_QUALIFIERS)30)
#define FIT_EXD_QUALIFIERS_LAST_SPORT                                            ((FIT_EXD_QUALIFIERS)31)
#define FIT_EXD_QUALIFIERS_MOVING                                                ((FIT_EXD_QUALIFIERS)32)
#define FIT_EXD_QUALIFIERS_STOPPED                                               ((FIT_EXD_QUALIFIERS)33)
#define FIT_EXD_QUALIFIERS_ESTIMATED_TOTAL                                       ((FIT_EXD_QUALIFIERS)34)
#define FIT_EXD_QUALIFIERS_ZONE_9                                                ((FIT_EXD_QUALIFIERS)242)
#define FIT_EXD_QUALIFIERS_ZONE_8                                                ((FIT_EXD_QUALIFIERS)243)
#define FIT_EXD_QUALIFIERS_ZONE_7                                                ((FIT_EXD_QUALIFIERS)244)
#define FIT_EXD_QUALIFIERS_ZONE_6                                                ((FIT_EXD_QUALIFIERS)245)
#define FIT_EXD_QUALIFIERS_ZONE_5                                                ((FIT_EXD_QUALIFIERS)246)
#define FIT_EXD_QUALIFIERS_ZONE_4                                                ((FIT_EXD_QUALIFIERS)247)
#define FIT_EXD_QUALIFIERS_ZONE_3                                                ((FIT_EXD_QUALIFIERS)248)
#define FIT_EXD_QUALIFIERS_ZONE_2                                                ((FIT_EXD_QUALIFIERS)249)
#define FIT_EXD_QUALIFIERS_ZONE_1                                                ((FIT_EXD_QUALIFIERS)250)
#define FIT_EXD_QUALIFIERS_COUNT                                                 44

typedef FIT_ENUM FIT_EXD_DESCRIPTORS;
#define FIT_EXD_DESCRIPTORS_INVALID                                              FIT_ENUM_INVALID
#define FIT_EXD_DESCRIPTORS_BIKE_LIGHT_BATTERY_STATUS                            ((FIT_EXD_DESCRIPTORS)0)
#define FIT_EXD_DESCRIPTORS_BEAM_ANGLE_STATUS                                    ((FIT_EXD_DESCRIPTORS)1)
#define FIT_EXD_DESCRIPTORS_BATERY_LEVEL                                         ((FIT_EXD_DESCRIPTORS)2)
#define FIT_EXD_DESCRIPTORS_LIGHT_NETWORK_MODE                                   ((FIT_EXD_DESCRIPTORS)3)
#define FIT_EXD_DESCRIPTORS_NUMBER_LIGHTS_CONNECTED                              ((FIT_EXD_DESCRIPTORS)4)
#define FIT_EXD_DESCRIPTORS_CADENCE                                              ((FIT_EXD_DESCRIPTORS)5)
#define FIT_EXD_DESCRIPTORS_DISTANCE                                             ((FIT_EXD_DESCRIPTORS)6)
#define FIT_EXD_DESCRIPTORS_ESTIMATED_TIME_OF_ARRIVAL                            ((FIT_EXD_DESCRIPTORS)7)
#define FIT_EXD_DESCRIPTORS_HEADING                                              ((FIT_EXD_DESCRIPTORS)8)
#define FIT_EXD_DESCRIPTORS_TIME                                                 ((FIT_EXD_DESCRIPTORS)9)
#define FIT_EXD_DESCRIPTORS_BATTERY_LEVEL                                        ((FIT_EXD_DESCRIPTORS)10)
#define FIT_EXD_DESCRIPTORS_TRAINER_RESISTANCE                                   ((FIT_EXD_DESCRIPTORS)11)
#define FIT_EXD_DESCRIPTORS_TRAINER_TARGET_POWER                                 ((FIT_EXD_DESCRIPTORS)12)
#define FIT_EXD_DESCRIPTORS_TIME_SEATED                                          ((FIT_EXD_DESCRIPTORS)13)
#define FIT_EXD_DESCRIPTORS_TIME_STANDING                                        ((FIT_EXD_DESCRIPTORS)14)
#define FIT_EXD_DESCRIPTORS_ELEVATION                                            ((FIT_EXD_DESCRIPTORS)15)
#define FIT_EXD_DESCRIPTORS_GRADE                                                ((FIT_EXD_DESCRIPTORS)16)
#define FIT_EXD_DESCRIPTORS_ASCENT                                               ((FIT_EXD_DESCRIPTORS)17)
#define FIT_EXD_DESCRIPTORS_DESCENT                                              ((FIT_EXD_DESCRIPTORS)18)
#define FIT_EXD_DESCRIPTORS_VERTICAL_SPEED                                       ((FIT_EXD_DESCRIPTORS)19)
#define FIT_EXD_DESCRIPTORS_DI2_BATTERY_LEVEL                                    ((FIT_EXD_DESCRIPTORS)20)
#define FIT_EXD_DESCRIPTORS_FRONT_GEAR                                           ((FIT_EXD_DESCRIPTORS)21)
#define FIT_EXD_DESCRIPTORS_REAR_GEAR                                            ((FIT_EXD_DESCRIPTORS)22)
#define FIT_EXD_DESCRIPTORS_GEAR_RATIO                                           ((FIT_EXD_DESCRIPTORS)23)
#define FIT_EXD_DESCRIPTORS_HEART_RATE                                           ((FIT_EXD_DESCRIPTORS)24)
#define FIT_EXD_DESCRIPTORS_HEART_RATE_ZONE                                      ((FIT_EXD_DESCRIPTORS)25)
#define FIT_EXD_DESCRIPTORS_TIME_IN_HEART_RATE_ZONE                              ((FIT_EXD_DESCRIPTORS)26)
#define FIT_EXD_DESCRIPTORS_HEART_RATE_RESERVE                                   ((FIT_EXD_DESCRIPTORS)27)
#define FIT_EXD_DESCRIPTORS_CALORIES                                             ((FIT_EXD_DESCRIPTORS)28)
#define FIT_EXD_DESCRIPTORS_GPS_ACCURACY                                         ((FIT_EXD_DESCRIPTORS)29)
#define FIT_EXD_DESCRIPTORS_GPS_SIGNAL_STRENGTH                                  ((FIT_EXD_DESCRIPTORS)30)
#define FIT_EXD_DESCRIPTORS_TEMPERATURE                                          ((FIT_EXD_DESCRIPTORS)31)
#define FIT_EXD_DESCRIPTORS_TIME_OF_DAY                                          ((FIT_EXD_DESCRIPTORS)32)
#define FIT_EXD_DESCRIPTORS_BALANCE                                              ((FIT_EXD_DESCRIPTORS)33)
#define FIT_EXD_DESCRIPTORS_PEDAL_SMOOTHNESS                                     ((FIT_EXD_DESCRIPTORS)34)
#define FIT_EXD_DESCRIPTORS_POWER                                                ((FIT_EXD_DESCRIPTORS)35)
#define FIT_EXD_DESCRIPTORS_FUNCTIONAL_THRESHOLD_POWER                           ((FIT_EXD_DESCRIPTORS)36)
#define FIT_EXD_DESCRIPTORS_INTENSITY_FACTOR                                     ((FIT_EXD_DESCRIPTORS)37)
#define FIT_EXD_DESCRIPTORS_WORK                                                 ((FIT_EXD_DESCRIPTORS)38)
#define FIT_EXD_DESCRIPTORS_POWER_RATIO                                          ((FIT_EXD_DESCRIPTORS)39)
#define FIT_EXD_DESCRIPTORS_NORMALIZED_POWER                                     ((FIT_EXD_DESCRIPTORS)40)
#define FIT_EXD_DESCRIPTORS_TRAINING_STRESS_SCORE                                ((FIT_EXD_DESCRIPTORS)41)
#define FIT_EXD_DESCRIPTORS_TIME_ON_ZONE                                         ((FIT_EXD_DESCRIPTORS)42)
#define FIT_EXD_DESCRIPTORS_SPEED                                                ((FIT_EXD_DESCRIPTORS)43)
#define FIT_EXD_DESCRIPTORS_LAPS                                                 ((FIT_EXD_DESCRIPTORS)44)
#define FIT_EXD_DESCRIPTORS_REPS                                                 ((FIT_EXD_DESCRIPTORS)45)
#define FIT_EXD_DESCRIPTORS_WORKOUT_STEP                                         ((FIT_EXD_DESCRIPTORS)46)
#define FIT_EXD_DESCRIPTORS_COURSE_DISTANCE                                      ((FIT_EXD_DESCRIPTORS)47)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_DISTANCE                                  ((FIT_EXD_DESCRIPTORS)48)
#define FIT_EXD_DESCRIPTORS_COURSE_ESTIMATED_TIME_OF_ARRIVAL                     ((FIT_EXD_DESCRIPTORS)49)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_ESTIMATED_TIME_OF_ARRIVAL                 ((FIT_EXD_DESCRIPTORS)50)
#define FIT_EXD_DESCRIPTORS_COURSE_TIME                                          ((FIT_EXD_DESCRIPTORS)51)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_TIME                                      ((FIT_EXD_DESCRIPTORS)52)
#define FIT_EXD_DESCRIPTORS_COURSE_HEADING                                       ((FIT_EXD_DESCRIPTORS)53)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_HEADING                                   ((FIT_EXD_DESCRIPTORS)54)
#define FIT_EXD_DESCRIPTORS_POWER_ZONE                                           ((FIT_EXD_DESCRIPTORS)55)
#define FIT_EXD_DESCRIPTORS_TORQUE_EFFECTIVENESS                                 ((FIT_EXD_DESCRIPTORS)56)
#define FIT_EXD_DESCRIPTORS_TIMER_TIME                                           ((FIT_EXD_DESCRIPTORS)57)
#define FIT_EXD_DESCRIPTORS_POWER_WEIGHT_RATIO                                   ((FIT_EXD_DESCRIPTORS)58)
#define FIT_EXD_DESCRIPTORS_LEFT_PLATFORM_CENTER_OFFSET                          ((FIT_EXD_DESCRIPTORS)59)
#define FIT_EXD_DESCRIPTORS_RIGHT_PLATFORM_CENTER_OFFSET                         ((FIT_EXD_DESCRIPTORS)60)
#define FIT_EXD_DESCRIPTORS_LEFT_POWER_PHASE_START_ANGLE                         ((FIT_EXD_DESCRIPTORS)61)
#define FIT_EXD_DESCRIPTORS_RIGHT_POWER_PHASE_START_ANGLE                        ((FIT_EXD_DESCRIPTORS)62)
#define FIT_EXD_DESCRIPTORS_LEFT_POWER_PHASE_FINISH_ANGLE                        ((FIT_EXD_DESCRIPTORS)63)
#define FIT_EXD_DESCRIPTORS_RIGHT_POWER_PHASE_FINISH_ANGLE                       ((FIT_EXD_DESCRIPTORS)64)
#define FIT_EXD_DESCRIPTORS_GEARS                                                ((FIT_EXD_DESCRIPTORS)65) // Combined gear information
#define FIT_EXD_DESCRIPTORS_PACE                                                 ((FIT_EXD_DESCRIPTORS)66)
#define FIT_EXD_DESCRIPTORS_TRAINING_EFFECT                                      ((FIT_EXD_DESCRIPTORS)67)
#define FIT_EXD_DESCRIPTORS_VERTICAL_OSCILLATION                                 ((FIT_EXD_DESCRIPTORS)68)
#define FIT_EXD_DESCRIPTORS_VERTICAL_RATIO                                       ((FIT_EXD_DESCRIPTORS)69)
#define FIT_EXD_DESCRIPTORS_GROUND_CONTACT_TIME                                  ((FIT_EXD_DESCRIPTORS)70)
#define FIT_EXD_DESCRIPTORS_LEFT_GROUND_CONTACT_TIME_BALANCE                     ((FIT_EXD_DESCRIPTORS)71)
#define FIT_EXD_DESCRIPTORS_RIGHT_GROUND_CONTACT_TIME_BALANCE                    ((FIT_EXD_DESCRIPTORS)72)
#define FIT_EXD_DESCRIPTORS_STRIDE_LENGTH                                        ((FIT_EXD_DESCRIPTORS)73)
#define FIT_EXD_DESCRIPTORS_RUNNING_CADENCE                                      ((FIT_EXD_DESCRIPTORS)74)
#define FIT_EXD_DESCRIPTORS_PERFORMANCE_CONDITION                                ((FIT_EXD_DESCRIPTORS)75)
#define FIT_EXD_DESCRIPTORS_COURSE_TYPE                                          ((FIT_EXD_DESCRIPTORS)76)
#define FIT_EXD_DESCRIPTORS_TIME_IN_POWER_ZONE                                   ((FIT_EXD_DESCRIPTORS)77)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_TURN                                      ((FIT_EXD_DESCRIPTORS)78)
#define FIT_EXD_DESCRIPTORS_COURSE_LOCATION                                      ((FIT_EXD_DESCRIPTORS)79)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_LOCATION                                  ((FIT_EXD_DESCRIPTORS)80)
#define FIT_EXD_DESCRIPTORS_COMPASS                                              ((FIT_EXD_DESCRIPTORS)81)
#define FIT_EXD_DESCRIPTORS_GEAR_COMBO                                           ((FIT_EXD_DESCRIPTORS)82)
#define FIT_EXD_DESCRIPTORS_MUSCLE_OXYGEN                                        ((FIT_EXD_DESCRIPTORS)83)
#define FIT_EXD_DESCRIPTORS_ICON                                                 ((FIT_EXD_DESCRIPTORS)84)
#define FIT_EXD_DESCRIPTORS_COMPASS_HEADING                                      ((FIT_EXD_DESCRIPTORS)85)
#define FIT_EXD_DESCRIPTORS_GPS_HEADING                                          ((FIT_EXD_DESCRIPTORS)86)
#define FIT_EXD_DESCRIPTORS_GPS_ELEVATION                                        ((FIT_EXD_DESCRIPTORS)87)
#define FIT_EXD_DESCRIPTORS_ANAEROBIC_TRAINING_EFFECT                            ((FIT_EXD_DESCRIPTORS)88)
#define FIT_EXD_DESCRIPTORS_COURSE                                               ((FIT_EXD_DESCRIPTORS)89)
#define FIT_EXD_DESCRIPTORS_OFF_COURSE                                           ((FIT_EXD_DESCRIPTORS)90)
#define FIT_EXD_DESCRIPTORS_GLIDE_RATIO                                          ((FIT_EXD_DESCRIPTORS)91)
#define FIT_EXD_DESCRIPTORS_VERTICAL_DISTANCE                                    ((FIT_EXD_DESCRIPTORS)92)
#define FIT_EXD_DESCRIPTORS_VMG                                                  ((FIT_EXD_DESCRIPTORS)93)
#define FIT_EXD_DESCRIPTORS_AMBIENT_PRESSURE                                     ((FIT_EXD_DESCRIPTORS)94)
#define FIT_EXD_DESCRIPTORS_PRESSURE                                             ((FIT_EXD_DESCRIPTORS)95)
#define FIT_EXD_DESCRIPTORS_VAM                                                  ((FIT_EXD_DESCRIPTORS)96)
#define FIT_EXD_DESCRIPTORS_COUNT                                                97

typedef FIT_UINT32 FIT_AUTO_ACTIVITY_DETECT;
#define FIT_AUTO_ACTIVITY_DETECT_INVALID                                         FIT_UINT32_INVALID
#define FIT_AUTO_ACTIVITY_DETECT_NONE                                            ((FIT_AUTO_ACTIVITY_DETECT)0x00000000)
#define FIT_AUTO_ACTIVITY_DETECT_RUNNING                                         ((FIT_AUTO_ACTIVITY_DETECT)0x00000001)
#define FIT_AUTO_ACTIVITY_DETECT_CYCLING                                         ((FIT_AUTO_ACTIVITY_DETECT)0x00000002)
#define FIT_AUTO_ACTIVITY_DETECT_SWIMMING                                        ((FIT_AUTO_ACTIVITY_DETECT)0x00000004)
#define FIT_AUTO_ACTIVITY_DETECT_WALKING                                         ((FIT_AUTO_ACTIVITY_DETECT)0x00000008)
#define FIT_AUTO_ACTIVITY_DETECT_ELLIPTICAL                                      ((FIT_AUTO_ACTIVITY_DETECT)0x00000020)
#define FIT_AUTO_ACTIVITY_DETECT_SEDENTARY                                       ((FIT_AUTO_ACTIVITY_DETECT)0x00000400)
#define FIT_AUTO_ACTIVITY_DETECT_COUNT                                           7

typedef FIT_UINT32Z FIT_SUPPORTED_EXD_SCREEN_LAYOUTS;
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_INVALID                                 FIT_UINT32Z_INVALID
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_FULL_SCREEN                             ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000001)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_VERTICAL                           ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000002)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_HORIZONTAL                         ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000004)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_VERTICAL_RIGHT_SPLIT               ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000008)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_HORIZONTAL_BOTTOM_SPLIT            ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000010)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_FULL_QUARTER_SPLIT                      ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000020)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_VERTICAL_LEFT_SPLIT                ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000040)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_HORIZONTAL_TOP_SPLIT               ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000080)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_COUNT                                   8

typedef FIT_UINT8 FIT_FIT_BASE_TYPE;
#define FIT_FIT_BASE_TYPE_INVALID                                                FIT_UINT8_INVALID
#define FIT_FIT_BASE_TYPE_ENUM                                                   ((FIT_FIT_BASE_TYPE)0)
#define FIT_FIT_BASE_TYPE_SINT8                                                  ((FIT_FIT_BASE_TYPE)1)
#define FIT_FIT_BASE_TYPE_UINT8                                                  ((FIT_FIT_BASE_TYPE)2)
#define FIT_FIT_BASE_TYPE_SINT16                                                 ((FIT_FIT_BASE_TYPE)131)
#define FIT_FIT_BASE_TYPE_UINT16                                                 ((FIT_FIT_BASE_TYPE)132)
#define FIT_FIT_BASE_TYPE_SINT32                                                 ((FIT_FIT_BASE_TYPE)133)
#define FIT_FIT_BASE_TYPE_UINT32                                                 ((FIT_FIT_BASE_TYPE)134)
#define FIT_FIT_BASE_TYPE_STRING                                                 ((FIT_FIT_BASE_TYPE)7)
#define FIT_FIT_BASE_TYPE_FLOAT32                                                ((FIT_FIT_BASE_TYPE)136)
#define FIT_FIT_BASE_TYPE_FLOAT64                                                ((FIT_FIT_BASE_TYPE)137)
#define FIT_FIT_BASE_TYPE_UINT8Z                                                 ((FIT_FIT_BASE_TYPE)10)
#define FIT_FIT_BASE_TYPE_UINT16Z                                                ((FIT_FIT_BASE_TYPE)139)
#define FIT_FIT_BASE_TYPE_UINT32Z                                                ((FIT_FIT_BASE_TYPE)140)
#define FIT_FIT_BASE_TYPE_BYTE                                                   ((FIT_FIT_BASE_TYPE)13)
#define FIT_FIT_BASE_TYPE_SINT64                                                 ((FIT_FIT_BASE_TYPE)142)
#define FIT_FIT_BASE_TYPE_UINT64                                                 ((FIT_FIT_BASE_TYPE)143)
#define FIT_FIT_BASE_TYPE_UINT64Z                                                ((FIT_FIT_BASE_TYPE)144)
#define FIT_FIT_BASE_TYPE_COUNT                                                  17

typedef FIT_ENUM FIT_TURN_TYPE;
#define FIT_TURN_TYPE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_TURN_TYPE_ARRIVING_IDX                                               ((FIT_TURN_TYPE)0)
#define FIT_TURN_TYPE_ARRIVING_LEFT_IDX                                          ((FIT_TURN_TYPE)1)
#define FIT_TURN_TYPE_ARRIVING_RIGHT_IDX                                         ((FIT_TURN_TYPE)2)
#define FIT_TURN_TYPE_ARRIVING_VIA_IDX                                           ((FIT_TURN_TYPE)3)
#define FIT_TURN_TYPE_ARRIVING_VIA_LEFT_IDX                                      ((FIT_TURN_TYPE)4)
#define FIT_TURN_TYPE_ARRIVING_VIA_RIGHT_IDX                                     ((FIT_TURN_TYPE)5)
#define FIT_TURN_TYPE_BEAR_KEEP_LEFT_IDX                                         ((FIT_TURN_TYPE)6)
#define FIT_TURN_TYPE_BEAR_KEEP_RIGHT_IDX                                        ((FIT_TURN_TYPE)7)
#define FIT_TURN_TYPE_CONTINUE_IDX                                               ((FIT_TURN_TYPE)8)
#define FIT_TURN_TYPE_EXIT_LEFT_IDX                                              ((FIT_TURN_TYPE)9)
#define FIT_TURN_TYPE_EXIT_RIGHT_IDX                                             ((FIT_TURN_TYPE)10)
#define FIT_TURN_TYPE_FERRY_IDX                                                  ((FIT_TURN_TYPE)11)
#define FIT_TURN_TYPE_ROUNDABOUT_45_IDX                                          ((FIT_TURN_TYPE)12)
#define FIT_TURN_TYPE_ROUNDABOUT_90_IDX                                          ((FIT_TURN_TYPE)13)
#define FIT_TURN_TYPE_ROUNDABOUT_135_IDX                                         ((FIT_TURN_TYPE)14)
#define FIT_TURN_TYPE_ROUNDABOUT_180_IDX                                         ((FIT_TURN_TYPE)15)
#define FIT_TURN_TYPE_ROUNDABOUT_225_IDX                                         ((FIT_TURN_TYPE)16)
#define FIT_TURN_TYPE_ROUNDABOUT_270_IDX                                         ((FIT_TURN_TYPE)17)
#define FIT_TURN_TYPE_ROUNDABOUT_315_IDX                                         ((FIT_TURN_TYPE)18)
#define FIT_TURN_TYPE_ROUNDABOUT_360_IDX                                         ((FIT_TURN_TYPE)19)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_45_IDX                                      ((FIT_TURN_TYPE)20)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_90_IDX                                      ((FIT_TURN_TYPE)21)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_135_IDX                                     ((FIT_TURN_TYPE)22)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_180_IDX                                     ((FIT_TURN_TYPE)23)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_225_IDX                                     ((FIT_TURN_TYPE)24)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_270_IDX                                     ((FIT_TURN_TYPE)25)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_315_IDX                                     ((FIT_TURN_TYPE)26)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_360_IDX                                     ((FIT_TURN_TYPE)27)
#define FIT_TURN_TYPE_ROUNDABOUT_GENERIC_IDX                                     ((FIT_TURN_TYPE)28)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_GENERIC_IDX                                 ((FIT_TURN_TYPE)29)
#define FIT_TURN_TYPE_SHARP_TURN_LEFT_IDX                                        ((FIT_TURN_TYPE)30)
#define FIT_TURN_TYPE_SHARP_TURN_RIGHT_IDX                                       ((FIT_TURN_TYPE)31)
#define FIT_TURN_TYPE_TURN_LEFT_IDX                                              ((FIT_TURN_TYPE)32)
#define FIT_TURN_TYPE_TURN_RIGHT_IDX                                             ((FIT_TURN_TYPE)33)
#define FIT_TURN_TYPE_UTURN_LEFT_IDX                                             ((FIT_TURN_TYPE)34)
#define FIT_TURN_TYPE_UTURN_RIGHT_IDX                                            ((FIT_TURN_TYPE)35)
#define FIT_TURN_TYPE_ICON_INV_IDX                                               ((FIT_TURN_TYPE)36)
#define FIT_TURN_TYPE_ICON_IDX_CNT                                               ((FIT_TURN_TYPE)37)
#define FIT_TURN_TYPE_COUNT                                                      38

typedef FIT_UINT8 FIT_BIKE_LIGHT_BEAM_ANGLE_MODE;
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_INVALID                                   FIT_UINT8_INVALID
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_MANUAL                                    ((FIT_BIKE_LIGHT_BEAM_ANGLE_MODE)0)
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_AUTO                                      ((FIT_BIKE_LIGHT_BEAM_ANGLE_MODE)1)
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_COUNT                                     2

typedef FIT_UINT16 FIT_FIT_BASE_UNIT;
#define FIT_FIT_BASE_UNIT_INVALID                                                FIT_UINT16_INVALID
#define FIT_FIT_BASE_UNIT_OTHER                                                  ((FIT_FIT_BASE_UNIT)0)
#define FIT_FIT_BASE_UNIT_KILOGRAM                                               ((FIT_FIT_BASE_UNIT)1)
#define FIT_FIT_BASE_UNIT_POUND                                                  ((FIT_FIT_BASE_UNIT)2)
#define FIT_FIT_BASE_UNIT_COUNT                                                  3

typedef FIT_UINT8 FIT_SET_TYPE;
#define FIT_SET_TYPE_INVALID                                                     FIT_UINT8_INVALID
#define FIT_SET_TYPE_REST                                                        ((FIT_SET_TYPE)0)
#define FIT_SET_TYPE_ACTIVE                                                      ((FIT_SET_TYPE)1)
#define FIT_SET_TYPE_COUNT                                                       2

typedef FIT_ENUM FIT_MAX_MET_CATEGORY;
#define FIT_MAX_MET_CATEGORY_INVALID                                             FIT_ENUM_INVALID
#define FIT_MAX_MET_CATEGORY_GENERIC                                             ((FIT_MAX_MET_CATEGORY)0)
#define FIT_MAX_MET_CATEGORY_CYCLING                                             ((FIT_MAX_MET_CATEGORY)1)
#define FIT_MAX_MET_CATEGORY_COUNT                                               2

typedef FIT_UINT16 FIT_EXERCISE_CATEGORY;
#define FIT_EXERCISE_CATEGORY_INVALID                                            FIT_UINT16_INVALID
#define FIT_EXERCISE_CATEGORY_BENCH_PRESS                                        ((FIT_EXERCISE_CATEGORY)0)
#define FIT_EXERCISE_CATEGORY_CALF_RAISE                                         ((FIT_EXERCISE_CATEGORY)1)
#define FIT_EXERCISE_CATEGORY_CARDIO                                             ((FIT_EXERCISE_CATEGORY)2)
#define FIT_EXERCISE_CATEGORY_CARRY                                              ((FIT_EXERCISE_CATEGORY)3)
#define FIT_EXERCISE_CATEGORY_CHOP                                               ((FIT_EXERCISE_CATEGORY)4)
#define FIT_EXERCISE_CATEGORY_CORE                                               ((FIT_EXERCISE_CATEGORY)5)
#define FIT_EXERCISE_CATEGORY_CRUNCH                                             ((FIT_EXERCISE_CATEGORY)6)
#define FIT_EXERCISE_CATEGORY_CURL                                               ((FIT_EXERCISE_CATEGORY)7)
#define FIT_EXERCISE_CATEGORY_DEADLIFT                                           ((FIT_EXERCISE_CATEGORY)8)
#define FIT_EXERCISE_CATEGORY_FLYE                                               ((FIT_EXERCISE_CATEGORY)9)
#define FIT_EXERCISE_CATEGORY_HIP_RAISE                                          ((FIT_EXERCISE_CATEGORY)10)
#define FIT_EXERCISE_CATEGORY_HIP_STABILITY                                      ((FIT_EXERCISE_CATEGORY)11)
#define FIT_EXERCISE_CATEGORY_HIP_SWING                                          ((FIT_EXERCISE_CATEGORY)12)
#define FIT_EXERCISE_CATEGORY_HYPEREXTENSION                                     ((FIT_EXERCISE_CATEGORY)13)
#define FIT_EXERCISE_CATEGORY_LATERAL_RAISE                                      ((FIT_EXERCISE_CATEGORY)14)
#define FIT_EXERCISE_CATEGORY_LEG_CURL                                           ((FIT_EXERCISE_CATEGORY)15)
#define FIT_EXERCISE_CATEGORY_LEG_RAISE                                          ((FIT_EXERCISE_CATEGORY)16)
#define FIT_EXERCISE_CATEGORY_LUNGE                                              ((FIT_EXERCISE_CATEGORY)17)
#define FIT_EXERCISE_CATEGORY_OLYMPIC_LIFT                                       ((FIT_EXERCISE_CATEGORY)18)
#define FIT_EXERCISE_CATEGORY_PLANK                                              ((FIT_EXERCISE_CATEGORY)19)
#define FIT_EXERCISE_CATEGORY_PLYO                                               ((FIT_EXERCISE_CATEGORY)20)
#define FIT_EXERCISE_CATEGORY_PULL_UP                                            ((FIT_EXERCISE_CATEGORY)21)
#define FIT_EXERCISE_CATEGORY_PUSH_UP                                            ((FIT_EXERCISE_CATEGORY)22)
#define FIT_EXERCISE_CATEGORY_ROW                                                ((FIT_EXERCISE_CATEGORY)23)
#define FIT_EXERCISE_CATEGORY_SHOULDER_PRESS                                     ((FIT_EXERCISE_CATEGORY)24)
#define FIT_EXERCISE_CATEGORY_SHOULDER_STABILITY                                 ((FIT_EXERCISE_CATEGORY)25)
#define FIT_EXERCISE_CATEGORY_SHRUG                                              ((FIT_EXERCISE_CATEGORY)26)
#define FIT_EXERCISE_CATEGORY_SIT_UP                                             ((FIT_EXERCISE_CATEGORY)27)
#define FIT_EXERCISE_CATEGORY_SQUAT                                              ((FIT_EXERCISE_CATEGORY)28)
#define FIT_EXERCISE_CATEGORY_TOTAL_BODY                                         ((FIT_EXERCISE_CATEGORY)29)
#define FIT_EXERCISE_CATEGORY_TRICEPS_EXTENSION                                  ((FIT_EXERCISE_CATEGORY)30)
#define FIT_EXERCISE_CATEGORY_WARM_UP                                            ((FIT_EXERCISE_CATEGORY)31)
#define FIT_EXERCISE_CATEGORY_RUN                                                ((FIT_EXERCISE_CATEGORY)32)
#define FIT_EXERCISE_CATEGORY_UNKNOWN                                            ((FIT_EXERCISE_CATEGORY)65534)
#define FIT_EXERCISE_CATEGORY_COUNT                                              34

typedef FIT_UINT16 FIT_BENCH_PRESS_EXERCISE_NAME;
#define FIT_BENCH_PRESS_EXERCISE_NAME_INVALID                                    FIT_UINT16_INVALID
#define FIT_BENCH_PRESS_EXERCISE_NAME_ALTERNATING_DUMBBELL_CHEST_PRESS_ON_SWISS_BALL ((FIT_BENCH_PRESS_EXERCISE_NAME)0)
#define FIT_BENCH_PRESS_EXERCISE_NAME_BARBELL_BENCH_PRESS                        ((FIT_BENCH_PRESS_EXERCISE_NAME)1)
#define FIT_BENCH_PRESS_EXERCISE_NAME_BARBELL_BOARD_BENCH_PRESS                  ((FIT_BENCH_PRESS_EXERCISE_NAME)2)
#define FIT_BENCH_PRESS_EXERCISE_NAME_BARBELL_FLOOR_PRESS                        ((FIT_BENCH_PRESS_EXERCISE_NAME)3)
#define FIT_BENCH_PRESS_EXERCISE_NAME_CLOSE_GRIP_BARBELL_BENCH_PRESS             ((FIT_BENCH_PRESS_EXERCISE_NAME)4)
#define FIT_BENCH_PRESS_EXERCISE_NAME_DECLINE_DUMBBELL_BENCH_PRESS               ((FIT_BENCH_PRESS_EXERCISE_NAME)5)
#define FIT_BENCH_PRESS_EXERCISE_NAME_DUMBBELL_BENCH_PRESS                       ((FIT_BENCH_PRESS_EXERCISE_NAME)6)
#define FIT_BENCH_PRESS_EXERCISE_NAME_DUMBBELL_FLOOR_PRESS                       ((FIT_BENCH_PRESS_EXERCISE_NAME)7)
#define FIT_BENCH_PRESS_EXERCISE_NAME_INCLINE_BARBELL_BENCH_PRESS                ((FIT_BENCH_PRESS_EXERCISE_NAME)8)
#define FIT_BENCH_PRESS_EXERCISE_NAME_INCLINE_DUMBBELL_BENCH_PRESS               ((FIT_BENCH_PRESS_EXERCISE_NAME)9)
#define FIT_BENCH_PRESS_EXERCISE_NAME_INCLINE_SMITH_MACHINE_BENCH_PRESS          ((FIT_BENCH_PRESS_EXERCISE_NAME)10)
#define FIT_BENCH_PRESS_EXERCISE_NAME_ISOMETRIC_BARBELL_BENCH_PRESS              ((FIT_BENCH_PRESS_EXERCISE_NAME)11)
#define FIT_BENCH_PRESS_EXERCISE_NAME_KETTLEBELL_CHEST_PRESS                     ((FIT_BENCH_PRESS_EXERCISE_NAME)12)
#define FIT_BENCH_PRESS_EXERCISE_NAME_NEUTRAL_GRIP_DUMBBELL_BENCH_PRESS          ((FIT_BENCH_PRESS_EXERCISE_NAME)13)
#define FIT_BENCH_PRESS_EXERCISE_NAME_NEUTRAL_GRIP_DUMBBELL_INCLINE_BENCH_PRESS  ((FIT_BENCH_PRESS_EXERCISE_NAME)14)
#define FIT_BENCH_PRESS_EXERCISE_NAME_ONE_ARM_FLOOR_PRESS                        ((FIT_BENCH_PRESS_EXERCISE_NAME)15)
#define FIT_BENCH_PRESS_EXERCISE_NAME_WEIGHTED_ONE_ARM_FLOOR_PRESS               ((FIT_BENCH_PRESS_EXERCISE_NAME)16)
#define FIT_BENCH_PRESS_EXERCISE_NAME_PARTIAL_LOCKOUT                            ((FIT_BENCH_PRESS_EXERCISE_NAME)17)
#define FIT_BENCH_PRESS_EXERCISE_NAME_REVERSE_GRIP_BARBELL_BENCH_PRESS           ((FIT_BENCH_PRESS_EXERCISE_NAME)18)
#define FIT_BENCH_PRESS_EXERCISE_NAME_REVERSE_GRIP_INCLINE_BENCH_PRESS           ((FIT_BENCH_PRESS_EXERCISE_NAME)19)
#define FIT_BENCH_PRESS_EXERCISE_NAME_SINGLE_ARM_CABLE_CHEST_PRESS               ((FIT_BENCH_PRESS_EXERCISE_NAME)20)
#define FIT_BENCH_PRESS_EXERCISE_NAME_SINGLE_ARM_DUMBBELL_BENCH_PRESS            ((FIT_BENCH_PRESS_EXERCISE_NAME)21)
#define FIT_BENCH_PRESS_EXERCISE_NAME_SMITH_MACHINE_BENCH_PRESS                  ((FIT_BENCH_PRESS_EXERCISE_NAME)22)
#define FIT_BENCH_PRESS_EXERCISE_NAME_SWISS_BALL_DUMBBELL_CHEST_PRESS            ((FIT_BENCH_PRESS_EXERCISE_NAME)23)
#define FIT_BENCH_PRESS_EXERCISE_NAME_TRIPLE_STOP_BARBELL_BENCH_PRESS            ((FIT_BENCH_PRESS_EXERCISE_NAME)24)
#define FIT_BENCH_PRESS_EXERCISE_NAME_WIDE_GRIP_BARBELL_BENCH_PRESS              ((FIT_BENCH_PRESS_EXERCISE_NAME)25)
#define FIT_BENCH_PRESS_EXERCISE_NAME_ALTERNATING_DUMBBELL_CHEST_PRESS           ((FIT_BENCH_PRESS_EXERCISE_NAME)26)
#define FIT_BENCH_PRESS_EXERCISE_NAME_COUNT                                      27

typedef FIT_UINT16 FIT_CALF_RAISE_EXERCISE_NAME;
#define FIT_CALF_RAISE_EXERCISE_NAME_INVALID                                     FIT_UINT16_INVALID
#define FIT_CALF_RAISE_EXERCISE_NAME_3_WAY_CALF_RAISE                            ((FIT_CALF_RAISE_EXERCISE_NAME)0)
#define FIT_CALF_RAISE_EXERCISE_NAME_3_WAY_WEIGHTED_CALF_RAISE                   ((FIT_CALF_RAISE_EXERCISE_NAME)1)
#define FIT_CALF_RAISE_EXERCISE_NAME_3_WAY_SINGLE_LEG_CALF_RAISE                 ((FIT_CALF_RAISE_EXERCISE_NAME)2)
#define FIT_CALF_RAISE_EXERCISE_NAME_3_WAY_WEIGHTED_SINGLE_LEG_CALF_RAISE        ((FIT_CALF_RAISE_EXERCISE_NAME)3)
#define FIT_CALF_RAISE_EXERCISE_NAME_DONKEY_CALF_RAISE                           ((FIT_CALF_RAISE_EXERCISE_NAME)4)
#define FIT_CALF_RAISE_EXERCISE_NAME_WEIGHTED_DONKEY_CALF_RAISE                  ((FIT_CALF_RAISE_EXERCISE_NAME)5)
#define FIT_CALF_RAISE_EXERCISE_NAME_SEATED_CALF_RAISE                           ((FIT_CALF_RAISE_EXERCISE_NAME)6)
#define FIT_CALF_RAISE_EXERCISE_NAME_WEIGHTED_SEATED_CALF_RAISE                  ((FIT_CALF_RAISE_EXERCISE_NAME)7)
#define FIT_CALF_RAISE_EXERCISE_NAME_SEATED_DUMBBELL_TOE_RAISE                   ((FIT_CALF_RAISE_EXERCISE_NAME)8)
#define FIT_CALF_RAISE_EXERCISE_NAME_SINGLE_LEG_BENT_KNEE_CALF_RAISE             ((FIT_CALF_RAISE_EXERCISE_NAME)9)
#define FIT_CALF_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_BENT_KNEE_CALF_RAISE    ((FIT_CALF_RAISE_EXERCISE_NAME)10)
#define FIT_CALF_RAISE_EXERCISE_NAME_SINGLE_LEG_DECLINE_PUSH_UP                  ((FIT_CALF_RAISE_EXERCISE_NAME)11)
#define FIT_CALF_RAISE_EXERCISE_NAME_SINGLE_LEG_DONKEY_CALF_RAISE                ((FIT_CALF_RAISE_EXERCISE_NAME)12)
#define FIT_CALF_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_DONKEY_CALF_RAISE       ((FIT_CALF_RAISE_EXERCISE_NAME)13)
#define FIT_CALF_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE_WITH_KNEE_HOLD         ((FIT_CALF_RAISE_EXERCISE_NAME)14)
#define FIT_CALF_RAISE_EXERCISE_NAME_SINGLE_LEG_STANDING_CALF_RAISE              ((FIT_CALF_RAISE_EXERCISE_NAME)15)
#define FIT_CALF_RAISE_EXERCISE_NAME_SINGLE_LEG_STANDING_DUMBBELL_CALF_RAISE     ((FIT_CALF_RAISE_EXERCISE_NAME)16)
#define FIT_CALF_RAISE_EXERCISE_NAME_STANDING_BARBELL_CALF_RAISE                 ((FIT_CALF_RAISE_EXERCISE_NAME)17)
#define FIT_CALF_RAISE_EXERCISE_NAME_STANDING_CALF_RAISE                         ((FIT_CALF_RAISE_EXERCISE_NAME)18)
#define FIT_CALF_RAISE_EXERCISE_NAME_WEIGHTED_STANDING_CALF_RAISE                ((FIT_CALF_RAISE_EXERCISE_NAME)19)
#define FIT_CALF_RAISE_EXERCISE_NAME_STANDING_DUMBBELL_CALF_RAISE                ((FIT_CALF_RAISE_EXERCISE_NAME)20)
#define FIT_CALF_RAISE_EXERCISE_NAME_COUNT                                       21

typedef FIT_UINT16 FIT_CARDIO_EXERCISE_NAME;
#define FIT_CARDIO_EXERCISE_NAME_INVALID                                         FIT_UINT16_INVALID
#define FIT_CARDIO_EXERCISE_NAME_BOB_AND_WEAVE_CIRCLE                            ((FIT_CARDIO_EXERCISE_NAME)0)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_BOB_AND_WEAVE_CIRCLE                   ((FIT_CARDIO_EXERCISE_NAME)1)
#define FIT_CARDIO_EXERCISE_NAME_CARDIO_CORE_CRAWL                               ((FIT_CARDIO_EXERCISE_NAME)2)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_CARDIO_CORE_CRAWL                      ((FIT_CARDIO_EXERCISE_NAME)3)
#define FIT_CARDIO_EXERCISE_NAME_DOUBLE_UNDER                                    ((FIT_CARDIO_EXERCISE_NAME)4)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_DOUBLE_UNDER                           ((FIT_CARDIO_EXERCISE_NAME)5)
#define FIT_CARDIO_EXERCISE_NAME_JUMP_ROPE                                       ((FIT_CARDIO_EXERCISE_NAME)6)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_JUMP_ROPE                              ((FIT_CARDIO_EXERCISE_NAME)7)
#define FIT_CARDIO_EXERCISE_NAME_JUMP_ROPE_CROSSOVER                             ((FIT_CARDIO_EXERCISE_NAME)8)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_JUMP_ROPE_CROSSOVER                    ((FIT_CARDIO_EXERCISE_NAME)9)
#define FIT_CARDIO_EXERCISE_NAME_JUMP_ROPE_JOG                                   ((FIT_CARDIO_EXERCISE_NAME)10)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_JUMP_ROPE_JOG                          ((FIT_CARDIO_EXERCISE_NAME)11)
#define FIT_CARDIO_EXERCISE_NAME_JUMPING_JACKS                                   ((FIT_CARDIO_EXERCISE_NAME)12)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_JUMPING_JACKS                          ((FIT_CARDIO_EXERCISE_NAME)13)
#define FIT_CARDIO_EXERCISE_NAME_SKI_MOGULS                                      ((FIT_CARDIO_EXERCISE_NAME)14)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_SKI_MOGULS                             ((FIT_CARDIO_EXERCISE_NAME)15)
#define FIT_CARDIO_EXERCISE_NAME_SPLIT_JACKS                                     ((FIT_CARDIO_EXERCISE_NAME)16)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_SPLIT_JACKS                            ((FIT_CARDIO_EXERCISE_NAME)17)
#define FIT_CARDIO_EXERCISE_NAME_SQUAT_JACKS                                     ((FIT_CARDIO_EXERCISE_NAME)18)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_SQUAT_JACKS                            ((FIT_CARDIO_EXERCISE_NAME)19)
#define FIT_CARDIO_EXERCISE_NAME_TRIPLE_UNDER                                    ((FIT_CARDIO_EXERCISE_NAME)20)
#define FIT_CARDIO_EXERCISE_NAME_WEIGHTED_TRIPLE_UNDER                           ((FIT_CARDIO_EXERCISE_NAME)21)
#define FIT_CARDIO_EXERCISE_NAME_COUNT                                           22

typedef FIT_UINT16 FIT_CARRY_EXERCISE_NAME;
#define FIT_CARRY_EXERCISE_NAME_INVALID                                          FIT_UINT16_INVALID
#define FIT_CARRY_EXERCISE_NAME_BAR_HOLDS                                        ((FIT_CARRY_EXERCISE_NAME)0)
#define FIT_CARRY_EXERCISE_NAME_FARMERS_WALK                                     ((FIT_CARRY_EXERCISE_NAME)1)
#define FIT_CARRY_EXERCISE_NAME_FARMERS_WALK_ON_TOES                             ((FIT_CARRY_EXERCISE_NAME)2)
#define FIT_CARRY_EXERCISE_NAME_HEX_DUMBBELL_HOLD                                ((FIT_CARRY_EXERCISE_NAME)3)
#define FIT_CARRY_EXERCISE_NAME_OVERHEAD_CARRY                                   ((FIT_CARRY_EXERCISE_NAME)4)
#define FIT_CARRY_EXERCISE_NAME_COUNT                                            5

typedef FIT_UINT16 FIT_CHOP_EXERCISE_NAME;
#define FIT_CHOP_EXERCISE_NAME_INVALID                                           FIT_UINT16_INVALID
#define FIT_CHOP_EXERCISE_NAME_CABLE_PULL_THROUGH                                ((FIT_CHOP_EXERCISE_NAME)0)
#define FIT_CHOP_EXERCISE_NAME_CABLE_ROTATIONAL_LIFT                             ((FIT_CHOP_EXERCISE_NAME)1)
#define FIT_CHOP_EXERCISE_NAME_CABLE_WOODCHOP                                    ((FIT_CHOP_EXERCISE_NAME)2)
#define FIT_CHOP_EXERCISE_NAME_CROSS_CHOP_TO_KNEE                                ((FIT_CHOP_EXERCISE_NAME)3)
#define FIT_CHOP_EXERCISE_NAME_WEIGHTED_CROSS_CHOP_TO_KNEE                       ((FIT_CHOP_EXERCISE_NAME)4)
#define FIT_CHOP_EXERCISE_NAME_DUMBBELL_CHOP                                     ((FIT_CHOP_EXERCISE_NAME)5)
#define FIT_CHOP_EXERCISE_NAME_HALF_KNEELING_ROTATION                            ((FIT_CHOP_EXERCISE_NAME)6)
#define FIT_CHOP_EXERCISE_NAME_WEIGHTED_HALF_KNEELING_ROTATION                   ((FIT_CHOP_EXERCISE_NAME)7)
#define FIT_CHOP_EXERCISE_NAME_HALF_KNEELING_ROTATIONAL_CHOP                     ((FIT_CHOP_EXERCISE_NAME)8)
#define FIT_CHOP_EXERCISE_NAME_HALF_KNEELING_ROTATIONAL_REVERSE_CHOP             ((FIT_CHOP_EXERCISE_NAME)9)
#define FIT_CHOP_EXERCISE_NAME_HALF_KNEELING_STABILITY_CHOP                      ((FIT_CHOP_EXERCISE_NAME)10)
#define FIT_CHOP_EXERCISE_NAME_HALF_KNEELING_STABILITY_REVERSE_CHOP              ((FIT_CHOP_EXERCISE_NAME)11)
#define FIT_CHOP_EXERCISE_NAME_KNEELING_ROTATIONAL_CHOP                          ((FIT_CHOP_EXERCISE_NAME)12)
#define FIT_CHOP_EXERCISE_NAME_KNEELING_ROTATIONAL_REVERSE_CHOP                  ((FIT_CHOP_EXERCISE_NAME)13)
#define FIT_CHOP_EXERCISE_NAME_KNEELING_STABILITY_CHOP                           ((FIT_CHOP_EXERCISE_NAME)14)
#define FIT_CHOP_EXERCISE_NAME_KNEELING_WOODCHOPPER                              ((FIT_CHOP_EXERCISE_NAME)15)
#define FIT_CHOP_EXERCISE_NAME_MEDICINE_BALL_WOOD_CHOPS                          ((FIT_CHOP_EXERCISE_NAME)16)
#define FIT_CHOP_EXERCISE_NAME_POWER_SQUAT_CHOPS                                 ((FIT_CHOP_EXERCISE_NAME)17)
#define FIT_CHOP_EXERCISE_NAME_WEIGHTED_POWER_SQUAT_CHOPS                        ((FIT_CHOP_EXERCISE_NAME)18)
#define FIT_CHOP_EXERCISE_NAME_STANDING_ROTATIONAL_CHOP                          ((FIT_CHOP_EXERCISE_NAME)19)
#define FIT_CHOP_EXERCISE_NAME_STANDING_SPLIT_ROTATIONAL_CHOP                    ((FIT_CHOP_EXERCISE_NAME)20)
#define FIT_CHOP_EXERCISE_NAME_STANDING_SPLIT_ROTATIONAL_REVERSE_CHOP            ((FIT_CHOP_EXERCISE_NAME)21)
#define FIT_CHOP_EXERCISE_NAME_STANDING_STABILITY_REVERSE_CHOP                   ((FIT_CHOP_EXERCISE_NAME)22)
#define FIT_CHOP_EXERCISE_NAME_COUNT                                             23

typedef FIT_UINT16 FIT_CORE_EXERCISE_NAME;
#define FIT_CORE_EXERCISE_NAME_INVALID                                           FIT_UINT16_INVALID
#define FIT_CORE_EXERCISE_NAME_ABS_JABS                                          ((FIT_CORE_EXERCISE_NAME)0)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_ABS_JABS                                 ((FIT_CORE_EXERCISE_NAME)1)
#define FIT_CORE_EXERCISE_NAME_ALTERNATING_PLATE_REACH                           ((FIT_CORE_EXERCISE_NAME)2)
#define FIT_CORE_EXERCISE_NAME_BARBELL_ROLLOUT                                   ((FIT_CORE_EXERCISE_NAME)3)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_BARBELL_ROLLOUT                          ((FIT_CORE_EXERCISE_NAME)4)
#define FIT_CORE_EXERCISE_NAME_BODY_BAR_OBLIQUE_TWIST                            ((FIT_CORE_EXERCISE_NAME)5)
#define FIT_CORE_EXERCISE_NAME_CABLE_CORE_PRESS                                  ((FIT_CORE_EXERCISE_NAME)6)
#define FIT_CORE_EXERCISE_NAME_CABLE_SIDE_BEND                                   ((FIT_CORE_EXERCISE_NAME)7)
#define FIT_CORE_EXERCISE_NAME_SIDE_BEND                                         ((FIT_CORE_EXERCISE_NAME)8)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_SIDE_BEND                                ((FIT_CORE_EXERCISE_NAME)9)
#define FIT_CORE_EXERCISE_NAME_CRESCENT_CIRCLE                                   ((FIT_CORE_EXERCISE_NAME)10)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_CRESCENT_CIRCLE                          ((FIT_CORE_EXERCISE_NAME)11)
#define FIT_CORE_EXERCISE_NAME_CYCLING_RUSSIAN_TWIST                             ((FIT_CORE_EXERCISE_NAME)12)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_CYCLING_RUSSIAN_TWIST                    ((FIT_CORE_EXERCISE_NAME)13)
#define FIT_CORE_EXERCISE_NAME_ELEVATED_FEET_RUSSIAN_TWIST                       ((FIT_CORE_EXERCISE_NAME)14)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_ELEVATED_FEET_RUSSIAN_TWIST              ((FIT_CORE_EXERCISE_NAME)15)
#define FIT_CORE_EXERCISE_NAME_HALF_TURKISH_GET_UP                               ((FIT_CORE_EXERCISE_NAME)16)
#define FIT_CORE_EXERCISE_NAME_KETTLEBELL_WINDMILL                               ((FIT_CORE_EXERCISE_NAME)17)
#define FIT_CORE_EXERCISE_NAME_KNEELING_AB_WHEEL                                 ((FIT_CORE_EXERCISE_NAME)18)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_KNEELING_AB_WHEEL                        ((FIT_CORE_EXERCISE_NAME)19)
#define FIT_CORE_EXERCISE_NAME_MODIFIED_FRONT_LEVER                              ((FIT_CORE_EXERCISE_NAME)20)
#define FIT_CORE_EXERCISE_NAME_OPEN_KNEE_TUCKS                                   ((FIT_CORE_EXERCISE_NAME)21)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_OPEN_KNEE_TUCKS                          ((FIT_CORE_EXERCISE_NAME)22)
#define FIT_CORE_EXERCISE_NAME_SIDE_ABS_LEG_LIFT                                 ((FIT_CORE_EXERCISE_NAME)23)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_SIDE_ABS_LEG_LIFT                        ((FIT_CORE_EXERCISE_NAME)24)
#define FIT_CORE_EXERCISE_NAME_SWISS_BALL_JACKKNIFE                              ((FIT_CORE_EXERCISE_NAME)25)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_SWISS_BALL_JACKKNIFE                     ((FIT_CORE_EXERCISE_NAME)26)
#define FIT_CORE_EXERCISE_NAME_SWISS_BALL_PIKE                                   ((FIT_CORE_EXERCISE_NAME)27)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PIKE                          ((FIT_CORE_EXERCISE_NAME)28)
#define FIT_CORE_EXERCISE_NAME_SWISS_BALL_ROLLOUT                                ((FIT_CORE_EXERCISE_NAME)29)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_SWISS_BALL_ROLLOUT                       ((FIT_CORE_EXERCISE_NAME)30)
#define FIT_CORE_EXERCISE_NAME_TRIANGLE_HIP_PRESS                                ((FIT_CORE_EXERCISE_NAME)31)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_TRIANGLE_HIP_PRESS                       ((FIT_CORE_EXERCISE_NAME)32)
#define FIT_CORE_EXERCISE_NAME_TRX_SUSPENDED_JACKKNIFE                           ((FIT_CORE_EXERCISE_NAME)33)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_TRX_SUSPENDED_JACKKNIFE                  ((FIT_CORE_EXERCISE_NAME)34)
#define FIT_CORE_EXERCISE_NAME_U_BOAT                                            ((FIT_CORE_EXERCISE_NAME)35)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_U_BOAT                                   ((FIT_CORE_EXERCISE_NAME)36)
#define FIT_CORE_EXERCISE_NAME_WINDMILL_SWITCHES                                 ((FIT_CORE_EXERCISE_NAME)37)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_WINDMILL_SWITCHES                        ((FIT_CORE_EXERCISE_NAME)38)
#define FIT_CORE_EXERCISE_NAME_ALTERNATING_SLIDE_OUT                             ((FIT_CORE_EXERCISE_NAME)39)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_ALTERNATING_SLIDE_OUT                    ((FIT_CORE_EXERCISE_NAME)40)
#define FIT_CORE_EXERCISE_NAME_GHD_BACK_EXTENSIONS                               ((FIT_CORE_EXERCISE_NAME)41)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_GHD_BACK_EXTENSIONS                      ((FIT_CORE_EXERCISE_NAME)42)
#define FIT_CORE_EXERCISE_NAME_OVERHEAD_WALK                                     ((FIT_CORE_EXERCISE_NAME)43)
#define FIT_CORE_EXERCISE_NAME_INCHWORM                                          ((FIT_CORE_EXERCISE_NAME)44)
#define FIT_CORE_EXERCISE_NAME_WEIGHTED_MODIFIED_FRONT_LEVER                     ((FIT_CORE_EXERCISE_NAME)45)
#define FIT_CORE_EXERCISE_NAME_RUSSIAN_TWIST                                     ((FIT_CORE_EXERCISE_NAME)46)
#define FIT_CORE_EXERCISE_NAME_ABDOMINAL_LEG_ROTATIONS                           ((FIT_CORE_EXERCISE_NAME)47) // Deprecated do not use
#define FIT_CORE_EXERCISE_NAME_ARM_AND_LEG_EXTENSION_ON_KNEES                    ((FIT_CORE_EXERCISE_NAME)48)
#define FIT_CORE_EXERCISE_NAME_BICYCLE                                           ((FIT_CORE_EXERCISE_NAME)49)
#define FIT_CORE_EXERCISE_NAME_BICEP_CURL_WITH_LEG_EXTENSION                     ((FIT_CORE_EXERCISE_NAME)50)
#define FIT_CORE_EXERCISE_NAME_CAT_COW                                           ((FIT_CORE_EXERCISE_NAME)51)
#define FIT_CORE_EXERCISE_NAME_CORKSCREW                                         ((FIT_CORE_EXERCISE_NAME)52)
#define FIT_CORE_EXERCISE_NAME_CRISS_CROSS                                       ((FIT_CORE_EXERCISE_NAME)53)
#define FIT_CORE_EXERCISE_NAME_CRISS_CROSS_WITH_BALL                             ((FIT_CORE_EXERCISE_NAME)54) // Deprecated do not use
#define FIT_CORE_EXERCISE_NAME_DOUBLE_LEG_STRETCH                                ((FIT_CORE_EXERCISE_NAME)55)
#define FIT_CORE_EXERCISE_NAME_KNEE_FOLDS                                        ((FIT_CORE_EXERCISE_NAME)56)
#define FIT_CORE_EXERCISE_NAME_LOWER_LIFT                                        ((FIT_CORE_EXERCISE_NAME)57)
#define FIT_CORE_EXERCISE_NAME_NECK_PULL                                         ((FIT_CORE_EXERCISE_NAME)58)
#define FIT_CORE_EXERCISE_NAME_PELVIC_CLOCKS                                     ((FIT_CORE_EXERCISE_NAME)59)
#define FIT_CORE_EXERCISE_NAME_ROLL_OVER                                         ((FIT_CORE_EXERCISE_NAME)60)
#define FIT_CORE_EXERCISE_NAME_ROLL_UP                                           ((FIT_CORE_EXERCISE_NAME)61)
#define FIT_CORE_EXERCISE_NAME_ROLLING                                           ((FIT_CORE_EXERCISE_NAME)62)
#define FIT_CORE_EXERCISE_NAME_ROWING_1                                          ((FIT_CORE_EXERCISE_NAME)63)
#define FIT_CORE_EXERCISE_NAME_ROWING_2                                          ((FIT_CORE_EXERCISE_NAME)64)
#define FIT_CORE_EXERCISE_NAME_SCISSORS                                          ((FIT_CORE_EXERCISE_NAME)65)
#define FIT_CORE_EXERCISE_NAME_SINGLE_LEG_CIRCLES                                ((FIT_CORE_EXERCISE_NAME)66)
#define FIT_CORE_EXERCISE_NAME_SINGLE_LEG_STRETCH                                ((FIT_CORE_EXERCISE_NAME)67)
#define FIT_CORE_EXERCISE_NAME_SNAKE_TWIST_1_AND_2                               ((FIT_CORE_EXERCISE_NAME)68) // Deprecated do not use
#define FIT_CORE_EXERCISE_NAME_SWAN                                              ((FIT_CORE_EXERCISE_NAME)69)
#define FIT_CORE_EXERCISE_NAME_SWIMMING                                          ((FIT_CORE_EXERCISE_NAME)70)
#define FIT_CORE_EXERCISE_NAME_TEASER                                            ((FIT_CORE_EXERCISE_NAME)71)
#define FIT_CORE_EXERCISE_NAME_THE_HUNDRED                                       ((FIT_CORE_EXERCISE_NAME)72)
#define FIT_CORE_EXERCISE_NAME_COUNT                                             73

typedef FIT_UINT16 FIT_CRUNCH_EXERCISE_NAME;
#define FIT_CRUNCH_EXERCISE_NAME_INVALID                                         FIT_UINT16_INVALID
#define FIT_CRUNCH_EXERCISE_NAME_BICYCLE_CRUNCH                                  ((FIT_CRUNCH_EXERCISE_NAME)0)
#define FIT_CRUNCH_EXERCISE_NAME_CABLE_CRUNCH                                    ((FIT_CRUNCH_EXERCISE_NAME)1)
#define FIT_CRUNCH_EXERCISE_NAME_CIRCULAR_ARM_CRUNCH                             ((FIT_CRUNCH_EXERCISE_NAME)2)
#define FIT_CRUNCH_EXERCISE_NAME_CROSSED_ARMS_CRUNCH                             ((FIT_CRUNCH_EXERCISE_NAME)3)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_CROSSED_ARMS_CRUNCH                    ((FIT_CRUNCH_EXERCISE_NAME)4)
#define FIT_CRUNCH_EXERCISE_NAME_CROSS_LEG_REVERSE_CRUNCH                        ((FIT_CRUNCH_EXERCISE_NAME)5)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_CROSS_LEG_REVERSE_CRUNCH               ((FIT_CRUNCH_EXERCISE_NAME)6)
#define FIT_CRUNCH_EXERCISE_NAME_CRUNCH_CHOP                                     ((FIT_CRUNCH_EXERCISE_NAME)7)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_CRUNCH_CHOP                            ((FIT_CRUNCH_EXERCISE_NAME)8)
#define FIT_CRUNCH_EXERCISE_NAME_DOUBLE_CRUNCH                                   ((FIT_CRUNCH_EXERCISE_NAME)9)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_DOUBLE_CRUNCH                          ((FIT_CRUNCH_EXERCISE_NAME)10)
#define FIT_CRUNCH_EXERCISE_NAME_ELBOW_TO_KNEE_CRUNCH                            ((FIT_CRUNCH_EXERCISE_NAME)11)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_ELBOW_TO_KNEE_CRUNCH                   ((FIT_CRUNCH_EXERCISE_NAME)12)
#define FIT_CRUNCH_EXERCISE_NAME_FLUTTER_KICKS                                   ((FIT_CRUNCH_EXERCISE_NAME)13)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_FLUTTER_KICKS                          ((FIT_CRUNCH_EXERCISE_NAME)14)
#define FIT_CRUNCH_EXERCISE_NAME_FOAM_ROLLER_REVERSE_CRUNCH_ON_BENCH             ((FIT_CRUNCH_EXERCISE_NAME)15)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_FOAM_ROLLER_REVERSE_CRUNCH_ON_BENCH    ((FIT_CRUNCH_EXERCISE_NAME)16)
#define FIT_CRUNCH_EXERCISE_NAME_FOAM_ROLLER_REVERSE_CRUNCH_WITH_DUMBBELL        ((FIT_CRUNCH_EXERCISE_NAME)17)
#define FIT_CRUNCH_EXERCISE_NAME_FOAM_ROLLER_REVERSE_CRUNCH_WITH_MEDICINE_BALL   ((FIT_CRUNCH_EXERCISE_NAME)18)
#define FIT_CRUNCH_EXERCISE_NAME_FROG_PRESS                                      ((FIT_CRUNCH_EXERCISE_NAME)19)
#define FIT_CRUNCH_EXERCISE_NAME_HANGING_KNEE_RAISE_OBLIQUE_CRUNCH               ((FIT_CRUNCH_EXERCISE_NAME)20)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_HANGING_KNEE_RAISE_OBLIQUE_CRUNCH      ((FIT_CRUNCH_EXERCISE_NAME)21)
#define FIT_CRUNCH_EXERCISE_NAME_HIP_CROSSOVER                                   ((FIT_CRUNCH_EXERCISE_NAME)22)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_HIP_CROSSOVER                          ((FIT_CRUNCH_EXERCISE_NAME)23)
#define FIT_CRUNCH_EXERCISE_NAME_HOLLOW_ROCK                                     ((FIT_CRUNCH_EXERCISE_NAME)24)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_HOLLOW_ROCK                            ((FIT_CRUNCH_EXERCISE_NAME)25)
#define FIT_CRUNCH_EXERCISE_NAME_INCLINE_REVERSE_CRUNCH                          ((FIT_CRUNCH_EXERCISE_NAME)26)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_INCLINE_REVERSE_CRUNCH                 ((FIT_CRUNCH_EXERCISE_NAME)27)
#define FIT_CRUNCH_EXERCISE_NAME_KNEELING_CABLE_CRUNCH                           ((FIT_CRUNCH_EXERCISE_NAME)28)
#define FIT_CRUNCH_EXERCISE_NAME_KNEELING_CROSS_CRUNCH                           ((FIT_CRUNCH_EXERCISE_NAME)29)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_KNEELING_CROSS_CRUNCH                  ((FIT_CRUNCH_EXERCISE_NAME)30)
#define FIT_CRUNCH_EXERCISE_NAME_KNEELING_OBLIQUE_CABLE_CRUNCH                   ((FIT_CRUNCH_EXERCISE_NAME)31)
#define FIT_CRUNCH_EXERCISE_NAME_KNEES_TO_ELBOW                                  ((FIT_CRUNCH_EXERCISE_NAME)32)
#define FIT_CRUNCH_EXERCISE_NAME_LEG_EXTENSIONS                                  ((FIT_CRUNCH_EXERCISE_NAME)33)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_LEG_EXTENSIONS                         ((FIT_CRUNCH_EXERCISE_NAME)34)
#define FIT_CRUNCH_EXERCISE_NAME_LEG_LEVERS                                      ((FIT_CRUNCH_EXERCISE_NAME)35)
#define FIT_CRUNCH_EXERCISE_NAME_MCGILL_CURL_UP                                  ((FIT_CRUNCH_EXERCISE_NAME)36)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_MCGILL_CURL_UP                         ((FIT_CRUNCH_EXERCISE_NAME)37)
#define FIT_CRUNCH_EXERCISE_NAME_MODIFIED_PILATES_ROLL_UP_WITH_BALL              ((FIT_CRUNCH_EXERCISE_NAME)38)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_MODIFIED_PILATES_ROLL_UP_WITH_BALL     ((FIT_CRUNCH_EXERCISE_NAME)39)
#define FIT_CRUNCH_EXERCISE_NAME_PILATES_CRUNCH                                  ((FIT_CRUNCH_EXERCISE_NAME)40)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_PILATES_CRUNCH                         ((FIT_CRUNCH_EXERCISE_NAME)41)
#define FIT_CRUNCH_EXERCISE_NAME_PILATES_ROLL_UP_WITH_BALL                       ((FIT_CRUNCH_EXERCISE_NAME)42)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_PILATES_ROLL_UP_WITH_BALL              ((FIT_CRUNCH_EXERCISE_NAME)43)
#define FIT_CRUNCH_EXERCISE_NAME_RAISED_LEGS_CRUNCH                              ((FIT_CRUNCH_EXERCISE_NAME)44)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_RAISED_LEGS_CRUNCH                     ((FIT_CRUNCH_EXERCISE_NAME)45)
#define FIT_CRUNCH_EXERCISE_NAME_REVERSE_CRUNCH                                  ((FIT_CRUNCH_EXERCISE_NAME)46)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_REVERSE_CRUNCH                         ((FIT_CRUNCH_EXERCISE_NAME)47)
#define FIT_CRUNCH_EXERCISE_NAME_REVERSE_CRUNCH_ON_A_BENCH                       ((FIT_CRUNCH_EXERCISE_NAME)48)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_REVERSE_CRUNCH_ON_A_BENCH              ((FIT_CRUNCH_EXERCISE_NAME)49)
#define FIT_CRUNCH_EXERCISE_NAME_REVERSE_CURL_AND_LIFT                           ((FIT_CRUNCH_EXERCISE_NAME)50)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_REVERSE_CURL_AND_LIFT                  ((FIT_CRUNCH_EXERCISE_NAME)51)
#define FIT_CRUNCH_EXERCISE_NAME_ROTATIONAL_LIFT                                 ((FIT_CRUNCH_EXERCISE_NAME)52)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_ROTATIONAL_LIFT                        ((FIT_CRUNCH_EXERCISE_NAME)53)
#define FIT_CRUNCH_EXERCISE_NAME_SEATED_ALTERNATING_REVERSE_CRUNCH               ((FIT_CRUNCH_EXERCISE_NAME)54)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SEATED_ALTERNATING_REVERSE_CRUNCH      ((FIT_CRUNCH_EXERCISE_NAME)55)
#define FIT_CRUNCH_EXERCISE_NAME_SEATED_LEG_U                                    ((FIT_CRUNCH_EXERCISE_NAME)56)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SEATED_LEG_U                           ((FIT_CRUNCH_EXERCISE_NAME)57)
#define FIT_CRUNCH_EXERCISE_NAME_SIDE_TO_SIDE_CRUNCH_AND_WEAVE                   ((FIT_CRUNCH_EXERCISE_NAME)58)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SIDE_TO_SIDE_CRUNCH_AND_WEAVE          ((FIT_CRUNCH_EXERCISE_NAME)59)
#define FIT_CRUNCH_EXERCISE_NAME_SINGLE_LEG_REVERSE_CRUNCH                       ((FIT_CRUNCH_EXERCISE_NAME)60)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_REVERSE_CRUNCH              ((FIT_CRUNCH_EXERCISE_NAME)61)
#define FIT_CRUNCH_EXERCISE_NAME_SKATER_CRUNCH_CROSS                             ((FIT_CRUNCH_EXERCISE_NAME)62)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SKATER_CRUNCH_CROSS                    ((FIT_CRUNCH_EXERCISE_NAME)63)
#define FIT_CRUNCH_EXERCISE_NAME_STANDING_CABLE_CRUNCH                           ((FIT_CRUNCH_EXERCISE_NAME)64)
#define FIT_CRUNCH_EXERCISE_NAME_STANDING_SIDE_CRUNCH                            ((FIT_CRUNCH_EXERCISE_NAME)65)
#define FIT_CRUNCH_EXERCISE_NAME_STEP_CLIMB                                      ((FIT_CRUNCH_EXERCISE_NAME)66)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_STEP_CLIMB                             ((FIT_CRUNCH_EXERCISE_NAME)67)
#define FIT_CRUNCH_EXERCISE_NAME_SWISS_BALL_CRUNCH                               ((FIT_CRUNCH_EXERCISE_NAME)68)
#define FIT_CRUNCH_EXERCISE_NAME_SWISS_BALL_REVERSE_CRUNCH                       ((FIT_CRUNCH_EXERCISE_NAME)69)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SWISS_BALL_REVERSE_CRUNCH              ((FIT_CRUNCH_EXERCISE_NAME)70)
#define FIT_CRUNCH_EXERCISE_NAME_SWISS_BALL_RUSSIAN_TWIST                        ((FIT_CRUNCH_EXERCISE_NAME)71)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SWISS_BALL_RUSSIAN_TWIST               ((FIT_CRUNCH_EXERCISE_NAME)72)
#define FIT_CRUNCH_EXERCISE_NAME_SWISS_BALL_SIDE_CRUNCH                          ((FIT_CRUNCH_EXERCISE_NAME)73)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SWISS_BALL_SIDE_CRUNCH                 ((FIT_CRUNCH_EXERCISE_NAME)74)
#define FIT_CRUNCH_EXERCISE_NAME_THORACIC_CRUNCHES_ON_FOAM_ROLLER                ((FIT_CRUNCH_EXERCISE_NAME)75)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_THORACIC_CRUNCHES_ON_FOAM_ROLLER       ((FIT_CRUNCH_EXERCISE_NAME)76)
#define FIT_CRUNCH_EXERCISE_NAME_TRICEPS_CRUNCH                                  ((FIT_CRUNCH_EXERCISE_NAME)77)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_BICYCLE_CRUNCH                         ((FIT_CRUNCH_EXERCISE_NAME)78)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_CRUNCH                                 ((FIT_CRUNCH_EXERCISE_NAME)79)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_SWISS_BALL_CRUNCH                      ((FIT_CRUNCH_EXERCISE_NAME)80)
#define FIT_CRUNCH_EXERCISE_NAME_TOES_TO_BAR                                     ((FIT_CRUNCH_EXERCISE_NAME)81)
#define FIT_CRUNCH_EXERCISE_NAME_WEIGHTED_TOES_TO_BAR                            ((FIT_CRUNCH_EXERCISE_NAME)82)
#define FIT_CRUNCH_EXERCISE_NAME_CRUNCH                                          ((FIT_CRUNCH_EXERCISE_NAME)83)
#define FIT_CRUNCH_EXERCISE_NAME_STRAIGHT_LEG_CRUNCH_WITH_BALL                   ((FIT_CRUNCH_EXERCISE_NAME)84)
#define FIT_CRUNCH_EXERCISE_NAME_COUNT                                           85

typedef FIT_UINT16 FIT_CURL_EXERCISE_NAME;
#define FIT_CURL_EXERCISE_NAME_INVALID                                           FIT_UINT16_INVALID
#define FIT_CURL_EXERCISE_NAME_ALTERNATING_DUMBBELL_BICEPS_CURL                  ((FIT_CURL_EXERCISE_NAME)0)
#define FIT_CURL_EXERCISE_NAME_ALTERNATING_DUMBBELL_BICEPS_CURL_ON_SWISS_BALL    ((FIT_CURL_EXERCISE_NAME)1)
#define FIT_CURL_EXERCISE_NAME_ALTERNATING_INCLINE_DUMBBELL_BICEPS_CURL          ((FIT_CURL_EXERCISE_NAME)2)
#define FIT_CURL_EXERCISE_NAME_BARBELL_BICEPS_CURL                               ((FIT_CURL_EXERCISE_NAME)3)
#define FIT_CURL_EXERCISE_NAME_BARBELL_REVERSE_WRIST_CURL                        ((FIT_CURL_EXERCISE_NAME)4)
#define FIT_CURL_EXERCISE_NAME_BARBELL_WRIST_CURL                                ((FIT_CURL_EXERCISE_NAME)5)
#define FIT_CURL_EXERCISE_NAME_BEHIND_THE_BACK_BARBELL_REVERSE_WRIST_CURL        ((FIT_CURL_EXERCISE_NAME)6)
#define FIT_CURL_EXERCISE_NAME_BEHIND_THE_BACK_ONE_ARM_CABLE_CURL                ((FIT_CURL_EXERCISE_NAME)7)
#define FIT_CURL_EXERCISE_NAME_CABLE_BICEPS_CURL                                 ((FIT_CURL_EXERCISE_NAME)8)
#define FIT_CURL_EXERCISE_NAME_CABLE_HAMMER_CURL                                 ((FIT_CURL_EXERCISE_NAME)9)
#define FIT_CURL_EXERCISE_NAME_CHEATING_BARBELL_BICEPS_CURL                      ((FIT_CURL_EXERCISE_NAME)10)
#define FIT_CURL_EXERCISE_NAME_CLOSE_GRIP_EZ_BAR_BICEPS_CURL                     ((FIT_CURL_EXERCISE_NAME)11)
#define FIT_CURL_EXERCISE_NAME_CROSS_BODY_DUMBBELL_HAMMER_CURL                   ((FIT_CURL_EXERCISE_NAME)12)
#define FIT_CURL_EXERCISE_NAME_DEAD_HANG_BICEPS_CURL                             ((FIT_CURL_EXERCISE_NAME)13)
#define FIT_CURL_EXERCISE_NAME_DECLINE_HAMMER_CURL                               ((FIT_CURL_EXERCISE_NAME)14)
#define FIT_CURL_EXERCISE_NAME_DUMBBELL_BICEPS_CURL_WITH_STATIC_HOLD             ((FIT_CURL_EXERCISE_NAME)15)
#define FIT_CURL_EXERCISE_NAME_DUMBBELL_HAMMER_CURL                              ((FIT_CURL_EXERCISE_NAME)16)
#define FIT_CURL_EXERCISE_NAME_DUMBBELL_REVERSE_WRIST_CURL                       ((FIT_CURL_EXERCISE_NAME)17)
#define FIT_CURL_EXERCISE_NAME_DUMBBELL_WRIST_CURL                               ((FIT_CURL_EXERCISE_NAME)18)
#define FIT_CURL_EXERCISE_NAME_EZ_BAR_PREACHER_CURL                              ((FIT_CURL_EXERCISE_NAME)19)
#define FIT_CURL_EXERCISE_NAME_FORWARD_BEND_BICEPS_CURL                          ((FIT_CURL_EXERCISE_NAME)20)
#define FIT_CURL_EXERCISE_NAME_HAMMER_CURL_TO_PRESS                              ((FIT_CURL_EXERCISE_NAME)21)
#define FIT_CURL_EXERCISE_NAME_INCLINE_DUMBBELL_BICEPS_CURL                      ((FIT_CURL_EXERCISE_NAME)22)
#define FIT_CURL_EXERCISE_NAME_INCLINE_OFFSET_THUMB_DUMBBELL_CURL                ((FIT_CURL_EXERCISE_NAME)23)
#define FIT_CURL_EXERCISE_NAME_KETTLEBELL_BICEPS_CURL                            ((FIT_CURL_EXERCISE_NAME)24)
#define FIT_CURL_EXERCISE_NAME_LYING_CONCENTRATION_CABLE_CURL                    ((FIT_CURL_EXERCISE_NAME)25)
#define FIT_CURL_EXERCISE_NAME_ONE_ARM_PREACHER_CURL                             ((FIT_CURL_EXERCISE_NAME)26)
#define FIT_CURL_EXERCISE_NAME_PLATE_PINCH_CURL                                  ((FIT_CURL_EXERCISE_NAME)27)
#define FIT_CURL_EXERCISE_NAME_PREACHER_CURL_WITH_CABLE                          ((FIT_CURL_EXERCISE_NAME)28)
#define FIT_CURL_EXERCISE_NAME_REVERSE_EZ_BAR_CURL                               ((FIT_CURL_EXERCISE_NAME)29)
#define FIT_CURL_EXERCISE_NAME_REVERSE_GRIP_WRIST_CURL                           ((FIT_CURL_EXERCISE_NAME)30)
#define FIT_CURL_EXERCISE_NAME_REVERSE_GRIP_BARBELL_BICEPS_CURL                  ((FIT_CURL_EXERCISE_NAME)31)
#define FIT_CURL_EXERCISE_NAME_SEATED_ALTERNATING_DUMBBELL_BICEPS_CURL           ((FIT_CURL_EXERCISE_NAME)32)
#define FIT_CURL_EXERCISE_NAME_SEATED_DUMBBELL_BICEPS_CURL                       ((FIT_CURL_EXERCISE_NAME)33)
#define FIT_CURL_EXERCISE_NAME_SEATED_REVERSE_DUMBBELL_CURL                      ((FIT_CURL_EXERCISE_NAME)34)
#define FIT_CURL_EXERCISE_NAME_SPLIT_STANCE_OFFSET_PINKY_DUMBBELL_CURL           ((FIT_CURL_EXERCISE_NAME)35)
#define FIT_CURL_EXERCISE_NAME_STANDING_ALTERNATING_DUMBBELL_CURLS               ((FIT_CURL_EXERCISE_NAME)36)
#define FIT_CURL_EXERCISE_NAME_STANDING_DUMBBELL_BICEPS_CURL                     ((FIT_CURL_EXERCISE_NAME)37)
#define FIT_CURL_EXERCISE_NAME_STANDING_EZ_BAR_BICEPS_CURL                       ((FIT_CURL_EXERCISE_NAME)38)
#define FIT_CURL_EXERCISE_NAME_STATIC_CURL                                       ((FIT_CURL_EXERCISE_NAME)39)
#define FIT_CURL_EXERCISE_NAME_SWISS_BALL_DUMBBELL_OVERHEAD_TRICEPS_EXTENSION    ((FIT_CURL_EXERCISE_NAME)40)
#define FIT_CURL_EXERCISE_NAME_SWISS_BALL_EZ_BAR_PREACHER_CURL                   ((FIT_CURL_EXERCISE_NAME)41)
#define FIT_CURL_EXERCISE_NAME_TWISTING_STANDING_DUMBBELL_BICEPS_CURL            ((FIT_CURL_EXERCISE_NAME)42)
#define FIT_CURL_EXERCISE_NAME_WIDE_GRIP_EZ_BAR_BICEPS_CURL                      ((FIT_CURL_EXERCISE_NAME)43)
#define FIT_CURL_EXERCISE_NAME_COUNT                                             44

typedef FIT_UINT16 FIT_DEADLIFT_EXERCISE_NAME;
#define FIT_DEADLIFT_EXERCISE_NAME_INVALID                                       FIT_UINT16_INVALID
#define FIT_DEADLIFT_EXERCISE_NAME_BARBELL_DEADLIFT                              ((FIT_DEADLIFT_EXERCISE_NAME)0)
#define FIT_DEADLIFT_EXERCISE_NAME_BARBELL_STRAIGHT_LEG_DEADLIFT                 ((FIT_DEADLIFT_EXERCISE_NAME)1)
#define FIT_DEADLIFT_EXERCISE_NAME_DUMBBELL_DEADLIFT                             ((FIT_DEADLIFT_EXERCISE_NAME)2)
#define FIT_DEADLIFT_EXERCISE_NAME_DUMBBELL_SINGLE_LEG_DEADLIFT_TO_ROW           ((FIT_DEADLIFT_EXERCISE_NAME)3)
#define FIT_DEADLIFT_EXERCISE_NAME_DUMBBELL_STRAIGHT_LEG_DEADLIFT                ((FIT_DEADLIFT_EXERCISE_NAME)4)
#define FIT_DEADLIFT_EXERCISE_NAME_KETTLEBELL_FLOOR_TO_SHELF                     ((FIT_DEADLIFT_EXERCISE_NAME)5)
#define FIT_DEADLIFT_EXERCISE_NAME_ONE_ARM_ONE_LEG_DEADLIFT                      ((FIT_DEADLIFT_EXERCISE_NAME)6)
#define FIT_DEADLIFT_EXERCISE_NAME_RACK_PULL                                     ((FIT_DEADLIFT_EXERCISE_NAME)7)
#define FIT_DEADLIFT_EXERCISE_NAME_ROTATIONAL_DUMBBELL_STRAIGHT_LEG_DEADLIFT     ((FIT_DEADLIFT_EXERCISE_NAME)8)
#define FIT_DEADLIFT_EXERCISE_NAME_SINGLE_ARM_DEADLIFT                           ((FIT_DEADLIFT_EXERCISE_NAME)9)
#define FIT_DEADLIFT_EXERCISE_NAME_SINGLE_LEG_BARBELL_DEADLIFT                   ((FIT_DEADLIFT_EXERCISE_NAME)10)
#define FIT_DEADLIFT_EXERCISE_NAME_SINGLE_LEG_BARBELL_STRAIGHT_LEG_DEADLIFT      ((FIT_DEADLIFT_EXERCISE_NAME)11)
#define FIT_DEADLIFT_EXERCISE_NAME_SINGLE_LEG_DEADLIFT_WITH_BARBELL              ((FIT_DEADLIFT_EXERCISE_NAME)12)
#define FIT_DEADLIFT_EXERCISE_NAME_SINGLE_LEG_RDL_CIRCUIT                        ((FIT_DEADLIFT_EXERCISE_NAME)13)
#define FIT_DEADLIFT_EXERCISE_NAME_SINGLE_LEG_ROMANIAN_DEADLIFT_WITH_DUMBBELL    ((FIT_DEADLIFT_EXERCISE_NAME)14)
#define FIT_DEADLIFT_EXERCISE_NAME_SUMO_DEADLIFT                                 ((FIT_DEADLIFT_EXERCISE_NAME)15)
#define FIT_DEADLIFT_EXERCISE_NAME_SUMO_DEADLIFT_HIGH_PULL                       ((FIT_DEADLIFT_EXERCISE_NAME)16)
#define FIT_DEADLIFT_EXERCISE_NAME_TRAP_BAR_DEADLIFT                             ((FIT_DEADLIFT_EXERCISE_NAME)17)
#define FIT_DEADLIFT_EXERCISE_NAME_WIDE_GRIP_BARBELL_DEADLIFT                    ((FIT_DEADLIFT_EXERCISE_NAME)18)
#define FIT_DEADLIFT_EXERCISE_NAME_COUNT                                         19

typedef FIT_UINT16 FIT_FLYE_EXERCISE_NAME;
#define FIT_FLYE_EXERCISE_NAME_INVALID                                           FIT_UINT16_INVALID
#define FIT_FLYE_EXERCISE_NAME_CABLE_CROSSOVER                                   ((FIT_FLYE_EXERCISE_NAME)0)
#define FIT_FLYE_EXERCISE_NAME_DECLINE_DUMBBELL_FLYE                             ((FIT_FLYE_EXERCISE_NAME)1)
#define FIT_FLYE_EXERCISE_NAME_DUMBBELL_FLYE                                     ((FIT_FLYE_EXERCISE_NAME)2)
#define FIT_FLYE_EXERCISE_NAME_INCLINE_DUMBBELL_FLYE                             ((FIT_FLYE_EXERCISE_NAME)3)
#define FIT_FLYE_EXERCISE_NAME_KETTLEBELL_FLYE                                   ((FIT_FLYE_EXERCISE_NAME)4)
#define FIT_FLYE_EXERCISE_NAME_KNEELING_REAR_FLYE                                ((FIT_FLYE_EXERCISE_NAME)5)
#define FIT_FLYE_EXERCISE_NAME_SINGLE_ARM_STANDING_CABLE_REVERSE_FLYE            ((FIT_FLYE_EXERCISE_NAME)6)
#define FIT_FLYE_EXERCISE_NAME_SWISS_BALL_DUMBBELL_FLYE                          ((FIT_FLYE_EXERCISE_NAME)7)
#define FIT_FLYE_EXERCISE_NAME_ARM_ROTATIONS                                     ((FIT_FLYE_EXERCISE_NAME)8)
#define FIT_FLYE_EXERCISE_NAME_HUG_A_TREE                                        ((FIT_FLYE_EXERCISE_NAME)9)
#define FIT_FLYE_EXERCISE_NAME_COUNT                                             10

typedef FIT_UINT16 FIT_HIP_RAISE_EXERCISE_NAME;
#define FIT_HIP_RAISE_EXERCISE_NAME_INVALID                                      FIT_UINT16_INVALID
#define FIT_HIP_RAISE_EXERCISE_NAME_BARBELL_HIP_THRUST_ON_FLOOR                  ((FIT_HIP_RAISE_EXERCISE_NAME)0)
#define FIT_HIP_RAISE_EXERCISE_NAME_BARBELL_HIP_THRUST_WITH_BENCH                ((FIT_HIP_RAISE_EXERCISE_NAME)1)
#define FIT_HIP_RAISE_EXERCISE_NAME_BENT_KNEE_SWISS_BALL_REVERSE_HIP_RAISE       ((FIT_HIP_RAISE_EXERCISE_NAME)2)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_BENT_KNEE_SWISS_BALL_REVERSE_HIP_RAISE ((FIT_HIP_RAISE_EXERCISE_NAME)3)
#define FIT_HIP_RAISE_EXERCISE_NAME_BRIDGE_WITH_LEG_EXTENSION                    ((FIT_HIP_RAISE_EXERCISE_NAME)4)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_BRIDGE_WITH_LEG_EXTENSION           ((FIT_HIP_RAISE_EXERCISE_NAME)5)
#define FIT_HIP_RAISE_EXERCISE_NAME_CLAM_BRIDGE                                  ((FIT_HIP_RAISE_EXERCISE_NAME)6)
#define FIT_HIP_RAISE_EXERCISE_NAME_FRONT_KICK_TABLETOP                          ((FIT_HIP_RAISE_EXERCISE_NAME)7)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_FRONT_KICK_TABLETOP                 ((FIT_HIP_RAISE_EXERCISE_NAME)8)
#define FIT_HIP_RAISE_EXERCISE_NAME_HIP_EXTENSION_AND_CROSS                      ((FIT_HIP_RAISE_EXERCISE_NAME)9)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_HIP_EXTENSION_AND_CROSS             ((FIT_HIP_RAISE_EXERCISE_NAME)10)
#define FIT_HIP_RAISE_EXERCISE_NAME_HIP_RAISE                                    ((FIT_HIP_RAISE_EXERCISE_NAME)11)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_HIP_RAISE                           ((FIT_HIP_RAISE_EXERCISE_NAME)12)
#define FIT_HIP_RAISE_EXERCISE_NAME_HIP_RAISE_WITH_FEET_ON_SWISS_BALL            ((FIT_HIP_RAISE_EXERCISE_NAME)13)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_HIP_RAISE_WITH_FEET_ON_SWISS_BALL   ((FIT_HIP_RAISE_EXERCISE_NAME)14)
#define FIT_HIP_RAISE_EXERCISE_NAME_HIP_RAISE_WITH_HEAD_ON_BOSU_BALL             ((FIT_HIP_RAISE_EXERCISE_NAME)15)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_HIP_RAISE_WITH_HEAD_ON_BOSU_BALL    ((FIT_HIP_RAISE_EXERCISE_NAME)16)
#define FIT_HIP_RAISE_EXERCISE_NAME_HIP_RAISE_WITH_HEAD_ON_SWISS_BALL            ((FIT_HIP_RAISE_EXERCISE_NAME)17)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_HIP_RAISE_WITH_HEAD_ON_SWISS_BALL   ((FIT_HIP_RAISE_EXERCISE_NAME)18)
#define FIT_HIP_RAISE_EXERCISE_NAME_HIP_RAISE_WITH_KNEE_SQUEEZE                  ((FIT_HIP_RAISE_EXERCISE_NAME)19)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_HIP_RAISE_WITH_KNEE_SQUEEZE         ((FIT_HIP_RAISE_EXERCISE_NAME)20)
#define FIT_HIP_RAISE_EXERCISE_NAME_INCLINE_REAR_LEG_EXTENSION                   ((FIT_HIP_RAISE_EXERCISE_NAME)21)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_INCLINE_REAR_LEG_EXTENSION          ((FIT_HIP_RAISE_EXERCISE_NAME)22)
#define FIT_HIP_RAISE_EXERCISE_NAME_KETTLEBELL_SWING                             ((FIT_HIP_RAISE_EXERCISE_NAME)23)
#define FIT_HIP_RAISE_EXERCISE_NAME_MARCHING_HIP_RAISE                           ((FIT_HIP_RAISE_EXERCISE_NAME)24)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_MARCHING_HIP_RAISE                  ((FIT_HIP_RAISE_EXERCISE_NAME)25)
#define FIT_HIP_RAISE_EXERCISE_NAME_MARCHING_HIP_RAISE_WITH_FEET_ON_A_SWISS_BALL ((FIT_HIP_RAISE_EXERCISE_NAME)26)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_MARCHING_HIP_RAISE_WITH_FEET_ON_A_SWISS_BALL ((FIT_HIP_RAISE_EXERCISE_NAME)27)
#define FIT_HIP_RAISE_EXERCISE_NAME_REVERSE_HIP_RAISE                            ((FIT_HIP_RAISE_EXERCISE_NAME)28)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_REVERSE_HIP_RAISE                   ((FIT_HIP_RAISE_EXERCISE_NAME)29)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE                         ((FIT_HIP_RAISE_EXERCISE_NAME)30)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_HIP_RAISE                ((FIT_HIP_RAISE_EXERCISE_NAME)31)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_BENCH      ((FIT_HIP_RAISE_EXERCISE_NAME)32)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_BENCH ((FIT_HIP_RAISE_EXERCISE_NAME)33)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_BOSU_BALL  ((FIT_HIP_RAISE_EXERCISE_NAME)34)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_BOSU_BALL ((FIT_HIP_RAISE_EXERCISE_NAME)35)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_FOAM_ROLLER ((FIT_HIP_RAISE_EXERCISE_NAME)36)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_FOAM_ROLLER ((FIT_HIP_RAISE_EXERCISE_NAME)37)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_MEDICINE_BALL ((FIT_HIP_RAISE_EXERCISE_NAME)38)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_HIP_RAISE_WITH_FOOT_ON_MEDICINE_BALL ((FIT_HIP_RAISE_EXERCISE_NAME)39)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_HIP_RAISE_WITH_HEAD_ON_BOSU_BALL  ((FIT_HIP_RAISE_EXERCISE_NAME)40)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_HIP_RAISE_WITH_HEAD_ON_BOSU_BALL ((FIT_HIP_RAISE_EXERCISE_NAME)41)
#define FIT_HIP_RAISE_EXERCISE_NAME_WEIGHTED_CLAM_BRIDGE                         ((FIT_HIP_RAISE_EXERCISE_NAME)42)
#define FIT_HIP_RAISE_EXERCISE_NAME_SINGLE_LEG_SWISS_BALL_HIP_RAISE_AND_LEG_CURL ((FIT_HIP_RAISE_EXERCISE_NAME)43)
#define FIT_HIP_RAISE_EXERCISE_NAME_CLAMS                                        ((FIT_HIP_RAISE_EXERCISE_NAME)44)
#define FIT_HIP_RAISE_EXERCISE_NAME_INNER_THIGH_CIRCLES                          ((FIT_HIP_RAISE_EXERCISE_NAME)45) // Deprecated do not use
#define FIT_HIP_RAISE_EXERCISE_NAME_INNER_THIGH_SIDE_LIFT                        ((FIT_HIP_RAISE_EXERCISE_NAME)46) // Deprecated do not use
#define FIT_HIP_RAISE_EXERCISE_NAME_LEG_CIRCLES                                  ((FIT_HIP_RAISE_EXERCISE_NAME)47)
#define FIT_HIP_RAISE_EXERCISE_NAME_LEG_LIFT                                     ((FIT_HIP_RAISE_EXERCISE_NAME)48)
#define FIT_HIP_RAISE_EXERCISE_NAME_LEG_LIFT_IN_EXTERNAL_ROTATION                ((FIT_HIP_RAISE_EXERCISE_NAME)49)
#define FIT_HIP_RAISE_EXERCISE_NAME_COUNT                                        50

typedef FIT_UINT16 FIT_HIP_STABILITY_EXERCISE_NAME;
#define FIT_HIP_STABILITY_EXERCISE_NAME_INVALID                                  FIT_UINT16_INVALID
#define FIT_HIP_STABILITY_EXERCISE_NAME_BAND_SIDE_LYING_LEG_RAISE                ((FIT_HIP_STABILITY_EXERCISE_NAME)0)
#define FIT_HIP_STABILITY_EXERCISE_NAME_DEAD_BUG                                 ((FIT_HIP_STABILITY_EXERCISE_NAME)1)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_DEAD_BUG                        ((FIT_HIP_STABILITY_EXERCISE_NAME)2)
#define FIT_HIP_STABILITY_EXERCISE_NAME_EXTERNAL_HIP_RAISE                       ((FIT_HIP_STABILITY_EXERCISE_NAME)3)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_EXTERNAL_HIP_RAISE              ((FIT_HIP_STABILITY_EXERCISE_NAME)4)
#define FIT_HIP_STABILITY_EXERCISE_NAME_FIRE_HYDRANT_KICKS                       ((FIT_HIP_STABILITY_EXERCISE_NAME)5)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_FIRE_HYDRANT_KICKS              ((FIT_HIP_STABILITY_EXERCISE_NAME)6)
#define FIT_HIP_STABILITY_EXERCISE_NAME_HIP_CIRCLES                              ((FIT_HIP_STABILITY_EXERCISE_NAME)7)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_HIP_CIRCLES                     ((FIT_HIP_STABILITY_EXERCISE_NAME)8)
#define FIT_HIP_STABILITY_EXERCISE_NAME_INNER_THIGH_LIFT                         ((FIT_HIP_STABILITY_EXERCISE_NAME)9)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_INNER_THIGH_LIFT                ((FIT_HIP_STABILITY_EXERCISE_NAME)10)
#define FIT_HIP_STABILITY_EXERCISE_NAME_LATERAL_WALKS_WITH_BAND_AT_ANKLES        ((FIT_HIP_STABILITY_EXERCISE_NAME)11)
#define FIT_HIP_STABILITY_EXERCISE_NAME_PRETZEL_SIDE_KICK                        ((FIT_HIP_STABILITY_EXERCISE_NAME)12)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_PRETZEL_SIDE_KICK               ((FIT_HIP_STABILITY_EXERCISE_NAME)13)
#define FIT_HIP_STABILITY_EXERCISE_NAME_PRONE_HIP_INTERNAL_ROTATION              ((FIT_HIP_STABILITY_EXERCISE_NAME)14)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_PRONE_HIP_INTERNAL_ROTATION     ((FIT_HIP_STABILITY_EXERCISE_NAME)15)
#define FIT_HIP_STABILITY_EXERCISE_NAME_QUADRUPED                                ((FIT_HIP_STABILITY_EXERCISE_NAME)16)
#define FIT_HIP_STABILITY_EXERCISE_NAME_QUADRUPED_HIP_EXTENSION                  ((FIT_HIP_STABILITY_EXERCISE_NAME)17)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_QUADRUPED_HIP_EXTENSION         ((FIT_HIP_STABILITY_EXERCISE_NAME)18)
#define FIT_HIP_STABILITY_EXERCISE_NAME_QUADRUPED_WITH_LEG_LIFT                  ((FIT_HIP_STABILITY_EXERCISE_NAME)19)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_QUADRUPED_WITH_LEG_LIFT         ((FIT_HIP_STABILITY_EXERCISE_NAME)20)
#define FIT_HIP_STABILITY_EXERCISE_NAME_SIDE_LYING_LEG_RAISE                     ((FIT_HIP_STABILITY_EXERCISE_NAME)21)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_SIDE_LYING_LEG_RAISE            ((FIT_HIP_STABILITY_EXERCISE_NAME)22)
#define FIT_HIP_STABILITY_EXERCISE_NAME_SLIDING_HIP_ADDUCTION                    ((FIT_HIP_STABILITY_EXERCISE_NAME)23)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_SLIDING_HIP_ADDUCTION           ((FIT_HIP_STABILITY_EXERCISE_NAME)24)
#define FIT_HIP_STABILITY_EXERCISE_NAME_STANDING_ADDUCTION                       ((FIT_HIP_STABILITY_EXERCISE_NAME)25)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_STANDING_ADDUCTION              ((FIT_HIP_STABILITY_EXERCISE_NAME)26)
#define FIT_HIP_STABILITY_EXERCISE_NAME_STANDING_CABLE_HIP_ABDUCTION             ((FIT_HIP_STABILITY_EXERCISE_NAME)27)
#define FIT_HIP_STABILITY_EXERCISE_NAME_STANDING_HIP_ABDUCTION                   ((FIT_HIP_STABILITY_EXERCISE_NAME)28)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_STANDING_HIP_ABDUCTION          ((FIT_HIP_STABILITY_EXERCISE_NAME)29)
#define FIT_HIP_STABILITY_EXERCISE_NAME_STANDING_REAR_LEG_RAISE                  ((FIT_HIP_STABILITY_EXERCISE_NAME)30)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_STANDING_REAR_LEG_RAISE         ((FIT_HIP_STABILITY_EXERCISE_NAME)31)
#define FIT_HIP_STABILITY_EXERCISE_NAME_SUPINE_HIP_INTERNAL_ROTATION             ((FIT_HIP_STABILITY_EXERCISE_NAME)32)
#define FIT_HIP_STABILITY_EXERCISE_NAME_WEIGHTED_SUPINE_HIP_INTERNAL_ROTATION    ((FIT_HIP_STABILITY_EXERCISE_NAME)33)
#define FIT_HIP_STABILITY_EXERCISE_NAME_COUNT                                    34

typedef FIT_UINT16 FIT_HIP_SWING_EXERCISE_NAME;
#define FIT_HIP_SWING_EXERCISE_NAME_INVALID                                      FIT_UINT16_INVALID
#define FIT_HIP_SWING_EXERCISE_NAME_SINGLE_ARM_KETTLEBELL_SWING                  ((FIT_HIP_SWING_EXERCISE_NAME)0)
#define FIT_HIP_SWING_EXERCISE_NAME_SINGLE_ARM_DUMBBELL_SWING                    ((FIT_HIP_SWING_EXERCISE_NAME)1)
#define FIT_HIP_SWING_EXERCISE_NAME_STEP_OUT_SWING                               ((FIT_HIP_SWING_EXERCISE_NAME)2)
#define FIT_HIP_SWING_EXERCISE_NAME_COUNT                                        3

typedef FIT_UINT16 FIT_HYPEREXTENSION_EXERCISE_NAME;
#define FIT_HYPEREXTENSION_EXERCISE_NAME_INVALID                                 FIT_UINT16_INVALID
#define FIT_HYPEREXTENSION_EXERCISE_NAME_BACK_EXTENSION_WITH_OPPOSITE_ARM_AND_LEG_REACH ((FIT_HYPEREXTENSION_EXERCISE_NAME)0)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_BACK_EXTENSION_WITH_OPPOSITE_ARM_AND_LEG_REACH ((FIT_HYPEREXTENSION_EXERCISE_NAME)1)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_BASE_ROTATIONS                          ((FIT_HYPEREXTENSION_EXERCISE_NAME)2)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_BASE_ROTATIONS                 ((FIT_HYPEREXTENSION_EXERCISE_NAME)3)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_BENT_KNEE_REVERSE_HYPEREXTENSION        ((FIT_HYPEREXTENSION_EXERCISE_NAME)4)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_BENT_KNEE_REVERSE_HYPEREXTENSION ((FIT_HYPEREXTENSION_EXERCISE_NAME)5)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_HOLLOW_HOLD_AND_ROLL                    ((FIT_HYPEREXTENSION_EXERCISE_NAME)6)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_HOLLOW_HOLD_AND_ROLL           ((FIT_HYPEREXTENSION_EXERCISE_NAME)7)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_KICKS                                   ((FIT_HYPEREXTENSION_EXERCISE_NAME)8)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_KICKS                          ((FIT_HYPEREXTENSION_EXERCISE_NAME)9)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_KNEE_RAISES                             ((FIT_HYPEREXTENSION_EXERCISE_NAME)10)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_KNEE_RAISES                    ((FIT_HYPEREXTENSION_EXERCISE_NAME)11)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_KNEELING_SUPERMAN                       ((FIT_HYPEREXTENSION_EXERCISE_NAME)12)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_KNEELING_SUPERMAN              ((FIT_HYPEREXTENSION_EXERCISE_NAME)13)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_LAT_PULL_DOWN_WITH_ROW                  ((FIT_HYPEREXTENSION_EXERCISE_NAME)14)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_MEDICINE_BALL_DEADLIFT_TO_REACH         ((FIT_HYPEREXTENSION_EXERCISE_NAME)15)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_ONE_ARM_ONE_LEG_ROW                     ((FIT_HYPEREXTENSION_EXERCISE_NAME)16)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_ONE_ARM_ROW_WITH_BAND                   ((FIT_HYPEREXTENSION_EXERCISE_NAME)17)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_OVERHEAD_LUNGE_WITH_MEDICINE_BALL       ((FIT_HYPEREXTENSION_EXERCISE_NAME)18)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_PLANK_KNEE_TUCKS                        ((FIT_HYPEREXTENSION_EXERCISE_NAME)19)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_PLANK_KNEE_TUCKS               ((FIT_HYPEREXTENSION_EXERCISE_NAME)20)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SIDE_STEP                               ((FIT_HYPEREXTENSION_EXERCISE_NAME)21)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SIDE_STEP                      ((FIT_HYPEREXTENSION_EXERCISE_NAME)22)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SINGLE_LEG_BACK_EXTENSION               ((FIT_HYPEREXTENSION_EXERCISE_NAME)23)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_BACK_EXTENSION      ((FIT_HYPEREXTENSION_EXERCISE_NAME)24)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SPINE_EXTENSION                         ((FIT_HYPEREXTENSION_EXERCISE_NAME)25)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SPINE_EXTENSION                ((FIT_HYPEREXTENSION_EXERCISE_NAME)26)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_STATIC_BACK_EXTENSION                   ((FIT_HYPEREXTENSION_EXERCISE_NAME)27)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_STATIC_BACK_EXTENSION          ((FIT_HYPEREXTENSION_EXERCISE_NAME)28)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SUPERMAN_FROM_FLOOR                     ((FIT_HYPEREXTENSION_EXERCISE_NAME)29)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SUPERMAN_FROM_FLOOR            ((FIT_HYPEREXTENSION_EXERCISE_NAME)30)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SWISS_BALL_BACK_EXTENSION               ((FIT_HYPEREXTENSION_EXERCISE_NAME)31)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SWISS_BALL_BACK_EXTENSION      ((FIT_HYPEREXTENSION_EXERCISE_NAME)32)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SWISS_BALL_HYPEREXTENSION               ((FIT_HYPEREXTENSION_EXERCISE_NAME)33)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SWISS_BALL_HYPEREXTENSION      ((FIT_HYPEREXTENSION_EXERCISE_NAME)34)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SWISS_BALL_OPPOSITE_ARM_AND_LEG_LIFT    ((FIT_HYPEREXTENSION_EXERCISE_NAME)35)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_WEIGHTED_SWISS_BALL_OPPOSITE_ARM_AND_LEG_LIFT ((FIT_HYPEREXTENSION_EXERCISE_NAME)36)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SUPERMAN_ON_SWISS_BALL                  ((FIT_HYPEREXTENSION_EXERCISE_NAME)37)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_COBRA                                   ((FIT_HYPEREXTENSION_EXERCISE_NAME)38)
#define FIT_HYPEREXTENSION_EXERCISE_NAME_SUPINE_FLOOR_BARRE                      ((FIT_HYPEREXTENSION_EXERCISE_NAME)39) // Deprecated do not use
#define FIT_HYPEREXTENSION_EXERCISE_NAME_COUNT                                   40

typedef FIT_UINT16 FIT_LATERAL_RAISE_EXERCISE_NAME;
#define FIT_LATERAL_RAISE_EXERCISE_NAME_INVALID                                  FIT_UINT16_INVALID
#define FIT_LATERAL_RAISE_EXERCISE_NAME_45_DEGREE_CABLE_EXTERNAL_ROTATION        ((FIT_LATERAL_RAISE_EXERCISE_NAME)0)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_ALTERNATING_LATERAL_RAISE_WITH_STATIC_HOLD ((FIT_LATERAL_RAISE_EXERCISE_NAME)1)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_BAR_MUSCLE_UP                            ((FIT_LATERAL_RAISE_EXERCISE_NAME)2)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_BENT_OVER_LATERAL_RAISE                  ((FIT_LATERAL_RAISE_EXERCISE_NAME)3)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_CABLE_DIAGONAL_RAISE                     ((FIT_LATERAL_RAISE_EXERCISE_NAME)4)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_CABLE_FRONT_RAISE                        ((FIT_LATERAL_RAISE_EXERCISE_NAME)5)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_CALORIE_ROW                              ((FIT_LATERAL_RAISE_EXERCISE_NAME)6)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_COMBO_SHOULDER_RAISE                     ((FIT_LATERAL_RAISE_EXERCISE_NAME)7)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_DUMBBELL_DIAGONAL_RAISE                  ((FIT_LATERAL_RAISE_EXERCISE_NAME)8)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_DUMBBELL_V_RAISE                         ((FIT_LATERAL_RAISE_EXERCISE_NAME)9)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_FRONT_RAISE                              ((FIT_LATERAL_RAISE_EXERCISE_NAME)10)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_LEANING_DUMBBELL_LATERAL_RAISE           ((FIT_LATERAL_RAISE_EXERCISE_NAME)11)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_LYING_DUMBBELL_RAISE                     ((FIT_LATERAL_RAISE_EXERCISE_NAME)12)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_MUSCLE_UP                                ((FIT_LATERAL_RAISE_EXERCISE_NAME)13)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_ONE_ARM_CABLE_LATERAL_RAISE              ((FIT_LATERAL_RAISE_EXERCISE_NAME)14)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_OVERHAND_GRIP_REAR_LATERAL_RAISE         ((FIT_LATERAL_RAISE_EXERCISE_NAME)15)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_PLATE_RAISES                             ((FIT_LATERAL_RAISE_EXERCISE_NAME)16)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_RING_DIP                                 ((FIT_LATERAL_RAISE_EXERCISE_NAME)17)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_WEIGHTED_RING_DIP                        ((FIT_LATERAL_RAISE_EXERCISE_NAME)18)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_RING_MUSCLE_UP                           ((FIT_LATERAL_RAISE_EXERCISE_NAME)19)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_WEIGHTED_RING_MUSCLE_UP                  ((FIT_LATERAL_RAISE_EXERCISE_NAME)20)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_ROPE_CLIMB                               ((FIT_LATERAL_RAISE_EXERCISE_NAME)21)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_WEIGHTED_ROPE_CLIMB                      ((FIT_LATERAL_RAISE_EXERCISE_NAME)22)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_SCAPTION                                 ((FIT_LATERAL_RAISE_EXERCISE_NAME)23)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_SEATED_LATERAL_RAISE                     ((FIT_LATERAL_RAISE_EXERCISE_NAME)24)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_SEATED_REAR_LATERAL_RAISE                ((FIT_LATERAL_RAISE_EXERCISE_NAME)25)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_SIDE_LYING_LATERAL_RAISE                 ((FIT_LATERAL_RAISE_EXERCISE_NAME)26)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_STANDING_LIFT                            ((FIT_LATERAL_RAISE_EXERCISE_NAME)27)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_SUSPENDED_ROW                            ((FIT_LATERAL_RAISE_EXERCISE_NAME)28)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_UNDERHAND_GRIP_REAR_LATERAL_RAISE        ((FIT_LATERAL_RAISE_EXERCISE_NAME)29)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_WALL_SLIDE                               ((FIT_LATERAL_RAISE_EXERCISE_NAME)30)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_WEIGHTED_WALL_SLIDE                      ((FIT_LATERAL_RAISE_EXERCISE_NAME)31)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_ARM_CIRCLES                              ((FIT_LATERAL_RAISE_EXERCISE_NAME)32)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_SHAVING_THE_HEAD                         ((FIT_LATERAL_RAISE_EXERCISE_NAME)33)
#define FIT_LATERAL_RAISE_EXERCISE_NAME_COUNT                                    34

typedef FIT_UINT16 FIT_LEG_CURL_EXERCISE_NAME;
#define FIT_LEG_CURL_EXERCISE_NAME_INVALID                                       FIT_UINT16_INVALID
#define FIT_LEG_CURL_EXERCISE_NAME_LEG_CURL                                      ((FIT_LEG_CURL_EXERCISE_NAME)0)
#define FIT_LEG_CURL_EXERCISE_NAME_WEIGHTED_LEG_CURL                             ((FIT_LEG_CURL_EXERCISE_NAME)1)
#define FIT_LEG_CURL_EXERCISE_NAME_GOOD_MORNING                                  ((FIT_LEG_CURL_EXERCISE_NAME)2)
#define FIT_LEG_CURL_EXERCISE_NAME_SEATED_BARBELL_GOOD_MORNING                   ((FIT_LEG_CURL_EXERCISE_NAME)3)
#define FIT_LEG_CURL_EXERCISE_NAME_SINGLE_LEG_BARBELL_GOOD_MORNING               ((FIT_LEG_CURL_EXERCISE_NAME)4)
#define FIT_LEG_CURL_EXERCISE_NAME_SINGLE_LEG_SLIDING_LEG_CURL                   ((FIT_LEG_CURL_EXERCISE_NAME)5)
#define FIT_LEG_CURL_EXERCISE_NAME_SLIDING_LEG_CURL                              ((FIT_LEG_CURL_EXERCISE_NAME)6)
#define FIT_LEG_CURL_EXERCISE_NAME_SPLIT_BARBELL_GOOD_MORNING                    ((FIT_LEG_CURL_EXERCISE_NAME)7)
#define FIT_LEG_CURL_EXERCISE_NAME_SPLIT_STANCE_EXTENSION                        ((FIT_LEG_CURL_EXERCISE_NAME)8)
#define FIT_LEG_CURL_EXERCISE_NAME_STAGGERED_STANCE_GOOD_MORNING                 ((FIT_LEG_CURL_EXERCISE_NAME)9)
#define FIT_LEG_CURL_EXERCISE_NAME_SWISS_BALL_HIP_RAISE_AND_LEG_CURL             ((FIT_LEG_CURL_EXERCISE_NAME)10)
#define FIT_LEG_CURL_EXERCISE_NAME_ZERCHER_GOOD_MORNING                          ((FIT_LEG_CURL_EXERCISE_NAME)11)
#define FIT_LEG_CURL_EXERCISE_NAME_COUNT                                         12

typedef FIT_UINT16 FIT_LEG_RAISE_EXERCISE_NAME;
#define FIT_LEG_RAISE_EXERCISE_NAME_INVALID                                      FIT_UINT16_INVALID
#define FIT_LEG_RAISE_EXERCISE_NAME_HANGING_KNEE_RAISE                           ((FIT_LEG_RAISE_EXERCISE_NAME)0)
#define FIT_LEG_RAISE_EXERCISE_NAME_HANGING_LEG_RAISE                            ((FIT_LEG_RAISE_EXERCISE_NAME)1)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_HANGING_LEG_RAISE                   ((FIT_LEG_RAISE_EXERCISE_NAME)2)
#define FIT_LEG_RAISE_EXERCISE_NAME_HANGING_SINGLE_LEG_RAISE                     ((FIT_LEG_RAISE_EXERCISE_NAME)3)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_HANGING_SINGLE_LEG_RAISE            ((FIT_LEG_RAISE_EXERCISE_NAME)4)
#define FIT_LEG_RAISE_EXERCISE_NAME_KETTLEBELL_LEG_RAISES                        ((FIT_LEG_RAISE_EXERCISE_NAME)5)
#define FIT_LEG_RAISE_EXERCISE_NAME_LEG_LOWERING_DRILL                           ((FIT_LEG_RAISE_EXERCISE_NAME)6)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_LEG_LOWERING_DRILL                  ((FIT_LEG_RAISE_EXERCISE_NAME)7)
#define FIT_LEG_RAISE_EXERCISE_NAME_LYING_STRAIGHT_LEG_RAISE                     ((FIT_LEG_RAISE_EXERCISE_NAME)8)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_LYING_STRAIGHT_LEG_RAISE            ((FIT_LEG_RAISE_EXERCISE_NAME)9)
#define FIT_LEG_RAISE_EXERCISE_NAME_MEDICINE_BALL_LEG_DROPS                      ((FIT_LEG_RAISE_EXERCISE_NAME)10)
#define FIT_LEG_RAISE_EXERCISE_NAME_QUADRUPED_LEG_RAISE                          ((FIT_LEG_RAISE_EXERCISE_NAME)11)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_QUADRUPED_LEG_RAISE                 ((FIT_LEG_RAISE_EXERCISE_NAME)12)
#define FIT_LEG_RAISE_EXERCISE_NAME_REVERSE_LEG_RAISE                            ((FIT_LEG_RAISE_EXERCISE_NAME)13)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_REVERSE_LEG_RAISE                   ((FIT_LEG_RAISE_EXERCISE_NAME)14)
#define FIT_LEG_RAISE_EXERCISE_NAME_REVERSE_LEG_RAISE_ON_SWISS_BALL              ((FIT_LEG_RAISE_EXERCISE_NAME)15)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_REVERSE_LEG_RAISE_ON_SWISS_BALL     ((FIT_LEG_RAISE_EXERCISE_NAME)16)
#define FIT_LEG_RAISE_EXERCISE_NAME_SINGLE_LEG_LOWERING_DRILL                    ((FIT_LEG_RAISE_EXERCISE_NAME)17)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_LOWERING_DRILL           ((FIT_LEG_RAISE_EXERCISE_NAME)18)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_HANGING_KNEE_RAISE                  ((FIT_LEG_RAISE_EXERCISE_NAME)19)
#define FIT_LEG_RAISE_EXERCISE_NAME_LATERAL_STEPOVER                             ((FIT_LEG_RAISE_EXERCISE_NAME)20)
#define FIT_LEG_RAISE_EXERCISE_NAME_WEIGHTED_LATERAL_STEPOVER                    ((FIT_LEG_RAISE_EXERCISE_NAME)21)
#define FIT_LEG_RAISE_EXERCISE_NAME_COUNT                                        22

typedef FIT_UINT16 FIT_LUNGE_EXERCISE_NAME;
#define FIT_LUNGE_EXERCISE_NAME_INVALID                                          FIT_UINT16_INVALID
#define FIT_LUNGE_EXERCISE_NAME_OVERHEAD_LUNGE                                   ((FIT_LUNGE_EXERCISE_NAME)0)
#define FIT_LUNGE_EXERCISE_NAME_LUNGE_MATRIX                                     ((FIT_LUNGE_EXERCISE_NAME)1)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_LUNGE_MATRIX                            ((FIT_LUNGE_EXERCISE_NAME)2)
#define FIT_LUNGE_EXERCISE_NAME_ALTERNATING_BARBELL_FORWARD_LUNGE                ((FIT_LUNGE_EXERCISE_NAME)3)
#define FIT_LUNGE_EXERCISE_NAME_ALTERNATING_DUMBBELL_LUNGE_WITH_REACH            ((FIT_LUNGE_EXERCISE_NAME)4)
#define FIT_LUNGE_EXERCISE_NAME_BACK_FOOT_ELEVATED_DUMBBELL_SPLIT_SQUAT          ((FIT_LUNGE_EXERCISE_NAME)5)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_BOX_LUNGE                                ((FIT_LUNGE_EXERCISE_NAME)6)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_BULGARIAN_SPLIT_SQUAT                    ((FIT_LUNGE_EXERCISE_NAME)7)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_CROSSOVER_LUNGE                          ((FIT_LUNGE_EXERCISE_NAME)8)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_FRONT_SPLIT_SQUAT                        ((FIT_LUNGE_EXERCISE_NAME)9)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_LUNGE                                    ((FIT_LUNGE_EXERCISE_NAME)10)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_REVERSE_LUNGE                            ((FIT_LUNGE_EXERCISE_NAME)11)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_SIDE_LUNGE                               ((FIT_LUNGE_EXERCISE_NAME)12)
#define FIT_LUNGE_EXERCISE_NAME_BARBELL_SPLIT_SQUAT                              ((FIT_LUNGE_EXERCISE_NAME)13)
#define FIT_LUNGE_EXERCISE_NAME_CORE_CONTROL_REAR_LUNGE                          ((FIT_LUNGE_EXERCISE_NAME)14)
#define FIT_LUNGE_EXERCISE_NAME_DIAGONAL_LUNGE                                   ((FIT_LUNGE_EXERCISE_NAME)15)
#define FIT_LUNGE_EXERCISE_NAME_DROP_LUNGE                                       ((FIT_LUNGE_EXERCISE_NAME)16)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_BOX_LUNGE                               ((FIT_LUNGE_EXERCISE_NAME)17)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_BULGARIAN_SPLIT_SQUAT                   ((FIT_LUNGE_EXERCISE_NAME)18)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_CROSSOVER_LUNGE                         ((FIT_LUNGE_EXERCISE_NAME)19)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_DIAGONAL_LUNGE                          ((FIT_LUNGE_EXERCISE_NAME)20)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_LUNGE                                   ((FIT_LUNGE_EXERCISE_NAME)21)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_LUNGE_AND_ROTATION                      ((FIT_LUNGE_EXERCISE_NAME)22)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_OVERHEAD_BULGARIAN_SPLIT_SQUAT          ((FIT_LUNGE_EXERCISE_NAME)23)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_REVERSE_LUNGE_TO_HIGH_KNEE_AND_PRESS    ((FIT_LUNGE_EXERCISE_NAME)24)
#define FIT_LUNGE_EXERCISE_NAME_DUMBBELL_SIDE_LUNGE                              ((FIT_LUNGE_EXERCISE_NAME)25)
#define FIT_LUNGE_EXERCISE_NAME_ELEVATED_FRONT_FOOT_BARBELL_SPLIT_SQUAT          ((FIT_LUNGE_EXERCISE_NAME)26)
#define FIT_LUNGE_EXERCISE_NAME_FRONT_FOOT_ELEVATED_DUMBBELL_SPLIT_SQUAT         ((FIT_LUNGE_EXERCISE_NAME)27)
#define FIT_LUNGE_EXERCISE_NAME_GUNSLINGER_LUNGE                                 ((FIT_LUNGE_EXERCISE_NAME)28)
#define FIT_LUNGE_EXERCISE_NAME_LAWNMOWER_LUNGE                                  ((FIT_LUNGE_EXERCISE_NAME)29)
#define FIT_LUNGE_EXERCISE_NAME_LOW_LUNGE_WITH_ISOMETRIC_ADDUCTION               ((FIT_LUNGE_EXERCISE_NAME)30)
#define FIT_LUNGE_EXERCISE_NAME_LOW_SIDE_TO_SIDE_LUNGE                           ((FIT_LUNGE_EXERCISE_NAME)31)
#define FIT_LUNGE_EXERCISE_NAME_LUNGE                                            ((FIT_LUNGE_EXERCISE_NAME)32)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_LUNGE                                   ((FIT_LUNGE_EXERCISE_NAME)33)
#define FIT_LUNGE_EXERCISE_NAME_LUNGE_WITH_ARM_REACH                             ((FIT_LUNGE_EXERCISE_NAME)34)
#define FIT_LUNGE_EXERCISE_NAME_LUNGE_WITH_DIAGONAL_REACH                        ((FIT_LUNGE_EXERCISE_NAME)35)
#define FIT_LUNGE_EXERCISE_NAME_LUNGE_WITH_SIDE_BEND                             ((FIT_LUNGE_EXERCISE_NAME)36)
#define FIT_LUNGE_EXERCISE_NAME_OFFSET_DUMBBELL_LUNGE                            ((FIT_LUNGE_EXERCISE_NAME)37)
#define FIT_LUNGE_EXERCISE_NAME_OFFSET_DUMBBELL_REVERSE_LUNGE                    ((FIT_LUNGE_EXERCISE_NAME)38)
#define FIT_LUNGE_EXERCISE_NAME_OVERHEAD_BULGARIAN_SPLIT_SQUAT                   ((FIT_LUNGE_EXERCISE_NAME)39)
#define FIT_LUNGE_EXERCISE_NAME_OVERHEAD_DUMBBELL_REVERSE_LUNGE                  ((FIT_LUNGE_EXERCISE_NAME)40)
#define FIT_LUNGE_EXERCISE_NAME_OVERHEAD_DUMBBELL_SPLIT_SQUAT                    ((FIT_LUNGE_EXERCISE_NAME)41)
#define FIT_LUNGE_EXERCISE_NAME_OVERHEAD_LUNGE_WITH_ROTATION                     ((FIT_LUNGE_EXERCISE_NAME)42)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_BARBELL_BOX_LUNGE                        ((FIT_LUNGE_EXERCISE_NAME)43)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_BOX_LUNGE                                ((FIT_LUNGE_EXERCISE_NAME)44)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_DUMBBELL_BOX_LUNGE                       ((FIT_LUNGE_EXERCISE_NAME)45)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_DUMBBELL_CROSSOVER_LUNGE                 ((FIT_LUNGE_EXERCISE_NAME)46)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_DUMBBELL_DIAGONAL_LUNGE                  ((FIT_LUNGE_EXERCISE_NAME)47)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_LUNGE_WITH_REACH_BACK                    ((FIT_LUNGE_EXERCISE_NAME)48)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_REVERSE_LUNGE_WITH_REACH_BACK           ((FIT_LUNGE_EXERCISE_NAME)49)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_LUNGE_WITH_TWIST_AND_OVERHEAD_REACH      ((FIT_LUNGE_EXERCISE_NAME)50)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_REVERSE_LUNGE_WITH_TWIST_AND_OVERHEAD_REACH ((FIT_LUNGE_EXERCISE_NAME)51)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_SLIDING_BOX_LUNGE                        ((FIT_LUNGE_EXERCISE_NAME)52)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_REVERSE_SLIDING_BOX_LUNGE               ((FIT_LUNGE_EXERCISE_NAME)53)
#define FIT_LUNGE_EXERCISE_NAME_REVERSE_SLIDING_LUNGE                            ((FIT_LUNGE_EXERCISE_NAME)54)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_REVERSE_SLIDING_LUNGE                   ((FIT_LUNGE_EXERCISE_NAME)55)
#define FIT_LUNGE_EXERCISE_NAME_RUNNERS_LUNGE_TO_BALANCE                         ((FIT_LUNGE_EXERCISE_NAME)56)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_RUNNERS_LUNGE_TO_BALANCE                ((FIT_LUNGE_EXERCISE_NAME)57)
#define FIT_LUNGE_EXERCISE_NAME_SHIFTING_SIDE_LUNGE                              ((FIT_LUNGE_EXERCISE_NAME)58)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_AND_CROSSOVER_LUNGE                         ((FIT_LUNGE_EXERCISE_NAME)59)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SIDE_AND_CROSSOVER_LUNGE                ((FIT_LUNGE_EXERCISE_NAME)60)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_LUNGE                                       ((FIT_LUNGE_EXERCISE_NAME)61)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SIDE_LUNGE                              ((FIT_LUNGE_EXERCISE_NAME)62)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_LUNGE_AND_PRESS                             ((FIT_LUNGE_EXERCISE_NAME)63)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_LUNGE_JUMP_OFF                              ((FIT_LUNGE_EXERCISE_NAME)64)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_LUNGE_SWEEP                                 ((FIT_LUNGE_EXERCISE_NAME)65)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SIDE_LUNGE_SWEEP                        ((FIT_LUNGE_EXERCISE_NAME)66)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_LUNGE_TO_CROSSOVER_TAP                      ((FIT_LUNGE_EXERCISE_NAME)67)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SIDE_LUNGE_TO_CROSSOVER_TAP             ((FIT_LUNGE_EXERCISE_NAME)68)
#define FIT_LUNGE_EXERCISE_NAME_SIDE_TO_SIDE_LUNGE_CHOPS                         ((FIT_LUNGE_EXERCISE_NAME)69)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SIDE_TO_SIDE_LUNGE_CHOPS                ((FIT_LUNGE_EXERCISE_NAME)70)
#define FIT_LUNGE_EXERCISE_NAME_SIFF_JUMP_LUNGE                                  ((FIT_LUNGE_EXERCISE_NAME)71)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SIFF_JUMP_LUNGE                         ((FIT_LUNGE_EXERCISE_NAME)72)
#define FIT_LUNGE_EXERCISE_NAME_SINGLE_ARM_REVERSE_LUNGE_AND_PRESS               ((FIT_LUNGE_EXERCISE_NAME)73)
#define FIT_LUNGE_EXERCISE_NAME_SLIDING_LATERAL_LUNGE                            ((FIT_LUNGE_EXERCISE_NAME)74)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_SLIDING_LATERAL_LUNGE                   ((FIT_LUNGE_EXERCISE_NAME)75)
#define FIT_LUNGE_EXERCISE_NAME_WALKING_BARBELL_LUNGE                            ((FIT_LUNGE_EXERCISE_NAME)76)
#define FIT_LUNGE_EXERCISE_NAME_WALKING_DUMBBELL_LUNGE                           ((FIT_LUNGE_EXERCISE_NAME)77)
#define FIT_LUNGE_EXERCISE_NAME_WALKING_LUNGE                                    ((FIT_LUNGE_EXERCISE_NAME)78)
#define FIT_LUNGE_EXERCISE_NAME_WEIGHTED_WALKING_LUNGE                           ((FIT_LUNGE_EXERCISE_NAME)79)
#define FIT_LUNGE_EXERCISE_NAME_WIDE_GRIP_OVERHEAD_BARBELL_SPLIT_SQUAT           ((FIT_LUNGE_EXERCISE_NAME)80)
#define FIT_LUNGE_EXERCISE_NAME_COUNT                                            81

typedef FIT_UINT16 FIT_OLYMPIC_LIFT_EXERCISE_NAME;
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_INVALID                                   FIT_UINT16_INVALID
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_HANG_POWER_CLEAN                  ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)0)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_HANG_SQUAT_CLEAN                  ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)1)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_POWER_CLEAN                       ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)2)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_POWER_SNATCH                      ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)3)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_SQUAT_CLEAN                       ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)4)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_CLEAN_AND_JERK                            ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)5)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_HANG_POWER_SNATCH                 ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)6)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_HANG_PULL                         ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)7)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_HIGH_PULL                         ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)8)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_SNATCH                            ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)9)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_BARBELL_SPLIT_JERK                        ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)10)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_CLEAN                                     ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)11)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_DUMBBELL_CLEAN                            ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)12)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_DUMBBELL_HANG_PULL                        ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)13)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_ONE_HAND_DUMBBELL_SPLIT_SNATCH            ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)14)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_PUSH_JERK                                 ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)15)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_SINGLE_ARM_DUMBBELL_SNATCH                ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)16)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_SINGLE_ARM_HANG_SNATCH                    ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)17)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_SINGLE_ARM_KETTLEBELL_SNATCH              ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)18)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_SPLIT_JERK                                ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)19)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_SQUAT_CLEAN_AND_JERK                      ((FIT_OLYMPIC_LIFT_EXERCISE_NAME)20)
#define FIT_OLYMPIC_LIFT_EXERCISE_NAME_COUNT                                     21

typedef FIT_UINT16 FIT_PLANK_EXERCISE_NAME;
#define FIT_PLANK_EXERCISE_NAME_INVALID                                          FIT_UINT16_INVALID
#define FIT_PLANK_EXERCISE_NAME_45_DEGREE_PLANK                                  ((FIT_PLANK_EXERCISE_NAME)0)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_45_DEGREE_PLANK                         ((FIT_PLANK_EXERCISE_NAME)1)
#define FIT_PLANK_EXERCISE_NAME_90_DEGREE_STATIC_HOLD                            ((FIT_PLANK_EXERCISE_NAME)2)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_90_DEGREE_STATIC_HOLD                   ((FIT_PLANK_EXERCISE_NAME)3)
#define FIT_PLANK_EXERCISE_NAME_BEAR_CRAWL                                       ((FIT_PLANK_EXERCISE_NAME)4)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_BEAR_CRAWL                              ((FIT_PLANK_EXERCISE_NAME)5)
#define FIT_PLANK_EXERCISE_NAME_CROSS_BODY_MOUNTAIN_CLIMBER                      ((FIT_PLANK_EXERCISE_NAME)6)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_CROSS_BODY_MOUNTAIN_CLIMBER             ((FIT_PLANK_EXERCISE_NAME)7)
#define FIT_PLANK_EXERCISE_NAME_ELBOW_PLANK_PIKE_JACKS                           ((FIT_PLANK_EXERCISE_NAME)8)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_ELBOW_PLANK_PIKE_JACKS                  ((FIT_PLANK_EXERCISE_NAME)9)
#define FIT_PLANK_EXERCISE_NAME_ELEVATED_FEET_PLANK                              ((FIT_PLANK_EXERCISE_NAME)10)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_ELEVATED_FEET_PLANK                     ((FIT_PLANK_EXERCISE_NAME)11)
#define FIT_PLANK_EXERCISE_NAME_ELEVATOR_ABS                                     ((FIT_PLANK_EXERCISE_NAME)12)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_ELEVATOR_ABS                            ((FIT_PLANK_EXERCISE_NAME)13)
#define FIT_PLANK_EXERCISE_NAME_EXTENDED_PLANK                                   ((FIT_PLANK_EXERCISE_NAME)14)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_EXTENDED_PLANK                          ((FIT_PLANK_EXERCISE_NAME)15)
#define FIT_PLANK_EXERCISE_NAME_FULL_PLANK_PASSE_TWIST                           ((FIT_PLANK_EXERCISE_NAME)16)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_FULL_PLANK_PASSE_TWIST                  ((FIT_PLANK_EXERCISE_NAME)17)
#define FIT_PLANK_EXERCISE_NAME_INCHING_ELBOW_PLANK                              ((FIT_PLANK_EXERCISE_NAME)18)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_INCHING_ELBOW_PLANK                     ((FIT_PLANK_EXERCISE_NAME)19)
#define FIT_PLANK_EXERCISE_NAME_INCHWORM_TO_SIDE_PLANK                           ((FIT_PLANK_EXERCISE_NAME)20)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_INCHWORM_TO_SIDE_PLANK                  ((FIT_PLANK_EXERCISE_NAME)21)
#define FIT_PLANK_EXERCISE_NAME_KNEELING_PLANK                                   ((FIT_PLANK_EXERCISE_NAME)22)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_KNEELING_PLANK                          ((FIT_PLANK_EXERCISE_NAME)23)
#define FIT_PLANK_EXERCISE_NAME_KNEELING_SIDE_PLANK_WITH_LEG_LIFT                ((FIT_PLANK_EXERCISE_NAME)24)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_KNEELING_SIDE_PLANK_WITH_LEG_LIFT       ((FIT_PLANK_EXERCISE_NAME)25)
#define FIT_PLANK_EXERCISE_NAME_LATERAL_ROLL                                     ((FIT_PLANK_EXERCISE_NAME)26)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_LATERAL_ROLL                            ((FIT_PLANK_EXERCISE_NAME)27)
#define FIT_PLANK_EXERCISE_NAME_LYING_REVERSE_PLANK                              ((FIT_PLANK_EXERCISE_NAME)28)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_LYING_REVERSE_PLANK                     ((FIT_PLANK_EXERCISE_NAME)29)
#define FIT_PLANK_EXERCISE_NAME_MEDICINE_BALL_MOUNTAIN_CLIMBER                   ((FIT_PLANK_EXERCISE_NAME)30)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MEDICINE_BALL_MOUNTAIN_CLIMBER          ((FIT_PLANK_EXERCISE_NAME)31)
#define FIT_PLANK_EXERCISE_NAME_MODIFIED_MOUNTAIN_CLIMBER_AND_EXTENSION          ((FIT_PLANK_EXERCISE_NAME)32)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MODIFIED_MOUNTAIN_CLIMBER_AND_EXTENSION ((FIT_PLANK_EXERCISE_NAME)33)
#define FIT_PLANK_EXERCISE_NAME_MOUNTAIN_CLIMBER                                 ((FIT_PLANK_EXERCISE_NAME)34)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MOUNTAIN_CLIMBER                        ((FIT_PLANK_EXERCISE_NAME)35)
#define FIT_PLANK_EXERCISE_NAME_MOUNTAIN_CLIMBER_ON_SLIDING_DISCS                ((FIT_PLANK_EXERCISE_NAME)36)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MOUNTAIN_CLIMBER_ON_SLIDING_DISCS       ((FIT_PLANK_EXERCISE_NAME)37)
#define FIT_PLANK_EXERCISE_NAME_MOUNTAIN_CLIMBER_WITH_FEET_ON_BOSU_BALL          ((FIT_PLANK_EXERCISE_NAME)38)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MOUNTAIN_CLIMBER_WITH_FEET_ON_BOSU_BALL ((FIT_PLANK_EXERCISE_NAME)39)
#define FIT_PLANK_EXERCISE_NAME_MOUNTAIN_CLIMBER_WITH_HANDS_ON_BENCH             ((FIT_PLANK_EXERCISE_NAME)40)
#define FIT_PLANK_EXERCISE_NAME_MOUNTAIN_CLIMBER_WITH_HANDS_ON_SWISS_BALL        ((FIT_PLANK_EXERCISE_NAME)41)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MOUNTAIN_CLIMBER_WITH_HANDS_ON_SWISS_BALL ((FIT_PLANK_EXERCISE_NAME)42)
#define FIT_PLANK_EXERCISE_NAME_PLANK                                            ((FIT_PLANK_EXERCISE_NAME)43)
#define FIT_PLANK_EXERCISE_NAME_PLANK_JACKS_WITH_FEET_ON_SLIDING_DISCS           ((FIT_PLANK_EXERCISE_NAME)44)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_JACKS_WITH_FEET_ON_SLIDING_DISCS  ((FIT_PLANK_EXERCISE_NAME)45)
#define FIT_PLANK_EXERCISE_NAME_PLANK_KNEE_TWIST                                 ((FIT_PLANK_EXERCISE_NAME)46)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_KNEE_TWIST                        ((FIT_PLANK_EXERCISE_NAME)47)
#define FIT_PLANK_EXERCISE_NAME_PLANK_PIKE_JUMPS                                 ((FIT_PLANK_EXERCISE_NAME)48)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_PIKE_JUMPS                        ((FIT_PLANK_EXERCISE_NAME)49)
#define FIT_PLANK_EXERCISE_NAME_PLANK_PIKES                                      ((FIT_PLANK_EXERCISE_NAME)50)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_PIKES                             ((FIT_PLANK_EXERCISE_NAME)51)
#define FIT_PLANK_EXERCISE_NAME_PLANK_TO_STAND_UP                                ((FIT_PLANK_EXERCISE_NAME)52)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_TO_STAND_UP                       ((FIT_PLANK_EXERCISE_NAME)53)
#define FIT_PLANK_EXERCISE_NAME_PLANK_WITH_ARM_RAISE                             ((FIT_PLANK_EXERCISE_NAME)54)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_WITH_ARM_RAISE                    ((FIT_PLANK_EXERCISE_NAME)55)
#define FIT_PLANK_EXERCISE_NAME_PLANK_WITH_KNEE_TO_ELBOW                         ((FIT_PLANK_EXERCISE_NAME)56)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_WITH_KNEE_TO_ELBOW                ((FIT_PLANK_EXERCISE_NAME)57)
#define FIT_PLANK_EXERCISE_NAME_PLANK_WITH_OBLIQUE_CRUNCH                        ((FIT_PLANK_EXERCISE_NAME)58)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK_WITH_OBLIQUE_CRUNCH               ((FIT_PLANK_EXERCISE_NAME)59)
#define FIT_PLANK_EXERCISE_NAME_PLYOMETRIC_SIDE_PLANK                            ((FIT_PLANK_EXERCISE_NAME)60)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLYOMETRIC_SIDE_PLANK                   ((FIT_PLANK_EXERCISE_NAME)61)
#define FIT_PLANK_EXERCISE_NAME_ROLLING_SIDE_PLANK                               ((FIT_PLANK_EXERCISE_NAME)62)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_ROLLING_SIDE_PLANK                      ((FIT_PLANK_EXERCISE_NAME)63)
#define FIT_PLANK_EXERCISE_NAME_SIDE_KICK_PLANK                                  ((FIT_PLANK_EXERCISE_NAME)64)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_KICK_PLANK                         ((FIT_PLANK_EXERCISE_NAME)65)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK                                       ((FIT_PLANK_EXERCISE_NAME)66)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK                              ((FIT_PLANK_EXERCISE_NAME)67)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_AND_ROW                               ((FIT_PLANK_EXERCISE_NAME)68)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_AND_ROW                      ((FIT_PLANK_EXERCISE_NAME)69)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_LIFT                                  ((FIT_PLANK_EXERCISE_NAME)70)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_LIFT                         ((FIT_PLANK_EXERCISE_NAME)71)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_WITH_ELBOW_ON_BOSU_BALL               ((FIT_PLANK_EXERCISE_NAME)72)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_WITH_ELBOW_ON_BOSU_BALL      ((FIT_PLANK_EXERCISE_NAME)73)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_WITH_FEET_ON_BENCH                    ((FIT_PLANK_EXERCISE_NAME)74)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_WITH_FEET_ON_BENCH           ((FIT_PLANK_EXERCISE_NAME)75)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_WITH_KNEE_CIRCLE                      ((FIT_PLANK_EXERCISE_NAME)76)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_WITH_KNEE_CIRCLE             ((FIT_PLANK_EXERCISE_NAME)77)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_WITH_KNEE_TUCK                        ((FIT_PLANK_EXERCISE_NAME)78)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_WITH_KNEE_TUCK               ((FIT_PLANK_EXERCISE_NAME)79)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_WITH_LEG_LIFT                         ((FIT_PLANK_EXERCISE_NAME)80)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_WITH_LEG_LIFT                ((FIT_PLANK_EXERCISE_NAME)81)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_WITH_REACH_UNDER                      ((FIT_PLANK_EXERCISE_NAME)82)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SIDE_PLANK_WITH_REACH_UNDER             ((FIT_PLANK_EXERCISE_NAME)83)
#define FIT_PLANK_EXERCISE_NAME_SINGLE_LEG_ELEVATED_FEET_PLANK                   ((FIT_PLANK_EXERCISE_NAME)84)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_ELEVATED_FEET_PLANK          ((FIT_PLANK_EXERCISE_NAME)85)
#define FIT_PLANK_EXERCISE_NAME_SINGLE_LEG_FLEX_AND_EXTEND                       ((FIT_PLANK_EXERCISE_NAME)86)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_FLEX_AND_EXTEND              ((FIT_PLANK_EXERCISE_NAME)87)
#define FIT_PLANK_EXERCISE_NAME_SINGLE_LEG_SIDE_PLANK                            ((FIT_PLANK_EXERCISE_NAME)88)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_SIDE_PLANK                   ((FIT_PLANK_EXERCISE_NAME)89)
#define FIT_PLANK_EXERCISE_NAME_SPIDERMAN_PLANK                                  ((FIT_PLANK_EXERCISE_NAME)90)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SPIDERMAN_PLANK                         ((FIT_PLANK_EXERCISE_NAME)91)
#define FIT_PLANK_EXERCISE_NAME_STRAIGHT_ARM_PLANK                               ((FIT_PLANK_EXERCISE_NAME)92)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_STRAIGHT_ARM_PLANK                      ((FIT_PLANK_EXERCISE_NAME)93)
#define FIT_PLANK_EXERCISE_NAME_STRAIGHT_ARM_PLANK_WITH_SHOULDER_TOUCH           ((FIT_PLANK_EXERCISE_NAME)94)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_STRAIGHT_ARM_PLANK_WITH_SHOULDER_TOUCH  ((FIT_PLANK_EXERCISE_NAME)95)
#define FIT_PLANK_EXERCISE_NAME_SWISS_BALL_PLANK                                 ((FIT_PLANK_EXERCISE_NAME)96)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PLANK                        ((FIT_PLANK_EXERCISE_NAME)97)
#define FIT_PLANK_EXERCISE_NAME_SWISS_BALL_PLANK_LEG_LIFT                        ((FIT_PLANK_EXERCISE_NAME)98)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PLANK_LEG_LIFT               ((FIT_PLANK_EXERCISE_NAME)99)
#define FIT_PLANK_EXERCISE_NAME_SWISS_BALL_PLANK_LEG_LIFT_AND_HOLD               ((FIT_PLANK_EXERCISE_NAME)100)
#define FIT_PLANK_EXERCISE_NAME_SWISS_BALL_PLANK_WITH_FEET_ON_BENCH              ((FIT_PLANK_EXERCISE_NAME)101)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PLANK_WITH_FEET_ON_BENCH     ((FIT_PLANK_EXERCISE_NAME)102)
#define FIT_PLANK_EXERCISE_NAME_SWISS_BALL_PRONE_JACKKNIFE                       ((FIT_PLANK_EXERCISE_NAME)103)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PRONE_JACKKNIFE              ((FIT_PLANK_EXERCISE_NAME)104)
#define FIT_PLANK_EXERCISE_NAME_SWISS_BALL_SIDE_PLANK                            ((FIT_PLANK_EXERCISE_NAME)105)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SWISS_BALL_SIDE_PLANK                   ((FIT_PLANK_EXERCISE_NAME)106)
#define FIT_PLANK_EXERCISE_NAME_THREE_WAY_PLANK                                  ((FIT_PLANK_EXERCISE_NAME)107)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_THREE_WAY_PLANK                         ((FIT_PLANK_EXERCISE_NAME)108)
#define FIT_PLANK_EXERCISE_NAME_TOWEL_PLANK_AND_KNEE_IN                          ((FIT_PLANK_EXERCISE_NAME)109)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_TOWEL_PLANK_AND_KNEE_IN                 ((FIT_PLANK_EXERCISE_NAME)110)
#define FIT_PLANK_EXERCISE_NAME_T_STABILIZATION                                  ((FIT_PLANK_EXERCISE_NAME)111)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_T_STABILIZATION                         ((FIT_PLANK_EXERCISE_NAME)112)
#define FIT_PLANK_EXERCISE_NAME_TURKISH_GET_UP_TO_SIDE_PLANK                     ((FIT_PLANK_EXERCISE_NAME)113)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_TURKISH_GET_UP_TO_SIDE_PLANK            ((FIT_PLANK_EXERCISE_NAME)114)
#define FIT_PLANK_EXERCISE_NAME_TWO_POINT_PLANK                                  ((FIT_PLANK_EXERCISE_NAME)115)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_TWO_POINT_PLANK                         ((FIT_PLANK_EXERCISE_NAME)116)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_PLANK                                   ((FIT_PLANK_EXERCISE_NAME)117)
#define FIT_PLANK_EXERCISE_NAME_WIDE_STANCE_PLANK_WITH_DIAGONAL_ARM_LIFT         ((FIT_PLANK_EXERCISE_NAME)118)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_WIDE_STANCE_PLANK_WITH_DIAGONAL_ARM_LIFT ((FIT_PLANK_EXERCISE_NAME)119)
#define FIT_PLANK_EXERCISE_NAME_WIDE_STANCE_PLANK_WITH_DIAGONAL_LEG_LIFT         ((FIT_PLANK_EXERCISE_NAME)120)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_WIDE_STANCE_PLANK_WITH_DIAGONAL_LEG_LIFT ((FIT_PLANK_EXERCISE_NAME)121)
#define FIT_PLANK_EXERCISE_NAME_WIDE_STANCE_PLANK_WITH_LEG_LIFT                  ((FIT_PLANK_EXERCISE_NAME)122)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_WIDE_STANCE_PLANK_WITH_LEG_LIFT         ((FIT_PLANK_EXERCISE_NAME)123)
#define FIT_PLANK_EXERCISE_NAME_WIDE_STANCE_PLANK_WITH_OPPOSITE_ARM_AND_LEG_LIFT ((FIT_PLANK_EXERCISE_NAME)124)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_MOUNTAIN_CLIMBER_WITH_HANDS_ON_BENCH    ((FIT_PLANK_EXERCISE_NAME)125)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PLANK_LEG_LIFT_AND_HOLD      ((FIT_PLANK_EXERCISE_NAME)126)
#define FIT_PLANK_EXERCISE_NAME_WEIGHTED_WIDE_STANCE_PLANK_WITH_OPPOSITE_ARM_AND_LEG_LIFT ((FIT_PLANK_EXERCISE_NAME)127)
#define FIT_PLANK_EXERCISE_NAME_PLANK_WITH_FEET_ON_SWISS_BALL                    ((FIT_PLANK_EXERCISE_NAME)128)
#define FIT_PLANK_EXERCISE_NAME_SIDE_PLANK_TO_PLANK_WITH_REACH_UNDER             ((FIT_PLANK_EXERCISE_NAME)129)
#define FIT_PLANK_EXERCISE_NAME_BRIDGE_WITH_GLUTE_LOWER_LIFT                     ((FIT_PLANK_EXERCISE_NAME)130)
#define FIT_PLANK_EXERCISE_NAME_BRIDGE_ONE_LEG_BRIDGE                            ((FIT_PLANK_EXERCISE_NAME)131)
#define FIT_PLANK_EXERCISE_NAME_PLANK_WITH_ARM_VARIATIONS                        ((FIT_PLANK_EXERCISE_NAME)132)
#define FIT_PLANK_EXERCISE_NAME_PLANK_WITH_LEG_LIFT                              ((FIT_PLANK_EXERCISE_NAME)133)
#define FIT_PLANK_EXERCISE_NAME_REVERSE_PLANK_WITH_LEG_PULL                      ((FIT_PLANK_EXERCISE_NAME)134)
#define FIT_PLANK_EXERCISE_NAME_COUNT                                            135

typedef FIT_UINT16 FIT_PLYO_EXERCISE_NAME;
#define FIT_PLYO_EXERCISE_NAME_INVALID                                           FIT_UINT16_INVALID
#define FIT_PLYO_EXERCISE_NAME_ALTERNATING_JUMP_LUNGE                            ((FIT_PLYO_EXERCISE_NAME)0)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_ALTERNATING_JUMP_LUNGE                   ((FIT_PLYO_EXERCISE_NAME)1)
#define FIT_PLYO_EXERCISE_NAME_BARBELL_JUMP_SQUAT                                ((FIT_PLYO_EXERCISE_NAME)2)
#define FIT_PLYO_EXERCISE_NAME_BODY_WEIGHT_JUMP_SQUAT                            ((FIT_PLYO_EXERCISE_NAME)3)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_JUMP_SQUAT                               ((FIT_PLYO_EXERCISE_NAME)4)
#define FIT_PLYO_EXERCISE_NAME_CROSS_KNEE_STRIKE                                 ((FIT_PLYO_EXERCISE_NAME)5)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_CROSS_KNEE_STRIKE                        ((FIT_PLYO_EXERCISE_NAME)6)
#define FIT_PLYO_EXERCISE_NAME_DEPTH_JUMP                                        ((FIT_PLYO_EXERCISE_NAME)7)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_DEPTH_JUMP                               ((FIT_PLYO_EXERCISE_NAME)8)
#define FIT_PLYO_EXERCISE_NAME_DUMBBELL_JUMP_SQUAT                               ((FIT_PLYO_EXERCISE_NAME)9)
#define FIT_PLYO_EXERCISE_NAME_DUMBBELL_SPLIT_JUMP                               ((FIT_PLYO_EXERCISE_NAME)10)
#define FIT_PLYO_EXERCISE_NAME_FRONT_KNEE_STRIKE                                 ((FIT_PLYO_EXERCISE_NAME)11)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_FRONT_KNEE_STRIKE                        ((FIT_PLYO_EXERCISE_NAME)12)
#define FIT_PLYO_EXERCISE_NAME_HIGH_BOX_JUMP                                     ((FIT_PLYO_EXERCISE_NAME)13)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_HIGH_BOX_JUMP                            ((FIT_PLYO_EXERCISE_NAME)14)
#define FIT_PLYO_EXERCISE_NAME_ISOMETRIC_EXPLOSIVE_BODY_WEIGHT_JUMP_SQUAT        ((FIT_PLYO_EXERCISE_NAME)15)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_ISOMETRIC_EXPLOSIVE_JUMP_SQUAT           ((FIT_PLYO_EXERCISE_NAME)16)
#define FIT_PLYO_EXERCISE_NAME_LATERAL_LEAP_AND_HOP                              ((FIT_PLYO_EXERCISE_NAME)17)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_LATERAL_LEAP_AND_HOP                     ((FIT_PLYO_EXERCISE_NAME)18)
#define FIT_PLYO_EXERCISE_NAME_LATERAL_PLYO_SQUATS                               ((FIT_PLYO_EXERCISE_NAME)19)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_LATERAL_PLYO_SQUATS                      ((FIT_PLYO_EXERCISE_NAME)20)
#define FIT_PLYO_EXERCISE_NAME_LATERAL_SLIDE                                     ((FIT_PLYO_EXERCISE_NAME)21)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_LATERAL_SLIDE                            ((FIT_PLYO_EXERCISE_NAME)22)
#define FIT_PLYO_EXERCISE_NAME_MEDICINE_BALL_OVERHEAD_THROWS                     ((FIT_PLYO_EXERCISE_NAME)23)
#define FIT_PLYO_EXERCISE_NAME_MEDICINE_BALL_SIDE_THROW                          ((FIT_PLYO_EXERCISE_NAME)24)
#define FIT_PLYO_EXERCISE_NAME_MEDICINE_BALL_SLAM                                ((FIT_PLYO_EXERCISE_NAME)25)
#define FIT_PLYO_EXERCISE_NAME_SIDE_TO_SIDE_MEDICINE_BALL_THROWS                 ((FIT_PLYO_EXERCISE_NAME)26)
#define FIT_PLYO_EXERCISE_NAME_SIDE_TO_SIDE_SHUFFLE_JUMP                         ((FIT_PLYO_EXERCISE_NAME)27)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_SIDE_TO_SIDE_SHUFFLE_JUMP                ((FIT_PLYO_EXERCISE_NAME)28)
#define FIT_PLYO_EXERCISE_NAME_SQUAT_JUMP_ONTO_BOX                               ((FIT_PLYO_EXERCISE_NAME)29)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_SQUAT_JUMP_ONTO_BOX                      ((FIT_PLYO_EXERCISE_NAME)30)
#define FIT_PLYO_EXERCISE_NAME_SQUAT_JUMPS_IN_AND_OUT                            ((FIT_PLYO_EXERCISE_NAME)31)
#define FIT_PLYO_EXERCISE_NAME_WEIGHTED_SQUAT_JUMPS_IN_AND_OUT                   ((FIT_PLYO_EXERCISE_NAME)32)
#define FIT_PLYO_EXERCISE_NAME_COUNT                                             33

typedef FIT_UINT16 FIT_PULL_UP_EXERCISE_NAME;
#define FIT_PULL_UP_EXERCISE_NAME_INVALID                                        FIT_UINT16_INVALID
#define FIT_PULL_UP_EXERCISE_NAME_BANDED_PULL_UPS                                ((FIT_PULL_UP_EXERCISE_NAME)0)
#define FIT_PULL_UP_EXERCISE_NAME_30_DEGREE_LAT_PULLDOWN                         ((FIT_PULL_UP_EXERCISE_NAME)1)
#define FIT_PULL_UP_EXERCISE_NAME_BAND_ASSISTED_CHIN_UP                          ((FIT_PULL_UP_EXERCISE_NAME)2)
#define FIT_PULL_UP_EXERCISE_NAME_CLOSE_GRIP_CHIN_UP                             ((FIT_PULL_UP_EXERCISE_NAME)3)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_CLOSE_GRIP_CHIN_UP                    ((FIT_PULL_UP_EXERCISE_NAME)4)
#define FIT_PULL_UP_EXERCISE_NAME_CLOSE_GRIP_LAT_PULLDOWN                        ((FIT_PULL_UP_EXERCISE_NAME)5)
#define FIT_PULL_UP_EXERCISE_NAME_CROSSOVER_CHIN_UP                              ((FIT_PULL_UP_EXERCISE_NAME)6)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_CROSSOVER_CHIN_UP                     ((FIT_PULL_UP_EXERCISE_NAME)7)
#define FIT_PULL_UP_EXERCISE_NAME_EZ_BAR_PULLOVER                                ((FIT_PULL_UP_EXERCISE_NAME)8)
#define FIT_PULL_UP_EXERCISE_NAME_HANGING_HURDLE                                 ((FIT_PULL_UP_EXERCISE_NAME)9)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_HANGING_HURDLE                        ((FIT_PULL_UP_EXERCISE_NAME)10)
#define FIT_PULL_UP_EXERCISE_NAME_KNEELING_LAT_PULLDOWN                          ((FIT_PULL_UP_EXERCISE_NAME)11)
#define FIT_PULL_UP_EXERCISE_NAME_KNEELING_UNDERHAND_GRIP_LAT_PULLDOWN           ((FIT_PULL_UP_EXERCISE_NAME)12)
#define FIT_PULL_UP_EXERCISE_NAME_LAT_PULLDOWN                                   ((FIT_PULL_UP_EXERCISE_NAME)13)
#define FIT_PULL_UP_EXERCISE_NAME_MIXED_GRIP_CHIN_UP                             ((FIT_PULL_UP_EXERCISE_NAME)14)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_MIXED_GRIP_CHIN_UP                    ((FIT_PULL_UP_EXERCISE_NAME)15)
#define FIT_PULL_UP_EXERCISE_NAME_MIXED_GRIP_PULL_UP                             ((FIT_PULL_UP_EXERCISE_NAME)16)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_MIXED_GRIP_PULL_UP                    ((FIT_PULL_UP_EXERCISE_NAME)17)
#define FIT_PULL_UP_EXERCISE_NAME_REVERSE_GRIP_PULLDOWN                          ((FIT_PULL_UP_EXERCISE_NAME)18)
#define FIT_PULL_UP_EXERCISE_NAME_STANDING_CABLE_PULLOVER                        ((FIT_PULL_UP_EXERCISE_NAME)19)
#define FIT_PULL_UP_EXERCISE_NAME_STRAIGHT_ARM_PULLDOWN                          ((FIT_PULL_UP_EXERCISE_NAME)20)
#define FIT_PULL_UP_EXERCISE_NAME_SWISS_BALL_EZ_BAR_PULLOVER                     ((FIT_PULL_UP_EXERCISE_NAME)21)
#define FIT_PULL_UP_EXERCISE_NAME_TOWEL_PULL_UP                                  ((FIT_PULL_UP_EXERCISE_NAME)22)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_TOWEL_PULL_UP                         ((FIT_PULL_UP_EXERCISE_NAME)23)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_PULL_UP                               ((FIT_PULL_UP_EXERCISE_NAME)24)
#define FIT_PULL_UP_EXERCISE_NAME_WIDE_GRIP_LAT_PULLDOWN                         ((FIT_PULL_UP_EXERCISE_NAME)25)
#define FIT_PULL_UP_EXERCISE_NAME_WIDE_GRIP_PULL_UP                              ((FIT_PULL_UP_EXERCISE_NAME)26)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_WIDE_GRIP_PULL_UP                     ((FIT_PULL_UP_EXERCISE_NAME)27)
#define FIT_PULL_UP_EXERCISE_NAME_BURPEE_PULL_UP                                 ((FIT_PULL_UP_EXERCISE_NAME)28)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_BURPEE_PULL_UP                        ((FIT_PULL_UP_EXERCISE_NAME)29)
#define FIT_PULL_UP_EXERCISE_NAME_JUMPING_PULL_UPS                               ((FIT_PULL_UP_EXERCISE_NAME)30)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_JUMPING_PULL_UPS                      ((FIT_PULL_UP_EXERCISE_NAME)31)
#define FIT_PULL_UP_EXERCISE_NAME_KIPPING_PULL_UP                                ((FIT_PULL_UP_EXERCISE_NAME)32)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_KIPPING_PULL_UP                       ((FIT_PULL_UP_EXERCISE_NAME)33)
#define FIT_PULL_UP_EXERCISE_NAME_L_PULL_UP                                      ((FIT_PULL_UP_EXERCISE_NAME)34)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_L_PULL_UP                             ((FIT_PULL_UP_EXERCISE_NAME)35)
#define FIT_PULL_UP_EXERCISE_NAME_SUSPENDED_CHIN_UP                              ((FIT_PULL_UP_EXERCISE_NAME)36)
#define FIT_PULL_UP_EXERCISE_NAME_WEIGHTED_SUSPENDED_CHIN_UP                     ((FIT_PULL_UP_EXERCISE_NAME)37)
#define FIT_PULL_UP_EXERCISE_NAME_PULL_UP                                        ((FIT_PULL_UP_EXERCISE_NAME)38)
#define FIT_PULL_UP_EXERCISE_NAME_COUNT                                          39

typedef FIT_UINT16 FIT_PUSH_UP_EXERCISE_NAME;
#define FIT_PUSH_UP_EXERCISE_NAME_INVALID                                        FIT_UINT16_INVALID
#define FIT_PUSH_UP_EXERCISE_NAME_CHEST_PRESS_WITH_BAND                          ((FIT_PUSH_UP_EXERCISE_NAME)0)
#define FIT_PUSH_UP_EXERCISE_NAME_ALTERNATING_STAGGERED_PUSH_UP                  ((FIT_PUSH_UP_EXERCISE_NAME)1)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_ALTERNATING_STAGGERED_PUSH_UP         ((FIT_PUSH_UP_EXERCISE_NAME)2)
#define FIT_PUSH_UP_EXERCISE_NAME_ALTERNATING_HANDS_MEDICINE_BALL_PUSH_UP        ((FIT_PUSH_UP_EXERCISE_NAME)3)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_ALTERNATING_HANDS_MEDICINE_BALL_PUSH_UP ((FIT_PUSH_UP_EXERCISE_NAME)4)
#define FIT_PUSH_UP_EXERCISE_NAME_BOSU_BALL_PUSH_UP                              ((FIT_PUSH_UP_EXERCISE_NAME)5)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_BOSU_BALL_PUSH_UP                     ((FIT_PUSH_UP_EXERCISE_NAME)6)
#define FIT_PUSH_UP_EXERCISE_NAME_CLAPPING_PUSH_UP                               ((FIT_PUSH_UP_EXERCISE_NAME)7)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_CLAPPING_PUSH_UP                      ((FIT_PUSH_UP_EXERCISE_NAME)8)
#define FIT_PUSH_UP_EXERCISE_NAME_CLOSE_GRIP_MEDICINE_BALL_PUSH_UP               ((FIT_PUSH_UP_EXERCISE_NAME)9)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_CLOSE_GRIP_MEDICINE_BALL_PUSH_UP      ((FIT_PUSH_UP_EXERCISE_NAME)10)
#define FIT_PUSH_UP_EXERCISE_NAME_CLOSE_HANDS_PUSH_UP                            ((FIT_PUSH_UP_EXERCISE_NAME)11)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_CLOSE_HANDS_PUSH_UP                   ((FIT_PUSH_UP_EXERCISE_NAME)12)
#define FIT_PUSH_UP_EXERCISE_NAME_DECLINE_PUSH_UP                                ((FIT_PUSH_UP_EXERCISE_NAME)13)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_DECLINE_PUSH_UP                       ((FIT_PUSH_UP_EXERCISE_NAME)14)
#define FIT_PUSH_UP_EXERCISE_NAME_DIAMOND_PUSH_UP                                ((FIT_PUSH_UP_EXERCISE_NAME)15)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_DIAMOND_PUSH_UP                       ((FIT_PUSH_UP_EXERCISE_NAME)16)
#define FIT_PUSH_UP_EXERCISE_NAME_EXPLOSIVE_CROSSOVER_PUSH_UP                    ((FIT_PUSH_UP_EXERCISE_NAME)17)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_EXPLOSIVE_CROSSOVER_PUSH_UP           ((FIT_PUSH_UP_EXERCISE_NAME)18)
#define FIT_PUSH_UP_EXERCISE_NAME_EXPLOSIVE_PUSH_UP                              ((FIT_PUSH_UP_EXERCISE_NAME)19)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_EXPLOSIVE_PUSH_UP                     ((FIT_PUSH_UP_EXERCISE_NAME)20)
#define FIT_PUSH_UP_EXERCISE_NAME_FEET_ELEVATED_SIDE_TO_SIDE_PUSH_UP             ((FIT_PUSH_UP_EXERCISE_NAME)21)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_FEET_ELEVATED_SIDE_TO_SIDE_PUSH_UP    ((FIT_PUSH_UP_EXERCISE_NAME)22)
#define FIT_PUSH_UP_EXERCISE_NAME_HAND_RELEASE_PUSH_UP                           ((FIT_PUSH_UP_EXERCISE_NAME)23)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_HAND_RELEASE_PUSH_UP                  ((FIT_PUSH_UP_EXERCISE_NAME)24)
#define FIT_PUSH_UP_EXERCISE_NAME_HANDSTAND_PUSH_UP                              ((FIT_PUSH_UP_EXERCISE_NAME)25)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_HANDSTAND_PUSH_UP                     ((FIT_PUSH_UP_EXERCISE_NAME)26)
#define FIT_PUSH_UP_EXERCISE_NAME_INCLINE_PUSH_UP                                ((FIT_PUSH_UP_EXERCISE_NAME)27)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_INCLINE_PUSH_UP                       ((FIT_PUSH_UP_EXERCISE_NAME)28)
#define FIT_PUSH_UP_EXERCISE_NAME_ISOMETRIC_EXPLOSIVE_PUSH_UP                    ((FIT_PUSH_UP_EXERCISE_NAME)29)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_ISOMETRIC_EXPLOSIVE_PUSH_UP           ((FIT_PUSH_UP_EXERCISE_NAME)30)
#define FIT_PUSH_UP_EXERCISE_NAME_JUDO_PUSH_UP                                   ((FIT_PUSH_UP_EXERCISE_NAME)31)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_JUDO_PUSH_UP                          ((FIT_PUSH_UP_EXERCISE_NAME)32)
#define FIT_PUSH_UP_EXERCISE_NAME_KNEELING_PUSH_UP                               ((FIT_PUSH_UP_EXERCISE_NAME)33)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_KNEELING_PUSH_UP                      ((FIT_PUSH_UP_EXERCISE_NAME)34)
#define FIT_PUSH_UP_EXERCISE_NAME_MEDICINE_BALL_CHEST_PASS                       ((FIT_PUSH_UP_EXERCISE_NAME)35)
#define FIT_PUSH_UP_EXERCISE_NAME_MEDICINE_BALL_PUSH_UP                          ((FIT_PUSH_UP_EXERCISE_NAME)36)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_MEDICINE_BALL_PUSH_UP                 ((FIT_PUSH_UP_EXERCISE_NAME)37)
#define FIT_PUSH_UP_EXERCISE_NAME_ONE_ARM_PUSH_UP                                ((FIT_PUSH_UP_EXERCISE_NAME)38)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_ONE_ARM_PUSH_UP                       ((FIT_PUSH_UP_EXERCISE_NAME)39)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_PUSH_UP                               ((FIT_PUSH_UP_EXERCISE_NAME)40)
#define FIT_PUSH_UP_EXERCISE_NAME_PUSH_UP_AND_ROW                                ((FIT_PUSH_UP_EXERCISE_NAME)41)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_PUSH_UP_AND_ROW                       ((FIT_PUSH_UP_EXERCISE_NAME)42)
#define FIT_PUSH_UP_EXERCISE_NAME_PUSH_UP_PLUS                                   ((FIT_PUSH_UP_EXERCISE_NAME)43)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_PUSH_UP_PLUS                          ((FIT_PUSH_UP_EXERCISE_NAME)44)
#define FIT_PUSH_UP_EXERCISE_NAME_PUSH_UP_WITH_FEET_ON_SWISS_BALL                ((FIT_PUSH_UP_EXERCISE_NAME)45)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_PUSH_UP_WITH_FEET_ON_SWISS_BALL       ((FIT_PUSH_UP_EXERCISE_NAME)46)
#define FIT_PUSH_UP_EXERCISE_NAME_PUSH_UP_WITH_ONE_HAND_ON_MEDICINE_BALL         ((FIT_PUSH_UP_EXERCISE_NAME)47)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_PUSH_UP_WITH_ONE_HAND_ON_MEDICINE_BALL ((FIT_PUSH_UP_EXERCISE_NAME)48)
#define FIT_PUSH_UP_EXERCISE_NAME_SHOULDER_PUSH_UP                               ((FIT_PUSH_UP_EXERCISE_NAME)49)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_SHOULDER_PUSH_UP                      ((FIT_PUSH_UP_EXERCISE_NAME)50)
#define FIT_PUSH_UP_EXERCISE_NAME_SINGLE_ARM_MEDICINE_BALL_PUSH_UP               ((FIT_PUSH_UP_EXERCISE_NAME)51)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_SINGLE_ARM_MEDICINE_BALL_PUSH_UP      ((FIT_PUSH_UP_EXERCISE_NAME)52)
#define FIT_PUSH_UP_EXERCISE_NAME_SPIDERMAN_PUSH_UP                              ((FIT_PUSH_UP_EXERCISE_NAME)53)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_SPIDERMAN_PUSH_UP                     ((FIT_PUSH_UP_EXERCISE_NAME)54)
#define FIT_PUSH_UP_EXERCISE_NAME_STACKED_FEET_PUSH_UP                           ((FIT_PUSH_UP_EXERCISE_NAME)55)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_STACKED_FEET_PUSH_UP                  ((FIT_PUSH_UP_EXERCISE_NAME)56)
#define FIT_PUSH_UP_EXERCISE_NAME_STAGGERED_HANDS_PUSH_UP                        ((FIT_PUSH_UP_EXERCISE_NAME)57)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_STAGGERED_HANDS_PUSH_UP               ((FIT_PUSH_UP_EXERCISE_NAME)58)
#define FIT_PUSH_UP_EXERCISE_NAME_SUSPENDED_PUSH_UP                              ((FIT_PUSH_UP_EXERCISE_NAME)59)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_SUSPENDED_PUSH_UP                     ((FIT_PUSH_UP_EXERCISE_NAME)60)
#define FIT_PUSH_UP_EXERCISE_NAME_SWISS_BALL_PUSH_UP                             ((FIT_PUSH_UP_EXERCISE_NAME)61)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PUSH_UP                    ((FIT_PUSH_UP_EXERCISE_NAME)62)
#define FIT_PUSH_UP_EXERCISE_NAME_SWISS_BALL_PUSH_UP_PLUS                        ((FIT_PUSH_UP_EXERCISE_NAME)63)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_SWISS_BALL_PUSH_UP_PLUS               ((FIT_PUSH_UP_EXERCISE_NAME)64)
#define FIT_PUSH_UP_EXERCISE_NAME_T_PUSH_UP                                      ((FIT_PUSH_UP_EXERCISE_NAME)65)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_T_PUSH_UP                             ((FIT_PUSH_UP_EXERCISE_NAME)66)
#define FIT_PUSH_UP_EXERCISE_NAME_TRIPLE_STOP_PUSH_UP                            ((FIT_PUSH_UP_EXERCISE_NAME)67)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_TRIPLE_STOP_PUSH_UP                   ((FIT_PUSH_UP_EXERCISE_NAME)68)
#define FIT_PUSH_UP_EXERCISE_NAME_WIDE_HANDS_PUSH_UP                             ((FIT_PUSH_UP_EXERCISE_NAME)69)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_WIDE_HANDS_PUSH_UP                    ((FIT_PUSH_UP_EXERCISE_NAME)70)
#define FIT_PUSH_UP_EXERCISE_NAME_PARALLETTE_HANDSTAND_PUSH_UP                   ((FIT_PUSH_UP_EXERCISE_NAME)71)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_PARALLETTE_HANDSTAND_PUSH_UP          ((FIT_PUSH_UP_EXERCISE_NAME)72)
#define FIT_PUSH_UP_EXERCISE_NAME_RING_HANDSTAND_PUSH_UP                         ((FIT_PUSH_UP_EXERCISE_NAME)73)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_RING_HANDSTAND_PUSH_UP                ((FIT_PUSH_UP_EXERCISE_NAME)74)
#define FIT_PUSH_UP_EXERCISE_NAME_RING_PUSH_UP                                   ((FIT_PUSH_UP_EXERCISE_NAME)75)
#define FIT_PUSH_UP_EXERCISE_NAME_WEIGHTED_RING_PUSH_UP                          ((FIT_PUSH_UP_EXERCISE_NAME)76)
#define FIT_PUSH_UP_EXERCISE_NAME_PUSH_UP                                        ((FIT_PUSH_UP_EXERCISE_NAME)77)
#define FIT_PUSH_UP_EXERCISE_NAME_PILATES_PUSHUP                                 ((FIT_PUSH_UP_EXERCISE_NAME)78)
#define FIT_PUSH_UP_EXERCISE_NAME_COUNT                                          79

typedef FIT_UINT16 FIT_ROW_EXERCISE_NAME;
#define FIT_ROW_EXERCISE_NAME_INVALID                                            FIT_UINT16_INVALID
#define FIT_ROW_EXERCISE_NAME_BARBELL_STRAIGHT_LEG_DEADLIFT_TO_ROW               ((FIT_ROW_EXERCISE_NAME)0)
#define FIT_ROW_EXERCISE_NAME_CABLE_ROW_STANDING                                 ((FIT_ROW_EXERCISE_NAME)1)
#define FIT_ROW_EXERCISE_NAME_DUMBBELL_ROW                                       ((FIT_ROW_EXERCISE_NAME)2)
#define FIT_ROW_EXERCISE_NAME_ELEVATED_FEET_INVERTED_ROW                         ((FIT_ROW_EXERCISE_NAME)3)
#define FIT_ROW_EXERCISE_NAME_WEIGHTED_ELEVATED_FEET_INVERTED_ROW                ((FIT_ROW_EXERCISE_NAME)4)
#define FIT_ROW_EXERCISE_NAME_FACE_PULL                                          ((FIT_ROW_EXERCISE_NAME)5)
#define FIT_ROW_EXERCISE_NAME_FACE_PULL_WITH_EXTERNAL_ROTATION                   ((FIT_ROW_EXERCISE_NAME)6)
#define FIT_ROW_EXERCISE_NAME_INVERTED_ROW_WITH_FEET_ON_SWISS_BALL               ((FIT_ROW_EXERCISE_NAME)7)
#define FIT_ROW_EXERCISE_NAME_WEIGHTED_INVERTED_ROW_WITH_FEET_ON_SWISS_BALL      ((FIT_ROW_EXERCISE_NAME)8)
#define FIT_ROW_EXERCISE_NAME_KETTLEBELL_ROW                                     ((FIT_ROW_EXERCISE_NAME)9)
#define FIT_ROW_EXERCISE_NAME_MODIFIED_INVERTED_ROW                              ((FIT_ROW_EXERCISE_NAME)10)
#define FIT_ROW_EXERCISE_NAME_WEIGHTED_MODIFIED_INVERTED_ROW                     ((FIT_ROW_EXERCISE_NAME)11)
#define FIT_ROW_EXERCISE_NAME_NEUTRAL_GRIP_ALTERNATING_DUMBBELL_ROW              ((FIT_ROW_EXERCISE_NAME)12)
#define FIT_ROW_EXERCISE_NAME_ONE_ARM_BENT_OVER_ROW                              ((FIT_ROW_EXERCISE_NAME)13)
#define FIT_ROW_EXERCISE_NAME_ONE_LEGGED_DUMBBELL_ROW                            ((FIT_ROW_EXERCISE_NAME)14)
#define FIT_ROW_EXERCISE_NAME_RENEGADE_ROW                                       ((FIT_ROW_EXERCISE_NAME)15)
#define FIT_ROW_EXERCISE_NAME_REVERSE_GRIP_BARBELL_ROW                           ((FIT_ROW_EXERCISE_NAME)16)
#define FIT_ROW_EXERCISE_NAME_ROPE_HANDLE_CABLE_ROW                              ((FIT_ROW_EXERCISE_NAME)17)
#define FIT_ROW_EXERCISE_NAME_SEATED_CABLE_ROW                                   ((FIT_ROW_EXERCISE_NAME)18)
#define FIT_ROW_EXERCISE_NAME_SEATED_DUMBBELL_ROW                                ((FIT_ROW_EXERCISE_NAME)19)
#define FIT_ROW_EXERCISE_NAME_SINGLE_ARM_CABLE_ROW                               ((FIT_ROW_EXERCISE_NAME)20)
#define FIT_ROW_EXERCISE_NAME_SINGLE_ARM_CABLE_ROW_AND_ROTATION                  ((FIT_ROW_EXERCISE_NAME)21)
#define FIT_ROW_EXERCISE_NAME_SINGLE_ARM_INVERTED_ROW                            ((FIT_ROW_EXERCISE_NAME)22)
#define FIT_ROW_EXERCISE_NAME_WEIGHTED_SINGLE_ARM_INVERTED_ROW                   ((FIT_ROW_EXERCISE_NAME)23)
#define FIT_ROW_EXERCISE_NAME_SINGLE_ARM_NEUTRAL_GRIP_DUMBBELL_ROW               ((FIT_ROW_EXERCISE_NAME)24)
#define FIT_ROW_EXERCISE_NAME_SINGLE_ARM_NEUTRAL_GRIP_DUMBBELL_ROW_AND_ROTATION  ((FIT_ROW_EXERCISE_NAME)25)
#define FIT_ROW_EXERCISE_NAME_SUSPENDED_INVERTED_ROW                             ((FIT_ROW_EXERCISE_NAME)26)
#define FIT_ROW_EXERCISE_NAME_WEIGHTED_SUSPENDED_INVERTED_ROW                    ((FIT_ROW_EXERCISE_NAME)27)
#define FIT_ROW_EXERCISE_NAME_T_BAR_ROW                                          ((FIT_ROW_EXERCISE_NAME)28)
#define FIT_ROW_EXERCISE_NAME_TOWEL_GRIP_INVERTED_ROW                            ((FIT_ROW_EXERCISE_NAME)29)
#define FIT_ROW_EXERCISE_NAME_WEIGHTED_TOWEL_GRIP_INVERTED_ROW                   ((FIT_ROW_EXERCISE_NAME)30)
#define FIT_ROW_EXERCISE_NAME_UNDERHAND_GRIP_CABLE_ROW                           ((FIT_ROW_EXERCISE_NAME)31)
#define FIT_ROW_EXERCISE_NAME_V_GRIP_CABLE_ROW                                   ((FIT_ROW_EXERCISE_NAME)32)
#define FIT_ROW_EXERCISE_NAME_WIDE_GRIP_SEATED_CABLE_ROW                         ((FIT_ROW_EXERCISE_NAME)33)
#define FIT_ROW_EXERCISE_NAME_COUNT                                              34

typedef FIT_UINT16 FIT_SHOULDER_PRESS_EXERCISE_NAME;
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_INVALID                                 FIT_UINT16_INVALID
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_ALTERNATING_DUMBBELL_SHOULDER_PRESS     ((FIT_SHOULDER_PRESS_EXERCISE_NAME)0)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_ARNOLD_PRESS                            ((FIT_SHOULDER_PRESS_EXERCISE_NAME)1)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_BARBELL_FRONT_SQUAT_TO_PUSH_PRESS       ((FIT_SHOULDER_PRESS_EXERCISE_NAME)2)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_BARBELL_PUSH_PRESS                      ((FIT_SHOULDER_PRESS_EXERCISE_NAME)3)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_BARBELL_SHOULDER_PRESS                  ((FIT_SHOULDER_PRESS_EXERCISE_NAME)4)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_DEAD_CURL_PRESS                         ((FIT_SHOULDER_PRESS_EXERCISE_NAME)5)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_DUMBBELL_ALTERNATING_SHOULDER_PRESS_AND_TWIST ((FIT_SHOULDER_PRESS_EXERCISE_NAME)6)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_DUMBBELL_HAMMER_CURL_TO_LUNGE_TO_PRESS  ((FIT_SHOULDER_PRESS_EXERCISE_NAME)7)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_DUMBBELL_PUSH_PRESS                     ((FIT_SHOULDER_PRESS_EXERCISE_NAME)8)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_FLOOR_INVERTED_SHOULDER_PRESS           ((FIT_SHOULDER_PRESS_EXERCISE_NAME)9)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_WEIGHTED_FLOOR_INVERTED_SHOULDER_PRESS  ((FIT_SHOULDER_PRESS_EXERCISE_NAME)10)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_INVERTED_SHOULDER_PRESS                 ((FIT_SHOULDER_PRESS_EXERCISE_NAME)11)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_WEIGHTED_INVERTED_SHOULDER_PRESS        ((FIT_SHOULDER_PRESS_EXERCISE_NAME)12)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_ONE_ARM_PUSH_PRESS                      ((FIT_SHOULDER_PRESS_EXERCISE_NAME)13)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_OVERHEAD_BARBELL_PRESS                  ((FIT_SHOULDER_PRESS_EXERCISE_NAME)14)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_OVERHEAD_DUMBBELL_PRESS                 ((FIT_SHOULDER_PRESS_EXERCISE_NAME)15)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SEATED_BARBELL_SHOULDER_PRESS           ((FIT_SHOULDER_PRESS_EXERCISE_NAME)16)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SEATED_DUMBBELL_SHOULDER_PRESS          ((FIT_SHOULDER_PRESS_EXERCISE_NAME)17)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SINGLE_ARM_DUMBBELL_SHOULDER_PRESS      ((FIT_SHOULDER_PRESS_EXERCISE_NAME)18)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SINGLE_ARM_STEP_UP_AND_PRESS            ((FIT_SHOULDER_PRESS_EXERCISE_NAME)19)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SMITH_MACHINE_OVERHEAD_PRESS            ((FIT_SHOULDER_PRESS_EXERCISE_NAME)20)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SPLIT_STANCE_HAMMER_CURL_TO_PRESS       ((FIT_SHOULDER_PRESS_EXERCISE_NAME)21)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_SWISS_BALL_DUMBBELL_SHOULDER_PRESS      ((FIT_SHOULDER_PRESS_EXERCISE_NAME)22)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_WEIGHT_PLATE_FRONT_RAISE                ((FIT_SHOULDER_PRESS_EXERCISE_NAME)23)
#define FIT_SHOULDER_PRESS_EXERCISE_NAME_COUNT                                   24

typedef FIT_UINT16 FIT_SHOULDER_STABILITY_EXERCISE_NAME;
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_INVALID                             FIT_UINT16_INVALID
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_90_DEGREE_CABLE_EXTERNAL_ROTATION   ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)0)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_BAND_EXTERNAL_ROTATION              ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)1)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_BAND_INTERNAL_ROTATION              ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)2)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_BENT_ARM_LATERAL_RAISE_AND_EXTERNAL_ROTATION ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)3)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_CABLE_EXTERNAL_ROTATION             ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)4)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_DUMBBELL_FACE_PULL_WITH_EXTERNAL_ROTATION ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)5)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_FLOOR_I_RAISE                       ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)6)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_FLOOR_I_RAISE              ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)7)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_FLOOR_T_RAISE                       ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)8)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_FLOOR_T_RAISE              ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)9)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_FLOOR_Y_RAISE                       ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)10)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_FLOOR_Y_RAISE              ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)11)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_INCLINE_I_RAISE                     ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)12)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_INCLINE_I_RAISE            ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)13)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_INCLINE_L_RAISE                     ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)14)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_INCLINE_L_RAISE            ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)15)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_INCLINE_T_RAISE                     ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)16)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_INCLINE_T_RAISE            ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)17)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_INCLINE_W_RAISE                     ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)18)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_INCLINE_W_RAISE            ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)19)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_INCLINE_Y_RAISE                     ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)20)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_INCLINE_Y_RAISE            ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)21)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_LYING_EXTERNAL_ROTATION             ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)22)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_SEATED_DUMBBELL_EXTERNAL_ROTATION   ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)23)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_STANDING_L_RAISE                    ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)24)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_SWISS_BALL_I_RAISE                  ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)25)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_SWISS_BALL_I_RAISE         ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)26)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_SWISS_BALL_T_RAISE                  ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)27)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_SWISS_BALL_T_RAISE         ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)28)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_SWISS_BALL_W_RAISE                  ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)29)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_SWISS_BALL_W_RAISE         ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)30)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_SWISS_BALL_Y_RAISE                  ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)31)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_WEIGHTED_SWISS_BALL_Y_RAISE         ((FIT_SHOULDER_STABILITY_EXERCISE_NAME)32)
#define FIT_SHOULDER_STABILITY_EXERCISE_NAME_COUNT                               33

typedef FIT_UINT16 FIT_SHRUG_EXERCISE_NAME;
#define FIT_SHRUG_EXERCISE_NAME_INVALID                                          FIT_UINT16_INVALID
#define FIT_SHRUG_EXERCISE_NAME_BARBELL_JUMP_SHRUG                               ((FIT_SHRUG_EXERCISE_NAME)0)
#define FIT_SHRUG_EXERCISE_NAME_BARBELL_SHRUG                                    ((FIT_SHRUG_EXERCISE_NAME)1)
#define FIT_SHRUG_EXERCISE_NAME_BARBELL_UPRIGHT_ROW                              ((FIT_SHRUG_EXERCISE_NAME)2)
#define FIT_SHRUG_EXERCISE_NAME_BEHIND_THE_BACK_SMITH_MACHINE_SHRUG              ((FIT_SHRUG_EXERCISE_NAME)3)
#define FIT_SHRUG_EXERCISE_NAME_DUMBBELL_JUMP_SHRUG                              ((FIT_SHRUG_EXERCISE_NAME)4)
#define FIT_SHRUG_EXERCISE_NAME_DUMBBELL_SHRUG                                   ((FIT_SHRUG_EXERCISE_NAME)5)
#define FIT_SHRUG_EXERCISE_NAME_DUMBBELL_UPRIGHT_ROW                             ((FIT_SHRUG_EXERCISE_NAME)6)
#define FIT_SHRUG_EXERCISE_NAME_INCLINE_DUMBBELL_SHRUG                           ((FIT_SHRUG_EXERCISE_NAME)7)
#define FIT_SHRUG_EXERCISE_NAME_OVERHEAD_BARBELL_SHRUG                           ((FIT_SHRUG_EXERCISE_NAME)8)
#define FIT_SHRUG_EXERCISE_NAME_OVERHEAD_DUMBBELL_SHRUG                          ((FIT_SHRUG_EXERCISE_NAME)9)
#define FIT_SHRUG_EXERCISE_NAME_SCAPTION_AND_SHRUG                               ((FIT_SHRUG_EXERCISE_NAME)10)
#define FIT_SHRUG_EXERCISE_NAME_SCAPULAR_RETRACTION                              ((FIT_SHRUG_EXERCISE_NAME)11)
#define FIT_SHRUG_EXERCISE_NAME_SERRATUS_CHAIR_SHRUG                             ((FIT_SHRUG_EXERCISE_NAME)12)
#define FIT_SHRUG_EXERCISE_NAME_WEIGHTED_SERRATUS_CHAIR_SHRUG                    ((FIT_SHRUG_EXERCISE_NAME)13)
#define FIT_SHRUG_EXERCISE_NAME_SERRATUS_SHRUG                                   ((FIT_SHRUG_EXERCISE_NAME)14)
#define FIT_SHRUG_EXERCISE_NAME_WEIGHTED_SERRATUS_SHRUG                          ((FIT_SHRUG_EXERCISE_NAME)15)
#define FIT_SHRUG_EXERCISE_NAME_WIDE_GRIP_JUMP_SHRUG                             ((FIT_SHRUG_EXERCISE_NAME)16)
#define FIT_SHRUG_EXERCISE_NAME_COUNT                                            17

typedef FIT_UINT16 FIT_SIT_UP_EXERCISE_NAME;
#define FIT_SIT_UP_EXERCISE_NAME_INVALID                                         FIT_UINT16_INVALID
#define FIT_SIT_UP_EXERCISE_NAME_ALTERNATING_SIT_UP                              ((FIT_SIT_UP_EXERCISE_NAME)0)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_ALTERNATING_SIT_UP                     ((FIT_SIT_UP_EXERCISE_NAME)1)
#define FIT_SIT_UP_EXERCISE_NAME_BENT_KNEE_V_UP                                  ((FIT_SIT_UP_EXERCISE_NAME)2)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_BENT_KNEE_V_UP                         ((FIT_SIT_UP_EXERCISE_NAME)3)
#define FIT_SIT_UP_EXERCISE_NAME_BUTTERFLY_SIT_UP                                ((FIT_SIT_UP_EXERCISE_NAME)4)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_BUTTERFLY_SITUP                        ((FIT_SIT_UP_EXERCISE_NAME)5)
#define FIT_SIT_UP_EXERCISE_NAME_CROSS_PUNCH_ROLL_UP                             ((FIT_SIT_UP_EXERCISE_NAME)6)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_CROSS_PUNCH_ROLL_UP                    ((FIT_SIT_UP_EXERCISE_NAME)7)
#define FIT_SIT_UP_EXERCISE_NAME_CROSSED_ARMS_SIT_UP                             ((FIT_SIT_UP_EXERCISE_NAME)8)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_CROSSED_ARMS_SIT_UP                    ((FIT_SIT_UP_EXERCISE_NAME)9)
#define FIT_SIT_UP_EXERCISE_NAME_GET_UP_SIT_UP                                   ((FIT_SIT_UP_EXERCISE_NAME)10)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_GET_UP_SIT_UP                          ((FIT_SIT_UP_EXERCISE_NAME)11)
#define FIT_SIT_UP_EXERCISE_NAME_HOVERING_SIT_UP                                 ((FIT_SIT_UP_EXERCISE_NAME)12)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_HOVERING_SIT_UP                        ((FIT_SIT_UP_EXERCISE_NAME)13)
#define FIT_SIT_UP_EXERCISE_NAME_KETTLEBELL_SIT_UP                               ((FIT_SIT_UP_EXERCISE_NAME)14)
#define FIT_SIT_UP_EXERCISE_NAME_MEDICINE_BALL_ALTERNATING_V_UP                  ((FIT_SIT_UP_EXERCISE_NAME)15)
#define FIT_SIT_UP_EXERCISE_NAME_MEDICINE_BALL_SIT_UP                            ((FIT_SIT_UP_EXERCISE_NAME)16)
#define FIT_SIT_UP_EXERCISE_NAME_MEDICINE_BALL_V_UP                              ((FIT_SIT_UP_EXERCISE_NAME)17)
#define FIT_SIT_UP_EXERCISE_NAME_MODIFIED_SIT_UP                                 ((FIT_SIT_UP_EXERCISE_NAME)18)
#define FIT_SIT_UP_EXERCISE_NAME_NEGATIVE_SIT_UP                                 ((FIT_SIT_UP_EXERCISE_NAME)19)
#define FIT_SIT_UP_EXERCISE_NAME_ONE_ARM_FULL_SIT_UP                             ((FIT_SIT_UP_EXERCISE_NAME)20)
#define FIT_SIT_UP_EXERCISE_NAME_RECLINING_CIRCLE                                ((FIT_SIT_UP_EXERCISE_NAME)21)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_RECLINING_CIRCLE                       ((FIT_SIT_UP_EXERCISE_NAME)22)
#define FIT_SIT_UP_EXERCISE_NAME_REVERSE_CURL_UP                                 ((FIT_SIT_UP_EXERCISE_NAME)23)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_REVERSE_CURL_UP                        ((FIT_SIT_UP_EXERCISE_NAME)24)
#define FIT_SIT_UP_EXERCISE_NAME_SINGLE_LEG_SWISS_BALL_JACKKNIFE                 ((FIT_SIT_UP_EXERCISE_NAME)25)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_SWISS_BALL_JACKKNIFE        ((FIT_SIT_UP_EXERCISE_NAME)26)
#define FIT_SIT_UP_EXERCISE_NAME_THE_TEASER                                      ((FIT_SIT_UP_EXERCISE_NAME)27)
#define FIT_SIT_UP_EXERCISE_NAME_THE_TEASER_WEIGHTED                             ((FIT_SIT_UP_EXERCISE_NAME)28)
#define FIT_SIT_UP_EXERCISE_NAME_THREE_PART_ROLL_DOWN                            ((FIT_SIT_UP_EXERCISE_NAME)29)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_THREE_PART_ROLL_DOWN                   ((FIT_SIT_UP_EXERCISE_NAME)30)
#define FIT_SIT_UP_EXERCISE_NAME_V_UP                                            ((FIT_SIT_UP_EXERCISE_NAME)31)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_V_UP                                   ((FIT_SIT_UP_EXERCISE_NAME)32)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_RUSSIAN_TWIST_ON_SWISS_BALL            ((FIT_SIT_UP_EXERCISE_NAME)33)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_SIT_UP                                 ((FIT_SIT_UP_EXERCISE_NAME)34)
#define FIT_SIT_UP_EXERCISE_NAME_X_ABS                                           ((FIT_SIT_UP_EXERCISE_NAME)35)
#define FIT_SIT_UP_EXERCISE_NAME_WEIGHTED_X_ABS                                  ((FIT_SIT_UP_EXERCISE_NAME)36)
#define FIT_SIT_UP_EXERCISE_NAME_SIT_UP                                          ((FIT_SIT_UP_EXERCISE_NAME)37)
#define FIT_SIT_UP_EXERCISE_NAME_COUNT                                           38

typedef FIT_UINT16 FIT_SQUAT_EXERCISE_NAME;
#define FIT_SQUAT_EXERCISE_NAME_INVALID                                          FIT_UINT16_INVALID
#define FIT_SQUAT_EXERCISE_NAME_LEG_PRESS                                        ((FIT_SQUAT_EXERCISE_NAME)0)
#define FIT_SQUAT_EXERCISE_NAME_BACK_SQUAT_WITH_BODY_BAR                         ((FIT_SQUAT_EXERCISE_NAME)1)
#define FIT_SQUAT_EXERCISE_NAME_BACK_SQUATS                                      ((FIT_SQUAT_EXERCISE_NAME)2)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_BACK_SQUATS                             ((FIT_SQUAT_EXERCISE_NAME)3)
#define FIT_SQUAT_EXERCISE_NAME_BALANCING_SQUAT                                  ((FIT_SQUAT_EXERCISE_NAME)4)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_BALANCING_SQUAT                         ((FIT_SQUAT_EXERCISE_NAME)5)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_BACK_SQUAT                               ((FIT_SQUAT_EXERCISE_NAME)6)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_BOX_SQUAT                                ((FIT_SQUAT_EXERCISE_NAME)7)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_FRONT_SQUAT                              ((FIT_SQUAT_EXERCISE_NAME)8)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_HACK_SQUAT                               ((FIT_SQUAT_EXERCISE_NAME)9)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_HANG_SQUAT_SNATCH                        ((FIT_SQUAT_EXERCISE_NAME)10)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_LATERAL_STEP_UP                          ((FIT_SQUAT_EXERCISE_NAME)11)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_QUARTER_SQUAT                            ((FIT_SQUAT_EXERCISE_NAME)12)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_SIFF_SQUAT                               ((FIT_SQUAT_EXERCISE_NAME)13)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_SQUAT_SNATCH                             ((FIT_SQUAT_EXERCISE_NAME)14)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_SQUAT_WITH_HEELS_RAISED                  ((FIT_SQUAT_EXERCISE_NAME)15)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_STEPOVER                                 ((FIT_SQUAT_EXERCISE_NAME)16)
#define FIT_SQUAT_EXERCISE_NAME_BARBELL_STEP_UP                                  ((FIT_SQUAT_EXERCISE_NAME)17)
#define FIT_SQUAT_EXERCISE_NAME_BENCH_SQUAT_WITH_ROTATIONAL_CHOP                 ((FIT_SQUAT_EXERCISE_NAME)18)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_BENCH_SQUAT_WITH_ROTATIONAL_CHOP        ((FIT_SQUAT_EXERCISE_NAME)19)
#define FIT_SQUAT_EXERCISE_NAME_BODY_WEIGHT_WALL_SQUAT                           ((FIT_SQUAT_EXERCISE_NAME)20)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_WALL_SQUAT                              ((FIT_SQUAT_EXERCISE_NAME)21)
#define FIT_SQUAT_EXERCISE_NAME_BOX_STEP_SQUAT                                   ((FIT_SQUAT_EXERCISE_NAME)22)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_BOX_STEP_SQUAT                          ((FIT_SQUAT_EXERCISE_NAME)23)
#define FIT_SQUAT_EXERCISE_NAME_BRACED_SQUAT                                     ((FIT_SQUAT_EXERCISE_NAME)24)
#define FIT_SQUAT_EXERCISE_NAME_CROSSED_ARM_BARBELL_FRONT_SQUAT                  ((FIT_SQUAT_EXERCISE_NAME)25)
#define FIT_SQUAT_EXERCISE_NAME_CROSSOVER_DUMBBELL_STEP_UP                       ((FIT_SQUAT_EXERCISE_NAME)26)
#define FIT_SQUAT_EXERCISE_NAME_DUMBBELL_FRONT_SQUAT                             ((FIT_SQUAT_EXERCISE_NAME)27)
#define FIT_SQUAT_EXERCISE_NAME_DUMBBELL_SPLIT_SQUAT                             ((FIT_SQUAT_EXERCISE_NAME)28)
#define FIT_SQUAT_EXERCISE_NAME_DUMBBELL_SQUAT                                   ((FIT_SQUAT_EXERCISE_NAME)29)
#define FIT_SQUAT_EXERCISE_NAME_DUMBBELL_SQUAT_CLEAN                             ((FIT_SQUAT_EXERCISE_NAME)30)
#define FIT_SQUAT_EXERCISE_NAME_DUMBBELL_STEPOVER                                ((FIT_SQUAT_EXERCISE_NAME)31)
#define FIT_SQUAT_EXERCISE_NAME_DUMBBELL_STEP_UP                                 ((FIT_SQUAT_EXERCISE_NAME)32)
#define FIT_SQUAT_EXERCISE_NAME_ELEVATED_SINGLE_LEG_SQUAT                        ((FIT_SQUAT_EXERCISE_NAME)33)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_ELEVATED_SINGLE_LEG_SQUAT               ((FIT_SQUAT_EXERCISE_NAME)34)
#define FIT_SQUAT_EXERCISE_NAME_FIGURE_FOUR_SQUATS                               ((FIT_SQUAT_EXERCISE_NAME)35)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_FIGURE_FOUR_SQUATS                      ((FIT_SQUAT_EXERCISE_NAME)36)
#define FIT_SQUAT_EXERCISE_NAME_GOBLET_SQUAT                                     ((FIT_SQUAT_EXERCISE_NAME)37)
#define FIT_SQUAT_EXERCISE_NAME_KETTLEBELL_SQUAT                                 ((FIT_SQUAT_EXERCISE_NAME)38)
#define FIT_SQUAT_EXERCISE_NAME_KETTLEBELL_SWING_OVERHEAD                        ((FIT_SQUAT_EXERCISE_NAME)39)
#define FIT_SQUAT_EXERCISE_NAME_KETTLEBELL_SWING_WITH_FLIP_TO_SQUAT              ((FIT_SQUAT_EXERCISE_NAME)40)
#define FIT_SQUAT_EXERCISE_NAME_LATERAL_DUMBBELL_STEP_UP                         ((FIT_SQUAT_EXERCISE_NAME)41)
#define FIT_SQUAT_EXERCISE_NAME_ONE_LEGGED_SQUAT                                 ((FIT_SQUAT_EXERCISE_NAME)42)
#define FIT_SQUAT_EXERCISE_NAME_OVERHEAD_DUMBBELL_SQUAT                          ((FIT_SQUAT_EXERCISE_NAME)43)
#define FIT_SQUAT_EXERCISE_NAME_OVERHEAD_SQUAT                                   ((FIT_SQUAT_EXERCISE_NAME)44)
#define FIT_SQUAT_EXERCISE_NAME_PARTIAL_SINGLE_LEG_SQUAT                         ((FIT_SQUAT_EXERCISE_NAME)45)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_PARTIAL_SINGLE_LEG_SQUAT                ((FIT_SQUAT_EXERCISE_NAME)46)
#define FIT_SQUAT_EXERCISE_NAME_PISTOL_SQUAT                                     ((FIT_SQUAT_EXERCISE_NAME)47)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_PISTOL_SQUAT                            ((FIT_SQUAT_EXERCISE_NAME)48)
#define FIT_SQUAT_EXERCISE_NAME_PLIE_SLIDES                                      ((FIT_SQUAT_EXERCISE_NAME)49)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_PLIE_SLIDES                             ((FIT_SQUAT_EXERCISE_NAME)50)
#define FIT_SQUAT_EXERCISE_NAME_PLIE_SQUAT                                       ((FIT_SQUAT_EXERCISE_NAME)51)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_PLIE_SQUAT                              ((FIT_SQUAT_EXERCISE_NAME)52)
#define FIT_SQUAT_EXERCISE_NAME_PRISONER_SQUAT                                   ((FIT_SQUAT_EXERCISE_NAME)53)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_PRISONER_SQUAT                          ((FIT_SQUAT_EXERCISE_NAME)54)
#define FIT_SQUAT_EXERCISE_NAME_SINGLE_LEG_BENCH_GET_UP                          ((FIT_SQUAT_EXERCISE_NAME)55)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_BENCH_GET_UP                 ((FIT_SQUAT_EXERCISE_NAME)56)
#define FIT_SQUAT_EXERCISE_NAME_SINGLE_LEG_BENCH_SQUAT                           ((FIT_SQUAT_EXERCISE_NAME)57)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_BENCH_SQUAT                  ((FIT_SQUAT_EXERCISE_NAME)58)
#define FIT_SQUAT_EXERCISE_NAME_SINGLE_LEG_SQUAT_ON_SWISS_BALL                   ((FIT_SQUAT_EXERCISE_NAME)59)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_SQUAT_ON_SWISS_BALL          ((FIT_SQUAT_EXERCISE_NAME)60)
#define FIT_SQUAT_EXERCISE_NAME_SQUAT                                            ((FIT_SQUAT_EXERCISE_NAME)61)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SQUAT                                   ((FIT_SQUAT_EXERCISE_NAME)62)
#define FIT_SQUAT_EXERCISE_NAME_SQUATS_WITH_BAND                                 ((FIT_SQUAT_EXERCISE_NAME)63)
#define FIT_SQUAT_EXERCISE_NAME_STAGGERED_SQUAT                                  ((FIT_SQUAT_EXERCISE_NAME)64)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_STAGGERED_SQUAT                         ((FIT_SQUAT_EXERCISE_NAME)65)
#define FIT_SQUAT_EXERCISE_NAME_STEP_UP                                          ((FIT_SQUAT_EXERCISE_NAME)66)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_STEP_UP                                 ((FIT_SQUAT_EXERCISE_NAME)67)
#define FIT_SQUAT_EXERCISE_NAME_SUITCASE_SQUATS                                  ((FIT_SQUAT_EXERCISE_NAME)68)
#define FIT_SQUAT_EXERCISE_NAME_SUMO_SQUAT                                       ((FIT_SQUAT_EXERCISE_NAME)69)
#define FIT_SQUAT_EXERCISE_NAME_SUMO_SQUAT_SLIDE_IN                              ((FIT_SQUAT_EXERCISE_NAME)70)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SUMO_SQUAT_SLIDE_IN                     ((FIT_SQUAT_EXERCISE_NAME)71)
#define FIT_SQUAT_EXERCISE_NAME_SUMO_SQUAT_TO_HIGH_PULL                          ((FIT_SQUAT_EXERCISE_NAME)72)
#define FIT_SQUAT_EXERCISE_NAME_SUMO_SQUAT_TO_STAND                              ((FIT_SQUAT_EXERCISE_NAME)73)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SUMO_SQUAT_TO_STAND                     ((FIT_SQUAT_EXERCISE_NAME)74)
#define FIT_SQUAT_EXERCISE_NAME_SUMO_SQUAT_WITH_ROTATION                         ((FIT_SQUAT_EXERCISE_NAME)75)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SUMO_SQUAT_WITH_ROTATION                ((FIT_SQUAT_EXERCISE_NAME)76)
#define FIT_SQUAT_EXERCISE_NAME_SWISS_BALL_BODY_WEIGHT_WALL_SQUAT                ((FIT_SQUAT_EXERCISE_NAME)77)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_SWISS_BALL_WALL_SQUAT                   ((FIT_SQUAT_EXERCISE_NAME)78)
#define FIT_SQUAT_EXERCISE_NAME_THRUSTERS                                        ((FIT_SQUAT_EXERCISE_NAME)79)
#define FIT_SQUAT_EXERCISE_NAME_UNEVEN_SQUAT                                     ((FIT_SQUAT_EXERCISE_NAME)80)
#define FIT_SQUAT_EXERCISE_NAME_WEIGHTED_UNEVEN_SQUAT                            ((FIT_SQUAT_EXERCISE_NAME)81)
#define FIT_SQUAT_EXERCISE_NAME_WAIST_SLIMMING_SQUAT                             ((FIT_SQUAT_EXERCISE_NAME)82)
#define FIT_SQUAT_EXERCISE_NAME_WALL_BALL                                        ((FIT_SQUAT_EXERCISE_NAME)83)
#define FIT_SQUAT_EXERCISE_NAME_WIDE_STANCE_BARBELL_SQUAT                        ((FIT_SQUAT_EXERCISE_NAME)84)
#define FIT_SQUAT_EXERCISE_NAME_WIDE_STANCE_GOBLET_SQUAT                         ((FIT_SQUAT_EXERCISE_NAME)85)
#define FIT_SQUAT_EXERCISE_NAME_ZERCHER_SQUAT                                    ((FIT_SQUAT_EXERCISE_NAME)86)
#define FIT_SQUAT_EXERCISE_NAME_KBS_OVERHEAD                                     ((FIT_SQUAT_EXERCISE_NAME)87) // Deprecated do not use
#define FIT_SQUAT_EXERCISE_NAME_SQUAT_AND_SIDE_KICK                              ((FIT_SQUAT_EXERCISE_NAME)88)
#define FIT_SQUAT_EXERCISE_NAME_SQUAT_JUMPS_IN_N_OUT                             ((FIT_SQUAT_EXERCISE_NAME)89)
#define FIT_SQUAT_EXERCISE_NAME_PILATES_PLIE_SQUATS_PARALLEL_TURNED_OUT_FLAT_AND_HEELS ((FIT_SQUAT_EXERCISE_NAME)90)
#define FIT_SQUAT_EXERCISE_NAME_RELEVE_STRAIGHT_LEG_AND_KNEE_BENT_WITH_ONE_LEG_VARIATION ((FIT_SQUAT_EXERCISE_NAME)91)
#define FIT_SQUAT_EXERCISE_NAME_COUNT                                            92

typedef FIT_UINT16 FIT_TOTAL_BODY_EXERCISE_NAME;
#define FIT_TOTAL_BODY_EXERCISE_NAME_INVALID                                     FIT_UINT16_INVALID
#define FIT_TOTAL_BODY_EXERCISE_NAME_BURPEE                                      ((FIT_TOTAL_BODY_EXERCISE_NAME)0)
#define FIT_TOTAL_BODY_EXERCISE_NAME_WEIGHTED_BURPEE                             ((FIT_TOTAL_BODY_EXERCISE_NAME)1)
#define FIT_TOTAL_BODY_EXERCISE_NAME_BURPEE_BOX_JUMP                             ((FIT_TOTAL_BODY_EXERCISE_NAME)2)
#define FIT_TOTAL_BODY_EXERCISE_NAME_WEIGHTED_BURPEE_BOX_JUMP                    ((FIT_TOTAL_BODY_EXERCISE_NAME)3)
#define FIT_TOTAL_BODY_EXERCISE_NAME_HIGH_PULL_BURPEE                            ((FIT_TOTAL_BODY_EXERCISE_NAME)4)
#define FIT_TOTAL_BODY_EXERCISE_NAME_MAN_MAKERS                                  ((FIT_TOTAL_BODY_EXERCISE_NAME)5)
#define FIT_TOTAL_BODY_EXERCISE_NAME_ONE_ARM_BURPEE                              ((FIT_TOTAL_BODY_EXERCISE_NAME)6)
#define FIT_TOTAL_BODY_EXERCISE_NAME_SQUAT_THRUSTS                               ((FIT_TOTAL_BODY_EXERCISE_NAME)7)
#define FIT_TOTAL_BODY_EXERCISE_NAME_WEIGHTED_SQUAT_THRUSTS                      ((FIT_TOTAL_BODY_EXERCISE_NAME)8)
#define FIT_TOTAL_BODY_EXERCISE_NAME_SQUAT_PLANK_PUSH_UP                         ((FIT_TOTAL_BODY_EXERCISE_NAME)9)
#define FIT_TOTAL_BODY_EXERCISE_NAME_WEIGHTED_SQUAT_PLANK_PUSH_UP                ((FIT_TOTAL_BODY_EXERCISE_NAME)10)
#define FIT_TOTAL_BODY_EXERCISE_NAME_STANDING_T_ROTATION_BALANCE                 ((FIT_TOTAL_BODY_EXERCISE_NAME)11)
#define FIT_TOTAL_BODY_EXERCISE_NAME_WEIGHTED_STANDING_T_ROTATION_BALANCE        ((FIT_TOTAL_BODY_EXERCISE_NAME)12)
#define FIT_TOTAL_BODY_EXERCISE_NAME_COUNT                                       13

typedef FIT_UINT16 FIT_TRICEPS_EXTENSION_EXERCISE_NAME;
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_INVALID                              FIT_UINT16_INVALID
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_BENCH_DIP                            ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)0)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_BENCH_DIP                   ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)1)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_BODY_WEIGHT_DIP                      ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)2)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_CABLE_KICKBACK                       ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)3)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_CABLE_LYING_TRICEPS_EXTENSION        ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)4)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_CABLE_OVERHEAD_TRICEPS_EXTENSION     ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)5)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_DUMBBELL_KICKBACK                    ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)6)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_DUMBBELL_LYING_TRICEPS_EXTENSION     ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)7)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_EZ_BAR_OVERHEAD_TRICEPS_EXTENSION    ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)8)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_INCLINE_DIP                          ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)9)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_INCLINE_DIP                 ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)10)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_INCLINE_EZ_BAR_LYING_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)11)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_LYING_DUMBBELL_PULLOVER_TO_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)12)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_LYING_EZ_BAR_TRICEPS_EXTENSION       ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)13)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_LYING_TRICEPS_EXTENSION_TO_CLOSE_GRIP_BENCH_PRESS ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)14)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_OVERHEAD_DUMBBELL_TRICEPS_EXTENSION  ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)15)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_RECLINING_TRICEPS_PRESS              ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)16)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_REVERSE_GRIP_PRESSDOWN               ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)17)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_REVERSE_GRIP_TRICEPS_PRESSDOWN       ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)18)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_ROPE_PRESSDOWN                       ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)19)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SEATED_BARBELL_OVERHEAD_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)20)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SEATED_DUMBBELL_OVERHEAD_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)21)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SEATED_EZ_BAR_OVERHEAD_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)22)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SEATED_SINGLE_ARM_OVERHEAD_DUMBBELL_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)23)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SINGLE_ARM_DUMBBELL_OVERHEAD_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)24)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SINGLE_DUMBBELL_SEATED_OVERHEAD_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)25)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SINGLE_LEG_BENCH_DIP_AND_KICK        ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)26)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_BENCH_DIP_AND_KICK ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)27)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SINGLE_LEG_DIP                       ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)28)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_SINGLE_LEG_DIP              ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)29)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_STATIC_LYING_TRICEPS_EXTENSION       ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)30)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SUSPENDED_DIP                        ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)31)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_SUSPENDED_DIP               ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)32)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SWISS_BALL_DUMBBELL_LYING_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)33)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SWISS_BALL_EZ_BAR_LYING_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)34)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_SWISS_BALL_EZ_BAR_OVERHEAD_TRICEPS_EXTENSION ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)35)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_TABLETOP_DIP                         ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)36)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_TABLETOP_DIP                ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)37)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_TRICEPS_EXTENSION_ON_FLOOR           ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)38)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_TRICEPS_PRESSDOWN                    ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)39)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_WEIGHTED_DIP                         ((FIT_TRICEPS_EXTENSION_EXERCISE_NAME)40)
#define FIT_TRICEPS_EXTENSION_EXERCISE_NAME_COUNT                                41

typedef FIT_UINT16 FIT_WARM_UP_EXERCISE_NAME;
#define FIT_WARM_UP_EXERCISE_NAME_INVALID                                        FIT_UINT16_INVALID
#define FIT_WARM_UP_EXERCISE_NAME_QUADRUPED_ROCKING                              ((FIT_WARM_UP_EXERCISE_NAME)0)
#define FIT_WARM_UP_EXERCISE_NAME_NECK_TILTS                                     ((FIT_WARM_UP_EXERCISE_NAME)1)
#define FIT_WARM_UP_EXERCISE_NAME_ANKLE_CIRCLES                                  ((FIT_WARM_UP_EXERCISE_NAME)2)
#define FIT_WARM_UP_EXERCISE_NAME_ANKLE_DORSIFLEXION_WITH_BAND                   ((FIT_WARM_UP_EXERCISE_NAME)3)
#define FIT_WARM_UP_EXERCISE_NAME_ANKLE_INTERNAL_ROTATION                        ((FIT_WARM_UP_EXERCISE_NAME)4)
#define FIT_WARM_UP_EXERCISE_NAME_ARM_CIRCLES                                    ((FIT_WARM_UP_EXERCISE_NAME)5)
#define FIT_WARM_UP_EXERCISE_NAME_BENT_OVER_REACH_TO_SKY                         ((FIT_WARM_UP_EXERCISE_NAME)6)
#define FIT_WARM_UP_EXERCISE_NAME_CAT_CAMEL                                      ((FIT_WARM_UP_EXERCISE_NAME)7)
#define FIT_WARM_UP_EXERCISE_NAME_ELBOW_TO_FOOT_LUNGE                            ((FIT_WARM_UP_EXERCISE_NAME)8)
#define FIT_WARM_UP_EXERCISE_NAME_FORWARD_AND_BACKWARD_LEG_SWINGS                ((FIT_WARM_UP_EXERCISE_NAME)9)
#define FIT_WARM_UP_EXERCISE_NAME_GROINERS                                       ((FIT_WARM_UP_EXERCISE_NAME)10)
#define FIT_WARM_UP_EXERCISE_NAME_INVERTED_HAMSTRING_STRETCH                     ((FIT_WARM_UP_EXERCISE_NAME)11)
#define FIT_WARM_UP_EXERCISE_NAME_LATERAL_DUCK_UNDER                             ((FIT_WARM_UP_EXERCISE_NAME)12)
#define FIT_WARM_UP_EXERCISE_NAME_NECK_ROTATIONS                                 ((FIT_WARM_UP_EXERCISE_NAME)13)
#define FIT_WARM_UP_EXERCISE_NAME_OPPOSITE_ARM_AND_LEG_BALANCE                   ((FIT_WARM_UP_EXERCISE_NAME)14)
#define FIT_WARM_UP_EXERCISE_NAME_REACH_ROLL_AND_LIFT                            ((FIT_WARM_UP_EXERCISE_NAME)15)
#define FIT_WARM_UP_EXERCISE_NAME_SCORPION                                       ((FIT_WARM_UP_EXERCISE_NAME)16) // Deprecated do not use
#define FIT_WARM_UP_EXERCISE_NAME_SHOULDER_CIRCLES                               ((FIT_WARM_UP_EXERCISE_NAME)17)
#define FIT_WARM_UP_EXERCISE_NAME_SIDE_TO_SIDE_LEG_SWINGS                        ((FIT_WARM_UP_EXERCISE_NAME)18)
#define FIT_WARM_UP_EXERCISE_NAME_SLEEPER_STRETCH                                ((FIT_WARM_UP_EXERCISE_NAME)19)
#define FIT_WARM_UP_EXERCISE_NAME_SLIDE_OUT                                      ((FIT_WARM_UP_EXERCISE_NAME)20)
#define FIT_WARM_UP_EXERCISE_NAME_SWISS_BALL_HIP_CROSSOVER                       ((FIT_WARM_UP_EXERCISE_NAME)21)
#define FIT_WARM_UP_EXERCISE_NAME_SWISS_BALL_REACH_ROLL_AND_LIFT                 ((FIT_WARM_UP_EXERCISE_NAME)22)
#define FIT_WARM_UP_EXERCISE_NAME_SWISS_BALL_WINDSHIELD_WIPERS                   ((FIT_WARM_UP_EXERCISE_NAME)23)
#define FIT_WARM_UP_EXERCISE_NAME_THORACIC_ROTATION                              ((FIT_WARM_UP_EXERCISE_NAME)24)
#define FIT_WARM_UP_EXERCISE_NAME_WALKING_HIGH_KICKS                             ((FIT_WARM_UP_EXERCISE_NAME)25)
#define FIT_WARM_UP_EXERCISE_NAME_WALKING_HIGH_KNEES                             ((FIT_WARM_UP_EXERCISE_NAME)26)
#define FIT_WARM_UP_EXERCISE_NAME_WALKING_KNEE_HUGS                              ((FIT_WARM_UP_EXERCISE_NAME)27)
#define FIT_WARM_UP_EXERCISE_NAME_WALKING_LEG_CRADLES                            ((FIT_WARM_UP_EXERCISE_NAME)28)
#define FIT_WARM_UP_EXERCISE_NAME_WALKOUT                                        ((FIT_WARM_UP_EXERCISE_NAME)29)
#define FIT_WARM_UP_EXERCISE_NAME_WALKOUT_FROM_PUSH_UP_POSITION                  ((FIT_WARM_UP_EXERCISE_NAME)30)
#define FIT_WARM_UP_EXERCISE_NAME_COUNT                                          31

typedef FIT_UINT16 FIT_RUN_EXERCISE_NAME;
#define FIT_RUN_EXERCISE_NAME_INVALID                                            FIT_UINT16_INVALID
#define FIT_RUN_EXERCISE_NAME_RUN                                                ((FIT_RUN_EXERCISE_NAME)0)
#define FIT_RUN_EXERCISE_NAME_WALK                                               ((FIT_RUN_EXERCISE_NAME)1)
#define FIT_RUN_EXERCISE_NAME_JOG                                                ((FIT_RUN_EXERCISE_NAME)2)
#define FIT_RUN_EXERCISE_NAME_SPRINT                                             ((FIT_RUN_EXERCISE_NAME)3)
#define FIT_RUN_EXERCISE_NAME_COUNT                                              4

typedef FIT_ENUM FIT_WATER_TYPE;
#define FIT_WATER_TYPE_INVALID                                                   FIT_ENUM_INVALID
#define FIT_WATER_TYPE_FRESH                                                     ((FIT_WATER_TYPE)0)
#define FIT_WATER_TYPE_SALT                                                      ((FIT_WATER_TYPE)1)
#define FIT_WATER_TYPE_EN13319                                                   ((FIT_WATER_TYPE)2)
#define FIT_WATER_TYPE_CUSTOM                                                    ((FIT_WATER_TYPE)3)
#define FIT_WATER_TYPE_COUNT                                                     4

typedef FIT_ENUM FIT_TISSUE_MODEL_TYPE;
#define FIT_TISSUE_MODEL_TYPE_INVALID                                            FIT_ENUM_INVALID
#define FIT_TISSUE_MODEL_TYPE_ZHL_16C                                            ((FIT_TISSUE_MODEL_TYPE)0) // Buhlmann's decompression algorithm, version C
#define FIT_TISSUE_MODEL_TYPE_COUNT                                              1

typedef FIT_ENUM FIT_DIVE_GAS_STATUS;
#define FIT_DIVE_GAS_STATUS_INVALID                                              FIT_ENUM_INVALID
#define FIT_DIVE_GAS_STATUS_DISABLED                                             ((FIT_DIVE_GAS_STATUS)0)
#define FIT_DIVE_GAS_STATUS_ENABLED                                              ((FIT_DIVE_GAS_STATUS)1)
#define FIT_DIVE_GAS_STATUS_BACKUP_ONLY                                          ((FIT_DIVE_GAS_STATUS)2)
#define FIT_DIVE_GAS_STATUS_COUNT                                                3

typedef FIT_ENUM FIT_DIVE_ALERT;
#define FIT_DIVE_ALERT_INVALID                                                   FIT_ENUM_INVALID
#define FIT_DIVE_ALERT_NDL_REACHED                                               ((FIT_DIVE_ALERT)0)
#define FIT_DIVE_ALERT_GAS_SWITCH_PROMPTED                                       ((FIT_DIVE_ALERT)1)
#define FIT_DIVE_ALERT_NEAR_SURFACE                                              ((FIT_DIVE_ALERT)2)
#define FIT_DIVE_ALERT_APPROACHING_NDL                                           ((FIT_DIVE_ALERT)3)
#define FIT_DIVE_ALERT_PO2_WARN                                                  ((FIT_DIVE_ALERT)4)
#define FIT_DIVE_ALERT_PO2_CRIT_HIGH                                             ((FIT_DIVE_ALERT)5)
#define FIT_DIVE_ALERT_PO2_CRIT_LOW                                              ((FIT_DIVE_ALERT)6)
#define FIT_DIVE_ALERT_TIME_ALERT                                                ((FIT_DIVE_ALERT)7)
#define FIT_DIVE_ALERT_DEPTH_ALERT                                               ((FIT_DIVE_ALERT)8)
#define FIT_DIVE_ALERT_DECO_CEILING_BROKEN                                       ((FIT_DIVE_ALERT)9)
#define FIT_DIVE_ALERT_DECO_COMPLETE                                             ((FIT_DIVE_ALERT)10)
#define FIT_DIVE_ALERT_SAFETY_STOP_BROKEN                                        ((FIT_DIVE_ALERT)11)
#define FIT_DIVE_ALERT_SAFETY_STOP_COMPLETE                                      ((FIT_DIVE_ALERT)12)
#define FIT_DIVE_ALERT_CNS_WARNING                                               ((FIT_DIVE_ALERT)13)
#define FIT_DIVE_ALERT_CNS_CRITICAL                                              ((FIT_DIVE_ALERT)14)
#define FIT_DIVE_ALERT_OTU_WARNING                                               ((FIT_DIVE_ALERT)15)
#define FIT_DIVE_ALERT_OTU_CRITICAL                                              ((FIT_DIVE_ALERT)16)
#define FIT_DIVE_ALERT_ASCENT_CRITICAL                                           ((FIT_DIVE_ALERT)17)
#define FIT_DIVE_ALERT_ALERT_DISMISSED_BY_KEY                                    ((FIT_DIVE_ALERT)18)
#define FIT_DIVE_ALERT_ALERT_DISMISSED_BY_TIMEOUT                                ((FIT_DIVE_ALERT)19)
#define FIT_DIVE_ALERT_BATTERY_LOW                                               ((FIT_DIVE_ALERT)20)
#define FIT_DIVE_ALERT_BATTERY_CRITICAL                                          ((FIT_DIVE_ALERT)21)
#define FIT_DIVE_ALERT_SAFETY_STOP_STARTED                                       ((FIT_DIVE_ALERT)22)
#define FIT_DIVE_ALERT_APPROACHING_FIRST_DECO_STOP                               ((FIT_DIVE_ALERT)23)
#define FIT_DIVE_ALERT_SETPOINT_SWITCH_AUTO_LOW                                  ((FIT_DIVE_ALERT)24)
#define FIT_DIVE_ALERT_SETPOINT_SWITCH_AUTO_HIGH                                 ((FIT_DIVE_ALERT)25)
#define FIT_DIVE_ALERT_SETPOINT_SWITCH_MANUAL_LOW                                ((FIT_DIVE_ALERT)26)
#define FIT_DIVE_ALERT_SETPOINT_SWITCH_MANUAL_HIGH                               ((FIT_DIVE_ALERT)27)
#define FIT_DIVE_ALERT_AUTO_SETPOINT_SWITCH_IGNORED                              ((FIT_DIVE_ALERT)28)
#define FIT_DIVE_ALERT_SWITCHED_TO_OPEN_CIRCUIT                                  ((FIT_DIVE_ALERT)29)
#define FIT_DIVE_ALERT_SWITCHED_TO_CLOSED_CIRCUIT                                ((FIT_DIVE_ALERT)30)
#define FIT_DIVE_ALERT_TANK_BATTERY_LOW                                          ((FIT_DIVE_ALERT)32)
#define FIT_DIVE_ALERT_PO2_CCR_DIL_LOW                                           ((FIT_DIVE_ALERT)33) // ccr diluent has low po2
#define FIT_DIVE_ALERT_DECO_STOP_CLEARED                                         ((FIT_DIVE_ALERT)34) // a deco stop has been cleared
#define FIT_DIVE_ALERT_APNEA_NEUTRAL_BUOYANCY                                    ((FIT_DIVE_ALERT)35) // Target Depth Apnea Alarm triggered
#define FIT_DIVE_ALERT_APNEA_TARGET_DEPTH                                        ((FIT_DIVE_ALERT)36) // Neutral Buoyance Apnea Alarm triggered
#define FIT_DIVE_ALERT_APNEA_SURFACE                                             ((FIT_DIVE_ALERT)37) // Surface Apnea Alarm triggered
#define FIT_DIVE_ALERT_APNEA_HIGH_SPEED                                          ((FIT_DIVE_ALERT)38) // High Speed Apnea Alarm triggered
#define FIT_DIVE_ALERT_APNEA_LOW_SPEED                                           ((FIT_DIVE_ALERT)39) // Low Speed Apnea Alarm triggered
#define FIT_DIVE_ALERT_COUNT                                                     39

typedef FIT_ENUM FIT_DIVE_ALARM_TYPE;
#define FIT_DIVE_ALARM_TYPE_INVALID                                              FIT_ENUM_INVALID
#define FIT_DIVE_ALARM_TYPE_DEPTH                                                ((FIT_DIVE_ALARM_TYPE)0) // Alarm when a certain depth is crossed
#define FIT_DIVE_ALARM_TYPE_TIME                                                 ((FIT_DIVE_ALARM_TYPE)1) // Alarm when a certain time has transpired
#define FIT_DIVE_ALARM_TYPE_SPEED                                                ((FIT_DIVE_ALARM_TYPE)2) // Alarm when a certain ascent or descent rate is exceeded
#define FIT_DIVE_ALARM_TYPE_COUNT                                                3

typedef FIT_ENUM FIT_DIVE_BACKLIGHT_MODE;
#define FIT_DIVE_BACKLIGHT_MODE_INVALID                                          FIT_ENUM_INVALID
#define FIT_DIVE_BACKLIGHT_MODE_AT_DEPTH                                         ((FIT_DIVE_BACKLIGHT_MODE)0)
#define FIT_DIVE_BACKLIGHT_MODE_ALWAYS_ON                                        ((FIT_DIVE_BACKLIGHT_MODE)1)
#define FIT_DIVE_BACKLIGHT_MODE_COUNT                                            2

typedef FIT_ENUM FIT_SLEEP_LEVEL;
#define FIT_SLEEP_LEVEL_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SLEEP_LEVEL_UNMEASURABLE                                             ((FIT_SLEEP_LEVEL)0)
#define FIT_SLEEP_LEVEL_AWAKE                                                    ((FIT_SLEEP_LEVEL)1)
#define FIT_SLEEP_LEVEL_LIGHT                                                    ((FIT_SLEEP_LEVEL)2)
#define FIT_SLEEP_LEVEL_DEEP                                                     ((FIT_SLEEP_LEVEL)3)
#define FIT_SLEEP_LEVEL_REM                                                      ((FIT_SLEEP_LEVEL)4)
#define FIT_SLEEP_LEVEL_COUNT                                                    5

typedef FIT_ENUM FIT_SPO2_MEASUREMENT_TYPE;
#define FIT_SPO2_MEASUREMENT_TYPE_INVALID                                        FIT_ENUM_INVALID
#define FIT_SPO2_MEASUREMENT_TYPE_OFF_WRIST                                      ((FIT_SPO2_MEASUREMENT_TYPE)0)
#define FIT_SPO2_MEASUREMENT_TYPE_SPOT_CHECK                                     ((FIT_SPO2_MEASUREMENT_TYPE)1)
#define FIT_SPO2_MEASUREMENT_TYPE_CONTINUOUS_CHECK                               ((FIT_SPO2_MEASUREMENT_TYPE)2)
#define FIT_SPO2_MEASUREMENT_TYPE_PERIODIC                                       ((FIT_SPO2_MEASUREMENT_TYPE)3)
#define FIT_SPO2_MEASUREMENT_TYPE_COUNT                                          4

typedef FIT_ENUM FIT_CCR_SETPOINT_SWITCH_MODE;
#define FIT_CCR_SETPOINT_SWITCH_MODE_INVALID                                     FIT_ENUM_INVALID
#define FIT_CCR_SETPOINT_SWITCH_MODE_MANUAL                                      ((FIT_CCR_SETPOINT_SWITCH_MODE)0) // User switches setpoints manually
#define FIT_CCR_SETPOINT_SWITCH_MODE_AUTOMATIC                                   ((FIT_CCR_SETPOINT_SWITCH_MODE)1) // Switch automatically based on depth
#define FIT_CCR_SETPOINT_SWITCH_MODE_COUNT                                       2

typedef FIT_ENUM FIT_DIVE_GAS_MODE;
#define FIT_DIVE_GAS_MODE_INVALID                                                FIT_ENUM_INVALID
#define FIT_DIVE_GAS_MODE_OPEN_CIRCUIT                                           ((FIT_DIVE_GAS_MODE)0)
#define FIT_DIVE_GAS_MODE_CLOSED_CIRCUIT_DILUENT                                 ((FIT_DIVE_GAS_MODE)1)
#define FIT_DIVE_GAS_MODE_COUNT                                                  2

typedef FIT_ENUM FIT_PROJECTILE_TYPE;
#define FIT_PROJECTILE_TYPE_INVALID                                              FIT_ENUM_INVALID
#define FIT_PROJECTILE_TYPE_ARROW                                                ((FIT_PROJECTILE_TYPE)0) // Arrow projectile type
#define FIT_PROJECTILE_TYPE_RIFLE_CARTRIDGE                                      ((FIT_PROJECTILE_TYPE)1) // Rifle cartridge projectile type
#define FIT_PROJECTILE_TYPE_PISTOL_CARTRIDGE                                     ((FIT_PROJECTILE_TYPE)2) // Pistol cartridge projectile type
#define FIT_PROJECTILE_TYPE_SHOTSHELL                                            ((FIT_PROJECTILE_TYPE)3) // Shotshell projectile type
#define FIT_PROJECTILE_TYPE_AIR_RIFLE_PELLET                                     ((FIT_PROJECTILE_TYPE)4) // Air rifle pellet projectile type
#define FIT_PROJECTILE_TYPE_OTHER                                                ((FIT_PROJECTILE_TYPE)5) // Other projectile type
#define FIT_PROJECTILE_TYPE_COUNT                                                6

typedef FIT_UINT16 FIT_FAVERO_PRODUCT;
#define FIT_FAVERO_PRODUCT_INVALID                                               FIT_UINT16_INVALID
#define FIT_FAVERO_PRODUCT_ASSIOMA_UNO                                           ((FIT_FAVERO_PRODUCT)10)
#define FIT_FAVERO_PRODUCT_ASSIOMA_DUO                                           ((FIT_FAVERO_PRODUCT)12)
#define FIT_FAVERO_PRODUCT_COUNT                                                 2

typedef FIT_ENUM FIT_SPLIT_TYPE;
#define FIT_SPLIT_TYPE_INVALID                                                   FIT_ENUM_INVALID
#define FIT_SPLIT_TYPE_ASCENT_SPLIT                                              ((FIT_SPLIT_TYPE)1)
#define FIT_SPLIT_TYPE_DESCENT_SPLIT                                             ((FIT_SPLIT_TYPE)2)
#define FIT_SPLIT_TYPE_INTERVAL_ACTIVE                                           ((FIT_SPLIT_TYPE)3)
#define FIT_SPLIT_TYPE_INTERVAL_REST                                             ((FIT_SPLIT_TYPE)4)
#define FIT_SPLIT_TYPE_INTERVAL_WARMUP                                           ((FIT_SPLIT_TYPE)5)
#define FIT_SPLIT_TYPE_INTERVAL_COOLDOWN                                         ((FIT_SPLIT_TYPE)6)
#define FIT_SPLIT_TYPE_INTERVAL_RECOVERY                                         ((FIT_SPLIT_TYPE)7)
#define FIT_SPLIT_TYPE_INTERVAL_OTHER                                            ((FIT_SPLIT_TYPE)8)
#define FIT_SPLIT_TYPE_CLIMB_ACTIVE                                              ((FIT_SPLIT_TYPE)9)
#define FIT_SPLIT_TYPE_CLIMB_REST                                                ((FIT_SPLIT_TYPE)10)
#define FIT_SPLIT_TYPE_SURF_ACTIVE                                               ((FIT_SPLIT_TYPE)11)
#define FIT_SPLIT_TYPE_RUN_ACTIVE                                                ((FIT_SPLIT_TYPE)12)
#define FIT_SPLIT_TYPE_RUN_REST                                                  ((FIT_SPLIT_TYPE)13)
#define FIT_SPLIT_TYPE_WORKOUT_ROUND                                             ((FIT_SPLIT_TYPE)14)
#define FIT_SPLIT_TYPE_RWD_RUN                                                   ((FIT_SPLIT_TYPE)17) // run/walk detection running
#define FIT_SPLIT_TYPE_RWD_WALK                                                  ((FIT_SPLIT_TYPE)18) // run/walk detection walking
#define FIT_SPLIT_TYPE_WINDSURF_ACTIVE                                           ((FIT_SPLIT_TYPE)21)
#define FIT_SPLIT_TYPE_RWD_STAND                                                 ((FIT_SPLIT_TYPE)22) // run/walk detection standing
#define FIT_SPLIT_TYPE_TRANSITION                                                ((FIT_SPLIT_TYPE)23) // Marks the time going from ascent_split to descent_split/used in backcountry ski
#define FIT_SPLIT_TYPE_SKI_LIFT_SPLIT                                            ((FIT_SPLIT_TYPE)28)
#define FIT_SPLIT_TYPE_SKI_RUN_SPLIT                                             ((FIT_SPLIT_TYPE)29)
#define FIT_SPLIT_TYPE_COUNT                                                     21

typedef FIT_ENUM FIT_CLIMB_PRO_EVENT;
#define FIT_CLIMB_PRO_EVENT_INVALID                                              FIT_ENUM_INVALID
#define FIT_CLIMB_PRO_EVENT_APPROACH                                             ((FIT_CLIMB_PRO_EVENT)0)
#define FIT_CLIMB_PRO_EVENT_START                                                ((FIT_CLIMB_PRO_EVENT)1)
#define FIT_CLIMB_PRO_EVENT_COMPLETE                                             ((FIT_CLIMB_PRO_EVENT)2)
#define FIT_CLIMB_PRO_EVENT_COUNT                                                3

typedef FIT_ENUM FIT_GAS_CONSUMPTION_RATE_TYPE;
#define FIT_GAS_CONSUMPTION_RATE_TYPE_INVALID                                    FIT_ENUM_INVALID
#define FIT_GAS_CONSUMPTION_RATE_TYPE_PRESSURE_SAC                               ((FIT_GAS_CONSUMPTION_RATE_TYPE)0) // Pressure-based Surface Air Consumption
#define FIT_GAS_CONSUMPTION_RATE_TYPE_VOLUME_SAC                                 ((FIT_GAS_CONSUMPTION_RATE_TYPE)1) // Volumetric Surface Air Consumption
#define FIT_GAS_CONSUMPTION_RATE_TYPE_RMV                                        ((FIT_GAS_CONSUMPTION_RATE_TYPE)2) // Respiratory Minute Volume
#define FIT_GAS_CONSUMPTION_RATE_TYPE_COUNT                                      3

typedef FIT_ENUM FIT_TAP_SENSITIVITY;
#define FIT_TAP_SENSITIVITY_INVALID                                              FIT_ENUM_INVALID
#define FIT_TAP_SENSITIVITY_HIGH                                                 ((FIT_TAP_SENSITIVITY)0)
#define FIT_TAP_SENSITIVITY_MEDIUM                                               ((FIT_TAP_SENSITIVITY)1)
#define FIT_TAP_SENSITIVITY_LOW                                                  ((FIT_TAP_SENSITIVITY)2)
#define FIT_TAP_SENSITIVITY_COUNT                                                3

typedef FIT_ENUM FIT_RADAR_THREAT_LEVEL_TYPE;
#define FIT_RADAR_THREAT_LEVEL_TYPE_INVALID                                      FIT_ENUM_INVALID
#define FIT_RADAR_THREAT_LEVEL_TYPE_THREAT_UNKNOWN                               ((FIT_RADAR_THREAT_LEVEL_TYPE)0)
#define FIT_RADAR_THREAT_LEVEL_TYPE_THREAT_NONE                                  ((FIT_RADAR_THREAT_LEVEL_TYPE)1)
#define FIT_RADAR_THREAT_LEVEL_TYPE_THREAT_APPROACHING                           ((FIT_RADAR_THREAT_LEVEL_TYPE)2)
#define FIT_RADAR_THREAT_LEVEL_TYPE_THREAT_APPROACHING_FAST                      ((FIT_RADAR_THREAT_LEVEL_TYPE)3)
#define FIT_RADAR_THREAT_LEVEL_TYPE_COUNT                                        4

typedef FIT_ENUM FIT_MAX_MET_SPEED_SOURCE;
#define FIT_MAX_MET_SPEED_SOURCE_INVALID                                         FIT_ENUM_INVALID
#define FIT_MAX_MET_SPEED_SOURCE_ONBOARD_GPS                                     ((FIT_MAX_MET_SPEED_SOURCE)0)
#define FIT_MAX_MET_SPEED_SOURCE_CONNECTED_GPS                                   ((FIT_MAX_MET_SPEED_SOURCE)1)
#define FIT_MAX_MET_SPEED_SOURCE_CADENCE                                         ((FIT_MAX_MET_SPEED_SOURCE)2)
#define FIT_MAX_MET_SPEED_SOURCE_COUNT                                           3

typedef FIT_ENUM FIT_MAX_MET_HEART_RATE_SOURCE;
#define FIT_MAX_MET_HEART_RATE_SOURCE_INVALID                                    FIT_ENUM_INVALID
#define FIT_MAX_MET_HEART_RATE_SOURCE_WHR                                        ((FIT_MAX_MET_HEART_RATE_SOURCE)0) // Wrist Heart Rate Monitor
#define FIT_MAX_MET_HEART_RATE_SOURCE_HRM                                        ((FIT_MAX_MET_HEART_RATE_SOURCE)1) // Chest Strap Heart Rate Monitor
#define FIT_MAX_MET_HEART_RATE_SOURCE_COUNT                                      2

typedef FIT_ENUM FIT_HRV_STATUS;
#define FIT_HRV_STATUS_INVALID                                                   FIT_ENUM_INVALID
#define FIT_HRV_STATUS_NONE                                                      ((FIT_HRV_STATUS)0)
#define FIT_HRV_STATUS_POOR                                                      ((FIT_HRV_STATUS)1)
#define FIT_HRV_STATUS_LOW                                                       ((FIT_HRV_STATUS)2)
#define FIT_HRV_STATUS_UNBALANCED                                                ((FIT_HRV_STATUS)3)
#define FIT_HRV_STATUS_BALANCED                                                  ((FIT_HRV_STATUS)4)
#define FIT_HRV_STATUS_COUNT                                                     5

typedef FIT_ENUM FIT_NO_FLY_TIME_MODE;
#define FIT_NO_FLY_TIME_MODE_INVALID                                             FIT_ENUM_INVALID
#define FIT_NO_FLY_TIME_MODE_STANDARD                                            ((FIT_NO_FLY_TIME_MODE)0) // Standard Diver Alert Network no-fly guidance
#define FIT_NO_FLY_TIME_MODE_FLAT_24_HOURS                                       ((FIT_NO_FLY_TIME_MODE)1) // Flat 24 hour no-fly guidance
#define FIT_NO_FLY_TIME_MODE_COUNT                                               2


#endif // !defined(FIT_CPP_INCLUDE_C)

///////////////////////////////////////////////////////////////////////
// Miscellaneous
///////////////////////////////////////////////////////////////////////

#define FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD                                       (FIT_UINT16_INVALID - 1)
#define FIT_SUBFIELD_INDEX_MAIN_FIELD                                            (FIT_UINT16_INVALID)


namespace fit
{

class Profile
{
public:
    enum class Type
    {
        Enum,
        Sint8,
        Uint8,
        Sint16,
        Uint16,
        Sint32,
        Uint32,
        String,
        Float32,
        Float64,
        Uint8z,
        Uint16z,
        Uint32z,
        Byte,
        Sint64,
        Uint64,
        Uint64z,
        Bool,
        File,
        MesgNum,
        Checksum,
        FileFlags,
        MesgCount,
        DateTime,
        LocalDateTime,
        MessageIndex,
        DeviceIndex,
        Gender,
        Language,
        LanguageBits0,
        LanguageBits1,
        LanguageBits2,
        LanguageBits3,
        LanguageBits4,
        TimeZone,
        DisplayMeasure,
        DisplayHeart,
        DisplayPower,
        DisplayPosition,
        Switch,
        Sport,
        SportBits0,
        SportBits1,
        SportBits2,
        SportBits3,
        SportBits4,
        SportBits5,
        SportBits6,
        SubSport,
        SportEvent,
        Activity,
        Intensity,
        SessionTrigger,
        AutolapTrigger,
        LapTrigger,
        TimeMode,
        BacklightMode,
        DateMode,
        BacklightTimeout,
        Event,
        EventType,
        TimerTrigger,
        FitnessEquipmentState,
        Tone,
        Autoscroll,
        ActivityClass,
        HrZoneCalc,
        PwrZoneCalc,
        WktStepDuration,
        WktStepTarget,
        Goal,
        GoalRecurrence,
        GoalSource,
        Schedule,
        CoursePoint,
        Manufacturer,
        GarminProduct,
        AntplusDeviceType,
        AntNetwork,
        WorkoutCapabilities,
        BatteryStatus,
        HrType,
        CourseCapabilities,
        Weight,
        WorkoutHr,
        WorkoutPower,
        BpStatus,
        UserLocalId,
        SwimStroke,
        ActivityType,
        ActivitySubtype,
        ActivityLevel,
        Side,
        LeftRightBalance,
        LeftRightBalance100,
        LengthType,
        DayOfWeek,
        ConnectivityCapabilities,
        WeatherReport,
        WeatherStatus,
        WeatherSeverity,
        WeatherSevereType,
        TimeIntoDay,
        LocaltimeIntoDay,
        StrokeType,
        BodyLocation,
        SegmentLapStatus,
        SegmentLeaderboardType,
        SegmentDeleteStatus,
        SegmentSelectionType,
        SourceType,
        LocalDeviceType,
        BleDeviceType,
        AntChannelId,
        DisplayOrientation,
        WorkoutEquipment,
        WatchfaceMode,
        DigitalWatchfaceLayout,
        AnalogWatchfaceLayout,
        RiderPositionType,
        PowerPhaseType,
        CameraEventType,
        SensorType,
        BikeLightNetworkConfigType,
        CommTimeoutType,
        CameraOrientationType,
        AttitudeStage,
        AttitudeValidity,
        AutoSyncFrequency,
        ExdLayout,
        ExdDisplayType,
        ExdDataUnits,
        ExdQualifiers,
        ExdDescriptors,
        AutoActivityDetect,
        SupportedExdScreenLayouts,
        FitBaseType,
        TurnType,
        BikeLightBeamAngleMode,
        FitBaseUnit,
        SetType,
        MaxMetCategory,
        ExerciseCategory,
        BenchPressExerciseName,
        CalfRaiseExerciseName,
        CardioExerciseName,
        CarryExerciseName,
        ChopExerciseName,
        CoreExerciseName,
        CrunchExerciseName,
        CurlExerciseName,
        DeadliftExerciseName,
        FlyeExerciseName,
        HipRaiseExerciseName,
        HipStabilityExerciseName,
        HipSwingExerciseName,
        HyperextensionExerciseName,
        LateralRaiseExerciseName,
        LegCurlExerciseName,
        LegRaiseExerciseName,
        LungeExerciseName,
        OlympicLiftExerciseName,
        PlankExerciseName,
        PlyoExerciseName,
        PullUpExerciseName,
        PushUpExerciseName,
        RowExerciseName,
        ShoulderPressExerciseName,
        ShoulderStabilityExerciseName,
        ShrugExerciseName,
        SitUpExerciseName,
        SquatExerciseName,
        TotalBodyExerciseName,
        TricepsExtensionExerciseName,
        WarmUpExerciseName,
        RunExerciseName,
        WaterType,
        TissueModelType,
        DiveGasStatus,
        DiveAlert,
        DiveAlarmType,
        DiveBacklightMode,
        SleepLevel,
        Spo2MeasurementType,
        CcrSetpointSwitchMode,
        DiveGasMode,
        ProjectileType,
        FaveroProduct,
        SplitType,
        ClimbProEvent,
        GasConsumptionRateType,
        TapSensitivity,
        RadarThreatLevelType,
        MaxMetSpeedSource,
        MaxMetHeartRateSource,
        HrvStatus,
        NoFlyTimeMode,
        Invalid
    };

    typedef enum
    {
        MESG_FILE_ID,
        MESG_FILE_CREATOR,
        MESG_TIMESTAMP_CORRELATION,
        MESG_SOFTWARE,
        MESG_SLAVE_DEVICE,
        MESG_CAPABILITIES,
        MESG_FILE_CAPABILITIES,
        MESG_MESG_CAPABILITIES,
        MESG_FIELD_CAPABILITIES,
        MESG_DEVICE_SETTINGS,
        MESG_USER_PROFILE,
        MESG_HRM_PROFILE,
        MESG_SDM_PROFILE,
        MESG_BIKE_PROFILE,
        MESG_CONNECTIVITY,
        MESG_WATCHFACE_SETTINGS,
        MESG_OHR_SETTINGS,
        MESG_TIME_IN_ZONE,
        MESG_ZONES_TARGET,
        MESG_SPORT,
        MESG_HR_ZONE,
        MESG_SPEED_ZONE,
        MESG_CADENCE_ZONE,
        MESG_POWER_ZONE,
        MESG_MET_ZONE,
        MESG_DIVE_SETTINGS,
        MESG_DIVE_ALARM,
        MESG_DIVE_APNEA_ALARM,
        MESG_DIVE_GAS,
        MESG_GOAL,
        MESG_ACTIVITY,
        MESG_SESSION,
        MESG_LAP,
        MESG_LENGTH,
        MESG_RECORD,
        MESG_EVENT,
        MESG_DEVICE_INFO,
        MESG_DEVICE_AUX_BATTERY_INFO,
        MESG_TRAINING_FILE,
        MESG_WEATHER_CONDITIONS,
        MESG_WEATHER_ALERT,
        MESG_GPS_METADATA,
        MESG_CAMERA_EVENT,
        MESG_GYROSCOPE_DATA,
        MESG_ACCELEROMETER_DATA,
        MESG_MAGNETOMETER_DATA,
        MESG_BAROMETER_DATA,
        MESG_THREE_D_SENSOR_CALIBRATION,
        MESG_ONE_D_SENSOR_CALIBRATION,
        MESG_VIDEO_FRAME,
        MESG_OBDII_DATA,
        MESG_NMEA_SENTENCE,
        MESG_AVIATION_ATTITUDE,
        MESG_VIDEO,
        MESG_VIDEO_TITLE,
        MESG_VIDEO_DESCRIPTION,
        MESG_VIDEO_CLIP,
        MESG_SET,
        MESG_JUMP,
        MESG_SPLIT,
        MESG_SPLIT_SUMMARY,
        MESG_CLIMB_PRO,
        MESG_FIELD_DESCRIPTION,
        MESG_DEVELOPER_DATA_ID,
        MESG_COURSE,
        MESG_COURSE_POINT,
        MESG_SEGMENT_ID,
        MESG_SEGMENT_LEADERBOARD_ENTRY,
        MESG_SEGMENT_POINT,
        MESG_SEGMENT_LAP,
        MESG_SEGMENT_FILE,
        MESG_WORKOUT,
        MESG_WORKOUT_SESSION,
        MESG_WORKOUT_STEP,
        MESG_EXERCISE_TITLE,
        MESG_SCHEDULE,
        MESG_TOTALS,
        MESG_WEIGHT_SCALE,
        MESG_BLOOD_PRESSURE,
        MESG_MONITORING_INFO,
        MESG_MONITORING,
        MESG_MONITORING_HR_DATA,
        MESG_SPO2_DATA,
        MESG_HR,
        MESG_STRESS_LEVEL,
        MESG_MAX_MET_DATA,
        MESG_HSA_BODY_BATTERY_DATA,
        MESG_HSA_EVENT,
        MESG_HSA_ACCELEROMETER_DATA,
        MESG_HSA_GYROSCOPE_DATA,
        MESG_HSA_STEP_DATA,
        MESG_HSA_SPO2_DATA,
        MESG_HSA_STRESS_DATA,
        MESG_HSA_RESPIRATION_DATA,
        MESG_HSA_HEART_RATE_DATA,
        MESG_HSA_CONFIGURATION_DATA,
        MESG_HSA_WRIST_TEMPERATURE_DATA,
        MESG_MEMO_GLOB,
        MESG_SLEEP_LEVEL,
        MESG_ANT_CHANNEL_ID,
        MESG_ANT_RX,
        MESG_ANT_TX,
        MESG_EXD_SCREEN_CONFIGURATION,
        MESG_EXD_DATA_FIELD_CONFIGURATION,
        MESG_EXD_DATA_CONCEPT_CONFIGURATION,
        MESG_DIVE_SUMMARY,
        MESG_AAD_ACCEL_FEATURES,
        MESG_HRV,
        MESG_BEAT_INTERVALS,
        MESG_HRV_STATUS_SUMMARY,
        MESG_HRV_VALUE,
        MESG_RAW_BBI,
        MESG_RESPIRATION_RATE,
        MESG_CHRONO_SHOT_SESSION,
        MESG_CHRONO_SHOT_DATA,
        MESG_TANK_UPDATE,
        MESG_TANK_SUMMARY,
        MESG_SLEEP_ASSESSMENT,
        MESG_SKIN_TEMP_OVERNIGHT,
        MESG_PAD,
        MESGS
    } MESG_INDEX;

    typedef enum
    {
        FILE_ID_MESG_TYPE,
        FILE_ID_MESG_MANUFACTURER,
        FILE_ID_MESG_PRODUCT,
        FILE_ID_MESG_SERIAL_NUMBER,
        FILE_ID_MESG_TIME_CREATED,
        FILE_ID_MESG_NUMBER,
        FILE_ID_MESG_PRODUCT_NAME,
        FILE_ID_MESG_FIELDS
    } FILE_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        FILE_ID_MESG_PRODUCT_FIELD_FAVERO_PRODUCT,
        FILE_ID_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        FILE_ID_MESG_PRODUCT_FIELD_SUBFIELDS,
        FILE_ID_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        FILE_ID_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } FILE_ID_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        FILE_CREATOR_MESG_SOFTWARE_VERSION,
        FILE_CREATOR_MESG_HARDWARE_VERSION,
        FILE_CREATOR_MESG_FIELDS
    } FILE_CREATOR_MESG_FIELD_INDEX;

    typedef enum
    {
        TIMESTAMP_CORRELATION_MESG_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_FRACTIONAL_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_SYSTEM_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_FRACTIONAL_SYSTEM_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_LOCAL_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_TIMESTAMP_MS,
        TIMESTAMP_CORRELATION_MESG_SYSTEM_TIMESTAMP_MS,
        TIMESTAMP_CORRELATION_MESG_FIELDS
    } TIMESTAMP_CORRELATION_MESG_FIELD_INDEX;

    typedef enum
    {
        SOFTWARE_MESG_MESSAGE_INDEX,
        SOFTWARE_MESG_VERSION,
        SOFTWARE_MESG_PART_NUMBER,
        SOFTWARE_MESG_FIELDS
    } SOFTWARE_MESG_FIELD_INDEX;

    typedef enum
    {
        SLAVE_DEVICE_MESG_MANUFACTURER,
        SLAVE_DEVICE_MESG_PRODUCT,
        SLAVE_DEVICE_MESG_FIELDS
    } SLAVE_DEVICE_MESG_FIELD_INDEX;

    typedef enum
    {
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_FAVERO_PRODUCT,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_SUBFIELDS,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SLAVE_DEVICE_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        CAPABILITIES_MESG_LANGUAGES,
        CAPABILITIES_MESG_SPORTS,
        CAPABILITIES_MESG_WORKOUTS_SUPPORTED,
        CAPABILITIES_MESG_CONNECTIVITY_SUPPORTED,
        CAPABILITIES_MESG_FIELDS
    } CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        FILE_CAPABILITIES_MESG_MESSAGE_INDEX,
        FILE_CAPABILITIES_MESG_TYPE,
        FILE_CAPABILITIES_MESG_FLAGS,
        FILE_CAPABILITIES_MESG_DIRECTORY,
        FILE_CAPABILITIES_MESG_MAX_COUNT,
        FILE_CAPABILITIES_MESG_MAX_SIZE,
        FILE_CAPABILITIES_MESG_FIELDS
    } FILE_CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        MESG_CAPABILITIES_MESG_MESSAGE_INDEX,
        MESG_CAPABILITIES_MESG_FILE,
        MESG_CAPABILITIES_MESG_MESG_NUM,
        MESG_CAPABILITIES_MESG_COUNT_TYPE,
        MESG_CAPABILITIES_MESG_COUNT,
        MESG_CAPABILITIES_MESG_FIELDS
    } MESG_CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        MESG_CAPABILITIES_MESG_COUNT_FIELD_NUM_PER_FILE,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_MAX_PER_FILE,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_MAX_PER_FILE_TYPE,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_SUBFIELDS,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } MESG_CAPABILITIES_MESG_COUNT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        FIELD_CAPABILITIES_MESG_MESSAGE_INDEX,
        FIELD_CAPABILITIES_MESG_FILE,
        FIELD_CAPABILITIES_MESG_MESG_NUM,
        FIELD_CAPABILITIES_MESG_FIELD_NUM,
        FIELD_CAPABILITIES_MESG_COUNT,
        FIELD_CAPABILITIES_MESG_FIELDS
    } FIELD_CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        DEVICE_SETTINGS_MESG_ACTIVE_TIME_ZONE,
        DEVICE_SETTINGS_MESG_UTC_OFFSET,
        DEVICE_SETTINGS_MESG_TIME_OFFSET,
        DEVICE_SETTINGS_MESG_TIME_MODE,
        DEVICE_SETTINGS_MESG_TIME_ZONE_OFFSET,
        DEVICE_SETTINGS_MESG_BACKLIGHT_MODE,
        DEVICE_SETTINGS_MESG_ACTIVITY_TRACKER_ENABLED,
        DEVICE_SETTINGS_MESG_CLOCK_TIME,
        DEVICE_SETTINGS_MESG_PAGES_ENABLED,
        DEVICE_SETTINGS_MESG_MOVE_ALERT_ENABLED,
        DEVICE_SETTINGS_MESG_DATE_MODE,
        DEVICE_SETTINGS_MESG_DISPLAY_ORIENTATION,
        DEVICE_SETTINGS_MESG_MOUNTING_SIDE,
        DEVICE_SETTINGS_MESG_DEFAULT_PAGE,
        DEVICE_SETTINGS_MESG_AUTOSYNC_MIN_STEPS,
        DEVICE_SETTINGS_MESG_AUTOSYNC_MIN_TIME,
        DEVICE_SETTINGS_MESG_LACTATE_THRESHOLD_AUTODETECT_ENABLED,
        DEVICE_SETTINGS_MESG_BLE_AUTO_UPLOAD_ENABLED,
        DEVICE_SETTINGS_MESG_AUTO_SYNC_FREQUENCY,
        DEVICE_SETTINGS_MESG_AUTO_ACTIVITY_DETECT,
        DEVICE_SETTINGS_MESG_NUMBER_OF_SCREENS,
        DEVICE_SETTINGS_MESG_SMART_NOTIFICATION_DISPLAY_ORIENTATION,
        DEVICE_SETTINGS_MESG_TAP_INTERFACE,
        DEVICE_SETTINGS_MESG_TAP_SENSITIVITY,
        DEVICE_SETTINGS_MESG_FIELDS
    } DEVICE_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        USER_PROFILE_MESG_MESSAGE_INDEX,
        USER_PROFILE_MESG_FRIENDLY_NAME,
        USER_PROFILE_MESG_GENDER,
        USER_PROFILE_MESG_AGE,
        USER_PROFILE_MESG_HEIGHT,
        USER_PROFILE_MESG_WEIGHT,
        USER_PROFILE_MESG_LANGUAGE,
        USER_PROFILE_MESG_ELEV_SETTING,
        USER_PROFILE_MESG_WEIGHT_SETTING,
        USER_PROFILE_MESG_RESTING_HEART_RATE,
        USER_PROFILE_MESG_DEFAULT_MAX_RUNNING_HEART_RATE,
        USER_PROFILE_MESG_DEFAULT_MAX_BIKING_HEART_RATE,
        USER_PROFILE_MESG_DEFAULT_MAX_HEART_RATE,
        USER_PROFILE_MESG_HR_SETTING,
        USER_PROFILE_MESG_SPEED_SETTING,
        USER_PROFILE_MESG_DIST_SETTING,
        USER_PROFILE_MESG_POWER_SETTING,
        USER_PROFILE_MESG_ACTIVITY_CLASS,
        USER_PROFILE_MESG_POSITION_SETTING,
        USER_PROFILE_MESG_TEMPERATURE_SETTING,
        USER_PROFILE_MESG_LOCAL_ID,
        USER_PROFILE_MESG_GLOBAL_ID,
        USER_PROFILE_MESG_WAKE_TIME,
        USER_PROFILE_MESG_SLEEP_TIME,
        USER_PROFILE_MESG_HEIGHT_SETTING,
        USER_PROFILE_MESG_USER_RUNNING_STEP_LENGTH,
        USER_PROFILE_MESG_USER_WALKING_STEP_LENGTH,
        USER_PROFILE_MESG_DEPTH_SETTING,
        USER_PROFILE_MESG_DIVE_COUNT,
        USER_PROFILE_MESG_FIELDS
    } USER_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        HRM_PROFILE_MESG_MESSAGE_INDEX,
        HRM_PROFILE_MESG_ENABLED,
        HRM_PROFILE_MESG_HRM_ANT_ID,
        HRM_PROFILE_MESG_LOG_HRV,
        HRM_PROFILE_MESG_HRM_ANT_ID_TRANS_TYPE,
        HRM_PROFILE_MESG_FIELDS
    } HRM_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        SDM_PROFILE_MESG_MESSAGE_INDEX,
        SDM_PROFILE_MESG_ENABLED,
        SDM_PROFILE_MESG_SDM_ANT_ID,
        SDM_PROFILE_MESG_SDM_CAL_FACTOR,
        SDM_PROFILE_MESG_ODOMETER,
        SDM_PROFILE_MESG_SPEED_SOURCE,
        SDM_PROFILE_MESG_SDM_ANT_ID_TRANS_TYPE,
        SDM_PROFILE_MESG_ODOMETER_ROLLOVER,
        SDM_PROFILE_MESG_FIELDS
    } SDM_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        BIKE_PROFILE_MESG_MESSAGE_INDEX,
        BIKE_PROFILE_MESG_NAME,
        BIKE_PROFILE_MESG_SPORT,
        BIKE_PROFILE_MESG_SUB_SPORT,
        BIKE_PROFILE_MESG_ODOMETER,
        BIKE_PROFILE_MESG_BIKE_SPD_ANT_ID,
        BIKE_PROFILE_MESG_BIKE_CAD_ANT_ID,
        BIKE_PROFILE_MESG_BIKE_SPDCAD_ANT_ID,
        BIKE_PROFILE_MESG_BIKE_POWER_ANT_ID,
        BIKE_PROFILE_MESG_CUSTOM_WHEELSIZE,
        BIKE_PROFILE_MESG_AUTO_WHEELSIZE,
        BIKE_PROFILE_MESG_BIKE_WEIGHT,
        BIKE_PROFILE_MESG_POWER_CAL_FACTOR,
        BIKE_PROFILE_MESG_AUTO_WHEEL_CAL,
        BIKE_PROFILE_MESG_AUTO_POWER_ZERO,
        BIKE_PROFILE_MESG_ID,
        BIKE_PROFILE_MESG_SPD_ENABLED,
        BIKE_PROFILE_MESG_CAD_ENABLED,
        BIKE_PROFILE_MESG_SPDCAD_ENABLED,
        BIKE_PROFILE_MESG_POWER_ENABLED,
        BIKE_PROFILE_MESG_CRANK_LENGTH,
        BIKE_PROFILE_MESG_ENABLED,
        BIKE_PROFILE_MESG_BIKE_SPD_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_BIKE_CAD_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_BIKE_SPDCAD_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_BIKE_POWER_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_ODOMETER_ROLLOVER,
        BIKE_PROFILE_MESG_FRONT_GEAR_NUM,
        BIKE_PROFILE_MESG_FRONT_GEAR,
        BIKE_PROFILE_MESG_REAR_GEAR_NUM,
        BIKE_PROFILE_MESG_REAR_GEAR,
        BIKE_PROFILE_MESG_SHIMANO_DI2_ENABLED,
        BIKE_PROFILE_MESG_FIELDS
    } BIKE_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        CONNECTIVITY_MESG_BLUETOOTH_ENABLED,
        CONNECTIVITY_MESG_BLUETOOTH_LE_ENABLED,
        CONNECTIVITY_MESG_ANT_ENABLED,
        CONNECTIVITY_MESG_NAME,
        CONNECTIVITY_MESG_LIVE_TRACKING_ENABLED,
        CONNECTIVITY_MESG_WEATHER_CONDITIONS_ENABLED,
        CONNECTIVITY_MESG_WEATHER_ALERTS_ENABLED,
        CONNECTIVITY_MESG_AUTO_ACTIVITY_UPLOAD_ENABLED,
        CONNECTIVITY_MESG_COURSE_DOWNLOAD_ENABLED,
        CONNECTIVITY_MESG_WORKOUT_DOWNLOAD_ENABLED,
        CONNECTIVITY_MESG_GPS_EPHEMERIS_DOWNLOAD_ENABLED,
        CONNECTIVITY_MESG_INCIDENT_DETECTION_ENABLED,
        CONNECTIVITY_MESG_GROUPTRACK_ENABLED,
        CONNECTIVITY_MESG_FIELDS
    } CONNECTIVITY_MESG_FIELD_INDEX;

    typedef enum
    {
        WATCHFACE_SETTINGS_MESG_MESSAGE_INDEX,
        WATCHFACE_SETTINGS_MESG_MODE,
        WATCHFACE_SETTINGS_MESG_LAYOUT,
        WATCHFACE_SETTINGS_MESG_FIELDS
    } WATCHFACE_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_DIGITAL_LAYOUT,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_ANALOG_LAYOUT,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_SUBFIELDS,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        OHR_SETTINGS_MESG_TIMESTAMP,
        OHR_SETTINGS_MESG_ENABLED,
        OHR_SETTINGS_MESG_FIELDS
    } OHR_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        TIME_IN_ZONE_MESG_TIMESTAMP,
        TIME_IN_ZONE_MESG_REFERENCE_MESG,
        TIME_IN_ZONE_MESG_REFERENCE_INDEX,
        TIME_IN_ZONE_MESG_TIME_IN_HR_ZONE,
        TIME_IN_ZONE_MESG_TIME_IN_SPEED_ZONE,
        TIME_IN_ZONE_MESG_TIME_IN_CADENCE_ZONE,
        TIME_IN_ZONE_MESG_TIME_IN_POWER_ZONE,
        TIME_IN_ZONE_MESG_HR_ZONE_HIGH_BOUNDARY,
        TIME_IN_ZONE_MESG_SPEED_ZONE_HIGH_BOUNDARY,
        TIME_IN_ZONE_MESG_CADENCE_ZONE_HIGH_BONDARY,
        TIME_IN_ZONE_MESG_POWER_ZONE_HIGH_BOUNDARY,
        TIME_IN_ZONE_MESG_HR_CALC_TYPE,
        TIME_IN_ZONE_MESG_MAX_HEART_RATE,
        TIME_IN_ZONE_MESG_RESTING_HEART_RATE,
        TIME_IN_ZONE_MESG_THRESHOLD_HEART_RATE,
        TIME_IN_ZONE_MESG_PWR_CALC_TYPE,
        TIME_IN_ZONE_MESG_FUNCTIONAL_THRESHOLD_POWER,
        TIME_IN_ZONE_MESG_FIELDS
    } TIME_IN_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        ZONES_TARGET_MESG_MAX_HEART_RATE,
        ZONES_TARGET_MESG_THRESHOLD_HEART_RATE,
        ZONES_TARGET_MESG_FUNCTIONAL_THRESHOLD_POWER,
        ZONES_TARGET_MESG_HR_CALC_TYPE,
        ZONES_TARGET_MESG_PWR_CALC_TYPE,
        ZONES_TARGET_MESG_FIELDS
    } ZONES_TARGET_MESG_FIELD_INDEX;

    typedef enum
    {
        SPORT_MESG_SPORT,
        SPORT_MESG_SUB_SPORT,
        SPORT_MESG_NAME,
        SPORT_MESG_FIELDS
    } SPORT_MESG_FIELD_INDEX;

    typedef enum
    {
        HR_ZONE_MESG_MESSAGE_INDEX,
        HR_ZONE_MESG_HIGH_BPM,
        HR_ZONE_MESG_NAME,
        HR_ZONE_MESG_FIELDS
    } HR_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        SPEED_ZONE_MESG_MESSAGE_INDEX,
        SPEED_ZONE_MESG_HIGH_VALUE,
        SPEED_ZONE_MESG_NAME,
        SPEED_ZONE_MESG_FIELDS
    } SPEED_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        CADENCE_ZONE_MESG_MESSAGE_INDEX,
        CADENCE_ZONE_MESG_HIGH_VALUE,
        CADENCE_ZONE_MESG_NAME,
        CADENCE_ZONE_MESG_FIELDS
    } CADENCE_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        POWER_ZONE_MESG_MESSAGE_INDEX,
        POWER_ZONE_MESG_HIGH_VALUE,
        POWER_ZONE_MESG_NAME,
        POWER_ZONE_MESG_FIELDS
    } POWER_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        MET_ZONE_MESG_MESSAGE_INDEX,
        MET_ZONE_MESG_HIGH_BPM,
        MET_ZONE_MESG_CALORIES,
        MET_ZONE_MESG_FAT_CALORIES,
        MET_ZONE_MESG_FIELDS
    } MET_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        DIVE_SETTINGS_MESG_TIMESTAMP,
        DIVE_SETTINGS_MESG_MESSAGE_INDEX,
        DIVE_SETTINGS_MESG_NAME,
        DIVE_SETTINGS_MESG_MODEL,
        DIVE_SETTINGS_MESG_GF_LOW,
        DIVE_SETTINGS_MESG_GF_HIGH,
        DIVE_SETTINGS_MESG_WATER_TYPE,
        DIVE_SETTINGS_MESG_WATER_DENSITY,
        DIVE_SETTINGS_MESG_PO2_WARN,
        DIVE_SETTINGS_MESG_PO2_CRITICAL,
        DIVE_SETTINGS_MESG_PO2_DECO,
        DIVE_SETTINGS_MESG_SAFETY_STOP_ENABLED,
        DIVE_SETTINGS_MESG_BOTTOM_DEPTH,
        DIVE_SETTINGS_MESG_BOTTOM_TIME,
        DIVE_SETTINGS_MESG_APNEA_COUNTDOWN_ENABLED,
        DIVE_SETTINGS_MESG_APNEA_COUNTDOWN_TIME,
        DIVE_SETTINGS_MESG_BACKLIGHT_MODE,
        DIVE_SETTINGS_MESG_BACKLIGHT_BRIGHTNESS,
        DIVE_SETTINGS_MESG_BACKLIGHT_TIMEOUT,
        DIVE_SETTINGS_MESG_REPEAT_DIVE_INTERVAL,
        DIVE_SETTINGS_MESG_SAFETY_STOP_TIME,
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_TYPE,
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE,
        DIVE_SETTINGS_MESG_TRAVEL_GAS,
        DIVE_SETTINGS_MESG_CCR_LOW_SETPOINT_SWITCH_MODE,
        DIVE_SETTINGS_MESG_CCR_LOW_SETPOINT,
        DIVE_SETTINGS_MESG_CCR_LOW_SETPOINT_DEPTH,
        DIVE_SETTINGS_MESG_CCR_HIGH_SETPOINT_SWITCH_MODE,
        DIVE_SETTINGS_MESG_CCR_HIGH_SETPOINT,
        DIVE_SETTINGS_MESG_CCR_HIGH_SETPOINT_DEPTH,
        DIVE_SETTINGS_MESG_GAS_CONSUMPTION_DISPLAY,
        DIVE_SETTINGS_MESG_UP_KEY_ENABLED,
        DIVE_SETTINGS_MESG_DIVE_SOUNDS,
        DIVE_SETTINGS_MESG_LAST_STOP_MULTIPLE,
        DIVE_SETTINGS_MESG_NO_FLY_TIME_MODE,
        DIVE_SETTINGS_MESG_FIELDS
    } DIVE_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_ANTPLUS_DEVICE_TYPE,
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_HEART_RATE_LOCAL_DEVICE_TYPE,
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_SUBFIELDS,
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } DIVE_SETTINGS_MESG_HEART_RATE_SOURCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        DIVE_ALARM_MESG_MESSAGE_INDEX,
        DIVE_ALARM_MESG_DEPTH,
        DIVE_ALARM_MESG_TIME,
        DIVE_ALARM_MESG_ENABLED,
        DIVE_ALARM_MESG_ALARM_TYPE,
        DIVE_ALARM_MESG_SOUND,
        DIVE_ALARM_MESG_DIVE_TYPES,
        DIVE_ALARM_MESG_ID,
        DIVE_ALARM_MESG_POPUP_ENABLED,
        DIVE_ALARM_MESG_TRIGGER_ON_DESCENT,
        DIVE_ALARM_MESG_TRIGGER_ON_ASCENT,
        DIVE_ALARM_MESG_REPEATING,
        DIVE_ALARM_MESG_SPEED,
        DIVE_ALARM_MESG_FIELDS
    } DIVE_ALARM_MESG_FIELD_INDEX;

    typedef enum
    {
        DIVE_APNEA_ALARM_MESG_MESSAGE_INDEX,
        DIVE_APNEA_ALARM_MESG_DEPTH,
        DIVE_APNEA_ALARM_MESG_TIME,
        DIVE_APNEA_ALARM_MESG_ENABLED,
        DIVE_APNEA_ALARM_MESG_ALARM_TYPE,
        DIVE_APNEA_ALARM_MESG_SOUND,
        DIVE_APNEA_ALARM_MESG_DIVE_TYPES,
        DIVE_APNEA_ALARM_MESG_ID,
        DIVE_APNEA_ALARM_MESG_POPUP_ENABLED,
        DIVE_APNEA_ALARM_MESG_TRIGGER_ON_DESCENT,
        DIVE_APNEA_ALARM_MESG_TRIGGER_ON_ASCENT,
        DIVE_APNEA_ALARM_MESG_REPEATING,
        DIVE_APNEA_ALARM_MESG_SPEED,
        DIVE_APNEA_ALARM_MESG_FIELDS
    } DIVE_APNEA_ALARM_MESG_FIELD_INDEX;

    typedef enum
    {
        DIVE_GAS_MESG_MESSAGE_INDEX,
        DIVE_GAS_MESG_HELIUM_CONTENT,
        DIVE_GAS_MESG_OXYGEN_CONTENT,
        DIVE_GAS_MESG_STATUS,
        DIVE_GAS_MESG_MODE,
        DIVE_GAS_MESG_FIELDS
    } DIVE_GAS_MESG_FIELD_INDEX;

    typedef enum
    {
        GOAL_MESG_MESSAGE_INDEX,
        GOAL_MESG_SPORT,
        GOAL_MESG_SUB_SPORT,
        GOAL_MESG_START_DATE,
        GOAL_MESG_END_DATE,
        GOAL_MESG_TYPE,
        GOAL_MESG_VALUE,
        GOAL_MESG_REPEAT,
        GOAL_MESG_TARGET_VALUE,
        GOAL_MESG_RECURRENCE,
        GOAL_MESG_RECURRENCE_VALUE,
        GOAL_MESG_ENABLED,
        GOAL_MESG_SOURCE,
        GOAL_MESG_FIELDS
    } GOAL_MESG_FIELD_INDEX;

    typedef enum
    {
        ACTIVITY_MESG_TIMESTAMP,
        ACTIVITY_MESG_TOTAL_TIMER_TIME,
        ACTIVITY_MESG_NUM_SESSIONS,
        ACTIVITY_MESG_TYPE,
        ACTIVITY_MESG_EVENT,
        ACTIVITY_MESG_EVENT_TYPE,
        ACTIVITY_MESG_LOCAL_TIMESTAMP,
        ACTIVITY_MESG_EVENT_GROUP,
        ACTIVITY_MESG_FIELDS
    } ACTIVITY_MESG_FIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_MESSAGE_INDEX,
        SESSION_MESG_TIMESTAMP,
        SESSION_MESG_EVENT,
        SESSION_MESG_EVENT_TYPE,
        SESSION_MESG_START_TIME,
        SESSION_MESG_START_POSITION_LAT,
        SESSION_MESG_START_POSITION_LONG,
        SESSION_MESG_SPORT,
        SESSION_MESG_SUB_SPORT,
        SESSION_MESG_TOTAL_ELAPSED_TIME,
        SESSION_MESG_TOTAL_TIMER_TIME,
        SESSION_MESG_TOTAL_DISTANCE,
        SESSION_MESG_TOTAL_CYCLES,
        SESSION_MESG_TOTAL_CALORIES,
        SESSION_MESG_TOTAL_FAT_CALORIES,
        SESSION_MESG_AVG_SPEED,
        SESSION_MESG_MAX_SPEED,
        SESSION_MESG_AVG_HEART_RATE,
        SESSION_MESG_MAX_HEART_RATE,
        SESSION_MESG_AVG_CADENCE,
        SESSION_MESG_MAX_CADENCE,
        SESSION_MESG_AVG_POWER,
        SESSION_MESG_MAX_POWER,
        SESSION_MESG_TOTAL_ASCENT,
        SESSION_MESG_TOTAL_DESCENT,
        SESSION_MESG_TOTAL_TRAINING_EFFECT,
        SESSION_MESG_FIRST_LAP_INDEX,
        SESSION_MESG_NUM_LAPS,
        SESSION_MESG_EVENT_GROUP,
        SESSION_MESG_TRIGGER,
        SESSION_MESG_NEC_LAT,
        SESSION_MESG_NEC_LONG,
        SESSION_MESG_SWC_LAT,
        SESSION_MESG_SWC_LONG,
        SESSION_MESG_NUM_LENGTHS,
        SESSION_MESG_NORMALIZED_POWER,
        SESSION_MESG_TRAINING_STRESS_SCORE,
        SESSION_MESG_INTENSITY_FACTOR,
        SESSION_MESG_LEFT_RIGHT_BALANCE,
        SESSION_MESG_END_POSITION_LAT,
        SESSION_MESG_END_POSITION_LONG,
        SESSION_MESG_AVG_STROKE_COUNT,
        SESSION_MESG_AVG_STROKE_DISTANCE,
        SESSION_MESG_SWIM_STROKE,
        SESSION_MESG_POOL_LENGTH,
        SESSION_MESG_THRESHOLD_POWER,
        SESSION_MESG_POOL_LENGTH_UNIT,
        SESSION_MESG_NUM_ACTIVE_LENGTHS,
        SESSION_MESG_TOTAL_WORK,
        SESSION_MESG_AVG_ALTITUDE,
        SESSION_MESG_MAX_ALTITUDE,
        SESSION_MESG_GPS_ACCURACY,
        SESSION_MESG_AVG_GRADE,
        SESSION_MESG_AVG_POS_GRADE,
        SESSION_MESG_AVG_NEG_GRADE,
        SESSION_MESG_MAX_POS_GRADE,
        SESSION_MESG_MAX_NEG_GRADE,
        SESSION_MESG_AVG_TEMPERATURE,
        SESSION_MESG_MAX_TEMPERATURE,
        SESSION_MESG_TOTAL_MOVING_TIME,
        SESSION_MESG_AVG_POS_VERTICAL_SPEED,
        SESSION_MESG_AVG_NEG_VERTICAL_SPEED,
        SESSION_MESG_MAX_POS_VERTICAL_SPEED,
        SESSION_MESG_MAX_NEG_VERTICAL_SPEED,
        SESSION_MESG_MIN_HEART_RATE,
        SESSION_MESG_TIME_IN_HR_ZONE,
        SESSION_MESG_TIME_IN_SPEED_ZONE,
        SESSION_MESG_TIME_IN_CADENCE_ZONE,
        SESSION_MESG_TIME_IN_POWER_ZONE,
        SESSION_MESG_AVG_LAP_TIME,
        SESSION_MESG_BEST_LAP_INDEX,
        SESSION_MESG_MIN_ALTITUDE,
        SESSION_MESG_PLAYER_SCORE,
        SESSION_MESG_OPPONENT_SCORE,
        SESSION_MESG_OPPONENT_NAME,
        SESSION_MESG_STROKE_COUNT,
        SESSION_MESG_ZONE_COUNT,
        SESSION_MESG_MAX_BALL_SPEED,
        SESSION_MESG_AVG_BALL_SPEED,
        SESSION_MESG_AVG_VERTICAL_OSCILLATION,
        SESSION_MESG_AVG_STANCE_TIME_PERCENT,
        SESSION_MESG_AVG_STANCE_TIME,
        SESSION_MESG_AVG_FRACTIONAL_CADENCE,
        SESSION_MESG_MAX_FRACTIONAL_CADENCE,
        SESSION_MESG_TOTAL_FRACTIONAL_CYCLES,
        SESSION_MESG_AVG_TOTAL_HEMOGLOBIN_CONC,
        SESSION_MESG_MIN_TOTAL_HEMOGLOBIN_CONC,
        SESSION_MESG_MAX_TOTAL_HEMOGLOBIN_CONC,
        SESSION_MESG_AVG_SATURATED_HEMOGLOBIN_PERCENT,
        SESSION_MESG_MIN_SATURATED_HEMOGLOBIN_PERCENT,
        SESSION_MESG_MAX_SATURATED_HEMOGLOBIN_PERCENT,
        SESSION_MESG_AVG_LEFT_TORQUE_EFFECTIVENESS,
        SESSION_MESG_AVG_RIGHT_TORQUE_EFFECTIVENESS,
        SESSION_MESG_AVG_LEFT_PEDAL_SMOOTHNESS,
        SESSION_MESG_AVG_RIGHT_PEDAL_SMOOTHNESS,
        SESSION_MESG_AVG_COMBINED_PEDAL_SMOOTHNESS,
        SESSION_MESG_SPORT_PROFILE_NAME,
        SESSION_MESG_SPORT_INDEX,
        SESSION_MESG_TIME_STANDING,
        SESSION_MESG_STAND_COUNT,
        SESSION_MESG_AVG_LEFT_PCO,
        SESSION_MESG_AVG_RIGHT_PCO,
        SESSION_MESG_AVG_LEFT_POWER_PHASE,
        SESSION_MESG_AVG_LEFT_POWER_PHASE_PEAK,
        SESSION_MESG_AVG_RIGHT_POWER_PHASE,
        SESSION_MESG_AVG_RIGHT_POWER_PHASE_PEAK,
        SESSION_MESG_AVG_POWER_POSITION,
        SESSION_MESG_MAX_POWER_POSITION,
        SESSION_MESG_AVG_CADENCE_POSITION,
        SESSION_MESG_MAX_CADENCE_POSITION,
        SESSION_MESG_ENHANCED_AVG_SPEED,
        SESSION_MESG_ENHANCED_MAX_SPEED,
        SESSION_MESG_ENHANCED_AVG_ALTITUDE,
        SESSION_MESG_ENHANCED_MIN_ALTITUDE,
        SESSION_MESG_ENHANCED_MAX_ALTITUDE,
        SESSION_MESG_AVG_LEV_MOTOR_POWER,
        SESSION_MESG_MAX_LEV_MOTOR_POWER,
        SESSION_MESG_LEV_BATTERY_CONSUMPTION,
        SESSION_MESG_AVG_VERTICAL_RATIO,
        SESSION_MESG_AVG_STANCE_TIME_BALANCE,
        SESSION_MESG_AVG_STEP_LENGTH,
        SESSION_MESG_TOTAL_ANAEROBIC_TRAINING_EFFECT,
        SESSION_MESG_AVG_VAM,
        SESSION_MESG_AVG_DEPTH,
        SESSION_MESG_MAX_DEPTH,
        SESSION_MESG_SURFACE_INTERVAL,
        SESSION_MESG_START_CNS,
        SESSION_MESG_END_CNS,
        SESSION_MESG_START_N2,
        SESSION_MESG_END_N2,
        SESSION_MESG_AVG_RESPIRATION_RATE,
        SESSION_MESG_MAX_RESPIRATION_RATE,
        SESSION_MESG_MIN_RESPIRATION_RATE,
        SESSION_MESG_MIN_TEMPERATURE,
        SESSION_MESG_O2_TOXICITY,
        SESSION_MESG_DIVE_NUMBER,
        SESSION_MESG_TRAINING_LOAD_PEAK,
        SESSION_MESG_ENHANCED_AVG_RESPIRATION_RATE,
        SESSION_MESG_ENHANCED_MAX_RESPIRATION_RATE,
        SESSION_MESG_ENHANCED_MIN_RESPIRATION_RATE,
        SESSION_MESG_TOTAL_GRIT,
        SESSION_MESG_TOTAL_FLOW,
        SESSION_MESG_JUMP_COUNT,
        SESSION_MESG_AVG_GRIT,
        SESSION_MESG_AVG_FLOW,
        SESSION_MESG_WORKOUT_FEEL,
        SESSION_MESG_WORKOUT_RPE,
        SESSION_MESG_AVG_SPO2,
        SESSION_MESG_AVG_STRESS,
        SESSION_MESG_SDRR_HRV,
        SESSION_MESG_RMSSD_HRV,
        SESSION_MESG_TOTAL_FRACTIONAL_ASCENT,
        SESSION_MESG_TOTAL_FRACTIONAL_DESCENT,
        SESSION_MESG_AVG_CORE_TEMPERATURE,
        SESSION_MESG_MIN_CORE_TEMPERATURE,
        SESSION_MESG_MAX_CORE_TEMPERATURE,
        SESSION_MESG_FIELDS
    } SESSION_MESG_FIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES,
        SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES,
        SESSION_MESG_TOTAL_CYCLES_FIELD_SUBFIELDS,
        SESSION_MESG_TOTAL_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SESSION_MESG_TOTAL_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SESSION_MESG_TOTAL_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE,
        SESSION_MESG_AVG_CADENCE_FIELD_SUBFIELDS,
        SESSION_MESG_AVG_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SESSION_MESG_AVG_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SESSION_MESG_AVG_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE,
        SESSION_MESG_MAX_CADENCE_FIELD_SUBFIELDS,
        SESSION_MESG_MAX_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SESSION_MESG_MAX_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SESSION_MESG_MAX_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LAP_MESG_MESSAGE_INDEX,
        LAP_MESG_TIMESTAMP,
        LAP_MESG_EVENT,
        LAP_MESG_EVENT_TYPE,
        LAP_MESG_START_TIME,
        LAP_MESG_START_POSITION_LAT,
        LAP_MESG_START_POSITION_LONG,
        LAP_MESG_END_POSITION_LAT,
        LAP_MESG_END_POSITION_LONG,
        LAP_MESG_TOTAL_ELAPSED_TIME,
        LAP_MESG_TOTAL_TIMER_TIME,
        LAP_MESG_TOTAL_DISTANCE,
        LAP_MESG_TOTAL_CYCLES,
        LAP_MESG_TOTAL_CALORIES,
        LAP_MESG_TOTAL_FAT_CALORIES,
        LAP_MESG_AVG_SPEED,
        LAP_MESG_MAX_SPEED,
        LAP_MESG_AVG_HEART_RATE,
        LAP_MESG_MAX_HEART_RATE,
        LAP_MESG_AVG_CADENCE,
        LAP_MESG_MAX_CADENCE,
        LAP_MESG_AVG_POWER,
        LAP_MESG_MAX_POWER,
        LAP_MESG_TOTAL_ASCENT,
        LAP_MESG_TOTAL_DESCENT,
        LAP_MESG_INTENSITY,
        LAP_MESG_LAP_TRIGGER,
        LAP_MESG_SPORT,
        LAP_MESG_EVENT_GROUP,
        LAP_MESG_NUM_LENGTHS,
        LAP_MESG_NORMALIZED_POWER,
        LAP_MESG_LEFT_RIGHT_BALANCE,
        LAP_MESG_FIRST_LENGTH_INDEX,
        LAP_MESG_AVG_STROKE_DISTANCE,
        LAP_MESG_SWIM_STROKE,
        LAP_MESG_SUB_SPORT,
        LAP_MESG_NUM_ACTIVE_LENGTHS,
        LAP_MESG_TOTAL_WORK,
        LAP_MESG_AVG_ALTITUDE,
        LAP_MESG_MAX_ALTITUDE,
        LAP_MESG_GPS_ACCURACY,
        LAP_MESG_AVG_GRADE,
        LAP_MESG_AVG_POS_GRADE,
        LAP_MESG_AVG_NEG_GRADE,
        LAP_MESG_MAX_POS_GRADE,
        LAP_MESG_MAX_NEG_GRADE,
        LAP_MESG_AVG_TEMPERATURE,
        LAP_MESG_MAX_TEMPERATURE,
        LAP_MESG_TOTAL_MOVING_TIME,
        LAP_MESG_AVG_POS_VERTICAL_SPEED,
        LAP_MESG_AVG_NEG_VERTICAL_SPEED,
        LAP_MESG_MAX_POS_VERTICAL_SPEED,
        LAP_MESG_MAX_NEG_VERTICAL_SPEED,
        LAP_MESG_TIME_IN_HR_ZONE,
        LAP_MESG_TIME_IN_SPEED_ZONE,
        LAP_MESG_TIME_IN_CADENCE_ZONE,
        LAP_MESG_TIME_IN_POWER_ZONE,
        LAP_MESG_REPETITION_NUM,
        LAP_MESG_MIN_ALTITUDE,
        LAP_MESG_MIN_HEART_RATE,
        LAP_MESG_WKT_STEP_INDEX,
        LAP_MESG_OPPONENT_SCORE,
        LAP_MESG_STROKE_COUNT,
        LAP_MESG_ZONE_COUNT,
        LAP_MESG_AVG_VERTICAL_OSCILLATION,
        LAP_MESG_AVG_STANCE_TIME_PERCENT,
        LAP_MESG_AVG_STANCE_TIME,
        LAP_MESG_AVG_FRACTIONAL_CADENCE,
        LAP_MESG_MAX_FRACTIONAL_CADENCE,
        LAP_MESG_TOTAL_FRACTIONAL_CYCLES,
        LAP_MESG_PLAYER_SCORE,
        LAP_MESG_AVG_TOTAL_HEMOGLOBIN_CONC,
        LAP_MESG_MIN_TOTAL_HEMOGLOBIN_CONC,
        LAP_MESG_MAX_TOTAL_HEMOGLOBIN_CONC,
        LAP_MESG_AVG_SATURATED_HEMOGLOBIN_PERCENT,
        LAP_MESG_MIN_SATURATED_HEMOGLOBIN_PERCENT,
        LAP_MESG_MAX_SATURATED_HEMOGLOBIN_PERCENT,
        LAP_MESG_AVG_LEFT_TORQUE_EFFECTIVENESS,
        LAP_MESG_AVG_RIGHT_TORQUE_EFFECTIVENESS,
        LAP_MESG_AVG_LEFT_PEDAL_SMOOTHNESS,
        LAP_MESG_AVG_RIGHT_PEDAL_SMOOTHNESS,
        LAP_MESG_AVG_COMBINED_PEDAL_SMOOTHNESS,
        LAP_MESG_TIME_STANDING,
        LAP_MESG_STAND_COUNT,
        LAP_MESG_AVG_LEFT_PCO,
        LAP_MESG_AVG_RIGHT_PCO,
        LAP_MESG_AVG_LEFT_POWER_PHASE,
        LAP_MESG_AVG_LEFT_POWER_PHASE_PEAK,
        LAP_MESG_AVG_RIGHT_POWER_PHASE,
        LAP_MESG_AVG_RIGHT_POWER_PHASE_PEAK,
        LAP_MESG_AVG_POWER_POSITION,
        LAP_MESG_MAX_POWER_POSITION,
        LAP_MESG_AVG_CADENCE_POSITION,
        LAP_MESG_MAX_CADENCE_POSITION,
        LAP_MESG_ENHANCED_AVG_SPEED,
        LAP_MESG_ENHANCED_MAX_SPEED,
        LAP_MESG_ENHANCED_AVG_ALTITUDE,
        LAP_MESG_ENHANCED_MIN_ALTITUDE,
        LAP_MESG_ENHANCED_MAX_ALTITUDE,
        LAP_MESG_AVG_LEV_MOTOR_POWER,
        LAP_MESG_MAX_LEV_MOTOR_POWER,
        LAP_MESG_LEV_BATTERY_CONSUMPTION,
        LAP_MESG_AVG_VERTICAL_RATIO,
        LAP_MESG_AVG_STANCE_TIME_BALANCE,
        LAP_MESG_AVG_STEP_LENGTH,
        LAP_MESG_AVG_VAM,
        LAP_MESG_AVG_DEPTH,
        LAP_MESG_MAX_DEPTH,
        LAP_MESG_MIN_TEMPERATURE,
        LAP_MESG_ENHANCED_AVG_RESPIRATION_RATE,
        LAP_MESG_ENHANCED_MAX_RESPIRATION_RATE,
        LAP_MESG_AVG_RESPIRATION_RATE,
        LAP_MESG_MAX_RESPIRATION_RATE,
        LAP_MESG_TOTAL_GRIT,
        LAP_MESG_TOTAL_FLOW,
        LAP_MESG_JUMP_COUNT,
        LAP_MESG_AVG_GRIT,
        LAP_MESG_AVG_FLOW,
        LAP_MESG_TOTAL_FRACTIONAL_ASCENT,
        LAP_MESG_TOTAL_FRACTIONAL_DESCENT,
        LAP_MESG_AVG_CORE_TEMPERATURE,
        LAP_MESG_MIN_CORE_TEMPERATURE,
        LAP_MESG_MAX_CORE_TEMPERATURE,
        LAP_MESG_FIELDS
    } LAP_MESG_FIELD_INDEX;

    typedef enum
    {
        LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES,
        LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES,
        LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELDS,
        LAP_MESG_TOTAL_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        LAP_MESG_TOTAL_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE,
        LAP_MESG_AVG_CADENCE_FIELD_SUBFIELDS,
        LAP_MESG_AVG_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        LAP_MESG_AVG_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } LAP_MESG_AVG_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE,
        LAP_MESG_MAX_CADENCE_FIELD_SUBFIELDS,
        LAP_MESG_MAX_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        LAP_MESG_MAX_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } LAP_MESG_MAX_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LENGTH_MESG_MESSAGE_INDEX,
        LENGTH_MESG_TIMESTAMP,
        LENGTH_MESG_EVENT,
        LENGTH_MESG_EVENT_TYPE,
        LENGTH_MESG_START_TIME,
        LENGTH_MESG_TOTAL_ELAPSED_TIME,
        LENGTH_MESG_TOTAL_TIMER_TIME,
        LENGTH_MESG_TOTAL_STROKES,
        LENGTH_MESG_AVG_SPEED,
        LENGTH_MESG_SWIM_STROKE,
        LENGTH_MESG_AVG_SWIMMING_CADENCE,
        LENGTH_MESG_EVENT_GROUP,
        LENGTH_MESG_TOTAL_CALORIES,
        LENGTH_MESG_LENGTH_TYPE,
        LENGTH_MESG_PLAYER_SCORE,
        LENGTH_MESG_OPPONENT_SCORE,
        LENGTH_MESG_STROKE_COUNT,
        LENGTH_MESG_ZONE_COUNT,
        LENGTH_MESG_ENHANCED_AVG_RESPIRATION_RATE,
        LENGTH_MESG_ENHANCED_MAX_RESPIRATION_RATE,
        LENGTH_MESG_AVG_RESPIRATION_RATE,
        LENGTH_MESG_MAX_RESPIRATION_RATE,
        LENGTH_MESG_FIELDS
    } LENGTH_MESG_FIELD_INDEX;

    typedef enum
    {
        RECORD_MESG_TIMESTAMP,
        RECORD_MESG_POSITION_LAT,
        RECORD_MESG_POSITION_LONG,
        RECORD_MESG_ALTITUDE,
        RECORD_MESG_HEART_RATE,
        RECORD_MESG_CADENCE,
        RECORD_MESG_DISTANCE,
        RECORD_MESG_SPEED,
        RECORD_MESG_POWER,
        RECORD_MESG_COMPRESSED_SPEED_DISTANCE,
        RECORD_MESG_GRADE,
        RECORD_MESG_RESISTANCE,
        RECORD_MESG_TIME_FROM_COURSE,
        RECORD_MESG_CYCLE_LENGTH,
        RECORD_MESG_TEMPERATURE,
        RECORD_MESG_SPEED_1S,
        RECORD_MESG_CYCLES,
        RECORD_MESG_TOTAL_CYCLES,
        RECORD_MESG_COMPRESSED_ACCUMULATED_POWER,
        RECORD_MESG_ACCUMULATED_POWER,
        RECORD_MESG_LEFT_RIGHT_BALANCE,
        RECORD_MESG_GPS_ACCURACY,
        RECORD_MESG_VERTICAL_SPEED,
        RECORD_MESG_CALORIES,
        RECORD_MESG_VERTICAL_OSCILLATION,
        RECORD_MESG_STANCE_TIME_PERCENT,
        RECORD_MESG_STANCE_TIME,
        RECORD_MESG_ACTIVITY_TYPE,
        RECORD_MESG_LEFT_TORQUE_EFFECTIVENESS,
        RECORD_MESG_RIGHT_TORQUE_EFFECTIVENESS,
        RECORD_MESG_LEFT_PEDAL_SMOOTHNESS,
        RECORD_MESG_RIGHT_PEDAL_SMOOTHNESS,
        RECORD_MESG_COMBINED_PEDAL_SMOOTHNESS,
        RECORD_MESG_TIME128,
        RECORD_MESG_STROKE_TYPE,
        RECORD_MESG_ZONE,
        RECORD_MESG_BALL_SPEED,
        RECORD_MESG_CADENCE256,
        RECORD_MESG_FRACTIONAL_CADENCE,
        RECORD_MESG_TOTAL_HEMOGLOBIN_CONC,
        RECORD_MESG_TOTAL_HEMOGLOBIN_CONC_MIN,
        RECORD_MESG_TOTAL_HEMOGLOBIN_CONC_MAX,
        RECORD_MESG_SATURATED_HEMOGLOBIN_PERCENT,
        RECORD_MESG_SATURATED_HEMOGLOBIN_PERCENT_MIN,
        RECORD_MESG_SATURATED_HEMOGLOBIN_PERCENT_MAX,
        RECORD_MESG_DEVICE_INDEX,
        RECORD_MESG_LEFT_PCO,
        RECORD_MESG_RIGHT_PCO,
        RECORD_MESG_LEFT_POWER_PHASE,
        RECORD_MESG_LEFT_POWER_PHASE_PEAK,
        RECORD_MESG_RIGHT_POWER_PHASE,
        RECORD_MESG_RIGHT_POWER_PHASE_PEAK,
        RECORD_MESG_ENHANCED_SPEED,
        RECORD_MESG_ENHANCED_ALTITUDE,
        RECORD_MESG_BATTERY_SOC,
        RECORD_MESG_MOTOR_POWER,
        RECORD_MESG_VERTICAL_RATIO,
        RECORD_MESG_STANCE_TIME_BALANCE,
        RECORD_MESG_STEP_LENGTH,
        RECORD_MESG_CYCLE_LENGTH16,
        RECORD_MESG_ABSOLUTE_PRESSURE,
        RECORD_MESG_DEPTH,
        RECORD_MESG_NEXT_STOP_DEPTH,
        RECORD_MESG_NEXT_STOP_TIME,
        RECORD_MESG_TIME_TO_SURFACE,
        RECORD_MESG_NDL_TIME,
        RECORD_MESG_CNS_LOAD,
        RECORD_MESG_N2_LOAD,
        RECORD_MESG_RESPIRATION_RATE,
        RECORD_MESG_ENHANCED_RESPIRATION_RATE,
        RECORD_MESG_GRIT,
        RECORD_MESG_FLOW,
        RECORD_MESG_CURRENT_STRESS,
        RECORD_MESG_EBIKE_TRAVEL_RANGE,
        RECORD_MESG_EBIKE_BATTERY_LEVEL,
        RECORD_MESG_EBIKE_ASSIST_MODE,
        RECORD_MESG_EBIKE_ASSIST_LEVEL_PERCENT,
        RECORD_MESG_AIR_TIME_REMAINING,
        RECORD_MESG_PRESSURE_SAC,
        RECORD_MESG_VOLUME_SAC,
        RECORD_MESG_RMV,
        RECORD_MESG_ASCENT_RATE,
        RECORD_MESG_PO2,
        RECORD_MESG_CORE_TEMPERATURE,
        RECORD_MESG_FIELDS
    } RECORD_MESG_FIELD_INDEX;

    typedef enum
    {
        EVENT_MESG_TIMESTAMP,
        EVENT_MESG_EVENT,
        EVENT_MESG_EVENT_TYPE,
        EVENT_MESG_DATA16,
        EVENT_MESG_DATA,
        EVENT_MESG_EVENT_GROUP,
        EVENT_MESG_SCORE,
        EVENT_MESG_OPPONENT_SCORE,
        EVENT_MESG_FRONT_GEAR_NUM,
        EVENT_MESG_FRONT_GEAR,
        EVENT_MESG_REAR_GEAR_NUM,
        EVENT_MESG_REAR_GEAR,
        EVENT_MESG_DEVICE_INDEX,
        EVENT_MESG_ACTIVITY_TYPE,
        EVENT_MESG_START_TIMESTAMP,
        EVENT_MESG_RADAR_THREAT_LEVEL_MAX,
        EVENT_MESG_RADAR_THREAT_COUNT,
        EVENT_MESG_RADAR_THREAT_AVG_APPROACH_SPEED,
        EVENT_MESG_RADAR_THREAT_MAX_APPROACH_SPEED,
        EVENT_MESG_FIELDS
    } EVENT_MESG_FIELD_INDEX;

    typedef enum
    {
        EVENT_MESG_DATA_FIELD_TIMER_TRIGGER,
        EVENT_MESG_DATA_FIELD_COURSE_POINT_INDEX,
        EVENT_MESG_DATA_FIELD_BATTERY_LEVEL,
        EVENT_MESG_DATA_FIELD_VIRTUAL_PARTNER_SPEED,
        EVENT_MESG_DATA_FIELD_HR_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_HR_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_SPEED_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_SPEED_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_CAD_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_CAD_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_POWER_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_POWER_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_TIME_DURATION_ALERT,
        EVENT_MESG_DATA_FIELD_DISTANCE_DURATION_ALERT,
        EVENT_MESG_DATA_FIELD_CALORIE_DURATION_ALERT,
        EVENT_MESG_DATA_FIELD_FITNESS_EQUIPMENT_STATE,
        EVENT_MESG_DATA_FIELD_SPORT_POINT,
        EVENT_MESG_DATA_FIELD_GEAR_CHANGE_DATA,
        EVENT_MESG_DATA_FIELD_RIDER_POSITION,
        EVENT_MESG_DATA_FIELD_COMM_TIMEOUT,
        EVENT_MESG_DATA_FIELD_DIVE_ALERT,
        EVENT_MESG_DATA_FIELD_AUTO_ACTIVITY_DETECT_DURATION,
        EVENT_MESG_DATA_FIELD_RADAR_THREAT_ALERT,
        EVENT_MESG_DATA_FIELD_SUBFIELDS,
        EVENT_MESG_DATA_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        EVENT_MESG_DATA_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } EVENT_MESG_DATA_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        EVENT_MESG_START_TIMESTAMP_FIELD_AUTO_ACTIVITY_DETECT_START_TIMESTAMP,
        EVENT_MESG_START_TIMESTAMP_FIELD_SUBFIELDS,
        EVENT_MESG_START_TIMESTAMP_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        EVENT_MESG_START_TIMESTAMP_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } EVENT_MESG_START_TIMESTAMP_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        DEVICE_INFO_MESG_TIMESTAMP,
        DEVICE_INFO_MESG_DEVICE_INDEX,
        DEVICE_INFO_MESG_DEVICE_TYPE,
        DEVICE_INFO_MESG_MANUFACTURER,
        DEVICE_INFO_MESG_SERIAL_NUMBER,
        DEVICE_INFO_MESG_PRODUCT,
        DEVICE_INFO_MESG_SOFTWARE_VERSION,
        DEVICE_INFO_MESG_HARDWARE_VERSION,
        DEVICE_INFO_MESG_CUM_OPERATING_TIME,
        DEVICE_INFO_MESG_BATTERY_VOLTAGE,
        DEVICE_INFO_MESG_BATTERY_STATUS,
        DEVICE_INFO_MESG_SENSOR_POSITION,
        DEVICE_INFO_MESG_DESCRIPTOR,
        DEVICE_INFO_MESG_ANT_TRANSMISSION_TYPE,
        DEVICE_INFO_MESG_ANT_DEVICE_NUMBER,
        DEVICE_INFO_MESG_ANT_NETWORK,
        DEVICE_INFO_MESG_SOURCE_TYPE,
        DEVICE_INFO_MESG_PRODUCT_NAME,
        DEVICE_INFO_MESG_BATTERY_LEVEL,
        DEVICE_INFO_MESG_FIELDS
    } DEVICE_INFO_MESG_FIELD_INDEX;

    typedef enum
    {
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_BLE_DEVICE_TYPE,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_ANTPLUS_DEVICE_TYPE,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_ANT_DEVICE_TYPE,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_LOCAL_DEVICE_TYPE,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_SUBFIELDS,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        DEVICE_INFO_MESG_PRODUCT_FIELD_FAVERO_PRODUCT,
        DEVICE_INFO_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        DEVICE_INFO_MESG_PRODUCT_FIELD_SUBFIELDS,
        DEVICE_INFO_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        DEVICE_INFO_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } DEVICE_INFO_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        DEVICE_AUX_BATTERY_INFO_MESG_TIMESTAMP,
        DEVICE_AUX_BATTERY_INFO_MESG_DEVICE_INDEX,
        DEVICE_AUX_BATTERY_INFO_MESG_BATTERY_VOLTAGE,
        DEVICE_AUX_BATTERY_INFO_MESG_BATTERY_STATUS,
        DEVICE_AUX_BATTERY_INFO_MESG_BATTERY_IDENTIFIER,
        DEVICE_AUX_BATTERY_INFO_MESG_FIELDS
    } DEVICE_AUX_BATTERY_INFO_MESG_FIELD_INDEX;

    typedef enum
    {
        TRAINING_FILE_MESG_TIMESTAMP,
        TRAINING_FILE_MESG_TYPE,
        TRAINING_FILE_MESG_MANUFACTURER,
        TRAINING_FILE_MESG_PRODUCT,
        TRAINING_FILE_MESG_SERIAL_NUMBER,
        TRAINING_FILE_MESG_TIME_CREATED,
        TRAINING_FILE_MESG_FIELDS
    } TRAINING_FILE_MESG_FIELD_INDEX;

    typedef enum
    {
        TRAINING_FILE_MESG_PRODUCT_FIELD_FAVERO_PRODUCT,
        TRAINING_FILE_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        TRAINING_FILE_MESG_PRODUCT_FIELD_SUBFIELDS,
        TRAINING_FILE_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        TRAINING_FILE_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } TRAINING_FILE_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WEATHER_CONDITIONS_MESG_TIMESTAMP,
        WEATHER_CONDITIONS_MESG_WEATHER_REPORT,
        WEATHER_CONDITIONS_MESG_TEMPERATURE,
        WEATHER_CONDITIONS_MESG_CONDITION,
        WEATHER_CONDITIONS_MESG_WIND_DIRECTION,
        WEATHER_CONDITIONS_MESG_WIND_SPEED,
        WEATHER_CONDITIONS_MESG_PRECIPITATION_PROBABILITY,
        WEATHER_CONDITIONS_MESG_TEMPERATURE_FEELS_LIKE,
        WEATHER_CONDITIONS_MESG_RELATIVE_HUMIDITY,
        WEATHER_CONDITIONS_MESG_LOCATION,
        WEATHER_CONDITIONS_MESG_OBSERVED_AT_TIME,
        WEATHER_CONDITIONS_MESG_OBSERVED_LOCATION_LAT,
        WEATHER_CONDITIONS_MESG_OBSERVED_LOCATION_LONG,
        WEATHER_CONDITIONS_MESG_DAY_OF_WEEK,
        WEATHER_CONDITIONS_MESG_HIGH_TEMPERATURE,
        WEATHER_CONDITIONS_MESG_LOW_TEMPERATURE,
        WEATHER_CONDITIONS_MESG_FIELDS
    } WEATHER_CONDITIONS_MESG_FIELD_INDEX;

    typedef enum
    {
        WEATHER_ALERT_MESG_TIMESTAMP,
        WEATHER_ALERT_MESG_REPORT_ID,
        WEATHER_ALERT_MESG_ISSUE_TIME,
        WEATHER_ALERT_MESG_EXPIRE_TIME,
        WEATHER_ALERT_MESG_SEVERITY,
        WEATHER_ALERT_MESG_TYPE,
        WEATHER_ALERT_MESG_FIELDS
    } WEATHER_ALERT_MESG_FIELD_INDEX;

    typedef enum
    {
        GPS_METADATA_MESG_TIMESTAMP,
        GPS_METADATA_MESG_TIMESTAMP_MS,
        GPS_METADATA_MESG_POSITION_LAT,
        GPS_METADATA_MESG_POSITION_LONG,
        GPS_METADATA_MESG_ENHANCED_ALTITUDE,
        GPS_METADATA_MESG_ENHANCED_SPEED,
        GPS_METADATA_MESG_HEADING,
        GPS_METADATA_MESG_UTC_TIMESTAMP,
        GPS_METADATA_MESG_VELOCITY,
        GPS_METADATA_MESG_FIELDS
    } GPS_METADATA_MESG_FIELD_INDEX;

    typedef enum
    {
        CAMERA_EVENT_MESG_TIMESTAMP,
        CAMERA_EVENT_MESG_TIMESTAMP_MS,
        CAMERA_EVENT_MESG_CAMERA_EVENT_TYPE,
        CAMERA_EVENT_MESG_CAMERA_FILE_UUID,
        CAMERA_EVENT_MESG_CAMERA_ORIENTATION,
        CAMERA_EVENT_MESG_FIELDS
    } CAMERA_EVENT_MESG_FIELD_INDEX;

    typedef enum
    {
        GYROSCOPE_DATA_MESG_TIMESTAMP,
        GYROSCOPE_DATA_MESG_TIMESTAMP_MS,
        GYROSCOPE_DATA_MESG_SAMPLE_TIME_OFFSET,
        GYROSCOPE_DATA_MESG_GYRO_X,
        GYROSCOPE_DATA_MESG_GYRO_Y,
        GYROSCOPE_DATA_MESG_GYRO_Z,
        GYROSCOPE_DATA_MESG_CALIBRATED_GYRO_X,
        GYROSCOPE_DATA_MESG_CALIBRATED_GYRO_Y,
        GYROSCOPE_DATA_MESG_CALIBRATED_GYRO_Z,
        GYROSCOPE_DATA_MESG_FIELDS
    } GYROSCOPE_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        ACCELEROMETER_DATA_MESG_TIMESTAMP,
        ACCELEROMETER_DATA_MESG_TIMESTAMP_MS,
        ACCELEROMETER_DATA_MESG_SAMPLE_TIME_OFFSET,
        ACCELEROMETER_DATA_MESG_ACCEL_X,
        ACCELEROMETER_DATA_MESG_ACCEL_Y,
        ACCELEROMETER_DATA_MESG_ACCEL_Z,
        ACCELEROMETER_DATA_MESG_CALIBRATED_ACCEL_X,
        ACCELEROMETER_DATA_MESG_CALIBRATED_ACCEL_Y,
        ACCELEROMETER_DATA_MESG_CALIBRATED_ACCEL_Z,
        ACCELEROMETER_DATA_MESG_COMPRESSED_CALIBRATED_ACCEL_X,
        ACCELEROMETER_DATA_MESG_COMPRESSED_CALIBRATED_ACCEL_Y,
        ACCELEROMETER_DATA_MESG_COMPRESSED_CALIBRATED_ACCEL_Z,
        ACCELEROMETER_DATA_MESG_FIELDS
    } ACCELEROMETER_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        MAGNETOMETER_DATA_MESG_TIMESTAMP,
        MAGNETOMETER_DATA_MESG_TIMESTAMP_MS,
        MAGNETOMETER_DATA_MESG_SAMPLE_TIME_OFFSET,
        MAGNETOMETER_DATA_MESG_MAG_X,
        MAGNETOMETER_DATA_MESG_MAG_Y,
        MAGNETOMETER_DATA_MESG_MAG_Z,
        MAGNETOMETER_DATA_MESG_CALIBRATED_MAG_X,
        MAGNETOMETER_DATA_MESG_CALIBRATED_MAG_Y,
        MAGNETOMETER_DATA_MESG_CALIBRATED_MAG_Z,
        MAGNETOMETER_DATA_MESG_FIELDS
    } MAGNETOMETER_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        BAROMETER_DATA_MESG_TIMESTAMP,
        BAROMETER_DATA_MESG_TIMESTAMP_MS,
        BAROMETER_DATA_MESG_SAMPLE_TIME_OFFSET,
        BAROMETER_DATA_MESG_BARO_PRES,
        BAROMETER_DATA_MESG_FIELDS
    } BAROMETER_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        THREE_D_SENSOR_CALIBRATION_MESG_TIMESTAMP,
        THREE_D_SENSOR_CALIBRATION_MESG_SENSOR_TYPE,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_DIVISOR,
        THREE_D_SENSOR_CALIBRATION_MESG_LEVEL_SHIFT,
        THREE_D_SENSOR_CALIBRATION_MESG_OFFSET_CAL,
        THREE_D_SENSOR_CALIBRATION_MESG_ORIENTATION_MATRIX,
        THREE_D_SENSOR_CALIBRATION_MESG_FIELDS
    } THREE_D_SENSOR_CALIBRATION_MESG_FIELD_INDEX;

    typedef enum
    {
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_ACCEL_CAL_FACTOR,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_GYRO_CAL_FACTOR,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_SUBFIELDS,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        ONE_D_SENSOR_CALIBRATION_MESG_TIMESTAMP,
        ONE_D_SENSOR_CALIBRATION_MESG_SENSOR_TYPE,
        ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR,
        ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_DIVISOR,
        ONE_D_SENSOR_CALIBRATION_MESG_LEVEL_SHIFT,
        ONE_D_SENSOR_CALIBRATION_MESG_OFFSET_CAL,
        ONE_D_SENSOR_CALIBRATION_MESG_FIELDS
    } ONE_D_SENSOR_CALIBRATION_MESG_FIELD_INDEX;

    typedef enum
    {
        ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_BARO_CAL_FACTOR,
        ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_SUBFIELDS,
        ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } ONE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        VIDEO_FRAME_MESG_TIMESTAMP,
        VIDEO_FRAME_MESG_TIMESTAMP_MS,
        VIDEO_FRAME_MESG_FRAME_NUMBER,
        VIDEO_FRAME_MESG_FIELDS
    } VIDEO_FRAME_MESG_FIELD_INDEX;

    typedef enum
    {
        OBDII_DATA_MESG_TIMESTAMP,
        OBDII_DATA_MESG_TIMESTAMP_MS,
        OBDII_DATA_MESG_TIME_OFFSET,
        OBDII_DATA_MESG_PID,
        OBDII_DATA_MESG_RAW_DATA,
        OBDII_DATA_MESG_PID_DATA_SIZE,
        OBDII_DATA_MESG_SYSTEM_TIME,
        OBDII_DATA_MESG_START_TIMESTAMP,
        OBDII_DATA_MESG_START_TIMESTAMP_MS,
        OBDII_DATA_MESG_FIELDS
    } OBDII_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        NMEA_SENTENCE_MESG_TIMESTAMP,
        NMEA_SENTENCE_MESG_TIMESTAMP_MS,
        NMEA_SENTENCE_MESG_SENTENCE,
        NMEA_SENTENCE_MESG_FIELDS
    } NMEA_SENTENCE_MESG_FIELD_INDEX;

    typedef enum
    {
        AVIATION_ATTITUDE_MESG_TIMESTAMP,
        AVIATION_ATTITUDE_MESG_TIMESTAMP_MS,
        AVIATION_ATTITUDE_MESG_SYSTEM_TIME,
        AVIATION_ATTITUDE_MESG_PITCH,
        AVIATION_ATTITUDE_MESG_ROLL,
        AVIATION_ATTITUDE_MESG_ACCEL_LATERAL,
        AVIATION_ATTITUDE_MESG_ACCEL_NORMAL,
        AVIATION_ATTITUDE_MESG_TURN_RATE,
        AVIATION_ATTITUDE_MESG_STAGE,
        AVIATION_ATTITUDE_MESG_ATTITUDE_STAGE_COMPLETE,
        AVIATION_ATTITUDE_MESG_TRACK,
        AVIATION_ATTITUDE_MESG_VALIDITY,
        AVIATION_ATTITUDE_MESG_FIELDS
    } AVIATION_ATTITUDE_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_MESG_URL,
        VIDEO_MESG_HOSTING_PROVIDER,
        VIDEO_MESG_DURATION,
        VIDEO_MESG_FIELDS
    } VIDEO_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_TITLE_MESG_MESSAGE_INDEX,
        VIDEO_TITLE_MESG_MESSAGE_COUNT,
        VIDEO_TITLE_MESG_TEXT,
        VIDEO_TITLE_MESG_FIELDS
    } VIDEO_TITLE_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_DESCRIPTION_MESG_MESSAGE_INDEX,
        VIDEO_DESCRIPTION_MESG_MESSAGE_COUNT,
        VIDEO_DESCRIPTION_MESG_TEXT,
        VIDEO_DESCRIPTION_MESG_FIELDS
    } VIDEO_DESCRIPTION_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_CLIP_MESG_CLIP_NUMBER,
        VIDEO_CLIP_MESG_START_TIMESTAMP,
        VIDEO_CLIP_MESG_START_TIMESTAMP_MS,
        VIDEO_CLIP_MESG_END_TIMESTAMP,
        VIDEO_CLIP_MESG_END_TIMESTAMP_MS,
        VIDEO_CLIP_MESG_CLIP_START,
        VIDEO_CLIP_MESG_CLIP_END,
        VIDEO_CLIP_MESG_FIELDS
    } VIDEO_CLIP_MESG_FIELD_INDEX;

    typedef enum
    {
        SET_MESG_TIMESTAMP,
        SET_MESG_DURATION,
        SET_MESG_REPETITIONS,
        SET_MESG_WEIGHT,
        SET_MESG_SET_TYPE,
        SET_MESG_START_TIME,
        SET_MESG_CATEGORY,
        SET_MESG_CATEGORY_SUBTYPE,
        SET_MESG_WEIGHT_DISPLAY_UNIT,
        SET_MESG_MESSAGE_INDEX,
        SET_MESG_WKT_STEP_INDEX,
        SET_MESG_FIELDS
    } SET_MESG_FIELD_INDEX;

    typedef enum
    {
        JUMP_MESG_TIMESTAMP,
        JUMP_MESG_DISTANCE,
        JUMP_MESG_HEIGHT,
        JUMP_MESG_ROTATIONS,
        JUMP_MESG_HANG_TIME,
        JUMP_MESG_SCORE,
        JUMP_MESG_POSITION_LAT,
        JUMP_MESG_POSITION_LONG,
        JUMP_MESG_SPEED,
        JUMP_MESG_ENHANCED_SPEED,
        JUMP_MESG_FIELDS
    } JUMP_MESG_FIELD_INDEX;

    typedef enum
    {
        SPLIT_MESG_MESSAGE_INDEX,
        SPLIT_MESG_SPLIT_TYPE,
        SPLIT_MESG_TOTAL_ELAPSED_TIME,
        SPLIT_MESG_TOTAL_TIMER_TIME,
        SPLIT_MESG_TOTAL_DISTANCE,
        SPLIT_MESG_AVG_SPEED,
        SPLIT_MESG_START_TIME,
        SPLIT_MESG_TOTAL_ASCENT,
        SPLIT_MESG_TOTAL_DESCENT,
        SPLIT_MESG_START_POSITION_LAT,
        SPLIT_MESG_START_POSITION_LONG,
        SPLIT_MESG_END_POSITION_LAT,
        SPLIT_MESG_END_POSITION_LONG,
        SPLIT_MESG_MAX_SPEED,
        SPLIT_MESG_AVG_VERT_SPEED,
        SPLIT_MESG_END_TIME,
        SPLIT_MESG_TOTAL_CALORIES,
        SPLIT_MESG_START_ELEVATION,
        SPLIT_MESG_TOTAL_MOVING_TIME,
        SPLIT_MESG_FIELDS
    } SPLIT_MESG_FIELD_INDEX;

    typedef enum
    {
        SPLIT_SUMMARY_MESG_MESSAGE_INDEX,
        SPLIT_SUMMARY_MESG_SPLIT_TYPE,
        SPLIT_SUMMARY_MESG_NUM_SPLITS,
        SPLIT_SUMMARY_MESG_TOTAL_TIMER_TIME,
        SPLIT_SUMMARY_MESG_TOTAL_DISTANCE,
        SPLIT_SUMMARY_MESG_AVG_SPEED,
        SPLIT_SUMMARY_MESG_MAX_SPEED,
        SPLIT_SUMMARY_MESG_TOTAL_ASCENT,
        SPLIT_SUMMARY_MESG_TOTAL_DESCENT,
        SPLIT_SUMMARY_MESG_AVG_HEART_RATE,
        SPLIT_SUMMARY_MESG_MAX_HEART_RATE,
        SPLIT_SUMMARY_MESG_AVG_VERT_SPEED,
        SPLIT_SUMMARY_MESG_TOTAL_CALORIES,
        SPLIT_SUMMARY_MESG_TOTAL_MOVING_TIME,
        SPLIT_SUMMARY_MESG_FIELDS
    } SPLIT_SUMMARY_MESG_FIELD_INDEX;

    typedef enum
    {
        CLIMB_PRO_MESG_TIMESTAMP,
        CLIMB_PRO_MESG_POSITION_LAT,
        CLIMB_PRO_MESG_POSITION_LONG,
        CLIMB_PRO_MESG_CLIMB_PRO_EVENT,
        CLIMB_PRO_MESG_CLIMB_NUMBER,
        CLIMB_PRO_MESG_CLIMB_CATEGORY,
        CLIMB_PRO_MESG_CURRENT_DIST,
        CLIMB_PRO_MESG_FIELDS
    } CLIMB_PRO_MESG_FIELD_INDEX;

    typedef enum
    {
        FIELD_DESCRIPTION_MESG_DEVELOPER_DATA_INDEX,
        FIELD_DESCRIPTION_MESG_FIELD_DEFINITION_NUMBER,
        FIELD_DESCRIPTION_MESG_FIT_BASE_TYPE_ID,
        FIELD_DESCRIPTION_MESG_FIELD_NAME,
        FIELD_DESCRIPTION_MESG_ARRAY,
        FIELD_DESCRIPTION_MESG_COMPONENTS,
        FIELD_DESCRIPTION_MESG_SCALE,
        FIELD_DESCRIPTION_MESG_OFFSET,
        FIELD_DESCRIPTION_MESG_UNITS,
        FIELD_DESCRIPTION_MESG_BITS,
        FIELD_DESCRIPTION_MESG_ACCUMULATE,
        FIELD_DESCRIPTION_MESG_FIT_BASE_UNIT_ID,
        FIELD_DESCRIPTION_MESG_NATIVE_MESG_NUM,
        FIELD_DESCRIPTION_MESG_NATIVE_FIELD_NUM,
        FIELD_DESCRIPTION_MESG_FIELDS
    } FIELD_DESCRIPTION_MESG_FIELD_INDEX;

    typedef enum
    {
        DEVELOPER_DATA_ID_MESG_DEVELOPER_ID,
        DEVELOPER_DATA_ID_MESG_APPLICATION_ID,
        DEVELOPER_DATA_ID_MESG_MANUFACTURER_ID,
        DEVELOPER_DATA_ID_MESG_DEVELOPER_DATA_INDEX,
        DEVELOPER_DATA_ID_MESG_APPLICATION_VERSION,
        DEVELOPER_DATA_ID_MESG_FIELDS
    } DEVELOPER_DATA_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        COURSE_MESG_SPORT,
        COURSE_MESG_NAME,
        COURSE_MESG_CAPABILITIES,
        COURSE_MESG_SUB_SPORT,
        COURSE_MESG_FIELDS
    } COURSE_MESG_FIELD_INDEX;

    typedef enum
    {
        COURSE_POINT_MESG_MESSAGE_INDEX,
        COURSE_POINT_MESG_TIMESTAMP,
        COURSE_POINT_MESG_POSITION_LAT,
        COURSE_POINT_MESG_POSITION_LONG,
        COURSE_POINT_MESG_DISTANCE,
        COURSE_POINT_MESG_TYPE,
        COURSE_POINT_MESG_NAME,
        COURSE_POINT_MESG_FAVORITE,
        COURSE_POINT_MESG_FIELDS
    } COURSE_POINT_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_ID_MESG_NAME,
        SEGMENT_ID_MESG_UUID,
        SEGMENT_ID_MESG_SPORT,
        SEGMENT_ID_MESG_ENABLED,
        SEGMENT_ID_MESG_USER_PROFILE_PRIMARY_KEY,
        SEGMENT_ID_MESG_DEVICE_ID,
        SEGMENT_ID_MESG_DEFAULT_RACE_LEADER,
        SEGMENT_ID_MESG_DELETE_STATUS,
        SEGMENT_ID_MESG_SELECTION_TYPE,
        SEGMENT_ID_MESG_FIELDS
    } SEGMENT_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_LEADERBOARD_ENTRY_MESG_MESSAGE_INDEX,
        SEGMENT_LEADERBOARD_ENTRY_MESG_NAME,
        SEGMENT_LEADERBOARD_ENTRY_MESG_TYPE,
        SEGMENT_LEADERBOARD_ENTRY_MESG_GROUP_PRIMARY_KEY,
        SEGMENT_LEADERBOARD_ENTRY_MESG_ACTIVITY_ID,
        SEGMENT_LEADERBOARD_ENTRY_MESG_SEGMENT_TIME,
        SEGMENT_LEADERBOARD_ENTRY_MESG_ACTIVITY_ID_STRING,
        SEGMENT_LEADERBOARD_ENTRY_MESG_FIELDS
    } SEGMENT_LEADERBOARD_ENTRY_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_POINT_MESG_MESSAGE_INDEX,
        SEGMENT_POINT_MESG_POSITION_LAT,
        SEGMENT_POINT_MESG_POSITION_LONG,
        SEGMENT_POINT_MESG_DISTANCE,
        SEGMENT_POINT_MESG_ALTITUDE,
        SEGMENT_POINT_MESG_LEADER_TIME,
        SEGMENT_POINT_MESG_ENHANCED_ALTITUDE,
        SEGMENT_POINT_MESG_FIELDS
    } SEGMENT_POINT_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_LAP_MESG_MESSAGE_INDEX,
        SEGMENT_LAP_MESG_TIMESTAMP,
        SEGMENT_LAP_MESG_EVENT,
        SEGMENT_LAP_MESG_EVENT_TYPE,
        SEGMENT_LAP_MESG_START_TIME,
        SEGMENT_LAP_MESG_START_POSITION_LAT,
        SEGMENT_LAP_MESG_START_POSITION_LONG,
        SEGMENT_LAP_MESG_END_POSITION_LAT,
        SEGMENT_LAP_MESG_END_POSITION_LONG,
        SEGMENT_LAP_MESG_TOTAL_ELAPSED_TIME,
        SEGMENT_LAP_MESG_TOTAL_TIMER_TIME,
        SEGMENT_LAP_MESG_TOTAL_DISTANCE,
        SEGMENT_LAP_MESG_TOTAL_CYCLES,
        SEGMENT_LAP_MESG_TOTAL_CALORIES,
        SEGMENT_LAP_MESG_TOTAL_FAT_CALORIES,
        SEGMENT_LAP_MESG_AVG_SPEED,
        SEGMENT_LAP_MESG_MAX_SPEED,
        SEGMENT_LAP_MESG_AVG_HEART_RATE,
        SEGMENT_LAP_MESG_MAX_HEART_RATE,
        SEGMENT_LAP_MESG_AVG_CADENCE,
        SEGMENT_LAP_MESG_MAX_CADENCE,
        SEGMENT_LAP_MESG_AVG_POWER,
        SEGMENT_LAP_MESG_MAX_POWER,
        SEGMENT_LAP_MESG_TOTAL_ASCENT,
        SEGMENT_LAP_MESG_TOTAL_DESCENT,
        SEGMENT_LAP_MESG_SPORT,
        SEGMENT_LAP_MESG_EVENT_GROUP,
        SEGMENT_LAP_MESG_NEC_LAT,
        SEGMENT_LAP_MESG_NEC_LONG,
        SEGMENT_LAP_MESG_SWC_LAT,
        SEGMENT_LAP_MESG_SWC_LONG,
        SEGMENT_LAP_MESG_NAME,
        SEGMENT_LAP_MESG_NORMALIZED_POWER,
        SEGMENT_LAP_MESG_LEFT_RIGHT_BALANCE,
        SEGMENT_LAP_MESG_SUB_SPORT,
        SEGMENT_LAP_MESG_TOTAL_WORK,
        SEGMENT_LAP_MESG_AVG_ALTITUDE,
        SEGMENT_LAP_MESG_MAX_ALTITUDE,
        SEGMENT_LAP_MESG_GPS_ACCURACY,
        SEGMENT_LAP_MESG_AVG_GRADE,
        SEGMENT_LAP_MESG_AVG_POS_GRADE,
        SEGMENT_LAP_MESG_AVG_NEG_GRADE,
        SEGMENT_LAP_MESG_MAX_POS_GRADE,
        SEGMENT_LAP_MESG_MAX_NEG_GRADE,
        SEGMENT_LAP_MESG_AVG_TEMPERATURE,
        SEGMENT_LAP_MESG_MAX_TEMPERATURE,
        SEGMENT_LAP_MESG_TOTAL_MOVING_TIME,
        SEGMENT_LAP_MESG_AVG_POS_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_AVG_NEG_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_MAX_POS_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_MAX_NEG_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_TIME_IN_HR_ZONE,
        SEGMENT_LAP_MESG_TIME_IN_SPEED_ZONE,
        SEGMENT_LAP_MESG_TIME_IN_CADENCE_ZONE,
        SEGMENT_LAP_MESG_TIME_IN_POWER_ZONE,
        SEGMENT_LAP_MESG_REPETITION_NUM,
        SEGMENT_LAP_MESG_MIN_ALTITUDE,
        SEGMENT_LAP_MESG_MIN_HEART_RATE,
        SEGMENT_LAP_MESG_ACTIVE_TIME,
        SEGMENT_LAP_MESG_WKT_STEP_INDEX,
        SEGMENT_LAP_MESG_SPORT_EVENT,
        SEGMENT_LAP_MESG_AVG_LEFT_TORQUE_EFFECTIVENESS,
        SEGMENT_LAP_MESG_AVG_RIGHT_TORQUE_EFFECTIVENESS,
        SEGMENT_LAP_MESG_AVG_LEFT_PEDAL_SMOOTHNESS,
        SEGMENT_LAP_MESG_AVG_RIGHT_PEDAL_SMOOTHNESS,
        SEGMENT_LAP_MESG_AVG_COMBINED_PEDAL_SMOOTHNESS,
        SEGMENT_LAP_MESG_STATUS,
        SEGMENT_LAP_MESG_UUID,
        SEGMENT_LAP_MESG_AVG_FRACTIONAL_CADENCE,
        SEGMENT_LAP_MESG_MAX_FRACTIONAL_CADENCE,
        SEGMENT_LAP_MESG_TOTAL_FRACTIONAL_CYCLES,
        SEGMENT_LAP_MESG_FRONT_GEAR_SHIFT_COUNT,
        SEGMENT_LAP_MESG_REAR_GEAR_SHIFT_COUNT,
        SEGMENT_LAP_MESG_TIME_STANDING,
        SEGMENT_LAP_MESG_STAND_COUNT,
        SEGMENT_LAP_MESG_AVG_LEFT_PCO,
        SEGMENT_LAP_MESG_AVG_RIGHT_PCO,
        SEGMENT_LAP_MESG_AVG_LEFT_POWER_PHASE,
        SEGMENT_LAP_MESG_AVG_LEFT_POWER_PHASE_PEAK,
        SEGMENT_LAP_MESG_AVG_RIGHT_POWER_PHASE,
        SEGMENT_LAP_MESG_AVG_RIGHT_POWER_PHASE_PEAK,
        SEGMENT_LAP_MESG_AVG_POWER_POSITION,
        SEGMENT_LAP_MESG_MAX_POWER_POSITION,
        SEGMENT_LAP_MESG_AVG_CADENCE_POSITION,
        SEGMENT_LAP_MESG_MAX_CADENCE_POSITION,
        SEGMENT_LAP_MESG_MANUFACTURER,
        SEGMENT_LAP_MESG_TOTAL_GRIT,
        SEGMENT_LAP_MESG_TOTAL_FLOW,
        SEGMENT_LAP_MESG_AVG_GRIT,
        SEGMENT_LAP_MESG_AVG_FLOW,
        SEGMENT_LAP_MESG_TOTAL_FRACTIONAL_ASCENT,
        SEGMENT_LAP_MESG_TOTAL_FRACTIONAL_DESCENT,
        SEGMENT_LAP_MESG_ENHANCED_AVG_ALTITUDE,
        SEGMENT_LAP_MESG_ENHANCED_MAX_ALTITUDE,
        SEGMENT_LAP_MESG_ENHANCED_MIN_ALTITUDE,
        SEGMENT_LAP_MESG_FIELDS
    } SEGMENT_LAP_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES,
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELDS,
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SEGMENT_FILE_MESG_MESSAGE_INDEX,
        SEGMENT_FILE_MESG_FILE_UUID,
        SEGMENT_FILE_MESG_ENABLED,
        SEGMENT_FILE_MESG_USER_PROFILE_PRIMARY_KEY,
        SEGMENT_FILE_MESG_LEADER_TYPE,
        SEGMENT_FILE_MESG_LEADER_GROUP_PRIMARY_KEY,
        SEGMENT_FILE_MESG_LEADER_ACTIVITY_ID,
        SEGMENT_FILE_MESG_LEADER_ACTIVITY_ID_STRING,
        SEGMENT_FILE_MESG_DEFAULT_RACE_LEADER,
        SEGMENT_FILE_MESG_FIELDS
    } SEGMENT_FILE_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_MESG_MESSAGE_INDEX,
        WORKOUT_MESG_SPORT,
        WORKOUT_MESG_CAPABILITIES,
        WORKOUT_MESG_NUM_VALID_STEPS,
        WORKOUT_MESG_WKT_NAME,
        WORKOUT_MESG_SUB_SPORT,
        WORKOUT_MESG_POOL_LENGTH,
        WORKOUT_MESG_POOL_LENGTH_UNIT,
        WORKOUT_MESG_WKT_DESCRIPTION,
        WORKOUT_MESG_FIELDS
    } WORKOUT_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_SESSION_MESG_MESSAGE_INDEX,
        WORKOUT_SESSION_MESG_SPORT,
        WORKOUT_SESSION_MESG_SUB_SPORT,
        WORKOUT_SESSION_MESG_NUM_VALID_STEPS,
        WORKOUT_SESSION_MESG_FIRST_STEP_INDEX,
        WORKOUT_SESSION_MESG_POOL_LENGTH,
        WORKOUT_SESSION_MESG_POOL_LENGTH_UNIT,
        WORKOUT_SESSION_MESG_FIELDS
    } WORKOUT_SESSION_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_MESSAGE_INDEX,
        WORKOUT_STEP_MESG_WKT_STEP_NAME,
        WORKOUT_STEP_MESG_DURATION_TYPE,
        WORKOUT_STEP_MESG_DURATION_VALUE,
        WORKOUT_STEP_MESG_TARGET_TYPE,
        WORKOUT_STEP_MESG_TARGET_VALUE,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH,
        WORKOUT_STEP_MESG_INTENSITY,
        WORKOUT_STEP_MESG_NOTES,
        WORKOUT_STEP_MESG_EQUIPMENT,
        WORKOUT_STEP_MESG_EXERCISE_CATEGORY,
        WORKOUT_STEP_MESG_EXERCISE_NAME,
        WORKOUT_STEP_MESG_EXERCISE_WEIGHT,
        WORKOUT_STEP_MESG_WEIGHT_DISPLAY_UNIT,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_TYPE,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH,
        WORKOUT_STEP_MESG_FIELDS
    } WORKOUT_STEP_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_TIME,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_DISTANCE,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_HR,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_CALORIES,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_STEP,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_POWER,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_REPS,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_SPEED_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_HR_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_CADENCE_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_POWER_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_STEPS,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_TIME,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_DISTANCE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_CALORIES,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_HR,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_POWER,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_STROKE_TYPE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_SPEED_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_HEART_RATE_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_CADENCE_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_POWER_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_SPEED_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_HEART_RATE_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_CADENCE_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_POWER_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_SPEED_ZONE,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_HR_ZONE,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_CADENCE_ZONE,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_POWER_ZONE,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SECONDARY_TARGET_STROKE_TYPE,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_SECONDARY_TARGET_VALUE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_LOW,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_LOW,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_LOW,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SECONDARY_CUSTOM_TARGET_POWER_LOW,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_LOW_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_SPEED_HIGH,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_HEART_RATE_HIGH,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_CADENCE_HIGH,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SECONDARY_CUSTOM_TARGET_POWER_HIGH,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_SECONDARY_CUSTOM_TARGET_VALUE_HIGH_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        EXERCISE_TITLE_MESG_MESSAGE_INDEX,
        EXERCISE_TITLE_MESG_EXERCISE_CATEGORY,
        EXERCISE_TITLE_MESG_EXERCISE_NAME,
        EXERCISE_TITLE_MESG_WKT_STEP_NAME,
        EXERCISE_TITLE_MESG_FIELDS
    } EXERCISE_TITLE_MESG_FIELD_INDEX;

    typedef enum
    {
        SCHEDULE_MESG_MANUFACTURER,
        SCHEDULE_MESG_PRODUCT,
        SCHEDULE_MESG_SERIAL_NUMBER,
        SCHEDULE_MESG_TIME_CREATED,
        SCHEDULE_MESG_COMPLETED,
        SCHEDULE_MESG_TYPE,
        SCHEDULE_MESG_SCHEDULED_TIME,
        SCHEDULE_MESG_FIELDS
    } SCHEDULE_MESG_FIELD_INDEX;

    typedef enum
    {
        SCHEDULE_MESG_PRODUCT_FIELD_FAVERO_PRODUCT,
        SCHEDULE_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        SCHEDULE_MESG_PRODUCT_FIELD_SUBFIELDS,
        SCHEDULE_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SCHEDULE_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SCHEDULE_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        TOTALS_MESG_MESSAGE_INDEX,
        TOTALS_MESG_TIMESTAMP,
        TOTALS_MESG_TIMER_TIME,
        TOTALS_MESG_DISTANCE,
        TOTALS_MESG_CALORIES,
        TOTALS_MESG_SPORT,
        TOTALS_MESG_ELAPSED_TIME,
        TOTALS_MESG_SESSIONS,
        TOTALS_MESG_ACTIVE_TIME,
        TOTALS_MESG_SPORT_INDEX,
        TOTALS_MESG_FIELDS
    } TOTALS_MESG_FIELD_INDEX;

    typedef enum
    {
        WEIGHT_SCALE_MESG_TIMESTAMP,
        WEIGHT_SCALE_MESG_WEIGHT,
        WEIGHT_SCALE_MESG_PERCENT_FAT,
        WEIGHT_SCALE_MESG_PERCENT_HYDRATION,
        WEIGHT_SCALE_MESG_VISCERAL_FAT_MASS,
        WEIGHT_SCALE_MESG_BONE_MASS,
        WEIGHT_SCALE_MESG_MUSCLE_MASS,
        WEIGHT_SCALE_MESG_BASAL_MET,
        WEIGHT_SCALE_MESG_PHYSIQUE_RATING,
        WEIGHT_SCALE_MESG_ACTIVE_MET,
        WEIGHT_SCALE_MESG_METABOLIC_AGE,
        WEIGHT_SCALE_MESG_VISCERAL_FAT_RATING,
        WEIGHT_SCALE_MESG_USER_PROFILE_INDEX,
        WEIGHT_SCALE_MESG_BMI,
        WEIGHT_SCALE_MESG_FIELDS
    } WEIGHT_SCALE_MESG_FIELD_INDEX;

    typedef enum
    {
        BLOOD_PRESSURE_MESG_TIMESTAMP,
        BLOOD_PRESSURE_MESG_SYSTOLIC_PRESSURE,
        BLOOD_PRESSURE_MESG_DIASTOLIC_PRESSURE,
        BLOOD_PRESSURE_MESG_MEAN_ARTERIAL_PRESSURE,
        BLOOD_PRESSURE_MESG_MAP_3_SAMPLE_MEAN,
        BLOOD_PRESSURE_MESG_MAP_MORNING_VALUES,
        BLOOD_PRESSURE_MESG_MAP_EVENING_VALUES,
        BLOOD_PRESSURE_MESG_HEART_RATE,
        BLOOD_PRESSURE_MESG_HEART_RATE_TYPE,
        BLOOD_PRESSURE_MESG_STATUS,
        BLOOD_PRESSURE_MESG_USER_PROFILE_INDEX,
        BLOOD_PRESSURE_MESG_FIELDS
    } BLOOD_PRESSURE_MESG_FIELD_INDEX;

    typedef enum
    {
        MONITORING_INFO_MESG_TIMESTAMP,
        MONITORING_INFO_MESG_LOCAL_TIMESTAMP,
        MONITORING_INFO_MESG_ACTIVITY_TYPE,
        MONITORING_INFO_MESG_CYCLES_TO_DISTANCE,
        MONITORING_INFO_MESG_CYCLES_TO_CALORIES,
        MONITORING_INFO_MESG_RESTING_METABOLIC_RATE,
        MONITORING_INFO_MESG_FIELDS
    } MONITORING_INFO_MESG_FIELD_INDEX;

    typedef enum
    {
        MONITORING_MESG_TIMESTAMP,
        MONITORING_MESG_DEVICE_INDEX,
        MONITORING_MESG_CALORIES,
        MONITORING_MESG_DISTANCE,
        MONITORING_MESG_CYCLES,
        MONITORING_MESG_ACTIVE_TIME,
        MONITORING_MESG_ACTIVITY_TYPE,
        MONITORING_MESG_ACTIVITY_SUBTYPE,
        MONITORING_MESG_ACTIVITY_LEVEL,
        MONITORING_MESG_DISTANCE_16,
        MONITORING_MESG_CYCLES_16,
        MONITORING_MESG_ACTIVE_TIME_16,
        MONITORING_MESG_LOCAL_TIMESTAMP,
        MONITORING_MESG_TEMPERATURE,
        MONITORING_MESG_TEMPERATURE_MIN,
        MONITORING_MESG_TEMPERATURE_MAX,
        MONITORING_MESG_ACTIVITY_TIME,
        MONITORING_MESG_ACTIVE_CALORIES,
        MONITORING_MESG_CURRENT_ACTIVITY_TYPE_INTENSITY,
        MONITORING_MESG_TIMESTAMP_MIN_8,
        MONITORING_MESG_TIMESTAMP_16,
        MONITORING_MESG_HEART_RATE,
        MONITORING_MESG_INTENSITY,
        MONITORING_MESG_DURATION_MIN,
        MONITORING_MESG_DURATION,
        MONITORING_MESG_ASCENT,
        MONITORING_MESG_DESCENT,
        MONITORING_MESG_MODERATE_ACTIVITY_MINUTES,
        MONITORING_MESG_VIGOROUS_ACTIVITY_MINUTES,
        MONITORING_MESG_FIELDS
    } MONITORING_MESG_FIELD_INDEX;

    typedef enum
    {
        MONITORING_MESG_CYCLES_FIELD_STEPS,
        MONITORING_MESG_CYCLES_FIELD_STROKES,
        MONITORING_MESG_CYCLES_FIELD_SUBFIELDS,
        MONITORING_MESG_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        MONITORING_MESG_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } MONITORING_MESG_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        MONITORING_HR_DATA_MESG_TIMESTAMP,
        MONITORING_HR_DATA_MESG_RESTING_HEART_RATE,
        MONITORING_HR_DATA_MESG_CURRENT_DAY_RESTING_HEART_RATE,
        MONITORING_HR_DATA_MESG_FIELDS
    } MONITORING_HR_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        SPO2_DATA_MESG_TIMESTAMP,
        SPO2_DATA_MESG_READING_SPO2,
        SPO2_DATA_MESG_READING_CONFIDENCE,
        SPO2_DATA_MESG_MODE,
        SPO2_DATA_MESG_FIELDS
    } SPO2_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HR_MESG_TIMESTAMP,
        HR_MESG_FRACTIONAL_TIMESTAMP,
        HR_MESG_TIME256,
        HR_MESG_FILTERED_BPM,
        HR_MESG_EVENT_TIMESTAMP,
        HR_MESG_EVENT_TIMESTAMP_12,
        HR_MESG_FIELDS
    } HR_MESG_FIELD_INDEX;

    typedef enum
    {
        STRESS_LEVEL_MESG_STRESS_LEVEL_VALUE,
        STRESS_LEVEL_MESG_STRESS_LEVEL_TIME,
        STRESS_LEVEL_MESG_FIELDS
    } STRESS_LEVEL_MESG_FIELD_INDEX;

    typedef enum
    {
        MAX_MET_DATA_MESG_UPDATE_TIME,
        MAX_MET_DATA_MESG_VO2_MAX,
        MAX_MET_DATA_MESG_SPORT,
        MAX_MET_DATA_MESG_SUB_SPORT,
        MAX_MET_DATA_MESG_MAX_MET_CATEGORY,
        MAX_MET_DATA_MESG_CALIBRATED_DATA,
        MAX_MET_DATA_MESG_HR_SOURCE,
        MAX_MET_DATA_MESG_SPEED_SOURCE,
        MAX_MET_DATA_MESG_FIELDS
    } MAX_MET_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_BODY_BATTERY_DATA_MESG_TIMESTAMP,
        HSA_BODY_BATTERY_DATA_MESG_PROCESSING_INTERVAL,
        HSA_BODY_BATTERY_DATA_MESG_LEVEL,
        HSA_BODY_BATTERY_DATA_MESG_CHARGED,
        HSA_BODY_BATTERY_DATA_MESG_UNCHARGED,
        HSA_BODY_BATTERY_DATA_MESG_FIELDS
    } HSA_BODY_BATTERY_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_EVENT_MESG_TIMESTAMP,
        HSA_EVENT_MESG_EVENT_ID,
        HSA_EVENT_MESG_FIELDS
    } HSA_EVENT_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_ACCELEROMETER_DATA_MESG_TIMESTAMP,
        HSA_ACCELEROMETER_DATA_MESG_TIMESTAMP_MS,
        HSA_ACCELEROMETER_DATA_MESG_SAMPLING_INTERVAL,
        HSA_ACCELEROMETER_DATA_MESG_ACCEL_X,
        HSA_ACCELEROMETER_DATA_MESG_ACCEL_Y,
        HSA_ACCELEROMETER_DATA_MESG_ACCEL_Z,
        HSA_ACCELEROMETER_DATA_MESG_TIMESTAMP_32K,
        HSA_ACCELEROMETER_DATA_MESG_FIELDS
    } HSA_ACCELEROMETER_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_GYROSCOPE_DATA_MESG_TIMESTAMP,
        HSA_GYROSCOPE_DATA_MESG_TIMESTAMP_MS,
        HSA_GYROSCOPE_DATA_MESG_SAMPLING_INTERVAL,
        HSA_GYROSCOPE_DATA_MESG_GYRO_X,
        HSA_GYROSCOPE_DATA_MESG_GYRO_Y,
        HSA_GYROSCOPE_DATA_MESG_GYRO_Z,
        HSA_GYROSCOPE_DATA_MESG_TIMESTAMP_32K,
        HSA_GYROSCOPE_DATA_MESG_FIELDS
    } HSA_GYROSCOPE_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_STEP_DATA_MESG_TIMESTAMP,
        HSA_STEP_DATA_MESG_PROCESSING_INTERVAL,
        HSA_STEP_DATA_MESG_STEPS,
        HSA_STEP_DATA_MESG_FIELDS
    } HSA_STEP_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_SPO2_DATA_MESG_TIMESTAMP,
        HSA_SPO2_DATA_MESG_PROCESSING_INTERVAL,
        HSA_SPO2_DATA_MESG_READING_SPO2,
        HSA_SPO2_DATA_MESG_CONFIDENCE,
        HSA_SPO2_DATA_MESG_FIELDS
    } HSA_SPO2_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_STRESS_DATA_MESG_TIMESTAMP,
        HSA_STRESS_DATA_MESG_PROCESSING_INTERVAL,
        HSA_STRESS_DATA_MESG_STRESS_LEVEL,
        HSA_STRESS_DATA_MESG_FIELDS
    } HSA_STRESS_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_RESPIRATION_DATA_MESG_TIMESTAMP,
        HSA_RESPIRATION_DATA_MESG_PROCESSING_INTERVAL,
        HSA_RESPIRATION_DATA_MESG_RESPIRATION_RATE,
        HSA_RESPIRATION_DATA_MESG_FIELDS
    } HSA_RESPIRATION_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_HEART_RATE_DATA_MESG_TIMESTAMP,
        HSA_HEART_RATE_DATA_MESG_PROCESSING_INTERVAL,
        HSA_HEART_RATE_DATA_MESG_STATUS,
        HSA_HEART_RATE_DATA_MESG_HEART_RATE,
        HSA_HEART_RATE_DATA_MESG_FIELDS
    } HSA_HEART_RATE_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_CONFIGURATION_DATA_MESG_TIMESTAMP,
        HSA_CONFIGURATION_DATA_MESG_DATA,
        HSA_CONFIGURATION_DATA_MESG_DATA_SIZE,
        HSA_CONFIGURATION_DATA_MESG_FIELDS
    } HSA_CONFIGURATION_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        HSA_WRIST_TEMPERATURE_DATA_MESG_TIMESTAMP,
        HSA_WRIST_TEMPERATURE_DATA_MESG_PROCESSING_INTERVAL,
        HSA_WRIST_TEMPERATURE_DATA_MESG_VALUE,
        HSA_WRIST_TEMPERATURE_DATA_MESG_FIELDS
    } HSA_WRIST_TEMPERATURE_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        MEMO_GLOB_MESG_PART_INDEX,
        MEMO_GLOB_MESG_MEMO,
        MEMO_GLOB_MESG_MESG_NUM,
        MEMO_GLOB_MESG_PARENT_INDEX,
        MEMO_GLOB_MESG_FIELD_NUM,
        MEMO_GLOB_MESG_DATA,
        MEMO_GLOB_MESG_FIELDS
    } MEMO_GLOB_MESG_FIELD_INDEX;

    typedef enum
    {
        SLEEP_LEVEL_MESG_TIMESTAMP,
        SLEEP_LEVEL_MESG_SLEEP_LEVEL,
        SLEEP_LEVEL_MESG_FIELDS
    } SLEEP_LEVEL_MESG_FIELD_INDEX;

    typedef enum
    {
        ANT_CHANNEL_ID_MESG_CHANNEL_NUMBER,
        ANT_CHANNEL_ID_MESG_DEVICE_TYPE,
        ANT_CHANNEL_ID_MESG_DEVICE_NUMBER,
        ANT_CHANNEL_ID_MESG_TRANSMISSION_TYPE,
        ANT_CHANNEL_ID_MESG_DEVICE_INDEX,
        ANT_CHANNEL_ID_MESG_FIELDS
    } ANT_CHANNEL_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        ANT_RX_MESG_TIMESTAMP,
        ANT_RX_MESG_FRACTIONAL_TIMESTAMP,
        ANT_RX_MESG_MESG_ID,
        ANT_RX_MESG_MESG_DATA,
        ANT_RX_MESG_CHANNEL_NUMBER,
        ANT_RX_MESG_DATA,
        ANT_RX_MESG_FIELDS
    } ANT_RX_MESG_FIELD_INDEX;

    typedef enum
    {
        ANT_TX_MESG_TIMESTAMP,
        ANT_TX_MESG_FRACTIONAL_TIMESTAMP,
        ANT_TX_MESG_MESG_ID,
        ANT_TX_MESG_MESG_DATA,
        ANT_TX_MESG_CHANNEL_NUMBER,
        ANT_TX_MESG_DATA,
        ANT_TX_MESG_FIELDS
    } ANT_TX_MESG_FIELD_INDEX;

    typedef enum
    {
        EXD_SCREEN_CONFIGURATION_MESG_SCREEN_INDEX,
        EXD_SCREEN_CONFIGURATION_MESG_FIELD_COUNT,
        EXD_SCREEN_CONFIGURATION_MESG_LAYOUT,
        EXD_SCREEN_CONFIGURATION_MESG_SCREEN_ENABLED,
        EXD_SCREEN_CONFIGURATION_MESG_FIELDS
    } EXD_SCREEN_CONFIGURATION_MESG_FIELD_INDEX;

    typedef enum
    {
        EXD_DATA_FIELD_CONFIGURATION_MESG_SCREEN_INDEX,
        EXD_DATA_FIELD_CONFIGURATION_MESG_CONCEPT_FIELD,
        EXD_DATA_FIELD_CONFIGURATION_MESG_FIELD_ID,
        EXD_DATA_FIELD_CONFIGURATION_MESG_CONCEPT_COUNT,
        EXD_DATA_FIELD_CONFIGURATION_MESG_DISPLAY_TYPE,
        EXD_DATA_FIELD_CONFIGURATION_MESG_TITLE,
        EXD_DATA_FIELD_CONFIGURATION_MESG_FIELDS
    } EXD_DATA_FIELD_CONFIGURATION_MESG_FIELD_INDEX;

    typedef enum
    {
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_SCREEN_INDEX,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_CONCEPT_FIELD,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_FIELD_ID,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_CONCEPT_INDEX,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_DATA_PAGE,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_CONCEPT_KEY,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_SCALING,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_DATA_UNITS,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_QUALIFIER,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_DESCRIPTOR,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_IS_SIGNED,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_FIELDS
    } EXD_DATA_CONCEPT_CONFIGURATION_MESG_FIELD_INDEX;

    typedef enum
    {
        DIVE_SUMMARY_MESG_TIMESTAMP,
        DIVE_SUMMARY_MESG_REFERENCE_MESG,
        DIVE_SUMMARY_MESG_REFERENCE_INDEX,
        DIVE_SUMMARY_MESG_AVG_DEPTH,
        DIVE_SUMMARY_MESG_MAX_DEPTH,
        DIVE_SUMMARY_MESG_SURFACE_INTERVAL,
        DIVE_SUMMARY_MESG_START_CNS,
        DIVE_SUMMARY_MESG_END_CNS,
        DIVE_SUMMARY_MESG_START_N2,
        DIVE_SUMMARY_MESG_END_N2,
        DIVE_SUMMARY_MESG_O2_TOXICITY,
        DIVE_SUMMARY_MESG_DIVE_NUMBER,
        DIVE_SUMMARY_MESG_BOTTOM_TIME,
        DIVE_SUMMARY_MESG_AVG_PRESSURE_SAC,
        DIVE_SUMMARY_MESG_AVG_VOLUME_SAC,
        DIVE_SUMMARY_MESG_AVG_RMV,
        DIVE_SUMMARY_MESG_DESCENT_TIME,
        DIVE_SUMMARY_MESG_ASCENT_TIME,
        DIVE_SUMMARY_MESG_AVG_ASCENT_RATE,
        DIVE_SUMMARY_MESG_AVG_DESCENT_RATE,
        DIVE_SUMMARY_MESG_MAX_ASCENT_RATE,
        DIVE_SUMMARY_MESG_MAX_DESCENT_RATE,
        DIVE_SUMMARY_MESG_HANG_TIME,
        DIVE_SUMMARY_MESG_FIELDS
    } DIVE_SUMMARY_MESG_FIELD_INDEX;

    typedef enum
    {
        AAD_ACCEL_FEATURES_MESG_TIMESTAMP,
        AAD_ACCEL_FEATURES_MESG_TIME,
        AAD_ACCEL_FEATURES_MESG_ENERGY_TOTAL,
        AAD_ACCEL_FEATURES_MESG_ZERO_CROSS_CNT,
        AAD_ACCEL_FEATURES_MESG_INSTANCE,
        AAD_ACCEL_FEATURES_MESG_TIME_ABOVE_THRESHOLD,
        AAD_ACCEL_FEATURES_MESG_FIELDS
    } AAD_ACCEL_FEATURES_MESG_FIELD_INDEX;

    typedef enum
    {
        HRV_MESG_TIME,
        HRV_MESG_FIELDS
    } HRV_MESG_FIELD_INDEX;

    typedef enum
    {
        BEAT_INTERVALS_MESG_TIMESTAMP,
        BEAT_INTERVALS_MESG_TIMESTAMP_MS,
        BEAT_INTERVALS_MESG_TIME,
        BEAT_INTERVALS_MESG_FIELDS
    } BEAT_INTERVALS_MESG_FIELD_INDEX;

    typedef enum
    {
        HRV_STATUS_SUMMARY_MESG_TIMESTAMP,
        HRV_STATUS_SUMMARY_MESG_WEEKLY_AVERAGE,
        HRV_STATUS_SUMMARY_MESG_LAST_NIGHT_AVERAGE,
        HRV_STATUS_SUMMARY_MESG_LAST_NIGHT_5_MIN_HIGH,
        HRV_STATUS_SUMMARY_MESG_BASELINE_LOW_UPPER,
        HRV_STATUS_SUMMARY_MESG_BASELINE_BALANCED_LOWER,
        HRV_STATUS_SUMMARY_MESG_BASELINE_BALANCED_UPPER,
        HRV_STATUS_SUMMARY_MESG_STATUS,
        HRV_STATUS_SUMMARY_MESG_FIELDS
    } HRV_STATUS_SUMMARY_MESG_FIELD_INDEX;

    typedef enum
    {
        HRV_VALUE_MESG_TIMESTAMP,
        HRV_VALUE_MESG_VALUE,
        HRV_VALUE_MESG_FIELDS
    } HRV_VALUE_MESG_FIELD_INDEX;

    typedef enum
    {
        RAW_BBI_MESG_TIMESTAMP,
        RAW_BBI_MESG_TIMESTAMP_MS,
        RAW_BBI_MESG_DATA,
        RAW_BBI_MESG_TIME,
        RAW_BBI_MESG_QUALITY,
        RAW_BBI_MESG_GAP,
        RAW_BBI_MESG_FIELDS
    } RAW_BBI_MESG_FIELD_INDEX;

    typedef enum
    {
        RESPIRATION_RATE_MESG_TIMESTAMP,
        RESPIRATION_RATE_MESG_RESPIRATION_RATE,
        RESPIRATION_RATE_MESG_FIELDS
    } RESPIRATION_RATE_MESG_FIELD_INDEX;

    typedef enum
    {
        CHRONO_SHOT_SESSION_MESG_TIMESTAMP,
        CHRONO_SHOT_SESSION_MESG_MIN_SPEED,
        CHRONO_SHOT_SESSION_MESG_MAX_SPEED,
        CHRONO_SHOT_SESSION_MESG_AVG_SPEED,
        CHRONO_SHOT_SESSION_MESG_SHOT_COUNT,
        CHRONO_SHOT_SESSION_MESG_PROJECTILE_TYPE,
        CHRONO_SHOT_SESSION_MESG_GRAIN_WEIGHT,
        CHRONO_SHOT_SESSION_MESG_STANDARD_DEVIATION,
        CHRONO_SHOT_SESSION_MESG_FIELDS
    } CHRONO_SHOT_SESSION_MESG_FIELD_INDEX;

    typedef enum
    {
        CHRONO_SHOT_DATA_MESG_TIMESTAMP,
        CHRONO_SHOT_DATA_MESG_SHOT_SPEED,
        CHRONO_SHOT_DATA_MESG_SHOT_NUM,
        CHRONO_SHOT_DATA_MESG_FIELDS
    } CHRONO_SHOT_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        TANK_UPDATE_MESG_TIMESTAMP,
        TANK_UPDATE_MESG_SENSOR,
        TANK_UPDATE_MESG_PRESSURE,
        TANK_UPDATE_MESG_FIELDS
    } TANK_UPDATE_MESG_FIELD_INDEX;

    typedef enum
    {
        TANK_SUMMARY_MESG_TIMESTAMP,
        TANK_SUMMARY_MESG_SENSOR,
        TANK_SUMMARY_MESG_START_PRESSURE,
        TANK_SUMMARY_MESG_END_PRESSURE,
        TANK_SUMMARY_MESG_VOLUME_USED,
        TANK_SUMMARY_MESG_FIELDS
    } TANK_SUMMARY_MESG_FIELD_INDEX;

    typedef enum
    {
        SLEEP_ASSESSMENT_MESG_COMBINED_AWAKE_SCORE,
        SLEEP_ASSESSMENT_MESG_AWAKE_TIME_SCORE,
        SLEEP_ASSESSMENT_MESG_AWAKENINGS_COUNT_SCORE,
        SLEEP_ASSESSMENT_MESG_DEEP_SLEEP_SCORE,
        SLEEP_ASSESSMENT_MESG_SLEEP_DURATION_SCORE,
        SLEEP_ASSESSMENT_MESG_LIGHT_SLEEP_SCORE,
        SLEEP_ASSESSMENT_MESG_OVERALL_SLEEP_SCORE,
        SLEEP_ASSESSMENT_MESG_SLEEP_QUALITY_SCORE,
        SLEEP_ASSESSMENT_MESG_SLEEP_RECOVERY_SCORE,
        SLEEP_ASSESSMENT_MESG_REM_SLEEP_SCORE,
        SLEEP_ASSESSMENT_MESG_SLEEP_RESTLESSNESS_SCORE,
        SLEEP_ASSESSMENT_MESG_AWAKENINGS_COUNT,
        SLEEP_ASSESSMENT_MESG_INTERRUPTIONS_SCORE,
        SLEEP_ASSESSMENT_MESG_AVERAGE_STRESS_DURING_SLEEP,
        SLEEP_ASSESSMENT_MESG_FIELDS
    } SLEEP_ASSESSMENT_MESG_FIELD_INDEX;

    typedef enum
    {
        SKIN_TEMP_OVERNIGHT_MESG_TIMESTAMP,
        SKIN_TEMP_OVERNIGHT_MESG_LOCAL_TIMESTAMP,
        SKIN_TEMP_OVERNIGHT_MESG_AVERAGE_DEVIATION,
        SKIN_TEMP_OVERNIGHT_MESG_AVERAGE_7_DAY_DEVIATION,
        SKIN_TEMP_OVERNIGHT_MESG_NIGHTLY_VALUE,
        SKIN_TEMP_OVERNIGHT_MESG_FIELDS
    } SKIN_TEMP_OVERNIGHT_MESG_FIELD_INDEX;

    typedef enum
    {
        PAD_MESG_FIELDS
    } PAD_MESG_FIELD_INDEX;

    typedef struct
    {
        FIT_FLOAT64 scale;
        FIT_FLOAT64 offset;
        FIT_UINT8 num;
        FIT_UINT8 bits;
        FIT_BOOL accumulate;
    } FIELD_COMPONENT;

    typedef struct
    {
        FIT_SINT32 refFieldValue;
        FIT_UINT8 refFieldNum;
    } SUBFIELD_MAP;

    typedef struct
    {
        const SUBFIELD_MAP* maps;
        const FIELD_COMPONENT* components;
        std::string name;
        std::string units;
        FIT_FLOAT64 scale;
        FIT_FLOAT64 offset;
        FIT_UINT8 numMaps;
        FIT_UINT16 numComponents;
        FIT_UINT8 type;
    } SUBFIELD;

    typedef struct
    {
        const FIELD_COMPONENT* components;
        const SUBFIELD* subFields;
        std::string name;
        std::string units;
        FIT_FLOAT64 scale;
        FIT_FLOAT64 offset;
        FIT_UINT16 numComponents;
        FIT_UINT16 numSubFields;
        FIT_UINT8 num;
        FIT_UINT8 type;
        FIT_BOOL isAccumulated;
        Type profileType;
    } FIELD;

    typedef struct
    {
        const FIELD* fields;
        std::string name;
        FIT_UINT16 num;
        FIT_UINT16 numFields;
    } MESG;

    static const MESG mesgs[MESGS];

    static const Profile::MESG* GetMesg(const FIT_UINT16 num);
    static const Profile::MESG* GetMesg(const std::string& name);
    static const FIT_UINT16 GetFieldIndex(const FIT_UINT16 mesgNum, const FIT_UINT8 fieldNum);
    static const FIT_UINT16 GetFieldIndex(const std::string& mesgName, const std::string& fieldName);
    static const Profile::FIELD* GetField(const FIT_UINT16 mesgNum, const FIT_UINT8 fieldNum);
    static const Profile::FIELD* GetField(const std::string& mesgName, const std::string& fieldName);
    static const FIT_UINT16 GetSubFieldIndex(const std::string& mesgName, const std::string& fieldName, const std::string& subFieldName);
    static const Profile::SUBFIELD* GetSubField(const FIT_UINT16 mesgNum, const FIT_UINT8 fieldNum, const FIT_UINT16 subFieldIndex);
    static const Profile::SUBFIELD* GetSubField(const std::string& mesgName, const std::string& fieldName, const std::string& subFieldName);
};

} // namespace fit

#endif // !defined(FIT_PROFILE_HPP)
