# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import ConsumptionManagementClientConfiguration
from .operations import (
    AggregatedCostOperations,
    BalancesOperations,
    BudgetsOperations,
    ChargesOperations,
    CreditsOperations,
    EventsOperations,
    LotsOperations,
    MarketplacesOperations,
    Operations,
    PriceSheetOperations,
    ReservationRecommendationDetailsOperations,
    ReservationRecommendationsOperations,
    ReservationTransactionsOperations,
    ReservationsDetailsOperations,
    ReservationsSummariesOperations,
    TagsOperations,
    UsageDetailsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class ConsumptionManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Consumption management client provides access to consumption resources for Azure Enterprise
    Subscriptions.

    :ivar usage_details: UsageDetailsOperations operations
    :vartype usage_details: azure.mgmt.consumption.aio.operations.UsageDetailsOperations
    :ivar marketplaces: MarketplacesOperations operations
    :vartype marketplaces: azure.mgmt.consumption.aio.operations.MarketplacesOperations
    :ivar budgets: BudgetsOperations operations
    :vartype budgets: azure.mgmt.consumption.aio.operations.BudgetsOperations
    :ivar tags: TagsOperations operations
    :vartype tags: azure.mgmt.consumption.aio.operations.TagsOperations
    :ivar charges: ChargesOperations operations
    :vartype charges: azure.mgmt.consumption.aio.operations.ChargesOperations
    :ivar balances: BalancesOperations operations
    :vartype balances: azure.mgmt.consumption.aio.operations.BalancesOperations
    :ivar reservations_summaries: ReservationsSummariesOperations operations
    :vartype reservations_summaries:
     azure.mgmt.consumption.aio.operations.ReservationsSummariesOperations
    :ivar reservations_details: ReservationsDetailsOperations operations
    :vartype reservations_details:
     azure.mgmt.consumption.aio.operations.ReservationsDetailsOperations
    :ivar reservation_recommendations: ReservationRecommendationsOperations operations
    :vartype reservation_recommendations:
     azure.mgmt.consumption.aio.operations.ReservationRecommendationsOperations
    :ivar reservation_recommendation_details: ReservationRecommendationDetailsOperations operations
    :vartype reservation_recommendation_details:
     azure.mgmt.consumption.aio.operations.ReservationRecommendationDetailsOperations
    :ivar reservation_transactions: ReservationTransactionsOperations operations
    :vartype reservation_transactions:
     azure.mgmt.consumption.aio.operations.ReservationTransactionsOperations
    :ivar price_sheet: PriceSheetOperations operations
    :vartype price_sheet: azure.mgmt.consumption.aio.operations.PriceSheetOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.consumption.aio.operations.Operations
    :ivar aggregated_cost: AggregatedCostOperations operations
    :vartype aggregated_cost: azure.mgmt.consumption.aio.operations.AggregatedCostOperations
    :ivar events: EventsOperations operations
    :vartype events: azure.mgmt.consumption.aio.operations.EventsOperations
    :ivar lots: LotsOperations operations
    :vartype lots: azure.mgmt.consumption.aio.operations.LotsOperations
    :ivar credits: CreditsOperations operations
    :vartype credits: azure.mgmt.consumption.aio.operations.CreditsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure Subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-10-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = ConsumptionManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.usage_details = UsageDetailsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.marketplaces = MarketplacesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.budgets = BudgetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tags = TagsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.charges = ChargesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.balances = BalancesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.reservations_summaries = ReservationsSummariesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reservations_details = ReservationsDetailsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reservation_recommendations = ReservationRecommendationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reservation_recommendation_details = ReservationRecommendationDetailsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.reservation_transactions = ReservationTransactionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.price_sheet = PriceSheetOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.aggregated_cost = AggregatedCostOperations(self._client, self._config, self._serialize, self._deserialize)
        self.events = EventsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.lots = LotsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.credits = CreditsOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ConsumptionManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
