---
id: fast-foundation.slider
title: Slider class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Slider](./fast-foundation.slider.md)

## Slider class

A Slider Custom HTML Element. Implements the [ARIA slider](https://www.w3.org/TR/wai-aria-1.1/#slider)<!-- -->.


track - The track of the slider


track-start - The track-start visual indicator


thumb - The slider thumb


- The default slot for labels


positioning-region - The region used to position the elements of the slider


track-container - The region containing the track elements


track-start - The element wrapping the track start slot


thumb-container - The thumb container element which is programatically positioned


change - Fires a custom 'change' event when the slider value changes

<b>Signature:</b>

```typescript
export declare class Slider extends FormAssociatedSlider implements SliderConfiguration 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [keypressHandler](./fast-foundation.slider.keypresshandler.md) |  | (e: KeyboardEvent) =&gt; void |  |
|  [max](./fast-foundation.slider.max.md) |  | number | The maximum allowed value. |
|  [min](./fast-foundation.slider.min.md) |  | number | The minimum allowed value. |
|  [mode](./fast-foundation.slider.mode.md) |  | [SliderMode](./fast-foundation.slidermode.md) | The selection mode. |
|  [orientation](./fast-foundation.slider.orientation.md) |  | Orientation | The orientation of the slider. |
|  [readOnly](./fast-foundation.slider.readonly.md) |  | boolean | When true, the control will be immutable by user interaction. See [readonly HTML attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/readonly) for more information. |
|  [step](./fast-foundation.slider.step.md) |  | number | Value to increment or decrement via arrow keys, mouse click or drag. |
|  [valueAsNumber](./fast-foundation.slider.valueasnumber.md) |  | number | The value property, typed as a number. |
|  [valueTextFormatter](./fast-foundation.slider.valuetextformatter.md) |  | (value: string) =&gt; string \| null | Custom function that generates a string for the component's "aria-valuetext" attribute based on the current value. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [decrement()](./fast-foundation.slider.decrement.md) |  | Decrement the value by the step |
|  [increment()](./fast-foundation.slider.increment.md) |  | Increment the value by the step |
