/* main.c -- program entry point of FAXDVI.

   Copyright (C) 1994 Ralph Schleicher  */

/* This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include <getopt.h>
#include "extern.h"


char *prog_name = 0;

char *fax_num = 0;
char *fax_prog = 0;

static struct option options[] =
  {
    {"number", required_argument, 0, 'n'},
    {"execute", required_argument, 0, 'x'},
    {"version", no_argument, 0, 'V'},
    {"help", no_argument, 0, '?'},
    {0, 0, 0, 0},
  };


int
DEFUN (main, (ac, av),
int ac AND
char **av)
{
  int c, i;

  prog_name = av[0];

  fax_prog = getenv ("FAXDVI");
  if (!fax_prog)
    fax_prog = FAX_PROG;

  for (opterr = 0; ; )
    {
      c = getopt_long (ac, av, "n:x:V", options, &i);
      if (c == -1)
	break;
      switch (c)
	{
	case 'n':
	  fax_num = optarg; break;
	case 'x':
	  fax_prog = optarg; break;
	case 'V':
	  version (); exit (0);
	default:
	  usage (); exit (1);
	}
    }

  av += optind;
  ac -= optind;

  for (; *av; ++av)
    {
      read_dvi (*av);
      send_fax ();
    }

  exit (0);
}
