
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file MetgramGraphAttributes.h
    \\brief Definition of MetgramGraph Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MetgramGraphAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

MetgramGraphAttributes::MetgramGraphAttributes():
	
	style_(MagTranslator<string, MetgramStyle>().magics("metgram_plot_style"))
	
{
}


MetgramGraphAttributes::~MetgramGraphAttributes()
{

}


void MetgramGraphAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "metgram";
	
	
	setMember(prefix, "metgram_plot_style", style_, params);
	
}

void MetgramGraphAttributes::copy(const MetgramGraphAttributes& other)
{
	style_ = unique_ptr<MetgramStyle>(other.style_->clone());
	
}


bool MetgramGraphAttributes::accept(const string& node)
{

	if ( magCompare(node, "metgraph")  )
		return true;
	if ( acceptNode(node, style_) )
		return true;
	
	return false;
}

void MetgramGraphAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "metgraph")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), style_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), style_, *elt);
		
	}
}

void MetgramGraphAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " style = " <<  *style_;
	
	out << "]" << "\n";
}

void MetgramGraphAttributes::toxml(ostream& out)  const
{
	out <<  "\"metgraph\"";
	out << ", \"metgram_plot_style\":";
	style_->toxml(out);
	
}

static MagicsParameter<string> metgram_plot_style("metgram_plot_style", "curve");
#include "MetgramStyle.h"
static SimpleObjectMaker<MetgramBar , MetgramStyle> bar_MetgramBar("bar");
static SimpleObjectMaker<MetgramFlags , MetgramStyle> flags_MetgramFlags("flags");
static SimpleObjectMaker<MetgramCurve , MetgramStyle> curve_MetgramCurve("curve");
