
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BarAttributes.h
    \\brief Definition of Bar Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "BarWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



BarWrapper::BarWrapper(): bar_(new Bar())


{


	
	GraphWrapper::object(bar_);
	

}
BarWrapper::BarWrapper(Bar* bar): bar_(bar)
{

	
	GraphWrapper::object(bar_);
	
}

BarWrapper::~BarWrapper()
{

}

void BarWrapper::set(const MagRequest& request)
{

	

	GraphWrapper::set(request);
	

	if  (request.countValues("GRAPH_BAR_ORIENTATION") ) {
		string orientation_value = request("GRAPH_BAR_ORIENTATION");
		bar_->orientation_ = orientation_value;
		}
	if  (request.countValues("GRAPH_BAR_WIDTH") ) {
		double width_value = request("GRAPH_BAR_WIDTH");
		bar_->width_ = width_value;
		}
	if  (request.countValues("GRAPH_BAR_STYLE") ) {
		string bar_style_value = request("GRAPH_BAR_STYLE");
		bar_->bar_style_ = bar_style_value;
		}
	if  (request.countValues("GRAPH_BAR_LINE_THICKNESS") ) {
		int thickness_value = request("GRAPH_BAR_LINE_THICKNESS");
		bar_->thickness_ = thickness_value;
		}
	if  (request.countValues("GRAPH_BAR_CLIPPING") ) {
		string clipping_value = request("GRAPH_BAR_CLIPPING");
		
		bar_->clipping_ = MagTranslator<string, bool>()(clipping_value);
		
		}
	stringarray  annotation_value;
	for (int i = 0; i < request.countValues("GRAPH_BAR_ANNOTATION"); i++)
		annotation_value.push_back((string)request("GRAPH_BAR_ANNOTATION", i));
	if ( !annotation_value.empty() )
		bar_->annotation_ = annotation_value;
	if  (request.countValues("GRAPH_BAR_ANNOTATION_FONT_SIZE") ) {
		double annotation_size_value = request("GRAPH_BAR_ANNOTATION_FONT_SIZE");
		bar_->annotation_size_ = annotation_size_value;
		}
	if  (request.countValues("GRAPH_BAR_MINIMUM_VALUE") ) {
		double min_value_value = request("GRAPH_BAR_MINIMUM_VALUE");
		bar_->min_value_ = min_value_value;
		}
	
	
	if  (request.countValues("GRAPH_BAR_JUSTIFICATION") ) {
		string justification_value = request("GRAPH_BAR_JUSTIFICATION");
		bar_->justification_ = MagTranslator<string, Justification>()(justification_value);
	}
		
	
	if  (request.countValues("GRAPH_BAR_LINE_STYLE") ) {
		string style_value = request("GRAPH_BAR_LINE_STYLE");
		bar_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	if  (request.countValues("GRAPH_BAR_LINE_COLOUR") ) {
		string line_colour_value = request("GRAPH_BAR_LINE_COLOUR");
		bar_->line_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(line_colour_value));
	}
		
	if  (request.countValues("GRAPH_BAR_COLOUR") ) {
		string colour_value = request("GRAPH_BAR_COLOUR");
		bar_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
		string shade_value = request.countValues("GRAPH_SHADE") ?  (string) request("GRAPH_SHADE") : "on";
	MagLog::debug() << " GRAPH_SHADE set to " << shade_value << endl;
	GraphShadeWrapper* shade_wrapper = 0;
	try
	{
		shade_wrapper = SimpleFactory<GraphShadeWrapper>::create(shade_value);
	}
	 catch (NoFactoryException&) {
		if (MagicsGlobal::strict()) {
            throw;
        }
		MagLog::warning() << "[" << shade_value << "] is not a valid value for shade: reset to default -> [on]" << endl;
		shade_wrapper = SimpleFactory<GraphShadeWrapper>::create("on");
	}
	shade_wrapper->set(request);
	bar_->shade_ =  unique_ptr<GraphShade>(shade_wrapper->object());
	delete shade_wrapper;
	if  (request.countValues("GRAPH_BAR_ANNOTATION_FONT_COLOUR") ) {
		string annotation_colour_value = request("GRAPH_BAR_ANNOTATION_FONT_COLOUR");
		bar_->annotation_colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(annotation_colour_value));
	}
		
	
}

void BarWrapper::print(ostream& out)  const
{
	out << "BarWrapper[]";
}






#include "GraphShadeWrapper.h"

static SimpleObjectMaker<GraphShadeWrapper> Bar_graph_shade_shading_Wrapper("shading");


#include "GraphShadeWrapper.h"

static SimpleObjectMaker<GraphShadeWrapper> Bar_graph_shade_on_Wrapper("on");


#include "NoGraphShadeWrapper.h"
static SimpleObjectMaker<NoGraphShade, GraphShade> Bar_graph_shade_noshading ("noshading");
static SimpleObjectMaker<NoGraphShadeWrapper, GraphShadeWrapper> Bar_graph_shade_noshading_wrapper ("noshading");


#include "NoGraphShadeWrapper.h"
static SimpleObjectMaker<NoGraphShade, GraphShade> Bar_graph_shade_off ("off");
static SimpleObjectMaker<NoGraphShadeWrapper, GraphShadeWrapper> Bar_graph_shade_off_wrapper ("off");




