ITK 5.4 Release Candidate 2: Web3 Testing Data
==============================================

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.4 Release Candidate 2 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

🔦 Highlights
-------------------------

ITK 5.4 marks a significant feature update aimed at bolstering the project's long-term **sustainability**. Specifically, this release harnesses the power of [Web3 technology](https://docs.ipfs.tech/concepts/ipfs-solves/#verifiability) to *enhance the process of contributing new data for collaborators, streamline software release management for quicker and more efficient rollouts, and facilitate decentralized, cost-efficient, and redundant data storage for extended distribution purposes*.

Since every local [Git](https://git-scm.com/) repository contains a copy of the entire project history, it is important to avoid adding large binary files directly to the repository. Large binary files added and removed throughout a project's history will cause the repository to become bloated, take up too much disk space, require excessive time and bandwidth to download, etc.

A [solution to this problem](https://docs.ipfs.tech/concepts/ipfs-solves/#verifiability) which has been adopted by ITK is to store binary files, such as images, in a separate location outside the Git repository, then download the files at build time with [CMake](https://cmake.org).

A "content link" file contains an identifying cryptographic hash or [Content Identifier (CID)](https://docs.ipfs.tech/concepts/ipfs-solves/#verifiability). The content link is stored in the Git repository at the path where the file would exist, but with a `.cid` extension appended to the file name. CMake will find these content link files at *build* time, download them from a list of server resources, and create symlinks or copies of the original files at the corresponding location in the *build tree*.

The CID is a self-describing hash following the [multiformats](https://multiformats.io/) standard created by the [InterPlanetary Filesystem (IPFS)](https://ipfs.io/) community. A file with a CID for its filename is content-verifiable. Locating files according to their CID makes content-addressed, as opposed to location-addressed, data exchange possible. This practice is the foundation of the decentralized web, also known as the dWeb or Web3. By adopting Web3, we gain:

- **Permissionless data uploads**
- **Robust, redundant storage**
- **Local and peer-to-peer storage**
- **Scalability**
- **Sustainability**

Contributors to ITK can upload their data through a [simple web app](https://content-link-upload.itk.org), ([alt web3 link](https://content-link-upload.itk.eth.limo/)) that utilizes a free CID pinning service, [web3.storage](https://web3.storage/).

Data used in the ITK Git repository is periodically tracked in a dedicated [Datalad](https://www.datalad.org/) repository, the [ITKData DataLad repository](https://gin.g-node.org/InsightSoftwareConsortium/ITKData/src/main). DataLad is a free and open source, Git-based distributed data management system that keeps track of data, ensures reproducibility, and supports collaboration. *Versioned* testing data trees can be browsed in a natural, nested *directory / file* layout, either via DataLad or IPFS's UnixFS storage.

The tracked data is stored across redundant locations so it can be retrieved from any of the following:

- Local [IPFS](https://ipfs.io/) nodes
- Peer [IPFS](https://ipfs.io/) nodes
- [web3.storage](https://web3.storage/)
- [pinata.cloud](https://pinata.cloud)
- Kitware's IPFS Server
- [ITKTestingData](https://github.com/InsightSoftwareConsortium/ITKTestingData) GitHub Pages CDN
- Kitware's Apache HTTP Server
- Local testing data cache
- Archive tarballs from GitHub Releases

![ITK testing data flow](https://hackmd.io/_uploads/HJNxwrnYp.png)

*Testing data workflow. Testing or example data is uploaded to IPFS via the content-link-upload.itk.org web app. This pins the data on multiple servers across the globe. At release time, the data is also pinned on multiple servers in the USA and France and community pinners. At release time, the data is also stored in the DataLad Git repository, served on an Apache HTTP server, and served on the GitHub Pages CDN. At test time an ITK build can pull the data from a local cache, archive tarball, the Apache HTTP server, GitHub Pages CDN, or multiple IPFS HTTP gateways.*

For more information, see our [testing data documentation](https://docs.itk.org/en/latest/contributing/data.html).

ITK 5.4 contains many additional improvements; highlights can be found below along with a more detailed changelog. For a summary of changes that continues our modern C++ evolution see our [5.4 Release Candidate 1 release notes](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.4rc01).

💾 Download
-------------

**Python Packages**

Install [ITK Python packages](https://docs.itk.org/en/latest/learn/python_quick_start.html) with:

```sh
pip install --upgrade --pre itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4rc02.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/InsightSoftwareGuide-Book1-5.4rc02.pdf)
- [InsightSoftwareGuide-Book2-5.4rc02.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/InsightSoftwareGuide-Book2-5.4rc02.pdf)

**Library Sources**

- [InsightToolkit-5.4rc02.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/InsightToolkit-5.4rc02.tar.gz)
- [InsightToolkit-5.4rc02.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/InsightToolkit-5.4rc02.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4rc02.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/InsightData-5.4rc02.tar.gz)
- [InsightData-5.4rc02.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/InsightData-5.4rc02.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc02/SHA512SUMS)


✨ Features
------------

### Python

- Wrapping for `itk.PhasedArray3DSpecialCoordinatesImage`
- Better support for multi-component images in `image_from_vtk_image`
- `itk.imread` supports a `series_uid` kwarg for DICOM series selection
- TBB version updated to latest stable version, disabled on Intel macOS
- Python binaries for 3.7-3.11 across platforms
- This will be the last release with Python 3.7 suppport
- Remote module GitHub action updated, Python 3.7 is not supported in Remote module builds
- Updated to the latest version of scikit-build

### C++

- C++17 is now required
- Many style improvements for modern C++ and consistency
- GCC 13 support
- Name mangling prefix for third party libraries is configurable
- Update mangled 3rd-parties to use `MANGLE_PREFIX` CMake variable
- Many improvements to code coverage
- Enhanced NRRD and Nifti metadata support
- Apply cmake-format for a consistent CMake style

### Performance

- Use index/point transforms without bounds checking
- Improved SSE2 detection
- Many improvements to how locks are handled

### Documentation

- New GitHub Action to check spelling
- Doxygen formatting cleanup
- Doxygen spelling fixes
- Doxygen Insight Journal links are consistent
- Many Doxygen improvements to the content
- Software Guide updated for style modernization
- Change the Insight Journal handle links to insight-journal links
- Replace `itkTypeMacro` with `itkOverrideGetNameOfClassMacro`

### Remote module updates

Updated modules:
- [BSplineGradient](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient.git)
- [BoneMorphometry](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry.git)
- [Cleaver](https://github.com/SCIInstitute/ITKCleaver.git)
- [Cuberille](https://github.com/InsightSoftwareConsortium/ITKCuberille.git),
- [CudaCommon](https://github.com/RTKConsortium/ITKCudaCommon.git)
- [FPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH.git)
- [GenericLabelInterpolator](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator.git)
- [HASI](https://github.com/KitwareMedical/HASI.git)
- [HigherOrderAccurateGradient](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient.git)
- [IOMeshSTL](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL.git)
- [IOMeshSWC](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC.git)
- [IOScanco](https://github.com/KitwareMedical/ITKIOScanco.git)
- [LabelErodeDilate](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate.git)
- [MeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData.git)
- [MinimalPathExtraction](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction.git)
- [Montage](https://github.com/InsightSoftwareConsortium/ITKMontage.git)
- [MorphologicalContourInterpolation](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation.git)
- [ParabolicMorphology](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology.git)
- [RANSAC](https://github.com/InsightSoftwareConsortium/ITKRANSAC.git)
- [RLEImage](https://github.com/KitwareMedical/ITKRLEImage.git)
- [RTK](https://github.com/RTKConsortium/RTK.git)
- [Shape](https://github.com/SlicerSALT/ITKShape.git)
- [SimpleITKFilters](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters.git)
- [SplitComponents](https://github.com/InsightSoftwareConsortium/ITKSplitComponents.git)
- [Strain](https://github.com/KitwareMedical/ITKStrain.git)
- [TextureFeatures](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures.git)
- [Thickness3D](https://github.com/InsightSoftwareConsortium/ITKThickness3D.git)
- [TubeTK](https://github.com/InsightSoftwareConsortium/ITKTubeTK.git)
- [Ultrasound](https://github.com/KitwareMedical/ITKUltrasound.git)
- [VkFFTBackend](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend.git)
- [WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm.git)


### Third party library updates

- eigen
- gdcm
- googletest
- kwsys
- meta-io
- nifti
- pygccxml
- vxl
- zlib-ng


🙏 Congratulations
------------------------

Congratulations and **thank you** to everyone who contributed to this release.

Of the *43 authors* who contributed since v5.3.0, we would like to specially recognize the new contributors:

*Nicklas Larsson, huangjxbq, Sankhesh Jhaveri, adrinkwater, FabioLolix, Vaibhaw, Ningfei Li, Max Aehle, Noah Egnatis, Federico Zivolo, Patrick Linnane, LAURENDEAU Matthieu, Shreeraj Jadhav, Shengpeng YU, Fernando Bordignon, and Andras Lasso.*

🗣️ What's Next
---------------

Process improvements in this release will ensure more regular and frequent releases in the future. Listening to feedback from the community, we anticipate one additional 5.4 release candidate to enable testing of critical DICOM improvements. Our next release candidate will include improvements based on experiences with 5.4 RC 2. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**

ITK Changes Since v5.4rc01
---------------------------------------------

### Dave Chen (4):

#### Documentation Updates

- Fixed spelling in itkRGBGibbsPriorFilter.h ([a4a46ccf83](https://github.com/InsightSoftwareConsortium/ITK/commit/a4a46ccf83))
- spelling fixes for the new github action ([55b5f46bab](https://github.com/InsightSoftwareConsortium/ITK/commit/55b5f46bab))
- Spell out Computing for the checker ([816d406fbb](https://github.com/InsightSoftwareConsortium/ITK/commit/816d406fbb))

#### Bug Fixes

- Fixed BrainWeb link ([61402981bb](https://github.com/InsightSoftwareConsortium/ITK/commit/61402981bb))


### Dženan Zukić (7):

#### Enhancements

- Add Python wrapping for itk::PhasedArray3DSpecialCoordinatesImage ([4bfe66c762](https://github.com/InsightSoftwareConsortium/ITK/commit/4bfe66c762))
- Better support for multi-component images in image_from_vtk_image ([336be62d3d](https://github.com/InsightSoftwareConsortium/ITK/commit/336be62d3d))
- Improve warning messages (label numbers as ints instead of chars) ([7b74fca444](https://github.com/InsightSoftwareConsortium/ITK/commit/7b74fca444))

#### Performance Improvements

- Use index/point transforms without bounds checking ([6e5ccc7504](https://github.com/InsightSoftwareConsortium/ITK/commit/6e5ccc7504))

#### Documentation Updates

- Move detailed description to the top of class documentation page ([afb5595d8f](https://github.com/InsightSoftwareConsortium/ITK/commit/afb5595d8f))
- Update ITK version mentioned in download.md from 4.13.1 to 5.3.0 ([80446b1c18](https://github.com/InsightSoftwareConsortium/ITK/commit/80446b1c18))

#### Platform Fixes

- Avoid CMake warning caused by feature test ([5bdcb06679](https://github.com/InsightSoftwareConsortium/ITK/commit/5bdcb06679))


### Gabriel A. Devenyi (1):

#### Bug Fixes

- Fix incorrectly specified expected result in itkIOTransformMINCTest.cxx ([279ffc9895](https://github.com/InsightSoftwareConsortium/ITK/commit/279ffc9895))


### Jean-Christophe Fillion-Robin (2):

#### Enhancements

- Update mangled 3rd-parties to use MANGLE_PREFIX CMake variable ([a3afcf6fcd](https://github.com/InsightSoftwareConsortium/ITK/commit/a3afcf6fcd))
- Ensure 3D multi-components conversion in image_from_vtk_image is tested ([abbab61c31](https://github.com/InsightSoftwareConsortium/ITK/commit/abbab61c31))


### Jon Haitz Legarreta Gorroño (104):

#### Enhancements

- Increase coverage for miscellaneous classes ([d6beb524a4](https://github.com/InsightSoftwareConsortium/ITK/commit/d6beb524a4))
- Increase coverage for `RegularStepGradientDescentBaseOptimizer` ([1312fca3d2](https://github.com/InsightSoftwareConsortium/ITK/commit/1312fca3d2))
- Increase `Optimizers` classes coverage: get cost function derivate ([bec6a42b7e](https://github.com/InsightSoftwareConsortium/ITK/commit/bec6a42b7e))
- Increase coverage for miscellaneous classes ([99abf7b89b](https://github.com/InsightSoftwareConsortium/ITK/commit/99abf7b89b))
- Increase coverage for miscellaneous classes ([f7615d27ac](https://github.com/InsightSoftwareConsortium/ITK/commit/f7615d27ac))
- Test the `const` point iterators in `itk::QuadEdgeMeshPolygonCell` ([46c47e08b3](https://github.com/InsightSoftwareConsortium/ITK/commit/46c47e08b3))
- Increase coverage for miscellaneous classes ([fd873b7ecf](https://github.com/InsightSoftwareConsortium/ITK/commit/fd873b7ecf))
- Remove ivar memberless `PrintSelf` implementation ([3a73368734](https://github.com/InsightSoftwareConsortium/ITK/commit/3a73368734))
- Allow `itkCellInterfaceTest` to run as long as possible ([e09713fbe9](https://github.com/InsightSoftwareConsortium/ITK/commit/e09713fbe9))
- Print the superclass object in `itk::MRFImageFilter::PrintSelf` ([a7a8254fe2](https://github.com/InsightSoftwareConsortium/ITK/commit/a7a8254fe2))
- Add boolean macro to `itk::Statistics::Histogram::ClipBinsAtEnds` ([4179d83534](https://github.com/InsightSoftwareConsortium/ITK/commit/4179d83534))
- Use `itkPrintSelfObjectMacro` to print smart pointers ([20225e5b7a](https://github.com/InsightSoftwareConsortium/ITK/commit/20225e5b7a))
- Add getter methods to `itk::RGBGibbsPriorFilter` ivars ([d28311fb8e](https://github.com/InsightSoftwareConsortium/ITK/commit/d28311fb8e))

#### Documentation Updates

- Change the Insight Journal handle links to insight-journal links ([1d4d1ba198](https://github.com/InsightSoftwareConsortium/ITK/commit/1d4d1ba198))
- Remove class self reference in Doxygen `\sa` command ([3ed75247e6](https://github.com/InsightSoftwareConsortium/ITK/commit/3ed75247e6))
- Clean up `itk::ConformalFlatteningMeshFilter` Doxygen documentation ([3a542d0d19](https://github.com/InsightSoftwareConsortium/ITK/commit/3a542d0d19))
- Remove duplicate "type" in alias documentation ([fabc102c52](https://github.com/InsightSoftwareConsortium/ITK/commit/fabc102c52))
- Document miscellaneous cell class methods in header files ([291e618b24](https://github.com/InsightSoftwareConsortium/ITK/commit/291e618b24))
- Avoid documenting ivar default values in SpatialFunction class ([4418b97f56](https://github.com/InsightSoftwareConsortium/ITK/commit/4418b97f56))
- Make the RTTI method documentation consistent in module `Video` ([a22d0a840f](https://github.com/InsightSoftwareConsortium/ITK/commit/a22d0a840f))
- Add a note to the `README` about issues vs. questions ([27f450358c](https://github.com/InsightSoftwareConsortium/ITK/commit/27f450358c))
- Add a note to the first interaction workflow about its nature ([b774fd5358](https://github.com/InsightSoftwareConsortium/ITK/commit/b774fd5358))
- Refer to ITK's discussion space in a consistent manner ([c42a8a7d3f](https://github.com/InsightSoftwareConsortium/ITK/commit/c42a8a7d3f))
- Reword the copyright holder sentence in the code of conduct ([f2cec9b741](https://github.com/InsightSoftwareConsortium/ITK/commit/f2cec9b741))
- Link the Creative Commons license page in the code of conduct ([392b74dd30](https://github.com/InsightSoftwareConsortium/ITK/commit/392b74dd30))
- Improve consistency when referring to the issue tracker in README ([66e933613c](https://github.com/InsightSoftwareConsortium/ITK/commit/66e933613c))
- Fix `MetaDataObject::EncapsulateMetaData` empty return doc warning ([68ab83372a](https://github.com/InsightSoftwareConsortium/ITK/commit/68ab83372a))
- Document `MetaDataObject::EncapsulateMetaData` parameters ([0595670b96](https://github.com/InsightSoftwareConsortium/ITK/commit/0595670b96))
- Document `itk::Indent` class methods in header file only ([3eb8fd7cdf](https://github.com/InsightSoftwareConsortium/ITK/commit/3eb8fd7cdf))
- Improve MINC transform adapter exception message ([a54062d23c](https://github.com/InsightSoftwareConsortium/ITK/commit/a54062d23c))
- Fix typo in `itk::Math` function parameter documentation ([b87ed30059](https://github.com/InsightSoftwareConsortium/ITK/commit/b87ed30059))
- Use Doxygen math syntax for math notation in class documentation ([365c547d9f](https://github.com/InsightSoftwareConsortium/ITK/commit/365c547d9f))
- Document `RGBGibbsPriorFilter` class methods in header file only ([4e5be8334d](https://github.com/InsightSoftwareConsortium/ITK/commit/4e5be8334d))
- Use proper Doxygen documentation style in `RGBGibbsPriorFilter` ([309a0535de](https://github.com/InsightSoftwareConsortium/ITK/commit/309a0535de))
- Improve comments in `itkHistogramTest.cxx` ([657b793d97](https://github.com/InsightSoftwareConsortium/ITK/commit/657b793d97))
- Remove François Budin from GPG key holder ITK maintainer's list ([85072a41ee](https://github.com/InsightSoftwareConsortium/ITK/commit/85072a41ee))
- Remove updating ResearchGate ITK project from release tasks ([4809e93798](https://github.com/InsightSoftwareConsortium/ITK/commit/4809e93798))
- Explain better the release announcement in NumFOCUS newsletter ([39138d78e6](https://github.com/InsightSoftwareConsortium/ITK/commit/39138d78e6))
- Remove unnecessary `ITKIOTransformMINC` `README` files ([89e00d7ac8](https://github.com/InsightSoftwareConsortium/ITK/commit/89e00d7ac8))
- Improve `ITKIOTransformMINC` class documentation ([7caf7e3c70](https://github.com/InsightSoftwareConsortium/ITK/commit/7caf7e3c70))

#### Platform Fixes

- Fix method parameter bound mismatch warning in `itk::VertexCell` ([2338bdc487](https://github.com/InsightSoftwareConsortium/ITK/commit/2338bdc487))
- Fix method parameter bound mismatch warning in misc cell classes ([a66bc7dc48](https://github.com/InsightSoftwareConsortium/ITK/commit/a66bc7dc48))
- Add missing semicolon to macro statement end in tests ([1801209574](https://github.com/InsightSoftwareConsortium/ITK/commit/1801209574))

#### Bug Fixes

- Return exit failure when insufficient test arguments are provided ([3b7078fdb4](https://github.com/InsightSoftwareConsortium/ITK/commit/3b7078fdb4))
- Fix dynamically allocated memory management ([edd6051ae3](https://github.com/InsightSoftwareConsortium/ITK/commit/edd6051ae3))

#### Style Changes

- Increase `itk::LabelStatisticsImageFilter::PrintSelf` consistency ([20124626ae](https://github.com/InsightSoftwareConsortium/ITK/commit/20124626ae))
- Use macros in tests ([84769233ee](https://github.com/InsightSoftwareConsortium/ITK/commit/84769233ee))
- Improve ivar printing style ([4ca8106ef7](https://github.com/InsightSoftwareConsortium/ITK/commit/4ca8106ef7))
- Conform to ITK comment style for within code in OpenCVVideoCapture ([1d4cc7ab36](https://github.com/InsightSoftwareConsortium/ITK/commit/1d4cc7ab36))
- Increase consistency in test argument check message ([3e41b8213d](https://github.com/InsightSoftwareConsortium/ITK/commit/3e41b8213d))
- Honor FastIncrementalBinaryDilateImageFilter class in test name ([ae3ee1de82](https://github.com/InsightSoftwareConsortium/ITK/commit/ae3ee1de82))
- Improve style across miscellaneous tests ([424f25800e](https://github.com/InsightSoftwareConsortium/ITK/commit/424f25800e))
- Conform to ITK SWG style guidelines adding a test ending message ([19ae34f628](https://github.com/InsightSoftwareConsortium/ITK/commit/19ae34f628))
- Conform to ITK style guidelines in miscellaneous test comments ([be8e4f6020](https://github.com/InsightSoftwareConsortium/ITK/commit/be8e4f6020))
- Remove empty comment lines in `itk::TriangleCell` implementation ([16f42267a0](https://github.com/InsightSoftwareConsortium/ITK/commit/16f42267a0))
- Prefer using the `ITK_TRY_EXPECT` macros in test ([eacd1d24fa](https://github.com/InsightSoftwareConsortium/ITK/commit/eacd1d24fa))
- Conform to ITK style guidelines in test ([b3c935159b](https://github.com/InsightSoftwareConsortium/ITK/commit/b3c935159b))
- Conform to ITK SWG style guidelines in test ending message ([5c8f982e34](https://github.com/InsightSoftwareConsortium/ITK/commit/5c8f982e34))
- Use the `itkNameOfTestExecutableMacro` macro in tests ([395c8f44ea](https://github.com/InsightSoftwareConsortium/ITK/commit/395c8f44ea))
- Use exception checking macros in tests ([2038fd7695](https://github.com/InsightSoftwareConsortium/ITK/commit/2038fd7695))
- Remove test input argument checking if no argument is required ([2596ea22b8](https://github.com/InsightSoftwareConsortium/ITK/commit/2596ea22b8))
- Fix ITK coding style inconsistency linter error ([18dd3e693f](https://github.com/InsightSoftwareConsortium/ITK/commit/18dd3e693f))
- Honor the filter name in source code filename ([c3ae51517e](https://github.com/InsightSoftwareConsortium/ITK/commit/c3ae51517e))
- Increase consistency in test argument check message ([5ca4f3b02a](https://github.com/InsightSoftwareConsortium/ITK/commit/5ca4f3b02a))
- Conform to ITK style guidelines in test ending message ([cfb8ae114d](https://github.com/InsightSoftwareConsortium/ITK/commit/cfb8ae114d))
- Conform to ITK comment style for within-code comments (tests) ([35b85b15bf](https://github.com/InsightSoftwareConsortium/ITK/commit/35b85b15bf))
- Remove empty comment lines in tests ([7a316c9c12](https://github.com/InsightSoftwareConsortium/ITK/commit/7a316c9c12))
- Remove uninformative standard output messages in tests ([05a0e03c31](https://github.com/InsightSoftwareConsortium/ITK/commit/05a0e03c31))
- Do not allow lonely std output endl statements in misc tests ([f795943d61](https://github.com/InsightSoftwareConsortium/ITK/commit/f795943d61))
- Improve printed message style across miscellaneous tests ([83c1c48c95](https://github.com/InsightSoftwareConsortium/ITK/commit/83c1c48c95))
- Declare variables close to where they are used in tests ([8a1d3d7420](https://github.com/InsightSoftwareConsortium/ITK/commit/8a1d3d7420))
- Declare and use test image dimensionality as `constexpr` ([8bc48815e5](https://github.com/InsightSoftwareConsortium/ITK/commit/8bc48815e5))
- Do not declare a test status variable that is only used once ([e388b79fdd](https://github.com/InsightSoftwareConsortium/ITK/commit/e388b79fdd))
- Use exception checking macros in itkVectorExpandImageFilterTest ([6e8a2600d1](https://github.com/InsightSoftwareConsortium/ITK/commit/6e8a2600d1))
- Prefer setting the input once all ivars have been set in test ([bb3d6d1696](https://github.com/InsightSoftwareConsortium/ITK/commit/bb3d6d1696))
- Use `ITK_TRY_EXPECT_NO_EXCEPTION` macro in `IOTransformMINC` test ([204d23a7e8](https://github.com/InsightSoftwareConsortium/ITK/commit/204d23a7e8))
- Prefer using `ITK_TEST_EXPECT_EQUAL` lh and rh comparison macro ([56bd332807](https://github.com/InsightSoftwareConsortium/ITK/commit/56bd332807))
- Prefer using `itk::Math::FloatAlmostEqual` in comparisons ([93d3d88c76](https://github.com/InsightSoftwareConsortium/ITK/commit/93d3d88c76))
- Add vertical space for readability in `itkIOTransformMINCTest` ([47df4f3567](https://github.com/InsightSoftwareConsortium/ITK/commit/47df4f3567))
- Use macros in tests ([c313059069](https://github.com/InsightSoftwareConsortium/ITK/commit/c313059069))
- Honor `itk::RGBGibbsPriorFilter` classname in its test filename ([86e2e937c0](https://github.com/InsightSoftwareConsortium/ITK/commit/86e2e937c0))
- Use an unsigned integer to store the number of poles ([6807db4845](https://github.com/InsightSoftwareConsortium/ITK/commit/6807db4845))
- Prefer using setter macro for `itk::RGBGibbsPriorFilter` ivar ([452cb3f971](https://github.com/InsightSoftwareConsortium/ITK/commit/452cb3f971))
- Use standard return codes in example ([2535192fb3](https://github.com/InsightSoftwareConsortium/ITK/commit/2535192fb3))
- Increase consistency in example argument check message ([5707df8d3e](https://github.com/InsightSoftwareConsortium/ITK/commit/5707df8d3e))
- Make non-macro comparison conditional blocks consistent in tests ([67d18e4715](https://github.com/InsightSoftwareConsortium/ITK/commit/67d18e4715))
- Increase consistency in test argument check message ([c2688765c2](https://github.com/InsightSoftwareConsortium/ITK/commit/c2688765c2))
- Conform to ITK style guidelines in test ending message ([dfc9fcd32f](https://github.com/InsightSoftwareConsortium/ITK/commit/dfc9fcd32f))
- Prefer using `constexpr <type>` over `struct` for image dimension ([eaf25ef26b](https://github.com/InsightSoftwareConsortium/ITK/commit/eaf25ef26b))
- Conform to ITK comment style for within-code comments (tests) ([488ac833aa](https://github.com/InsightSoftwareConsortium/ITK/commit/488ac833aa))
- Remove empty comment lines in tests ([e4643c59f0](https://github.com/InsightSoftwareConsortium/ITK/commit/e4643c59f0))
- Remove uninformative standard output message in itkHistogramTest ([41ad697626](https://github.com/InsightSoftwareConsortium/ITK/commit/41ad697626))
- Remove uninformative comments in tests ([b9b530f620](https://github.com/InsightSoftwareConsortium/ITK/commit/b9b530f620))
- Do not allow lonely std output endl statements in misc tests ([f9f3078385](https://github.com/InsightSoftwareConsortium/ITK/commit/f9f3078385))
- Increase consistency in newline character use in tests ([154938d8ca](https://github.com/InsightSoftwareConsortium/ITK/commit/154938d8ca))
- Remove blank lines in excess in miscellaneous tests ([603b67d7b9](https://github.com/InsightSoftwareConsortium/ITK/commit/603b67d7b9))
- Prefer using macros for `itk::SLICImageFilter` basic methods ([df51b3ffa2](https://github.com/InsightSoftwareConsortium/ITK/commit/df51b3ffa2))
- Use standard exit return code in `itk::SLICImagetFilter` test ([8930ed2da3](https://github.com/InsightSoftwareConsortium/ITK/commit/8930ed2da3))
- Conform to ITK SWG style guidelines in test ending message ([d9f0d5e66a](https://github.com/InsightSoftwareConsortium/ITK/commit/d9f0d5e66a))
- Do not use superclass template parameters in `itk::fem` RTTI ([9f1d99077f](https://github.com/InsightSoftwareConsortium/ITK/commit/9f1d99077f))
- Prefer double forward slashes for within-method body comments ([8d3df523ff](https://github.com/InsightSoftwareConsortium/ITK/commit/8d3df523ff))
- Use testing macros in `itkHistogramTest.cxx` ([397278f75f](https://github.com/InsightSoftwareConsortium/ITK/commit/397278f75f))
- Make non-macro comparison blocks consistent in itkHistogramTest ([d6111f2edb](https://github.com/InsightSoftwareConsortium/ITK/commit/d6111f2edb))
- Use `this` to address self methods in `RGBGibbsPriorFilter` ([034cd067bb](https://github.com/InsightSoftwareConsortium/ITK/commit/034cd067bb))


### Matt McCormick (22):

#### Enhancements

- Bump pygccxml to v2.4.0 ([b1f03a845c](https://github.com/InsightSoftwareConsortium/ITK/commit/b1f03a845c))
- Migrate content links from .md5, .sha512 to .cid ([f3899ce8c6](https://github.com/InsightSoftwareConsortium/ITK/commit/f3899ce8c6))
- Add cmake-format config and script ([788fbc4858](https://github.com/InsightSoftwareConsortium/ITK/commit/788fbc4858))
- Remove setup-girder-api-key GitSetup script ([31597d4fac](https://github.com/InsightSoftwareConsortium/ITK/commit/31597d4fac))
- Remove UploadBinaryData.sh script ([2916886bfb](https://github.com/InsightSoftwareConsortium/ITK/commit/2916886bfb))

#### Documentation Updates

- Release documentation updates for ITK 5.4 RC 01 ([779afebce0](https://github.com/InsightSoftwareConsortium/ITK/commit/779afebce0))
- Update testing data upload docs for CID transition ([53fddd33c6](https://github.com/InsightSoftwareConsortium/ITK/commit/53fddd33c6))
- Update .git-blame-ignore-revs for cmake-format, .cid content links ([9442dcdcec](https://github.com/InsightSoftwareConsortium/ITK/commit/9442dcdcec))
- Update content link upload documention in GitCheatSheet.pdf ([caedb38830](https://github.com/InsightSoftwareConsortium/ITK/commit/caedb38830))
- Add Sphinx Documentation rendering ([effb802abd](https://github.com/InsightSoftwareConsortium/ITK/commit/effb802abd))

#### Platform Fixes

- Use full ::itk namespace in itkMacro.h ([7fbe8880a9](https://github.com/InsightSoftwareConsortium/ITK/commit/7fbe8880a9))
- Remove pkg_resources import from base.py ([b31c942bbe](https://github.com/InsightSoftwareConsortium/ITK/commit/b31c942bbe))
- Encode the pygccxml __version__ ([1fec6af521](https://github.com/InsightSoftwareConsortium/ITK/commit/1fec6af521))
- Update w3 gateway CID identification ([d7e6c200e2](https://github.com/InsightSoftwareConsortium/ITK/commit/d7e6c200e2))

#### Bug Fixes

- GetGlobalDefaultSplitter to a global singleton ([94344fd0b5](https://github.com/InsightSoftwareConsortium/ITK/commit/94344fd0b5))
- Update pygccxml source code path in update script ([886b5243b1](https://github.com/InsightSoftwareConsortium/ITK/commit/886b5243b1))
- Fix xarray compute value check ([ff64d3c3ff](https://github.com/InsightSoftwareConsortium/ITK/commit/ff64d3c3ff))
- Remove extra space in CppcheckTargets VERBATIM ([078db2e1bc](https://github.com/InsightSoftwareConsortium/ITK/commit/078db2e1bc))
- Fix ITKGroup identification with multiline itk_module ([6384cd067a](https://github.com/InsightSoftwareConsortium/ITK/commit/6384cd067a))

#### Style Changes

- Separate \ingroup for MultiThreaded with AddImageFilter, PowImageFilter ([1ec8df840a](https://github.com/InsightSoftwareConsortium/ITK/commit/1ec8df840a))
- Initial run of cmake-format ([efa749515d](https://github.com/InsightSoftwareConsortium/ITK/commit/efa749515d))
- Lower case for function name in ITKModuleEnablement ([3568eeec2b](https://github.com/InsightSoftwareConsortium/ITK/commit/3568eeec2b))


### MetaIO Maintainers (1):

#### Miscellaneous Changes

- MetaIO 2023-07-16 (556864f5) ([c42090c681](https://github.com/InsightSoftwareConsortium/ITK/commit/c42090c681))


### Nicklas Larsson (1):

#### Bug Fixes

- define SWIGPY_SLICEOBJECT ([d2361b89fe](https://github.com/InsightSoftwareConsortium/ITK/commit/d2361b89fe))


### Niels Dekker (41):

#### Enhancements

- Add TEST(ObjectFactoryBase, CreatedInstanceHasReferenceCountOfTwo) ([47bcc5081e](https://github.com/InsightSoftwareConsortium/ITK/commit/47bcc5081e))
- Make VectorContainer::size_type public, test nested `vector` types ([dc641cd7d7](https://github.com/InsightSoftwareConsortium/ITK/commit/dc641cd7d7))
- Add `MersenneTwisterRandomVariateGenerator::ResetNextSeed()` ([ecd7bdae82](https://github.com/InsightSoftwareConsortium/ITK/commit/ecd7bdae82))

#### Documentation Updates

- Note that object returned by `CreateInstance` has reference count 2 ([f981aae69d](https://github.com/InsightSoftwareConsortium/ITK/commit/f981aae69d))
- itkGetObjectMacro member functions return a raw (not smart) pointer ([eb97e952c2](https://github.com/InsightSoftwareConsortium/ITK/commit/eb97e952c2))
- Document that `SetGlobalInstance` always returns true ([9da299b85c](https://github.com/InsightSoftwareConsortium/ITK/commit/9da299b85c))

#### Platform Fixes

- Adjust check that all arguments of MakePoint/Vector have same type ([89d3c3c015](https://github.com/InsightSoftwareConsortium/ITK/commit/89d3c3c015))

#### Bug Fixes

- ImageRandomIteratorWithIndex should not assign data in constructor ([997ff54d59](https://github.com/InsightSoftwareConsortium/ITK/commit/997ff54d59))
- Use `lock_guard<mutex>` in FFT configuration to deal with exception ([a00eb3914d](https://github.com/InsightSoftwareConsortium/ITK/commit/a00eb3914d))
- Use `lock_guard<mutex>` in FEMFactoryBase to deal with exception ([c1e15a36d0](https://github.com/InsightSoftwareConsortium/ITK/commit/c1e15a36d0))

#### Style Changes

- Call GetTransformTypeAsString() just once, in `TransformFactory` ([9baa34b699](https://github.com/InsightSoftwareConsortium/ITK/commit/9baa34b699))
- Remove redundant GetPrimaryOutput() calls from `ProcessObject` ([997aa169a2](https://github.com/InsightSoftwareConsortium/ITK/commit/997aa169a2))
- Remove redundant checks in `ProcessObject::VerifyPreconditions()` ([c3ee320bf8](https://github.com/InsightSoftwareConsortium/ITK/commit/c3ee320bf8))
- ImageSourceCommonGlobals default member initializer, Rule of Zero ([c6690b9209](https://github.com/InsightSoftwareConsortium/ITK/commit/c6690b9209))
- Replace `std::unique_lock` with `std::lock_guard` in ThreadPool ([1094cdde9a](https://github.com/InsightSoftwareConsortium/ITK/commit/1094cdde9a))
- Replace std::unique_lock with std::lock_guard in Filter.hxx files ([3335e69433](https://github.com/InsightSoftwareConsortium/ITK/commit/3335e69433))
- Remove duplicate assignment from itkPlatformMultiThreaderPosix ([1dc9deb15c](https://github.com/InsightSoftwareConsortium/ITK/commit/1dc9deb15c))
- Remove unused `threadId`, just pass `nullptr` to `_beginthreadex` ([2ee34dde73](https://github.com/InsightSoftwareConsortium/ITK/commit/2ee34dde73))
- Use `lock_guard<mutex>` in `PlatformMultiThreader` classes ([c4c3710d5f](https://github.com/InsightSoftwareConsortium/ITK/commit/c4c3710d5f))
- Use `lock_guard<mutex>` in PlatformMultiThreader::TerminateThread ([e56c7bdf20](https://github.com/InsightSoftwareConsortium/ITK/commit/e56c7bdf20))
- Use `lock_guard<mutex>` in ParallelSparseFieldLevelSetImageFilter ([5e1f0cf1c0](https://github.com/InsightSoftwareConsortium/ITK/commit/5e1f0cf1c0))
- Use `lock_guard<mutex>` in PDEDeformable Registration classes ([873a724b92](https://github.com/InsightSoftwareConsortium/ITK/commit/873a724b92))
- Replace std::min, std::max in MultiThreaderBase with `std::clamp` ([0c31b223ed](https://github.com/InsightSoftwareConsortium/ITK/commit/0c31b223ed))
- Remove `ITK_X_ASSERT`, just use `assert` in `constexpr` functions ([e888f7bc2d](https://github.com/InsightSoftwareConsortium/ITK/commit/e888f7bc2d))
- Use `insert_or_assign` in SingletonIndex SetGlobalInstancePrivate ([5c14067e53](https://github.com/InsightSoftwareConsortium/ITK/commit/5c14067e53))
- Let `SetGlobalInstancePrivate` return `void`, instead of `true` ([eadc465c3f](https://github.com/InsightSoftwareConsortium/ITK/commit/eadc465c3f))
- Let `Singleton` assume that SetGlobalInstance always returns true ([6ec6328ed2](https://github.com/InsightSoftwareConsortium/ITK/commit/6ec6328ed2))
- SingletonIndex does not need to store the unused `func` parameter ([6d1c4c7ab7](https://github.com/InsightSoftwareConsortium/ITK/commit/6d1c4c7ab7))
- Remove unused parameter from `SetGlobalInstance` and `Singleton` ([8598841db5](https://github.com/InsightSoftwareConsortium/ITK/commit/8598841db5))
- Replace Registration/Metricsv4 "LockPtr" with "MutexPtr" ([8149ba9651](https://github.com/InsightSoftwareConsortium/ITK/commit/8149ba9651))
- Rename private and internal data members from "Lock" to "Mutex" ([0150e46924](https://github.com/InsightSoftwareConsortium/ITK/commit/0150e46924))
- Code cleanup ImageRandomConstIteratorWith(Only)Index RandomJump() ([d92dc14c7f](https://github.com/InsightSoftwareConsortium/ITK/commit/d92dc14c7f))
- Rename local `std::lock_guard` variables "lockGuard" ([04100e62e0](https://github.com/InsightSoftwareConsortium/ITK/commit/04100e62e0))
- Default constructors VectorContainer, Iterator, ConstIterator ([ff47f5cf84](https://github.com/InsightSoftwareConsortium/ITK/commit/ff47f5cf84))
- Remove private ObjectFactoryBase member `InitializeFactoryList()` ([82d7060408](https://github.com/InsightSoftwareConsortium/ITK/commit/82d7060408))
- Replace `std::bind` in ThreadPool::AddWork with lambda expression ([75b99671a8](https://github.com/InsightSoftwareConsortium/ITK/commit/75b99671a8))
- Simply assign factories, in ObjectFactoryBase::RegisterInternal() ([2859d67cda](https://github.com/InsightSoftwareConsortium/ITK/commit/2859d67cda))
- Remove private ObjectFactoryBase member `RegisterInternal()` ([427972e600](https://github.com/InsightSoftwareConsortium/ITK/commit/427972e600))
- Remove lock MersenneTwisterRandomVariateGenerator ResetNextSeed ([1ce107fc42](https://github.com/InsightSoftwareConsortium/ITK/commit/1ce107fc42))
- Disallow copy/move, default constructor `MersenneTwisterGlobals` ([89d4735e05](https://github.com/InsightSoftwareConsortium/ITK/commit/89d4735e05))
- Add using-declaration MersenneTwisterRandomVariateGenerator GTest ([bdcb9e33cb](https://github.com/InsightSoftwareConsortium/ITK/commit/bdcb9e33cb))


### Sean McBride (1):

#### Bug Fixes

- Use atomic bool to fix race found by thread sanitizer ([c3a8eab2ad](https://github.com/InsightSoftwareConsortium/ITK/commit/c3a8eab2ad))


### VXL Maintainers (1):

#### Miscellaneous Changes

- VXL 2023-06-18 (4332fd74) ([9c18c34119](https://github.com/InsightSoftwareConsortium/ITK/commit/9c18c34119))


### Zlib-ng Upstream (2):

#### Miscellaneous Changes

- zlib-ng 2023-06-29 (cf89cf35) ([2ab12b9807](https://github.com/InsightSoftwareConsortium/ITK/commit/2ab12b9807))
- zlib-ng 2023-08-07 (73bbb54c) ([68bc6c994e](https://github.com/InsightSoftwareConsortium/ITK/commit/68bc6c994e))


### pygccxml Upstream (1):

#### Enhancements

- pygccxml v2.4.0 (reduced) ([6637e8709b](https://github.com/InsightSoftwareConsortium/ITK/commit/6637e8709b))




ITK Sphinx Examples Changes Since v5.4rc01
---------------------------------------------

### Matt McCormick (5):

#### Enhancements

- Update to ITK 5.4 RC 01 ([0b4ca644](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0b4ca644))
- Bump ITK to 5.4 Release Candidate 2 ([e404022a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e404022a))
- Add PASS_REGULAR_EXPRESION to ConvertImageWithLabelsToShapeLabelMap ([84fb315d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/84fb315d))

#### Platform Fixes

- pandoc version for docs build ([3370d2ae](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3370d2ae))

#### Bug Fixes

- Disable ConvertImageWithLabelsToShapeLabelMapTest on Windows ([db481ba1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/db481ba1))




ITK Software Guide Changes Since v5.4rc01
---------------------------------------------

### Jon Haitz Legarreta Gorroño (5):

#### Documentation Updates

- Avoid documenting ivar default values ([6a2861a](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6a2861a))
- Avoid using initialization lists in coding style snippets ([35a15c2](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/35a15c2))
- Use non-boolean, built-in type ivars to illustrate `PrintSelf` ([8f61111](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/8f61111))
- Do not encourage using empty comment lines ([278366c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/278366c))

#### Style Changes

- Finish coding style guideline item sentence with period ([14aee41](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/14aee41))


### Matt McCormick (2):

#### Enhancements

- Bump ITK Superbuild version to 5.4 RC 1 ([381c84c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/381c84c))
- Bump ITK Superbuild version to 5.4 RC 2 ([3b541a4](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/3b541a4))


### Niels Dekker (1):

#### Documentation Updates

- Replace `itkTypeMacro` with `itkOverrideGetNameOfClassMacro` ([5428594](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5428594))
