/* util.c	9/11/1995
 */

/* SPDX-FileCopyrightText: 1995,1996 Sascha Demetrio
 * SPDX-FileCopyrightText: 2009, 2015, 2018 Peter Pentchev
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "config.h"

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "buffer.h"
#include "hexer.h"
#include "util.h"
#include "tio.h"

#undef isoct
#undef ishex
#define isoct(x) ((x) >= '0' && (x) < '8')
#define ishex(x) (isdigit(x) || (tolower(x) >= 'a' && tolower(x) <= 'f'))

  int
util_trunc(char *s)
  /* remove trailing whitespace.
   */
{
  int i = strlen(s) - !!*s;

  while (i ? s[i] == ' ' || s[i] == '\t' : 0) --i;
  s[++i] = 0;
  return 0;
}
/* util_trunc */

  static int
util_pstrcmp(char **a, char **b)
{
  return strcmp(*a, *b);
}
/* util_pstrcmp */

  int
util_strsort(char **list)
  /* a simple bubblesort.
   */
{
  int n;

  for (n = 0; list[n]; ++n);
  qsort((void *)list, n, sizeof(char *), (int (*)(const void *, const void *))util_pstrcmp);
  return 0;
}
/* util_strsort */

int
write_buf(const int fd, const char * const buf, const size_t len)
{
  size_t written = 0;

  while (written < len) {
    const size_t n = write(fd, buf + written, len - written);
    if (n < 1)
      return -1;
    written += n;
  }
  return written;
}

/* end of util.c */


/* VIM configuration: (do not delete this line)
 *
 * vim:bk:nodg:efm=%f\:%l\:%m:hid:icon:
 * vim:sw=2:sm:textwidth=79:ul=1024:wrap:
 */
