/*
    Copyright (C) 2010 William Hart
    Copyright (C) 2014 Abhinav Baid

    This file is part of FLINT.

    FLINT is free software: you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.  See <https://www.gnu.org/licenses/>.
*/

#include "test_helpers.h"
#include "d_mat.h"
#include "ulong_extras.h"

TEST_FUNCTION_START(d_mat_init_clear, state)
{
    int i;

    /* check if memory management works properly */
    for (i = 0; i < 1000 * flint_test_multiplier(); i++)
    {
        d_mat_t A;
        slong j, k;
        slong rows = n_randint(state, 100);
        slong cols = n_randint(state, 100);

        d_mat_init(A, rows, cols);

        for (j = 0; j < rows; j++)
            for (k = 0; k < cols; k++)
                d_mat_entry(A, j, k) = 0;

        d_mat_clear(A);
    }

    TEST_FUNCTION_END(state);
}
