/* SPDX-License-Identifier: GPL-2.0-only */

#include <delay.h>
#include <drivers/i2c/tas5825m/tas5825m.h>

static int program_dsp_ram(struct device *dev)
{
	int res;

	res = tas5825m_set_book(dev, 0x64);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x01);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0xFE, 0x00, 0x40, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x50, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00,
			0x00, 0x82, 0x00, 0x93, 0x00, 0xFC, 0x00, 0x00,
			0x84, 0xC1, 0x02, 0x9F, 0x08, 0x18, 0x10, 0x00,
			0x02, 0x28, 0x00, 0x03, 0x8F, 0x00, 0xFF, 0xF8,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x02);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x02, 0x60, 0x00, 0x01, 0x84, 0xA0, 0x02, 0x00,
			0x84, 0x02, 0x04, 0x03, 0x00, 0x26, 0x20, 0x96,
			0x84, 0xA2, 0x04, 0x02, 0x84, 0xC1, 0x02, 0xBC,
			0x84, 0x49, 0x03, 0x64, 0x08, 0xFC, 0x0C, 0x99,
			0x02, 0x70, 0x00, 0x04, 0x84, 0xC1, 0x02, 0xBD,
			0xE0, 0x10, 0x31, 0xAD, 0x84, 0xCA, 0x20, 0xE0,
			0xF0, 0x1C, 0x31, 0xAE, 0xF0, 0x1C, 0x31, 0xAF,
			0x02, 0x68, 0x00, 0x03, 0xF0, 0x1C, 0x31, 0xB0,
			0xF0, 0x1D, 0x31, 0xB1, 0x02, 0x78, 0x00, 0x02,
			0x84, 0x41, 0x03, 0x78, 0x80, 0x27, 0x80, 0xF9,
			0x08, 0xFC, 0x0C, 0x98, 0x84, 0x83, 0x03, 0x6A,
			0xE0, 0x10, 0x11, 0xAD, 0x84, 0xC2, 0x00, 0xE0,
			0xF0, 0x1C, 0x11, 0xAE, 0xF0, 0x1C, 0x11, 0xAF,
			0xF0, 0x1C, 0x11, 0xB0, 0xF0, 0x1D, 0x11, 0xB1,
			0x84, 0x59, 0x03, 0x65, 0x80, 0x27, 0x80, 0xF8,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x03);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x84, 0x83, 0x03, 0x6B, 0xE2, 0x57, 0x91, 0xB2,
			0x84, 0xC1, 0x02, 0xBD, 0x84, 0x82, 0x60, 0xE0,
			0xF0, 0x1C, 0x71, 0xB3, 0xF0, 0x1C, 0x71, 0xB4,
			0xF0, 0x1C, 0x71, 0xB5, 0xF0, 0x1D, 0x71, 0xB6,
			0x84, 0x51, 0x03, 0x79, 0x80, 0x27, 0x80, 0xFB,
			0x84, 0x83, 0x03, 0x6C, 0xE0, 0x10, 0x11, 0xB2,
			0x84, 0xC2, 0x40, 0xE0, 0xF0, 0x1C, 0x51, 0xB3,
			0xF0, 0x1C, 0x51, 0xB4, 0xF0, 0x1C, 0x51, 0xB5,
			0xF0, 0x1D, 0x51, 0xB6, 0x84, 0x4B, 0x03, 0x64,
			0x84, 0x49, 0x03, 0x77, 0x86, 0xA1, 0x01, 0xB7,
			0x84, 0x43, 0x03, 0x78, 0x02, 0x11, 0xFF, 0xFC,
			0x84, 0x41, 0x03, 0x7E, 0x80, 0x27, 0x80, 0xFA,
			0x84, 0x83, 0x03, 0x6D, 0xE2, 0x57, 0x80, 0x00,
			0x84, 0xC1, 0x02, 0xBD, 0x84, 0x82, 0x20, 0xE0,
			0xF0, 0x1C, 0x31, 0xB8, 0xF0, 0x1C, 0x31, 0xB9,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x04);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0xF0, 0x1C, 0x31, 0xBA, 0xF0, 0x1D, 0x31, 0xBB,
			0x86, 0xA1, 0x01, 0xB7, 0x80, 0x27, 0x80, 0xF9,
			0x84, 0x83, 0x03, 0x6E, 0xE0, 0x10, 0x00, 0x00,
			0x84, 0xC2, 0x00, 0xE0, 0xF0, 0x1C, 0x11, 0xB8,
			0xF0, 0x1C, 0x11, 0xB9, 0xF0, 0x1C, 0x11, 0xBA,
			0xF0, 0x1D, 0x11, 0xBB, 0x86, 0xA1, 0x01, 0x9D,
			0x80, 0x27, 0x80, 0xF8, 0x84, 0x83, 0x03, 0x6F,
			0x84, 0x5B, 0x03, 0x65, 0x66, 0x6D, 0x60, 0x00,
			0xEE, 0x64, 0x80, 0x00, 0x02, 0xC3, 0x00, 0x10,
			0x62, 0x6D, 0x40, 0x00, 0xEA, 0x64, 0x60, 0x00,
			0x02, 0xD3, 0x00, 0x10, 0x88, 0x47, 0x00, 0x81,
			0x09, 0x07, 0x08, 0x88, 0x08, 0xFC, 0x28, 0x53,
			0x0D, 0x00, 0x10, 0x18, 0x84, 0xC3, 0x03, 0x24,
			0x08, 0x60, 0x28, 0x50, 0x84, 0x80, 0x04, 0x02,
			0xE4, 0x00, 0x00, 0x80, 0x86, 0xC1, 0x01, 0x9F,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x05);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x88, 0x47, 0x20, 0x81, 0x0D, 0x00, 0x10, 0x20,
			0x84, 0x53, 0x03, 0x79, 0x84, 0x4B, 0x03, 0x77,
			0x84, 0x43, 0x03, 0x7E, 0x00, 0x42, 0x20, 0x85,
			0x84, 0xDB, 0x03, 0x23, 0x08, 0xFC, 0x38, 0x10,
			0x02, 0x48, 0x02, 0xBC, 0x02, 0x40, 0x02, 0xBD,
			0xE4, 0x10, 0x11, 0x9E, 0x00, 0xFE, 0x20, 0x88,
			0x88, 0x6C, 0x00, 0x00, 0x02, 0x48, 0x02, 0xBC,
			0x02, 0x40, 0x02, 0xBD, 0x02, 0x80, 0x00, 0x00,
			0x84, 0xA1, 0x03, 0x6F, 0xE4, 0x00, 0x00, 0x00,
			0x84, 0xA1, 0x03, 0x6E, 0x84, 0xD1, 0x03, 0x6C,
			0xE0, 0x00, 0x00, 0x00, 0xE8, 0x00, 0x00, 0x82,
			0x84, 0xC9, 0x03, 0x6D, 0x88, 0x07, 0x00, 0x80,
			0xEC, 0x00, 0x00, 0x81, 0x10, 0x00, 0x18, 0x01,
			0x88, 0x47, 0x00, 0x80, 0x02, 0x50, 0x02, 0xBC,
			0x00, 0xFE, 0x20, 0x99, 0x0C, 0x20, 0x08, 0x20,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x06);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x02, 0x78, 0x00, 0x02, 0x02, 0x50, 0x02, 0xBC,
			0x02, 0x40, 0x02, 0xBD, 0x02, 0x70, 0x00, 0x06,
			0x84, 0x59, 0x03, 0x4F, 0xE2, 0x57, 0x91, 0xBC,
			0x02, 0xC3, 0x00, 0x10, 0x84, 0xC9, 0x02, 0xBD,
			0x84, 0xC2, 0x60, 0xE0, 0xF0, 0x1C, 0x71, 0xBD,
			0xF0, 0x1C, 0x71, 0xBE, 0x02, 0x68, 0x00, 0x05,
			0xF0, 0x1C, 0x71, 0xBF, 0xF0, 0x1D, 0x71, 0xC0,
			0xE4, 0x00, 0x11, 0xC3, 0x80, 0x27, 0x80, 0xE3,
			0xF4, 0x00, 0x11, 0xC1, 0xF4, 0x1F, 0x71, 0xC2,
			0xF4, 0x1C, 0x71, 0xC4, 0xF4, 0x1D, 0x71, 0xC5,
			0x84, 0x49, 0x03, 0x57, 0x80, 0x67, 0x80, 0xFB,
			0x02, 0xD3, 0x00, 0x10, 0xE0, 0x10, 0x31, 0xBC,
			0x84, 0xCA, 0x20, 0xE0, 0xF0, 0x1C, 0x31, 0xBD,
			0xF0, 0x1C, 0x31, 0xBE, 0xF0, 0x1C, 0x31, 0xBF,
			0xF0, 0x1D, 0x31, 0xC0, 0xE4, 0x00, 0x11, 0xC3,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x07);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x80, 0x27, 0x80, 0xE1, 0xF4, 0x00, 0x11, 0xC1,
			0xF4, 0x1F, 0x31, 0xC2, 0xF4, 0x1C, 0x31, 0xC4,
			0xF4, 0x1D, 0x31, 0xC5, 0x84, 0xC2, 0x04, 0x05,
			0x08, 0xFC, 0x58, 0x10, 0x80, 0x67, 0x80, 0xF9,
			0x02, 0xD3, 0x00, 0x10, 0x84, 0xCA, 0x04, 0x04,
			0x08, 0xFC, 0x58, 0x31, 0x84, 0xCA, 0x04, 0x06,
			0x08, 0x00, 0x0A, 0x21, 0x84, 0xC2, 0x04, 0x07,
			0x08, 0x00, 0x0A, 0x00, 0xE4, 0x10, 0x31, 0xA3,
			0xE0, 0x10, 0x00, 0x00, 0xEA, 0x65, 0x60, 0x00,
			0x02, 0xC3, 0x00, 0x10, 0xEE, 0x65, 0x80, 0x00,
			0x02, 0xCB, 0x00, 0x10, 0x88, 0x47, 0x00, 0x82,
			0x09, 0x07, 0x09, 0x31, 0x08, 0xFC, 0x48, 0x13,
			0x0D, 0x00, 0x10, 0x38, 0x84, 0xCB, 0x03, 0x2C,
			0x08, 0x60, 0x48, 0x11, 0x84, 0x80, 0x04, 0x02,
			0xE4, 0x00, 0x00, 0x81, 0x02, 0x28, 0x00, 0x02,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x08);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x88, 0x67, 0x20, 0x00, 0xE4, 0x00, 0x02, 0x00,
			0x84, 0xDB, 0x03, 0x2B, 0x80, 0x48, 0x00, 0x81,
			0x86, 0xD9, 0x01, 0xA9, 0x86, 0xC1, 0x01, 0xAA,
			0x0D, 0x00, 0x10, 0x38, 0x08, 0xFC, 0x3C, 0x12,
			0x84, 0x5B, 0x03, 0x4F, 0x84, 0x4B, 0x03, 0x57,
			0x84, 0xD2, 0x04, 0x02, 0x00, 0x62, 0x20, 0xE4,
			0x86, 0xD1, 0x01, 0xAC, 0x0D, 0x00, 0x10, 0x20,
			0x86, 0xC9, 0x01, 0xA8, 0x86, 0xC1, 0x01, 0xA7,
			0x00, 0xFE, 0x20, 0xE8, 0x08, 0x44, 0x26, 0x30,
			0x08, 0xFC, 0x3C, 0x71, 0x86, 0xC1, 0x01, 0xA6,
			0x84, 0xCA, 0x04, 0x02, 0x86, 0xD1, 0x01, 0xAB,
			0x84, 0x80, 0x04, 0x02, 0xE4, 0x00, 0x00, 0x80,
			0x88, 0x40, 0x00, 0x80, 0x08, 0xFC, 0x08, 0x50,
			0x02, 0x28, 0x00, 0x01, 0x02, 0xA3, 0x00, 0x18,
			0xE4, 0x40, 0x00, 0x00, 0x88, 0xC8, 0x00, 0x82,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x09);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x84, 0xC9, 0x03, 0x2D, 0x86, 0xC1, 0x01, 0xA5,
			0x86, 0xD9, 0x01, 0xA4, 0x0D, 0x00, 0x10, 0x48,
			0x08, 0x44, 0x06, 0x13, 0x86, 0xC1, 0x01, 0xEF,
			0x84, 0x49, 0x03, 0x37, 0x00, 0xFC, 0x00, 0x00,
			0xE4, 0x10, 0x40, 0x83, 0xEC, 0x10, 0x20, 0x00,
			0x88, 0x47, 0x00, 0x82, 0x04, 0x80, 0xA8, 0xB3,
			0x84, 0x80, 0x04, 0x07, 0xE4, 0x00, 0x00, 0x83,
			0x84, 0xDB, 0x03, 0x2D, 0x88, 0x40, 0x00, 0x83,
			0x10, 0x00, 0x1A, 0x22, 0xE4, 0x80, 0xC0, 0x00,
			0x88, 0x40, 0x00, 0x81, 0x84, 0xD8, 0x04, 0x04,
			0x0C, 0x20, 0x08, 0x39, 0x86, 0xD1, 0x01, 0xF0,
			0x84, 0x81, 0x02, 0xBC, 0x86, 0xC9, 0x01, 0xF1,
			0xE0, 0x00, 0x11, 0xC7, 0x84, 0x82, 0x20, 0xE0,
			0x84, 0x82, 0x04, 0x02, 0xF0, 0x1C, 0x31, 0xC8,
			0xF0, 0x1C, 0x31, 0xC9, 0xF0, 0x1C, 0x31, 0xCA,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0A);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0xF0, 0x1D, 0x31, 0xCB, 0xE4, 0x00, 0x11, 0xCE,
			0x80, 0x27, 0x80, 0xE1, 0xF4, 0x00, 0x11, 0xCC,
			0xF4, 0x1F, 0x31, 0xCD, 0xF4, 0x1C, 0x31, 0xCF,
			0xF4, 0x1D, 0x31, 0xD0, 0x84, 0x41, 0x03, 0x2F,
			0x80, 0x67, 0x80, 0xF9, 0x02, 0xDB, 0x00, 0x10,
			0x8F, 0x30, 0x00, 0x00, 0x0C, 0x1C, 0x11, 0x74,
			0x08, 0x64, 0x66, 0x72, 0x0D, 0x00, 0x10, 0x40,
			0x08, 0x44, 0x06, 0x12, 0x84, 0xD2, 0x41, 0x00,
			0xE0, 0x10, 0x51, 0xD1, 0xF0, 0x1C, 0x11, 0xD2,
			0xF0, 0x1C, 0x11, 0xD3, 0xF0, 0x1C, 0x11, 0xD4,
			0xF0, 0x1D, 0x11, 0xD5, 0xE4, 0x00, 0x11, 0xD8,
			0x80, 0x27, 0x80, 0xE0, 0xF4, 0x00, 0x11, 0xD6,
			0xF4, 0x20, 0x11, 0xD7, 0x84, 0x84, 0x00, 0xF8,
			0xF4, 0x1C, 0x11, 0xD9, 0x84, 0x4B, 0x03, 0x37,
			0xF4, 0x1D, 0x11, 0xDA, 0x84, 0x49, 0x03, 0x5F,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0B);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x80, 0x67, 0x80, 0xF8, 0xE0, 0x00, 0x11, 0xDB,
			0x84, 0x82, 0x21, 0x00, 0x84, 0x82, 0x20, 0xE0,
			0xF0, 0x1C, 0x31, 0xDC, 0xF0, 0x1C, 0x31, 0xDD,
			0xF0, 0x1C, 0x31, 0xDE, 0xF0, 0x1D, 0x31, 0xDF,
			0xE4, 0x00, 0x11, 0xE2, 0x80, 0x27, 0x80, 0xE1,
			0xF4, 0x00, 0x11, 0xE0, 0xF4, 0x1F, 0x31, 0xE1,
			0xF4, 0x1C, 0x31, 0xE3, 0xF4, 0x1D, 0x31, 0xE4,
			0x84, 0x51, 0x03, 0x60, 0x80, 0x67, 0x80, 0xF9,
			0xE4, 0x00, 0x00, 0x81, 0xE0, 0x80, 0x51, 0xE5,
			0x84, 0x82, 0x40, 0xE0, 0xF0, 0x1C, 0x51, 0xE6,
			0xF0, 0x1C, 0x51, 0xE7, 0xF0, 0x1C, 0x51, 0xE8,
			0x88, 0x47, 0x00, 0x80, 0xF0, 0x1D, 0x51, 0xE9,
			0xE4, 0x00, 0x11, 0xEC, 0x80, 0x27, 0x80, 0xE2,
			0xF4, 0x00, 0x11, 0xEA, 0xF4, 0x1F, 0x51, 0xEB,
			0xF4, 0x1C, 0x51, 0xED, 0xF4, 0x1D, 0x51, 0xEE,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0C);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x02, 0x58, 0x02, 0xBC, 0x08, 0xFC, 0x0D, 0x18,
			0x80, 0x67, 0x80, 0xFA, 0x02, 0xD3, 0x00, 0x10,
			0x10, 0x00, 0x18, 0x03, 0x84, 0x43, 0x03, 0x2F,
			0x84, 0x4B, 0x03, 0x5F, 0x84, 0x53, 0x03, 0x60,
			0x84, 0x41, 0x03, 0x47, 0x84, 0x51, 0x03, 0x3F,
			0x84, 0xC1, 0x02, 0xBD, 0x00, 0xFC, 0x00, 0x00,
			0x02, 0x48, 0x02, 0xBD, 0x02, 0x11, 0xFF, 0xF8,
			0x86, 0xD1, 0x01, 0xEF, 0x86, 0xC9, 0x01, 0xF0,
			0x86, 0x1D, 0x01, 0xF1, 0xE0, 0x10, 0x11, 0xC7,
			0x86, 0xA1, 0x01, 0xC8, 0x84, 0xC2, 0x00, 0xE0,
			0xF0, 0x1C, 0x00, 0x00, 0xF0, 0x1C, 0x11, 0xC9,
			0xF0, 0x1C, 0x11, 0xCA, 0xF0, 0x1D, 0x11, 0xCB,
			0xE4, 0x00, 0x11, 0xCE, 0x80, 0x27, 0x80, 0xE0,
			0x84, 0x1E, 0x04, 0x02, 0x02, 0x78, 0x00, 0x02,
			0xF4, 0x00, 0x11, 0xCC, 0xF4, 0x1F, 0x11, 0xCD,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0D);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0xF4, 0x1C, 0x11, 0xCF, 0xF4, 0x1D, 0x11, 0xD0,
			0x86, 0xA1, 0x01, 0xD1, 0x80, 0x67, 0x80, 0xF8,
			0x84, 0x43, 0x03, 0x47, 0x84, 0x59, 0x03, 0x62,
			0x8F, 0xA0, 0x00, 0x00, 0x02, 0xDB, 0x00, 0x10,
			0x0C, 0x1C, 0x51, 0x6C, 0x08, 0x64, 0x66, 0x71,
			0x0D, 0x00, 0x10, 0x30, 0x08, 0x44, 0x46, 0x51,
			0x84, 0xCA, 0x01, 0x00, 0xE0, 0x10, 0x20, 0x00,
			0xF0, 0x1C, 0x51, 0xD2, 0xF0, 0x1C, 0x51, 0xD3,
			0xF0, 0x1C, 0x51, 0xD4, 0xF0, 0x1D, 0x51, 0xD5,
			0xE4, 0x00, 0x11, 0xD8, 0x80, 0x27, 0x80, 0xE2,
			0xF4, 0x00, 0x11, 0xD6, 0xF4, 0x1F, 0x51, 0xD7,
			0xF4, 0x1C, 0x51, 0xD9, 0xF4, 0x1D, 0x51, 0xDA,
			0x84, 0x41, 0x03, 0x61, 0x80, 0x67, 0x80, 0xFA,
			0xE0, 0x00, 0x11, 0xDB, 0x84, 0x82, 0x01, 0x00,
			0x84, 0x82, 0x00, 0xE0, 0xF0, 0x1C, 0x11, 0xDC,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0E);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0xF0, 0x1C, 0x11, 0xDD, 0xF0, 0x1C, 0x11, 0xDE,
			0xF0, 0x1D, 0x11, 0xDF, 0xE4, 0x00, 0x11, 0xE2,
			0x80, 0x27, 0x80, 0xE0, 0xF4, 0x00, 0x11, 0xE0,
			0xF4, 0x1F, 0x11, 0xE1, 0xF4, 0x1C, 0x11, 0xE3,
			0x02, 0x83, 0x00, 0x18, 0x84, 0xC2, 0x60, 0xE0,
			0x86, 0xC1, 0x01, 0xE4, 0xE0, 0x00, 0x11, 0xE5,
			0xF4, 0x1D, 0x00, 0x80, 0x84, 0xA0, 0x04, 0x02,
			0x80, 0x67, 0x80, 0xF8, 0xE4, 0x00, 0x00, 0x00,
			0xF0, 0x1C, 0x71, 0xE6, 0xF0, 0x1C, 0x71, 0xE7,
			0xF0, 0x1C, 0x71, 0xE8, 0xF0, 0x1D, 0x71, 0xE9,
			0x86, 0xA1, 0x01, 0xEC, 0x88, 0x47, 0x00, 0x80,
			0xE4, 0x00, 0x00, 0x00, 0x80, 0x27, 0x80, 0xE3,
			0xF4, 0x00, 0x11, 0xEA, 0xF4, 0x1F, 0x71, 0xEB,
			0xF4, 0x1C, 0x71, 0xED, 0xF4, 0x1D, 0x71, 0xEE,
			0x86, 0xC9, 0x01, 0xA1, 0x80, 0x67, 0x80, 0xFB,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0F);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x84, 0x5B, 0x03, 0x62, 0x08, 0x00, 0x10, 0x20,
			0x02, 0xD3, 0x00, 0x10, 0x84, 0x53, 0x03, 0x3F,
			0x84, 0x43, 0x03, 0x61, 0x08, 0xFC, 0x0D, 0x18,
			0x02, 0x50, 0x02, 0xBD, 0x00, 0x26, 0x21, 0xB7,
			0x10, 0x00, 0x18, 0x01, 0x86, 0xC1, 0x01, 0xC6,
			0x84, 0xC3, 0x03, 0x63, 0x02, 0xC0, 0x03, 0x63,
			0x84, 0x52, 0x04, 0x00, 0x02, 0x48, 0x02, 0xBC,
			0x84, 0xC2, 0x04, 0x01, 0x00, 0xFF, 0x10, 0xB0,
			0x8C, 0xFF, 0x02, 0xBC, 0x00, 0xFE, 0x21, 0xDA,
			0x00, 0xFC, 0x00, 0x00, 0x86, 0xC9, 0x01, 0xA0,
			0x84, 0x81, 0x02, 0xBC, 0x02, 0xA3, 0x00, 0x10,
			0xE4, 0x00, 0x00, 0x00, 0x84, 0x81, 0x02, 0xBD,
			0x88, 0x47, 0x13, 0x25, 0x02, 0xA3, 0x00, 0x10,
			0xE4, 0x00, 0x00, 0x00, 0x88, 0x47, 0x13, 0x26,
			0x02, 0x40, 0x03, 0x28, 0x84, 0xC1, 0x03, 0x25,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x10);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0xFF, 0x11, 0x4E, 0x00, 0xFC, 0x00, 0x00,
			0x02, 0x40, 0x03, 0x29, 0x86, 0xC9, 0x01, 0xA0,
			0x84, 0xC1, 0x03, 0x26, 0x00, 0xFF, 0x11, 0x4E,
			0x00, 0xFC, 0x00, 0x00, 0x86, 0xC1, 0x01, 0xA2,
			0x84, 0xC3, 0x03, 0x2A, 0x02, 0xC0, 0x03, 0x29,
			0x02, 0xC8, 0x03, 0x26, 0x02, 0x40, 0x03, 0x28,
			0x02, 0x48, 0x03, 0x25, 0x02, 0x50, 0x03, 0x2A,
			0x84, 0xC2, 0x04, 0x00, 0x84, 0xCA, 0x04, 0x01,
			0x00, 0xFF, 0x21, 0xDF, 0x00, 0xFC, 0x00, 0x00,
			0x84, 0xA1, 0x02, 0xBC, 0xE6, 0x64, 0xA0, 0x00,
			0x88, 0x47, 0x12, 0xBC, 0x84, 0xA1, 0x03, 0x26,
			0xE6, 0x57, 0xA0, 0x00, 0x88, 0x47, 0x12, 0xBD,
			0x84, 0x00, 0x04, 0x03, 0x00, 0xFC, 0x00, 0x00,
			0x02, 0xC0, 0x00, 0x00, 0x00, 0xFC, 0x50, 0x00,
			0x8F, 0x00, 0x00, 0x08, 0x8F, 0x00, 0xFF, 0xFF,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x11);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x84, 0x58, 0x04, 0x01, 0x84, 0xA1, 0x03, 0x68,
			0x84, 0xC1, 0x03, 0x67, 0xE0, 0xE0, 0x00, 0x00,
			0x02, 0xCA, 0x60, 0x00, 0x40, 0x40, 0xA0, 0x00,
			0x80, 0x00, 0xC0, 0x82, 0x08, 0xFC, 0x48, 0x3A,
			0x08, 0xFC, 0x38, 0x52, 0x84, 0x58, 0x04, 0x02,
			0xE0, 0x10, 0x40, 0x00, 0x84, 0xA0, 0x41, 0x00,
			0x40, 0x47, 0x20, 0x00, 0x02, 0xD3, 0x00, 0x10,
			0x84, 0xA2, 0x04, 0x00, 0x84, 0xA1, 0x03, 0x66,
			0xE4, 0x20, 0x00, 0x00, 0x08, 0x00, 0x28, 0x42,
			0x45, 0x40, 0xA0, 0x00, 0x80, 0x40, 0xC0, 0x83,
			0x08, 0xFC, 0x68, 0x3B, 0x08, 0xFC, 0x38, 0x71,
			0x84, 0xD3, 0x03, 0x68, 0xE4, 0x10, 0x20, 0x00,
			0x84, 0xA0, 0x04, 0x00, 0x45, 0x47, 0x20, 0x00,
			0x02, 0xD3, 0x00, 0x10, 0x80, 0x40, 0xC0, 0x81,
			0x0D, 0x00, 0x10, 0x20, 0x08, 0x00, 0x28, 0x42,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x12);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x84, 0xD3, 0x03, 0x66, 0x86, 0xD1, 0x01, 0x9C,
			0x86, 0xD9, 0x01, 0x9B, 0x08, 0xFC, 0x3C, 0x11,
			0x08, 0x44, 0x46, 0x53, 0x00, 0xFC, 0x00, 0x00,
			0x02, 0x83, 0x00, 0x19, 0x02, 0xA3, 0x00, 0x1B,
			0x80, 0x00, 0xC0, 0x83, 0x84, 0xC9, 0x03, 0x69,
			0x0D, 0x00, 0x10, 0x68, 0x08, 0xFC, 0x7C, 0x33,
			0xE0, 0x00, 0x00, 0x00, 0x02, 0x83, 0x00, 0x1B,
			0x86, 0xD9, 0x01, 0x9B, 0x08, 0x44, 0x46, 0x53,
			0x80, 0x07, 0x00, 0x82, 0xE0, 0x00, 0x00, 0x83,
			0x80, 0x07, 0x00, 0x83, 0x0C, 0x60, 0x0C, 0x10,
			0x0C, 0xE0, 0x0C, 0x39, 0x84, 0xC3, 0x03, 0x67,
			0x84, 0xCB, 0x03, 0x69, 0x00, 0xFC, 0x50, 0x00,
			0x8F, 0x00, 0x00, 0x01,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	return 0;
}

static int program_biquad_filters(struct device *dev)
{
	int res;

	res = tas5825m_set_book(dev, 0xAA);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x01);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x07, 0xED, 0x50, 0x78, 0xF0, 0xBB, 0x11, 0x75,
			0x07, 0x5C, 0xFB, 0x5D, 0x0F, 0x44, 0xEE, 0x8B,
			0xF8, 0xB5, 0xB4, 0x2B, 0x07, 0xE4, 0x94, 0x67,
			0xF1, 0x16, 0x72, 0x2F, 0x07, 0x10, 0xC7, 0x66,
			0x0E, 0xE9, 0x8D, 0xD1, 0xF9, 0x0A, 0xA4, 0x33,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x30, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x02);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x03);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x07, 0xB9, 0x96, 0x60, 0xF0, 0x8C, 0xD3, 0x40,
			0x07, 0xB9, 0x96, 0x60, 0x0F, 0x71, 0xF1, 0x6F,
			0xF8, 0x8B, 0x97, 0xF0, 0x07, 0xDB, 0xDE, 0xC0,
			0xF0, 0x48, 0x42, 0x80, 0x07, 0xDB, 0xDE, 0xC0,
			0x0F, 0xB6, 0x7C, 0xB8, 0xF8, 0x47, 0x01, 0xB8,
			0x07, 0xBA, 0x69, 0x7A, 0xF0, 0xCA, 0x2B, 0x37,
			0x07, 0x84, 0xF0, 0x5E, 0x0F, 0x35, 0xD4, 0xC9,
			0xF8, 0xC0, 0xA6, 0x28, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x04);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x05);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x07, 0xB9, 0x96, 0x60,
			0xF0, 0x8C, 0xD3, 0x40, 0x07, 0xB9, 0x96, 0x60,
			0x0F, 0x71, 0xF1, 0x6F, 0xF8, 0x8B, 0x97, 0xF0,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x06);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x07, 0xDB, 0xDE, 0xC0, 0xF0, 0x48, 0x42, 0x80,
			0x07, 0xDB, 0xDE, 0xC0, 0x0F, 0xB6, 0x7C, 0xB8,
			0xF8, 0x47, 0x01, 0xB8, 0x07, 0xBA, 0x69, 0x7A,
			0xF0, 0xCA, 0x2B, 0x37, 0x07, 0x84, 0xF0, 0x5E,
			0x0F, 0x35, 0xD4, 0xC9, 0xF8, 0xC0, 0xA6, 0x28,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0F);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x41, 0xBE, 0x3C,
			0xF0, 0x4D, 0x2C, 0x26, 0x07, 0x7A, 0xE8, 0xE9,
			0x0F, 0xB6, 0x7C, 0xB8, 0xF8, 0x47, 0x01, 0xB8,
			0x08, 0x00, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x2C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x10);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x00, 0x99, 0x82, 0x0D, 0xFF, 0x08, 0xB1, 0xE4,
			0x00, 0x67, 0xA6, 0xD7, 0x0F, 0xBE, 0xCA, 0x9D,
			0xF8, 0x37, 0x5A, 0x9B, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x35, 0x5D, 0x83, 0xC3, 0x96, 0xF7, 0xF4, 0x67,
			0x33, 0xEC, 0x44, 0x70, 0x0C, 0xE3, 0x60, 0xA2,
			0xFA, 0x99, 0x26, 0x28, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x03, 0xF6, 0x87, 0x00, 0x07, 0xED, 0x0F,
			0x00, 0x03, 0xF6, 0x87, 0x0E, 0xF9, 0x62, 0x4A,
			0xF8, 0xF6, 0xC3, 0x98
		};
		res = tas5825m_write_block_at(dev, 0x1C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x11);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x03, 0xF6, 0x87, 0x00, 0x07, 0xED, 0x0F,
			0x00, 0x03, 0xF6, 0x87, 0x0E, 0xF9, 0x62, 0x4A,
			0xF8, 0xF6, 0xC3, 0x98, 0x07, 0x80, 0xA7, 0xAC,
			0xF0, 0xFE, 0xB0, 0xA7, 0x07, 0x80, 0xA7, 0xAC,
			0x0E, 0xF9, 0x62, 0x4A, 0xF8, 0xF6, 0xC3, 0x98,
			0x07, 0x80, 0xA7, 0xAC, 0xF0, 0xFE, 0xB0, 0xA7,
			0x07, 0x80, 0xA7, 0xAC, 0x0E, 0xF9, 0x62, 0x4A,
			0xF8, 0xF6, 0xC3, 0x98
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	return 0;
}


int tas5825m_setup(struct device *dev, int id)
{
	int res = 0;

	res = tas5825m_set_book(dev, 0x00);
	if (res < 0)
		return res;

	// Set to HiZ state and enable DSP
	res = tas5825m_write_at(dev, 0x03, 0x02);
	if (res < 0)
		return res;

	// Digital core and registers reset
	res = tas5825m_write_at(dev, 0x01, 0x11);
	if (res < 0)
		return res;

	// DSP reset
	res = tas5825m_write_at(dev, 0x03, 0x12);
	if (res < 0)
		return res;

	res = tas5825m_write_at(dev, 0x48, 0x0C);
	if (res < 0)
		return res;

	res = program_dsp_ram(dev);
	if (res < 0)
		return res;

	res = tas5825m_set_book(dev, 0x78);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x18);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x30, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x1C);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x38, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x40, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x48
		};
		res = tas5825m_write_block_at(dev, 0x0C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x1D);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x50,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x58,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x70,
			0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x03, 0x88,
			0x00, 0x00, 0x03, 0x90, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0x98, 0x00, 0x00, 0x03, 0xA0,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x1E);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xA8,
			0x00, 0x00, 0x03, 0xB0, 0x00, 0x00, 0x03, 0xB8,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x03, 0xC0
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	// XOR checksums
	res = tas5825m_set_book(dev, 0x8C);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x0E);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x20, 0xC4, 0x9C, 0x00, 0x20, 0xC4, 0x9C,
			0x02, 0xDE, 0xAD, 0x00, 0x74, 0x01, 0x39, 0x01,
			0x00, 0x20, 0xC4, 0x9B, 0x00, 0xA7, 0x26, 0x4A,
			0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF,
			0x7F, 0xFF, 0xFF, 0xFF
		};
		res = tas5825m_write_block_at(dev, 0x5C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0F);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x7F, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0xE7, 0x00, 0x00, 0x00,
			0xFE, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x10);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x62, 0x48, 0x8E,
			0xFF, 0x83, 0xE9, 0x30, 0x00, 0x2E, 0x18, 0x72,
			0x0F, 0x40, 0xAE, 0x1F, 0xF8, 0x9A, 0x41, 0xD5,
			0x07, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF,
			0xF0, 0xBF, 0x51, 0xE1, 0x07, 0x65, 0xBE, 0x2B,
			0x0A, 0x19, 0xBB, 0x39, 0xFC, 0x3F, 0x79, 0xE8,
			0x07, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x5C, 0x79, 0x55,
			0x00, 0xB8, 0xF2, 0xAB, 0x00, 0x5C, 0x79, 0x55,
			0x0D, 0x98, 0xCC, 0x51, 0xFA, 0x16, 0x2B, 0x95,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x11);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x5C, 0x79, 0x55, 0x00, 0xB8, 0xF2, 0xAB,
			0x00, 0x5C, 0x79, 0x55, 0x0D, 0x98, 0xCC, 0x51,
			0xFA, 0x16, 0x2B, 0x95, 0x06, 0xE0, 0xA8, 0x2F,
			0xF2, 0x3E, 0xAF, 0xA2, 0x06, 0xE0, 0xA8, 0x2F,
			0x0D, 0x98, 0xCC, 0x51, 0xFA, 0x16, 0x2B, 0x95,
			0x06, 0xE0, 0xA8, 0x2F, 0xF2, 0x3E, 0xAF, 0xA2,
			0x06, 0xE0, 0xA8, 0x2F, 0x0D, 0x98, 0xCC, 0x51,
			0xFA, 0x16, 0x2B, 0x95, 0x02, 0x4D, 0x99, 0x99,
			0xFD, 0xB2, 0x66, 0x67, 0x00, 0x80, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_book(dev, 0x00);
	if (res < 0)
		return res;

	res = tas5825m_write_at(dev, 0x40, 0x00);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x7D, 0x11);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x7E, 0xFF);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x01);
	if (res < 0)
		return res;

	res = tas5825m_write_at(dev, 0x51, 0x05);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x02);
	if (res < 0)
		return res;

	res = tas5825m_write_at(dev, 0x19, 0xDF);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x00);
	if (res < 0)
		return res;

	res = tas5825m_write_at(dev, 0x46, 0x11);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x02, 0x00);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x53, 0x00);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x54, 0x00);
	if (res < 0)
		return res;

	// Set to HiZ state and enable DSP
	res = tas5825m_write_at(dev, 0x03, 0x02);
	if (res < 0)
		return res;

	// Wait for device to settle
	mdelay(5);

	// XOR checksums
	res = tas5825m_set_book(dev, 0x8C);
	if (res < 0)
		return res;

	res = tas5825m_set_page(dev, 0x0B);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x28, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x00, 0x20, 0xC4, 0x9C
		};
		res = tas5825m_write_block_at(dev, 0x50, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x7F, 0xFF, 0xFF, 0xFF
		};
		res = tas5825m_write_block_at(dev, 0x5C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x01);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0xC0, 0x00, 0x00, 0x00, 0x00, 0x71, 0x94, 0x9A,
		};
		res = tas5825m_write_block_at(dev, 0x28, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0A);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x64, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0B);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x80, 0x00, 0x00, 0x00, 0x2D, 0x6A, 0x86,
			0x00, 0x2D, 0x6A, 0x86, 0x00, 0x80, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x80, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x57, 0x62, 0x00, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x28, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x02, 0x66, 0xC4, 0x1B, 0x00, 0x89, 0x37, 0x4C,
		};
		res = tas5825m_write_block_at(dev, 0x48, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x7D, 0x99, 0x3B, 0xE5, 0x00, 0x00, 0x57, 0x62,
		};
		res = tas5825m_write_block_at(dev, 0x54, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0E);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x22, 0x1D, 0x95, 0x00, 0x03, 0x69, 0xC5,
			0x00, 0x03, 0x69, 0xC5, 0x1C, 0x1B, 0xF0, 0x41,
			0x04, 0x0C, 0x37, 0x14, 0x00, 0x03, 0x69, 0xC5,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x30, 0xE8,
			0x01, 0x2E, 0x4F, 0x40
		};
		res = tas5825m_write_block_at(dev, 0x5C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x0F);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0xC9, 0xD9, 0xD4, 0x00, 0x43, 0x6C, 0x19,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0xFF, 0xA0, 0x00, 0x00, 0xF7, 0x5C, 0x28, 0xF6,
			0xFB, 0x44, 0x29, 0x20, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x08, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x10);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x08, 0x13, 0x85, 0x62
		};
		res = tas5825m_write_block_at(dev, 0x18, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x11);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x02, 0x9E, 0x15, 0x7E, 0xFD, 0x61, 0xEA, 0x82,
			0x01, 0x00, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x44, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = tas5825m_set_page(dev, 0x07);
	if (res < 0)
		return res;

	{
		const uint8_t values[] = {
			0x00, 0x80, 0x00, 0x00
		};
		res = tas5825m_write_block_at(dev, 0x64, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}
	{
		const uint8_t values[] = {
			0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00,
		};
		res = tas5825m_write_block_at(dev, 0x6C, values, ARRAY_SIZE(values));
		if (res < 0)
			return res;
	}

	res = program_biquad_filters(dev);
	if (res < 0)
		return res;

	res = tas5825m_set_book(dev, 0x00);
	if (res < 0)
		return res;

	// Register tuning
	res = tas5825m_write_at(dev, 0x30, 0x00);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x60, 0x02);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x62, 0x09);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x4C, 0x30);
	if (res < 0)
		return res;

	// Set to PLAY state
	res = tas5825m_write_at(dev, 0x03, 0x03);
	if (res < 0)
		return res;

	// Clear analog fault
	res = tas5825m_write_at(dev, 0x78, 0x80);
	if (res < 0)
		return res;

	res = tas5825m_write_at(dev, 0x60, 0x00);
	if (res < 0)
		return res;
	res = tas5825m_write_at(dev, 0x64, 0x02);
	if (res < 0)
		return res;

	return 0;
}
