/* SPDX-License-Identifier: GPL-2.0-only */

#include <soc/gpio_snr.h>

#include "romstage.h"

static struct snr_pad_config frost_creek_gpio_table[] = {
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_4, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_5, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_6, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_7, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_8, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_9, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_10, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_11, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_18,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_19,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST2_20,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_0,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_1, PAD_FUNC(GPIO), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_4,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_5,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_6,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_7,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_8,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_9,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_10,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST01_11, PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
			    PAD_CFG0_RXINV_MASK | PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE |
				    PAD_CFG0_TX_DISABLE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST5_15, PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
			    PAD_CFG0_RXINV_MASK | PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE |
				    PAD_CFG0_TX_DISABLE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST5_16,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST5_17,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WEST5_18,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_WESTB_8, PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
			    PAD_CFG0_RXINV_MASK | PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE |
				    PAD_CFG0_TX_DISABLE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(
		GPIO_WESTB_11,
		PAD_TRIG(LEVEL) | PAD_IRQ_ROUTE(SCI) | PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
		PAD_CFG0_RXINV_MASK | PAD_CFG0_TRIG_MASK | PAD_CFG0_ROUTE_MASK |
			PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE,
		GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_6,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_10,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_11,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(
		GPIO_EAST2_12,
		PAD_TRIG(LEVEL) | PAD_IRQ_ROUTE(IOAPIC) | PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
		PAD_CFG0_TRIG_MASK | PAD_CFG0_RXINV_MASK | PAD_CFG0_ROUTE_MASK |
			PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE,
		GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_13, PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
			    PAD_CFG0_RXINV_MASK | PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE |
				    PAD_CFG0_TX_DISABLE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_14,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_17,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_18,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_19,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_20,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_22, PAD_FUNC(GPIO) | PAD_BUF(TX_DISABLE),
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST2_23,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST0_10,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST0_11,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST0_18,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST0_19, PAD_FUNC(GPIO), PAD_CFG0_MODE_MASK,
			    GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT0(GPIO_EAST0_21,
			    PAD_FUNC(GPIO) | PAD_BUF(RX_DISABLE) | PAD_CFG0_TX_STATE,
			    PAD_CFG0_MODE_MASK | PAD_CFG0_RX_DISABLE | PAD_CFG0_TX_DISABLE |
				    PAD_CFG0_TX_STATE,
			    GPIO_HOSTSW_OWN_DRIVER),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_0, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_1, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(DN_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_2, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_3, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_4, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_5, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_6, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_7, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_8, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_9, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT),
	SNR_PAD_CFG_STRUCT1(GPIO_EMMC_10, PAD_FUNC(NF1), PAD_CFG0_MODE_MASK, PAD_PULL(UP_20K),
			    PAD_CFG1_PULL_MASK, GPIO_HOSTSW_OWN_DEFAULT)
};

void mainboard_config_gpios(void)
{
	printk(BIOS_INFO, "GPIO table: %p, entry num: %zu!\n", frost_creek_gpio_table,
	       ARRAY_SIZE(frost_creek_gpio_table));
	/**
	 * Configure pads prior to FspSiliconInit() in case there's any
	 * dependencies during hardware initialization.
	 */
	gpio_configure_snr_pads(frost_creek_gpio_table, ARRAY_SIZE(frost_creek_gpio_table));
}
