# Source directory structure

- **actions**

  Handles player actions and queues pending actions.

- **audio**

  Contains files for mixing and playing music and sound.

- **cmdline**

  Code specific to command line (arguments).

- **config**

  Code concerning game configuration.

- **core**

  Provides core functionality such as string operations, encryption, and compression.

- **drawing**

  Low level drawing logic and palette tables.

- **interface**

  Window and widget logic, includes high level drawing and input.

- **localisation**

  String IDs, currency and date logic.

- **management**

  Park management logic such as finance, marketing and research.

- **network**

  Network and multiplayer logic, includes management of network games and downloading / uploading of content.

- **object**

  Code relating to objects (rides, shops, scenery, etc).

- **paint**

  Prepares objects' sprites to be drawn.

- **peep**

  Guest and staff definitions and logic such as action management and pathfinding.

- **platform**

  Compiler and operating system specific code such as type definitions, message handling and file input / output.

- **rct1**

  Code specific only to RCT1 (vanilla).

- **rct2**

  Code specific only to RCT2 (vanilla).

- **rct12**

  Code specific to vanilla RCT, either RCT 1 or RCT 2.

- **ride**

  Data and logic for rides, vehicles and track.

- **scenario**

  Code relating to game scenarios.

- **title**

  Code for loading and updating title screen sequence.

- **util**

  Utility and helper functions.

- **windows**

  Definitions and logic for all the windows in the game.

- **world**

  World objects and mechanics such as the climate, landscape, sprites and park.
