/*****************************************************************************
 * Copyright (c) 2014-2022 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "../common.h"

constexpr const StringId STR_NONE = 0xFFFF;
constexpr const StringId STR_VIEWPORT = 0xFFFE;

enum : uint16_t
{
    STR_EMPTY = 0,
    STR_RIDE_NAME_DEFAULT = 1,
    STR_RIDE_NAME_SPIRAL_ROLLER_COASTER = 2,
    STR_RIDE_NAME_STAND_UP_ROLLER_COASTER = 3,
    STR_RIDE_NAME_SUSPENDED_SWINGING_COASTER = 4,
    STR_RIDE_NAME_INVERTED_ROLLER_COASTER = 5,
    STR_RIDE_NAME_JUNIOR_ROLLER_COASTER = 6,
    STR_RIDE_NAME_MINIATURE_RAILWAY = 7,
    STR_RIDE_NAME_MONORAIL = 8,
    STR_RIDE_NAME_MINI_SUSPENDED_COASTER = 9,
    STR_RIDE_NAME_BOAT_HIRE = 10,
    STR_RIDE_NAME_WOODEN_WILD_MOUSE = 11,
    STR_RIDE_NAME_STEEPLECHASE = 12,
    STR_RIDE_NAME_CAR_RIDE = 13,
    STR_RIDE_NAME_LAUNCHED_FREEFALL = 14,
    STR_RIDE_NAME_BOBSLEIGH_COASTER = 15,
    STR_RIDE_NAME_OBSERVATION_TOWER = 16,
    STR_RIDE_NAME_LOOPING_ROLLER_COASTER = 17,
    STR_RIDE_NAME_DINGHY_SLIDE = 18,
    STR_RIDE_NAME_MINE_TRAIN_COASTER = 19,
    STR_RIDE_NAME_CHAIRLIFT = 20,
    STR_RIDE_NAME_CORKSCREW_ROLLER_COASTER = 21,
    STR_RIDE_NAME_MAZE = 22,
    STR_RIDE_NAME_SPIRAL_SLIDE = 23,
    STR_RIDE_NAME_GO_KARTS = 24,
    STR_RIDE_NAME_LOG_FLUME = 25,
    STR_RIDE_NAME_RIVER_RAPIDS = 26,
    STR_RIDE_NAME_DODGEMS = 27,
    STR_RIDE_NAME_SWINGING_SHIP = 28,
    STR_RIDE_NAME_SWINGING_INVERTER_SHIP = 29,
    STR_RIDE_NAME_FOOD_STALL = 30,
    STR_RIDE_NAME_1D = 31,
    STR_RIDE_NAME_DRINK_STALL = 32,
    STR_RIDE_NAME_1F = 33,
    STR_RIDE_NAME_SHOP = 34,
    STR_RIDE_NAME_MERRY_GO_ROUND = 35,
    STR_RIDE_NAME_22 = 36,
    STR_RIDE_NAME_INFORMATION_KIOSK = 37,
    STR_RIDE_NAME_TOILETS = 38,
    STR_RIDE_NAME_FERRIS_WHEEL = 39,
    STR_RIDE_NAME_MOTION_SIMULATOR = 40,
    STR_RIDE_NAME_3D_CINEMA = 41,
    STR_RIDE_NAME_TOP_SPIN = 42,
    STR_RIDE_NAME_SPACE_RINGS = 43,
    STR_RIDE_NAME_REVERSE_FREEFALL_COASTER = 44,
    STR_RIDE_NAME_LIFT = 45,
    STR_RIDE_NAME_VERTICAL_DROP_ROLLER_COASTER = 46,
    STR_RIDE_NAME_CASH_MACHINE = 47,
    STR_RIDE_NAME_TWIST = 48,
    STR_RIDE_NAME_HAUNTED_HOUSE = 49,
    STR_RIDE_NAME_FIRST_AID = 50,
    STR_RIDE_NAME_CIRCUS = 51,
    STR_RIDE_NAME_GHOST_TRAIN = 52,
    STR_RIDE_NAME_TWISTER_ROLLER_COASTER = 53,
    STR_RIDE_NAME_WOODEN_ROLLER_COASTER = 54,
    STR_RIDE_NAME_SIDE_FRICTION_ROLLER_COASTER = 55,
    STR_RIDE_NAME_WILD_MOUSE = 56,
    STR_RIDE_NAME_MULTI_DIMENSION_ROLLER_COASTER = 57,
    STR_RIDE_NAME_38 = 58,
    STR_RIDE_NAME_FLYING_ROLLER_COASTER = 59,
    STR_RIDE_NAME_3A = 60,
    STR_RIDE_NAME_VIRGINIA_REEL = 61,
    STR_RIDE_NAME_SPLASH_BOATS = 62,
    STR_RIDE_NAME_MINI_HELICOPTERS = 63,
    STR_RIDE_NAME_LAY_DOWN_ROLLER_COASTER = 64,
    STR_RIDE_NAME_SUSPENDED_MONORAIL = 65,
    STR_RIDE_NAME_40 = 66,
    STR_RIDE_NAME_REVERSER_ROLLER_COASTER = 67,
    STR_RIDE_NAME_HEARTLINE_TWISTER_COASTER = 68,
    STR_RIDE_NAME_MINI_GOLF = 69,
    STR_RIDE_NAME_GIGA_COASTER = 70,
    STR_RIDE_NAME_ROTO_DROP = 71,
    STR_RIDE_NAME_FLYING_SAUCERS = 72,
    STR_RIDE_NAME_CROOKED_HOUSE = 73,
    STR_RIDE_NAME_MONORAIL_CYCLES = 74,
    STR_RIDE_NAME_COMPACT_INVERTED_COASTER = 75,
    STR_RIDE_NAME_WATER_COASTER = 76,
    STR_RIDE_NAME_AIR_POWERED_VERTICAL_COASTER = 77,
    STR_RIDE_NAME_INVERTED_HAIRPIN_COASTER = 78,
    STR_RIDE_NAME_MAGIC_CARPET = 79,
    STR_RIDE_NAME_SUBMARINE_RIDE = 80,
    STR_RIDE_NAME_RIVER_RAFTS = 81,
    STR_RIDE_NAME_50 = 82,
    STR_RIDE_NAME_ENTERPRISE = 83,
    STR_RIDE_NAME_52 = 84,
    STR_RIDE_NAME_53 = 85,
    STR_RIDE_NAME_54 = 86,
    STR_RIDE_NAME_55 = 87,
    STR_RIDE_NAME_INVERTED_IMPULSE_COASTER = 88,
    STR_RIDE_NAME_MINI_ROLLER_COASTER = 89,
    STR_RIDE_NAME_MINE_RIDE = 90,
    STR_RIDE_NAME_59 = 91,
    STR_RIDE_NAME_LIM_LAUNCHED_ROLLER_COASTER = 92,
    STR_RIDE_NAME_HYBRID_COASTER = 93,
    STR_RIDE_NAME_SINGLE_RAIL_ROLLER_COASTER = 94,
    STR_RIDE_NAME_ALPINE_COASTER = 95,
    STR_RIDE_NAME_CLASSIC_WOODEN_ROLLER_COASTER = 96,

    STR_RIDE_DESCRIPTION_SPIRAL_ROLLER_COASTER = 512,
    STR_RIDE_DESCRIPTION_STAND_UP_ROLLER_COASTER = 513,
    STR_RIDE_DESCRIPTION_SUSPENDED_SWINGING_COASTER = 514,
    STR_RIDE_DESCRIPTION_INVERTED_ROLLER_COASTER = 515,
    STR_RIDE_DESCRIPTION_JUNIOR_ROLLER_COASTER = 516,
    STR_RIDE_DESCRIPTION_MINIATURE_RAILWAY = 517,
    STR_RIDE_DESCRIPTION_MONORAIL = 518,
    STR_RIDE_DESCRIPTION_MINI_SUSPENDED_COASTER = 519,
    STR_RIDE_DESCRIPTION_BOAT_HIRE = 520,
    STR_RIDE_DESCRIPTION_WOODEN_WILD_MOUSE = 521,
    STR_RIDE_DESCRIPTION_STEEPLECHASE = 522,
    STR_RIDE_DESCRIPTION_CAR_RIDE = 523,
    STR_RIDE_DESCRIPTION_LAUNCHED_FREEFALL = 524,
    STR_RIDE_DESCRIPTION_BOBSLEIGH_COASTER = 525,
    STR_RIDE_DESCRIPTION_OBSERVATION_TOWER = 526,
    STR_RIDE_DESCRIPTION_LOOPING_ROLLER_COASTER = 527,
    STR_RIDE_DESCRIPTION_DINGHY_SLIDE = 528,
    STR_RIDE_DESCRIPTION_MINE_TRAIN_COASTER = 529,
    STR_RIDE_DESCRIPTION_CHAIRLIFT = 530,
    STR_RIDE_DESCRIPTION_CORKSCREW_ROLLER_COASTER = 531,
    STR_RIDE_DESCRIPTION_MAZE = 532,
    STR_RIDE_DESCRIPTION_SPIRAL_SLIDE = 533,
    STR_RIDE_DESCRIPTION_GO_KARTS = 534,
    STR_RIDE_DESCRIPTION_LOG_FLUME = 535,
    STR_RIDE_DESCRIPTION_RIVER_RAPIDS = 536,
    STR_RIDE_DESCRIPTION_DODGEMS = 537,
    STR_RIDE_DESCRIPTION_SWINGING_SHIP = 538,
    STR_RIDE_DESCRIPTION_SWINGING_INVERTER_SHIP = 539,
    STR_RIDE_DESCRIPTION_FOOD_STALL = 540,

    STR_RIDE_DESCRIPTION_DRINK_STALL = 542,

    STR_RIDE_DESCRIPTION_SHOP = 544,
    STR_RIDE_DESCRIPTION_MERRY_GO_ROUND = 545,

    STR_RIDE_DESCRIPTION_INFORMATION_KIOSK = 547,
    STR_RIDE_DESCRIPTION_TOILETS = 548,
    STR_RIDE_DESCRIPTION_FERRIS_WHEEL = 549,
    STR_RIDE_DESCRIPTION_MOTION_SIMULATOR = 550,
    STR_RIDE_DESCRIPTION_3D_CINEMA = 551,
    STR_RIDE_DESCRIPTION_TOP_SPIN = 552,
    STR_RIDE_DESCRIPTION_SPACE_RINGS = 553,
    STR_RIDE_DESCRIPTION_REVERSE_FREEFALL_COASTER = 554,
    STR_RIDE_DESCRIPTION_LIFT = 555,
    STR_RIDE_DESCRIPTION_VERTICAL_DROP_ROLLER_COASTER = 556,
    STR_RIDE_DESCRIPTION_CASH_MACHINE = 557,
    STR_RIDE_DESCRIPTION_TWIST = 558,
    STR_RIDE_DESCRIPTION_HAUNTED_HOUSE = 559,
    STR_RIDE_DESCRIPTION_FIRST_AID = 560,
    STR_RIDE_DESCRIPTION_CIRCUS = 561,
    STR_RIDE_DESCRIPTION_GHOST_TRAIN = 562,
    STR_RIDE_DESCRIPTION_HYPER_TWISTER = 563,
    STR_RIDE_DESCRIPTION_WOODEN_ROLLER_COASTER = 564,
    STR_RIDE_DESCRIPTION_SIDE_FRICTION_ROLLER_COASTER = 565,
    STR_RIDE_DESCRIPTION_WILD_MOUSE = 566,
    STR_RIDE_DESCRIPTION_MULTI_DIMENSION_ROLLER_COASTER = 567,

    STR_RIDE_DESCRIPTION_FLYING_ROLLER_COASTER = 569,

    STR_RIDE_DESCRIPTION_VIRGINIA_REEL = 571,
    STR_RIDE_DESCRIPTION_SPLASH_BOATS = 572,
    STR_RIDE_DESCRIPTION_MINI_HELICOPTERS = 573,
    STR_RIDE_DESCRIPTION_LAY_DOWN_ROLLER_COASTER = 574,
    STR_RIDE_DESCRIPTION_SUSPENDED_MONORAIL = 575,

    STR_RIDE_DESCRIPTION_REVERSER_ROLLER_COASTER = 577,
    STR_RIDE_DESCRIPTION_HEARTLINE_TWISTER_COASTER = 578,
    STR_RIDE_DESCRIPTION_MINI_GOLF = 579,
    STR_RIDE_DESCRIPTION_GIGA_COASTER = 580,
    STR_RIDE_DESCRIPTION_ROTO_DROP = 581,
    STR_RIDE_DESCRIPTION_FLYING_SAUCERS = 582,
    STR_RIDE_DESCRIPTION_CROOKED_HOUSE = 583,
    STR_RIDE_DESCRIPTION_MONORAIL_CYCLES = 584,
    STR_RIDE_DESCRIPTION_COMPACT_INVERTED_COASTER = 585,
    STR_RIDE_DESCRIPTION_WATER_COASTER = 586,
    STR_RIDE_DESCRIPTION_AIR_POWERED_VERTICAL_COASTER = 587,
    STR_RIDE_DESCRIPTION_INVERTED_HAIRPIN_COASTER = 588,
    STR_RIDE_DESCRIPTION_MAGIC_CARPET = 589,
    STR_RIDE_DESCRIPTION_SUBMARINE_RIDE = 590,
    STR_RIDE_DESCRIPTION_RIVER_RAFTS = 591,

    STR_RIDE_DESCRIPTION_ENTERPRISE = 593,

    STR_RIDE_DESCRIPTION_INVERTED_IMPULSE_COASTER = 598,
    STR_RIDE_DESCRIPTION_MINI_ROLLER_COASTER = 599,
    STR_RIDE_DESCRIPTION_MINE_RIDE = 600,

    STR_RIDE_DESCRIPTION_LIM_LAUNCHED_ROLLER_COASTER = 602,
    STR_RIDE_DESCRIPTION_HYBRID_COASTER = 603,
    STR_RIDE_DESCRIPTION_SINGLE_RAIL_ROLLER_COASTER = 604,
    STR_RIDE_DESCRIPTION_ALPINE_COASTER = 605,
    STR_RIDE_DESCRIPTION_CLASSIC_WOODEN_ROLLER_COASTER = 606,

    STR_GUEST_X = 767,
    STR_HANDYMAN_X = 768,
    STR_MECHANIC_X = 769,
    STR_SECURITY_GUARD_X = 770,
    STR_ENTERTAINER_X = 771,

    STR_UNNAMED_PARK = 777,
    STR_DEFAULT_SIGN = 778,
    STR_DATE_DAY_1 = 779,
    STR_DATE_DAY_2 = STR_DATE_DAY_1 + 1,
    STR_DATE_DAY_3 = STR_DATE_DAY_1 + 2,
    STR_DATE_DAY_4 = STR_DATE_DAY_1 + 3,
    STR_DATE_DAY_5 = STR_DATE_DAY_1 + 4,
    STR_DATE_DAY_6 = STR_DATE_DAY_1 + 5,
    STR_DATE_DAY_7 = STR_DATE_DAY_1 + 6,
    STR_DATE_DAY_8 = STR_DATE_DAY_1 + 7,
    STR_DATE_DAY_9 = STR_DATE_DAY_1 + 8,
    STR_DATE_DAY_10 = STR_DATE_DAY_1 + 9,
    STR_DATE_DAY_11 = STR_DATE_DAY_1 + 10,
    STR_DATE_DAY_12 = STR_DATE_DAY_1 + 11,
    STR_DATE_DAY_13 = STR_DATE_DAY_1 + 12,
    STR_DATE_DAY_14 = STR_DATE_DAY_1 + 13,
    STR_DATE_DAY_15 = STR_DATE_DAY_1 + 14,
    STR_DATE_DAY_16 = STR_DATE_DAY_1 + 15,
    STR_DATE_DAY_17 = STR_DATE_DAY_1 + 16,
    STR_DATE_DAY_18 = STR_DATE_DAY_1 + 17,
    STR_DATE_DAY_19 = STR_DATE_DAY_1 + 18,
    STR_DATE_DAY_20 = STR_DATE_DAY_1 + 19,
    STR_DATE_DAY_21 = STR_DATE_DAY_1 + 20,
    STR_DATE_DAY_22 = STR_DATE_DAY_1 + 21,
    STR_DATE_DAY_23 = STR_DATE_DAY_1 + 22,
    STR_DATE_DAY_24 = STR_DATE_DAY_1 + 23,
    STR_DATE_DAY_25 = STR_DATE_DAY_1 + 24,
    STR_DATE_DAY_26 = STR_DATE_DAY_1 + 25,
    STR_DATE_DAY_27 = STR_DATE_DAY_1 + 26,
    STR_DATE_DAY_28 = STR_DATE_DAY_1 + 27,
    STR_DATE_DAY_29 = STR_DATE_DAY_1 + 28,
    STR_DATE_DAY_30 = STR_DATE_DAY_1 + 29,
    STR_DATE_DAY_31 = STR_DATE_DAY_1 + 30,
    STR_MONTH_SHORT_JAN = 810, // Unused
    STR_MONTH_SHORT_FEB = 811, // Unused
    STR_MONTH_SHORT_MAR = 812,
    STR_MONTH_SHORT_APR = 813,
    STR_MONTH_SHORT_MAY = 814,
    STR_MONTH_SHORT_JUN = 815,
    STR_MONTH_SHORT_JUL = 816,
    STR_MONTH_SHORT_AUG = 817,
    STR_MONTH_SHORT_SEP = 818,
    STR_MONTH_SHORT_OCT = 819,
    STR_MONTH_SHORT_NOV = 820, // Unused
    STR_MONTH_SHORT_DEC = 821, // Unused

    STR_CLOSE_X = 824,
    STR_CHOSEN_NAME_IN_USE_ALREADY = 825,
    STR_TOO_MANY_NAMES_DEFINED = 826,
    STR_NOT_ENOUGH_CASH_REQUIRES = 827,
    STR_CLOSE_WINDOW_TIP = 828,
    STR_WINDOW_TITLE_TIP = 829,
    STR_ZOOM_IN_TIP = 830,
    STR_ZOOM_OUT_TIP = 831,
    STR_ROTATE_TIP = 832,
    STR_PAUSE_GAME_TIP = 833,
    STR_DISC_AND_GAME_OPTIONS_TIP = 834,

    STR_RESOLUTION_X_BY_Y = 839,
    STR_ARG_16_RESOLUTION_X_BY_Y = 840,

    STR_ABOUT = 847,

    STR_COPYRIGHT_CS = 850,
    STR_DESIGNED_AND_PROGRAMMED_BY_CS = 851,
    STR_GRAPHICS_BY_SF = 852,
    STR_SOUND_AND_MUSIC_BY_AB = 853,
    STR_ADDITIONAL_SOUNDS_RECORDED_BY_DE = 854,
    STR_REPRESENTATION_BY_JL = 855,
    STR_THANKS_TO = 856,
    STR_THANKS_TO_PEOPLE = 857,
    // STR_0858 to 0864 are removed.
    STR_STRINGID = 865,
    STR_ARG_2_STRINGID = 866, // Unused
    STR_ARG_4_STRINGID = 867, // Unused
    STR_ARG_6_STRINGID = 868,
    STR_ARG_8_STRINGID = 869, // Unused
    STR_ARG_10_STRINGID = 870,
    STR_ARG_12_STRINGID = 871,
    STR_ARG_14_STRINGID = 872,
    STR_ARG_16_STRINGID = 873, // Unused
    STR_ARG_18_STRINGID = 874,
    STR_ARG_20_STRINGID = 875,
    STR_DROPDOWN_GLYPH = 876,
    STR_TOO_LOW = 877,
    STR_TOO_HIGH = 878,
    STR_CANT_LOWER_LAND_HERE = 879,
    STR_CANT_RAISE_LAND_HERE = 880,
    STR_OBJECT_IN_THE_WAY = 881,
    STR_LOAD_GAME = 882,
    STR_SAVE_GAME = 883,
    STR_LOAD_LANDSCAPE = 884,
    STR_SAVE_LANDSCAPE = 885,

    STR_QUIT_SCENARIO_EDITOR = 887,
    STR_QUIT_ROLLERCOASTER_DESIGNER = 888,
    STR_QUIT_TRACK_DESIGNS_MANAGER = 889,

    STR_SCREENSHOT = 891,
    STR_SCREENSHOT_SAVED_AS = 892,
    STR_SCREENSHOT_FAILED = 893,
    STR_ERR_LANDSCAPE_DATA_AREA_FULL = 894,
    STR_CANT_BUILD_PARTLY_ABOVE_AND_PARTLY_BELOW_GROUND = 895,
    STR_RIDE_CONSTRUCTION_WINDOW_TITLE = 896,
    STR_RIDE_CONSTRUCTION_DIRECTION = 897,
    STR_RIDE_CONSTRUCTION_LEFT_CURVE_TIP = 898,
    STR_RIDE_CONSTRUCTION_RIGHT_CURVE_TIP = 899,
    STR_RIDE_CONSTRUCTION_LEFT_CURVE_SMALL_TIP = 900,
    STR_RIDE_CONSTRUCTION_RIGHT_CURVE_SMALL_TIP = 901,
    STR_RIDE_CONSTRUCTION_LEFT_CURVE_VERY_SMALL_TIP = 902,
    STR_RIDE_CONSTRUCTION_RIGHT_CURVE_VERY_SMALL_TIP = 903,
    STR_RIDE_CONSTRUCTION_LEFT_CURVE_LARGE_TIP = 904,
    STR_RIDE_CONSTRUCTION_RIGHT_CURVE_LARGE_TIP = 905,
    STR_RIDE_CONSTRUCTION_STRAIGHT_TIP = 906,
    STR_RIDE_CONSTRUCTION_SLOPE = 907,
    STR_RIDE_CONSTRUCTION_ROLL_BANKING = 908,
    STR_RIDE_CONSTRUCTION_SEAT_ROT = 909,
    STR_RIDE_CONSTRUCTION_ROLL_FOR_LEFT_CURVE_TIP = 910,
    STR_RIDE_CONSTRUCTION_ROLL_FOR_RIGHT_CURVE_TIP = 911,
    STR_RIDE_CONSTRUCTION_NO_ROLL_TIP = 912,
    STR_RIDE_CONSTRUCTION_MOVE_TO_PREVIOUS_SECTION_TIP = 913,
    STR_RIDE_CONSTRUCTION_MOVE_TO_NEXT_SECTION_TIP = 914,
    STR_RIDE_CONSTRUCTION_CONSTRUCT_SELECTED_SECTION_TIP = 915,
    STR_RIDE_CONSTRUCTION_REMOVE_HIGHLIGHTED_SECTION_TIP = 916,
    STR_RIDE_CONSTRUCTION_VERTICAL_DROP_TIP = 917,
    STR_RIDE_CONSTRUCTION_STEEP_SLOPE_DOWN_TIP = 918,
    STR_RIDE_CONSTRUCTION_SLOPE_DOWN_TIP = 919,
    STR_RIDE_CONSTRUCTION_LEVEL_TIP = 920,
    STR_RIDE_CONSTRUCTION_SLOPE_UP_TIP = 921,
    STR_RIDE_CONSTRUCTION_STEEP_SLOPE_UP_TIP = 922,
    STR_RIDE_CONSTRUCTION_VERTICAL_RISE_TIP = 923,
    STR_RIDE_CONSTRUCTION_HELIX_DOWN_TIP = 924,
    STR_RIDE_CONSTRUCTION_HELIX_UP_TIP = 925,
    STR_RIDE_CONSTRUCTION_CANT_REMOVE_THIS = 926,
    STR_RIDE_CONSTRUCTION_CANT_CONSTRUCT_THIS_HERE = 927,
    STR_RIDE_CONSTRUCTION_CHAIN_LIFT_TIP = 928,
    STR_S_BEND_LEFT = 929,
    STR_S_BEND_RIGHT = 930,
    STR_VERTICAL_LOOP_LEFT = 931,
    STR_VERTICAL_LOOP_RIGHT = 932,
    STR_RAISE_OR_LOWER_LAND_FIRST = 933,
    STR_RIDE_ENTRANCE_IN_THE_WAY = 934,
    STR_RIDE_EXIT_IN_THE_WAY = 935,
    STR_PARK_ENTRANCE_IN_THE_WAY = 936,
    STR_VIEW_OPTIONS_TIP = 937,
    STR_ADJUST_LAND_TIP = 938,
    STR_UNDERGROUND_VIEW = 939,
    STR_REMOVE_BASE_LAND = 940,
    STR_REMOVE_VERTICAL_FACES = 941,
    STR_SEE_THROUGH_RIDES = 942,
    STR_SEE_THROUGH_SCENERY = 943,
    STR_SAVE_PROMPT_SAVE = 944,
    STR_SAVE_PROMPT_DONT_SAVE = 945,
    STR_SAVE_PROMPT_CANCEL = 946,
    STR_SAVE_BEFORE_LOADING = 947,
    STR_SAVE_BEFORE_QUITTING = 948,
    STR_SAVE_BEFORE_QUITTING_2 = 949,
    STR_LOAD_GAME_PROMPT_TITLE = 950,
    STR_QUIT_GAME_PROMPT_TITLE = 951,
    STR_QUIT_GAME_2_PROMPT_TITLE = 952,
    STR_LOAD_LANDSCAPE_PROMPT_TITLE = 953,

    STR_RIDE_CONSTRUCTION_SELECT_SEAT_ROTATION_ANGLE_TIP = 955,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_180 = 956,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_135 = 957,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_90 = 958,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_NEG_45 = 959,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_0 = 960,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_45 = 961,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_90 = 962,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_135 = 963,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_180 = 964,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_225 = 965,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_270 = 966,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_315 = 967,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_360 = 968,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_405 = 969,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_450 = 970,
    STR_RIDE_CONSTRUCTION_SEAT_ROTATION_ANGLE_495 = 971,
    STR_CANCEL = 972,
    STR_OK = 973,
    STR_RIDES = 974,
    STR_SHOPS_AND_STALLS = 975,
    STR_TOILETS_AND_INFORMATION_KIOSKS = 976,
    STR_NEW_TRANSPORT_RIDES = 977,
    STR_NEW_GENTLE_RIDES = 978,
    STR_NEW_ROLLER_COASTERS = 979,
    STR_NEW_THRILL_RIDES = 980,
    STR_NEW_WATER_RIDES = 981,
    STR_NEW_SHOPS_STALLS = 982,
    STR_RESEARCH_AND_DEVELOPMENT = 983,
    STR_RAISE_COST_AMOUNT = 984,
    STR_LOWER_COST_AMOUNT = 985,
    STR_COST_AMOUNT = 986,
    STR_TOO_MANY_RIDES = 987,
    STR_CANT_CREATE_NEW_RIDE_ATTRACTION = 988,
    STR_RIDE_WINDOW_TITLE = 989,
    STR_CONSTRUCTION = 990,
    STR_STATION_PLATFORM = 991,
    STR_DEMOLISH_RIDE_TIP = 992,
    STR_DEMOLISH_RIDE = 993,
    STR_DEMOLISH = 994,
    STR_DEMOLISH_RIDE_ID = 995,
    STR_OVERALL_VIEW = 996,
    STR_VIEW_SELECTION = 997,
    STR_NO_MORE_STATIONS_ALLOWED_ON_THIS_RIDE = 998,
    STR_REQUIRES_A_STATION_PLATFORM = 999,
    STR_TRACK_IS_NOT_A_COMPLETE_CIRCUIT = 1000,
    STR_TRACK_UNSUITABLE_FOR_TYPE_OF_TRAIN = 1001,
    STR_CANT_OPEN = 1002,
    STR_CANT_TEST = 1003,
    STR_CANT_CLOSE = 1004,
    STR_CANT_START_CONSTRUCTION_ON = 1005,
    STR_MUST_BE_CLOSED_FIRST = 1006,
    STR_UNABLE_TO_CREATE_ENOUGH_VEHICLES = 1007,
    STR_OPEN_CLOSE_OR_TEST_RIDE = 1008,
    STR_OPEN_OR_CLOSE_ALL_RIDES = 1009,
    STR_OPEN_OR_CLOSE_PARK_TIP = 1010,
    STR_CLOSE_ALL = 1011,
    STR_OPEN_ALL = 1012,
    STR_CLOSE_PARK = 1013,
    STR_OPEN_PARK = 1014,
    STR_UNABLE_TO_OPERATE_WITH_MORE_THAN_ONE_STATION_IN_THIS_MODE = 1015,
    STR_UNABLE_TO_OPERATE_WITH_LESS_THAN_TWO_STATIONS_IN_THIS_MODE = 1016,
    STR_CANT_CHANGE_OPERATING_MODE = 1017,
    STR_RIDE_SET_VEHICLE_TYPE_FAIL = 1018,
    STR_RIDE_SET_VEHICLE_SET_NUM_CARS_PER_TRAIN_FAIL = 1019,
    STR_RIDE_SET_VEHICLE_SET_NUM_TRAINS_FAIL = 1020,
    STR_RIDE_VEHICLE_COUNT = 1021,
    STR_1_CAR_PER_TRAIN = 1022,
    STR_X_CARS_PER_TRAIN = 1023,
    // STR_1024    :{COMMA16} car per train
    // STR_1025    :{COMMA16} cars per train
    STR_STATION_PLATFORM_TOO_LONG = 1026,
    STR_LOCATE_SUBJECT_TIP = 1027,
    STR_OFF_EDGE_OF_MAP = 1028,
    STR_CANNOT_BUILD_PARTLY_ABOVE_AND_PARTLY_BELOW_WATER = 1029,
    STR_CAN_ONLY_BUILD_THIS_UNDERWATER = 1030,
    STR_RIDE_CANT_BUILD_THIS_UNDERWATER = 1031,
    STR_CAN_ONLY_BUILD_THIS_ON_WATER = 1032,
    STR_CAN_ONLY_BUILD_THIS_ABOVE_GROUND = 1033,
    STR_CAN_ONLY_BUILD_THIS_ON_LAND = 1034,
    STR_LOCAL_AUTHORITY_WONT_ALLOW_CONSTRUCTION_ABOVE_TREE_HEIGHT = 1035,
    STR_FILE_DIALOG_TITLE_LOAD_GAME = 1036,
    STR_FILE_DIALOG_TITLE_LOAD_LANDSCAPE = 1037,
    STR_FILE_DIALOG_TITLE_CONVERT_SAVED_GAME_TO_SCENARIO = 1038, // Unused
    STR_FILE_DIALOG_TITLE_INSTALL_NEW_TRACK_DESIGN = 1039,
    STR_FILE_DIALOG_TITLE_SAVE_GAME = 1040,
    STR_FILE_DIALOG_TITLE_SAVE_SCENARIO = 1041,
    STR_FILE_DIALOG_TITLE_SAVE_LANDSCAPE = 1042,
    STR_OPENRCT2_SAVED_GAME = 1043,
    STR_OPENRCT2_SCENARIO_FILE = 1044,
    STR_OPENRCT2_LANDSCAPE_FILE = 1045,
    STR_OPENRCT2_TRACK_DESIGN_FILE = 1046,
    STR_GAME_SAVE_FAILED = 1047,
    STR_SCENARIO_SAVE_FAILED = 1048,
    STR_LANDSCAPE_SAVE_FAILED = 1049,
    STR_FAILED_TO_LOAD_FILE_CONTAINS_INVALID_DATA = 1050,
    STR_INVISIBLE_SUPPORTS = 1051,
    STR_INVISIBLE_PEOPLE = 1052,
    STR_RIDES_IN_PARK_TIP = 1053,
    STR_NAME_RIDE_TIP = 1054,
    STR_NAME_GUEST_TIP = 1055,
    STR_NAME_STAFF_TIP = 1056,
    STR_RIDE_ATTRACTION_NAME = 1057,
    STR_ENTER_NEW_NAME_FOR_THIS_RIDE_ATTRACTION = 1058,
    STR_CANT_RENAME_RIDE_ATTRACTION = 1059,
    STR_INVALID_RIDE_ATTRACTION_NAME = 1060,
    STR_RIDE_MODE_NORMAL = 1061,
    STR_RIDE_MODE_CONTINUOUS_CIRCUIT = 1062,
    STR_RIDE_MODE_REVERSE_INCLINE_LAUNCHED_SHUTTLE = 1063,
    STR_RIDE_MODE_POWERED_LAUNCH_PASSTROUGH = 1064,
    STR_RIDE_MODE_SHUTTLE = 1065,
    STR_RIDE_MODE_BOAT_HIRE = 1066,
    STR_RIDE_MODE_UPWARD_LAUNCH = 1067,
    STR_RIDE_MODE_ROTATING_LIFT = 1068,
    STR_RIDE_MODE_STATION_TO_STATION = 1069,
    STR_RIDE_MODE_SINGLE_RIDE_PER_ADMISSION = 1070,
    STR_RIDE_MODE_UNLIMITED_RIDES_PER_ADMISSION = 1071,
    STR_RIDE_MODE_MAZE = 1072,
    STR_RIDE_MODE_RACE = 1073,
    STR_RIDE_MODE_DODGEMS = 1074,
    STR_RIDE_MODE_SWING = 1075,
    STR_RIDE_MODE_SHOP_STALL = 1076,
    STR_RIDE_MODE_ROTATION = 1077,
    STR_RIDE_MODE_FORWARD_ROTATION = 1078,
    STR_RIDE_MODE_BACKWARD_ROTATION = 1079,
    STR_RIDE_MODE_FILM_AVENGING_AVIATORS = 1080,
    STR_RIDE_MODE_3D_FILM_MOUSE_TAILS = 1081,
    STR_RIDE_MODE_SPACE_RINGS = 1082,
    STR_RIDE_MODE_BEGINNERS = 1083,
    STR_RIDE_MODE_LIM_POWERED_LAUNCH = 1084,
    STR_RIDE_MODE_FILM_THRILL_RIDERS = 1085,
    STR_RIDE_MODE_3D_FILM_STORM_CHASERS = 1086,
    STR_RIDE_MODE_3D_FILM_SPACE_RAIDERS = 1087,
    STR_RIDE_MODE_INTENSE = 1088,
    STR_RIDE_MODE_BERSERK = 1089,
    STR_RIDE_MODE_HAUNTED_HOUSE = 1090,
    STR_RIDE_MODE_CIRCUS_SHOW = 1091,
    STR_RIDE_MODE_DOWNWARD_LAUNCH = 1092,
    STR_RIDE_MODE_CROOKED_HOUSE = 1093,
    STR_RIDE_MODE_FREEFALL_DROP = 1094,
    STR_RIDE_MODE_CONTINUOUS_CIRCUIT_BLOCK_SECTIONED = 1095,
    STR_RIDE_MODE_POWERED_LAUNCH = 1096,
    STR_RIDE_MODE_POWERED_LAUNCH_BLOCK_SECTIONED_MODE = 1097,
    STR_MOVING_TO_END_OF = 1098,
    STR_WAITING_FOR_PASSENGERS_AT = 1099,
    STR_WAITING_TO_DEPART = 1100,
    STR_DEPARTING = 1101,
    STR_TRAVELLING_AT_0 = 1102,
    STR_ARRIVING_AT = 1103,
    STR_UNLOADING_PASSENGERS_AT = 1104,
    STR_TRAVELLING_AT_1 = 1105,
    STR_CRASHING = 1106,
    STR_CRASHED_0 = 1107,
    STR_TRAVELLING_AT_2 = 1108,
    STR_SWINGING = 1109,
    STR_ROTATING_0 = 1110,
    STR_ROTATING_1 = 1111,
    STR_OPERATING_0 = 1112,
    STR_SHOWING_FILM = 1113,
    STR_ROTATING_2 = 1114,
    STR_OPERATING_1 = 1115,
    STR_OPERATING_2 = 1116,
    STR_DOING_CIRCUS_SHOW = 1117,
    STR_OPERATING_3 = 1118,
    STR_WAITING_FOR_CABLE_LIFT = 1119,
    STR_TRAVELLING_AT_3 = 1120,
    STR_STOPPING_0 = 1121,
    STR_WAITING_FOR_PASSENGERS = 1122,
    STR_WAITING_TO_START = 1123,
    STR_STARTING = 1124,
    STR_OPERATING = 1125,
    STR_STOPPING_1 = 1126,
    STR_UNLOADING_PASSENGERS = 1127,
    STR_STOPPED_BY_BLOCK_BRAKES = 1128,
    STR_ALL_VEHICLES_IN_SAME_COLOURS = 1129,
    STR_DIFFERENT_COLOURS_PER = 1130,
    STR_DIFFERENT_COLOURS_PER_VEHICLE = 1131,
    STR_RIDE_COLOUR_VEHICLE_VALUE = 1132,
    STR_RIDE_COLOUR_VEHICLE_OPTION = 1133,
    STR_RIDE_COLOUR_TRAIN_VALUE = 1134,
    STR_RIDE_COLOUR_TRAIN_OPTION = 1135,
    STR_SELECT_MAIN_COLOUR_TIP = 1136,
    STR_SELECT_ADDITIONAL_COLOUR_1_TIP = 1137,
    STR_SELECT_ADDITIONAL_COLOUR_2_TIP = 1138,
    STR_SELECT_SUPPORT_STRUCTURE_COLOUR_TIP = 1139,
    STR_SELECT_VEHICLE_COLOUR_SCHEME_TIP = 1140,
    STR_SELECT_VEHICLE_TO_MODIFY_TIP = 1141,
    STR_DROPDOWN_MENU_LABEL = 1142,
    STR_DROPDOWN_MENU_LABEL_SELECTED = 1143,
    STR_CANT_BUILD_MOVE_ENTRANCE_FOR_THIS_RIDE_ATTRACTION = 1144,
    STR_CANT_BUILD_MOVE_EXIT_FOR_THIS_RIDE_ATTRACTION = 1145,
    STR_ENTRANCE_NOT_YET_BUILT = 1146,
    STR_EXIT_NOT_YET_BUILT = 1147,
    STR_QUARTER_LOAD = 1148,
    STR_HALF_LOAD = 1149,
    STR_THREE_QUARTER_LOAD = 1150,
    STR_FULL_LOAD = 1151,
    STR_ANY_LOAD = 1152,
    STR_HEIGHT_MARKS_ON_RIDE_TRACKS = 1153,
    STR_HEIGHT_MARKS_ON_LAND = 1154,
    STR_HEIGHT_MARKS_ON_PATHS = 1155,
    STR_TOGGLE_OPTION = 1156,
    STR_TOGGLE_OPTION_CHECKED = 1157, // Used as STR_TOGGLE_OPTION + 1
    STR_CANT_REMOVE_THIS = 1158,
    STR_PLACE_SCENERY_TIP = 1159,
    STR_ADJUST_WATER_TIP = 1160,
    STR_CANT_POSITION_THIS_HERE = 1161,
    STR_MAP_TOOLTIP_STRINGID = 1162,
    STR_MAP_TOOLTIP_STRINGID_CLICK_TO_MODIFY = 1163,
    STR_MAP_TOOLTIP_STRINGID_CLICK_TO_REMOVE = 1164,
    STR_MAP_TOOLTIP_STRINGID_STRINGID = 1165,
    STR_CANT_LOWER_WATER_LEVEL_HERE = 1166,
    STR_CANT_RAISE_WATER_LEVEL_HERE = 1167,
    STR_OPTIONS_TITLE = 1168,
    STR_SOUND_NONE = 1169,
    STR_STRING = 1170,
    STR_RIDE_ENTRANCE_CLOSED = 1171,
    STR_RIDE_ENTRANCE_NAME = 1172,
    STR_BUILD_FOOTPATH_TIP = 1173,
    STR_BANNER_SIGN_IN_THE_WAY = 1174,
    STR_CANT_BUILD_THIS_ON_SLOPED_FOOTPATH = 1175,
    STR_CANT_BUILD_FOOTPATH_HERE = 1176,
    STR_CANT_REMOVE_FOOTPATH_FROM_HERE = 1177,
    STR_LAND_SLOPE_UNSUITABLE = 1178,
    STR_FOOTPATH_IN_THE_WAY = 1179,
    STR_CANT_BUILD_THIS_UNDERWATER = 1180,
    STR_FOOTPATHS = 1181,
    STR_TYPE = 1182,
    STR_DIRECTION = 1183,
    STR_SLOPE = 1184,
    STR_DIRECTION_TIP = 1185,
    STR_SLOPE_DOWN_TIP = 1186,
    STR_LEVEL_TIP = 1187,
    STR_SLOPE_UP_TIP = 1188,
    STR_CONSTRUCT_THE_SELECTED_FOOTPATH_SECTION_TIP = 1189,
    STR_REMOVE_PREVIOUS_FOOTPATH_SECTION_TIP = 1190,
    STR_BLACK_STRING = 1191,
    STR_RED_OUTLINED_STRING = 1192,
    STR_WINDOW_COLOUR_2_STRINGID = 1193,
    STR_CLOSED = 1194,
    STR_TEST_RUN = 1195,
    STR_OPEN = 1196,
    STR_BROKEN_DOWN = 1197,
    STR_CRASHED = 1198,
    STR_PERSON_ON_RIDE = 1199,
    STR_PEOPLE_ON_RIDE = 1200,
    STR_QUEUE_EMPTY = 1201,
    STR_QUEUE_ONE_PERSON = 1202,
    STR_QUEUE_PEOPLE = 1203,
    STR_QUEUE_TIME_LABEL = 1204,
    STR_QUEUE_TIME_PLURAL_LABEL = 1205,
    STR_WAIT_FOR = 1206,
    STR_LEAVE_IF_ANOTHER_TRAIN_ARRIVES = 1207,
    STR_LEAVE_IF_ANOTHER_BOAT_ARRIVES = 1208,
    STR_WAIT_FOR_PASSENGERS_BEFORE_DEPARTING_TIP = 1209,
    STR_LEAVE_IF_ANOTHER_VEHICLE_ARRIVES_TIP = 1210,
    STR_MINIMUM_WAITING_TIME = 1211,
    STR_MAXIMUM_WAITING_TIME = 1212,
    STR_MINIMUM_LENGTH_BEFORE_DEPARTING_TIP = 1213,
    STR_MAXIMUM_LENGTH_BEFORE_DEPARTING_TIP = 1214,
    STR_SYNCHRONISE_WITH_ADJACENT_STATIONS = 1215,
    STR_SYNCHRONISE_WITH_ADJACENT_STATIONS_TIP = 1216,
    STR_FORMAT_SECONDS = 1217,
    STR_NUMERIC_UP = 1218,
    STR_NUMERIC_DOWN = 1219,
    STR_EXIT_ONLY = 1220,
    STR_NO_ENTRANCE = 1221,
    STR_NO_EXIT = 1222,
    STR_TRANSPORT_RIDES_TIP = 1223,
    STR_GENTLE_RIDES_TIP = 1224,
    STR_ROLLER_COASTERS_TIP = 1225,
    STR_THRILL_RIDES_TIP = 1226,
    STR_WATER_RIDES_TIP = 1227,
    STR_SHOPS_STALLS_TIP = 1228,
    STR_RIDE_COMPONENT_TRAIN = 1229,
    STR_RIDE_COMPONENT_TRAIN_PLURAL = 1230,
    STR_RIDE_COMPONENT_TRAIN_CAPITALISED = 1231,
    STR_RIDE_COMPONENT_TRAIN_CAPITALISED_PLURAL = 1232,
    STR_RIDE_COMPONENT_TRAIN_COUNT = 1233,
    STR_RIDE_COMPONENT_TRAIN_COUNT_PLURAL = 1234,
    STR_RIDE_COMPONENT_TRAIN_NO = 1235,
    STR_RIDE_COMPONENT_BOAT = 1236,
    STR_RIDE_COMPONENT_BOAT_PLURAL = 1237,
    STR_RIDE_COMPONENT_BOAT_CAPITALISED = 1238,
    STR_RIDE_COMPONENT_BOAT_CAPITALISED_PLURAL = 1239,
    STR_RIDE_COMPONENT_BOAT_COUNT = 1240,
    STR_RIDE_COMPONENT_BOAT_COUNT_PLURAL = 1241,
    STR_RIDE_COMPONENT_BOAT_NO = 1242,
    STR_RIDE_COMPONENT_TRACK = 1243,
    STR_RIDE_COMPONENT_TRACK_PLURAL = 1244,
    STR_RIDE_COMPONENT_TRACK_CAPITALISED = 1245,
    STR_RIDE_COMPONENT_TRACK_CAPITALISED_PLURAL = 1246,
    STR_RIDE_COMPONENT_TRACK_COUNT = 1247,
    STR_RIDE_COMPONENT_TRACK_COUNT_PLURAL = 1248,
    STR_RIDE_COMPONENT_TRACK_NO = 1249,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM = 1250,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_PLURAL = 1251,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_CAPITALISED = 1252,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_CAPITALISED_PLURAL = 1253,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_COUNT = 1254,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_COUNT_PLURAL = 1255,
    STR_RIDE_COMPONENT_DOCKING_PLATFORM_NO = 1256,
    STR_RIDE_COMPONENT_STATION = 1257,
    STR_RIDE_COMPONENT_STATION_PLURAL = 1258,
    STR_RIDE_COMPONENT_STATION_CAPITALISED = 1259,
    STR_RIDE_COMPONENT_STATION_CAPITALISED_PLURAL = 1260,
    STR_RIDE_COMPONENT_STATION_COUNT = 1261,
    STR_RIDE_COMPONENT_STATION_COUNT_PLURAL = 1262,
    STR_RIDE_COMPONENT_STATION_NO = 1263,
    STR_RIDE_COMPONENT_CAR = 1264,
    STR_RIDE_COMPONENT_CAR_PLURAL = 1265,
    STR_RIDE_COMPONENT_CAR_CAPITALISED = 1266,
    STR_RIDE_COMPONENT_CAR_CAPITALISED_PLURAL = 1267,
    STR_RIDE_COMPONENT_CAR_COUNT = 1268,
    STR_RIDE_COMPONENT_CAR_COUNT_PLURAL = 1269,
    STR_RIDE_COMPONENT_CAR_NO = 1270,
    STR_RIDE_COMPONENT_BUILDING = 1271,
    STR_RIDE_COMPONENT_BUILDING_PLURAL = 1272,
    STR_RIDE_COMPONENT_BUILDING_CAPITALISED = 1273,
    STR_RIDE_COMPONENT_BUILDING_CAPITALISED_PLURAL = 1274,
    STR_RIDE_COMPONENT_BUILDING_COUNT = 1275,
    STR_RIDE_COMPONENT_BUILDING_COUNT_PLURAL = 1276,
    STR_RIDE_COMPONENT_BUILDING_NO = 1277,
    STR_RIDE_COMPONENT_STRUCTURE = 1278,
    STR_RIDE_COMPONENT_STRUCTURE_PLURAL = 1279,
    STR_RIDE_COMPONENT_STRUCTURE_CAPITALISED = 1280,
    STR_RIDE_COMPONENT_STRUCTURE_CAPITALISED_PLURAL = 1281,
    STR_RIDE_COMPONENT_STRUCTURE_COUNT = 1282,
    STR_RIDE_COMPONENT_STRUCTURE_COUNT_PLURAL = 1283,
    STR_RIDE_COMPONENT_STRUCTURE_NO = 1284,
    STR_RIDE_COMPONENT_SHIP = 1285,
    STR_RIDE_COMPONENT_SHIP_PLURAL = 1286,
    STR_RIDE_COMPONENT_SHIP_CAPITALISED = 1287,
    STR_RIDE_COMPONENT_SHIP_CAPITALISED_PLURAL = 1288,
    STR_RIDE_COMPONENT_SHIP_COUNT = 1289,
    STR_RIDE_COMPONENT_SHIP_COUNT_PLURAL = 1290,
    STR_RIDE_COMPONENT_SHIP_NO = 1291,
    STR_RIDE_COMPONENT_CABIN = 1292,
    STR_RIDE_COMPONENT_CABIN_PLURAL = 1293,
    STR_RIDE_COMPONENT_CABIN_CAPITALISED = 1294,
    STR_RIDE_COMPONENT_CABIN_CAPITALISED_PLURAL = 1295,
    STR_RIDE_COMPONENT_CABIN_COUNT = 1296,
    STR_RIDE_COMPONENT_CABIN_COUNT_PLURAL = 1297,
    STR_RIDE_COMPONENT_CABIN_NO = 1298,
    STR_RIDE_COMPONENT_WHEEL = 1299,
    STR_RIDE_COMPONENT_WHEEL_PLURAL = 1300,
    STR_RIDE_COMPONENT_WHEEL_CAPITALISED = 1301,
    STR_RIDE_COMPONENT_WHEEL_CAPITALISED_PLURAL = 1302,
    STR_RIDE_COMPONENT_WHEEL_COUNT = 1303,
    STR_RIDE_COMPONENT_WHEEL_COUNT_PLURAL = 1304,
    STR_RIDE_COMPONENT_WHEEL_NO = 1305,
    STR_RIDE_COMPONENT_RING = 1306,
    STR_RIDE_COMPONENT_RING_PLURAL = 1307,
    STR_RIDE_COMPONENT_RING_CAPITALISED = 1308,
    STR_RIDE_COMPONENT_RING_CAPITALISED_PLURAL = 1309,
    STR_RIDE_COMPONENT_RING_COUNT = 1310,
    STR_RIDE_COMPONENT_RING_COUNT_PLURAL = 1311,
    STR_RIDE_COMPONENT_RING_NO = 1312,
    STR_RIDE_COMPONENT_PLAYER = 1313,
    STR_RIDE_COMPONENT_PLAYER_PLURAL = 1314,
    STR_RIDE_COMPONENT_PLAYER_CAPITALISED = 1315,
    STR_RIDE_COMPONENT_PLAYER_CAPITALISED_PLURAL = 1316,
    STR_RIDE_COMPONENT_PLAYER_COUNT = 1317,
    STR_RIDE_COMPONENT_PLAYER_COUNT_PLURAL = 1318,
    STR_RIDE_COMPONENT_PLAYER_NO = 1319,
    STR_RIDE_COMPONENT_COURSE = 1320,
    STR_RIDE_COMPONENT_COURSE_PLURAL = 1321,
    STR_RIDE_COMPONENT_COURSE_CAPITALISED = 1322,
    STR_RIDE_COMPONENT_COURSE_CAPITALISED_PLURAL = 1323,
    STR_RIDE_COMPONENT_COURSE_COUNT = 1324,
    STR_RIDE_COMPONENT_COURSE_COUNT_PLURAL = 1325,
    STR_RIDE_COMPONENT_COURSE_NO = 1326,
    STR_ROTATE_OBJECTS_90 = 1327,
    STR_LEVEL_LAND_REQUIRED = 1328,
    STR_LAUNCH_SPEED = 1329,
    STR_LAUNCH_SPEED_TIP = 1330,
    STR_RIDE_MODE_SPEED_VALUE = 1331,
    // 1332 not used. Likely ride_mode_speed value
    STR_RIDE_STATION = 1333,
    STR_RIDE_STATION_X = 1334,
    STR_RIDE_ENTRANCE = 1335,
    STR_RIDE_STATION_X_ENTRANCE = 1336,
    STR_RIDE_EXIT = 1337,
    STR_RIDE_STATION_X_EXIT = 1338,
    STR_NO_TEST_RESULTS_YET = 1339,
    STR_MAX_SPEED = 1340,
    STR_RIDE_TIME = 1341,
    STR_RIDE_TIME_ENTRY = 1342,
    STR_RIDE_TIME_ENTRY_WITH_SEPARATOR = 1343,
    STR_RIDE_LENGTH = 1344,
    STR_RIDE_LENGTH_ENTRY = 1345,
    STR_RIDE_LENGTH_ENTRY_WITH_SEPARATOR = 1346,
    STR_AVERAGE_SPEED = 1347,
    STR_MAX_POSITIVE_VERTICAL_G = 1348,
    STR_MAX_NEGATIVE_VERTICAL_G = 1350,
    STR_MAX_NEGATIVE_VERTICAL_G_RED = 1351,
    STR_MAX_LATERAL_G = 1352,
    STR_MAX_LATERAL_G_RED = 1353,
    STR_HIGHEST_DROP_HEIGHT = 1354,
    STR_DROPS = 1355,
    STR_INVERSIONS = 1356,
    STR_HOLES = 1357,
    STR_TOTAL_AIR_TIME = 1358,
    STR_QUEUE_TIME_MINUTE = 1359,
    STR_QUEUE_TIME_MINUTES = 1360,
    STR_CANT_CHANGE_SPEED = 1361,
    STR_CANT_CHANGE_LAUNCH_SPEED = 1362,
    STR_TOO_HIGH_FOR_SUPPORTS = 1363,
    STR_SUPPORTS_CANT_BE_EXTENDED = 1364,
    STR_IN_LINE_TWIST_LEFT = 1365,
    STR_IN_LINE_TWIST_RIGHT = 1366,
    STR_HALF_LOOP = 1367,
    STR_HALF_CORKSCREW_LEFT = 1368,
    STR_HALF_CORKSCREW_RIGHT = 1369,
    STR_BARREL_ROLL_LEFT = 1370,
    STR_BARREL_ROLL_RIGHT = 1371,
    STR_LAUNCHED_LIFT_HILL = 1372,
    STR_LARGE_HALF_LOOP_LEFT = 1373,
    STR_LARGE_HALF_LOOP_RIGHT = 1374,
    STR_UPPER_TRANSFER = 1375,
    STR_LOWER_TRANSFER = 1376,
    STR_HEARTLINE_ROLL_LEFT = 1377,
    STR_HEARTLINE_ROLL_RIGHT = 1378,
    STR_REVERSER_LEFT = 1379,
    STR_REVERSER_RIGHT = 1380,
    STR_CURVED_LIFT_HILL_LEFT = 1381,
    STR_CURVED_LIFT_HILL_RIGHT = 1382,
    STR_QUARTER_LOOP = 1383,
    STR_YELLOW_STRING = 1384,
    STR_RIDE_CONSTRUCTION_OTHER_TRACK_CONFIGURATIONS_TIP = 1385,
    STR_RIDE_CONSTRUCTION_SPECIAL = 1386,
    STR_CANT_CHANGE_LAND_TYPE = 1387,
    STR_MONEY_EFFECT_RECEIVE = 1388,
    STR_MONEY_EFFECT_SPEND = 1389,
    STR_BOTTOM_TOOLBAR_CASH = 1390,
    STR_BOTTOM_TOOLBAR_CASH_NEGATIVE = 1391,
    STR_VIEW_OF_RIDE_ATTRACTION_TIP = 1392,
    STR_VEHICLE_DETAILS_AND_OPTIONS_TIP = 1393,
    STR_OPERATING_OPTIONS_TIP = 1394,
    STR_MAINTENANCE_OPTIONS_TIP = 1395,
    STR_COLOUR_SCHEME_OPTIONS_TIP = 1396,
    STR_SOUND_AND_MUSIC_OPTIONS_TIP = 1397,
    STR_MEASUREMENTS_AND_TEST_DATA_TIP = 1398,
    STR_GRAPHS_TIP = 1399,
    STR_RIDE_CONSTRUCTION_ENTRANCE = 1400,
    STR_RIDE_CONSTRUCTION_EXIT = 1401,
    STR_RIDE_CONSTRUCTION_ENTRANCE_TIP = 1402,
    STR_RIDE_CONSTRUCTION_EXIT_TIP = 1403,
    STR_ROTATE_90_TIP = 1404,
    STR_MIRROR_IMAGE_TIP = 1405,
    STR_TOGGLE_SCENERY_TIP = 1406,
    STR_BUILD_THIS = 1407,
    STR_COST_LABEL = 1408,
    STR_ENTRY_EXIT_PLATFORM = 1409,
    STR_VERTICAL_TOWER = 1410,
    STR_X_IN_THE_WAY = 1411,
    STR_DATA_LOGGING_NOT_AVAILABLE_FOR_THIS_TYPE_OF_RIDE = 1412,
    STR_DATA_LOGGING_WILL_START_WHEN_NEXT_LEAVES = 1413,
    STR_RIDE_STATS_TIME = 1414,
    STR_RIDE_STATS_VELOCITY = 1415,
    STR_RIDE_STATS_ALTITUDE = 1416,
    STR_RIDE_STATS_VERT_G = 1417,
    STR_RIDE_STATS_LAT_G = 1418,
    STR_RIDE_STATS_VELOCITY_FORMAT = 1419,
    STR_RIDE_STATS_ALTITUDE_FORMAT = 1420,
    STR_RIDE_STATS_G_FORCE_FORMAT = 1421,
    STR_LOGGING_DATA_FROM_TIP = 1422,
    STR_QUEUE_LINE_PATH_TIP = 1423,
    STR_FOOTPATH_TIP = 1424,
    STR_FOOTPATH_MAP_TIP = 1425,
    STR_QUEUE_LINE_MAP_TIP = 1426,
    STR_CUSTOMERS_PER_HOUR = 1427,
    STR_RIDE_INCOME_ADMISSION_PRICE = 1428,
    STR_ARG_6_CURRENCY2DP = 1429,
    STR_FREE = 1430,
    STR_WALKING = 1431,
    STR_HEADING_FOR = 1432,
    STR_QUEUING_FOR = 1433,
    STR_DROWNING = 1434,
    STR_ON_RIDE = 1435,
    STR_IN_RIDE = 1436,
    STR_AT_RIDE = 1437,
    STR_SITTING = 1438,
    STR_SELECT_LOCATION = 1439,
    STR_MOWING_GRASS = 1440,
    STR_SWEEPING_FOOTPATH = 1441,
    STR_EMPTYING_LITTER_BIN = 1442,
    STR_WATERING_GARDENS = 1443,
    STR_WATCHING_RIDE = 1444,
    STR_WATCHING_CONSTRUCTION_OF = 1445,
    STR_LOOKING_AT_SCENERY = 1446,
    STR_LEAVING_PARK = 1447,
    STR_WATCHING_NEW_RIDE_BEING_CONSTRUCTED = 1448,
    STR_GUEST_MAP_TIP = 1449,
    STR_TRACKED_GUEST_MAP_TIP = 1450,
    STR_STAFF_MAP_TIP = 1451,
    STR_GUEST_RENAME_TITLE = 1452,
    STR_GUEST_RENAME_PROMPT = 1453,
    STR_CANT_NAME_GUEST = 1454,
    STR_ERR_INVALID_NAME_FOR_GUEST = 1455,
    STR_GUEST_STAT_CASH_SPENT = 1456,
    STR_GUEST_STAT_CASH_IN_POCKET = 1457,
    STR_GUEST_STAT_TIME_IN_PARK = 1458,
    STR_RIDE_CONSTRUCTION_TRACK_STYLE = 1459,
    STR_RIDE_CONSTRUCTION_U_SHAPED_OPEN_TRACK_TIP = 1460,
    STR_RIDE_CONSTRUCTION_O_SHAPED_ENCLOSED_TRACK_TIP = 1461,
    STR_TOO_STEEP_FOR_LIFT_HILL = 1462,
    STR_GUESTS = 1463,
    STR_HELIX_UP_SMALL = 1464,
    STR_HELIX_UP_LARGE = 1465,
    STR_HELIX_DOWN_SMALL = 1466,
    STR_HELIX_DOWN_LARGE = 1467,
    STR_STAFF = 1468,
    STR_RIDE_MUST_START_AND_END_WITH_STATIONS = 1469,
    STR_STATION_NOT_LONG_ENOUGH = 1470,
    STR_SPEED = 1471,
    STR_SPEED_TIP = 1472,
    STR_EXCITEMENT_RATING = 1473,
    STR_EXCITEMENT_RATING_NOT_YET_AVAILABLE = 1474,
    STR_INTENSITY_RATING = 1475,
    STR_INTENSITY_RATING_NOT_YET_AVAILABLE = 1476,
    STR_INTENSITY_RATING_RED = 1477,
    STR_NAUSEA_RATING = 1478,
    STR_NAUSEA_RATING_NOT_YET_AVAILABLE = 1479,
    STR_PEEP_THOUGHT_TYPE_CANT_AFFORD_0 = 1480,
    STR_PEEP_THOUGHT_TYPE_SPENT_MONEY = 1481,
    STR_PEEP_THOUGHT_TYPE_SICK = 1482,
    STR_PEEP_THOUGHT_TYPE_VERY_SICK = 1483,
    STR_PEEP_THOUGHT_TYPE_MORE_THRILLING = 1484,
    STR_PEEP_THOUGHT_TYPE_INTENSE = 1485,
    STR_PEEP_THOUGHT_TYPE_HAVENT_FINISHED = 1486,
    STR_PEEP_THOUGHT_TYPE_SICKENING = 1487,
    STR_PEEP_THOUGHT_TYPE_BAD_VALUE = 1488,
    STR_PEEP_THOUGHT_TYPE_GO_HOME = 1489,
    STR_PEEP_THOUGHT_TYPE_GOOD_VALUE = 1490,
    STR_PEEP_THOUGHT_TYPE_ALREADY_GOT = 1491,
    STR_PEEP_THOUGHT_TYPE_CANT_AFFORD = 1492,
    STR_PEEP_THOUGHT_TYPE_NOT_HUNGRY = 1493,
    STR_PEEP_THOUGHT_TYPE_NOT_THIRSTY = 1494,
    STR_PEEP_THOUGHT_TYPE_DROWNING = 1495,
    STR_PEEP_THOUGHT_TYPE_LOST = 1496,
    STR_PEEP_THOUGHT_TYPE_WAS_GREAT = 1497,
    STR_PEEP_THOUGHT_TYPE_QUEUING_AGES = 1498,
    STR_PEEP_THOUGHT_TYPE_TIRED = 1499,
    STR_PEEP_THOUGHT_TYPE_HUNGRY = 1500,
    STR_PEEP_THOUGHT_TYPE_THIRSTY = 1501,
    STR_PEEP_THOUGHT_TYPE_TOILET = 1502,
    STR_PEEP_THOUGHT_TYPE_CANT_FIND = 1503,
    STR_PEEP_THOUGHT_TYPE_NOT_PAYING = 1504,
    STR_PEEP_THOUGHT_TYPE_NOT_WHILE_RAINING = 1505,
    STR_PEEP_THOUGHT_TYPE_BAD_LITTER = 1506,
    STR_PEEP_THOUGHT_TYPE_CANT_FIND_EXIT = 1507,
    STR_PEEP_THOUGHT_TYPE_GET_OFF = 1508,
    STR_PEEP_THOUGHT_TYPE_GET_OUT = 1509,
    STR_PEEP_THOUGHT_TYPE_NOT_SAFE = 1510,
    STR_PEEP_THOUGHT_TYPE_PATH_DISGUSTING = 1511,
    STR_PEEP_THOUGHT_TYPE_CROWDED = 1512,
    STR_PEEP_THOUGHT_TYPE_VANDALISM = 1513,
    STR_PEEP_THOUGHT_TYPE_SCENERY = 1514,
    STR_PEEP_THOUGHT_TYPE_VERY_CLEAN = 1515,
    STR_PEEP_THOUGHT_TYPE_FOUNTAINS = 1516,
    STR_PEEP_THOUGHT_TYPE_MUSIC = 1517,
    STR_PEEP_THOUGHT_TYPE_BALLOON = 1518,
    STR_PEEP_THOUGHT_TYPE_TOY = 1519,
    STR_PEEP_THOUGHT_TYPE_MAP = 1520,
    STR_PEEP_THOUGHT_TYPE_PHOTO = 1521,
    STR_PEEP_THOUGHT_TYPE_UMBRELLA = 1522,
    STR_PEEP_THOUGHT_TYPE_DRINK = 1523,
    STR_PEEP_THOUGHT_TYPE_BURGER = 1524,
    STR_PEEP_THOUGHT_TYPE_CHIPS = 1525,
    STR_PEEP_THOUGHT_TYPE_ICE_CREAM = 1526,
    STR_PEEP_THOUGHT_TYPE_CANDYFLOSS = 1527,
    // STR_1528    :
    // STR_1529    :
    // STR_1530    :
    STR_PEEP_THOUGHT_TYPE_PIZZA = 1531,
    // STR_1532    :
    STR_PEEP_THOUGHT_TYPE_POPCORN = 1533,
    STR_PEEP_THOUGHT_TYPE_HOT_DOG = 1534,
    STR_PEEP_THOUGHT_TYPE_TENTACLE = 1535,
    STR_PEEP_THOUGHT_TYPE_HAT = 1536,
    STR_PEEP_THOUGHT_TYPE_TOFFEE_APPLE = 1537,
    STR_PEEP_THOUGHT_TYPE_TSHIRT = 1538,
    STR_PEEP_THOUGHT_TYPE_DOUGHNUT = 1539,
    STR_PEEP_THOUGHT_TYPE_COFFEE = 1540,
    // STR_1541    :
    STR_PEEP_THOUGHT_TYPE_CHICKEN = 1542,
    STR_PEEP_THOUGHT_TYPE_LEMONADE = 1543,
    // STR_1544    :
    // STR_1545    :
    // STR_1546    :
    STR_PEEP_THOUGHT_TYPE_WOW = 1547, // This string is empty! STR_1547    :
                                      // STR_1548    :
                                      // STR_1549    :
    STR_PEEP_THOUGHT_TYPE_WOW2 = 1550,
    STR_PEEP_THOUGHT_TYPE_WATCHED = 1551,
    STR_PEEP_THOUGHT_TYPE_BALLOON_MUCH = 1552,
    STR_PEEP_THOUGHT_TYPE_TOY_MUCH = 1553,
    STR_PEEP_THOUGHT_TYPE_MAP_MUCH = 1554,
    STR_PEEP_THOUGHT_TYPE_PHOTO_MUCH = 1555,
    STR_PEEP_THOUGHT_TYPE_UMBRELLA_MUCH = 1556,
    STR_PEEP_THOUGHT_TYPE_DRINK_MUCH = 1557,
    STR_PEEP_THOUGHT_TYPE_BURGER_MUCH = 1558,
    STR_PEEP_THOUGHT_TYPE_CHIPS_MUCH = 1559,
    STR_PEEP_THOUGHT_TYPE_ICE_CREAM_MUCH = 1560,
    STR_PEEP_THOUGHT_TYPE_CANDYFLOSS_MUCH = 1561,
    // STR_1562    :
    // STR_1563    :
    // STR_1564    :
    STR_PEEP_THOUGHT_TYPE_PIZZA_MUCH = 1565,
    // STR_1566    :
    STR_PEEP_THOUGHT_TYPE_POPCORN_MUCH = 1567,
    STR_PEEP_THOUGHT_TYPE_HOT_DOG_MUCH = 1568,
    STR_PEEP_THOUGHT_TYPE_TENTACLE_MUCH = 1569,
    STR_PEEP_THOUGHT_TYPE_HAT_MUCH = 1570,
    STR_PEEP_THOUGHT_TYPE_TOFFEE_APPLE_MUCH = 1571,
    STR_PEEP_THOUGHT_TYPE_TSHIRT_MUCH = 1572,
    STR_PEEP_THOUGHT_TYPE_DOUGHNUT_MUCH = 1573,
    STR_PEEP_THOUGHT_TYPE_COFFEE_MUCH = 1574,
    // STR_1575    :
    STR_PEEP_THOUGHT_TYPE_CHICKEN_MUCH = 1576,
    STR_PEEP_THOUGHT_TYPE_LEMONADE_MUCH = 1577,
    // STR_1578    :
    // STR_1579    :
    // STR_1580    :
    // STR_1581    :
    // STR_1582    :
    // STR_1583    :
    STR_PEEP_THOUGHT_TYPE_PHOTO2 = 1584,
    STR_PEEP_THOUGHT_TYPE_PHOTO3 = 1585,
    STR_PEEP_THOUGHT_TYPE_PHOTO4 = 1586,
    STR_PEEP_THOUGHT_TYPE_PRETZEL = 1587,
    STR_PEEP_THOUGHT_TYPE_HOT_CHOCOLATE = 1588,
    STR_PEEP_THOUGHT_TYPE_ICED_TEA = 1589,
    STR_PEEP_THOUGHT_TYPE_FUNNEL_CAKE = 1590,
    STR_PEEP_THOUGHT_TYPE_SUNGLASSES = 1591,
    STR_PEEP_THOUGHT_TYPE_BEEF_NOODLES = 1592,
    STR_PEEP_THOUGHT_TYPE_FRIED_RICE_NOODLES = 1593,
    STR_PEEP_THOUGHT_TYPE_WONTON_SOUP = 1594,
    STR_PEEP_THOUGHT_TYPE_MEATBALL_SOUP = 1595,
    STR_PEEP_THOUGHT_TYPE_FRUIT_JUICE = 1596,
    STR_PEEP_THOUGHT_TYPE_SOYBEAN_MILK = 1597,
    STR_PEEP_THOUGHT_TYPE_SU_JONGKWA = 1598,
    STR_PEEP_THOUGHT_TYPE_SUB_SANDWICH = 1599,
    STR_PEEP_THOUGHT_TYPE_COOKIE = 1600,
    // STR_1601    :
    // STR_1602    :
    // STR_1603    :
    STR_PEEP_THOUGHT_TYPE_ROAST_SAUSAGE = 1604,
    // STR_1605    :
    // STR_1606    :
    // STR_1607    :
    // STR_1608    :
    // STR_1609    :
    // STR_1610    :
    // STR_1611    :
    // STR_1612    :
    // STR_1613    :
    // STR_1614    :
    // STR_1615    :
    STR_PEEP_THOUGHT_TYPE_PHOTO2_MUCH = 1616,
    STR_PEEP_THOUGHT_TYPE_PHOTO3_MUCH = 1617,
    STR_PEEP_THOUGHT_TYPE_PHOTO4_MUCH = 1618,
    STR_PEEP_THOUGHT_TYPE_PRETZEL_MUCH = 1619,
    STR_PEEP_THOUGHT_TYPE_HOT_CHOCOLATE_MUCH = 1620,
    STR_PEEP_THOUGHT_TYPE_ICED_TEA_MUCH = 1621,
    STR_PEEP_THOUGHT_TYPE_FUNNEL_CAKE_MUCH = 1622,
    STR_PEEP_THOUGHT_TYPE_SUNGLASSES_MUCH = 1623,
    STR_PEEP_THOUGHT_TYPE_BEEF_NOODLES_MUCH = 1624,
    STR_PEEP_THOUGHT_TYPE_FRIED_RICE_NOODLES_MUCH = 1625,
    STR_PEEP_THOUGHT_TYPE_WONTON_SOUP_MUCH = 1626,
    STR_PEEP_THOUGHT_TYPE_MEATBALL_SOUP_MUCH = 1627,
    STR_PEEP_THOUGHT_TYPE_FRUIT_JUICE_MUCH = 1628,
    STR_PEEP_THOUGHT_TYPE_SOYBEAN_MILK_MUCH = 1629,
    STR_PEEP_THOUGHT_TYPE_SU_JONGKWA_MUCH = 1630,
    STR_PEEP_THOUGHT_TYPE_SUB_SANDWICH_MUCH = 1631,
    STR_PEEP_THOUGHT_TYPE_COOKIE_MUCH = 1632,
    // STR_1633    :
    // STR_1634    :
    // STR_1635    :
    STR_PEEP_THOUGHT_TYPE_ROAST_SAUSAGE_MUCH = 1636,
    // STR_1637    :
    // STR_1638    :
    // STR_1639    :
    // STR_1640    :
    // STR_1641    :
    // STR_1642    :
    // STR_1643    :
    // STR_1644    :
    // STR_1645    :
    // STR_1646    :
    // STR_1647    :
    STR_PEEP_THOUGHT_TYPE_HELP = 1648,
    STR_PEEP_THOUGHT_TYPE_RUNNING_OUT = 1649,
    STR_PEEP_THOUGHT_TYPE_NEW_RIDE = 1650,
    STR_PEEP_THOUGHT_TYPE_NICE_RIDE_DEPRECATED = 1651,
    STR_PEEP_THOUGHT_TYPE_EXCITED_DEPRECATED = 1652,
    STR_PEEP_THOUGHT_TYPE_HERE_WE_ARE = 1653,
    STR_GUEST_RECENT_THOUGHTS_LABEL = 1654,
    STR_CONSTRUCT_FOOTPATH_ON_LAND_TIP = 1655,
    STR_CONSTRUCT_BRIDGE_OR_TUNNEL_FOOTPATH_TIP = 1656,
    STR_GUEST_STAT_PREFERRED_RIDE = 1657,
    STR_GUEST_STAT_PREFERRED_INTESITY_BELOW = 1658,
    STR_GUEST_STAT_PREFERRED_INTESITY_BETWEEN = 1659,
    STR_GUEST_STAT_PREFERRED_INTESITY_ABOVE = 1660,
    STR_GUEST_STAT_NAUSEA_TOLERANCE = 1661,
    STR_GUEST_STAT_HAPPINESS_LABEL = 1662,
    STR_GUEST_STAT_NAUSEA_LABEL = 1663,
    STR_GUEST_STAT_ENERGY_LABEL = 1664,
    STR_GUEST_STAT_HUNGER_LABEL = 1665,
    STR_GUEST_STAT_THIRST_LABEL = 1666,
    STR_GUEST_STAT_TOILET_LABEL = 1667,
    STR_SATISFACTION_UNKNOWN = 1668,
    STR_SATISFACTION_PERCENT = 1669,
    STR_TOTAL_CUSTOMERS = 1670,
    STR_TOTAL_PROFIT = 1671,
    STR_BRAKES = 1672,
    STR_SPINNING_CONTROL_TOGGLE_TRACK = 1673,
    STR_RIDE_CONSTRUCTION_BRAKE_SPEED = 1674,
    STR_RIDE_CONSTRUCTION_BRAKE_SPEED_VELOCITY = 1675,
    STR_RIDE_CONSTRUCTION_BRAKE_SPEED_LIMIT_TIP = 1676,
    STR_POPULARITY_UNKNOWN = 1677,
    STR_POPULARITY_PERCENT = 1678,
    STR_HELIX_UP_LEFT = 1679,
    STR_HELIX_UP_RIGHT = 1680,
    STR_HELIX_DOWN_LEFT = 1681,
    STR_HELIX_DOWN_RIGHT = 1682,
    STR_BASE_SIZE_2_X_2 = 1683,
    STR_BASE_SIZE_4_X_4 = 1684,
    STR_BASE_SIZE_2_X_4 = 1685,
    STR_BASE_SIZE_5_X_1 = 1686,
    STR_WATER_SPLASH = 1687,
    STR_BASE_SIZE_4_X_1 = 1688, // Unused
    STR_BLOCK_BRAKES = 1689,
    STR_NEW_RIDE_NAME_AND_DESCRIPTION = 1690,
    STR_NEW_RIDE_COST = 1691,
    STR_NEW_RIDE_COST_FROM = 1692,
    STR_GUESTS_TIP = 1693,
    STR_STAFF_TIP = 1694,
    STR_INCOME_AND_COSTS_TIP = 1695,
    STR_CUSTOMER_INFORMATION_TIP = 1696,
    STR_CANNOT_PLACE_THESE_ON_QUEUE_LINE_AREA = 1697,
    STR_CAN_ONLY_PLACE_THESE_ON_QUEUE_AREA = 1698,
    STR_TOO_MANY_PEOPLE_IN_GAME = 1699,
    STR_HIRE_HANDYMAN = 1700,
    STR_HIRE_MECHANIC = 1701,
    STR_HIRE_SECURITY_GUARD = 1702,
    STR_HIRE_ENTERTAINER = 1703,
    STR_CANT_HIRE_NEW_STAFF = 1704,
    STR_FIRE_STAFF_TIP = 1705,
    STR_PICKUP_TIP = 1706,
    STR_TOO_MANY_STAFF_IN_GAME = 1707,
    STR_SET_PATROL_TIP = 1708,
    STR_SACK_STAFF = 1709,
    STR_YES = 1710,
    STR_FIRE_STAFF_ID = 1711,
    STR_STAFF_OPTION_SWEEP_FOOTPATHS = 1712,
    STR_STAFF_OPTION_WATER_GARDENS = 1713,
    STR_STAFF_OPTION_EMPTY_LITTER = 1714,
    STR_STAFF_OPTION_MOW_GRASS = 1715,
    STR_INVALID_NAME_FOR_PARK = 1716,
    STR_CANT_RENAME_PARK = 1717,
    STR_PARK_NAME = 1718,
    STR_ENTER_PARK_NAME = 1719,
    STR_NAME_PARK_TIP = 1720,
    STR_PARK_CLOSED = 1721,
    STR_PARK_OPEN = 1722,
    STR_CANT_OPEN_PARK = 1723,
    STR_CANT_CLOSE_PARK = 1724,
    STR_CANT_BUY_LAND = 1725,
    STR_LAND_NOT_FOR_SALE = 1726,
    STR_CONSTRUCTION_RIGHTS_NOT_FOR_SALE = 1727,
    STR_CANT_BUY_CONSTRUCTION_RIGHTS_HERE = 1728,
    STR_LAND_NOT_OWNED_BY_PARK = 1729,
    STR_BANNER_TEXT_CLOSED = 1730,
    STR_BANNER_TEXT_FORMAT = 1731,
    STR_RIDE_CONSTRUCTION_BUILD = 1732,
    STR_RIDE_CONSTRUCTION_MODE = 1733,
    STR_NUMBER_OF_LAPS = 1734,
    STR_NUMBER_OF_LAPS_TIP = 1735,
    STR_NUMBER_OF_LAPS_VALUE = 1736,
    // STR_1737    :{COMMA16}
    STR_CANT_CHANGE_NUMBER_OF_LAPS = 1738,
    STR_RACE_WON_BY_GUEST = 1739,
    STR_RACE_WON_BY = 1740,
    STR_NOT_YET_CONSTRUCTED = 1741,
    STR_MAX_PEOPLE_ON_RIDE = 1742,
    STR_MAX_PEOPLE_ON_RIDE_TIP = 1743,
    STR_MAX_PEOPLE_ON_RIDE_VALUE = 1744,
    // STR_1745    :{COMMA16}
    STR_CANT_CHANGE_THIS = 1746,
    STR_TIME_LIMIT = 1747,
    STR_TIME_LIMIT_TIP = 1748,
    STR_RIDE_MODE_TIME_LIMIT_VALUE = 1749,
    // STR_1750    :{DURATION}
    STR_CANT_CHANGE_TIME_LIMIT = 1751,
    STR_INDIVIDUAL_GUESTS_TIP = 1752,
    STR_SUMMARISED_GUESTS_TIP = 1753,
    STR_FORMAT_NUM_GUESTS_PLURAL = 1754,
    STR_FORMAT_NUM_GUESTS_SINGULAR = 1755,
    STR_ADMISSION_PRICE = 1756,
    STR_RELIABILITY_LABEL_1757 = 1757,
    STR_RIDE_CONSTRUCTION_BUILD_MODE = 1758,
    STR_RIDE_CONSTRUCTION_MOVE_MODE = 1759,
    STR_RIDE_CONSTRUCTION_FILL_IN_MODE = 1760,
    STR_RIDE_CONSTRUCTION_BUILD_MAZE_IN_THIS_DIRECTION_TIP = 1761,
    STR_WATERFALLS = 1762,
    STR_RAPIDS = 1763,
    STR_LOG_BUMPS = 1764,
    STR_ON_RIDE_PHOTO_SECTION = 1765,
    STR_REVERSER_TURNTABLE = 1766,
    STR_SPINNING_TUNNEL = 1767,
    STR_CANT_CHANGE_NUMBER_OF_SWINGS = 1768,
    STR_NUMBER_OF_SWINGS = 1769,
    STR_NUMBER_OF_SWINGS_TIP = 1770,
    STR_RIDE_MODE_NUMBER_OF_SWINGS_VALUE = 1771,
    // STR_1772    :{COMMA16}
    STR_ONLY_ONE_ON_RIDE_PHOTO_PER_RIDE = 1773,
    STR_ONLY_ONE_CABLE_LIFT_HILL_PER_RIDE = 1774,
    // STR_OPTIONS_RIDE_MUSIC_OFF = 1775,
    // STR_OPTIONS_RIDE_MUSIC_ON = 1776,
    STR_RIDE_MUSIC = 1777,
    STR_SCROLLING_SIGN_TEXT = 1778,
    STR_STAFF_OPTION_COSTUME_PANDA = 1779,
    STR_STAFF_OPTION_COSTUME_TIGER = 1780,
    STR_STAFF_OPTION_COSTUME_ELEPHANT = 1781,
    STR_STAFF_OPTION_COSTUME_ROMAN = 1782,
    STR_STAFF_OPTION_COSTUME_GORILLA = 1783,
    STR_STAFF_OPTION_COSTUME_SNOWMAN = 1784,
    STR_STAFF_OPTION_COSTUME_KNIGHT = 1785,
    STR_STAFF_OPTION_COSTUME_ASTRONAUT = 1786,
    STR_STAFF_OPTION_COSTUME_BANDIT = 1787,
    STR_STAFF_OPTION_COSTUME_SHERIFF = 1788,
    STR_STAFF_OPTION_COSTUME_PIRATE = 1789,
    STR_UNIFORM_COLOUR_TIP = 1790,
    STR_UNIFORM_COLOUR = 1791,
    STR_RESPONDING_TO_RIDE_BREAKDOWN_CALL = 1792,
    STR_HEADING_TO_RIDE_FOR_INSPECTION = 1793,
    STR_FIXING_RIDE = 1794,
    STR_ANSWERING_RADIO_CALL = 1795,
    STR_HAS_BROKEN_DOWN_AND_REQUIRES_FIXING = 1796,
    // STR_1797    :This option cannot be changed for this ride
    STR_WHIRLPOOL = 1798,
    STR_RIDE_SECONDARY_PRICE_VALUE = 1799,
    STR_RIDE_BREAKDOWN_SAFETY_CUT_OUT = 1800,
    STR_RIDE_BREAKDOWN_RESTRAINTS_STUCK_CLOSED = 1801,
    STR_RIDE_BREAKDOWN_RESTRAINTS_STUCK_OPEN = 1802,
    STR_RIDE_BREAKDOWN_DOORS_STUCK_CLOSED = 1803,
    STR_RIDE_BREAKDOWN_DOORS_STUCK_OPEN = 1804,
    STR_RIDE_BREAKDOWN_VEHICLE_MALFUNCTION = 1805,
    STR_RIDE_BREAKDOWN_BRAKES_FAILURE = 1806,
    STR_RIDE_BREAKDOWN_CONTROL_FAILURE = 1807,
    STR_LAST_BREAKDOWN = 1808,
    STR_CURRENT_BREAKDOWN = 1809,
    STR_CARRYING = 1810,
    STR_CANT_BUILD_THIS_HERE = 1811,
    STR_STRING_DEFINED_TOOLTIP = 1812,
    STR_MISCELLANEOUS = 1813,
    STR_ACTIONS = 1814,
    STR_THOUGHTS = 1815,
    STR_INFORMATION_TYPE_TIP = 1816,
    STR_GUESTS_COUNT_COMMA_SEP = 1817,
    STR_ALL_GUESTS = 1818,
    STR_ALL_GUESTS_SUMMARISED = 1819,
    STR_GUESTS_FILTER = 1820,
    STR_GUESTS_FILTER_THINKING = 1821,
    STR_GUESTS_FILTER_THINKING_ABOUT = 1822,
    STR_SHOW_GUESTS_THOUGHTS_ABOUT_THIS_RIDE_ATTRACTION_TIP = 1823,
    STR_SHOW_GUESTS_ON_THIS_RIDE_ATTRACTION_TIP = 1824,
    STR_SHOW_GUESTS_QUEUING_FOR_THIS_RIDE_ATTRACTION_TIP = 1825,
    STR_STATUS = 1826,
    STR_POPULARITY = 1827,
    STR_SATISFACTION = 1828,
    STR_PROFIT = 1829,
    STR_QUEUE_LENGTH = 1830,
    STR_QUEUE_TIME = 1831,
    STR_RELIABILITY = 1832,
    STR_DOWN_TIME = 1833,
    STR_GUESTS_FAVOURITE = 1834,
    STR_POPULARITY_UNKNOWN_LABEL = 1835,
    STR_POPULARITY_LABEL = 1836,
    STR_SATISFACTION_UNKNOWN_LABEL = 1837,
    STR_SATISFACTION_LABEL = 1838,
    STR_RELIABILITY_LABEL = 1839,
    STR_DOWN_TIME_LABEL = 1840,
    STR_PROFIT_LABEL = 1841,
    STR_GUESTS_FAVOURITE_LABEL = 1842,
    STR_GUESTS_FAVOURITE_PLURAL_LABEL = 1843,
    STR_RIDE_LIST_INFORMATION_TYPE_TIP = 1844,
    // STR_1845    :{MONTHYEAR}  // Used in window_game_bottom_toolbar_onpaint
    STR_BOTTOM_TOOLBAR_NUM_GUESTS_STABLE = 1846,
    STR_BOTTOM_TOOLBAR_NUM_GUESTS_DECREASE = 1847,
    STR_BOTTOM_TOOLBAR_NUM_GUESTS_INCREASE = 1848,
    STR_PLAY_MUSIC = 1849,
    STR_SELECT_MUSIC_TIP = 1850,
    STR_RUNNING_COST_PER_HOUR = 1851,
    STR_RUNNING_COST_UNKNOWN = 1852,
    STR_BUILT_THIS_YEAR = 1853,
    STR_BUILT_LAST_YEAR = 1854,
    STR_BUILT_YEARS_AGO = 1855,
    STR_PROFIT_PER_ITEM_SOLD = 1856,
    STR_LOSS_PER_ITEM_SOLD = 1857,
    STR_COST_PER_MONTH = 1858,
    STR_HANDYMAN_PLURAL = 1859,
    STR_MECHANIC_PLURAL = 1860,
    STR_SECURITY_GUARD_PLURAL = 1861,
    STR_ENTERTAINER_PLURAL = 1862,
    STR_HANDYMAN_SINGULAR = 1863,
    STR_MECHANIC_SINGULAR = 1864,
    STR_SECURITY_GUARD_SINGULAR = 1865,
    STR_ENTERTAINER_SINGULAR = 1866,
    STR_STAFF_LIST_COUNTER = 1867,
    STR_CANT_CHANGE_NUMBER_OF_ROTATIONS = 1868,
    STR_NUMBER_OF_ROTATIONS = 1869,
    STR_NUMBER_OF_ROTATIONS_TIP = 1870,
    STR_NUMBER_OF_ROTATIONS_VALUE = 1871,
    // STR_1872    :{COMMA16}
    STR_INCOME_PER_HOUR = 1873,
    STR_PROFIT_PER_HOUR = 1874,
    STR_GUEST_ITEM_FORMAT = 1875,
    STR_INSPECT_RIDES = 1876,
    STR_FIX_RIDES = 1877,
    STR_INSPECTION = 1878,
    STR_EVERY_10_MINUTES = 1879,
    STR_EVERY_20_MINUTES = 1880,
    STR_EVERY_30_MINUTES = 1881,
    STR_EVERY_45_MINUTES = 1882,
    STR_EVERY_HOUR = 1883,
    STR_EVERY_2_HOURS = 1884,
    STR_NEVER = 1885,
    STR_INSPECTING_RIDE = 1886,
    STR_TIME_SINCE_LAST_INSPECTION_MINUTES = 1887,
    STR_TIME_SINCE_LAST_INSPECTION_MORE_THAN_4_HOURS = 1888,
    STR_DOWN_TIME_LABEL_1889 = 1889,
    STR_SELECT_HOW_OFTEN_A_MECHANIC_SHOULD_CHECK_THIS_RIDE = 1890,
    STR_NO_THING_IN_PARK_YET = 1891,
    // STR_1892    :<removed string - do not use>
    // STR_1893    :<removed string - do not use>
    STR_ITEMS_SOLD = 1894,
    STR_BUILD_RIDE_TIP = 1895,
    STR_FINANCES_SUMMARY_EXPENDITURE_INCOME = 1896,
    STR_FINANCES_SUMMARY_RIDE_CONSTRUCTION = 1897,
    STR_FINANCES_SUMMARY_RIDE_RUNNING_COSTS = 1898,
    STR_FINANCES_SUMMARY_LAND_PURCHASE = 1899,
    STR_FINANCES_SUMMARY_LANDSCAPING = 1900,
    STR_FINANCES_SUMMARY_PARK_ENTRANCE_TICKETS = 1901,
    STR_FINANCES_SUMMARY_RIDE_TICKETS = 1902,
    STR_FINANCES_SUMMARY_SHOP_SALES = 1903,
    STR_FINANCES_SUMMARY_SHOP_STOCK = 1904,
    STR_FINANCES_SUMMARY_FOOD_DRINK_SALES = 1905,
    STR_FINANCES_SUMMARY_FOOD_DRINK_STOCK = 1906,
    STR_FINANCES_SUMMARY_STAFF_WAGES = 1907,
    STR_FINANCES_SUMMARY_MARKETING = 1908,
    STR_FINANCES_SUMMARY_RESEARCH = 1909,
    STR_FINANCES_SUMMARY_LOAN_INTEREST = 1910,
    STR_FINANCES_SUMMARY_AT_X_PER_YEAR = 1911,
    STR_FINANCES_SUMMARY_MONTH_HEADING = 1912,
    STR_FINANCES_SUMMARY_INCOME_VALUE = 1913,
    STR_FINANCES_SUMMARY_EXPENDITURE_VALUE = 1914,
    STR_FINANCES_SUMMARY_LOSS_VALUE = 1915,
    STR_FINANCES_SUMMARY_LOAN = 1916,
    STR_FINANCES_SUMMARY_LOAN_VALUE = 1917,
    STR_CANT_BORROW_ANY_MORE_MONEY = 1918,
    STR_NOT_ENOUGH_CASH_AVAILABLE = 1919,
    STR_CANT_PAY_BACK_LOAN = 1920,
    STR_START_NEW_GAME_TIP = 1921,
    STR_CONTINUE_SAVED_GAME_TIP = 1922,
    STR_EXIT = 1924,
    STR_ERR_CANT_PLACE_PERSON_HERE = 1925,
    // STR_1926    :<removed string - do not use>
    STR_RIDE_IS_BROKEN_DOWN = 1927,
    STR_RIDE_HAS_CRASHED = 1928,
    STR_RIDE_IS_STILL_NOT_FIXED = 1929,
    STR_TOGGLE_GUEST_TRACKING_TIP = 1930,
    STR_PEEP_TRACKING_PEEP_JOINED_QUEUE_FOR_X = 1931,
    STR_PEEP_TRACKING_PEEP_IS_ON_X = 1932,
    STR_PEEP_TRACKING_PEEP_IS_IN_X = 1933,
    STR_PEEP_TRACKING_LEFT_RIDE_X = 1934,
    STR_PEEP_TRACKING_LEFT_PARK = 1935,
    STR_PEEP_TRACKING_NOTIFICATION_BOUGHT_X = 1936,
    STR_SHOW_SUBJECT_TIP = 1937,
    STR_SHOW_GUEST_VIEW_TIP = 1938,
    STR_STAFF_OVERVIEW_TIP = 1939,
    STR_SHOW_GUEST_NEEDS_TIP = 1940,
    STR_SHOW_GUEST_VISITED_RIDES_TIP = 1941,
    STR_SHOW_GUEST_FINANCE_TIP = 1942,
    STR_SHOW_GUEST_THOUGHTS_TIP = 1943,
    STR_SHOW_GUEST_ITEMS_TIP = 1944,
    STR_STAFF_OPTIONS_TIP = 1945,
    STR_SELECT_COSTUME_TIP = 1946,
    STR_SHOW_PATROL_AREA_TIP = 1947,
    STR_HIRE_STAFF_TIP = 1948,
    STR_FINANCIAL_SUMMARY = 1949,
    STR_FINANCIAL_GRAPH = 1950,
    STR_PARK_VALUE_GRAPH = 1951,
    STR_PROFIT_GRAPH = 1952,
    STR_MARKETING = 1953,
    STR_RESEARCH_FUNDING = 1954,
    STR_NUMBER_OF_CIRCUITS = 1955,
    STR_NUMBER_OF_CIRCUITS_TIP = 1956,
    STR_NUMBER_OF_CIRCUITS_VALUE = 1957,
    // STR_1958    :{COMMA16}
    // STR_1959    :Can't change number of circuits...
    STR_SHOP_ITEM_PRICE_LABEL_BALLOON = 1960,
    STR_SHOP_ITEM_PRICE_LABEL_CUDDLY_TOY = 1961,
    STR_SHOP_ITEM_PRICE_LABEL_PARK_MAP = 1962,
    STR_SHOP_ITEM_PRICE_LABEL_ON_RIDE_PHOTO = 1963,
    STR_SHOP_ITEM_PRICE_LABEL_UMBRELLA = 1964,
    STR_SHOP_ITEM_PRICE_LABEL_DRINK = 1965,
    STR_SHOP_ITEM_PRICE_LABEL_BURGER = 1966,
    STR_SHOP_ITEM_PRICE_LABEL_CHIPS = 1967,
    STR_SHOP_ITEM_PRICE_LABEL_ICE_CREAM = 1968,
    STR_SHOP_ITEM_PRICE_LABEL_CANDYFLOSS = 1969,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_CAN = 1970,        // Empty
    STR_SHOP_ITEM_PRICE_LABEL_RUBBISH = 1971,          // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BURGER_BOX = 1972, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_PIZZA = 1973,
    STR_SHOP_ITEM_PRICE_LABEL_VOUCHER = 1974, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_POPCORN = 1975,
    STR_SHOP_ITEM_PRICE_LABEL_HOT_DOG = 1976,
    STR_SHOP_ITEM_PRICE_LABEL_TENTACLE = 1977,
    STR_SHOP_ITEM_PRICE_LABEL_HAT = 1978,
    STR_SHOP_ITEM_PRICE_LABEL_TOFFEE_APPLE = 1979,
    STR_SHOP_ITEM_PRICE_LABEL_T_SHIRT = 1980,
    STR_SHOP_ITEM_PRICE_LABEL_DOUGHNUT = 1981,
    STR_SHOP_ITEM_PRICE_LABEL_COFFEE = 1982,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_CUP = 1983, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_FRIED_CHICKEN = 1984,
    STR_SHOP_ITEM_PRICE_LABEL_LEMONADE = 1985,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOX = 1986,    // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOTTLE = 1987, // Empty
    STR_SHOP_ITEM_SINGULAR_BALLOON = 1988,
    STR_SHOP_ITEM_SINGULAR_CUDDLY_TOY = 1989,
    STR_SHOP_ITEM_SINGULAR_PARK_MAP = 1990,
    STR_SHOP_ITEM_SINGULAR_ON_RIDE_PHOTO = 1991,
    STR_SHOP_ITEM_SINGULAR_UMBRELLA = 1992,
    STR_SHOP_ITEM_SINGULAR_DRINK = 1993,
    STR_SHOP_ITEM_SINGULAR_BURGER = 1994,
    STR_SHOP_ITEM_SINGULAR_CHIPS = 1995,
    STR_SHOP_ITEM_SINGULAR_ICE_CREAM = 1996,
    STR_SHOP_ITEM_SINGULAR_CANDYFLOSS = 1997,
    STR_SHOP_ITEM_SINGULAR_EMPTY_CAN = 1998,
    STR_SHOP_ITEM_SINGULAR_RUBBISH = 1999,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BURGER_BOX = 2000,
    STR_SHOP_ITEM_SINGULAR_PIZZA = 2001,
    STR_SHOP_ITEM_SINGULAR_VOUCHER = 2002,
    STR_SHOP_ITEM_SINGULAR_POPCORN = 2003,
    STR_SHOP_ITEM_SINGULAR_HOT_DOG = 2004,
    STR_SHOP_ITEM_SINGULAR_TENTACLE = 2005,
    STR_SHOP_ITEM_SINGULAR_HAT = 2006,
    STR_SHOP_ITEM_SINGULAR_TOFFEE_APPLE = 2007,
    STR_SHOP_ITEM_SINGULAR_T_SHIRT = 2008,
    STR_SHOP_ITEM_SINGULAR_DOUGHNUT = 2009,
    STR_SHOP_ITEM_SINGULAR_COFFEE = 2010,
    STR_SHOP_ITEM_SINGULAR_EMPTY_CUP = 2011,
    STR_SHOP_ITEM_SINGULAR_FRIED_CHICKEN = 2012,
    STR_SHOP_ITEM_SINGULAR_LEMONADE = 2013,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOX = 2014,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOTTLE = 2015,
    STR_SHOP_ITEM_PLURAL_BALLOON = 2016,
    STR_SHOP_ITEM_PLURAL_CUDDLY_TOY = 2017,
    STR_SHOP_ITEM_PLURAL_PARK_MAP = 2018,
    STR_SHOP_ITEM_PLURAL_ON_RIDE_PHOTO = 2019,
    STR_SHOP_ITEM_PLURAL_UMBRELLA = 2020,
    STR_SHOP_ITEM_PLURAL_DRINK = 2021,
    STR_SHOP_ITEM_PLURAL_BURGER = 2022,
    STR_SHOP_ITEM_PLURAL_CHIPS = 2023,
    STR_SHOP_ITEM_PLURAL_ICE_CREAM = 2024,
    STR_SHOP_ITEM_PLURAL_CANDYFLOSS = 2025,
    STR_SHOP_ITEM_PLURAL_EMPTY_CAN = 2026,
    STR_SHOP_ITEM_PLURAL_RUBBISH = 2027,
    STR_SHOP_ITEM_PLURAL_EMPTY_BURGER_BOX = 2028,
    STR_SHOP_ITEM_PLURAL_PIZZA = 2029,
    STR_SHOP_ITEM_PLURAL_VOUCHER = 2030,
    STR_SHOP_ITEM_PLURAL_POPCORN = 2031,
    STR_SHOP_ITEM_PLURAL_HOT_DOG = 2032,
    STR_SHOP_ITEM_PLURAL_TENTACLE = 2033,
    STR_SHOP_ITEM_PLURAL_HAT = 2034,
    STR_SHOP_ITEM_PLURAL_TOFFEE_APPLE = 2035,
    STR_SHOP_ITEM_PLURAL_T_SHIRT = 2036,
    STR_SHOP_ITEM_PLURAL_DOUGHNUT = 2037,
    STR_SHOP_ITEM_PLURAL_COFFEE = 2038,
    STR_SHOP_ITEM_PLURAL_EMPTY_CUP = 2039,
    STR_SHOP_ITEM_PLURAL_FRIED_CHICKEN = 2040,
    STR_SHOP_ITEM_PLURAL_LEMONADE = 2041,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOX = 2042,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOTTLE = 2043,
    STR_SHOP_ITEM_INDEFINITE_BALLOON = 2044,
    STR_SHOP_ITEM_INDEFINITE_CUDDLY_TOY = 2045,
    STR_SHOP_ITEM_INDEFINITE_PARK_MAP = 2046,
    STR_SHOP_ITEM_INDEFINITE_ON_RIDE_PHOTO = 2047,
    STR_SHOP_ITEM_INDEFINITE_UMBRELLA = 2048,
    STR_SHOP_ITEM_INDEFINITE_DRINK = 2049,
    STR_SHOP_ITEM_INDEFINITE_BURGER = 2050,
    STR_SHOP_ITEM_INDEFINITE_CHIPS = 2051,
    STR_SHOP_ITEM_INDEFINITE_ICE_CREAM = 2052,
    STR_SHOP_ITEM_INDEFINITE_CANDYFLOSS = 2053,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_CAN = 2054,
    STR_SHOP_ITEM_INDEFINITE_RUBBISH = 2055,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BURGER_BOX = 2056,
    STR_SHOP_ITEM_INDEFINITE_PIZZA = 2057,
    STR_SHOP_ITEM_INDEFINITE_VOUCHER = 2058,
    STR_SHOP_ITEM_INDEFINITE_POPCORN = 2059,
    STR_SHOP_ITEM_INDEFINITE_HOT_DOG = 2060,
    STR_SHOP_ITEM_INDEFINITE_TENTACLE = 2061,
    STR_SHOP_ITEM_INDEFINITE_HAT = 2062,
    STR_SHOP_ITEM_INDEFINITE_TOFFEE_APPLE = 2063,
    STR_SHOP_ITEM_INDEFINITE_T_SHIRT = 2064,
    STR_SHOP_ITEM_INDEFINITE_DOUGHNUT = 2065,
    STR_SHOP_ITEM_INDEFINITE_COFFEE = 2066,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_CUP = 2067,
    STR_SHOP_ITEM_INDEFINITE_FRIED_CHICKEN = 2068,
    STR_SHOP_ITEM_INDEFINITE_LEMONADE = 2069,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOX = 2070,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOTTLE = 2071,
    STR_SHOP_ITEM_DISPLAY_BALLOON = 2072,
    STR_SHOP_ITEM_DISPLAY_CUDDLY_TOY = 2073,
    STR_SHOP_ITEM_DISPLAY_PARK_MAP = 2074,
    STR_SHOP_ITEM_DISPLAY_ON_RIDE_PHOTO = 2075,
    STR_SHOP_ITEM_DISPLAY_UMBRELLA = 2076,
    STR_SHOP_ITEM_DISPLAY_DRINK = 2077,
    STR_SHOP_ITEM_DISPLAY_BURGER = 2078,
    STR_SHOP_ITEM_DISPLAY_CHIPS = 2079,
    STR_SHOP_ITEM_DISPLAY_ICE_CREAM = 2080,
    STR_SHOP_ITEM_DISPLAY_CANDYFLOSS = 2081,
    STR_SHOP_ITEM_DISPLAY_EMPTY_CAN = 2082,
    STR_SHOP_ITEM_DISPLAY_RUBBISH = 2083,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BURGER_BOX = 2084,
    STR_SHOP_ITEM_DISPLAY_PIZZA = 2085,
    STR_SHOP_ITEM_DISPLAY_VOUCHER = 2086,
    STR_SHOP_ITEM_DISPLAY_POPCORN = 2087,
    STR_SHOP_ITEM_DISPLAY_HOT_DOG = 2088,
    STR_SHOP_ITEM_DISPLAY_TENTACLE = 2089,
    STR_SHOP_ITEM_DISPLAY_HAT = 2090,
    STR_SHOP_ITEM_DISPLAY_TOFFEE_APPLE = 2091,
    STR_SHOP_ITEM_DISPLAY_T_SHIRT = 2092,
    STR_SHOP_ITEM_DISPLAY_DOUGHNUT = 2093,
    STR_SHOP_ITEM_DISPLAY_COFFEE = 2094,
    STR_SHOP_ITEM_DISPLAY_EMPTY_CUP = 2095,
    STR_SHOP_ITEM_DISPLAY_FRIED_CHICKEN = 2096,
    STR_SHOP_ITEM_DISPLAY_LEMONADE = 2097,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOX = 2098,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOTTLE = 2099,

    STR_SHOP_ITEM_PRICE_LABEL_PRETZEL = 2103,
    STR_SHOP_ITEM_PRICE_LABEL_HOT_CHOCOLATE = 2104,
    STR_SHOP_ITEM_PRICE_LABEL_ICED_TEA = 2105,
    STR_SHOP_ITEM_PRICE_LABEL_FUNNEL_CAKE = 2106,
    STR_SHOP_ITEM_PRICE_LABEL_SUNGLASSES = 2107,
    STR_SHOP_ITEM_PRICE_LABEL_BEEF_NOODLES = 2108,
    STR_SHOP_ITEM_PRICE_LABEL_FRIED_RICE_NOODLES = 2109,
    STR_SHOP_ITEM_PRICE_LABEL_WONTON_SOUP = 2110,
    STR_SHOP_ITEM_PRICE_LABEL_MEATBALL_SOUP = 2111,
    STR_SHOP_ITEM_PRICE_LABEL_FRUIT_JUICE = 2112,
    STR_SHOP_ITEM_PRICE_LABEL_SOYBEAN_MILK = 2113,
    STR_SHOP_ITEM_PRICE_LABEL_SUJONGKWA = 2114,
    STR_SHOP_ITEM_PRICE_LABEL_SUB_SANDWICH = 2115,
    STR_SHOP_ITEM_PRICE_LABEL_COOKIE = 2116,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOWL_RED = 2117,     // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_DRINK_CARTON = 2118, // Empty
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_JUICE_CUP = 2119,    // Empty
    STR_SHOP_ITEM_PRICE_LABEL_ROAST_SAUSAGE = 2120,
    STR_SHOP_ITEM_PRICE_LABEL_EMPTY_BOWL_BLUE = 2121, // Empty

    STR_SHOP_ITEM_SINGULAR_PRETZEL = 2125,
    STR_SHOP_ITEM_SINGULAR_HOT_CHOCOLATE = 2126,
    STR_SHOP_ITEM_SINGULAR_ICED_TEA = 2127,
    STR_SHOP_ITEM_SINGULAR_FUNNEL_CAKE = 2128,
    STR_SHOP_ITEM_SINGULAR_SUNGLASSES = 2129,
    STR_SHOP_ITEM_SINGULAR_BEEF_NOODLES = 2130,
    STR_SHOP_ITEM_SINGULAR_FRIED_RICE_NOODLES = 2131,
    STR_SHOP_ITEM_SINGULAR_WONTON_SOUP = 2132,
    STR_SHOP_ITEM_SINGULAR_MEATBALL_SOUP = 2133,
    STR_SHOP_ITEM_SINGULAR_FRUIT_JUICE = 2134,
    STR_SHOP_ITEM_SINGULAR_SOYBEAN_MILK = 2135,
    STR_SHOP_ITEM_SINGULAR_SUJONGKWA = 2136,
    STR_SHOP_ITEM_SINGULAR_SUB_SANDWICH = 2137,
    STR_SHOP_ITEM_SINGULAR_COOKIE = 2138,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOWL_RED = 2139,
    STR_SHOP_ITEM_SINGULAR_EMPTY_DRINK_CARTON = 2140,
    STR_SHOP_ITEM_SINGULAR_EMPTY_JUICE_CUP = 2141,
    STR_SHOP_ITEM_SINGULAR_ROAST_SAUSAGE = 2142,
    STR_SHOP_ITEM_SINGULAR_EMPTY_BOWL_BLUE = 2143,

    STR_SHOP_ITEM_PLURAL_PRETZEL = 2147,
    STR_SHOP_ITEM_PLURAL_HOT_CHOCOLATE = 2148,
    STR_SHOP_ITEM_PLURAL_ICED_TEA = 2149,
    STR_SHOP_ITEM_PLURAL_FUNNEL_CAKE = 2150,
    STR_SHOP_ITEM_PLURAL_SUNGLASSES = 2151,
    STR_SHOP_ITEM_PLURAL_BEEF_NOODLES = 2152,
    STR_SHOP_ITEM_PLURAL_FRIED_RICE_NOODLES = 2153,
    STR_SHOP_ITEM_PLURAL_WONTON_SOUP = 2154,
    STR_SHOP_ITEM_PLURAL_MEATBALL_SOUP = 2155,
    STR_SHOP_ITEM_PLURAL_FRUIT_JUICE = 2156,
    STR_SHOP_ITEM_PLURAL_SOYBEAN_MILK = 2157,
    STR_SHOP_ITEM_PLURAL_SUJONGKWA = 2158,
    STR_SHOP_ITEM_PLURAL_SUB_SANDWICH = 2159,
    STR_SHOP_ITEM_PLURAL_COOKIE = 2160,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOWL_RED = 2161,
    STR_SHOP_ITEM_PLURAL_EMPTY_DRINK_CARTON = 2162,
    STR_SHOP_ITEM_PLURAL_EMPTY_JUICE_CUP = 2163,
    STR_SHOP_ITEM_PLURAL_ROAST_SAUSAGE = 2164,
    STR_SHOP_ITEM_PLURAL_EMPTY_BOWL_BLUE = 2165,

    STR_SHOP_ITEM_INDEFINITE_PRETZEL = 2169,
    STR_SHOP_ITEM_INDEFINITE_HOT_CHOCOLATE = 2170,
    STR_SHOP_ITEM_INDEFINITE_ICED_TEA = 2171,
    STR_SHOP_ITEM_INDEFINITE_FUNNEL_CAKE = 2172,
    STR_SHOP_ITEM_INDEFINITE_SUNGLASSES = 2173,
    STR_SHOP_ITEM_INDEFINITE_BEEF_NOODLES = 2174,
    STR_SHOP_ITEM_INDEFINITE_FRIED_RICE_NOODLES = 2175,
    STR_SHOP_ITEM_INDEFINITE_WONTON_SOUP = 2176,
    STR_SHOP_ITEM_INDEFINITE_MEATBALL_SOUP = 2177,
    STR_SHOP_ITEM_INDEFINITE_FRUIT_JUICE = 2178,
    STR_SHOP_ITEM_INDEFINITE_SOYBEAN_MILK = 2179,
    STR_SHOP_ITEM_INDEFINITE_SUJONGKWA = 2180,
    STR_SHOP_ITEM_INDEFINITE_SUB_SANDWICH = 2181,
    STR_SHOP_ITEM_INDEFINITE_COOKIE = 2182,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOWL_RED = 2183,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_DRINK_CARTON = 2184,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_JUICE_CUP = 2185,
    STR_SHOP_ITEM_INDEFINITE_ROAST_SAUSAGE = 2186,
    STR_SHOP_ITEM_INDEFINITE_EMPTY_BOWL_BLUE = 2187,

    STR_SHOP_ITEM_DISPLAY_PRETZEL = 2191,
    STR_SHOP_ITEM_DISPLAY_HOT_CHOCOLATE = 2192,
    STR_SHOP_ITEM_DISPLAY_ICED_TEA = 2193,
    STR_SHOP_ITEM_DISPLAY_FUNNEL_CAKE = 2194,
    STR_SHOP_ITEM_DISPLAY_SUNGLASSES = 2195,
    STR_SHOP_ITEM_DISPLAY_BEEF_NOODLES = 2196,
    STR_SHOP_ITEM_DISPLAY_FRIED_RICE_NOODLES = 2197,
    STR_SHOP_ITEM_DISPLAY_WONTON_SOUP = 2198,
    STR_SHOP_ITEM_DISPLAY_MEATBALL_SOUP = 2199,
    STR_SHOP_ITEM_DISPLAY_FRUIT_JUICE = 2200,
    STR_SHOP_ITEM_DISPLAY_SOYBEAN_MILK = 2201,
    STR_SHOP_ITEM_DISPLAY_SUJONGKWA = 2202,
    STR_SHOP_ITEM_DISPLAY_SUB_SANDWICH = 2203,
    STR_SHOP_ITEM_DISPLAY_COOKIE = 2204,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOWL_RED = 2205,
    STR_SHOP_ITEM_DISPLAY_EMPTY_DRINK_CARTON = 2206,
    STR_SHOP_ITEM_DISPLAY_EMPTY_JUICE_CUP = 2207,
    STR_SHOP_ITEM_DISPLAY_ROAST_SAUSAGE = 2208,
    STR_SHOP_ITEM_DISPLAY_EMPTY_BOWL_BLUE = 2209,
    STR_STAFF_HANDYMEN_TAB_TIP = 2210,
    STR_STAFF_MECHANICS_TAB_TIP = 2211,
    STR_STAFF_SECURITY_TAB_TIP = 2212,
    STR_STAFF_ENTERTAINERS_TAB_TIP = 2213,
    STR_CONSTRUCTION_NOT_POSSIBLE_WHILE_GAME_IS_PAUSED = 2214,
    STR_RIDE_MAP_TIP = 2215,
    STR_CELSIUS_VALUE = 2216,
    STR_FAHRENHEIT_VALUE = 2217,
    STR_NEWS_VEHICLE_HAS_STALLED = 2218,
    STR_X_PEOPLE_DIED_ON_X = 2219,
    STR_PARK_RATING_LABEL = 2220,
    STR_PARK_RATING_TIP = 2221,
    STR_GRAPH_LABEL = 2222,
    STR_GUESTS_IN_PARK_LABEL = 2223,
    STR_CASH_LABEL = 2224,
    STR_CASH_NEGATIVE_LABEL = 2225,
    STR_PARK_VALUE_LABEL = 2226,
    STR_COMPANY_VALUE_LABEL = 2227,
    STR_LAST_MONTH_PROFIT_FROM_FOOD_DRINK_MERCHANDISE_SALES_LABEL = 2228,
    STR_SLOPE_UP_TO_VERTICAL = 2229,
    STR_VERTICAL_TRACK = 2230,
    STR_HOLDING_BRAKE_FOR_DROP = 2231,
    STR_CABLE_LIFT_HILL = 2232,
    STR_PARK_INFORMATION_TIP = 2233,
    STR_RECENT_MESSAGES = 2234,
    STR_NEWS_DATE_FORMAT = 2235,
    STR_MONTH_JANUARY = 2236,  // unused
    STR_MONTH_FEBRUARY = 2237, // unused
    STR_MONTH_MARCH = 2238,
    STR_MONTH_APRIL = 2239,
    STR_MONTH_MAY = 2240,
    STR_MONTH_JUNE = 2241,
    STR_MONTH_JULY = 2242,
    STR_MONTH_AUGUST = 2243,
    STR_MONTH_SEPTEMBER = 2244,
    STR_MONTH_OCTOBER = 2245,
    STR_MONTH_NOVEMBER = 2246, // unused
    STR_MONTH_DECEMBER = 2247, // unused
    STR_CANT_DEMOLISH_RIDE = 2248,
    STR_NEWS_ITEM_RESEARCH_NEW_RIDE_AVAILABLE = 2249,
    STR_NEWS_ITEM_RESEARCH_NEW_SCENERY_SET_AVAILABLE = 2250,
    // STR_2251    :Can only be built on paths!
    STR_CAN_ONLY_BE_BUILT_ACROSS_PATHS = 2252,
    STR_RESEARCH_NEW_TRANSPORT_RIDES = 2253,
    STR_RESEARCH_NEW_GENTLE_RIDES = 2254,
    STR_RESEARCH_NEW_ROLLER_COASTERS = 2255,
    STR_RESEARCH_NEW_THRILL_RIDES = 2256,
    STR_RESEARCH_NEW_WATER_RIDES = 2257,
    STR_RESEARCH_NEW_SHOPS_AND_STALLS = 2258,
    STR_RESEARCH_NEW_SCENERY_AND_THEMING = 2259,
    STR_RESEARCH_FUNDING_NONE = 2260,
    STR_RESEARCH_FUNDING_MINIMUM = 2261,
    STR_RESEARCH_FUNDING_NORMAL = 2262,
    STR_RESEARCH_FUNDING_MAXIMUM = 2263,
    STR_RESEARCH_FUNDING_ = 2264,
    STR_RESEARCH_COST_PER_MONTH = 2265,
    STR_RESEARCH_PRIORITIES = 2266,
    STR_CURRENTLY_IN_DEVELOPMENT = 2267,
    STR_LAST_DEVELOPMENT = 2268,
    STR_RESEARCH_TYPE_LABEL = 2269,
    STR_RESEARCH_PROGRESS_LABEL = 2270,
    STR_RESEARCH_EXPECTED_LABEL = 2271,
    STR_RESEARCH_RIDE_LABEL = 2272,
    STR_RESEARCH_SCENERY_LABEL = 2273,
    STR_RESEARCH_SHOW_DETAILS_TIP = 2274,
    STR_FINANCES_RESEARCH_TIP = 2275,
    STR_RESEARCH_AND_DEVELOPMENT_TIP = 2276,
    STR_RESEARCH_UNKNOWN = 2277,
    STR_RESEARCH_CATEGORY_TRANSPORT = 2278,
    STR_RESEARCH_CATEGORY_GENTLE = 2279,
    STR_RESEARCH_CATEGORY_ROLLERCOASTER = 2280,
    STR_RESEARCH_CATEGORY_THRILL = 2281,
    STR_RESEARCH_CATEGORY_WATER = 2282,
    STR_RESEARCH_CATEGORY_SHOP = 2283,
    STR_RESEARCH_CATEGORY_SCENERY_GROUP = 2284,
    STR_RESEARCH_STAGE_INITIAL_RESEARCH = 2285,
    STR_RESEARCH_STAGE_DESIGNING = 2286,
    STR_RESEARCH_STAGE_COMPLETING_DESIGN = 2287,
    STR_RESEARCH_STAGE_UNKNOWN = 2288,
    STR_RESEARCH_EXPECTED_FORMAT = 2289,
    // STR_2290    :<removed string - do not use>
    STR_SELECT_SCENARIO = 2291,
    STR_GUEST_LABEL_RIDES_BEEN_ON = 2292,
    STR_NOTHING = 2293,
    STR_CHANGE_BASE_LAND_TIP = 2294,
    STR_CHANGE_VERTICAL_LAND_TIP = 2295,
    STR_GUEST_EXPENSES_ENTRANCE_FEE = 2296,
    STR_GUEST_EXPENSES_RIDE = 2297,
    STR_GUEST_EXPENSES_RIDE_PLURAL = 2298,
    STR_GUEST_EXPENSES_FOOD = 2299,
    STR_GUEST_EXPENSES_FOOD_PLURAL = 2300,
    STR_GUEST_EXPENSES_DRINK = 2301,
    STR_GUEST_EXPENSES_DRINK_PLURAL = 2302,
    STR_GUEST_EXPENSES_SOUVENIR = 2303,
    STR_GUEST_EXPENSES_SOUVENIR_PLURAL = 2304,
    // STR_2305    :Track design files
    // STR_2306    :Save track design
    STR_SELECT_DESIGN = 2307,
    STR_TRACK_DESIGNS = 2308,
    STR_TRACK_DESIGN_INSTALL_WINDOW_TITLE = 2309,
    STR_BUILD_CUSTOM_DESIGN = 2310,
    STR_TRACK_LIST_EXCITEMENT_RATING = 2311,
    STR_TRACK_LIST_INTENSITY_RATING = 2312,
    STR_TRACK_LIST_NAUSEA_RATING = 2313,
    STR_TRACK_LIST_RIDE_LENGTH = 2314,
    STR_TRACK_LIST_COST_AROUND = 2315,
    STR_TRACK_LIST_SPACE_REQUIRED = 2316,
    // STR_2317    :<removed string - do not use>
    // STR_2318    :<removed string - do not use>
    // STR_2319    :<removed string - do not use>
    // STR_2320    :<removed string - do not use>
    STR_NUMBER_OF_RIDES_LABEL = 2321,
    STR_STAFF_LABEL = 2322,
    STR_PARK_SIZE_METRIC_LABEL = 2323,
    STR_PARK_SIZE_IMPERIAL_LABEL = 2324,
    STR_BUY_LAND_RIGHTS_TIP = 2325,
    STR_BUY_CONSTRUCTION_RIGHTS_TIP = 2326,
    STR_OPTIONS = 2327,
    STR_CURRENCY = 2328,
    STR_DISTANCE_AND_SPEED = 2329,
    STR_TEMPERATURE = 2330,
    STR_HEIGHT_LABELS = 2331,
    STR_UNITS = 2332,
    STR_SOUND_EFFECTS = 2333,
    STR_POUNDS = 2334,
    STR_DOLLARS = 2335,
    STR_FRANC = 2336,
    STR_DEUTSCHE_MARK = 2337,
    STR_YEN = 2338,
    STR_PESETA = 2339,
    STR_LIRA = 2340,
    STR_GUILDERS = 2341,
    STR_KRONA = 2342,
    STR_EUROS = 2343,
    STR_IMPERIAL = 2344,
    STR_METRIC = 2345,
    // STR_DISPLAY = 2346, // Unused
    STR_NEWS_ITEM_GUEST_DROWNED = 2347,
    STR_STAFF_STATS_TIP = 2348,
    STR_STAFF_STAT_WAGES = 2349,
    STR_STAFF_STAT_EMPLOYED_FOR = 2350,
    STR_STAFF_STAT_LAWNS_MOWN = 2351,
    STR_STAFF_STAT_GARDENS_WATERED = 2352,
    STR_STAFF_STAT_LITTER_SWEPT = 2353,
    STR_STAFF_STAT_BINS_EMPTIED = 2354,
    STR_STAFF_STAT_RIDES_FIXED = 2355,
    STR_STAFF_STAT_RIDES_INSPECTED = 2356,
    // STR_2357    :House
    STR_HEIGHT_IN_UNITS = 2358,
    STR_REAL_VALUES = 2359,
    STR_DISPLAY_RESOLUTION = 2360,
    STR_TILE_SMOOTHING = 2361,
    STR_TILE_SMOOTHING_TIP = 2362,
    STR_GRIDLINES = 2363,
    STR_GRIDLINES_TIP = 2364,
    STR_BANK_REFUSES_TO_INCREASE_LOAN = 2365,
    STR_CELSIUS = 2366,
    STR_FAHRENHEIT = 2367,
    STR_PEEP_STAT_NAUSEA_TOLERANCE_NONE = 2368,
    STR_PEEP_STAT_NAUSEA_TOLERANCE_LOW = 2369,
    STR_PEEP_STAT_NAUSEA_TOLERANCE_AVERAGE = 2370,
    STR_PEEP_STAT_NAUSEA_TOLERANCE_HIGH = 2371,
    STR_RATING_LOW = 2372,
    STR_RATING_MEDIUM = 2373,
    STR_RATING_HIGH = 2374,
    STR_RATING_VERY_HIGH = 2375,
    STR_RATING_EXTREME = 2376,
    STR_RATING_ULTRA_EXTREME = 2377,
    STR_ADJUST_SMALLER_LAND_TIP = 2378,
    STR_ADJUST_LARGER_LAND_TIP = 2379,
    STR_ADJUST_SMALLER_WATER_TIP = 2380,
    STR_ADJUST_LARGER_WATER_TIP = 2381,
    STR_LAND = 2382,
    STR_WATER = 2383,
    STR_OBJECTIVE_LABEL = 2384,
    STR_OBJECTIVE_NONE = 2385,
    STR_OBJECTIVE_GUESTS_BY = STR_OBJECTIVE_NONE + 1,
    STR_OBJECTIVE_PARK_VALUE_BY = STR_OBJECTIVE_NONE + 2,
    STR_OBJECTIVE_HAVE_FUN = STR_OBJECTIVE_NONE + 3,
    STR_OBJECTIVE_BUILD_THE_BEST = STR_OBJECTIVE_NONE + 4,
    STR_OBJECTIVE_10_ROLLERCOASTERS = STR_OBJECTIVE_NONE + 5,
    STR_OBJECTIVE_GUESTS_AND_RATING = STR_OBJECTIVE_NONE + 6,
    STR_OBJECTIVE_MONTHLY_RIDE_INCOME = STR_OBJECTIVE_NONE + 7,
    STR_OBJECTIVE_10_ROLLERCOASTERS_LENGTH = STR_OBJECTIVE_NONE + 8,
    STR_OBJECTIVE_FINISH_5_ROLLERCOASTERS = STR_OBJECTIVE_NONE + 9,
    STR_OBJECTIVE_REPLAY_LOAN_AND_PARK_VALUE = STR_OBJECTIVE_NONE + 10,
    STR_OBJECTIVE_MONTHLY_FOOD_INCOME = STR_OBJECTIVE_NONE + 11,
    STR_OBJECTIVE_DROPDOWN_NONE = 2397,
    STR_OBJECTIVE_DROPDOWN_NUMBER_OF_GUESTS_AT_A_GIVEN_DATE = STR_OBJECTIVE_DROPDOWN_NONE + 1,
    STR_OBJECTIVE_DROPDOWN_PARK_VALUE_AT_A_GIVEN_DATE = STR_OBJECTIVE_DROPDOWN_NONE + 2,
    STR_OBJECTIVE_DROPDOWN_HAVE_FUN = STR_OBJECTIVE_DROPDOWN_NONE + 3,
    STR_OBJECTIVE_DROPDOWN_BUILD_THE_BEST_RIDE_YOU_CAN = STR_OBJECTIVE_DROPDOWN_NONE + 4,
    STR_OBJECTIVE_DROPDOWN_BUILD_10_ROLLER_COASTERS = STR_OBJECTIVE_DROPDOWN_NONE + 5,
    STR_OBJECTIVE_DROPDOWN_NUMBER_OF_GUESTS_IN_PARK = STR_OBJECTIVE_DROPDOWN_NONE + 6,
    STR_OBJECTIVE_DROPDOWN_MONTHLY_INCOME_FROM_RIDE_TICKETS = STR_OBJECTIVE_DROPDOWN_NONE + 7,
    STR_OBJECTIVE_DROPDOWN_BUILD_10_ROLLER_COASTERS_OF_A_GIVEN_LENGTH = STR_OBJECTIVE_DROPDOWN_NONE + 8,
    STR_OBJECTIVE_DROPDOWN_FINISH_BUILDING_5_ROLLER_COASTERS = STR_OBJECTIVE_DROPDOWN_NONE + 9,
    STR_OBJECTIVE_DROPDOWN_REPAY_LOAN_AND_ACHIEVE_A_GIVEN_PARK_VALUE = STR_OBJECTIVE_DROPDOWN_NONE + 10,
    STR_OBJECTIVE_DROPDOWN_MONTHLY_PROFIT_FROM_FOOD_MERCHANDISE = STR_OBJECTIVE_DROPDOWN_NONE + 11,
    STR_MARKETING_CAMPAIGNS_IN_OPERATION = 2409,
    STR_MARKETING_CAMPAIGNS_NONE = 2410,
    STR_MARKETING_CAMPAIGNS_AVAILABLE = 2411,
    STR_START_THIS_MARKETING_CAMPAIGN = 2412,
    STR_MARKETING_PER_WEEK = 2413,
    STR_MARKETING_NOT_SELECTED = 2414,
    STR_MARKETING_RIDE = 2415,
    STR_MARKETING_ITEM = 2416,
    STR_LENGTH_OF_TIME = 2417,
    STR_PEEP_INVENTORY_VOUCHER_PARK_ENTRY_FREE = 2418,
    STR_PEEP_INVENTORY_VOUCHER_RIDE_FREE = 2419,
    STR_PEEP_INVENTORY_VOUCHER_PARK_ENTRY_HALF_PRICE = 2420,
    STR_PEEP_INVENTORY_VOUCHER_FOOD_OR_DRINK_FREE = 2421,
    // STR_2422    :Advertising campaign for {STRINGID}
    // STR_2423    :Advertising campaign for {STRINGID}
    STR_MARKETING_VOUCHERS_FOR_FREE_ENTRY_TO_THE_PARK = 2424,
    STR_MARKETING_VOUCHERS_FOR_FREE_RIDES_ON_A_PARTICULAR_RIDE = 2425,
    STR_MARKETING_VOUCHERS_FOR_HALF_PRICE_ENTRY_TO_THE_PARK = 2426,
    STR_MARKETING_VOUCHERS_FOR_FREE_FOOD_OR_DRINK = 2427,
    STR_MARKETING_ADVERTISING_CAMPAIGN_FOR_THE_PARK = 2428,
    STR_MARKETING_ADVERTISING_CAMPAIGN_FOR_A_PARTICULAR_RIDE = 2429,
    STR_VOUCHERS_FOR_FREE_ENTRY_TO = 2430,
    STR_VOUCHERS_FOR_FREE_RIDE_ON = 2431,
    STR_VOUCHERS_FOR_HALF_PRICE_ENTRY_TO = 2432,
    STR_VOUCHERS_FOR_FREE = 2433,
    STR_ADVERTISING_CAMPAIGN_FOR_1 = 2434,
    STR_ADVERTISING_CAMPAIGN_FOR_2 = 2435,
    STR_MARKETING_1_WEEK = 2436,
    // STR_2437    :<removed string - do not use>
    // STR_2438    :<removed string - do not use>
    // STR_2439    :<removed string - do not use>
    // STR_2440    :<removed string - do not use>
    // STR_2441    :<removed string - do not use>
    // STR_2442    :<removed string - do not use>
    STR_MARKETING_COST_PER_WEEK = 2443,
    STR_MARKETING_TOTAL_COST = 2444,
    STR_MARKETING_START_THIS_MARKETING_CAMPAIGN = 2445,
    STR_MARKETING_FINISHED_FREE_ENTRY = 2446,
    STR_MARKETING_FINISHED_FREE_RIDES = 2447,
    STR_MARKETING_FINISHED_HALF_PRICE_ENTRY = 2448,
    STR_MARKETING_FINISHED_FREE_RIDE = 2449,
    STR_MARKETING_FINISHED_PARK_ADS = 2450,
    STR_MARKETING_FINISHED_RIDE_ADS = 2451,
    STR_FINANCES_FINANCIAL_GRAPH_CASH_LESS_LOAN_POSITIVE = 2452,
    STR_FINANCES_FINANCIAL_GRAPH_CASH_LESS_LOAN_NEGATIVE = 2453,
    STR_FINANCES_FINANCIAL_GRAPH_CASH_VALUE = 2454,
    // STR_FINANCES_FINANCIAL_GRAPH_CASH_VALUE_POSITIVE = 2455, // Unused
    // STR_FINANCES_FINANCIAL_GRAPH_CASH_VALUE_NEGATIVE = 2456, // Unused
    STR_FINANCES_SHOW_SUMMARY_TAB_TIP = 2457,
    STR_FINANCES_SHOW_CASH_TAB_TIP = 2458,
    STR_FINANCES_SHOW_PARK_VALUE_TAB_TIP = 2459,
    STR_FINANCES_SHOW_WEEKLY_PROFIT_TAB_TIP = 2460,
    STR_FINANCES_SHOW_MARKETING_TAB_TIP = 2461,
    STR_PARK_ENTRANCE_TAB_TIP = 2462,
    STR_PARK_RATING_TAB_TIP = 2463,
    STR_PARK_GUESTS_TAB_TIP = 2464,
    STR_PARK_PRICE_TAB_TIP = 2465,
    STR_PARK_STATS_TAB_TIP = 2466,
    STR_PARK_OBJECTIVE_TAB_TIP = 2467,
    STR_PARK_AWARDS_TAB_TIP = 2468,
    STR_SELECT_LEVEL_OF_RESEARCH_AND_DEVELOPMENT = 2469,
    STR_RESEARCH_NEW_TRANSPORT_RIDES_TIP = 2470,
    STR_RESEARCH_NEW_GENTLE_RIDES_TIP = 2471,
    STR_RESEARCH_NEW_ROLLER_COASTERS_TIP = 2472,
    STR_RESEARCH_NEW_THRILL_RIDES_TIP = 2473,
    STR_RESEARCH_NEW_WATER_RIDES_TIP = 2474,
    STR_RESEARCH_NEW_SHOPS_AND_STALLS_TIP = 2475,
    STR_RESEARCH_NEW_SCENERY_AND_THEMING_TIP = 2476,
    STR_SELECT_OPERATING_MODE = 2477,
    STR_SHOW_GRAPH_OF_VELOCITY_AGAINST_TIME_TIP = 2478,
    STR_SHOW_GRAPH_OF_ALTITUDE_AGAINST_TIME_TIP = 2479,
    STR_SHOW_GRAPH_OF_VERTICAL_ACCELERATION_AGAINST_TIME_TIP = 2480,
    STR_SHOW_GRAPH_OF_LATERAL_ACCELERATION_AGAINST_TIME_TIP = 2481,
    STR_PROFIT_PER_WEEK_AND_PARK_VALUE_TIP = 2482,
    STR_FINANCES_WEEKLY_PROFIT_POSITIVE = 2483,
    STR_FINANCES_WEEKLY_PROFIT_LOSS = 2484,
    // STR_CONTROLS = 2485, // Unused
    // STR_GENERAL = 2486,  // Unused
    STR_REAL_NAME = 2487,
    STR_REAL_NAME_TIP = 2488,
    STR_HOTKEY = 2489,
    STR_SHORTCUTS_TITLE = 2490,
    STR_SHORTCUT_ACTION_RESET = 2491,
    STR_SHORTCUT_ACTION_RESET_TIP = 2492,
    STR_SHORTCUT_CLOSE_TOP_MOST_WINDOW = 2493,
    STR_SHORTCUT_CLOSE_ALL_FLOATING_WINDOWS = 2494,
    STR_SHORTCUT_CANCEL_CONSTRUCTION_MODE = 2495,
    STR_SHORTCUT_PAUSE_GAME = 2496,
    STR_SHORTCUT_ZOOM_VIEW_OUT = 2497,
    STR_SHORTCUT_ZOOM_VIEW_IN = 2498,
    STR_SHORTCUT_ROTATE_VIEW_CLOCKWISE = 2499,
    STR_SHORTCUT_ROTATE_CONSTRUCTION_OBJECT = 2500,
    STR_SHORTCUT_UNDERGROUND_VIEW_TOGGLE = 2501,
    STR_SHORTCUT_REMOVE_BASE_LAND_TOGGLE = 2502,
    STR_SHORTCUT_REMOVE_VERTICAL_LAND_TOGGLE = 2503,
    STR_SHORTCUT_SEE_THROUGH_RIDES_TOGGLE = 2504,
    STR_SHORTCUT_SEE_THROUGH_SCENERY_TOGGLE = 2505,
    STR_SHORTCUT_INVISIBLE_SUPPORTS_TOGGLE = 2506,
    STR_SHORTCUT_INVISIBLE_PEOPLE_TOGGLE = 2507,
    STR_SHORTCUT_HEIGHT_MARKS_ON_LAND_TOGGLE = 2508,
    STR_SHORTCUT_HEIGHT_MARKS_ON_RIDE_TRACKS_TOGGLE = 2509,
    STR_SHORTCUT_HEIGHT_MARKS_ON_PATHS_TOGGLE = 2510,
    STR_SHORTCUT_ADJUST_LAND = 2511,
    STR_SHORTCUT_ADJUST_WATER = 2512,
    STR_SHORTCUT_BUILD_SCENERY = 2513,
    STR_SHORTCUT_BUILD_PATHS = 2514,
    STR_SHORTCUT_BUILD_NEW_RIDE = 2515,
    STR_SHORTCUT_SHOW_FINANCIAL_INFORMATION = 2516,
    STR_SHORTCUT_SHOW_RESEARCH_INFORMATION = 2517,
    STR_SHORTCUT_SHOW_RIDES_LIST = 2518,
    STR_SHORTCUT_SHOW_PARK_INFORMATION = 2519,
    STR_SHORTCUT_SHOW_GUEST_LIST = 2520,
    STR_SHORTCUT_SHOW_STAFF_LIST = 2521,
    STR_SHORTCUT_SHOW_RECENT_MESSAGES = 2522,
    STR_SHORTCUT_SHOW_MAP = 2523,
    STR_SHORTCUT_SCREENSHOT = 2524,

    // 2525--2532 unused

    STR_SHORTCUT_BACKSPACE = 2533,
    STR_SHORTCUT_TAB = 2534,

    // 2535--2536 unused

    STR_SHORTCUT_CLEAR = 2537,
    STR_SHORTCUT_RETURN = 2538,

    // 2539--2542 unused

    STR_SHORTCUT_ALT = 2543,
    STR_SHORTCUT_PAUSE = 2544,
    STR_SHORTCUT_CAPS = 2545,

    // 2546--2551 unused

    STR_SHORTCUT_ESCAPE = 2552,

    // 2553--2556 unused

    STR_SHORTCUT_SPACEBAR = 2557,
    STR_SHORTCUT_PGUP = 2558,
    STR_SHORTCUT_PGDN = 2559,
    STR_SHORTCUT_END = 2560,
    STR_SHORTCUT_HOME = 2561,
    STR_SHORTCUT_LEFT = 2562,
    STR_SHORTCUT_UP = 2563,
    STR_SHORTCUT_RIGHT = 2564,
    STR_SHORTCUT_DOWN = 2565,
    STR_SHORTCUT_SELECT = 2566,
    STR_SHORTCUT_PRINT = 2567,
    STR_SHORTCUT_EXECUTE = 2568,
    STR_SHORTCUT_SNAPSHOT = 2569,
    STR_SHORTCUT_INSERT = 2570,
    STR_SHORTCUT_DELETE = 2571,
    STR_SHORTCUT_HELP = 2572,

    // 2573--2617 unused

    STR_SHORTCUT_MENU = 2618,

    // 2619--2620 unused

    STR_SHORTCUT_NUMPAD_0 = 2621,
    STR_SHORTCUT_NUMPAD_1 = 2622,
    STR_SHORTCUT_NUMPAD_2 = 2623,
    STR_SHORTCUT_NUMPAD_3 = 2624,
    STR_SHORTCUT_NUMPAD_4 = 2625,
    STR_SHORTCUT_NUMPAD_5 = 2626,
    STR_SHORTCUT_NUMPAD_6 = 2627,
    STR_SHORTCUT_NUMPAD_7 = 2628,
    STR_SHORTCUT_NUMPAD_8 = 2629,
    STR_SHORTCUT_NUMPAD_9 = 2630,
    STR_SHORTCUT_NUMPAD_MULTIPLY = 2631,
    STR_SHORTCUT_NUMPAD_PLUS = 2632,

    // 2633 unused

    STR_SHORTCUT_NUMPAD_MINUS = 2634,
    STR_SHORTCUT_NUMPAD_PERIOD = 2635,
    STR_SHORTCUT_NUMPAD_DIVIDE = 2636,

    // 2637--2668 unused

    STR_SHORTCUT_NUMLOCK = 2669,
    STR_SHORTCUT_SCROLL = 2670,

    // 2671--2679 unused

    STR_RESEARCH_COMPLETED_AL = 2680,
    // STR_2681    :<removed string - do not use>
    // STR_2682    :<removed string - do not use>
    // STR_2683    :<removed string - do not use>
    STR_CHEAT_LARGE_TRAM_GUESTS_TIP = 2684,
    STR_MAPGEN_SIMPLEX_NOISE = 2685,
    STR_MAPGEN_SIMPLEX_NOISE_LOW_ = 2686,
    STR_MAPGEN_SIMPLEX_NOISE_HIGH = 2687,
    STR_MAPGEN_SIMPLEX_NOISE_BASE_FREQUENCY = 2688,
    STR_MAPGEN_SIMPLEX_NOISE_OCTAVES = 2689,
    STR_MAPGEN_WINDOW_TITLE = 2690,
    STR_BASE_HEIGHT_LABEL = 2691,
    STR_WATER_LEVEL_LABEL = 2692,
    STR_TERRAIN_LABEL = 2693,
    STR_MAPGEN_ACTION_GENERATE = 2694,
    STR_MAPGEN_OPTION_RANDOM_TERRAIN = 2695,
    STR_MAPGEN_OPTION_PLACE_TREES = 2696,

    // 2697--2699 unused

    STR_OPTIONS_AUTOSAVE_FREQUENCY_LABEL = 2700,
    STR_SAVE_EVERY_MINUTE = 2701,
    STR_SAVE_EVERY_5MINUTES = 2702,
    STR_SAVE_EVERY_15MINUTES = 2703,
    STR_SAVE_EVERY_30MINUTES = 2704,
    STR_SAVE_EVERY_HOUR = 2705,
    STR_SAVE_NEVER = 2706,
    STR_FILEBROWSER_USE_SYSTEM_WINDOW = 2707,
    STR_FILEBROWSER_OVERWRITE_PROMPT = 2708,
    STR_FILEBROWSER_OVERWRITE_TITLE = 2709,
    STR_FILEBROWSER_FILE_NAME_PROMPT = 2710,

    // 2711--2717 unused

    STR_FILEBROWSER_ACTION_UP = 2718,
    STR_FILEBROWSER_ACTION_NEW_FILE = 2719,
    STR_DURATION_SEC = 2720,
    STR_DURATION_SECS = 2721,
    STR_DURATION_MIN_SEC = 2722,
    STR_DURATION_MIN_SECS = 2723,
    STR_DURATION_MINS_SEC = 2724,
    STR_DURATION_MINS_SECS = 2725,
    STR_REALTIME_MIN = 2726,
    STR_REALTIME_MINS = 2727,
    STR_REALTIME_HOUR_MIN = 2728,
    STR_REALTIME_HOUR_MINS = 2729,
    STR_REALTIME_HOURS_MIN = 2730,
    STR_REALTIME_HOURS_MINS = 2731,
    STR_UNIT_SUFFIX_FEET = 2732,
    STR_UNIT_SUFFIX_METRES = 2733,
    STR_UNIT_SUFFIX_MILES_PER_HOUR = 2734,
    STR_UNIT_SUFFIX_KILOMETRES_PER_HOUR = 2735,
    STR_DATE_FORMAT_MY = 2736,
    STR_DATE_FORMAT_DMY = 2737,
    STR_OPTIONS_MUSIC_LABEL = 2738,
    STR_OPTIONS_MUSIC_VALUE_NONE = 2739,
    STR_ROLLERCOASTER_TYCOON_1_DROPDOWN = 2740,
    STR_ROLLERCOASTER_TYCOON_2_DROPDOWN = 2741,

    // 2744--2748 unused

    STR_MY_NEW_SCENARIO = 2749,
    STR_MOVE_ALL_TOP = 2750,
    STR_MOVE_ALL_BOTTOM = 2751,
    STR_CHEAT_CLEAR_GRASS = 2752,
    STR_CHEAT_MOWED_GRASS = 2753,
    STR_CHEAT_WATER_PLANTS = 2754,
    STR_CHEAT_FIX_VANDALISM = 2755,
    STR_CHEAT_REMOVE_LITTER = 2756,

    // 2757--2764 unused

    STR_CHEAT_LARGE_TRAM_GUESTS = 2765,
    STR_CHEAT_WIN_SCENARIO = 2766,
    STR_CHEAT_FREEZE_WEATHER = 2767,

    STR_CHEAT_OPEN_PARK = 2769,
    STR_CHEAT_CLOSE_PARK = 2770,
    // STR_2771    :Slower Gamespeed
    // STR_2772    :Faster Gamespeed
    STR_OPTIONS_DISPLAY_WINDOWED = 2773,
    STR_OPTIONS_DISPLAY_FULLSCREEN = 2774,
    STR_OPTIONS_DISPLAY_FULLSCREEN_BORDERLESS = 2775,
    STR_OPTIONS_LANGUAGE = 2776,
    STR_OPTIONS_DROPDOWN_ITEM = 2777,
    STR_OPTIONS_DROPDOWN_ITEM_SELECTED = 2778, // used as STR_OPTIONS_DROPDOWN_ITEM + 1
    STR_VIEWPORT_NO = 2779,
    STR_EXTRA_VIEWPORT = 2780,
    STR_SHORTCUT_ENTRY_FORMAT = 2781,
    STR_SHIFT_PLUS = 2782,
    STR_CTRL_PLUS = 2783,
    STR_SHORTCUT_CHANGE_TITLE = 2784,
    STR_SHORTCUT_CHANGE_PROMPT = 2785,
    STR_SHORTCUT_LIST_TIP = 2786,
    STR_FINANCES_PARK_VALUE = 2787,
    STR_OBJECTIVE_ACHIEVED = 2788,
    STR_OBJECTIVE_FAILED = 2789,
    STR_ENTER_NAME_INTO_SCENARIO_CHART = 2790,
    STR_ENTER_NAME = 2791,
    STR_PLEASE_ENTER_YOUR_NAME_FOR_THE_SCENARIO_CHART = 2792,
    STR_COMPLETED_BY = 2793,
    STR_COMPLETED_BY_WITH_COMPANY_VALUE = 2794,
    STR_SORT = 2795,
    STR_RIDE_LIST_SORT_TIP = 2796,
    STR_SCREEN_EDGE_SCROLLING = 2797,
    STR_SCREEN_EDGE_SCROLLING_TIP = 2798,
    STR_HOTKEY_TIP = 2799,
    STR_TOTAL_ADMISSIONS = 2800,
    STR_INCOME_FROM_ADMISSIONS = 2801,
    STR_MAP_LABEL = 2802,
    STR_SHOW_GUESTS_ON_MAP_TIP = 2803,
    STR_SHOW_STAFF_ON_MAP_TIP = 2804,
    STR_SHOW_MAP_TIP = 2805,
    STR_PEEPS_DISGUSTED_BY_PATHS = 2806,
    STR_PEEPS_DISLIKE_LITTER = 2807,
    STR_PEEPS_DISLIKE_VANDALISM = 2808,
    STR_PEEPS_ARE_HUNGRY = 2809,
    STR_PEEPS_ARE_THIRSTY = 2810,
    STR_PEEPS_CANT_FIND_TOILET = 2811,
    STR_PEEPS_GETTING_LOST_OR_STUCK = 2812,
    STR_ENTRANCE_FEE_TOO_HI = 2813,
    STR_AWARD_MOST_UNTIDY = 2814,
    STR_AWARD_MOST_TIDY = STR_AWARD_MOST_UNTIDY + 1,
    STR_AWARD_BEST_ROLLERCOASTERS = STR_AWARD_MOST_UNTIDY + 2,
    STR_AWARD_BEST_VALUE = STR_AWARD_MOST_UNTIDY + 3,
    STR_AWARD_MOST_BEAUTIFUL = STR_AWARD_MOST_UNTIDY + 4,
    STR_AWARD_WORST_VALUE = STR_AWARD_MOST_UNTIDY + 5,
    STR_AWARD_SAFEST = STR_AWARD_MOST_UNTIDY + 6,
    STR_AWARD_BEST_STAFF = STR_AWARD_MOST_UNTIDY + 7,
    STR_AWARD_BEST_FOOD = STR_AWARD_MOST_UNTIDY + 8,
    STR_AWARD_WORST_FOOD = STR_AWARD_MOST_UNTIDY + 9,
    STR_AWARD_BEST_TOILETS = STR_AWARD_MOST_UNTIDY + 10,
    STR_AWARD_MOST_DISAPPOINTING = STR_AWARD_MOST_UNTIDY + 11,
    STR_AWARD_BEST_WATER_RIDES = STR_AWARD_MOST_UNTIDY + 12,
    STR_AWARD_BEST_CUSTOM_DESIGNED_RIDES = STR_AWARD_MOST_UNTIDY + 13,
    STR_AWARD_MOST_DAZZLING_RIDE_COLOURS = STR_AWARD_MOST_UNTIDY + 14,
    STR_AWARD_MOST_CONFUSING_LAYOUT = STR_AWARD_MOST_UNTIDY + 15,
    STR_AWARD_BEST_GENTLE_RIDES = STR_AWARD_MOST_UNTIDY + 16,
    STR_NEWS_ITEM_AWARD_MOST_UNTIDY = 2831,
    STR_NEWS_ITEM_MOST_TIDY = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 1,
    STR_NEWS_ITEM_BEST_ROLLERCOASTERS = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 2,
    STR_NEWS_ITEM_BEST_VALUE = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 3,
    STR_NEWS_ITEM_MOST_BEAUTIFUL = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 4,
    STR_NEWS_ITEM_WORST_VALUE = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 5,
    STR_NEWS_ITEM_SAFEST = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 6,
    STR_NEWS_ITEM_BEST_STAFF = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 7,
    STR_NEWS_ITEM_BEST_FOOD = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 8,
    STR_NEWS_ITEM_WORST_FOOD = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 9,
    STR_NEWS_ITEM_BEST_TOILETS = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 10,
    STR_NEWS_ITEM_MOST_DISAPPOINTING = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 11,
    STR_NEWS_ITEM_BEST_WATER_RIDES = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 12,
    STR_NEWS_ITEM_BEST_CUSTOM_DESIGNED_RIDES = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 13,
    STR_NEWS_ITEM_MOST_DAZZLING_RIDE_COLOURS = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 14,
    STR_NEWS_ITEM_MOST_CONFUSING_LAYOUT = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 15,
    STR_NEWS_ITEM_BEST_GENTLE_RIDES = STR_NEWS_ITEM_AWARD_MOST_UNTIDY + 16,
    STR_NO_RECENT_AWARDS = 2848,
    // STR_2849    :New scenario installed successfully
    // STR_2850    :New track design installed successfully
    // STR_2851    :Scenario already installed
    // STR_2852    :Track design already installed
    STR_FORBIDDEN_BY_THE_LOCAL_AUTHORITY = 2853,
    STR_ENTRANCE_NOT_CONNECTED = 2854,
    STR_EXIT_NOT_CONNECTED = 2855,
    STR_CANT_START_MARKETING_CAMPAIGN = 2858,
    // STR_2859    :Another instance of OpenRCT2 is already running
    STR_LICENSED_TO_INFOGRAMES_INTERACTIVE_INC = 2861,

    STR_MAIN_COLOUR_SCHEME = 2971,
    STR_ALTERNATIVE_COLOUR_SCHEME_1 = 2972,
    STR_ALTERNATIVE_COLOUR_SCHEME_2 = 2973,
    STR_ALTERNATIVE_COLOUR_SCHEME_3 = 2974,
    STR_COLOUR_SCHEME_TO_CHANGE_TIP = 2975,
    STR_PAINT_INDIVIDUAL_AREA_TIP = 2976,
    STR_STAFF_TITLE_STAFF_MEMBER_NAME = 2977,
    STR_STAFF_PROMPT_ENTER_NAME = 2978,
    STR_STAFF_ERROR_CANT_NAME_STAFF_MEMBER = 2979,
    STR_TOO_MANY_BANNERS_IN_GAME = 2980,
    STR_NO_ENTRY = 2981,
    STR_BANNER_TEXT = 2982,
    STR_ENTER_BANNER_TEXT = 2983,
    STR_ERR_CANT_SET_BANNER_TEXT = 2984,
    STR_BANNER_WINDOW_TITLE = 2985,
    STR_CHANGE_BANNER_TEXT_TIP = 2986,
    STR_SET_AS_NO_ENTRY_BANNER_TIP = 2987,
    STR_DEMOLISH_BANNER_TIP = 2988,
    STR_SELECT_MAIN_SIGN_COLOUR_TIP = 2989,
    STR_SELECT_TEXT_COLOUR_TIP = 2990,
    STR_SIGN = 2991,
    STR_SIGN_TEXT_TITLE = 2992,
    STR_SIGN_TEXT_PROMPT = 2993,
    STR_CHANGE_SIGN_TEXT_TIP = 2994,
    STR_DEMOLISH_SIGN_TIP = 2995,
    STR_TEXT_COLOUR_BLACK = 2996,
    STR_TEXT_COLOUR_GREY = 2997,
    STR_TEXT_COLOUR_WHITE = 2998,
    STR_TEXT_COLOUR_RED = 2999,
    STR_TEXT_COLOUR_GREEN = 3000,
    STR_TEXT_COLOUR_YELLOW = 3001,
    STR_TEXT_COLOUR_TOPAZ = 3002,
    STR_TEXT_COLOUR_CELADON = 3003,
    STR_TEXT_COLOUR_BABYBLUE = 3004,
    STR_TEXT_COLOUR_PALELAVENDER = 3005,
    STR_TEXT_COLOUR_PALEGOLD = 3006,
    STR_TEXT_COLOUR_LIGHTPINK = 3007,
    STR_TEXT_COLOUR_PEARLAQUA = 3008,
    STR_TEXT_COLOUR_PALESILVER = 3009,
    STR_UNABLE_TO_LOAD_FILE = 3010,
    STR_FILE_CONTAINS_INVALID_DATA = 3011,
    STR_MUSIC_STYLE_DODGEMS_BEAT = 3012,
    STR_MUSIC_STYLE_FAIRGROUND_ORGAN = 3013,
    STR_MUSIC_STYLE_ROMAN_FANFARE = 3014,
    STR_MUSIC_STYLE_ORIENTAL = 3015,
    STR_MUSIC_STYLE_MARTIAN = 3016,
    STR_MUSIC_STYLE_JUNGLE_DRUMS = 3017,
    STR_MUSIC_STYLE_EGYPTIAN = 3018,
    STR_MUSIC_STYLE_TOYLAND = 3019,
    STR_MUSIC_STYLE_CIRCUS_SHOW = 3020,
    STR_MUSIC_STYLE_SPACE = 3021,
    STR_MUSIC_STYLE_HORROR = 3022,
    STR_MUSIC_STYLE_TECHNO = 3023,
    STR_MUSIC_STYLE_GENTLE = 3024,
    STR_MUSIC_STYLE_SUMMER = 3025,
    STR_MUSIC_STYLE_WATER = 3026,
    STR_MUSIC_STYLE_WILD_WEST = 3027,
    STR_MUSIC_STYLE_JURASSIC = 3028,
    STR_MUSIC_STYLE_ROCK = 3029,
    STR_MUSIC_STYLE_RAGTIME = 3030,
    STR_MUSIC_STYLE_FANTASY = 3031,
    STR_MUSIC_STYLE_ROCK_STYLE_2 = 3032,
    STR_MUSIC_STYLE_ICE = 3033,
    STR_MUSIC_STYLE_SNOW = 3034,
    STR_MUSIC_STYLE_CUSTOM_MUSIC_1 = 3035,
    STR_MUSIC_STYLE_CUSTOM_MUSIC_2 = 3036,
    STR_MUSIC_STYLE_MEDIEVAL = 3037,
    STR_MUSIC_STYLE_URBAN = 3038,
    STR_MUSIC_STYLE_ORGAN = 3039,
    STR_MUSIC_STYLE_MECHANICAL = 3040,
    STR_MUSIC_STYLE_MODERN = 3041,
    STR_MUSIC_STYLE_PIRATES = 3042,
    STR_MUSIC_STYLE_ROCK_STYLE_3 = 3043,
    STR_MUSIC_STYLE_CANDY_STYLE = 3044,
    STR_SELECT_MUSIC_STYLE_TIP = 3045,
    // STR_THIS_RIDE_CANNOT_BE_MODIFIED = 3046, // Unused
    STR_LOCAL_AUTHORITY_FORBIDS_DEMOLITION_OR_MODIFICATIONS_TO_THIS_RIDE = 3047,
    STR_MARKETING_CAMPAIGNS_FORBIDDEN_BY_LOCAL_AUTHORITY = 3048,
    STR_GOLF_HOLE_A = 3049,
    STR_GOLF_HOLE_B = 3050,
    STR_GOLF_HOLE_C = 3051,
    STR_GOLF_HOLE_D = 3052,
    STR_GOLF_HOLE_E = 3053,
    STR_RIDE_DESIGN_MAZE_BRICK_WALLS = 3058,
    STR_RIDE_DESIGN_MAZE_HEDGES = 3059,
    STR_RIDE_DESIGN_MAZE_ICE_BLOCKS = 3060,
    STR_RIDE_DESIGN_MAZE_WOODEN_FENCES = 3061,
    STR_RIDE_CONSTRUCTION_STANDARD_RC_TRACK_TIP = 3062,
    STR_RIDE_CONSTRUCTION_WATER_CHANNEL_TIP = 3063,
    STR_BEGINNER_PARKS = 3064,
    STR_CHALLENGING_PARKS = STR_BEGINNER_PARKS + 1,
    STR_EXPERT_PARKS = STR_BEGINNER_PARKS + 2,
    STR_REAL_PARKS = STR_BEGINNER_PARKS + 3,
    STR_OTHER_PARKS = STR_BEGINNER_PARKS + 4,
    STR_TOP_SECTION = 3069,
    STR_SLOPE_TO_LEVEL = 3070,
    STR_SAME_PRICE_THROUGHOUT_PARK = 3071,
    STR_SAME_PRICE_THROUGHOUT_PARK_TIP = 3072,
    STR_PARK_RATING_WARNING_4_WEEKS_REMAINING = 3073,
    STR_PARK_RATING_WARNING_3_WEEKS_REMAINING = 3074,
    STR_PARK_RATING_WARNING_2_WEEKS_REMAINING = 3075,
    STR_PARK_RATING_WARNING_1_WEEK_REMAINING = 3076,
    STR_PARK_HAS_BEEN_CLOSED_DOWN = 3077,
    STR_SELECT_STYLE_OF_ENTRANCE_EXIT_STATION_TIP = 3090,
    STR_YOU_ARE_NOT_ALLOWED_TO_REMOVE_THIS_SECTION = 3091,
    STR_NOT_ALLOWED_TO_MODIFY_STATION = 3092,
    STR_FAVOURITE_RIDE = 3093,
    STR_PEEP_FAVOURITE_RIDE_NOT_AVAILABLE = 3094,
    STR_LIFT_HILL_CHAIN_SPEED = 3095,
    STR_LIFT_HILL_CHAIN_SPEED_VALUE = 3096,
    STR_SELECT_LIFT_HILL_CHAIN_SPEED_TIP = 3097,
    // STR_3098    :Can't change lift hill speed...
    STR_SELECT_COLOUR = 3099,
    STR_SELECT_SECONDARY_COLOUR = 3100,
    STR_SELECT_TERNARY_COLOUR = 3101,
    STR_SCENERY_PAINTBRUSH_TIP = 3102,
    STR_CANT_REPAINT_THIS = 3103,
    STR_LIST_RIDES_TIP = 3104,
    STR_LIST_SHOPS_AND_STALLS_TIP = 3105,
    STR_LIST_KIOSKS_AND_FACILITIES_TIP = 3106,
    STR_CLOSE_RIDE = 3107,
    STR_TEST_RIDE = 3108,
    STR_OPEN_RIDE = 3109,
    STR_BLOCK_SECTIONS = 3110,
    STR_CLICK_ON_DESIGN_TO_BUILD_IT_TIP = 3111,
    STR_CLICK_ON_DESIGN_TO_RENAME_OR_DELETE_IT = 3112,
    STR_SELECT_A_DIFFERENT_DESIGN = 3113,
    STR_GO_BACK_TO_DESIGN_SELECTION_WINDOW_TIP = 3114,
    STR_SAVE_TRACK_DESIGN = 3115,
    STR_SAVE_TRACK_DESIGN_NOT_POSSIBLE = 3116,
    STR_CALLING_MECHANIC = 3117,
    STR_MEHCANIC_IS_HEADING_FOR_THE_RIDE = 3118,
    STR_MEHCANIC_IS_FIXING_THE_RIDE = 3119,
    STR_LOCATE_NEAREST_AVAILABLE_MECHANIC_TIP = 3120,
    STR_UNABLE_TO_LOCATE_MECHANIC = 3121,
    STR_FAVOURITE_RIDE_OF_GUEST = 3122,
    STR_FAVOURITE_RIDE_OF_GUESTS = 3123,
    STR_BROKEN = 3124,
    STR_EXCITEMENT_FACTOR = 3125,
    STR_INTENSITY_FACTOR = 3126,
    STR_NAUSEA_FACTOR = 3127,
    STR_SAVE_TRACK_DESIGN_ITEM = 3128,
    STR_SAVE_TRACK_DESIGN_WITH_SCENERY_ITEM = 3129,
    STR_DESIGN_SAVE = 3130,
    STR_DESIGN_CANCEL = 3131,
    STR_CLICK_ITEMS_OF_SCENERY_TO_SELECT = 3132,
    STR_ERR_UNABLE_TO_BUILD_THIS_ON_SLOPE = 3133,
    STR_DESIGN_INCLUDES_SCENERY_WHICH_IS_UNAVAILABLE = 3134,
    STR_VEHICLE_DESIGN_UNAVAILABLE = 3135,
    STR_THIS_DESIGN_WILL_BE_BUILT_WITH_AN_ALTERNATIVE_VEHICLE_TYPE = 3136,
    STR_SELECT_NEARBY_SCENERY = 3137,
    STR_RESET_SELECTION = 3138,
    STR_CABLE_LIFT_UNABLE_TO_WORK_IN_THIS_OPERATING_MODE = 3139,
    STR_CABLE_LIFT_HILL_MUST_START_IMMEDIATELY_AFTER_STATION = 3140,
    STR_MULTICIRCUIT_NOT_POSSIBLE_WITH_CABLE_LIFT_HILL = 3141,
    STR_CAPACITY = 3142,
    STR_SHOW_PEOPLE_ON_MAP_TIP = 3143,
    STR_SHOW_RIDES_STALLS_ON_MAP_TIP = 3144,

    STR_SELECT_NUMBER_OF_CIRCUITS_TIP = 3160,

    STR_ERR_REASON_NOT_ENOUGH_MEMORY = 3162,

    STR_OBJECT_SELECTION_SELECTION_SIZE = 3164,

    STR_INCLUDES_X_OBJECTS = 3167,

    STR_OBJECT_SELECTION_ERR_OBJECT_DATA_NOT_FOUND = 3169,
    STR_OBJECT_SELECTION_ERR_NOT_ENOUGH_SPACE_FOR_GRAPHICS = 3170,
    STR_OBJECT_SELECTION_ERR_TOO_MANY_OF_TYPE_SELECTED = 3171,
    STR_OBJECT_SELECTION_ERR_SHOULD_SELECT_X_FIRST = 3172,
    STR_OBJECT_SELECTION_ERR_CURRENTLY_IN_USE = 3173,
    STR_OBJECT_SELECTION_ERR_IS_REQUIRED_BY_ANOTHER = 3174,
    STR_OBJECT_SELECTION_ERR_ALWAYS_REQUIRED = 3175,
    STR_UNABLE_TO_SELECT_THIS_OBJECT = 3176,
    STR_UNABLE_TO_DE_SELECT_THIS_OBJECT = 3177,
    STR_AT_LEAST_ONE_RIDE_OBJECT_MUST_BE_SELECTED = 3179,
    STR_INVALID_SELECTION_OF_OBJECTS = 3180,
    STR_OBJECT_SELECTION = 3181,
    STR_PARK_ENTRANCE_TYPE_MUST_BE_SELECTED = 3182,
    STR_WATER_TYPE_MUST_BE_SELECTED = 3183,
    STR_OBJECT_SELECTION_RIDE_VEHICLES_ATTRACTIONS = 3184,
    STR_OBJECT_SELECTION_SMALL_SCENERY = 3185,
    STR_OBJECT_SELECTION_LARGE_SCENERY = 3186,
    STR_OBJECT_SELECTION_WALLS_FENCES = 3187,
    STR_OBJECT_SELECTION_PATH_SIGNS = 3188,
    STR_OBJECT_SELECTION_FOOTPATHS = 3189,
    STR_OBJECT_SELECTION_PATH_EXTRAS = 3190,
    STR_OBJECT_SELECTION_SCENERY_GROUPS = 3191,
    STR_OBJECT_SELECTION_PARK_ENTRANCE = 3192,
    STR_OBJECT_SELECTION_WATER = 3193,

    STR_INVENTION_LIST = 3195,
    STR_INVENTION_RESEARCH_GROUP = 3196,
    STR_INVENTION_PREINVENTED_ITEMS = 3197,
    STR_INVENTION_TO_BE_INVENTED_ITEMS = 3198,
    STR_RANDOM_SHUFFLE = 3199,
    STR_RANDOM_SHUFFLE_TIP = 3200,
    STR_EDITOR_STEP_OBJECT_SELECTION = 3201,
    STR_EDITOR_STEP_LANDSCAPE_EDITOR = 3202,
    STR_EDITOR_STEP_INVENTIONS_LIST_SET_UP = 3203,
    STR_EDITOR_STEP_OPTIONS_SELECTION = 3204,
    STR_EDITOR_STEP_OBJECTIVE_SELECTION = 3205,
    STR_EDITOR_STEP_SAVE_SCENARIO = 3206,
    STR_EDITOR_STEP_ROLLERCOASTER_DESIGNER = 3207,
    STR_EDITOR_STEP_TRACK_DESIGNS_MANAGER = 3208,
    STR_BACK_TO_PREVIOUS_STEP = 3209,
    STR_FORWARD_TO_NEXT_STEP = 3210,
    STR_MAP_SIZE = 3211,
    STR_POP16_COMMA16 = 3212,
    STR_CANT_DECREASE_MAP_SIZE_ANY_FURTHER = 3213,
    STR_CANT_INCREASE_MAP_SIZE_ANY_FURTHER = 3214,
    STR_TOO_CLOSE_TO_EDGE_OF_MAP = 3215,
    STR_SELECT_PARK_OWNED_LAND_TIP = 3216,
    STR_LAND_OWNED = 3217,
    STR_CONSTRUCTION_RIGHTS_OWNED = 3218,
    STR_LAND_SALE = 3219,
    STR_CONSTRUCTION_RIGHTS_SALE = 3220,
    STR_SET_LAND_TO_BE_OWNED_TIP = 3221,
    STR_SET_CONSTRUCTION_RIGHTS_TO_BE_OWNED_TIP = 3222,
    STR_SET_LAND_TO_BE_AVAILABLE_TIP = 3223,
    STR_SET_CONSTRUCTION_RIGHTS_TO_BE_AVAILABLE_TIP = 3224,
    STR_SCENERY_CLUSTER_TIP = 3225,
    STR_BUILD_PARK_ENTRANCE_TIP = 3226,
    STR_ERR_TOO_MANY_PARK_ENTRANCES = 3227,
    STR_SET_STARTING_POSITIONS_TIP = 3228,
    STR_BLOCK_BRAKES_CANNOT_BE_USED_DIRECTLY_AFTER_STATION = 3229,
    STR_BLOCK_BRAKES_CANNOT_BE_USED_DIRECTLY_AFTER_EACH_OTHER = 3230,
    STR_BLOCK_BRAKES_CANNOT_BE_USED_DIRECTLY_AFTER_THE_TOP_OF_THIS_LIFT_HILL = 3231,
    STR_SCENARIO_OPTIONS_FINANCIAL = 3232,
    STR_SCENARIO_OPTIONS_GUESTS = 3233,
    STR_SCENARIO_OPTIONS_PARK = 3234,
    STR_SCENARIO_OPTIONS_FINANCIAL_TIP = 3235,
    STR_SCENARIO_OPTIONS_GUESTS_TIP = 3236,
    STR_SCENARIO_OPTIONS_PARK_TIP = 3237,
    STR_MAKE_PARK_NO_MONEY = 3238,
    STR_MAKE_PARK_NO_MONEY_TIP = 3239,
    STR_INIT_CASH_LABEL = 3240,
    STR_INIT_LOAN_LABEL = 3241,
    STR_MAX_LOAN_LABEL = 3242,
    STR_INTEREST_RATE_LABEL = 3243,
    STR_FORBID_MARKETING = 3244,
    STR_FORBID_MARKETING_TIP = 3245,
    STR_CURRENCY_FORMAT_LABEL = 3246,
    STR_PERCENT_FORMAT_LABEL = 3247,
    STR_CANT_INCREASE_CASH = 3248,
    STR_CANT_REDUCE_CASH = 3249,
    STR_CANT_INCREASE_INIT_LOAN = 3250,
    STR_CANT_REDUCE_INIT_LOAN = 3251,
    STR_CANT_INCREASE_MAX_LOAN = 3252,
    STR_CANT_REDUCE_MAX_LOAN = 3253,
    STR_CANT_INCREASE_INTEREST_RATE = 3254,
    STR_CANT_REDUCE_INTEREST_RATE = 3255,
    STR_GUESTS_PREFER_LESS_INTENSE_RIDES = 3256,
    STR_GUESTS_PREFER_LESS_INTENSE_RIDES_TIP = 3257,
    STR_GUESTS_PREFER_MORE_INTENSE_RIDES = 3258,
    STR_GUESTS_PREFER_MORE_INTENSE_RIDES_TIP = 3259,
    STR_CASH_PER_GUEST_LABEL = 3260,
    STR_GUEST_INIT_HAPPINESS = 3261,
    STR_GUEST_INIT_HUNGER = 3262,
    STR_GUEST_INIT_THIRST = 3263,
    STR_CANT_INCREASE_FURTHER = 3264,
    STR_CANT_REDUCE_FURTHER = 3265,
    STR_PAY_FOR_PARK_PAY_FOR_RIDES_TIP = 3266,
    STR_FORBID_TREE_REMOVAL = 3267,
    STR_FORBID_TREE_REMOVAL_TIP = 3268,
    STR_FORBID_LANDSCAPE_CHANGES = 3269,
    STR_FORBID_LANDSCAPE_CHANGES_TIP = 3270,
    STR_FORBID_HIGH_CONSTRUCTION = 3271,
    STR_FORBID_HIGH_CONSTRUCTION_TIP = 3272,
    STR_HARD_PARK_RATING = 3273,
    STR_HARD_PARK_RATING_TIP = 3274,
    STR_HARD_GUEST_GENERATION = 3275,
    STR_HARD_GUEST_GENERATION_TIP = 3276,
    STR_LAND_COST_LABEL = 3277,
    STR_RIGHTS_COST_LABEL = 3278,
    STR_FREE_PARK_ENTER = 3279,
    STR_PAY_PARK_ENTER = 3280,
    STR_ENTRY_PRICE_LABEL = 3281,
    STR_SELECT_OBJECTIVE_AND_PARK_NAME_TIP = 3282,
    STR_SELECT_RIDES_TO_BE_PRESERVED_TIP = 3283,
    STR_OBJECTIVE_SELECTION = 3284,
    STR_OBJECTIVE_PRESERVED_RIDES_TITLE = 3285,
    STR_SELECT_OBJECTIVE_FOR_THIS_SCENARIO_TIP = 3286,
    STR_OBJECTIVE_WINDOW = 3287,
    STR_SELECT_CLIMATE_TIP = 3288,
    STR_CLIMATE_LABEL = 3289,
    STR_CLIMATE_COOL_AND_WET = 3290,
    STR_CLIMATE_WARM = STR_CLIMATE_COOL_AND_WET + 1,
    STR_CLIMATE_HOT_AND_DRY = STR_CLIMATE_COOL_AND_WET + 2,
    STR_CLIMATE_COLD = STR_CLIMATE_COOL_AND_WET + 3,
    STR_CHANGE = 3294,
    STR_CHANGE_NAME_OF_PARK_TIP = 3295,
    STR_CHANGE_NAME_OF_SCENARIO_TIP = 3296,
    STR_CHANGE_DETAIL_NOTES_ABOUT_PARK_SCENARIO_TIP = 3297,
    STR_WINDOW_PARK_NAME = 3298, // Unused
    STR_WINDOW_PARK_DETAILS = 3299,
    STR_WINDOW_SCENARIO_NAME = 3300,
    STR_WINDOW_OBJECTIVE_DATE = 3301,
    STR_WINDOW_OBJECTIVE_VALUE_DATE = 3302,
    STR_WINDOW_OBJECTIVE_GUEST_COUNT = 3303,
    STR_WINDOW_OBJECTIVE_PARK_VALUE = 3304,
    STR_WINDOW_OBJECTIVE_MONTHLY_INCOME = 3305,
    STR_WINDOW_OBJECTIVE_MONTHLY_PROFIT = 3306,
    STR_WINDOW_OBJECTIVE_MINIMUM_LENGTH = 3307,
    STR_WINDOW_OBJECTIVE_EXCITEMENT_RATING = 3308,
    STR_WINDOW_COLOUR_2_COMMA16 = 3309,
    STR_WINDOW_COLOUR_2_LENGTH = 3310,
    STR_WINDOW_COLOUR_2_COMMA2DP32 = 3311,
    STR_WINDOW_PRESERVATION_ORDER = 3312,
    STR_SCENARIO_NAME = 3313,
    STR_ENTER_SCENARIO_NAME = 3314,
    STR_PARK_SCENARIO_DETAILS = 3315,
    STR_ENTER_SCENARIO_DESCRIPTION = 3316,
    STR_NO_DETAILS_YET = 3317,
    STR_SELECT_WHICH_GROUP_THIS_SCENARIO_APPEARS_IN = 3318,
    STR_WINDOW_SCENARIO_GROUP = 3319,
    STR_UNABLE_TO_SAVE_SCENARIO_FILE = 3320,

    STR_OBJECTIVE = 3322,

    STR_WINDOW_NO_IMAGE = 3326,
    STR_PEEP_SPAWNS_NOT_SET = 3327,
    STR_CANT_ADVANCE_TO_NEXT_EDITOR_STAGE = 3328,
    STR_NO_PARK_ENTRANCES = 3329,
    STR_PARK_MUST_OWN_SOME_LAND = 3330,
    STR_PARK_ENTRANCE_PATH_INCOMPLETE_OR_COMPLEX = 3331,
    STR_PARK_ENTRANCE_WRONG_DIRECTION_OR_NO_PATH = 3332,
    STR_SAVE_PLUGIN_DATA = 3333,
    STR_SAVE_PLUGIN_DATA_TIP = 3334,
    STR_ROLLER_COASTER_DESIGNER_SELECT_RIDE_TYPES_VEHICLES = 3335,
    STR_TRACK_DESIGNS_MANAGER_SELECT_RIDE_TYPE = 3336,

    STR_CUSTOM_DESIGNED_LAYOUT = 3338,
    STR_1_DESIGN_AVAILABLE = 3339,
    STR_X_DESIGNS_AVAILABLE = 3340,
    STR_GAME_TOOLS_TIP = 3341,
    STR_SCENARIO_EDITOR = 3342,
    STR_CONVERT_SAVED_GAME_TO_SCENARIO = 3343,
    STR_ROLLER_COASTER_DESIGNER = 3344,
    STR_TRACK_DESIGNS_MANAGER = 3345,
    STR_CANT_SAVE_TRACK_DESIGN = 3346,
    STR_TRACK_TOO_LARGE_OR_TOO_MUCH_SCENERY = 3347,
    STR_TRACK_MANAGE_RENAME = 3348,
    STR_TRACK_MANAGE_DELETE = 3349,
    STR_TRACK_DESIGN_RENAME_TITLE = 3350,
    STR_TRACK_DESIGN_RENAME_DESC = 3351,
    STR_CANT_RENAME_TRACK_DESIGN = 3352,
    STR_NEW_NAME_CONTAINS_INVALID_CHARACTERS = 3353,
    STR_ANOTHER_FILE_EXISTS_WITH_NAME_OR_FILE_IS_WRITE_PROTECTED = 3354,
    STR_FILE_IS_WRITE_PROTECTED_OR_LOCKED = 3355,
    STR_DELETE_FILE = 3356,
    STR_ARE_YOU_SURE_YOU_WANT_TO_PERMANENTLY_DELETE_TRACK = 3357,
    STR_CANT_DELETE_TRACK_DESIGN = 3358,
    STR_NO_TRACK_DESIGNS_OF_THIS_TYPE = 3359,
    STR_WARNING = 3360,
    STR_TOO_MANY_TRACK_DESIGNS_OF_THIS_TYPE = 3361,

    STR_OBJECT_SELECTION_ADVANCED = 3364,
    STR_OBJECT_SELECTION_ADVANCED_TIP = 3365,
    STR_MAP_RIDE = 3366,
    STR_MAP_FOOD_STALL = 3367,
    STR_MAP_DRINK_STALL = 3368,
    STR_MAP_SOUVENIR_STALL = 3369,
    STR_MAP_INFO_KIOSK = 3370,
    STR_MAP_FIRST_AID = 3371,
    STR_MAP_CASH_MACHINE = 3372,
    STR_MAP_TOILET = 3373,
    STR_WARNING_TOO_MANY_OBJECTS_SELECTED = 3374,
    STR_NOT_ALL_OBJECTS_IN_THIS_SCENERY_GROUP_COULD_BE_SELECTED = 3375,
    STR_INSTALL_NEW_TRACK_DESIGN = 3376,
    STR_INSTALL_NEW_TRACK_DESIGN_TIP = 3377,
    STR_INSTALL_NEW_TRACK_DESIGN_INSTALL = 3378,
    STR_INSTALL_NEW_TRACK_DESIGN_CANCEL = 3379,
    STR_UNABLE_TO_INSTALL_THIS_TRACK_DESIGN = 3380,

    STR_SELECT_NEW_NAME_FOR_TRACK_DESIGN = 3383,
    STR_AN_EXISTING_TRACK_DESIGN_ALREADY_HAS_THIS_NAME = 3384,

    STR_SAVE_TRACK_SCENERY_UNABLE_TO_SELECT_ADDITIONAL_ITEM_OF_SCENERY = 3389,
    STR_SAVE_TRACK_SCENERY_TOO_MANY_ITEMS_SELECTED = 3390,

    STR_CLEAR_SCENERY_TIP = 3437,
    STR_UNABLE_TO_REMOVE_ALL_SCENERY_FROM_HERE = 3438,
    STR_CLEAR_SCENERY = 3439,
    STR_SET_PATROL_AREA = 3445,
    STR_CLEAR_PATROL_AREA = 3446,

    // 3447--5119 reserved for user strings.

    STR_OPENRCT2_BEGIN_STRING_ID = 5120,

    STR_FINANCES_BUTTON_ON_TOOLBAR = 5120,
    STR_RESEARCH_BUTTON_ON_TOOLBAR = 5121,

    STR_CHEAT_RENEW_RIDES = 5123,

    STR_CHEAT_MAKE_DESTRUCTABLE = 5125,
    STR_OPTIONS_MUSIC_VALUE_RANDOM = 5126,
    STR_DISABLE_ELEVATION = 5127,
    STR_SELECTION_SIZE = 5128,
    STR_ENTER_SELECTION_SIZE = 5129,
    STR_MAP_SIZE_2 = 5130,
    STR_ENTER_MAP_SIZE = 5131,
    STR_CHEAT_FIX_ALL_RIDES = 5132,
    STR_ADJUST_SMALLER_LAND_RIGHTS_TIP = 5133,
    STR_ADJUST_LARGER_LAND_RIGHTS_TIP = 5134,
    STR_BUY_LAND_AND_CONSTRUCTION_RIGHTS_TIP = 5135,
    STR_LAND_RIGHTS = 5136,
    STR_CHEAT_UNLOCK_OPERATING_LIMITS = 5137,
    STR_SMALL_WINDOW_COLOUR_2_STRINGID = 5138,
    STR_WHITE_STRING = 5139,
    STR_CHEAT_DISABLE_BRAKES_FAILURE = 5140,
    STR_CHEAT_DISABLE_BREAKDOWNS = 5141,
    STR_SPEED_NORMAL = 5142,
    STR_SPEED_QUICK = 5143,
    STR_SPEED_FAST = 5144,
    STR_SPEED_TURBO = 5145,
    STR_SPEED_HYPER = 5146,
    STR_CHEATS_BUTTON_ON_TOOLBAR = 5147,
    STR_GAME_SPEED_TIP = 5148,
    STR_CHEATS_TIP = 5149,
    STR_ENABLE_DEBUGGING_TOOLS = 5150,
    STR_LOCALE_THOUSANDS_SEPARATOR = 5151,
    STR_LOCALE_DECIMAL_POINT = 5152,
    STR_EDIT_THEMES_BUTTON = 5153,
    STR_HARDWARE_DISPLAY = 5154, // Unused
    STR_CHEAT_UNLOCK_PRICES = 5157,
    STR_QUIT_TO_MENU = 5158,
    STR_EXIT_OPENRCT2 = 5159,
    STR_DATE_FORMAT_MDY = 5160,
    STR_DATE_FORMAT = 5161,
    STR_DATE_FORMAT_DAY_MONTH_YEAR = 5162,
    STR_DATE_FORMAT_MONTH_DAY_YEAR = 5163,
    STR_FULLSCREEN_MODE = 5177,
    STR_FINANCIAL_CHEATS_TIP = 5178,
    STR_GUEST_CHEATS_TIP = 5179,
    STR_PARK_CHEATS_TIP = 5180,
    STR_RIDE_CHEATS_TIP = 5181,
    STR_FORMAT_INTEGER = 5182,
    STR_BASE_HEIGHT = 5183,
    STR_ENTER_BASE_HEIGHT = 5184,
    STR_WATER_LEVEL = 5185,
    STR_ENTER_WATER_LEVEL = 5186,
    STR_THEMES_WINDOW_FINANCES = 5187,
    STR_THEMES_WINDOW_NEW_CAMPAIGN = 5188,
    STR_THEMES_WINDOW_RESEARCH = 5189,
    STR_THEMES_WINDOW_MAP = 5190,
    STR_THEMES_WINDOW_VIEWPORT = 5191,
    STR_THEMES_WINDOW_RECENT_NEWS = 5192,
    STR_THEMES_WINDOW_LAND = 5193,
    STR_THEMES_WINDOW_WATER = 5194,
    STR_THEMES_WINDOW_CLEAR_SCENERY = 5195,
    STR_THEMES_WINDOW_LAND_RIGHTS = 5196,
    STR_THEMES_WINDOW_SCENERY = 5197,
    STR_THEMES_WINDOW_FOOTPATH = 5198,
    STR_THEMES_WINDOW_RIDE_CONSTRUCTION = 5199,
    STR_THEMES_WINDOW_TRACK_DESIGN_PLACE = 5200,
    STR_THEMES_WINDOW_CONSTRUCT_RIDE = 5201,
    STR_THEMES_WINDOW_TRACK_DESIGN_LIST = 5202,
    STR_THEMES_WINDOW_RIDE = 5203,
    STR_THEMES_WINDOW_RIDE_LIST = 5204,
    STR_THEMES_WINDOW_PEEP = 5205,
    STR_THEMES_WINDOW_GUEST_LIST = 5206,
    STR_THEMES_WINDOW_STAFF = 5207,
    STR_THEMES_WINDOW_STAFF_LIST = 5208,
    STR_THEMES_WINDOW_BANNER = 5209,
    STR_THEMES_WINDOW_EDITOR_OBJECT_SELECTION = 5210,
    STR_THEMES_WINDOW_EDITOR_INVENTION_LIST = 5211,
    STR_THEMES_WINDOW_EDITOR_SCENARIO_OPTIONS = 5212,
    STR_THEMES_WINDOW_EDTIOR_OBJECTIVE_OPTIONS = 5213,
    STR_THEMES_WINDOW_MAPGEN = 5214,
    STR_THEMES_WINDOW_MANAGE_TRACK_DESIGN = 5215,
    STR_THEMES_WINDOW_INSTALL_TRACK = 5216,
    STR_CHEAT_TITLE = 5217,
    STR_THEMES_WINDOW_THEMES = 5218,
    STR_THEMES_WINDOW_OPTIONS = 5219,
    STR_THEMES_WINDOW_KEYBOARD_SHORTCUT_LIST = 5220,
    STR_THEMES_WINDOW_CHANGE_KEYBOARD_SHORTCUT = 5221,
    STR_THEMES_WINDOW_LOADSAVE = 5222,
    STR_THEMES_WINDOW_SAVE_PROMPT = 5223,
    STR_THEMES_WINDOW_DEMOLISH_RIDE_PROMPT = 5224,
    STR_THEMES_WINDOW_FIRE_PROMPT = 5225,
    STR_THEMES_WINDOW_TRACK_DELETE_PROMPT = 5226,
    STR_THEMES_WINDOW_LOADSAVE_OVERWRITE_PROMPT = 5227,
    STR_THEMES_TAB_MAIN_TIP = 5228,
    STR_THEMES_TAB_PARK_TIP = 5229,
    STR_THEMES_TAB_TOOLS_TIP = 5230,
    STR_THEMES_TAB_RIDES_AND_GUESTS_TIP = 5231,
    STR_THEMES_TAB_EDITORS_TIP = 5232,
    STR_THEMES_TAB_MISC_TIP = 5233,
    STR_THEMES_TAB_PROMPTS_TIP = 5234,
    STR_THEMES_TAB_SETTINGS_TIP = 5235,
    STR_THEMES_HEADER_WINDOW = 5236,
    STR_THEMES_HEADER_PALETTE = 5237,
    STR_THEMES_LABEL_CURRENT_THEME = 5238,
    STR_THEMES_ACTION_DUPLICATE = 5239,
    STR_THEMES_PROMPT_ENTER_THEME_NAME = 5240,
    STR_THEMES_ERR_CANT_CHANGE_THIS_THEME = 5241,
    STR_THEMES_ERR_NAME_ALREADY_EXISTS = 5242,
    STR_ERROR_INVALID_CHARACTERS = 5243,
    STR_THEMES_TITLE = 5244,
    STR_THEMES_WINDOW_TOP_TOOLBAR = 5245,
    STR_THEMES_WINDOW_BOTTOM_TOOLBAR = 5246,
    STR_THEMES_WINDOW_BOTTOM_TOOLBAR_TRACK_EDITOR = 5247,
    STR_THEMES_WINDOW_BOTTOM_TOOLBAR_SCENARIO_EDITOR = 5248,
    STR_THEMES_WINDOW_TITLE_MENU_BUTTONS = 5249,
    STR_THEMES_WINDOW_TITLE_MENU_EXIT = 5250,
    STR_THEMES_WINDOW_TITLE_MENU_OPTIONS = 5251,
    STR_THEMES_WINDOW_TITLE_MENU_SCENARIO_SELECTION = 5252,
    STR_THEMES_WINDOW_PARK_INFORMATION = 5253,
    STR_THEMES_DESC_CANT_CHANGE_THIS_THEME = 5256,
    STR_THEMES_ACTION_DUPLICATE_TIP = 5257,
    STR_THEMES_ACTION_DELETE_TIP = 5258,
    STR_THEMES_ACTION_RENAME_TIP = 5259,
    STR_GIANT_SCREENSHOT = 5260,
    STR_OBJECT_FILTER = 5261,
    STR_OBJECT_FILTER_WW = 5262,
    STR_OBJECT_FILTER_TT = 5263,
    STR_OBJECT_FILTER_CUSTOM = 5264,
    STR_OBJECT_FILTER_TIP = 5265,
    STR_OPTIONS_DISPLAY_TIP = 5266,
    STR_OPTIONS_CULTURE_TIP = 5267,
    STR_OPTIONS_AUDIO_TIP = 5268,
    STR_OPTIONS_CONTROLS_AND_INTERFACE_TIP = 5269,
    STR_OPTIONS_MISCELLANEOUS_TIP = 5270,
    STR_CLEAR_SCENERY_REMOVE_SMALL_SCENERY_TIP = 5272,
    STR_CLEAR_SCENERY_REMOVE_LARGE_SCENERY_TIP = 5273,
    STR_CLEAR_SCENERY_REMOVE_FOOTPATHS_TIP = 5274,
    STR_OBJECT_SEARCH = 5275,      // Unused (commented out)
    STR_OBJECT_SEARCH_DESC = 5276, // Unused (commented out)
    STR_OBJECT_SEARCH_CLEAR = 5277,
    STR_CHEAT_SANDBOX_MODE = 5278,
    STR_CHEAT_SANDBOX_MODE_DISABLE = 5279,
    STR_CHEAT_SANDBOX_MODE_TIP = 5280,
    STR_THEMES_TAB_FEATURES_TIP = 5281,
    STR_THEMES_OPTION_RCT1_RIDE_CONTROLS = 5282,
    STR_THEMES_OPTION_RCT1_PARK_CONTROLS = 5283,
    STR_THEMES_OPTION_RCT1_SCENARIO_SELECTION_FONT = 5284,

    STR_DEBUG_RIDE_ALREADY_BROKEN = 5287,
    STR_DEBUG_RIDE_IS_CLOSED = 5288,
    STR_DEBUG_NO_BREAKDOWNS_AVAILABLE = 5289,
    STR_DEBUG_FIX_RIDE = 5290,
    STR_DEBUG_CANT_FORCE_BREAKDOWN = 5291,
    STR_DEBUG_FORCE_BREAKDOWN_TIP = 5292,
    STR_CLOSE_RIDE_TIP = 5293,
    STR_TEST_RIDE_TIP = 5294,
    STR_OPEN_RIDE_TIP = 5295,
    STR_CLOSE_PARK_TIP = 5296,
    STR_OPEN_PARK_TIP = 5297,
    STR_RED_STRINGID = 5298,
    STR_LIGHTPINK_STRINGID = 5299,
    STR_QUICK_FIRE_STAFF = 5300,
    STR_CHEAT_CLEAR_LOAN_TIP = 5301,
    STR_CHEAT_CLEAR_LOAN = 5302,
    STR_CHEAT_BUILD_IN_PAUSE_MODE = 5303,
    STR_TITLE_SEQUENCE = 5304,
    STR_TITLE_SEQUENCE_RCT1 = 5305,
    STR_TITLE_SEQUENCE_RCT1_AA = 5306,
    STR_TITLE_SEQUENCE_RCT1_AA_LL = 5307,
    STR_TITLE_SEQUENCE_RCT2 = 5308,
    STR_TITLE_SEQUENCE_OPENRCT2 = 5309,
    STR_TITLE_SEQUENCE_RANDOM = 5310,
    STR_DEBUG_TIP = 5311,
    STR_DEBUG_DROPDOWN_CONSOLE = 5312,
    STR_DEBUG_DROPDOWN_TILE_INSPECTOR = 5313,
    STR_TILE_INSPECTOR_TITLE = 5314,
    STR_TILE_INSPECTOR_ENTRANCE_TYPE_RIDE_ENTRANCE = 5335,
    STR_TILE_INSPECTOR_ENTRANCE_TYPE_RIDE_EXIT = 5336,
    STR_TILE_INSPECTOR_ENTRANCE_TYPE_PARK_ENTRANC = 5337,
    STR_TILE_INSPECTOR_ELEMENT_TYPE = 5338,
    STR_TILE_INSPECTOR_BASE_HEIGHT = 5339,
    STR_TILE_INSPECTOR_CLEARANCE_HEIGHT = 5340,
    STR_AUTO_STAFF_PLACEMENT = 5343,
    STR_CHANGELOG_TITLE = 5344,
    STR_CHEAT_TITLE_FINANCIAL = 5345,
    STR_CHEAT_TITLE_GUEST = 5346,
    STR_CHEAT_TITLE_PARK = 5347,
    STR_CHEAT_TITLE_RIDE = 5348,
    STR_OBJECT_FILTER_ALL_RIDES_TIP = 5349,
    STR_MAX = 5350,
    STR_MIN = 5351,
    STR_CHEAT_GUEST_HAPPINESS = 5352,
    STR_CHEAT_GUEST_ENERGY = 5353,
    STR_CHEAT_GUEST_HUNGER = 5354,
    STR_CHEAT_GUEST_THIRST = 5355,
    STR_CHEAT_GUEST_NAUSEA = 5356,
    STR_CHEAT_GUEST_NAUSEA_TOLERANCE = 5357,
    STR_CHEAT_GUEST_TOILET = 5358,
    STR_CHEAT_REMOVE_ALL_GUESTS = 5359,
    STR_CHEAT_REMOVE_ALL_GUESTS_TIP = 5360,
    STR_CHEAT_GIVE_ALL_GUESTS = 5361,
    STR_CHEAT_GUEST_PREFERRED_INTENSITY = 5362,
    STR_CHEAT_MORE_THAN_1 = 5363,
    STR_CHEAT_LESS_THAN_15 = 5364,
    STR_CHEAT_STAFF_SPEED = 5365,
    STR_NORMAL = 5366,
    STR_FAST = 5367,
    STR_CHEAT_RESET_CRASH_STATUS = 5368,
    STR_DEBUG_DROPDOWN_OBJECT_SELECTION = 5371,
    STR_INVERT_RIGHT_MOUSE_DRAG = 5372,
    STR_NAME = 5373,
    STR_DATE = 5374,
    STR_UP = 5375,
    STR_DOWN = 5376,
    STR_ERROR_EXISTING_NAME = 5404,
    STR_MINIMISE_FULLSCREEN_ON_FOCUS_LOSS = 5440,

    STR_FORCE_PARK_RATING = 5442,
    STR_OBJECTS_SORT_TYPE = 5447,
    STR_OBJECTS_SORT_RIDE = 5448,
    STR_SHORTCUT_REDUCE_GAME_SPEED = 5449,
    STR_SHORTCUT_INCREASE_GAME_SPEED = 5450,
    STR_SHORTCUT_OPEN_CHEATS_WINDOW = 5451,
    STR_SHORTCUT_TOGGLE_VISIBILITY_OF_TOOLBARS = 5452,
    STR_SELECT_OTHER_RIDE = 5453,
    STR_UNCAP_FPS = 5454,
    STR_ENABLE_SANDBOX_MODE = 5455,
    STR_DISABLE_CLEARANCE_CHECKS = 5456,
    STR_DISABLE_SUPPORT_LIMITS = 5457,
    STR_ROTATE_CLOCKWISE = 5458,
    STR_ROTATE_ANTI_CLOCKWISE = 5459,
    STR_SHORTCUT_ROTATE_VIEW_ANTICLOCKWISE = 5460,
    STR_CHEAT_SET_GUESTS_PARAMETERS = 5461,
    STR_CURRENCY_FORMAT = 5462,
    STR_CHEAT_HAVE_FUN = 5463,
    STR_CHEAT_GENERAL_GROUP = 5464,
    STR_CHEAT_WEATHER_GROUP = 5465,
    STR_CHEAT_STAFF_GROUP = 5466,
    STR_ALT_PLUS = 5467,
    STR_SHOW_RECENT_MESSAGES_ON_TOOLBAR = 5468,
    STR_SHORTCUT_SCROLL_MAP_UP = 5469,
    STR_SHORTCUT_SCROLL_MAP_LEFT = 5470,
    STR_SHORTCUT_SCROLL_MAP_DOWN = 5471,
    STR_SHORTCUT_SCROLL_MAP_RIGHT = 5472,
    STR_CYCLE_DAY_NIGHT = 5473,
    STR_UPPERCASE_BANNERS = 5474,
    STR_X_WEEKS = 5475,
    STR_HARDWARE_GROUP = 5476,
    STR_RENDERING_GROUP = 5477,
    STR_CONTROLS_GROUP = 5478,
    STR_TOOLBAR_BUTTONS_GROUP = 5479,
    STR_SHOW_TOOLBAR_BUTTONS_FOR = 5480,
    STR_THEMES_GROUP = 5481,
    STR_TIME_SINCE_LAST_INSPECTION_MINUTE = 5482,
    STR_X_WEEKS_REMAINING = 5483,
    STR_1_WEEK_REMAINING = 5484,
    STR_BOTTOM_TOOLBAR_NEWS_TEXT = 5485,
    STR_LAND_TOOL_SIZE_VALUE = 5486,
    STR_SHOW_RECENT_MESSAGES_TIP = 5487,
    STR_TRACKED_GUESTS_ONLY_TIP = 5489,
    STR_AUDIO_FOCUS = 5490,
    STR_DEBUG_DROPDOWN_INVENTIONS_LIST = 5491,
    STR_DEBUG_DROPDOWN_SCENARIO_OPTIONS = 5492,
    STR_SEND_MESSAGE = 5493,

    STR_PLAYER_LIST = 5495, // Unused
    STR_PLAYER = 5496,
    STR_PING = 5497,
    STR_SERVER_LIST = 5498,
    STR_PLAYER_NAME = 5499,
    STR_ADD_SERVER = 5500,
    STR_START_SERVER = 5501,
    STR_MULTIPLAYER = 5502,
    STR_ENTER_HOSTNAME_OR_IP_ADDRESS = 5503,
    STR_SHOW_MULTIPLAYER_STATUS_TIP = 5504,
    STR_UNABLE_TO_CONNECT_TO_SERVER = 5505,
    STR_CHEAT_IGNORE_INTENSITY = 5506,
    STR_OPTIONS_SOUND_VALUE_DEFAULT = 5510,
    STR_OPTIONS_SOUND_VALUE_UNKNOWN = 5511,
    STR_SAVE_GAME_AS = 5512,
    STR_SHORTCUT_QUICK_SAVE_GAME = 5513,
    STR_CHEAT_DISABLE_VANDALISM = 5514,
    STR_CHEAT_DISABLE_VANDALISM_TIP = 5515,
    STR_COLOUR_BLACK_TIP = 5516,
    STR_COLOUR_GREY_TIP = 5517,
    STR_COLOUR_WHITE_TIP = 5518,
    STR_COLOUR_DARK_PURPLE_TIP = 5519,
    STR_COLOUR_LIGHT_PURPLE_TIP = 5520,
    STR_COLOUR_BRIGHT_PURPLE_TIP = 5521,
    STR_COLOUR_DARK_BLUE_TIP = 5522,
    STR_COLOUR_LIGHT_BLUE_TIP = 5523,
    STR_COLOUR_ICY_BLUE_TIP = 5524,
    STR_COLOUR_TEAL_TIP = 5525,
    STR_COLOUR_AQUAMARINE_TIP = 5526,
    STR_COLOUR_SATURATED_GREEN_TIP = 5527,
    STR_COLOUR_DARK_GREEN_TIP = 5528,
    STR_COLOUR_MOSS_GREEN_TIP = 5529,
    STR_COLOUR_BRIGHT_GREEN_TIP = 5530,
    STR_COLOUR_OLIVE_GREEN_TIP = 5531,
    STR_COLOUR_DARK_OLIVE_GREEN_TIP = 5532,
    STR_COLOUR_BRIGHT_YELLOW_TIP = 5533,
    STR_COLOUR_YELLOW_TIP = 5534,
    STR_COLOUR_DARK_YELLOW_TIP = 5535,
    STR_COLOUR_LIGHT_ORANGE_TIP = 5536,
    STR_COLOUR_DARK_ORANGE_TIP = 5537,
    STR_COLOUR_LIGHT_BROWN_TIP = 5538,
    STR_COLOUR_SATURATED_BROWN_TIP = 5539,
    STR_COLOUR_DARK_BROWN_TIP = 5540,
    STR_COLOUR_SALMON_PINK_TIP = 5541,
    STR_COLOUR_BORDEAUX_RED_TIP = 5542,
    STR_COLOUR_SATURATED_RED_TIP = 5543,
    STR_COLOUR_BRIGHT_RED_TIP = 5544,
    STR_COLOUR_DARK_PINK_TIP = 5545,
    STR_COLOUR_BRIGHT_PINK_TIP = 5546,
    STR_COLOUR_LIGHT_PINK_TIP = 5547,
    STR_CHEAT_SHOW_ALL_OPERATING_MODES = 5548,
    STR_DATE_FORMAT_YEAR_MONTH_DAY = 5549,
    STR_DATE_FORMAT_YMD = 5550,
    STR_DATE_FORMAT_YEAR_DAY_MONTH = 5551,
    STR_DATE_FORMAT_YDM = 5552,
    STR_STEAM_OVERLAY_PAUSE = 5553,
    STR_ENABLE_MOUNTAIN_TOOL_TIP = 5554,
    STR_CHEAT_SHOW_VEHICLES_FROM_OTHER_TRACK_TYPES = 5555,
    STR_KICK_PLAYER_TIP = 5556,
    STR_STAY_CONNECTED_AFTER_DESYNC = 5557,
    STR_RESTART_REQUIRED = 5558,
    STR_CHEAT_10_MINUTE_INSPECTIONS = 5559,
    STR_CHEAT_10_MINUTE_INSPECTIONS_TIP = 5560,
    STR_LANGUAGE_LOAD_FAILED = 5561,
    STR_WARNING_IN_CAPS = 5562,
    STR_THIS_FEATURE_IS_CURRENTLY_UNSTABLE = 5563,

    STR_PASSWORD = 5566,
    STR_ADVERTISE = 5567,
    STR_PASSWORD_REQUIRED = 5568,
    STR_PASSWORD_REQUIRED_DESC = 5569,
    STR_FETCH_SERVERS = 5570,
    STR_JOIN_GAME = 5571,
    STR_ADD_TO_FAVOURITES = 5572,
    STR_REMOVE_FROM_FAVOURITES = 5573,
    STR_SERVER_NAME = 5574,
    STR_MAX_PLAYERS = 5575,
    STR_PORT = 5576,
    STR_WON = 5577,
    STR_ROUBLE = 5578,
    STR_UI_SCALING_DESC = 5579,
    STR_CZECH_KORUNA = 5580,
    STR_SHOW_FPS = 5581,
    STR_TRAP_MOUSE = 5582,
    STR_UNIT_SUFFIX_METRES_PER_SECOND = 5583,
    STR_SI = 5584,
    STR_CHEAT_UNLOCK_OPERATING_LIMITS_TIP = 5585,
    STR_AUTO_OPEN_SHOPS = 5586,
    STR_AUTO_OPEN_SHOPS_TIP = 5587,
    STR_SHOW_MULTIPLAYER_TIP = 5588,
    STR_NOTIFICATION_SETTINGS = 5589,
    STR_NOTIFICATION_PARK_AWARD = 5590,
    STR_NOTIFICATION_PARK_MARKETING_CAMPAIGN_FINISHED = 5591,
    STR_NOTIFICATION_PARK_WARNINGS = 5592,
    STR_NOTIFICATION_PARK_RATING_WARNINGS = 5593,
    STR_NOTIFICATION_RIDE_BROKEN_DOWN = 5594,
    STR_NOTIFICATION_RIDE_CRASHED = 5595,
    STR_NOTIFICATION_RIDE_WARNINGS = 5596,
    STR_NOTIFICATION_RIDE_RESEARCHED = 5597,
    STR_NOTIFICATION_GUEST_WARNINGS = 5598,
    STR_NOTIFICATION_GUEST_LEFT_PARK = 5600,
    STR_NOTIFICATION_GUEST_QUEUING_FOR_RIDE = 5601,
    STR_NOTIFICATION_GUEST_ON_RIDE = 5602,
    STR_NOTIFICATION_GUEST_LEFT_RIDE = 5603,
    STR_NOTIFICATION_GUEST_BOUGHT_ITEM = 5604,
    STR_NOTIFICATION_GUEST_USED_FACILITY = 5605,
    STR_NOTIFICATION_GUEST_DIED = 5606,
    STR_TILE_INSPECTOR_BASE_HEIGHT_SHORT = 5608,
    STR_TILE_INSPECTOR_CLEARANGE_HEIGHT_SHORT = 5609,
    STR_REMOVE_SELECTED_ELEMENT_TIP = 5610,
    STR_TILE_INSPECTOR_FLAG_GHOST_SHORT = 5611,
    STR_TILE_INSPECTOR_FLAG_GHOST = 5612,
    STR_TILE_INSPECTOR_FLAG_BROKEN_SHORT = 5613,
    STR_TILE_INSPECTOR_FLAG_BROKEN = 5614,
    STR_TILE_INSPECTOR_FLAG_LAST_SHORT = 5615,
    STR_TILE_INSPECTOR_FLAG_LAST = 5616,
    STR_MOVE_SELECTED_ELEMENT_UP_TIP = 5617,
    STR_MOVE_SELECTED_ELEMENT_DOWN_TIP = 5618,
    STR_SCENARIO_CATEGORY_RCT1 = 5619,
    STR_SCENARIO_CATEGORY_RCT1_AA = 5620,
    STR_SCENARIO_CATEGORY_RCT1_LL = 5621,
    STR_SCENARIO_CATEGORY_RCT2 = 5622,
    STR_SCENARIO_CATEGORY_RCT2_WW = 5623,
    STR_SCENARIO_CATEGORY_RCT2_TT = 5624,
    STR_SCENARIO_CATEGORY_REAL_PARKS = 5625,
    STR_SCENARIO_CATEGORY_OTHER_PARKS = 5626,
    STR_OPTIONS_SCENARIO_GROUPING = 5627,
    STR_OPTIONS_SCENARIO_ORIGIN = 5628,
    STR_OPTIONS_SCENARIO_DIFFICULTY = 5629,
    STR_OPTIONS_SCENARIO_UNLOCKING = 5630,
    STR_DLC_PARKS = 5631,
    STR_BUILD_YOUR_OWN_PARKS = 5632,
    STR_CMD_PLUS = 5633,
    STR_OPTION_PLUS = 5634,
    STR_MONEY_SPENT = 5635,
    STR_COMMANDS_RAN = 5636,
    STR_CANT_DO_THIS = 5637,
    STR_PERMISSION_DENIED = 5638,
    STR_PLAYERS_TIP = 5639,
    STR_GROUPS_TIP = 5640,
    STR_DEFAULT_GROUP = 5641,
    STR_GROUP = 5642,
    STR_ADD_GROUP = 5643,
    STR_REMOVE_GROUP = 5644,
    STR_ACTION_CHAT = 5645,
    STR_ACTION_TERRAFORM = 5646,
    STR_ACTION_TOGGLE_PAUSE = 5647,
    STR_ACTION_SET_WATER_LEVEL = 5648,
    STR_ACTION_CREATE_RIDE = 5649,
    STR_ACTION_REMOVE_RIDE = 5650,
    STR_ACTION_BUILD_RIDE = 5651,
    STR_ACTION_RIDE_PROPERTIES = 5652,
    STR_ACTION_SCENERY = 5653,
    STR_ACTION_PATH = 5654,
    STR_ACTION_GUEST = 5655,
    STR_ACTION_STAFF = 5656,
    STR_ACTION_PARK_PROPERTIES = 5657,
    STR_ACTION_PARK_FUNDING = 5658,
    STR_ACTION_KICK_PLAYER = 5659,
    STR_ACTION_MODIFY_GROUPS = 5660,
    STR_ACTION_SET_PLAYER_GROUP = 5661,
    STR_ACTION_NA = 5662,
    STR_ACTION_CLEAR_LANDSCAPE = 5663,
    STR_ACTION_CHEAT = 5664,
    STR_ACTION_TOGGLE_SCENERY_CLUSTER = 5665,
    STR_ACTION_PASSWORDLESS_LOGIN = 5666,
    // Empty block
    STR_LAST_ACTION_RAN = 5701,
    STR_LOCATE_PLAYER_TIP = 5702,
    STR_CANT_KICK_THE_HOST = 5703,
    STR_LAST_ACTION = 5704,
    STR_CANT_SET_TO_THIS_GROUP = 5705,
    STR_CANT_REMOVE_GROUP_THAT_PLAYERS_BELONG_TO = 5706,
    STR_THIS_GROUP_CANNOT_BE_MODIFIED = 5707,
    STR_CANT_CHANGE_GROUP_THAT_THE_HOST_BELONGS_TO = 5708,
    STR_RENAME_GROUP = 5709,
    STR_GROUP_NAME = 5710,
    STR_ENTER_NEW_NAME_FOR_THIS_GROUP = 5711,
    STR_CANT_MODIFY_PERMISSION_THAT_YOU_DO_NOT_HAVE_YOURSELF = 5712,
    // STR_5713    :Kick Player (unused)
    STR_SHORTCUT_SHOW_OPTIONS = 5714,
    STR_NEW_GAME = 5715,
    STR_NOT_ALLOWED_IN_MULTIPLAYER = 5716, // Unused
    STR_NETWORK_VERSION = 5717,
    STR_NETWORK_VERSION_TIP = 5718,
    STR_SUNNY = 5719,
    STR_PARTIALLY_CLOUDY = STR_SUNNY + 1,
    STR_CLOUDY = STR_SUNNY + 2,
    STR_RAIN = STR_SUNNY + 3,
    STR_HEAVY_RAIN = STR_SUNNY + 4,
    STR_THUNDERSTORM = STR_SUNNY + 5,
    STR_CHANGE_WEATHER = 5725,
    STR_CHANGE_WEATHER_TOOLTIP = 5726,
    STR_OPTIONS_RENDERING_TIP = 5734,
    STR_THEMES_WINDOW_NETWORK_STATUS = 5735,
    STR_THEMES_WINDOW_PLAYER = 5736,
    STR_CLOSED_WITH_PERSON = 5737,
    STR_CLOSED_WITH_PEOPLE = 5738,
    STR_CUSTOMERS_ON_RIDE = 5739,
    STR_CHEAT_NEVERENDING_MARKETING = 5740,
    STR_CHEAT_NEVERENDING_MARKETING_TIP = 5741,
    STR_MULTIPLAYER_AUTHENTICATING = 5742,
    STR_MULTIPLAYER_CONNECTING = 5743,
    STR_MULTIPLAYER_RESOLVING = 5744,
    STR_MULTIPLAYER_DESYNC = 5745,
    STR_MULTIPLAYER_DISCONNECTED_NO_REASON = 5746,
    STR_MULTIPLAYER_DISCONNECTED_WITH_REASON = 5747,
    STR_MULTIPLAYER_KICKED = 5748,
    STR_MULTIPLAYER_KICKED_REASON = 5749,
    STR_MULTIPLAYER_CONNECTION_CLOSED = 5750,
    STR_MULTIPLAYER_NO_DATA = 5751,
    STR_MULTIPLAYER_PLAYER_HAS_DISCONNECTED_NO_REASON = 5752,
    STR_MULTIPLAYER_PLAYER_HAS_DISCONNECTED_WITH_REASON = 5753,
    STR_MULTIPLAYER_BAD_PLAYER_NAME = 5754,
    STR_MULTIPLAYER_INCORRECT_SOFTWARE_VERSION = 5755,
    STR_MULTIPLAYER_BAD_PASSWORD = 5756,
    STR_MULTIPLAYER_SERVER_FULL = 5757,
    STR_MULTIPLAYER_PLAYER_HAS_JOINED_THE_GAME = 5758,
    STR_MULTIPLAYER_DOWNLOADING_MAP = 5759,
    STR_HONG_KONG_DOLLAR = 5760,
    STR_NEW_TAIWAN_DOLLAR = 5761,
    STR_CHINESE_YUAN = 5762,
    STR_ALL_FILES = 5763,
    STR_INVALID_RIDE_TYPE = 5764,
    STR_CANT_EDIT_INVALID_RIDE_TYPE = 5765,
    STR_HUNGARIAN_FORINT = 5766,
    STR_RIDE_LIST_INCOME = 5767,
    STR_RIDE_LIST_TOTAL_CUSTOMERS = 5768,
    STR_RIDE_LIST_TOTAL_PROFIT = 5769,
    STR_RIDE_LIST_CUSTOMERS_PER_HOUR = 5770,
    STR_RIDE_LIST_RUNNING_COST = 5771,
    STR_RIDE_LIST_AGE = 5772,
    STR_RIDE_LIST_TOTAL_CUSTOMERS_LABEL = 5773,
    STR_RIDE_LIST_TOTAL_PROFIT_LABEL = 5774,
    STR_RIDE_LIST_CUSTOMERS_PER_HOUR_LABEL = 5775,
    STR_RIDE_LIST_BUILT_THIS_YEAR_LABEL = 5776,
    STR_RIDE_LIST_BUILT_LAST_YEAR_LABEL = 5777,
    STR_RIDE_LIST_BUILT_X_YEARS_AGO_LABEL = 5778,
    STR_RIDE_LIST_INCOME_LABEL = 5779,
    STR_RIDE_LIST_RUNNING_COST_LABEL = 5780,
    STR_RIDE_LIST_RUNNING_COST_UNKNOWN = 5781,
    STR_MULTIPLAYER_CONNECTED_CHAT_HINT = 5782,
    STR_SCENARIO_LOCKED = 5783,
    STR_SCENARIO_LOCKED_DESC = 5784,
    STR_CANT_RENAME_GROUP = 5785,
    STR_INVALID_GROUP_NAME = 5786,
    STR_X_PLAYERS_ONLINE = 5787,
    STR_DEFAULT_INSPECTION_INTERVAL = 5788,
    STR_DISABLE_LIGHTNING_EFFECT = 5789,
    STR_CHEAT_UNLOCK_PRICES_TIP = 5790,
    STR_CHEAT_RENEW_RIDES_TIP = 5791,
    STR_CHEAT_FIX_ALL_RIDES_TIP = 5792,
    STR_CHEAT_RESET_CRASH_STATUS_TIP = 5793,
    STR_CHEAT_MAKE_DESTRUCTABLE_TIP = 5794,
    STR_CHEAT_IGNORE_INTENSITY_TIP = 5795,
    STR_CHEAT_OPEN_PARK_TIP = 5796,
    STR_CHEAT_FREEZE_WEATHER_TIP = 5797,
    STR_CHEAT_BUILD_IN_PAUSE_MODE_TIP = 5798,
    STR_CHEAT_DISABLE_BRAKES_FAILURE_TIP = 5799,
    STR_CHEAT_DISABLE_BREAKDOWNS_TIP = 5800,
    STR_CHEAT_DISABLE_LITTERING = 5801,
    STR_CHEAT_DISABLE_LITTERING_TIP = 5802,
    STR_ROTATE_SELECTED_ELEMENT_TIP = 5803,
    STR_SHORTCUT_MUTE_SOUND = 5804,
    STR_ADVERTISE_SERVER_TIP = 5805,
    STR_SHORTCUT_WINDOWED_MODE_TOGGLE = 5806,
    STR_NUMBER_RIDES = 5807,
    STR_NUMBER_SHOPS_AND_STALLS = 5808,
    STR_NUMBER_TOILETS_AND_INFORMATION_KIOSKS = 5809,
    STR_CHEAT_DISABLE_TRAIN_LENGTH_LIMIT = 5810,
    STR_CHEAT_DISABLE_TRAIN_LENGTH_LIMIT_TIP = 5811,
    STR_SHORTCUT_SHOW_MULTIPLAYER = 5812,
    STR_TRACK_LIST_NAME_FORMAT = 5813,
    STR_TRACK_PREVIEW_NAME_FORMAT = 5814,
    STR_SHOW_FPS_TIP = 5815,
    STR_WINDOW_SCALE_TIP = 5816,
    STR_STEAM_OVERLAY_PAUSE_TIP = 5819,
    STR_MINIMISE_FULLSCREEN_ON_FOCUS_LOSS_TIP = 5820,
    STR_CYCLE_DAY_NIGHT_TIP = 5822,
    STR_UPPERCASE_BANNERS_TIP = 5823,
    STR_DISABLE_LIGHTNING_EFFECT_TIP = 5824,
    STR_TRAP_MOUSE_TIP = 5825,
    STR_INVERT_RIGHT_MOUSE_DRAG_TIP = 5826,
    STR_CURRENT_THEME_TIP = 5827,
    STR_DISTANCE_AND_SPEED_TIP = 5828,
    STR_CURRENCY_TIP = 5829,
    STR_LANGUAGE_TIP = 5830,
    STR_TEMPERATURE_FORMAT_TIP = 5831,
    STR_HEIGHT_LABELS_UNITS_TIP = 5832,
    STR_DATE_FORMAT_TIP = 5833,
    STR_AUDIO_DEVICE_TIP = 5834,
    STR_AUDIO_FOCUS_TIP = 5835,
    STR_TITLE_MUSIC_TIP = 5836,
    STR_EDIT_THEMES_BUTTON_TIP = 5837,
    STR_FINANCES_BUTTON_ON_TOOLBAR_TIP = 5838,
    STR_RESEARCH_BUTTON_ON_TOOLBAR_TIP = 5839,
    STR_CHEATS_BUTTON_ON_TOOLBAR_TIP = 5840,
    STR_SHOW_RECENT_MESSAGES_ON_TOOLBAR_TIP = 5841,
    STR_SCENARIO_GROUPING_TIP = 5842,
    STR_SCENARIO_UNLOCKING_TIP = 5843,
    STR_STAY_CONNECTED_AFTER_DESYNC_TIP = 5844,
    STR_ENABLE_DEBUGGING_TOOLS_TIP = 5845,
    STR_AUTOSAVE_FREQUENCY_TIP = 5846,
    STR_TITLE_SEQUENCE_TIP = 5847,
    STR_AUTO_STAFF_PLACEMENT_TIP = 5849,
    STR_HANDYMEN_MOW_BY_DEFAULT_TIP = 5850,
    STR_DEFAULT_INSPECTION_INTERVAL_TIP = 5851,
    STR_SOUND_EFFECTS_TIP = 5853,
    STR_RIDE_MUSIC_TIP = 5854,
    STR_FULLSCREEN_MODE_TIP = 5855,
    STR_DISPLAY_RESOLUTION_TIP = 5856,
    STR_OPTIONS_TIP = 5857,
    STR_HARDWARE_DISPLAY_TIP = 5858, // Unused
    STR_UNCAP_FPS_TIP = 5859,
    STR_SHORTCUT_PAINT_ORIGINAL = 5860,
    STR_MULTIPLAYER_VERIFICATION_FAILURE = 5861,
    STR_ALLOW_KNOWN_KEYS_ONLY = 5862,
    STR_ALLOW_KNOWN_KEYS_ONLY_TIP = 5863,
    STR_MULTIPLAYER_UNKNOWN_KEY_DISALLOWED = 5864,
    STR_LOG_CHAT = 5865,
    STR_LOG_CHAT_TIP = 5866,
    STR_PROVIDER_NAME = 5867,
    STR_PROVIDER_EMAIL = 5868,
    STR_PROVIDER_WEBSITE = 5869,
    STR_SHOW_SERVER_INFO_TIP = 5870,
    STR_CHEAT_DISABLE_PLANT_AGING = 5871,
    STR_CHEAT_DISABLE_PLANT_AGING_TIP = 5872,
    STR_CHEAT_ENABLE_CHAIN_LIFT_ON_ALL_TRACK = 5873,
    STR_CHEAT_ENABLE_CHAIN_LIFT_ON_ALL_TRACK_TIP = 5874,
    STR_DRAWING_ENGINE = 5875,
    STR_DRAWING_ENGINE_TIP = 5876,
    STR_DRAWING_ENGINE_SOFTWARE = 5877,
    STR_DRAWING_ENGINE_SOFTWARE_WITH_HARDWARE_DISPLAY = 5878,
    STR_DRAWING_ENGINE_OPENGL = 5879,
    STR_SELECTED_ONLY = 5880,
    STR_NON_SELECTED_ONLY = 5881,
    STR_CUSTOM_CURRENCY = 5882,
    STR_CUSTOM_CURRENCY_WINDOW_TITLE = 5883,
    STR_RATE = 5884,
    STR_CUSTOM_CURRENCY_EQUIVALENCY = 5885,
    STR_CURRENCY_SYMBOL_TEXT = 5886,
    STR_PREFIX = 5887,
    STR_SUFFIX = 5888,
    STR_CUSTOM_CURRENCY_SYMBOL_INPUT_TITLE = 5889,
    STR_CUSTOM_CURRENCY_SYMBOL_INPUT_DESC = 5890,
    STR_LOADSAVE_DEFAULT = 5891,
    STR_LOADSAVE_DEFAULT_TIP = 5892,
    STR_RATE_INPUT_TITLE = 5893,
    STR_RATE_INPUT_DESC = 5894,
    STR_FILE_DIALOG_TITLE_SAVE_TRACK = 5895,
    STR_TRACK_SAVE_FAILED = 5896,
    STR_TRACK_LOAD_FAILED_ERROR = 5898,
    STR_SHORTCUT_DEBUG_PAINT_TOGGLE = 5899,
    STR_DEBUG_PAINT_USE_OLD_DRAWING = 5900,
    STR_DEBUG_PAINT_SHOW_SEGMENT_HEIGHTS = 5901,
    STR_DEBUG_PAINT_SHOW_BOUND_BOXES = 5902,
    STR_DEBUG_DROPDOWN_DEBUG_PAINT = 5903,
    STR_CHEAT_RESET_DATE = 5904,
    STR_MAP_GENERATOR_TIP = 5905,
    STR_ZOOM_TO_CURSOR = 5906,
    STR_ZOOM_TO_CURSOR_TIP = 5907,
    STR_CHEAT_ALLOW_ARBITRARY_RIDE_TYPE_CHANGES = 5908,
    STR_CHEAT_ALLOW_ARBITRARY_RIDE_TYPE_CHANGES_TIP = 5909,
    STR_APPLY = 5910,
    STR_SEE_THROUGH_PATHS = 5911,
    STR_SHORTCUT_SEE_THROUGH_PATHS_TOGGLE = 5912,
    STR_CHAT = 5913,
    STR_RIDE_DESCRIPTION_UNKNOWN = 5914,
    STR_MULTIPLAYER_DEFAULT_NAME = 5915,
    STR_MULTIPLAYER_PLAYER_COUNT = 5916,
    STR_MULTIPLAYER_PLAYER_COUNT_PLURAL = 5917,
    STR_SERVER_MAX_PLAYERS_VALUE = 5918,
    STR_COMMA16 = 5919,
    STR_RENDER_WEATHER_EFFECTS = 5920,
    STR_RENDER_WEATHER_EFFECTS_TIP = 5921,
    STR_MAX_VEHICLES_TIP = 5922,
    STR_MAX_CARS_PER_TRAIN_TIP = 5923,
    STR_TILE_INSPECTOR_GROUPBOX_SURFACE_INFO = 5924,
    STR_TILE_INSPECTOR_GROUPBOX_PATH_INFO = 5925,
    STR_TILE_INSPECTOR_GROUPBOX_TRACK_INFO = 5926,
    STR_TILE_INSPECTOR_GROUPBOX_SCENERY_INFO = 5927,
    STR_TILE_INSPECTOR_GROUPBOX_ENTRANCE_INFO = 5928,
    STR_TILE_INSPECTOR_GROUPBOX_WALL_INFO = 5929,
    STR_TILE_INSPECTOR_GROUPBOX_LARGE_SCENERY_INFO = 5930,
    STR_TILE_INSPECTOR_GROUPBOX_BANNER_INFO = 5931,
    STR_TILE_INSPECTOR_GROUPBOX_PROPERTIES = 5933,
    STR_TILE_INSPECTOR_SURFACE_TERAIN = 5934,
    STR_TILE_INSPECTOR_SURFACE_EDGE = 5935,
    STR_TILE_INSPECTOR_SURFACE_OWNERSHIP = 5936,
    STR_TILE_INSPECTOR_LAND_NOT_OWNED_AND_NOT_AVAILABLE = 5937,
    STR_TILE_INSPECTOR_SURFACE_WATER_LEVEL = 5938,
    STR_TILE_INSPECTOR_SURFACE_REMOVE_FENCES = 5939,
    STR_TILE_INSPECTOR_SURFACE_RESTORE_FENCES = 5940,
    STR_TILE_INSPECTOR_BASE_HEIGHT_FULL = 5941,
    STR_TILE_INSPECTOR_PATH_NAME = 5942,
    STR_TILE_INSPECTOR_PATH_ADDITIONS = 5943,
    STR_TILE_INSPECTOR_PATH_ADDITIONS_NONE = 5944,
    STR_TILE_INSPECTOR_PATH_CONNECTED_EDGES = 5945,
    STR_TILE_INSPECTOR_TRACK_RIDE_TYPE = 5946,
    STR_TILE_INSPECTOR_TRACK_RIDE_ID = 5947,
    STR_TILE_INSPECTOR_TRACK_RIDE_NAME = 5948,
    STR_TILE_INSPECTOR_TRACK_CHAIN_LIFT = 5949,
    STR_TILE_INSPECTOR_TRACK_ENTIRE_TRACK_PIECE = 5950,
    STR_TILE_INSPECTOR_TRACK_PIECE_ID = 5951,
    STR_TILE_INSPECTOR_TRACK_SEQUENCE = 5952,
    STR_TILE_INSPECTOR_SORT_TIP = 5953,
    STR_TILE_INSPECTOR_SCENERY_AGE = 5954,
    STR_TILE_INSPECTOR_SCENERY_QUADRANT = 5955,
    STR_TILE_INSPECTOR_SCENERY_QUADRANT_SW = 5956,
    STR_TILE_INSPECTOR_SCENERY_QUADRANT_NW = 5957,
    STR_TILE_INSPECTOR_SCENERY_QUADRANT_NE = 5958,
    STR_TILE_INSPECTOR_SCENERY_QUADRANT_SE = 5959,
    STR_TILE_INSPECTOR_SCENERY_QUADRANT_LABEL = 5960,
    STR_TILE_INSPECTOR_SCENERY_ENTRY_IDX = 5961,
    STR_TILE_INSPECTOR_COLLISSION = 5962,
    STR_TILE_INSPECTOR_SURFACE_CORNERS = 5963,
    STR_TILE_INSPECTOR_SURFACE_DIAGONAL = 5964,
    STR_TILE_INSPECTOR_ENTRANCE_TYPE = 5965,
    STR_TILE_INSPECTOR_ENTRANCE_PART = 5966,
    STR_TILE_INSPECTOR_ENTRANCE_MIDDLE = 5967,
    STR_TILE_INSPECTOR_ENTRANCE_LEFT = 5968,
    STR_TILE_INSPECTOR_ENTRANCE_RIGHT = 5969,
    STR_TILE_INSPECTOR_ENTRANCE_ENTRANCE_ID = 5970,
    STR_TILE_INSPECTOR_ENTRANCE_EXIT_ID = 5971,
    STR_TILE_INSPECTOR_ENTRANCE_RIDE_ID = 5972,
    STR_TILE_INSPECTOR_CLAMP_TO_NEXT = 5973,
    STR_TILE_INSPECTOR_CLAMP_TO_NEXT_TIP = 5974,
    STR_TILE_INSPECTOR_WALL_SLOPE = 5975,
    STR_TILE_INSPECTOR_WALL_FLAT = 5976,
    STR_TILE_INSPECTOR_WALL_SLOPED_LEFT = 5977,
    STR_TILE_INSPECTOR_WALL_SLOPED_RIGHT = 5978,
    STR_TILE_INSPECTOR_WALL_TYPE = 5979,
    STR_TILE_INSPECTOR_ENTRY_BANNER_TEXT = 5980,
    STR_TILE_INSPECTOR_ENTRY_BANNER_NONE = 5981,
    STR_TILE_INSPECTOR_LARGE_SCENERY_TYPE = 5982,
    STR_TILE_INSPECTOR_LARGE_SCENERY_PIECE_ID = 5983,
    STR_TILE_INSPECTOR_BANNER_BLOCKED_PATHS = 5984,
    STR_FILEBROWSER_ACTION_NEW_FOLDER = 5985,
    STR_FILEBROWSER_FOLDER_NAME_PROMPT = 5986,
    STR_UNABLE_TO_CREATE_FOLDER = 5987,
    STR_NO_LAND_RIGHTS_FOR_SALE_TIP = 5988,
    STR_NO_CONSTRUCTION_RIGHTS_FOR_SALE_TIP = 5989,
    STR_NO_LAND_OR_CONSTRUCTION_RIGHTS_FOR_SALE_TIP = 5990,
    STR_CANT_PASTE = 5991,
    STR_TILE_ELEMENT_LIMIT_REACHED = 5992,
    STR_TILE_INSPECTOR_COPY_TIP = 5993,
    STR_TILE_INSPECTOR_PASTE_TIP = 5994,
    STR_BOOSTER = 5995,
    STR_RIDE_CONSTRUCTION_BOOSTER_SPEED = 5996,

    STR_ADD_SET_MONEY = 5997,
    STR_ADD_MONEY = 5998,
    STR_SET_MONEY = 5999,
    STR_ENTER_NEW_VALUE = 6000,

    STR_ENABLE_LIGHTING_EFFECTS = 6001,
    STR_ENABLE_LIGHTING_EFFECTS_TIP = 6002,

    STR_VIEW_CLIPPING_MENU = 6003,
    STR_VIEW_CLIPPING_TITLE = 6004,
    STR_VIEW_CLIPPING_HEIGHT_ENABLE = 6005,
    STR_VIEW_CLIPPING_HEIGHT_ENABLE_TIP = 6006,
    STR_VIEW_CLIPPING_HEIGHT_VALUE = 6007,
    STR_VIEW_CLIPPING_HEIGHT_VALUE_TOGGLE = 6008,
    STR_VIEW_CLIPPING_HEIGHT_SCROLL_TIP = 6009,
    STR_UNIT2DP_SUFFIX_METRES = 6010,
    STR_UNIT1DP_SUFFIX_FEET = 6011,
    STR_UNIT1DP_NO_SUFFIX = 6012,
    STR_RIDE_INCOME_ADMISSION_PAY_FOR_ENTRY_TIP = 6013,
    STR_ADMISSION_PRICE_PAY_PER_RIDE_TIP = 6014,
    STR_TILE_INSPECTOR_PATH_SLOPED = 6015,
    STR_ACTION_MODIFY_TILE = 6016,
    STR_NETWORK_ACTION_RATE_LIMIT_MESSAGE = 6017,
    STR_SHORTCUT_CONSTRUCTION_TURN_LEFT = 6018,
    STR_SHORTCUT_CONSTRUCTION_TURN_RIGHT = 6019,
    STR_SHORTCUT_CONSTRUCTION_USE_TRACK_DEFAULT = 6020,
    STR_SHORTCUT_CONSTRUCTION_SLOPE_DOWN = 6021,
    STR_SHORTCUT_CONSTRUCTION_SLOPE_UP = 6022,
    STR_SHORTCUT_CONSTRUCTION_CHAIN_LIFT_TOGGLE = 6023,
    STR_SHORTCUT_CONSTRUCTION_BANK_LEFT = 6024,
    STR_SHORTCUT_CONSTRUCTION_BANK_RIGHT = 6025,
    STR_SHORTCUT_CONSTRUCTION_PREVIOUS_TRACK = 6026,
    STR_SHORTCUT_CONSTRUCTION_NEXT_TRACK = 6027,
    STR_SHORTCUT_CONSTRUCTION_BUILD_CURRENT = 6028,
    STR_SHORTCUT_CONSTRUCTION_DEMOLISH_CURRENT = 6029,

    STR_SCENERY_EYEDROPPER_TIP = 6030,

    STR_SERVER_DESCRIPTION = 6031,
    STR_SERVER_GREETING = 6032,

    STR_PATH_TO_RCT1 = 6033,
    STR_STRING_TOOLTIP = 6034,
    STR_PATH_TO_RCT1_BROWSER = 6035,
    STR_PATH_TO_RCT1_CLEAR_TIP = 6036,
    STR_PATH_TO_RCT1_WRONG_ERROR = 6037,
    STR_PATH_TO_RCT1_TIP = 6038,

    STR_QUICK_DEMOLISH_RIDE = 6039,

    STR_ACTION_EDIT_SCENARIO_OPTIONS = 6040,

    STR_NO_MECHANICS_ARE_HIRED_MESSAGE = 6041,

    STR_FILE_DIALOG_TITLE_LOAD_HEIGHTMAP = 6042,
    STR_MAPGEN_SELECT_HEIGHTMAP = 6043,
    STR_MAPGEN_SMOOTH_HEIGHTMAP = 6044,
    STR_MAPGEN_SMOOTH_STRENGTH = 6045,
    STR_MAPGEN_NORMALIZE = 6046,
    STR_MAPGEN_SMOOTH_TILE = 6047,
    STR_HEIGHT_MAP_ERROR = 6048,
    STR_ERROR_READING_PNG = 6049,
    STR_ERROR_READING_BITMAP = 6050,

    STR_ERROR_HEIHGT_MAP_TOO_BIG = 6052,
    STR_ERROR_CANNOT_NORMALIZE = 6053,
    STR_ERROR_24_BIT_BITMAP = 6054,
    STR_OPENRCT2_HEIGHTMAP_FILE = 6055,

    STR_TOOLBAR_MUTE_TIP = 6056,
    STR_MUTE_BUTTON_ON_TOOLBAR_TIP = 6057,
    STR_MUTE_BUTTON_ON_TOOLBAR = 6058,

    STR_RIGHTGUILLEMET = 6059,

    STR_SHOW_GUEST_PURCHASES = 6060,
    STR_SHOW_GUEST_PURCHASES_TIP = 6061,
    STR_MONEY_EFFECT_RECEIVE_HIGHP = 6062,
    STR_MONEY_EFFECT_SPEND_HIGHP = 6063,

    STR_CHEAT_OWN_ALL_LAND = 6064,

    STR_LOG_SERVER_ACTIONS = 6065,
    STR_LOG_SERVER_ACTIONS_TIP = 6066,
    STR_LOG_SERVER_STARTED = 6067,
    STR_LOG_SERVER_STOPPED = 6068,
    STR_LOG_PLAYER_KICKED = 6069,
    STR_LOG_SET_PLAYER_GROUP = 6070,
    STR_LOG_ADD_PLAYER_GROUP = 6071,
    STR_LOG_REMOVE_PLAYER_GROUP = 6072,
    STR_LOG_EDIT_PLAYER_GROUP_PERMISSIONS = 6073,
    STR_LOG_EDIT_PLAYER_GROUP_NAME = 6074,
    STR_LOG_EDIT_DEFAULT_PLAYER_GROUP = 6075,
    STR_LOG_CHEAT_USED = 6076,
    STR_LOG_CHEAT_ADD_MONEY = 6077,
    STR_LOG_CREATE_RIDE = 6078,
    STR_LOG_DEMOLISH_RIDE = 6079,
    STR_LOG_RIDE_APPEARANCE = 6080,
    STR_LOG_RIDE_STATUS_CLOSED = 6081,
    STR_LOG_RIDE_STATUS_OPEN = 6082,
    STR_LOG_RIDE_STATUS_TESTING = 6083,
    STR_LOG_RIDE_VEHICLES = 6084,
    STR_LOG_RIDE_SETTINGS = 6085,
    STR_LOG_RIDE_NAME = 6086,
    STR_LOG_RIDE_PRICE = 6087,
    STR_LOG_RIDE_SECONDARY_PRICE = 6088,
    STR_LOG_PARK_NAME = 6089,
    STR_LOG_PARK_CLOSED = 6090,
    STR_LOG_PARK_OPEN = 6091,
    STR_LOG_PARK_ENTRANCE_FEE = 6092,
    STR_LOG_PLACE_SCENERY = 6093,
    STR_LOG_REMOVE_SCENERY = 6094,
    STR_LOG_EDIT_SCENERY = 6095,
    STR_LOG_SET_SIGN_NAME = 6096,
    STR_LOG_PLACE_TRACK = 6097,
    STR_LOG_REMOVE_TRACK = 6098,
    STR_LOG_CLIENT_STARTED = 6099,
    STR_LOG_CLIENT_STOPPED = 6100,
    STR_CHEAT_DISABLE_RIDE_VALUE_AGING = 6101,
    STR_CHEAT_DISABLE_RIDE_VALUE_AGING_TIP = 6102,
    STR_OPTION_DISABLED_DURING_NETWORK_PLAY = 6103,

    STR_RIDE_NAME_HYPERCOASTER = 6105,
    STR_RIDE_NAME_MONSTER_TRUCKS = 6107,
    STR_RIDE_NAME_HYPER_TWISTER = 6109,
    STR_RIDE_NAME_CLASSIC_MINI_ROLLER_COASTER = 6111,
    STR_RIDE_DESCRIPTION_HYPERCOASTER = 6113,
    STR_RIDE_DESCRIPTION_MONSTER_TRUCKS_GROUP = 6115,
    STR_RIDE_DESCRIPTION_TWISTER_ROLLER_COASTER = 6116,
    STR_RIDE_DESCRIPTION_CLASSIC_MINI_COASTER = 6119,

    STR_NEWS_ITEM_RESEARCH_NEW_VEHICLE_AVAILABLE = 6120,

    STR_CHEAT_OWN_ALL_LAND_TIP = 6121,

    STR_NOT_ENOUGH_ROLLER_COASTERS = 6122,

    STR_OBJECT_LOAD_ERROR_TITLE = 6123,
    STR_OBJECT_NAME = 6124,
    STR_OBJECT_TYPE = 6125,
    STR_UNKNOWN_OBJECT_TYPE = 6126,
    STR_OBJECT_ERROR_WINDOW_FILE = 6127,
    STR_OBJECT_ERROR_WINDOW_EXPLANATION = 6128,
    STR_COPY_SELECTED = 6129,
    STR_COPY_ALL = 6130,
    STR_OBJECT_SOURCE = 6131,

    STR_CHEAT_IGNORE_RESEARCH_STATUS = 6132,
    STR_CHEAT_IGNORE_RESEARCH_STATUS_TIP = 6133,

    STR_SHORTCUT_CLEAR_SCENERY = 6134,

    STR_MULTIPLAYER_CLIENT_INVALID_REQUEST = 6135,
    STR_MULTIPLAYER_SERVER_INVALID_REQUEST = 6136,

    STR_ABOUT_OPENRCT2_DESCRIPTION = 6137,
    STR_ABOUT_OPENRCT2_DESCRIPTION_2 = 6138,
    STR_ABOUT_OPENRCT2_DESCRIPTION_3 = 6139,

    STR_CHANGELOG_ELLIPSIS = 6140,

    STR_THEMES_OPTION_RCT1_BOTTOM_TOOLBAR = 6141,

    STR_TRACK_DESIGN_NAME = 6142,
    STR_TRACK_DESIGN_TYPE = 6143,

    STR_DEBUG_PAINT_SHOW_DIRTY_VISUALS = 6144,

    STR_RIDE_CONSTRUCTION_BOOSTER_SPEED_LIMIT_TIP = 6145,

    STR_CHEAT_ENABLE_ALL_DRAWABLE_TRACK_PIECES = 6146,
    STR_CHEAT_ENABLE_ALL_DRAWABLE_TRACK_PIECES_TIP = 6147,

    STR_SERVER_LIST_CONNECTING = 6148,
    STR_SERVER_LIST_NO_CONNECTION = 6149,
    STR_SERVER_LIST_INVALID_RESPONSE_JSON_NUMBER = 6150,
    STR_SERVER_LIST_MASTER_SERVER_FAILED = 6151,
    STR_SERVER_LIST_INVALID_RESPONSE_JSON_ARRAY = 6152,

    STR_PAID_ENTRY_PAID_RIDES = 6153,

    STR_ADMIN_NOT_RECOMMENDED = 6154,
    STR_MISSING_DIALOG_APPLICATION_ERROR = 6155,

    STR_ERROR_RESERVED_NAME = 6156,

    STR_CONSOLE = 6157,

    STR_AVAILABLE_VEHICLES = 6160,

    STR_SHORTCUT_GRIDLINES_DISPLAY_TOGGLE = 6161,

    STR_SPINNING_WILD_MOUSE_GROUP = 6162,
    STR_SPINNING_WILD_MOUSE_GROUP_DESC = 6163,

    STR_CLOSE_X_WHITE = 6164,

    STR_USE_VSYNC = 6165,
    STR_USE_VSYNC_TIP = 6166,

    STR_OPTIONS_ADVANCED = 6167,
    STR_OPTIONS_TITLE_SEQUENCE = 6168,
    STR_OPTIONS_SCENARIO_SELECTION = 6169,
    STR_OPTIONS_TWEAKS = 6170,

    STR_GUESTS_FILTER_BY_NAME = 6171,
    STR_GUESTS_FILTER_BY_NAME_TIP = 6172,
    STR_GUESTS_ENTER_NAME_TO_SEARCH = 6173,

    STR_LITTER_VOMIT = 6188,
    STR_DUCK = 6189,

    STR_TILE_INSPECTOR_SURFACE = 6191,
    STR_TILE_INSPECTOR_WALL = 6192,

    STR_BOTTOM_TOOLBAR_NUM_GUESTS_STABLE_SINGULAR = 6193,
    STR_BOTTOM_TOOLBAR_NUM_GUESTS_DECREASE_SINGULAR = 6194,
    STR_BOTTOM_TOOLBAR_NUM_GUESTS_INCREASE_SINGULAR = 6195,

    STR_YEAR = 6196,
    STR_MONTH = 6197,
    STR_DAY = 6198,
    STR_DATE_SET = 6199,
    STR_DATE_RESET = 6200,
    STR_FORMAT_MONTH = 6201,

    STR_VIRTUAL_FLOOR_STYLE = 6202,
    STR_VIRTUAL_FLOOR_STYLE_TIP = 6203,

    STR_CHEAT_GROUP_CONSTRUCTION = 6215,
    STR_CHEAT_GROUP_OPERATION = 6216,
    STR_CHEAT_GROUP_AVAILABILITY = 6217,

    STR_OBJECT_FILTER_OPENRCT2_OFFICIAL = 6218,

    STR_HIGHLIGHT_PATH_ISSUES_MENU = 6219,

    STR_TILE_INSPECTOR_ENTRANCE_MAKE_USABLE = 6220,
    STR_TILE_INSPECTOR_ENTRANCE_MAKE_USABLE_TIP = 6221,

    STR_ERR_CANT_PLACE_PEEP_SPAWN_HERE = 6222,
    STR_ERR_MUST_BE_OUTSIDE_PARK_BOUNDARIES = 6223,
    STR_LOG_PLACE_PEEP_SPAWN = 6224,

    STR_NOT_SUPPPORTED_IN_OPENGL = 6225,

    STR_ALLOW_EARLY_COMPLETION = 6226,
    STR_EARLY_COMPLETION_TIP = 6227,
    STR_SCENARIO_OPTIONS = 6228,

    STR_WINDOW_COLOUR_2_STRINGID_STRINGID = 6229,
    STR_INVENTIONS_LIST_RIDE_AND_VEHICLE_NAME = 6230,
    STR_INVENTIONS_LIST_RIDE_AND_VEHICLE_NAME_DRAG = 6231,

    STR_FROZEN = 6232,

    STR_SHORTCUT_VIEW_CLIPPING = 6233,
    STR_SHORTCUT_HIGHLIGHT_PATH_ISSUES_TOGGLE = 6234,

    STR_MULTIPLAYER_INFORMATION_TITLE = 6235,
    STR_MULTIPLAYER_PLAYERS_TITLE = 6236,
    STR_MULTIPLAYER_GROUPS_TITLE = 6237,
    STR_MULTIPLAYER_OPTIONS_TITLE = 6238,

    STR_VIEW_CLIPPING_VERTICAL_CLIPPING = 6239,
    STR_VIEW_CLIPPING_HORIZONTAL_CLIPPING = 6240,
    STR_VIEW_CLIPPING_SELECT_AREA = 6241,
    STR_VIEW_CLIPPING_CLEAR_SELECTION = 6242,

    STR_REFURBISH_RIDE_TIP = 6243,
    STR_CANT_REFURBISH_RIDE = 6244,
    STR_CANT_REFURBISH_NOT_NEEDED = 6245,
    STR_REFURBISH = 6246,
    STR_REFURBISH_RIDE = 6247,
    STR_REFURBISH_RIDE_ID_MONEY = 6248,
    STR_REFURBISH_RIDE_ID_NO_MONEY = 6249,
    STR_DEMOLISH_RIDE_ID_MONEY = 6250,
    STR_RIDE_NOT_YET_EMPTY = 6251,

    STR_INVALID_URL = 6255,

    STR_EFFECTS_GROUP = 6256,
    STR_VIRTUAL_FLOOR_STYLE_GLASSY = 6257,
    STR_VIRTUAL_FLOOR_STYLE_TRANSPARENT = 6258,
    STR_VIRTUAL_FLOOR_STYLE_DISABLED = 6259,

    STR_DEBUG_PAINT_SHOW_BLOCKED_TILES = 6260,
    STR_DEBUG_PAINT_SHOW_WIDE_PATHS = 6261,

    STR_MASTER_VOLUME = 6262,
    STR_MASTER_VOLUME_TIP = 6263,

    STR_ALWAYS_NATIVE_LOADSAVE = 6264,
    STR_ALWAYS_NATIVE_LOADSAVE_TIP = 6265,

    STR_OPEN_USER_CONTENT_FOLDER = 6266,

    STR_SHORTCUT_OPEN_TILE_INSPECTOR = 6267,

    STR_ADVANCE_TO_NEXT_TICK = 6268,

    STR_INVALID_CLIMATE_ID = 6269,

    STR_OBJECT_SELECTION_TERRAIN_SURFACES = 6270,
    STR_OBJECT_SELECTION_TERRAIN_EDGES = 6271,
    STR_OBJECT_SELECTION_STATIONS = 6272,
    STR_OBJECT_SELECTION_MUSIC = 6273,

    STR_CANT_SET_COLOUR_SCHEME = 6274,

    STR_STATION_STYLE = 6275,
    STR_GUESTS_GETTING_STUCK_ON_RIDE = 6276,

    STR_TILE_INSPECTOR_STATION_INDEX = 6277,

    STR_AUTOSAVE_AMOUNT = 6278,
    STR_AUTOSAVE_AMOUNT_TIP = 6279,

    STR_TOOLBAR_CHAT_TIP = 6280,
    STR_CHAT_BUTTON_ON_TOOLBAR_TIP = 6281,
    STR_CHAT_BUTTON_ON_TOOLBAR = 6282,
    STR_CHAT_UNAVAILABLE = 6283,

    STR_SIZE_BYTE = 6293,
    STR_SIZE_KILOBYTE = 6294,
    STR_SIZE_MEGABYTE = 6295,
    STR_SIZE_GIGABYTE = 6296,
    STR_SIZE_TERABYTE = 6297,

    STR_NETWORK_SPEED_SEC = 6298,

    STR_DOWNLOAD_ALL = 6299,
    STR_DOWNLOAD_ALL_TIP = 6300,
    STR_COPY_SELECTED_TIP = 6301,
    STR_COPY_ALL_TIP = 6302,
    STR_DOWNLOADING_OBJECTS = 6303,

    STR_SHORTCUT_OPEN_SCENERY_PICKER = 6304,

    STR_MULTITHREADING = 6305,
    STR_MULTITHREADING_TIP = 6306,

    STR_TILE_INSPECTOR_COLOUR_SCHEME = 6307,
    STR_TILE_INSPECTOR_TRACK_BLOCK_BRAKE = 6319,
    STR_TILE_INSPECTOR_TRACK_IS_INDESTRUCTIBLE = 6320,
    STR_TILE_INSPECTOR_PATH_BROKEN = 6321,

    STR_MAP_TOOLTIP_BANNER_STRINGID_STRINGID = 6308,

    STR_MULTIPLAYER_RECONNECT = 6309,

    STR_PEEP_DEBUG_POSITION = 6310,
    STR_PEEP_DEBUG_NEXT = 6311,
    STR_PEEP_DEBUG_NEXT_SURFACE = 6312,
    STR_PEEP_DEBUG_NEXT_SLOPE = 6313,
    STR_PEEP_DEBUG_DEST = 6314,
    STR_PEEP_DEBUG_PATHFIND_GOAL = 6315,
    STR_PEEP_DEBUG_PATHFIND_HISTORY = 6316,
    STR_PEEP_DEBUG_PATHFIND_HISTORY_ITEM = 6317,
    STR_PEEP_DEBUG_SPRITE_INDEX = 6322,

    STR_DESYNC_REPORT = 6318,

    STR_SIMULATING = 6323,
    STR_SIMULATE_RIDE = 6324,
    STR_SIMULATE_RIDE_TIP = 6325,
    STR_CANT_SIMULATE = 6326,

    STR_TRANSPARENT_SCREENSHOT = 6327,
    STR_TRANSPARENT_SCREENSHOT_TIP = 6328,

    STR_STRING_STRINGID = 6329,
    STR_DOWNLOADING_OBJECTS_FROM = 6330,

    STR_CREATE_DUCKS = 6331,
    STR_REMOVE_DUCKS = 6332,
    STR_SHORTCUT_SCALE_UP = 6333,
    STR_SHORTCUT_SCALE_DOWN = 6334,

    STR_SHORTCUT_COPY_ELEMENT = 6336,
    STR_SHORTCUT_PASTE_ELEMENT = 6337,
    STR_SHORTCUT_REMOVE_ELEMENT = 6338,
    STR_SHORTCUT_MOVE_ELEMENT_UP = 6339,
    STR_SHORTCUT_MOVE_ELEMENT_DOWN = 6340,
    STR_SHORTCUT_INCREASE_X_COORD = 6341,
    STR_SHORTCUT_DECREASE_X_COORD = 6342,
    STR_SHORTCUT_INCREASE_Y_COORD = 6343,
    STR_SHORTCUT_DECREASE_Y_COORD = 6344,
    STR_SHORTCUT_INCREASE_ELEM_HEIGHT = 6345,
    STR_SHORTCUT_DECREASE_ELEM_HEIGHT = 6346,

    STR_CANNOT_BUILD_PATH_ADDITIONS_ON_LEVEL_CROSSINGS = 6347,
    STR_REMOVE_LEVEL_CROSSING_FIRST = 6348,

    STR_OPTIONS_RANDOM_TITLE_SEQUENCE = 6349,

    STR_SCENERY_SCATTER = 6350,
    STR_THEMES_WINDOW_SCENERY_SCATTER = 6351,
    STR_SCATTER_TOOL_DENSITY = 6352,
    STR_SCATTER_TOOL_DENSITY_LOW = 6353,
    STR_SCATTER_TOOL_DENSITY_MEDIUM = 6354,
    STR_SCATTER_TOOL_DENSITY_HIGH = 6355,

    STR_CREATE_DUCKS_TIP = 6356,
    STR_REMOVE_DUCKS_TIP = 6357,

    STR_PAGE_X = 6358,
    STR_ARG_4_PAGE_X = 6359,

    STR_GRAPH_AXIS_LABEL = 6360,

    STR_ENABLE_LIGHTING_VEHICLES = 6361,
    STR_ENABLE_LIGHTING_VEHICLES_TIP = 6362,

    STR_COPY_INPUT_TO_CLIPBOARD = 6363,

    STR_X_PERSON_DIED_ON_X = 6364,

    STR_NOTIFICATION_RIDE_CASUALTIES = 6365,
    STR_NOTIFICATION_RIDE_VEHICLE_STALLED = 6366,

    STR_TILE_INSPECTOR_WALL_ANIMATION_FRAME = 6367,

    STR_WINE_NOT_RECOMMENDED = 6368,
    STR_CHEAT_ALLOW_TRACK_PLACE_INVALID_HEIGHTS = 6369,
    STR_CHEAT_ALLOW_TRACK_PLACE_INVALID_HEIGHTS_TIP = 6370,

    STR_PATH_TO_RCT1_DOES_NOT_CONTAIN_CSG1I_DAT = 6371,
    STR_PATH_TO_RCT1_IS_WRONG_VERSION = 6372,

    STR_SHORTCUT_TOGGLE_CLEARANCE_CHECKS = 6373,
    STR_OVERLAY_CLEARANCE_CHECKS_DISABLED = 6374,

    STR_UNKNOWN_RIDE = 6375,

    STR_RESEARCH_VEHICLE_LABEL = 6376,
    STR_RESEARCH_TYPE_LABEL_VEHICLE = 6377,

    STR_MULTIPLAYER_RECEIVING_OBJECTS_LIST = 6378,

    STR_MULTIPLAYER_RECEIVED_INVALID_DATA = 6379,

    STR_UPDATE_AVAILABLE = 6380,
    STR_JOIN_DISCORD = 6381,
    STR_NEW_RELEASE_VERSION_INFO = 6382,
    STR_NEW_RELEASE_DOWNLOAD_PAGE = 6383,

    STR_SNOW = 6384,
    STR_HEAVY_SNOW = 6385,
    STR_BLIZZARD = 6386,

    STR_CANT_LOWER_ELEMENT_HERE = 6387,
    STR_CANT_RAISE_ELEMENT_HERE = 6388,
    STR_NO_CLEARANCE = 6389,

    STR_NEEDS_RCT2_FILES = 6390,
    STR_PICK_RCT2_DIR = 6391,
    STR_COULD_NOT_FIND_AT_PATH = 6392,

    STR_CHEATS_MENU_OBJECTIVE_OPTIONS = 6393,
    STR_CHEAT_OBJECTIVE_GROUP = 6394,
    STR_CHEAT_MAINTENANCE_GROUP = 6395,

    STR_DISABLE_SCREENSAVER = 6396,
    STR_DISABLE_SCREENSAVER_TIP = 6397,

    STR_FILE_CONTAINS_UNSUPPORTED_RIDE_TYPES = 6398,

    STR_NEEDS_RCT2_FILES_MANUAL = 6399,

    STR_OWN_ON_GOG = 6400,
    STR_INSTALLED_ON_HDD = 6401,
    STR_OPENRCT2_SETUP = 6402,
    STR_WHICH_APPLIES_BEST = 6403,
    STR_PLEASE_SELECT_GOG_INSTALLER = 6404,
    STR_SELECT_GOG_INSTALLER = 6405,
    STR_GOG_INSTALLER = 6406,
    STR_THIS_WILL_TAKE_A_FEW_MINUTES = 6407,
    STR_INSTALL_INNOEXTRACT = 6408,
    STR_NOT_THE_GOG_INSTALLER = 6409,

    STR_ZOOM_BUTTON_ON_TOOLBAR = 6410,
    STR_ZOOM_BUTTON_ON_TOOLBAR_TIP = 6411,

    STR_SHORTCUT_NUMPAD_RETURN = 6412,

    STR_SHORTCUT_MOD_SHIFT = 6413,
    STR_SHORTCUT_MOD_LSHIFT = 6414,
    STR_SHORTCUT_MOD_RSHIFT = 6415,
    STR_SHORTCUT_MOD_CTRL = 6416,
    STR_SHORTCUT_MOD_LCTRL = 6417,
    STR_SHORTCUT_MOD_RCTRL = 6418,
    STR_SHORTCUT_MOD_ALT = 6419,
    STR_SHORTCUT_MOD_LALT = 6420,
    STR_SHORTCUT_MOD_RALT = 6421,
    STR_SHORTCUT_MOD_GUI = 6422,
    STR_SHORTCUT_MOD_LGUI = 6423,
    STR_SHORTCUT_MOD_RGUI = 6424,

    STR_SHORTCUT_JOY_LEFT = 6425,
    STR_SHORTCUT_JOY_RIGHT = 6426,
    STR_SHORTCUT_JOY_UP = 6427,
    STR_SHORTCUT_JOY_DOWN = 6428,
    STR_SHORTCUT_JOY_NUMBER = 6429,

    STR_SHORTCUT_MOUSE_LEFT = 6430,
    STR_SHORTCUT_MOUSE_RIGHT = 6431,
    STR_SHORTCUT_MOUSE_NUMBER = 6432,

    STR_SHORTCUT_REMOVE = 6433,
    STR_SHORTCUT_REMOVE_TIP = 6434,

    STR_STAFF_STAT_VANDALS_STOPPED = 6435,

    STR_TILE_INSPECTOR_TOGGLE_INVISIBILITY_TIP = 6436,
    STR_TILE_INSPECTOR_FLAG_INVISIBLE = 6437,
    STR_TILE_INSPECTOR_INVISIBLE_SHORT = 6438,
    STR_SHORTCUT_TOGGLE_INVISIBILITY = 6439,

    STR_VIEWPORT_TRANSPARENT_WATER = 6440,

    STR_AT_LEAST_ONE_FOOTPATH_NON_QUEUE_SURFACE_OBJECT_MUST_BE_SELECTED = 6441,
    STR_AT_LEAST_ONE_FOOTPATH_QUEUE_SURFACE_OBJECT_MUST_BE_SELECTED = 6442,
    STR_AT_LEAST_ONE_FOOTPATH_RAILING_OBJECT_MUST_BE_SELECTED = 6443,
    STR_OBJECT_SELECTION_FOOTPATH_SURFACES = 6444,
    STR_OBJECT_SELECTION_FOOTPATH_RAILINGS = 6445,
    STR_TILE_INSPECTOR_FOOTPATH_SURFACE_NAME = 6446,
    STR_TILE_INSPECTOR_FOOTPATH_RAILINGS_NAME = 6447,

    STR_UNSUPPORTED_OBJECT_FORMAT = 6448,

    STR_MUSIC_OBJECT_TRACK_HEADER = 6449,
    STR_MUSIC_OBJECT_TRACK_LIST_ITEM = 6450,
    STR_MUSIC_OBJECT_TRACK_LIST_ITEM_WITH_COMPOSER = 6451,

    STR_RIDE_OBJECT_SHOP_SELLS = 6452,

    STR_COPY_BUILD_HASH = 6453,

    STR_CANT_RENAME_BANNER = 6454,
    STR_CANT_RENAME_SIGN = 6455,

    STR_SHORTCUT_GIANT_SCREENSHOT = 6456,

    STR_FILE_BUG_ON_GITHUB = 6457,

    STR_FOLLOW_SUBJECT_TIP = 6458,

    STR_TILE_INSPECTOR_DIRECTION_SHORT = 6460,
    STR_TILE_INSPECTOR_DIRECTION = 6461,

    STR_RIDE_LIST_EXCITEMENT = 6462,
    STR_EXCITEMENT_LABEL = 6463,
    STR_RIDE_LIST_INTENSITY = 6464,
    STR_INTENSITY_LABEL = 6465,
    STR_RIDE_LIST_NAUSEA = 6466,
    STR_NAUSEA_LABEL = 6467,
    STR_RATING_UKNOWN_LABEL = 6468,

    STR_ADJUST_SMALLER_PATROL_AREA_TIP = 6469,
    STR_ADJUST_LARGER_PATROL_AREA_TIP = 6470,

    STR_SEE_THROUGH_VEGETATION = 6471,
    STR_SEE_THROUGH_VEHICLES = 6472,
    STR_SEE_THROUGH_SUPPORTS = 6473,
    STR_SEE_THROUGH_GUESTS = 6474,
    STR_SEE_THROUGH_STAFF = 6475,
    STR_INVISIBLE_VEGETATION = 6476,
    STR_INVISIBLE_SCENERY = 6477,
    STR_INVISIBLE_PATHS = 6478,
    STR_INVISIBLE_RIDES = 6479,
    STR_INVISIBLE_VEHICLES = 6480,
    STR_TRANSPARENCY_OPTIONS = 6481,
    STR_TRANSPARENCY_OPTIONS_TITLE = 6482,
    STR_SHORTCUT_OPEN_TRANSPARENCY_OPTIONS = 6483,
    STR_SHORTCUT_SEE_THROUGH_VEGETATION_TOGGLE = 6484,
    STR_SHORTCUT_SEE_THROUGH_VEHICLES_TOGGLE = 6485,
    STR_SHORTCUT_SEE_THROUGH_GUESTS_TOGGLE = 6486,
    STR_SHORTCUT_SEE_THROUGH_STAFF_TOGGLE = 6487,

    STR_PEEPS_COMPLAINING_ABOUT_QUEUE_LENGTH_WARNING = 6488,

    STR_ERROR_PARK_VERSION_TITLE = 6489,
    STR_WARNING_PARK_VERSION_TITLE = 6490,
    STR_ERROR_PARK_VERSION_TOO_NEW_MESSAGE = 6491,
    STR_ERROR_PARK_VERSION_TOO_OLD_MESSAGE = 6492,
    STR_WARNING_PARK_VERSION_MESSAGE = 6493,

    STR_GROUP_BY_TRACK_TYPE = 6494,
    STR_GROUP_BY_TRACK_TYPE_TIP = 6495,
    STR_NEW_RIDE_VEHICLE_NAME = 6496,

    STR_TILE_INSPECTOR_SELECT_TILE_HINT = 6497,

    STR_MAINTAIN_SQUARE_MAP_TOOLTIP = 6498,

    STR_VEHICLE_UNSUPPORTED_TD6 = 6499,
    STR_TRACK_ELEM_UNSUPPORTED_TD6 = 6500,

    STR_RANDOM_COLOUR = 6501,

    STR_ENTER_VALUE = 6502,

    STR_AT_LEAST_ONE_STATION_OBJECT_MUST_BE_SELECTED = 6503,
    STR_AT_LEAST_ONE_TERRAIN_SURFACE_OBJECT_MUST_BE_SELECTED = 6504,
    STR_AT_LEAST_ONE_TERRAIN_EDGE_OBJECT_MUST_BE_SELECTED = 6505,

    STR_LARGE_HALF_CORKSCREW_LEFT = 6506,
    STR_LARGE_HALF_CORKSCREW_RIGHT = 6507,
    STR_MEDIUM_HALF_LOOP_LEFT = 6508,
    STR_MEDIUM_HALF_LOOP_RIGHT = 6509,
    STR_ZERO_G_ROLL_LEFT = 6510,
    STR_ZERO_G_ROLL_RIGHT = 6511,
    STR_LARGE_ZERO_G_ROLL_LEFT = 6512,
    STR_LARGE_ZERO_G_ROLL_RIGHT = 6513,

    STR_INVALID_HEIGHT = 6514,

    STR_OBJECT_USES_FALLBACK_IMAGES = 6515,
    STR_OBJECT_SELECTION_FALLBACK_IMAGES_WARNING = 6516,
    STR_PARK_USES_FALLBACK_IMAGES_WARNING = 6517,

    STR_SCENARIO_HOVER_HINT = 6518,

    STR_SCENARIO_CATEGORY_EXTRAS_PARKS = 6519,

    STR_ASSET_PACKS = 6520,
    STR_LOW_PRIORITY = 6521,
    STR_HIGH_PRIORITY = 6522,
    STR_DECREASE_PRIOTITY_TIP = 6523,
    STR_INCREASE_PRIOTITY_TIP = 6524,
    STR_RELOAD_ASSET_PACKS_TIP = 6525,
    STR_BASE_GRAPHICS_MUSIC_SOUND = 6526,

    STR_COMPETITIONS = 6527,

    STR_INVALID_TRACK_PARAMETERS = 6528,
    STR_INVALID_COLOUR_SCHEME_PARAMETER = 6529,

    STR_SCENARIO_CATEGORY_UCES = 6530,
    STR_UCES_TM = 6531,
    STR_UCES_KD = 6532,

    STR_EXCITEMENT_FACTOR_NEGATIVE = 6533,
    STR_INTENSITY_FACTOR_NEGATIVE = 6534,
    STR_NAUSEA_FACTOR_NEGATIVE = 6535,

    STR_ERROR_PARK_VERSION_TOO_NEW_MESSAGE_2 = 6536,

    // Have to include resource strings (from scenarios and objects) for the time being now that language is partially working
    /* MAX_STR_COUNT = 32768 */ // MAX_STR_COUNT - upper limit for number of strings, not the current count strings
};
