<?php
  /**************************************************************************\
  * eGroupWare - Setup                                                       *
  * http://www.egroupware.org                                                *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: ldapmodify.php 20295 2006-02-15 12:31:25Z  $ */

	$GLOBALS['egw_info'] = array(
		'flags' => array(
			'noheader'   => True,
			'nonavbar'   => True,
			'currentapp' => 'home',
			'noapi'      => True
	));
	include('./inc/functions.inc.php');

	/* Authorize the user to use setup app and load the database */
	if(!$GLOBALS['egw_setup']->auth('Config'))
	{
		Header('Location: index.php');
		exit;
	}
	/* Does not return unless user is authorized */

	class egw
	{
		var $common;
		var $accounts;
		var $applications;
		var $db;
	}
	$GLOBALS['egw'] = new egw;
	$GLOBALS['egw']->common = CreateObject('phpgwapi.common');

	$common = $GLOBALS['egw']->common;
	$GLOBALS['egw_setup']->loaddb();
	$GLOBALS['egw']->db = clone($GLOBALS['egw_setup']->db);

	$tpl_root = $GLOBALS['egw_setup']->html->setup_tpl_dir('setup');
	$setup_tpl = CreateObject('setup.Template',$tpl_root);
	$setup_tpl->set_file(array(
		'ldap'   => 'ldap.tpl',
		'T_head' => 'head.tpl',
		'T_footer' => 'footer.tpl',
		'T_alert_msg' => 'msg_alert_msg.tpl'
	));

	$GLOBALS['egw_setup']->db->select($GLOBALS['egw_setup']->config_table,'config_name,config_value',array(
		"config_name LIKE 'ldap%' OR config_name='account_repository'",
	),__LINE__,__FILE__);
	while($GLOBALS['egw_setup']->db->next_record())
	{
		$config[$GLOBALS['egw_setup']->db->f('config_name')] = $GLOBALS['egw_setup']->db->f('config_value');
	}
	$GLOBALS['egw_info']['server']['ldap_host']          = $config['ldap_host'];
	$GLOBALS['egw_info']['server']['ldap_context']       = $config['ldap_context'];
	$GLOBALS['egw_info']['server']['ldap_group_context'] = $config['ldap_group_context'];
	$GLOBALS['egw_info']['server']['ldap_root_dn']       = $config['ldap_root_dn'];
	$GLOBALS['egw_info']['server']['ldap_root_pw']       = $config['ldap_root_pw'];
	$GLOBALS['egw_info']['server']['account_repository'] = $config['account_repository'];
	$GLOBALS['egw_info']['server']['ldap_version3']      = $config['ldap_version3'];

	$GLOBALS['egw']->accounts = CreateObject('phpgwapi.accounts');
	$acct            = $GLOBALS['egw']->accounts;

	/* connect to ldap server */
	if(!$ldap = $common->ldapConnect())
	{
		$noldapconnection = True;
	}

	if($noldapconnection)
	{
		Header('Location: config.php?error=badldapconnection');
		exit;
	}

	$sr = ldap_search($ldap,$config['ldap_context'],'(|(uid=*))',array('cn','givenname','uid','uidnumber'));
	$info = ldap_get_entries($ldap, $sr);
	$tmp = '';

	for($i=0; $i<$info['count']; $i++)
	{
		if(!$GLOBALS['egw_info']['server']['global_denied_users'][$info[$i]['uid'][0]])
		{
			$account_info[$info[$i]['uidnumber'][0]] = $info[$i];
		}
	}

	if($GLOBALS['egw_info']['server']['ldap_group_context'])
	{
		$srg = ldap_search($ldap,$config['ldap_group_context'],'(|(cn=*))',array('gidnumber','cn','memberuid'));
		$info = ldap_get_entries($ldap, $srg);
		$tmp = '';

		for($i=0; $i<$info['count']; $i++)
		{
			if(!$GLOBALS['egw_info']['server']['global_denied_groups'][$info[$i]['cn'][0]] &&
				!$account_info[$i][$info[$i]['cn'][0]])
			{
				$group_info[-$info[$i]['gidnumber'][0]] = $info[$i];
			}
		}
	}
	else
	{
		$group_info = array();
	}

	$GLOBALS['egw_setup']->db->select($GLOBALS['egw_setup']->applications_table,'app_name','app_enabled != 0 AND app_enabled != 3',__LINE__,__FILE__);
	while($GLOBALS['egw_setup']->db->next_record())
	{
		$apps[$GLOBALS['egw_setup']->db->f('app_name')] = lang($GLOBALS['egw_setup']->db->f('app_name'));
	}

	if($cancel)
	{
		Header("Location: ldap.php");
		exit;
	}

	$GLOBALS['egw_setup']->html->show_header(lang('LDAP Modify'),False,'config',$GLOBALS['egw_setup']->ConfigDomain . '(' . $GLOBALS['egw_domain'][$GLOBALS['egw_setup']->ConfigDomain]['db_type'] . ')');
	$setup_complete = False;
	if(isset($_POST['submit']))
	{
		$acl = CreateObject('phpgwapi.acl');
		if(isset($_POST['ldapgroups']))
		{
			$groups = CreateObject('phpgwapi.accounts');
			while(list($key,$groupid) = each($_POST['ldapgroups']))
			{
				$id_exist = 0;
				$entry = array();
				$thisacctid    = $group_info[$groupid]['gidnumber'][0];
				$thisacctlid   = $group_info[$groupid]['cn'][0];
				/* echo "Updating GROUPID : ".$thisacctlid."<br />\n"; */
				$thisfirstname = $group_info[$groupid]['cn'][0];
				$thismembers   = $group_info[$groupid]['memberuid'];
				$thisdn        = $group_info[$groupid]['dn'];

				/* Do some checks before we try to import the data. */
				if(!empty($thisacctid) && !empty($thisacctlid))
				{
					$groups->account_id = (int)$thisacctid;

					$sr = ldap_search($ldap,$config['ldap_group_context'],'cn='.$thisacctlid);
					$entry = ldap_get_entries($ldap, $sr);

					reset($entry[0]['objectclass']);
					$addclass = True;
					while(list($key,$value) = each($entry[0]['objectclass']))
					{
						if(strtolower($value) == 'phpgwaccount')
						{
							$addclass = False;
						}
					}
					if($addclass)
					{
						reset($entry[0]['objectclass']);
						$replace['objectclass'] = $entry[0]['objectclass'];
						unset($replace['objectclass']['count']);
						$replace['objectclass'][]       = 'phpgwAccount';
						sort($replace['objectclass']);
						ldap_mod_replace($ldap,$thisdn,$replace);
						unset($replace);
						unset($addclass);
					}
					unset($add);
					if(!@isset($entry[0]['phpgwaccountstatus']))
					{
						$add['phpgwaccountstatus'][] = 'A';
					}
					if(!@isset($entry[0]['phpgwaccounttype']))
					{
						$add['phpgwaccounttype'][] = 'g';
					}
					if(!@isset($entry[0]['phpgwaccountexpires']))
					{
						$add['phpgwaccountexpires'][] = -1;
					}
					if(@isset($add))
					{
						ldap_mod_add($ldap,$thisdn,$add);
					}

					/* Now make the members a member of this group in phpgw. */
					if(is_array($thismembers))
					{
						foreach($thismembers as $key => $members)
						{
							if($key == 'count')
							{
								continue;
							}
							/* echo '<br />members: ' . $members; */
							$tmpid = 0;
							@reset($account_info);
							while(list($x,$y) = each($account_info))
							{
								/* echo '<br />checking: '.$y['account_lid']; */
								if($members == $y['account_lid'])
								{
									$tmpid = $y['account_id'];
								}
							}
							// Insert acls for this group based on memberuid field.
							// Since the group has app rights, we don't need to give users
							//  these rights.  Instead, we maintain group membership here.
							if($tmpid)
							{
								$acl->account_id = (int)$tmpid;
								$acl->read_repository();
	
								$acl->delete('phpgw_group',$thisacctid,1);
								$acl->add('phpgw_group',$thisacctid,1);
	
								// Now add the acl to let them change their password
								$acl->delete('preferences','changepassword',1);
								$acl->add('preferences','changepassword',1);
	
								$acl->save_repository();
							}
						}
					}
					/* Now give this group some rights */
					$GLOBALS['egw_info']['user']['account_id'] = $thisacctid;
					$acl->account_id = (int)$thisacctid;
					$acl->read_repository();
					@reset($_POST['s_apps']);
					while(list($key,$app) = @each($_POST['s_apps']))
					{
						$acl->delete($app,'run',1);
						$acl->add($app,'run',1);
					}
					$acl->save_repository();
					$defaultgroupid = $thisacctid;
				}
			}
		}

		if(isset($_POST['users']))
		{
			$accounts = CreateObject('phpgwapi.accounts');
			while(list($key,$id) = each($_POST['users']))
			{
				$id_exist = 0;
				$thisacctid  = $account_info[$id]['uidnumber'][0];
				$thisacctlid = $account_info[$id]['uid'][0];
				/* echo "Updating USERID : ".$thisacctlid."<br />\n"; */
				$thisdn      = $account_info[$id]['dn'];

				/* Do some checks before we try to import the data. */
				if(!empty($thisacctid) && !empty($thisacctlid))
				{
					$accounts->account_id = (int)$thisacctid;
					$sr = ldap_search($ldap,$config['ldap_context'],'uid='.$thisacctlid);
					$entry = ldap_get_entries($ldap, $sr);
					reset($entry[0]['objectclass']);
					$addclass = True;
					while(list($key,$value) = each($entry[0]['objectclass']))
					{
						if(strtolower($value) == 'phpgwaccount')
						{
							$addclass = False;
						}
					}
					if($addclass)
					{
						reset($entry[0]['objectclass']);
						$replace['objectclass'] = $entry[0]['objectclass'];
						unset($replace['objectclass']['count']);
						$replace['objectclass'][]       = 'phpgwAccount';
						sort($replace['objectclass']);
						ldap_mod_replace($ldap,$thisdn,$replace);
						unset($replace);
						unset($addclass);
					}
					unset($add);
					if(!@isset($entry[0]['phpgwaccountstatus']))
					{
						$add['phpgwaccountstatus'][] = 'A';
					}
					if(!@isset($entry[0]['phpgwaccounttype']))
					{
						$add['phpgwaccounttype'][] = 'u';
					}
					if(!@isset($entry[0]['phpgwaccountexpires']))
					{
						$add['phpgwaccountexpires'][] = -1;
					}
					if(@isset($add))
					{
						ldap_mod_add($ldap,$thisdn,$add);
					}

					/*
					Insert default acls for this user.
					Since the group has app rights, we don't need to give users
					these rights.
					*/
					$acl->account_id = (int)$thisacctid;
					$acl->read_repository();

					/*
					However, if no groups were imported, we do need to give each user
					apps access
					*/
					if(empty($_POST['ldapgroups']))
					{
						@reset($_POST['s_apps']);
						while(list($key,$app) = @each($_POST['s_apps']))
						{
							$acl->delete($app,'run',1);
							$acl->add($app,'run',1);
						}
					}
					// Now add the acl to let them change their password
					$acl->delete('preferences','changepassword',1);
					$acl->add('preferences','changepassword',1);

					/*
					Only give them admin if we asked for them to have it.
					This is typically an exception to apps for run rights
					as a group member.
					*/
					for($a=0;$a<=count($_POST['admins']);$a++)
					{
						if($_POST['admins'][$a] == $thisacctid)
						{
							$acl->delete('admin','run',1);
							$acl->add('admin','run',1);
						}
					}
					/* Save these new acls. */
					$acl->save_repository();
				}
			}
		}
		$setup_complete = True;
	}

	if(isset($_GET['error']))
	{
		/* echo '<br /><center><b>Error:</b> '.$error.'</center>'; */
		$GLOBALS['egw_setup']->html->show_alert_msg('Error',$_GET['error']);
	}

	if($setup_complete)
	{
		echo '<br /><center>'.lang('Modifications have been completed!').' '.lang('Click <a href="index.php">here</a> to return to setup.').'<br /><center>';
		$GLOBALS['egw_setup']->html->show_footer();
		exit;
	}

	$setup_tpl->set_block('ldap','header','header');
	$setup_tpl->set_block('ldap','user_list','user_list');
	$setup_tpl->set_block('ldap','admin_list','admin_list');
	$setup_tpl->set_block('ldap','group_list','group_list');
	$setup_tpl->set_block('ldap','app_list','app_list');
	$setup_tpl->set_block('ldap','submit','submit');
	$setup_tpl->set_block('ldap','footer','footer');

	$user_list = '';
	while(list($key,$account) = @each($account_info))
	{
		$user_list .= '<option value="' . $account['uidnumber'][0] . '">' . utf8_decode($account['cn'][0]) . ' (' . $account['uid'][0] . ')</option>';
	}

	$admin_list = '';
	@reset($account_info);
	while (list($key,$account) = @each($account_info))
	{
		$admin_list .= '<option value="' . $account['uidnumber'][0] . '">' . utf8_decode($account['cn'][0]) . ' (' . $account['uid'][0] . ')</option>';
	}

	$group_list = '';
	while(list($key,$group) = @each($group_info))
	{
		$group_list .= '<option value="' . $group['gidnumber'][0] . '">' . utf8_decode($group['cn'][0])  . '</option>';
	}

	$app_list = '';
	while(list($appname,$apptitle) = each($apps))
	{
		if($appname == 'admin' ||
			$appname == 'skel' ||
			$appname == 'backup' ||
			$appname == 'netsaint' ||
			$appname == 'developer_tools' ||
			$appname == 'phpsysinfo' ||
			$appname == 'eldaptir' ||
			$appname == 'qmailldap')
		{
			$app_list .= '<option value="' . $appname . '">' . $apptitle . '</option>';
		}
		else
		{
			$app_list .= '<option value="' . $appname . '" selected>' . $apptitle . '</option>';
		}
	}

	$setup_tpl->set_var('action_url','ldapmodify.php');
	$setup_tpl->set_var('users',$user_list);
	$setup_tpl->set_var('admins',$admin_list);
	$setup_tpl->set_var('ldapgroups',$group_list);
	$setup_tpl->set_var('s_apps',$app_list);

	$setup_tpl->set_var('ldap_import',lang('LDAP Modify'));
	$setup_tpl->set_var('description',lang("This section will help you setup your LDAP accounts for use with eGroupWare").'.');
	$setup_tpl->set_var('select_users',lang('Select which user(s) will be modified'));
	$setup_tpl->set_var('select_admins',lang('Select which user(s) will also have admin privileges'));
	$setup_tpl->set_var('select_groups',lang('Select which group(s) will be modified (group membership will be maintained)'));
	$setup_tpl->set_var('select_apps',lang('Select the default applications to which your users will have access').'.');
	$setup_tpl->set_var('form_submit',lang('Modify'));
	$setup_tpl->set_var('cancel',lang('Cancel'));

	$setup_tpl->pfp('out','header');
	$setup_tpl->pfp('out','user_list');
	$setup_tpl->pfp('out','admin_list');
	$setup_tpl->pfp('out','group_list');
	$setup_tpl->pfp('out','app_list');
	$setup_tpl->pfp('out','submit');
	$setup_tpl->pfp('out','footer');

	$GLOBALS['egw_setup']->html->show_footer();
?>
