/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.NOTIFYICONDATA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    int id;
    Image image2;
    String toolTipText;
    boolean visible = true;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        tray.createItem(this, tray.getItemCount());
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void createWidget() {
        if (OS.IsWinCE) {
            return;
        }
        NOTIFYICONDATA nOTIFYICONDATA = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        nOTIFYICONDATA.cbSize = NOTIFYICONDATA.sizeof;
        this.id = this.display.nextTrayId++;
        nOTIFYICONDATA.uID = this.id;
        nOTIFYICONDATA.hWnd = this.display.hwndMessage;
        nOTIFYICONDATA.uFlags = 1;
        nOTIFYICONDATA.uCallbackMessage = 32773;
        OS.Shell_NotifyIcon(0, nOTIFYICONDATA);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    int messageProc(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 513: {
                if (!this.hooks(13)) break;
                OS.SetForegroundWindow(n);
                this.postEvent(13);
                break;
            }
            case 515: 
            case 518: {
                if (!this.hooks(14)) break;
                OS.SetForegroundWindow(n);
                this.postEvent(14);
                break;
            }
            case 517: {
                if (!this.hooks(35)) break;
                OS.SetForegroundWindow(n);
                this.sendEvent(35);
                if (!this.isDisposed()) break;
                return 0;
            }
        }
        this.display.wakeThread();
        return 0;
    }

    void recreate() {
        this.createWidget();
        if (!this.visible) {
            this.setVisible(false);
        }
        if (this.text.length() != 0) {
            this.setText(this.text);
        }
        if (this.image != null) {
            this.setImage(this.image);
        }
        if (this.toolTipText != null) {
            this.setToolTipText(this.toolTipText);
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        this.toolTipText = null;
        if (OS.IsWinCE) {
            return;
        }
        NOTIFYICONDATA nOTIFYICONDATA = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        nOTIFYICONDATA.cbSize = NOTIFYICONDATA.sizeof;
        nOTIFYICONDATA.uID = this.id;
        nOTIFYICONDATA.hWnd = this.display.hwndMessage;
        OS.Shell_NotifyIcon(2, nOTIFYICONDATA);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setImage(Image image) {
        Object object;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            return;
        }
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        int n = 0;
        Image image2 = image;
        if (image2 != null) {
            switch (image2.type) {
                case 0: {
                    object = image2.getImageData();
                    ImageData imageData = ((ImageData)object).getTransparencyMask();
                    this.image2 = new Image((Device)this.display, (ImageData)object, imageData);
                    n = this.image2.handle;
                    break;
                }
                case 1: {
                    n = image2.handle;
                }
            }
        }
        object = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        ((NOTIFYICONDATA)object).cbSize = NOTIFYICONDATA.sizeof;
        ((NOTIFYICONDATA)object).uID = this.id;
        ((NOTIFYICONDATA)object).hWnd = this.display.hwndMessage;
        ((NOTIFYICONDATA)object).hIcon = n;
        ((NOTIFYICONDATA)object).uFlags = 2;
        OS.Shell_NotifyIcon(1, (NOTIFYICONDATA)object);
    }

    public void setToolTipText(String string) {
        int n;
        this.checkWidget();
        this.toolTipText = string;
        if (OS.IsWinCE) {
            return;
        }
        NOTIFYICONDATA nOTIFYICONDATA = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
        TCHAR tCHAR = new TCHAR(0, this.toolTipText == null ? "" : this.toolTipText, true);
        int n2 = n = OS.SHELL32_MAJOR < 5 ? 64 : 128;
        if (OS.IsUnicode) {
            char[] cArray = nOTIFYICONDATA.szTip;
            n = Math.min(n - 1, tCHAR.length());
            System.arraycopy(tCHAR.chars, 0, cArray, 0, n);
        } else {
            byte[] byArray = ((NOTIFYICONDATAA)nOTIFYICONDATA).szTip;
            n = Math.min(n - 1, tCHAR.length());
            System.arraycopy(tCHAR.bytes, 0, byArray, 0, n);
        }
        nOTIFYICONDATA.cbSize = NOTIFYICONDATA.sizeof;
        nOTIFYICONDATA.uID = this.id;
        nOTIFYICONDATA.hWnd = this.display.hwndMessage;
        nOTIFYICONDATA.uFlags = 4;
        OS.Shell_NotifyIcon(1, nOTIFYICONDATA);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.visible == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = bl;
        if (!OS.IsWinCE) {
            NOTIFYICONDATA nOTIFYICONDATA = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
            nOTIFYICONDATA.cbSize = NOTIFYICONDATA.sizeof;
            nOTIFYICONDATA.uID = this.id;
            nOTIFYICONDATA.hWnd = this.display.hwndMessage;
            if (OS.SHELL32_MAJOR < 5) {
                if (bl) {
                    nOTIFYICONDATA.uFlags = 1;
                    nOTIFYICONDATA.uCallbackMessage = 32773;
                    OS.Shell_NotifyIcon(0, nOTIFYICONDATA);
                    this.setImage(this.image);
                    this.setToolTipText(this.toolTipText);
                } else {
                    OS.Shell_NotifyIcon(2, nOTIFYICONDATA);
                }
            } else {
                nOTIFYICONDATA.uFlags = 8;
                nOTIFYICONDATA.dwState = bl ? 0 : 1;
                nOTIFYICONDATA.dwStateMask = 1;
                OS.Shell_NotifyIcon(1, nOTIFYICONDATA);
            }
        }
        if (!bl) {
            this.sendEvent(23);
        }
    }
}

