/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NMLVFINDITEM;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    ImageList imageList;
    int lastIndexOf;
    int lastWidth;
    boolean fixScrollWidth;
    boolean ignoreSelect;
    boolean dragStarted;
    boolean ignoreRedraw;
    boolean mouseDown;
    boolean customDraw;
    boolean ignoreShrink;
    static final int TableProc;
    static final TCHAR TableClass;

    static {
        TableClass = new TCHAR(0, "SysListView32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TableClass, wNDCLASS);
        TableProc = wNDCLASS.lpfnWndProc;
    }

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    TableItem _getItem(int n) {
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, -1, false);
        return this.items[n];
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TableProc, this.handle, n, n2, n3);
    }

    static int checkStyle(int n) {
        return Widget.checkBits(n |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.clear();
            if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 17;
                lVITEM.pszText = -1;
                lVITEM.iItem = n;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                tableItem.cached = false;
            }
            if (!this.ignoreRedraw && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, n, n);
            }
            this.setScrollWidth(tableItem, false);
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        if (n == 0 && n2 == n3 - 1) {
            this.clearAll();
        } else {
            LVITEM lVITEM = null;
            boolean bl = false;
            int n4 = n;
            while (n4 <= n2) {
                TableItem tableItem = this.items[n4];
                if (tableItem != null) {
                    bl = true;
                    tableItem.clear();
                    if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                        if (lVITEM == null) {
                            lVITEM = new LVITEM();
                            lVITEM.mask = 17;
                            lVITEM.pszText = -1;
                        }
                        lVITEM.iItem = n4;
                        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                        tableItem.cached = false;
                    }
                }
                ++n4;
            }
            if (bl) {
                if (!this.ignoreRedraw && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, n, n2);
                }
                TableItem tableItem = n == n2 ? this.items[n] : null;
                this.setScrollWidth(tableItem, false);
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = OS.SendMessage(this.handle, 4100, 0, 0);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0 || nArray[n2] >= n) {
                this.error(6);
            }
            ++n2;
        }
        LVITEM lVITEM = null;
        boolean bl = false;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            TableItem tableItem = this.items[n4];
            if (tableItem != null) {
                bl = true;
                tableItem.clear();
                if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                    if (lVITEM == null) {
                        lVITEM = new LVITEM();
                        lVITEM.mask = 17;
                        lVITEM.pszText = -1;
                    }
                    lVITEM.iItem = n3;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                    tableItem.cached = false;
                }
                if (!this.ignoreRedraw && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, n4, n4);
                }
            }
            ++n3;
        }
        if (bl) {
            this.setScrollWidth(null, false);
        }
    }

    public void clearAll() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4100, 0, 0);
        LVITEM lVITEM = null;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = this.items[n2];
            if (tableItem != null) {
                tableItem.clear();
                if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                    if (lVITEM == null) {
                        lVITEM = new LVITEM();
                        lVITEM.mask = 17;
                        lVITEM.pszText = -1;
                    }
                    lVITEM.iItem = n2;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                    tableItem.cached = false;
                }
            }
            ++n2;
        }
        if (bl) {
            if (!this.ignoreRedraw && this.drawCount == 0 && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, 0, n - 1);
            }
            this.setScrollWidth(null, false);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.checkWidget();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        int n7 = 0;
        if (n != -1) {
            n7 |= n & 0xFFFF;
        } else {
            n6 = 0;
            n5 = OS.SendMessage(this.handle, 4127, 0, 0);
            n4 = OS.SendMessage(n5, 4608, 0, 0);
            n3 = 0;
            while (n3 < n4) {
                n6 += OS.SendMessage(this.handle, 4125, n3, 0);
                ++n3;
            }
            n7 |= n6 & 0xFFFF;
        }
        if (n2 != -1) {
            n7 |= n2 << 16;
        }
        n6 = OS.SendMessage(this.handle, 4160, -1, n7);
        n5 = n6 & 0xFFFF;
        n4 = n6 >> 16;
        n3 = OS.SendMessage(this.handle, 4160, 0, 0);
        int n8 = OS.SendMessage(this.handle, 4160, 1, 0);
        n4 -= (n8 >> 16) - (n3 >> 16);
        if (n5 == 0) {
            n5 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n9 = this.getBorderWidth();
        n5 += n9 * 2;
        n4 += n9 * 2;
        if ((this.style & 0x200) != 0) {
            n5 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n4 += OS.GetSystemMetrics(3);
        }
        return new Point(n5, n4);
    }

    void createHandle() {
        int n;
        int n2;
        int n3;
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if ((this.style & 0x20) != 0) {
            n3 = OS.SendMessage(this.handle, 4160, 0, 0);
            int n4 = OS.SendMessage(this.handle, 4160, 1, 0);
            n = n2 = (n4 >> 16) - (n3 >> 16);
            this.setCheckboxImageList(n2, n);
            OS.SendMessage(this.handle, 4107, 61440, 0);
        }
        n3 = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n3, 0);
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 4;
        n2 = OS.GetProcessHeap();
        lVCOLUMN.pszText = n = OS.HeapAlloc(n2, 8, TCHAR.sizeof);
        OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 0, lVCOLUMN);
        OS.HeapFree(n2, 0, n);
        int n5 = 16386;
        if ((this.style & 0x10000) != 0) {
            n5 |= 0x20;
        }
        OS.SendMessage(this.handle, 4150, n5, n5);
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        if ((this.style & 0x4000000) != 0) {
            int n6 = OS.SendMessage(this.handle, 4127, 0, 0);
            int n7 = OS.GetWindowLong(n6, -20);
            OS.SetWindowLong(n6, -20, n7 | 0x400000);
        }
    }

    void createItem(TableColumn tableColumn, int n) {
        Object object;
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n3 = OS.SendMessage(n2, 4608, 0, 0);
        int n4 = n3 + 1;
        if (n3 == 1 && this.columns[0] == null) {
            n3 = 0;
        }
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if (n3 == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        int n5 = OS.SendMessage(this.handle, 4100, 0, 0);
        int n6 = 0;
        while (n6 < n5) {
            object = this.items[n6];
            if (object != null) {
                int[] nArray;
                Object[] objectArray;
                Object[] objectArray2;
                String[] stringArray = ((TableItem)object).strings;
                if (stringArray != null) {
                    objectArray2 = new String[n4];
                    System.arraycopy(stringArray, 0, objectArray2, 0, n);
                    System.arraycopy(stringArray, n, objectArray2, n + 1, n4 - n - 1);
                    ((TableItem)object).strings = objectArray2;
                }
                if ((objectArray2 = ((TableItem)object).images) != null) {
                    objectArray = new Image[n4];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n);
                    System.arraycopy(objectArray2, n, objectArray, n + 1, n4 - n - 1);
                    ((TableItem)object).images = objectArray;
                }
                if (n == 0 && n3 != 0) {
                    if (stringArray == null) {
                        ((TableItem)object).strings = new String[n4];
                        ((TableItem)object).strings[1] = ((TableItem)object).text;
                    }
                    ((TableItem)object).text = "";
                    if (objectArray2 == null) {
                        ((TableItem)object).images = new Image[n4];
                        ((TableItem)object).images[1] = ((TableItem)object).image;
                    }
                    ((TableItem)object).image = null;
                }
                if (((TableItem)object).cellBackground != null) {
                    objectArray = ((TableItem)object).cellBackground;
                    nArray = new int[n4];
                    System.arraycopy(objectArray, 0, nArray, 0, n);
                    System.arraycopy(objectArray, n, nArray, n + 1, n4 - n - 1);
                    nArray[n] = -1;
                    ((TableItem)object).cellBackground = nArray;
                }
                if (((TableItem)object).cellForeground != null) {
                    objectArray = ((TableItem)object).cellForeground;
                    nArray = new int[n4];
                    System.arraycopy(objectArray, 0, nArray, 0, n);
                    System.arraycopy(objectArray, n, nArray, n + 1, n4 - n - 1);
                    nArray[n] = -1;
                    ((TableItem)object).cellForeground = nArray;
                }
                if (((TableItem)object).cellFont != null) {
                    objectArray = ((TableItem)object).cellFont;
                    nArray = new int[n4];
                    System.arraycopy(objectArray, 0, nArray, 0, n);
                    System.arraycopy(objectArray, n, nArray, n + 1, n4 - n - 1);
                    nArray[n] = -1;
                    ((TableItem)object).cellFont = nArray;
                }
            }
            ++n6;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, n3 - n);
        this.columns[n] = tableColumn;
        if (n == 0) {
            if (n3 > 0) {
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 2;
                OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 1, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, lVCOLUMN);
                int n7 = lVCOLUMN.cx;
                int n8 = 1024;
                int n9 = OS.GetProcessHeap();
                int n10 = n8 * TCHAR.sizeof;
                int n11 = OS.HeapAlloc(n9, 8, n10);
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = n11;
                lVCOLUMN.cchTextMax = n8;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 0, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 1, lVCOLUMN);
                lVCOLUMN.fmt = 2048;
                lVCOLUMN.cx = n7;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.cchTextMax = 0;
                lVCOLUMN.pszText = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                lVCOLUMN.mask = 1;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                if (n11 != 0) {
                    OS.HeapFree(n9, 0, n11);
                }
            } else {
                OS.SendMessage(this.handle, 4126, 0, 0);
            }
            if ((this.parent.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1;
                lVITEM.iImage = -1;
                int n12 = 0;
                while (n12 < n5) {
                    lVITEM.iItem = n12++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                }
            }
        } else {
            n6 = 0;
            if ((tableColumn.style & 0x1000000) == 0x1000000) {
                n6 = 2;
            }
            if ((tableColumn.style & 0x20000) == 131072) {
                n6 = 1;
            }
            object = new LVCOLUMN();
            ((LVCOLUMN)object).mask = 3;
            ((LVCOLUMN)object).fmt = n6;
            OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, n, (LVCOLUMN)object);
        }
    }

    void createItem(TableItem tableItem, int n) {
        int n2;
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if (n3 == this.items.length) {
            boolean bl = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
            n2 = bl ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.iItem = n;
        lVITEM.pszText = -1;
        lVITEM.mask |= 1;
        lVITEM.iImage = -1;
        lVITEM.mask |= 2;
        this.ignoreSelect = true;
        n2 = OS.SendMessage(this.handle, OS.LVM_INSERTITEM, 0, lVITEM);
        this.ignoreSelect = false;
        if (n2 == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, n, this.items, n + 1, n3 - n);
        this.items[n] = tableItem;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, nArray[n], lVITEM);
                this.ignoreSelect = false;
            }
            ++n;
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n, lVITEM);
        this.ignoreSelect = false;
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n == 0 && n2 == n3 - 1) {
            this.deselectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 2;
            int n4 = n = Math.max(0, n);
            while (n4 <= n2) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, n4, lVITEM);
                this.ignoreSelect = false;
                ++n4;
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lVITEM);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        Object[] objectArray;
        int n;
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n3 = OS.SendMessage(n2, 4608, 0, 0);
        int n4 = 0;
        while (n4 < n3) {
            if (this.columns[n4] == tableColumn) break;
            ++n4;
        }
        boolean bl = false;
        if (n4 == 0) {
            int n5;
            int n6;
            bl = true;
            if (n3 > 1) {
                n4 = 1;
                n6 = 1024;
                n = OS.GetProcessHeap();
                n5 = n6 * TCHAR.sizeof;
                int n7 = OS.HeapAlloc(n, 8, n5);
                objectArray = new LVCOLUMN();
                objectArray.mask = 6;
                objectArray.pszText = n7;
                objectArray.cchTextMax = n6;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1, (LVCOLUMN)objectArray);
                objectArray.mask |= 1;
                objectArray.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, (LVCOLUMN)objectArray);
                if (n7 != 0) {
                    OS.HeapFree(n, 0, n7);
                }
            } else {
                n6 = OS.GetProcessHeap();
                n = OS.HeapAlloc(n6, 8, TCHAR.sizeof);
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 4;
                lVCOLUMN.pszText = n;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0, lVCOLUMN);
                if (n != 0) {
                    OS.HeapFree(n6, 0, n);
                }
            }
            if ((this.parent.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1;
                lVITEM.iImage = -1;
                n = OS.SendMessage(this.handle, 4100, 0, 0);
                n5 = 0;
                while (n5 < n) {
                    lVITEM.iItem = n5++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0, lVITEM);
                }
            }
        }
        if (n3 > 1 && OS.SendMessage(this.handle, 4124, n4, 0) == 0) {
            this.error(15);
        }
        if (bl) {
            n4 = 0;
        }
        System.arraycopy(this.columns, n4 + 1, this.columns, n4, --n3 - n4);
        this.columns[n3] = null;
        int n8 = OS.SendMessage(this.handle, 4100, 0, 0);
        n = 0;
        while (n < n8) {
            TableItem tableItem = this.items[n];
            if (tableItem != null) {
                int[] nArray;
                Object[] objectArray2;
                String[] stringArray = tableItem.strings;
                if (stringArray != null) {
                    if (n3 == 0) {
                        tableItem.strings = null;
                    } else {
                        if (n4 == 0) {
                            tableItem.text = stringArray[1];
                        }
                        objectArray = new String[n3];
                        System.arraycopy(stringArray, 0, objectArray, 0, n4);
                        System.arraycopy(stringArray, n4 + 1, objectArray, n4, n3 - n4);
                        tableItem.strings = objectArray;
                    }
                }
                if ((objectArray = tableItem.images) != null) {
                    if (n3 == 0) {
                        tableItem.images = null;
                    } else {
                        if (n4 == 0) {
                            tableItem.image = objectArray[1];
                        }
                        objectArray2 = new Image[n3];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
                        System.arraycopy(objectArray, n4 + 1, objectArray2, n4, n3 - n4);
                        tableItem.images = objectArray2;
                    }
                }
                if (tableItem.cellBackground != null) {
                    if (n3 == 0) {
                        tableItem.cellBackground = null;
                    } else {
                        objectArray2 = tableItem.cellBackground;
                        nArray = new int[n3];
                        System.arraycopy(objectArray2, 0, nArray, 0, n4);
                        System.arraycopy(objectArray2, n4 + 1, nArray, n4, n3 - n4);
                        tableItem.cellBackground = nArray;
                    }
                }
                if (tableItem.cellForeground != null) {
                    if (n3 == 0) {
                        tableItem.cellForeground = null;
                    } else {
                        objectArray2 = tableItem.cellForeground;
                        nArray = new int[n3];
                        System.arraycopy(objectArray2, 0, nArray, 0, n4);
                        System.arraycopy(objectArray2, n4 + 1, nArray, n4, n3 - n4);
                        tableItem.cellForeground = nArray;
                    }
                }
                if (tableItem.cellFont != null) {
                    if (n3 == 0) {
                        tableItem.cellFont = null;
                    } else {
                        objectArray2 = tableItem.cellFont;
                        nArray = new int[n3];
                        System.arraycopy(objectArray2, 0, nArray, 0, n4);
                        System.arraycopy(objectArray2, n4 + 1, nArray, n4, n3 - n4);
                        tableItem.cellFont = nArray;
                    }
                }
            }
            ++n;
        }
        if (n3 == 0) {
            this.setScrollWidth(null, true);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n = OS.SendMessage(this.handle, 4100, 0, 0);
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] == tableItem) break;
            ++n2;
        }
        if (n2 == n) {
            return;
        }
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n3 = OS.SendMessage(this.handle, 4104, n2, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n3 == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n2 + 1, this.items, n2, --n - n2);
        this.items[n] = null;
        if (n == 0) {
            if (this.imageList != null) {
                int n4 = OS.SendMessage(this.handle, 4127, 0, 0);
                int n5 = OS.SendMessage(n4, 4608, 0, 0);
                if (n5 == 1 && this.columns[0] == null) {
                    n5 = 0;
                }
                int n6 = 0;
                while (n6 < n5) {
                    TableColumn tableColumn = this.columns[n6];
                    if (tableColumn.getImage() != null) break;
                    ++n6;
                }
                if (n6 == n5) {
                    OS.SendMessage(this.handle, 4099, 1, 0);
                    this.display.releaseImageList(this.imageList);
                    this.imageList = null;
                }
            }
            this.customDraw = false;
            this.items = new TableItem[4];
        }
    }

    void fixCheckboxImageList() {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n = OS.SendMessage(this.handle, 4098, 1, 0);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(n, nArray, nArray2);
        int n2 = OS.SendMessage(this.handle, 4098, 2, 0);
        if (n2 == 0) {
            return;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.ImageList_GetIconSize(n2, nArray3, nArray4);
        if (nArray[0] == nArray3[0] && nArray2[0] == nArray4[0]) {
            return;
        }
        this.setCheckboxImageList(nArray[0], nArray2[0]);
    }

    int getBackgroundPixel() {
        return OS.SendMessage(this.handle, 4096, 0, 0);
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n3 = OS.SendMessage(n2, 4608, 0, 0);
        if (n3 == 1 && this.columns[0] == null) {
            n3 = 0;
        }
        if (n < 0 || n >= n3) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4127, 0, 0);
        int n2 = OS.SendMessage(n, 4608, 0, 0);
        if (n2 == 1 && this.columns[0] == null) {
            n2 = 0;
        }
        return n2;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4127, 0, 0);
        int n2 = OS.SendMessage(n, 4608, 0, 0);
        if (n2 == 1 && this.columns[0] == null) {
            n2 = 0;
        }
        TableColumn[] tableColumnArray = new TableColumn[n2];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, n2);
        return tableColumnArray;
    }

    int getFocusIndex() {
        return OS.SendMessage(this.handle, 4108, -1, 1);
    }

    int getForegroundPixel() {
        return OS.SendMessage(this.handle, 4131, 0, 0);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4127, 0, 0);
        if (n == 0) {
            return 0;
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(n, rECT);
        return rECT.bottom - rECT.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 0x4000) == 0;
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        if (lVHITTESTINFO.iItem != -1) {
            return this._getItem(lVHITTESTINFO.iItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4100, 0, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4160, 0, 0);
        int n2 = OS.SendMessage(this.handle, 4160, 1, 0);
        return (n2 >> 16) - (n >> 16);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4100, 0, 0);
        TableItem[] tableItemArray = new TableItem[n];
        if ((this.style & 0x10000000) != 0) {
            int n2 = 0;
            while (n2 < n) {
                tableItemArray[n2] = this._getItem(n2);
                ++n2;
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, n);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4151, 0, 0);
        return (n & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n = -1;
        int n2 = 0;
        int n3 = OS.SendMessage(this.handle, 4146, 0, 0);
        TableItem[] tableItemArray = new TableItem[n3];
        while ((n = OS.SendMessage(this.handle, 4108, n, 2)) != -1) {
            tableItemArray[n2++] = this._getItem(n);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4146, 0, 0);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4108, -1, 1);
        int n2 = OS.SendMessage(this.handle, 4108, -1, 2);
        if (n == n2) {
            return n2;
        }
        int n3 = -1;
        while ((n3 = OS.SendMessage(this.handle, 4108, n3, 2)) != -1) {
            if (n3 != n) continue;
            return n3;
        }
        return n2;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = -1;
        int n2 = 0;
        int n3 = OS.SendMessage(this.handle, 4146, 0, 0);
        int[] nArray = new int[n3];
        while ((n = OS.SendMessage(this.handle, 4108, n, 2)) != -1) {
            nArray[n2++] = n;
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, OS.SendMessage(this.handle, 4135, 0, 0));
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(new Point(rectangle.width, rectangle.height));
            int n = this.imageList.indexOf(image);
            if (n == -1) {
                n = this.imageList.add(image);
            }
            int n2 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4099, 1, n2);
            this.fixCheckboxImageList();
            return n;
        }
        int n = this.imageList.indexOf(image);
        if (n != -1) {
            return n;
        }
        return this.imageList.add(image);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n = OS.SendMessage(this.handle, 4127, 0, 0);
        int n2 = OS.SendMessage(n, 4608, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            if (this.columns[n3] == tableColumn) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        int n = OS.SendMessage(this.handle, 4100, 0, 0);
        if (1 <= this.lastIndexOf && this.lastIndexOf < n - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < n / 2) {
            int n2 = 0;
            while (n2 < n) {
                if (this.items[n2] == tableItem) {
                    this.lastIndexOf = n2;
                    return this.lastIndexOf;
                }
                ++n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                if (this.items[n3] == tableItem) {
                    this.lastIndexOf = n3;
                    return this.lastIndexOf;
                }
                --n3;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = n;
        int n2 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
        return n2 != 0 && (lVITEM.state & 2) != 0;
    }

    void releaseWidget() {
        int n;
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n3 = OS.SendMessage(n2, 4608, 0, 0);
        if (n3 == 1 && this.columns[0] == null) {
            n3 = 0;
        }
        int n4 = 0;
        while (n4 < n3) {
            TableColumn tableColumn = this.columns[n4];
            if (!tableColumn.isDisposed()) {
                tableColumn.releaseResources();
            }
            ++n4;
        }
        this.columns = null;
        n4 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (OS.IsWin95 && n3 > 1) {
            OS.SendMessage(this.handle, 11, 0, 0);
            n = n4 - 1;
            while (n >= 0) {
                TableItem tableItem = this.items[n];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4104, n, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.releaseResources();
                }
                --n;
            }
        } else {
            n = 0;
            while (n < n4) {
                TableItem tableItem = this.items[n];
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.releaseResources();
                }
                ++n;
            }
        }
        this.customDraw = false;
        this.items = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
        n = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, 0);
        if (n != 0) {
            OS.ImageList_Destroy(n);
        }
        super.releaseWidget();
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = -1;
        int n5 = 0;
        while (n5 < nArray2.length) {
            int n6 = nArray2[n5];
            if (n6 != n4) {
                TableItem tableItem = this.items[n6];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n7 = OS.SendMessage(this.handle, 4104, n6, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n7 == 0) {
                    this.error(15);
                }
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.releaseResources();
                }
                System.arraycopy(this.items, n6 + 1, this.items, n6, --n3 - n6);
                this.items[n3] = null;
                n4 = n6;
            }
            ++n5;
        }
    }

    public void remove(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        TableItem tableItem = this.items[n];
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n3 = OS.SendMessage(this.handle, 4104, n, 0);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n3 == 0) {
            this.error(15);
        }
        if (tableItem != null && !tableItem.isDisposed()) {
            tableItem.releaseResources();
        }
        System.arraycopy(this.items, n + 1, this.items, n, --n2 - n);
        this.items[n2] = null;
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        if (n == 0 && n2 == n3 - 1) {
            this.removeAll();
        } else {
            int n4 = n;
            while (n4 <= n2) {
                TableItem tableItem = this.items[n4];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n5 = OS.SendMessage(this.handle, 4104, n, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n5 == 0) break;
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.releaseResources();
                }
                ++n4;
            }
            System.arraycopy(this.items, n4, this.items, n, n3 - n4);
            int n6 = n3 - (n4 - n);
            while (n6 < n3) {
                this.items[n6] = null;
                ++n6;
            }
            if (n4 <= n2) {
                this.error(15);
            }
        }
    }

    public void removeAll() {
        TableItem tableItem;
        int n;
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n4 = OS.SendMessage(n3, 4608, 0, 0);
        if (n4 == 1 && this.columns[0] == null) {
            n4 = 0;
        }
        int n5 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (OS.IsWin95 && n4 > 1) {
            int n6 = n2 = this.drawCount == 0 && OS.IsWindowVisible(this.handle) ? 1 : 0;
            if (n2 != 0) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            n = n5 - 1;
            while (n >= 0) {
                tableItem = this.items[n];
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n7 = OS.SendMessage(this.handle, 4104, n, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n7 == 0) break;
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.releaseResources();
                }
                --n;
            }
            if (n2 != 0) {
                OS.SendMessage(this.handle, 11, 1, 0);
            }
            if (n != -1) {
                this.error(15);
            }
        } else {
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            n2 = OS.SendMessage(this.handle, 4105, 0, 0);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (n2 == 0) {
                this.error(15);
            }
            n = 0;
            while (n < n5) {
                tableItem = this.items[n];
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.releaseResources();
                }
                ++n;
            }
        }
        if (this.imageList != null) {
            n2 = 0;
            while (n2 < n4) {
                TableColumn tableColumn = this.columns[n2];
                if (tableColumn.getImage() != null) break;
                ++n2;
            }
            if (n2 == n4) {
                OS.SendMessage(this.handle, 4099, 1, 0);
                this.display.releaseImageList(this.imageList);
                this.imageList = null;
            }
        }
        this.customDraw = false;
        this.items = new TableItem[4];
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (nArray[n2] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, nArray[n2], lVITEM);
                this.ignoreSelect = false;
            }
            --n2;
        }
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n, lVITEM);
        this.ignoreSelect = false;
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if (n == 0 && n2 == n3 - 1) {
            this.selectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 2;
            lVITEM.stateMask = 2;
            int n4 = n;
            while (n4 <= n2) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, n4, lVITEM);
                this.ignoreSelect = false;
                ++n4;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1, lVITEM);
        this.ignoreSelect = false;
    }

    LRESULT sendMouseDownEvent(int n, int n2, int n3, int n4, int n5) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = (short)(n5 & 0xFFFF);
        lVHITTESTINFO.y = (short)(n5 >> 16);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        this.sendMouseEvent(n, n2, n3, n4, n5);
        OS.SetFocus(this.handle);
        if (lVHITTESTINFO.iItem == -1) {
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        boolean bl = false;
        int n6 = OS.SendMessage(this.handle, 4146, 0, 0);
        if (n6 == 1 && lVHITTESTINFO.iItem != -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 8;
            lVITEM.stateMask = 2;
            lVITEM.iItem = lVHITTESTINFO.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0, lVITEM);
            boolean bl2 = bl = (lVITEM.state & 2) != 0;
            if (bl) {
                this.ignoreSelect = true;
            }
        }
        this.dragStarted = false;
        int n7 = this.callWindowProc(n3, n4, n5);
        if (bl) {
            this.ignoreSelect = false;
            Event event = new Event();
            event.item = this._getItem(lVHITTESTINFO.iItem);
            this.postEvent(13, event);
        }
        if (this.dragStarted) {
            if (OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean bl3;
            int n8 = 6;
            boolean bl4 = bl3 = (lVHITTESTINFO.flags & n8) != 0;
            if (!bl3 && (this.style & 2) != 0) {
                boolean bl5 = bl3 = (lVHITTESTINFO.flags & 8) == 0;
            }
            if (bl3) {
                this.mouseDown = false;
                this.sendMouseEvent(4, n2, n3, n4, n5);
            }
        }
        this.dragStarted = false;
        return new LRESULT(n7);
    }

    void setBackgroundPixel(int n) {
        if (this.background == n) {
            return;
        }
        this.background = n;
        if (n == -1) {
            n = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 4097, 0, n);
        OS.SendMessage(this.handle, 4134, 0, n);
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageListColor();
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void setCheckboxImageListColor() {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n = OS.SendMessage(this.handle, 4098, 2, 0);
        if (n == 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(n, nArray, nArray2);
        this.setCheckboxImageList(nArray[0], nArray2[0]);
    }

    void setCheckboxImageList(int n, int n2) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n3 = 4;
        int n4 = OS.ImageList_Create(n, n2, 0, n3, n3);
        int n5 = OS.GetDC(this.handle);
        if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
            OS.SetLayout(n5, 0);
        }
        int n6 = OS.CreateCompatibleDC(n5);
        int n7 = OS.CreateCompatibleBitmap(n5, n * n3, n2);
        int n8 = OS.SelectObject(n6, n7);
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, n * n3, n2);
        int n9 = OS.CreateSolidBrush(this.getBackgroundPixel());
        OS.FillRect(n6, rECT, n9);
        OS.DeleteObject(n9);
        int n10 = OS.SelectObject(n5, this.defaultFont());
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n5, tEXTMETRIC);
        OS.SelectObject(n5, n10);
        int n11 = Math.min(tEXTMETRIC.tmHeight, n);
        int n12 = Math.min(tEXTMETRIC.tmHeight, n2);
        int n13 = (n - n11) / 2;
        int n14 = (n2 - n12) / 2 + 1;
        OS.SetRect(rECT, n13, n14, n13 + n11, n14 + n12);
        OS.DrawFrameControl(n6, rECT, 4, 16384);
        rECT.left += n;
        rECT.right += n;
        OS.DrawFrameControl(n6, rECT, 4, 17408);
        rECT.left += n;
        rECT.right += n;
        OS.DrawFrameControl(n6, rECT, 4, 16640);
        rECT.left += n;
        rECT.right += n;
        OS.DrawFrameControl(n6, rECT, 4, 17664);
        OS.SelectObject(n6, n8);
        OS.DeleteDC(n6);
        OS.ReleaseDC(this.handle, n5);
        OS.ImageList_AddMasked(n4, n7, 0);
        OS.DeleteObject(n7);
        int n15 = OS.SendMessage(this.handle, 4098, 2, 0);
        OS.SendMessage(this.handle, 4099, 2, n4);
        if (n15 != 0) {
            OS.ImageList_Destroy(n15);
        }
    }

    void setFocusIndex(int n) {
        if (n < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 1;
        lVITEM.stateMask = 1;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, n, lVITEM);
        this.ignoreSelect = false;
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.setScrollWidth(null, true);
        int n = OS.SendMessage(this.handle, 4127, 0, 0);
        OS.InvalidateRect(n, null, true);
        int n2 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n2 & 1) == 0) {
            return;
        }
        n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 0x4000) != 0) {
            return;
        }
        this.setRowHeight();
    }

    void setForegroundPixel(int n) {
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        if (n == -1) {
            n = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 4132, 0, n);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setHeaderVisible(boolean bl) {
        int n;
        this.checkWidget();
        int n2 = OS.GetWindowLong(this.handle, -16);
        n2 &= 0xFFFFBFFF;
        if (!bl) {
            n2 |= 0x4000;
        }
        int n3 = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, n2);
        if (n3 != 0) {
            this.setTopIndex(n3);
        }
        if (bl && ((n = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
            this.setRowHeight();
        }
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        int n2 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n == n2) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        int n3 = n;
        while (n3 < n2) {
            TableItem tableItem = this.items[n3];
            if (!bl) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                int n4 = OS.SendMessage(this.handle, 4104, n, 0);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (n4 == 0) break;
            }
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.releaseResources();
            }
            ++n3;
        }
        if (n3 < n2) {
            this.error(15);
        }
        int n5 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n5];
        System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n, n2));
        this.items = tableItemArray;
        if (bl) {
            int n6 = 3;
            OS.SendMessage(this.handle, 4143, n, n6);
        } else {
            int n7 = n2;
            while (n7 < n) {
                this.items[n7] = new TableItem(this, 0, n7, true);
                ++n7;
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        int n = 0;
        if (bl) {
            n = 1;
            int n2 = OS.GetWindowLong(this.handle, -16);
            if ((n2 & 0x4000) == 0) {
                this.setRowHeight();
            }
        }
        OS.SendMessage(this.handle, 4150, 1, n);
    }

    public void setRedraw(boolean bl) {
        int n;
        this.checkWidget();
        if (this.drawCount == 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl) {
            if (--this.drawCount == 0) {
                this.setScrollWidth(null, true);
                OS.SendMessage(this.handle, 11, 1, 0);
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, false);
                } else {
                    OS.RedrawWindow(this.handle, null, 0, 1025);
                }
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
            n = OS.SendMessage(this.handle, 4127, 0, 0);
            if (n != 0) {
                OS.SendMessage(n, 11, 0, 0);
            }
        }
    }

    void setRowHeight() {
        if ((OS.COMCTL32_MAJOR << 16 | OS.COMCTL32_MINOR) >= 327760) {
            return;
        }
        int n = OS.SendMessage(this.handle, 4098, 1, 0);
        if (n != 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        RECT rECT = new RECT();
        OS.GetWindowRect(n2, rECT);
        int n3 = rECT.bottom - rECT.top - 1;
        int n4 = OS.ImageList_Create(1, n3, 0, 0, 0);
        OS.SendMessage(this.handle, 4099, 1, n4);
        this.fixCheckboxImageList();
        OS.SendMessage(this.handle, 4099, 1, 0);
        OS.ImageList_Destroy(n4);
    }

    boolean setScrollWidth(TableItem tableItem, boolean bl) {
        if (this.ignoreRedraw) {
            return false;
        }
        if (!(bl || this.drawCount == 0 && OS.IsWindowVisible(this.handle))) {
            this.fixScrollWidth = true;
            return false;
        }
        this.fixScrollWidth = false;
        int n = OS.SendMessage(this.handle, 4127, 0, 0);
        int n2 = OS.SendMessage(n, 4608, 0, 0);
        if (n2 == 1 && this.columns[0] == null) {
            int n3;
            int n4;
            int[] nArray;
            Object object;
            int n5 = 0;
            n2 = OS.SendMessage(this.handle, 4100, 0, 0);
            int n6 = 0;
            while (n6 < n2) {
                String string = null;
                if (tableItem != null) {
                    string = tableItem.text;
                } else if (this.items[n6] != null) {
                    string = this.items[n6].text;
                }
                if (string != null && string.length() != 0) {
                    object = new TCHAR(this.getCodePage(), string, true);
                    n5 = Math.max(n5, OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0, (TCHAR)object));
                }
                if (tableItem != null) break;
                ++n6;
            }
            int n7 = OS.SendMessage(this.handle, 4098, 2, 0);
            if (n7 != 0) {
                object = new int[1];
                nArray = new int[1];
                OS.ImageList_GetIconSize(n7, object, nArray);
                n5 += object[0] + 4;
            }
            if ((n4 = OS.SendMessage(this.handle, 4098, 1, 0)) != 0) {
                nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.ImageList_GetIconSize(n4, nArray, nArray2);
                n5 += nArray[0];
            }
            if ((n5 += 8) > (n3 = OS.SendMessage(this.handle, 4125, 0, 0))) {
                OS.SendMessage(this.handle, 4126, 0, n5);
                return true;
            }
        }
        return false;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray);
        int n2 = nArray[0];
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = tableItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = -1;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = this.indexOf(tableItemArray[n3]);
            if (n4 != -1) {
                n2 = n4;
                this.select(n2);
            }
            --n3;
        }
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.select(n);
        if (n != -1) {
            this.setFocusIndex(n);
        }
        this.showSelection();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        this.select(n, n2);
        this.setFocusIndex(n);
        this.showSelection();
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4135, 0, 0);
        if (n == n2) {
            return;
        }
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, n, 1);
            if (n != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, n, 1);
            }
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        OS.SendMessage(this.handle, 4110, 0, rECT);
        int n3 = (n - n2) * (rECT.bottom - rECT.top);
        OS.SendMessage(this.handle, 4116, 0, n3);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n = this.indexOf(tableColumn);
        int n2 = OS.SendMessage(this.handle, 4127, 0, 0);
        int n3 = OS.SendMessage(n2, 4608, 0, 0);
        if (n3 <= 1 || n < 0 || n >= n3) {
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        if (n == 0) {
            rECT.top = 1;
            OS.SendMessage(this.handle, 4152, -1, rECT);
            rECT.right = rECT.left;
            int n4 = OS.SendMessage(this.handle, 4125, 0, 0);
            rECT.left = rECT.right - n4;
        } else {
            rECT.top = n;
            OS.SendMessage(this.handle, 4152, -1, rECT);
        }
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        if (rECT.left < rECT2.left) {
            int n5 = rECT.left - rECT2.left;
            OS.SendMessage(this.handle, 4116, n5, 0);
        } else {
            int n6 = Math.min(rECT2.right - rECT2.left, rECT.right - rECT.left);
            if (rECT.left + n6 > rECT2.right) {
                int n7 = rECT.left + n6 - rECT2.right;
                OS.SendMessage(this.handle, 4116, n7, 0);
            }
        }
    }

    void showItem(int n) {
        if (OS.SendMessage(this.handle, 4136, 0, 0) <= 0) {
            OS.SendMessage(this.handle, 4115, n, 1);
            if (n != OS.SendMessage(this.handle, 4135, 0, 0)) {
                OS.SendMessage(this.handle, 4115, n, 1);
            }
        } else {
            OS.SendMessage(this.handle, 4115, n, 0);
        }
    }

    public void showItem(TableItem tableItem) {
        int n;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n = this.indexOf(tableItem)) != -1) {
            this.showItem(n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4108, -1, 2);
        if (n != -1) {
            this.showItem(n);
        }
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        int n = OS.SendMessage(this.handle, 4174, 0, 0);
        if (n == nMTTDISPINFO.hwndFrom && this.toolTipText != null) {
            return "";
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x40 | 0x2000000;
        if ((this.style & 0x8000) == 0) {
            n |= 8;
        }
        if ((this.style & 4) != 0) {
            n |= 4;
        }
        n |= 0x4001;
        if ((this.style & 0x10000000) != 0) {
            n |= 0x1000;
        }
        return n;
    }

    TCHAR windowClass() {
        return TableClass;
    }

    int windowProc() {
        return TableProc;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return lRESULT;
    }

    LRESULT WM_GETOBJECT(int n, int n2) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n, n2);
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 0x20) != 0 && n == 32 && (n3 = OS.SendMessage(this.handle, 4108, -1, 1)) != -1) {
            TableItem tableItem;
            tableItem.setChecked(!(tableItem = this._getItem(n3)).getChecked(), true);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.handle, -4, n3 + 1);
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDBLCLK(int n, int n2) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = (short)(n2 & 0xFFFF);
        lVHITTESTINFO.y = (short)(n2 >> 16);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        this.sendMouseEvent(3, 1, 513, n, n2);
        this.sendMouseEvent(8, 1, 515, n, n2);
        if (lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(515, n, n2);
        }
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        this.mouseDown = true;
        LRESULT lRESULT = this.sendMouseDownEvent(3, 1, 513, n, n2);
        if ((this.style & 0x20) != 0) {
            LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
            lVHITTESTINFO.x = (short)(n2 & 0xFFFF);
            lVHITTESTINFO.y = (short)(n2 >> 16);
            int n3 = OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
            if (n3 != -1 && lVHITTESTINFO.flags == 8) {
                TableItem tableItem;
                tableItem.setChecked(!(tableItem = this._getItem(n3)).getChecked(), true);
                if (!OS.IsWinCE) {
                    OS.NotifyWinEvent(32773, this.handle, -4, n3 + 1);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(int n, int n2) {
        this.mouseDown = false;
        return super.WM_LBUTTONUP(n, n2);
    }

    LRESULT WM_MOUSEHOVER(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.WM_MOUSEHOVER(n, n2);
        int n4 = OS.SendMessage(this.handle, 4151, 0, 0);
        if ((n4 & (n3 = 200)) != 0) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PAINT(int n, int n2) {
        if (!this.ignoreShrink) {
            int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
            if (this.items.length > 4 && this.items.length - n3 > 3) {
                int n4 = Math.max(4, (n3 + 3) / 4 * 4);
                TableItem[] tableItemArray = new TableItem[n4];
                System.arraycopy(this.items, 0, tableItemArray, 0, n3);
                this.items = tableItemArray;
            }
        }
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        return super.WM_PAINT(n, n2);
    }

    LRESULT WM_NOTIFY(int n, int n2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, n2, 12);
        int n3 = OS.SendMessage(this.handle, 4127, 0, 0);
        if (nMHDR.hwndFrom == n3) {
            switch (nMHDR.code) {
                case -326: 
                case -325: 
                case -306: 
                case -305: {
                    NMHEADER nMHEADER = new NMHEADER();
                    OS.MoveMemory(nMHEADER, n2, NMHEADER.sizeof);
                    TableColumn tableColumn = this.columns[nMHEADER.iItem];
                    if (tableColumn == null || tableColumn.getResizable()) break;
                    return LRESULT.ONE;
                }
                case -321: 
                case -301: {
                    TableColumn tableColumn;
                    Object object;
                    int n4;
                    int n5 = OS.SendMessage(this.handle, 4125, 0, 0);
                    if (this.lastWidth == 0 && n5 > 0 && ((n4 = OS.SendMessage(this.handle, 4151, 0, 0)) & 1) != 0) {
                        object = new RECT();
                        OS.GetClientRect(this.handle, (RECT)object);
                        ((RECT)object).right = ((RECT)object).left + n5;
                        OS.InvalidateRect(this.handle, (RECT)object, true);
                    }
                    this.lastWidth = n5;
                    NMHEADER nMHEADER = new NMHEADER();
                    OS.MoveMemory(nMHEADER, n2, NMHEADER.sizeof);
                    if (nMHEADER.pitem == 0) break;
                    object = new HDITEM();
                    OS.MoveMemory((HDITEM)object, nMHEADER.pitem, HDITEM.sizeof);
                    if ((((HDITEM)object).mask & 1) == 0 || (tableColumn = this.columns[nMHEADER.iItem]) == null) break;
                    tableColumn.sendEvent(11);
                    if (this.isDisposed()) {
                        return LRESULT.ZERO;
                    }
                    int n6 = OS.SendMessage(n3, 4608, 0, 0);
                    if (n6 == 1 && this.columns[0] == null) {
                        n6 = 0;
                    }
                    TableColumn[] tableColumnArray = new TableColumn[n6];
                    System.arraycopy(this.columns, 0, tableColumnArray, 0, n6);
                    int n7 = nMHEADER.iItem + 1;
                    while (n7 < n6) {
                        if (!tableColumnArray[n7].isDisposed()) {
                            tableColumnArray[n7].sendEvent(10);
                        }
                        ++n7;
                    }
                    break;
                }
                case -323: 
                case -303: {
                    NMHEADER nMHEADER = new NMHEADER();
                    OS.MoveMemory(nMHEADER, n2, NMHEADER.sizeof);
                    TableColumn tableColumn = this.columns[nMHEADER.iItem];
                    if (tableColumn == null) break;
                    tableColumn.postEvent(14);
                }
            }
        }
        return super.WM_NOTIFY(n, n2);
    }

    LRESULT WM_RBUTTONDBLCLK(int n, int n2) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = (short)(n2 & 0xFFFF);
        lVHITTESTINFO.y = (short)(n2 >> 16);
        OS.SendMessage(this.handle, 4114, 0, lVHITTESTINFO);
        this.sendMouseEvent(3, 1, 516, n, n2);
        this.sendMouseEvent(8, 1, 518, n, n2);
        if (lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(518, n, n2);
        }
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_RBUTTONDOWN(int n, int n2) {
        return this.sendMouseDownEvent(3, 3, 516, n, n2);
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        int n3 = OS.SendMessage(this.handle, 4100, 0, 0);
        if (n3 == 0) {
            return lRESULT;
        }
        int n4 = OS.SendMessage(this.handle, 4108, -1, 1);
        if (n4 == -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 1;
            lVITEM.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, 0, lVITEM);
            this.ignoreSelect = false;
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        return null;
    }

    LRESULT WM_SYSCOLORCHANGE(int n, int n2) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 0x20) != 0) {
            this.setCheckboxImageListColor();
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGED(int n, int n2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGED(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n2, 28);
        if ((wINDOWPOS.flags & 1) == 0) {
            this.setResizeChildren(false);
            int n3 = this.callWindowProc(71, n, n2);
            this.sendEvent(11);
            if (this.isDisposed()) {
                return new LRESULT(n3);
            }
            if (this.layout != null) {
                this.layout.layout(this, false);
            }
            this.setResizeChildren(true);
            return new LRESULT(n3);
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(int n, int n2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, n2, 12);
        switch (nMHDR.code) {
            case -179: 
            case -152: {
                if ((this.style & 0x10000000) == 0) break;
                NMLVFINDITEM nMLVFINDITEM = new NMLVFINDITEM();
                OS.MoveMemory(nMLVFINDITEM, n2, 40);
                int n3 = Math.max(0, nMLVFINDITEM.iStart - 1);
                return new LRESULT(n3);
            }
            case -177: 
            case -150: {
                Object object;
                Object object2;
                NMLVDISPINFO nMLVDISPINFO = new NMLVDISPINFO();
                OS.MoveMemory(nMLVDISPINFO, n2, 52);
                this.lastIndexOf = nMLVDISPINFO.iItem;
                TableItem tableItem = this._getItem(nMLVDISPINFO.iItem);
                if (!tableItem.cached) {
                    if ((this.style & 0x10000000) != 0) {
                        object2 = new Event();
                        ((Event)object2).item = tableItem;
                        this.ignoreRedraw = true;
                        this.sendEvent(36, (Event)object2);
                        if (this.isDisposed()) break;
                        this.ignoreRedraw = false;
                        Object object3 = object = this.fixScrollWidth ? null : tableItem;
                        if (this.setScrollWidth((TableItem)object, true)) {
                            this.redraw();
                        }
                    }
                    tableItem.cached = true;
                }
                if ((nMLVDISPINFO.mask & 1) != 0) {
                    object2 = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        object2 = tableItem.text;
                    } else {
                        object = tableItem.strings;
                        if (object != null) {
                            object2 = object[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (object2 != null) {
                        object = new TCHAR(this.getCodePage(), (String)object2, false);
                        int n4 = Math.min(((TCHAR)object).length(), nMLVDISPINFO.cchTextMax - 1) * TCHAR.sizeof;
                        OS.MoveMemory(nMLVDISPINFO.pszText, (TCHAR)object, n4);
                        OS.MoveMemory(nMLVDISPINFO.pszText + n4, new byte[TCHAR.sizeof], TCHAR.sizeof);
                        nMLVDISPINFO.cchTextMax = Math.min(nMLVDISPINFO.cchTextMax, ((String)object2).length() + 1);
                    }
                }
                if ((nMLVDISPINFO.mask & 2) != 0) {
                    object2 = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        object2 = tableItem.image;
                    } else {
                        object = tableItem.images;
                        if (object != null) {
                            object2 = object[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (object2 != null) {
                        nMLVDISPINFO.iImage = this.imageIndex((Image)object2);
                    }
                }
                if ((nMLVDISPINFO.mask & 8) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    int n5 = 1;
                    if (tableItem.checked) {
                        ++n5;
                    }
                    if (tableItem.grayed) {
                        n5 += 2;
                    }
                    nMLVDISPINFO.state = n5 << 12;
                    nMLVDISPINFO.stateMask = 61440;
                }
                if ((nMLVDISPINFO.mask & 0x10) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    nMLVDISPINFO.iIndent = tableItem.imageIndent;
                }
                OS.MoveMemory(n2, nMLVDISPINFO, 52);
                break;
            }
            case -12: {
                if (!this.customDraw) break;
                NMLVCUSTOMDRAW nMLVCUSTOMDRAW = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nMLVCUSTOMDRAW, n2, 60);
                switch (nMLVCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        return new LRESULT(32);
                    }
                    case 65537: {
                        return new LRESULT(32);
                    }
                    case 196609: {
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        TableItem tableItem = this._getItem(nMLVCUSTOMDRAW.dwItemSpec);
                        int n11 = n10 = tableItem.cellFont != null ? tableItem.cellFont[nMLVCUSTOMDRAW.iSubItem] : -1;
                        if (n10 == -1) {
                            n10 = tableItem.font;
                        }
                        int n12 = n9 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                        if (n9 == -1) {
                            n9 = tableItem.foreground;
                        }
                        int n13 = n8 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
                        if (n8 == -1) {
                            n8 = tableItem.background;
                        }
                        if (n10 == -1 && n9 == -1 && n8 == -1 && tableItem.cellForeground == null && tableItem.cellBackground == null && tableItem.cellFont == null && (n7 = OS.SendMessage(n6 = OS.SendMessage(this.handle, 4127, 0, 0), 4608, 0, 0)) == 1) break;
                        if (n10 == -1) {
                            n10 = OS.SendMessage(this.handle, 49, 0, 0);
                        }
                        OS.SelectObject(nMLVCUSTOMDRAW.hdc, n10);
                        nMLVCUSTOMDRAW.clrText = n9 == -1 ? this.getForegroundPixel() : n9;
                        nMLVCUSTOMDRAW.clrTextBk = n8 == -1 ? this.getBackgroundPixel() : n8;
                        OS.MoveMemory(n2, nMLVCUSTOMDRAW, 60);
                        return new LRESULT(2);
                    }
                }
                break;
            }
            case -156: {
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                this.dragStarted = true;
                if (nMHDR.code != -109) break;
                int n14 = OS.GetMessagePos();
                POINT pOINT = new POINT();
                pOINT.x = (short)(n14 & 0xFFFF);
                pOINT.y = (short)(n14 >> 16);
                OS.ScreenToClient(this.handle, pOINT);
                Event event = new Event();
                event.x = pOINT.x;
                event.y = pOINT.y;
                this.postEvent(29, event);
                break;
            }
            case -108: {
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n2, NMLISTVIEW.sizeof);
                TableColumn tableColumn = this.columns[nMLISTVIEW.iSubItem];
                if (tableColumn == null) break;
                tableColumn.postEvent(13);
                break;
            }
            case -114: {
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n2, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                Event event = new Event();
                event.item = this._getItem(nMLISTVIEW.iItem);
                this.postEvent(14, event);
                break;
            }
            case -101: {
                if (this.ignoreSelect) break;
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, n2, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1 || (nMLISTVIEW.uChanged & 8) == 0) break;
                boolean bl = (nMLISTVIEW.uNewState & 1) != 0;
                int n15 = OS.SendMessage(this.handle, 4108, -1, 1);
                if ((this.style & 2) != 0 && OS.GetKeyState(17) < 0) {
                    if (!bl) {
                        if (n15 == nMLISTVIEW.iItem) {
                            boolean bl2 = (nMLISTVIEW.uNewState & 2) != 0;
                            boolean bl3 = (nMLISTVIEW.uOldState & 2) != 0;
                            bl = bl2 != bl3;
                        }
                    } else {
                        bl = this.mouseDown;
                    }
                }
                if (OS.GetKeyState(32) < 0) {
                    bl = true;
                }
                if (!bl) break;
                Event event = new Event();
                if (n15 != -1) {
                    event.item = this._getItem(n15);
                }
                this.postEvent(13, event);
                break;
            }
            case -16: {
                boolean bl;
                if (!OS.IsPPC) break;
                boolean bl4 = bl = this.menu != null && !this.menu.isDisposed();
                if (bl || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean bl;
                if (!OS.IsPPC) break;
                boolean bl5 = bl = this.menu != null && !this.menu.isDisposed();
                if (!bl && !this.hooks(35)) break;
                NMRGINFO nMRGINFO = new NMRGINFO();
                OS.MoveMemory(nMRGINFO, n2, NMRGINFO.sizeof);
                this.showMenu(nMRGINFO.x, nMRGINFO.y);
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(n, n2);
    }
}

