/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    static final int CLIENT_INSET = 3;
    static final int GroupProc;
    static final TCHAR GroupClass;

    static {
        GroupClass = new TCHAR(0, OS.IsWinCE ? "BUTTON" : "SWT_GROUP", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        if (OS.IsWinCE) {
            OS.GetClassInfo(0, GroupClass, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
        } else {
            TCHAR tCHAR = new TCHAR(0, "BUTTON", true);
            OS.GetClassInfo(0, tCHAR, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
            int n = OS.GetModuleHandle(null);
            if (!OS.GetClassInfo(n, GroupClass, wNDCLASS)) {
                int n2 = OS.GetProcessHeap();
                wNDCLASS.hInstance = n;
                wNDCLASS.style &= 0xFFFFFFFC;
                int n3 = GroupClass.length() * TCHAR.sizeof;
                int n4 = OS.HeapAlloc(n2, 8, n3);
                OS.MoveMemory(n4, GroupClass, n3);
                wNDCLASS.lpszClassName = n4;
                OS.RegisterClass(wNDCLASS);
            }
        }
    }

    public Group(Composite composite, int n) {
        super(composite, Group.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3) {
        if (this.handle == 0) {
            return 0;
        }
        switch (n) {
            case 513: 
            case 515: {
                return OS.DefWindowProc(this.handle, n, n2, n3);
            }
        }
        return OS.CallWindowProc(GroupProc, this.handle, n, n2, n3);
    }

    static int checkStyle(int n) {
        return (n |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        int n6 = OS.GetDC(this.handle);
        int n7 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n7 != 0) {
            n5 = OS.SelectObject(n6, n7);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n6, tEXTMETRIC);
        int n8 = 0;
        int n9 = OS.GetWindowTextLength(this.handle);
        if (n9 != 0) {
            TCHAR tCHAR = new TCHAR(this.getCodePage(), n9 + 1);
            OS.GetWindowText(this.handle, tCHAR, n9 + 1);
            RECT rECT = new RECT();
            int n10 = 1056;
            OS.DrawText(n6, tCHAR, n9, rECT, n10);
            n8 = rECT.right - rECT.left + 12;
        }
        if (n7 != 0) {
            OS.SelectObject(n6, n5);
        }
        OS.ReleaseDC(this.handle, n6);
        rectangle.x -= 3;
        rectangle.y -= tEXTMETRIC.tmHeight;
        rectangle.width = Math.max(rectangle.width, n8) + 6;
        rectangle.height += tEXTMETRIC.tmHeight + 3;
        return rectangle;
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFFFD;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n = 0;
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n3 != 0) {
            n = OS.SelectObject(n2, n3);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n2, tEXTMETRIC);
        if (n3 != 0) {
            OS.SelectObject(n2, n);
        }
        OS.ReleaseDC(this.handle, n2);
        int n4 = 3;
        int n5 = tEXTMETRIC.tmHeight;
        int n6 = rECT.right - 6;
        int n7 = rECT.bottom - n5 - 3;
        return new Rectangle(n4, n5, n6, n7);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    boolean mnemonicHit(char c) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
    }

    int widgetStyle() {
        return super.widgetStyle() | 7 | 0x2000000 | 0x4000000;
    }

    TCHAR windowClass() {
        return GroupClass;
    }

    int windowProc() {
        return GroupProc;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.drawBackground(n);
        return LRESULT.ONE;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        LRESULT lRESULT = super.WM_NCHITTEST(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = this.callWindowProc(132, n, n2);
        if (n3 == -1) {
            n3 = 1;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_MOUSEMOVE(int n, int n2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int n, int n2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            int n3 = OS.SaveDC(n);
            int n4 = this.callWindowProc(792, n, n2);
            OS.RestoreDC(n, n3);
            return new LRESULT(n4);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (OS.IsWinCE) {
            return lRESULT;
        }
        OS.InvalidateRect(this.handle, null, true);
        return lRESULT;
    }
}

