/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class FillLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;

    public FillLayout() {
    }

    public FillLayout(int n) {
        this.type = n;
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        Control[] controlArray = composite.getChildren();
        int n3 = controlArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            Control control = controlArray[n6];
            Point point = control.computeSize(-1, -1, bl);
            n4 = Math.max(n4, point.x);
            n5 = Math.max(n5, point.y);
            ++n6;
        }
        n6 = 0;
        int n7 = 0;
        if (this.type == 256) {
            n6 = n3 * n4;
            if (n3 != 0) {
                n6 += (n3 - 1) * this.spacing;
            }
            n7 = n5;
        } else {
            n6 = n4;
            n7 = n3 * n5;
            if (n3 != 0) {
                n7 += (n3 - 1) * this.spacing;
            }
        }
        return new Point(n6 += this.marginWidth * 2, n7 += this.marginHeight * 2);
    }

    protected void layout(Composite composite, boolean bl) {
        Rectangle rectangle = composite.getClientArea();
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        if (n == 0) {
            return;
        }
        int n2 = rectangle.width - this.marginWidth * 2;
        int n3 = rectangle.height - this.marginHeight * 2;
        if (this.type == 256) {
            int n4 = rectangle.x + this.marginWidth;
            int n5 = (n2 -= (n - 1) * this.spacing) % n;
            int n6 = rectangle.y + this.marginHeight;
            int n7 = n2 / n;
            int n8 = 0;
            while (n8 < n) {
                Control control = controlArray[n8];
                int n9 = n7;
                if (n8 == 0) {
                    n9 += n5 / 2;
                } else if (n8 == n - 1) {
                    n9 += (n5 + 1) / 2;
                }
                control.setBounds(n4, n6, n9, n3);
                n4 += n9 + this.spacing;
                ++n8;
            }
        } else {
            int n10 = rectangle.x + this.marginWidth;
            int n11 = (n3 -= (n - 1) * this.spacing) / n;
            int n12 = rectangle.y + this.marginHeight;
            int n13 = n3 % n;
            int n14 = 0;
            while (n14 < n) {
                Control control = controlArray[n14];
                int n15 = n11;
                if (n14 == 0) {
                    n15 += n13 / 2;
                } else if (n14 == n - 1) {
                    n15 += (n13 + 1) / 2;
                }
                control.setBounds(n10, n12, n2, n15);
                n12 += n15 + this.spacing;
                ++n14;
            }
        }
    }
}

