/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LZWCodec;

final class GIFFileFormat
extends FileFormat {
    String signature;
    String version;
    boolean sorted;
    int screenWidth;
    int screenHeight;
    int backgroundPixel;
    int aspect;
    int bitsPerPixel;
    int defaultDepth;
    boolean userInput = false;
    int disposalMethod = 0;
    int delayTime = 0;
    int transparentPixel = -1;
    int repeatCount = 1;
    static final int GIF_APPLICATION_EXTENSION_BLOCK_ID = 255;
    static final int GIF_GRAPHICS_CONTROL_BLOCK_ID = 249;
    static final int GIF_PLAIN_TEXT_BLOCK_ID = 1;
    static final int GIF_COMMENT_BLOCK_ID = 254;
    static final int GIF_EXTENSION_BLOCK_ID = 33;
    static final int GIF_IMAGE_BLOCK_ID = 44;
    static final int GIF_TRAILER_ID = 59;

    GIFFileFormat() {
    }

    static PaletteData grayRamp(int n) {
        int n2 = n - 1;
        RGB[] rGBArray = new RGB[n];
        int n3 = 0;
        while (n3 < n) {
            byte by = (byte)(n3 * 3 * 256 / n2);
            rGBArray[n3] = new RGB(by, by, by);
            ++n3;
        }
        return new PaletteData(rGBArray);
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[3];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            return new String(byArray).equals("GIF");
        }
        catch (Exception exception) {
            return false;
        }
    }

    ImageData[] loadFromByteStream() {
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[3];
        byte[] byArray3 = new byte[7];
        try {
            this.inputStream.read(byArray);
            this.signature = new String(byArray);
            if (!this.signature.equals("GIF")) {
                SWT.error(40);
            }
            this.inputStream.read(byArray2);
            this.version = new String(byArray2);
            this.inputStream.read(byArray3);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.loader.logicalScreenWidth = this.screenWidth = byArray3[0] & 0xFF | (byArray3[1] & 0xFF) << 8;
        this.loader.logicalScreenHeight = this.screenHeight = byArray3[2] & 0xFF | (byArray3[3] & 0xFF) << 8;
        byte by = byArray3[4];
        this.backgroundPixel = byArray3[5] & 0xFF;
        this.aspect = byArray3[6] & 0xFF;
        this.bitsPerPixel = (by >> 4 & 7) + 1;
        this.defaultDepth = (by & 7) + 1;
        PaletteData paletteData = null;
        if ((by & 0x80) != 0) {
            this.sorted = (by & 8) != 0;
            paletteData = this.readPalette(1 << this.defaultDepth);
        } else {
            this.sorted = false;
            this.backgroundPixel = -1;
            this.defaultDepth = this.bitsPerPixel;
        }
        this.loader.backgroundPixel = this.backgroundPixel;
        this.getExtensions();
        int n = this.readID();
        ImageData[] imageDataArray = new ImageData[]{};
        while (n == 44) {
            ImageData imageData = this.readImageBlock(paletteData);
            if (this.loader.hasListeners()) {
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, 3, true));
            }
            ImageData[] imageDataArray2 = imageDataArray;
            imageDataArray = new ImageData[imageDataArray2.length + 1];
            System.arraycopy(imageDataArray2, 0, imageDataArray, 0, imageDataArray2.length);
            imageDataArray[imageDataArray.length - 1] = imageData;
            try {
                n = this.inputStream.read();
                if (n > 0) {
                    this.inputStream.unread(new byte[]{(byte)n});
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            this.getExtensions();
            n = this.readID();
        }
        return imageDataArray;
    }

    int readID() {
        try {
            return this.inputStream.read();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
            return -1;
        }
    }

    void getExtensions() {
        int n = this.readID();
        while (n != 44 && n != 59 && n > 0) {
            if (n == 33) {
                this.readExtension();
            } else {
                SWT.error(40);
            }
            n = this.readID();
        }
        if (n == 44 || n == 59) {
            try {
                this.inputStream.unread(new byte[]{(byte)n});
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
    }

    byte[] readExtension() {
        int n = this.readID();
        if (n == 254) {
            return this.readCommentExtension();
        }
        if (n == 1) {
            return this.readPlainTextExtension();
        }
        if (n == 249) {
            return this.readGraphicsControlExtension();
        }
        if (n == 255) {
            return this.readApplicationExtension();
        }
        try {
            int n2 = this.inputStream.read();
            if (n2 < 0) {
                SWT.error(40);
            }
            byte[] byArray = new byte[n2];
            this.inputStream.read(byArray, 0, n2);
            return byArray;
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
            return null;
        }
    }

    byte[] readCommentExtension() {
        try {
            byte[] byArray = new byte[]{};
            byte[] byArray2 = new byte[255];
            int n = this.inputStream.read();
            while (n > 0 && this.inputStream.read(byArray2, 0, n) != -1) {
                byte[] byArray3 = byArray;
                byArray = new byte[byArray3.length + n];
                System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                System.arraycopy(byArray2, 0, byArray, byArray3.length, n);
                n = this.inputStream.read();
            }
            return byArray;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    byte[] readPlainTextExtension() {
        try {
            this.inputStream.read();
            byte[] byArray = new byte[12];
            this.inputStream.read(byArray);
            byte[] byArray2 = new byte[]{};
            byte[] byArray3 = new byte[255];
            int n = this.inputStream.read();
            while (n > 0 && this.inputStream.read(byArray3, 0, n) != -1) {
                byte[] byArray4 = byArray2;
                byArray2 = new byte[byArray4.length + n];
                System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
                System.arraycopy(byArray3, 0, byArray2, byArray4.length, n);
                n = this.inputStream.read();
            }
            return byArray2;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    byte[] readGraphicsControlExtension() {
        try {
            this.inputStream.read();
            byte[] byArray = new byte[4];
            this.inputStream.read(byArray);
            byte by = byArray[0];
            this.userInput = (by & 2) != 0;
            this.disposalMethod = by >> 2 & 7;
            this.delayTime = byArray[1] & 0xFF | (byArray[2] & 0xFF) << 8;
            if ((by & 1) != 0) {
                int n = byArray[3] & 0xFF;
                if (n <= 1 << this.defaultDepth) {
                    this.transparentPixel = n;
                }
            } else {
                this.transparentPixel = -1;
            }
            this.inputStream.read();
            return byArray;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    byte[] readApplicationExtension() {
        try {
            this.inputStream.read();
            byte[] byArray = new byte[8];
            this.inputStream.read(byArray);
            String string = new String(byArray);
            byte[] byArray2 = new byte[3];
            this.inputStream.read(byArray2);
            String string2 = new String(byArray2);
            byte[] byArray3 = new byte[]{};
            byte[] byArray4 = new byte[255];
            int n = this.inputStream.read();
            while (n > 0 && this.inputStream.read(byArray4, 0, n) != -1) {
                byte[] byArray5 = byArray3;
                byArray3 = new byte[byArray5.length + n];
                System.arraycopy(byArray5, 0, byArray3, 0, byArray5.length);
                System.arraycopy(byArray4, 0, byArray3, byArray5.length, n);
                n = this.inputStream.read();
            }
            if (string.equals("NETSCAPE") && string2.equals("2.0") && byArray3[0] == 1) {
                this.loader.repeatCount = this.repeatCount = byArray3[1] & 0xFF | (byArray3[2] & 0xFF) << 8;
            }
            return byArray3;
        }
        catch (Exception exception) {
            SWT.error(39, exception);
            return null;
        }
    }

    ImageData readImageBlock(PaletteData paletteData) {
        PaletteData paletteData2;
        int n;
        boolean bl;
        byte[] byArray = new byte[9];
        try {
            this.inputStream.read(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        int n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
        int n3 = byArray[2] & 0xFF | (byArray[3] & 0xFF) << 8;
        int n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
        int n5 = byArray[6] & 0xFF | (byArray[7] & 0xFF) << 8;
        byte by = byArray[8];
        boolean bl2 = bl = (by & 0x40) != 0;
        if ((by & 0x80) != 0) {
            n = (by & 7) + 1;
            paletteData2 = this.readPalette(1 << n);
        } else {
            n = this.defaultDepth;
            paletteData2 = paletteData;
        }
        if (n != 1 && n != 4 && n != 8) {
            n = n < 4 ? 4 : 8;
        }
        if (paletteData2 == null) {
            paletteData2 = GIFFileFormat.grayRamp(1 << n);
        }
        int n6 = -1;
        try {
            n6 = this.inputStream.read();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n6 < 0) {
            SWT.error(40);
        }
        ImageData imageData = ImageData.internal_new(n4, n5, n, paletteData2, 4, null, 0, null, null, -1, this.transparentPixel, 2, n2, n3, this.disposalMethod, this.delayTime);
        LZWCodec lZWCodec = new LZWCodec();
        lZWCodec.decode(this.inputStream, this.loader, imageData, bl, n6);
        return imageData;
    }

    PaletteData readPalette(int n) {
        byte[] byArray = new byte[n * 3];
        try {
            if (this.inputStream.read(byArray) != byArray.length) {
                SWT.error(40);
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        RGB[] rGBArray = new RGB[n];
        int n2 = 0;
        while (n2 < n) {
            rGBArray[n2] = new RGB(byArray[n2 * 3] & 0xFF, byArray[n2 * 3 + 1] & 0xFF, byArray[n2 * 3 + 2] & 0xFF);
            ++n2;
        }
        return new PaletteData(rGBArray);
    }

    void unloadIntoByteStream(ImageData imageData) {
        if (imageData.depth != 1 && imageData.depth != 4 && imageData.depth != 8) {
            SWT.error(38);
        }
        byte by = (byte)(128 + (imageData.depth - 1) + (imageData.depth - 1) * 16);
        try {
            this.outputStream.write(new byte[]{71, 73, 70});
            this.outputStream.write(new byte[]{56, 57, 97});
            this.outputStream.writeShort((short)imageData.width);
            this.outputStream.writeShort((short)imageData.height);
            this.outputStream.writeByte(by);
            this.outputStream.writeByte((byte)0);
            this.outputStream.writeByte((byte)0);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.writePalette(imageData.palette, imageData.depth);
        if (imageData.transparentPixel != -1 || imageData.disposalMethod != 0 || imageData.delayTime != 0) {
            this.writeGraphicsControlBlock(imageData);
        }
        this.writeImageBlock(imageData);
        try {
            this.outputStream.write(59);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void writeGraphicsControlBlock(ImageData imageData) {
        try {
            this.outputStream.write(33);
            this.outputStream.write(249);
            this.outputStream.write(4);
            byte[] byArray = new byte[]{-3, 0, 0, 0};
            if (imageData.transparentPixel == -1) {
                byArray[0] = (byte)(byArray[0] & 0xFE);
            } else {
                byArray[0] = (byte)(byArray[0] | 1);
                byArray[3] = (byte)imageData.transparentPixel;
            }
            if (imageData.disposalMethod != 0) {
                byArray[0] = (byte)(byArray[0] | (imageData.disposalMethod & 7) << 2);
            }
            if (imageData.delayTime != 0) {
                byArray[1] = (byte)(imageData.delayTime & 0xFF);
                byArray[2] = (byte)(imageData.delayTime >> 8 & 0xFF);
            }
            this.outputStream.write(byArray);
            this.outputStream.write(0);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void writeImageBlock(ImageData imageData) {
        try {
            this.outputStream.write(44);
            byte[] byArray = new byte[]{(byte)(imageData.x & 0xFF), (byte)(imageData.x >> 8 & 0xFF), (byte)(imageData.y & 0xFF), (byte)(imageData.y >> 8 & 0xFF), (byte)(imageData.width & 0xFF), (byte)(imageData.width >> 8 & 0xFF), (byte)(imageData.height & 0xFF), (byte)(imageData.height >> 8 & 0xFF), 0};
            this.outputStream.write(byArray);
            this.outputStream.write(imageData.depth);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        new LZWCodec().encode(this.outputStream, imageData);
    }

    void writePalette(PaletteData paletteData, int n) {
        byte[] byArray = new byte[(1 << n) * 3];
        int n2 = 0;
        int n3 = 0;
        while (n3 < paletteData.colors.length) {
            RGB rGB = paletteData.colors[n3];
            byArray[n2] = (byte)rGB.red;
            byArray[n2 + 1] = (byte)rGB.green;
            byArray[n2 + 2] = (byte)rGB.blue;
            n2 += 3;
            ++n3;
        }
        try {
            this.outputStream.write(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }
}

