/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public final class Image
implements Drawable {
    public int type;
    public int handle;
    Device device;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    ImageData data;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int n, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n, n2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image image, int n) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        switch (n) {
            case 0: {
                Rectangle rectangle = image.getBounds();
                this.type = image.type;
                switch (this.type) {
                    case 0: {
                        int n2 = device.internal_new_GC(null);
                        int n3 = OS.CreateCompatibleDC(n2);
                        int n4 = OS.CreateCompatibleDC(n2);
                        int n5 = OS.SelectObject(n3, image.handle);
                        this.handle = OS.CreateCompatibleBitmap(n3, rectangle.width, rectangle.height);
                        if (this.handle == 0) {
                            SWT.error(2);
                        }
                        int n6 = OS.SelectObject(n4, this.handle);
                        OS.BitBlt(n4, 0, 0, rectangle.width, rectangle.height, n3, 0, 0, 0xCC0020);
                        OS.SelectObject(n3, n5);
                        OS.SelectObject(n4, n6);
                        OS.DeleteDC(n3);
                        OS.DeleteDC(n4);
                        device.internal_dispose_GC(n2, null);
                        this.transparentPixel = image.transparentPixel;
                        this.alpha = image.alpha;
                        if (image.alphaData == null) break;
                        this.alphaData = new byte[image.alphaData.length];
                        System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        if (OS.IsWinCE) {
                            this.init(device, image.data);
                            break;
                        }
                        this.handle = OS.CopyImage(image.handle, 1, rectangle.width, rectangle.height, 0);
                        if (this.handle != 0) break;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(42);
                    }
                }
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 1: {
                int[] nArray;
                int n7;
                int n8;
                int n9;
                Rectangle rectangle = image.getBounds();
                this.type = image.type;
                byte[] byArray = new byte[48];
                byArray[0] = 40;
                byArray[4] = (byte)(rectangle.width & 0xFF);
                byArray[5] = (byte)((rectangle.width & 0xFF00) >> 8);
                byArray[6] = (byte)((rectangle.width & 0xFF0000) >> 16);
                byArray[7] = (byte)((rectangle.width & 0xFF000000) >> 24);
                byArray[8] = (byte)(rectangle.height & 0xFF);
                byArray[9] = (byte)((rectangle.height & 0xFF00) >> 8);
                byArray[10] = (byte)((rectangle.height & 0xFF0000) >> 16);
                byArray[11] = (byte)((rectangle.height & 0xFF000000) >> 24);
                byArray[12] = 1;
                byArray[14] = 1;
                byArray[44] = -1;
                byArray[45] = -1;
                byArray[46] = -1;
                byte[] byArray2 = byArray;
                int n10 = device.internal_new_GC(null);
                int n11 = OS.CreateCompatibleDC(n10);
                if (n11 == 0) {
                    SWT.error(2);
                }
                if ((n9 = OS.CreateCompatibleDC(n11)) == 0) {
                    SWT.error(2);
                }
                if ((n8 = OS.CreateCompatibleDC(n10)) == 0) {
                    SWT.error(2);
                }
                if ((n7 = OS.CreateDIBSection(n9, byArray2, 0, nArray = new int[1], 0, 0)) == 0) {
                    SWT.error(2);
                }
                switch (this.type) {
                    case 0: {
                        int n12 = OS.SelectObject(n11, image.handle);
                        this.handle = OS.CreateCompatibleBitmap(n10, rectangle.width, rectangle.height);
                        if (this.handle == 0) {
                            SWT.error(2);
                        }
                        int n13 = OS.SelectObject(n9, n7);
                        int n14 = OS.SelectObject(n8, this.handle);
                        OS.BitBlt(n9, 0, 0, rectangle.width, rectangle.height, n11, 0, 0, 0xCC0020);
                        RECT rECT = new RECT();
                        rECT.left = 0;
                        rECT.top = 0;
                        rECT.right = rectangle.width;
                        rECT.bottom = rectangle.height;
                        OS.FillRect(n8, rECT, OS.GetSysColorBrush(OS.COLOR_3DFACE));
                        int n15 = OS.CreateSolidBrush(OS.GetSysColor(OS.COLOR_3DHILIGHT));
                        int n16 = OS.SelectObject(n8, n15);
                        OS.BitBlt(n8, 1, 1, rectangle.width, rectangle.height, n9, 0, 0, 12060490);
                        n15 = OS.CreateSolidBrush(OS.GetSysColor(OS.COLOR_3DSHADOW));
                        OS.DeleteObject(OS.SelectObject(n8, n15));
                        OS.BitBlt(n8, 0, 0, rectangle.width, rectangle.height, n9, 0, 0, 12060490);
                        OS.DeleteObject(OS.SelectObject(n8, n16));
                        OS.SelectObject(n11, n12);
                        OS.SelectObject(n8, n14);
                        OS.SelectObject(n9, n13);
                        OS.DeleteDC(n11);
                        OS.DeleteDC(n9);
                        OS.DeleteDC(n8);
                        OS.DeleteObject(n7);
                        device.internal_dispose_GC(n10, null);
                        break;
                    }
                    case 1: {
                        int n17;
                        ICONINFO iCONINFO = new ICONINFO();
                        if (OS.IsWinCE) {
                            Image.GetIconInfo(image, iCONINFO);
                        } else if (!OS.GetIconInfo(image.handle, iCONINFO)) {
                            SWT.error(40);
                        }
                        int n18 = OS.CreateCompatibleDC(n10);
                        int n19 = iCONINFO.hbmColor == 0 ? OS.SelectObject(n11, iCONINFO.hbmMask) : OS.SelectObject(n11, iCONINFO.hbmColor);
                        int n20 = OS.CreateCompatibleBitmap(n11, rectangle.width, rectangle.height);
                        if (n20 == 0) {
                            SWT.error(2);
                        }
                        if ((n17 = OS.CreateBitmap(rectangle.width, rectangle.height, 1, 1, null)) == 0) {
                            SWT.error(2);
                        }
                        int n21 = OS.SelectObject(n18, n17);
                        if (iCONINFO.hbmColor != 0) {
                            OS.SelectObject(n11, iCONINFO.hbmMask);
                        }
                        OS.SelectObject(n11, iCONINFO.hbmMask);
                        OS.BitBlt(n18, 0, 0, rectangle.width, rectangle.height, n11, 0, 0, 0xCC0020);
                        int n22 = OS.SelectObject(n9, n7);
                        if (iCONINFO.hbmColor == 0) {
                            OS.SelectObject(n11, iCONINFO.hbmMask);
                            OS.BitBlt(n9, 0, 0, rectangle.width, rectangle.height, n11, 0, rectangle.height, 0xCC0020);
                        } else {
                            OS.SelectObject(n11, iCONINFO.hbmColor);
                            OS.BitBlt(n9, 0, 0, rectangle.width, rectangle.height, n11, 0, 0, 0xCC0020);
                        }
                        RECT rECT = new RECT();
                        rECT.left = 0;
                        rECT.top = 0;
                        rECT.right = rectangle.width;
                        rECT.bottom = rectangle.height;
                        int n23 = OS.SelectObject(n8, n20);
                        OS.FillRect(n8, rECT, OS.GetSysColorBrush(OS.COLOR_3DFACE));
                        int n24 = OS.CreateSolidBrush(OS.GetSysColor(OS.COLOR_3DSHADOW));
                        int n25 = OS.SelectObject(n8, n24);
                        OS.BitBlt(n8, 0, 0, rectangle.width, rectangle.height, n9, 0, 0, 12060490);
                        OS.BitBlt(n9, 0, 0, rectangle.width, rectangle.height, n18, 0, 0, 0x330008);
                        n24 = OS.CreateSolidBrush(0);
                        OS.DeleteObject(OS.SelectObject(n8, n24));
                        OS.BitBlt(n8, 0, 0, rectangle.width, rectangle.height, n9, 0, 0, 12060490);
                        OS.DeleteObject(OS.SelectObject(n8, n25));
                        OS.SelectObject(n11, n19);
                        OS.DeleteDC(n11);
                        OS.SelectObject(n9, n22);
                        OS.DeleteDC(n9);
                        OS.SelectObject(n8, n23);
                        OS.DeleteDC(n8);
                        OS.SelectObject(n18, n21);
                        OS.DeleteDC(n18);
                        OS.DeleteObject(n7);
                        device.internal_dispose_GC(n10, null);
                        ICONINFO iCONINFO2 = new ICONINFO();
                        iCONINFO2.fIcon = iCONINFO.fIcon;
                        iCONINFO2.hbmMask = n17;
                        iCONINFO2.hbmColor = n20;
                        this.handle = OS.CreateIconIndirect(iCONINFO2);
                        if (this.handle == 0) {
                            SWT.error(2);
                        }
                        OS.DeleteObject(n20);
                        OS.DeleteObject(n17);
                        if (iCONINFO.hbmColor != 0) {
                            OS.DeleteObject(iCONINFO.hbmColor);
                        }
                        OS.DeleteObject(iCONINFO.hbmMask);
                        break;
                    }
                    default: {
                        SWT.error(42);
                    }
                }
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 2: {
                Rectangle rectangle = image.getBounds();
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                ImageData imageData2 = imageData;
                if (!paletteData.isDirect) {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n26 = 0;
                    while (n26 < rGBArray.length) {
                        if (imageData.transparentPixel != n26) {
                            int n27;
                            RGB rGB = rGBArray[n26];
                            int n28 = rGB.red;
                            int n29 = rGB.green;
                            int n30 = rGB.blue;
                            rGB.green = rGB.blue = (n27 = n28 + n28 + n29 + n29 + n29 + n29 + n29 + n30 >> 3);
                            rGB.red = rGB.blue;
                        }
                        ++n26;
                    }
                    imageData2.palette = new PaletteData(rGBArray);
                } else {
                    RGB[] rGBArray = new RGB[256];
                    int n31 = 0;
                    while (n31 < rGBArray.length) {
                        rGBArray[n31] = new RGB(n31, n31, n31);
                        ++n31;
                    }
                    imageData2 = new ImageData(rectangle.width, rectangle.height, 8, new PaletteData(rGBArray));
                    imageData2.maskData = imageData.maskData;
                    imageData2.maskPad = imageData.maskPad;
                    int[] nArray = new int[rectangle.width];
                    int n32 = paletteData.redMask;
                    int n33 = paletteData.greenMask;
                    int n34 = paletteData.blueMask;
                    int n35 = paletteData.redShift;
                    int n36 = paletteData.greenShift;
                    int n37 = paletteData.blueShift;
                    int n38 = 0;
                    while (n38 < rectangle.height) {
                        int n39 = n38 * imageData2.bytesPerLine;
                        imageData.getPixels(0, n38, rectangle.width, nArray, 0);
                        int n40 = 0;
                        while (n40 < rectangle.width) {
                            int n41 = nArray[n40];
                            int n42 = n41 & n32;
                            n42 = n35 < 0 ? n42 >>> -n35 : n42 << n35;
                            int n43 = n41 & n33;
                            n43 = n36 < 0 ? n43 >>> -n36 : n43 << n36;
                            int n44 = n41 & n34;
                            n44 = n37 < 0 ? n44 >>> -n37 : n44 << n37;
                            imageData2.data[n39++] = (byte)(n42 + n42 + n43 + n43 + n43 + n43 + n43 + n44 >> 3);
                            ++n40;
                        }
                        ++n38;
                    }
                }
                this.init(device, imageData2);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
        }
        SWT.error(5);
    }

    public Image(Device device, Rectangle rectangle) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(device, rectangle.width, rectangle.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, imageData);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        if (imageData2.depth != 1) {
            if (imageData2.depth != 4) {
                SWT.error(5);
            }
            PaletteData paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
            ImageData imageData3 = new ImageData(imageData2.width, imageData2.height, 1, paletteData);
            RGB[] rGBArray = imageData2.getRGBs();
            int n = 0;
            while (n < rGBArray.length) {
                if (rGBArray[n].equals(paletteData.colors[0])) break;
                ++n;
            }
            if (n == rGBArray.length) {
                SWT.error(5);
            }
            int[] nArray = new int[imageData2.width];
            int n2 = 0;
            while (n2 < imageData2.height) {
                imageData2.getPixels(0, n2, imageData2.width, nArray, 0);
                int n3 = 0;
                while (n3 < nArray.length) {
                    nArray[n3] = nArray[n3] == n ? 0 : 1;
                    ++n3;
                }
                imageData3.setPixels(0, n2, imageData2.width, nArray, 0);
                ++n2;
            }
            imageData2 = imageData3;
        }
        Image.init(device, this, imageData, imageData2);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream inputStream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(inputStream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String string) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(string));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    int createDIBFromDDB(int n, int n2, int n3, int n4) {
        int[] nArray;
        int n5;
        int n6;
        int n7;
        Object object;
        int n8;
        int n9;
        int n10 = OS.GetDeviceCaps(n, 12);
        int n11 = n10 * (n9 = OS.GetDeviceCaps(n, 14));
        boolean bl = n11 > 8;
        RGB[] rGBArray = null;
        if (!bl) {
            n8 = 1 << n11;
            object = new byte[4 * n8];
            OS.GetPaletteEntries(this.device.hPalette, 0, n8, (byte[])object);
            rGBArray = new RGB[n8];
            int n12 = 0;
            while (n12 < n8) {
                rGBArray[n12] = new RGB((int)(object[n12] & 0xFF), (int)(object[n12 + 1] & 0xFF), (int)(object[n12 + 2] & 0xFF));
                ++n12;
            }
        }
        n8 = OS.IsWinCE && (n11 == 16 || n11 == 32) ? 1 : 0;
        object = new BITMAPINFOHEADER();
        ((BITMAPINFOHEADER)object).biSize = 40;
        ((BITMAPINFOHEADER)object).biWidth = n3;
        ((BITMAPINFOHEADER)object).biHeight = -n4;
        ((BITMAPINFOHEADER)object).biPlanes = 1;
        ((BITMAPINFOHEADER)object).biBitCount = (short)n11;
        ((BITMAPINFOHEADER)object).biCompression = n8 != 0 ? 3 : 0;
        byte[] byArray = bl ? new byte[40 + (n8 != 0 ? 12 : 0)] : new byte[40 + rGBArray.length * 4];
        OS.MoveMemory(byArray, (BITMAPINFOHEADER)object, 40);
        int n13 = 40;
        if (bl) {
            if (n8 != 0) {
                n7 = 0;
                n6 = 0;
                n5 = 0;
                switch (n11) {
                    case 16: {
                        n7 = 31744;
                        n6 = 992;
                        n5 = 31;
                        byArray[n13] = (byte)((n7 & 0xFF) >> 0);
                        byArray[n13 + 1] = (byte)((n7 & 0xFF00) >> 8);
                        byArray[n13 + 2] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray[n13 + 3] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray[n13 + 4] = (byte)((n6 & 0xFF) >> 0);
                        byArray[n13 + 5] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n13 + 6] = (byte)((n6 & 0xFF0000) >> 16);
                        byArray[n13 + 7] = (byte)((n6 & 0xFF000000) >> 24);
                        byArray[n13 + 8] = (byte)((n5 & 0xFF) >> 0);
                        byArray[n13 + 9] = (byte)((n5 & 0xFF00) >> 8);
                        byArray[n13 + 10] = (byte)((n5 & 0xFF0000) >> 16);
                        byArray[n13 + 11] = (byte)((n5 & 0xFF000000) >> 24);
                        break;
                    }
                    case 32: {
                        n7 = 65280;
                        n6 = 0xFF0000;
                        n5 = -16777216;
                        byArray[n13] = (byte)((n7 & 0xFF000000) >> 24);
                        byArray[n13 + 1] = (byte)((n7 & 0xFF0000) >> 16);
                        byArray[n13 + 2] = (byte)((n7 & 0xFF00) >> 8);
                        byArray[n13 + 3] = (byte)((n7 & 0xFF) >> 0);
                        byArray[n13 + 4] = (byte)((n6 & 0xFF000000) >> 24);
                        byArray[n13 + 5] = (byte)((n6 & 0xFF0000) >> 16);
                        byArray[n13 + 6] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n13 + 7] = (byte)((n6 & 0xFF) >> 0);
                        byArray[n13 + 8] = (byte)((n5 & 0xFF000000) >> 24);
                        byArray[n13 + 9] = (byte)((n5 & 0xFF0000) >> 16);
                        byArray[n13 + 10] = (byte)((n5 & 0xFF00) >> 8);
                        byArray[n13 + 11] = (byte)((n5 & 0xFF) >> 0);
                        break;
                    }
                    default: {
                        SWT.error(38);
                        break;
                    }
                }
            }
        } else {
            n7 = 0;
            while (n7 < rGBArray.length) {
                byArray[n13] = (byte)rGBArray[n7].blue;
                byArray[n13 + 1] = (byte)rGBArray[n7].green;
                byArray[n13 + 2] = (byte)rGBArray[n7].red;
                byArray[n13 + 3] = 0;
                n13 += 4;
                ++n7;
            }
        }
        if ((n6 = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        n5 = OS.CreateCompatibleDC(n);
        int n14 = OS.CreateCompatibleDC(n);
        int n15 = OS.SelectObject(n5, n2);
        int n16 = OS.SelectObject(n14, n6);
        OS.BitBlt(n14, 0, 0, n3, n4, n5, 0, 0, 0xCC0020);
        OS.SelectObject(n5, n15);
        OS.SelectObject(n14, n16);
        OS.DeleteDC(n5);
        OS.DeleteDC(n14);
        return n6;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.type == 1) {
            if (OS.IsWinCE) {
                this.data = null;
            }
            OS.DestroyIcon(this.handle);
        } else {
            OS.DeleteObject(this.handle);
        }
        this.handle = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int n = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, 24, bITMAP);
        int n2 = OS.CreateCompatibleDC(n);
        int n3 = OS.SelectObject(n2, this.handle);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (bITMAP.bmBitsPixel <= 8) {
            if (OS.IsWinCE) {
                byte[] byArray = new byte[1];
                OS.MoveMemory(byArray, bITMAP.bmBits, 1);
                byte by = byArray[0];
                int n7 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                byArray[0] = (byte)(this.transparentPixel << 8 - bITMAP.bmBitsPixel | byArray[0] & ~n7);
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                int n8 = OS.GetPixel(n2, 0, 0);
                byArray[0] = by;
                OS.MoveMemory(bITMAP.bmBits, byArray, 1);
                n6 = (n8 & 0xFF0000) >> 16;
                n5 = (n8 & 0xFF00) >> 8;
                n4 = n8 & 0xFF;
            } else {
                byte[] byArray = new byte[4];
                OS.GetDIBColorTable(n2, this.transparentPixel, 1, byArray);
                n6 = byArray[0] & 0xFF;
                n5 = byArray[1] & 0xFF;
                n4 = byArray[2] & 0xFF;
            }
        } else {
            switch (bITMAP.bmBitsPixel) {
                case 16: {
                    n6 = (this.transparentPixel & 0x1F) << 3;
                    n5 = (this.transparentPixel & 0x3E0) >> 2;
                    n4 = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    n6 = (this.transparentPixel & 0xFF0000) >> 16;
                    n5 = (this.transparentPixel & 0xFF00) >> 8;
                    n4 = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    n6 = (this.transparentPixel & 0xFF000000) >>> 24;
                    n5 = (this.transparentPixel & 0xFF0000) >> 16;
                    n4 = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(n2, n3);
        OS.DeleteDC(n2);
        this.device.internal_dispose_GC(n, null);
        return Color.win32_new(this.device, 0x2000000 | n6 << 16 | n5 << 8 | n4);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 0: {
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, 24, bITMAP);
                return new Rectangle(0, 0, bITMAP.bmWidth, bITMAP.bmHeight);
            }
            case 1: {
                if (OS.IsWinCE) {
                    return new Rectangle(0, 0, this.data.width, this.data.height);
                }
                ICONINFO iCONINFO = new ICONINFO();
                OS.GetIconInfo(this.handle, iCONINFO);
                int n = iCONINFO.hbmColor;
                if (n == 0) {
                    n = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n, 24, bITMAP);
                if (n == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                return new Rectangle(0, 0, bITMAP.bmWidth, bITMAP.bmHeight);
            }
        }
        SWT.error(42);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 1: {
                int n;
                int n2;
                Object[] objectArray;
                int n3;
                if (OS.IsWinCE) {
                    return this.data;
                }
                ICONINFO iCONINFO = new ICONINFO();
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetIconInfo(this.handle, iCONINFO);
                int n4 = iCONINFO.hbmColor;
                if (n4 == 0) {
                    n4 = iCONINFO.hbmMask;
                }
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(n4, 24, bITMAP);
                int n5 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n6 = bITMAP.bmWidth;
                if (n4 == iCONINFO.hbmMask) {
                    bITMAP.bmHeight /= 2;
                }
                int n7 = bITMAP.bmHeight;
                int n8 = 0;
                if (n5 <= 8) {
                    n8 = 1 << n5;
                }
                BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
                bITMAPINFOHEADER.biSize = 40;
                bITMAPINFOHEADER.biWidth = n6;
                bITMAPINFOHEADER.biHeight = -n7;
                bITMAPINFOHEADER.biPlanes = 1;
                bITMAPINFOHEADER.biBitCount = (short)n5;
                bITMAPINFOHEADER.biCompression = 0;
                byte[] byArray = new byte[40 + n8 * 4];
                OS.MoveMemory(byArray, bITMAPINFOHEADER, 40);
                int n9 = this.device.internal_new_GC(null);
                int n10 = OS.CreateCompatibleDC(n9);
                int n11 = OS.SelectObject(n10, n4);
                int n12 = 0;
                if (n5 <= 8 && (n3 = this.device.hPalette) != 0) {
                    n12 = OS.SelectPalette(n10, n3, false);
                    OS.RealizePalette(n10);
                }
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n10, n4, 0, n7, 0, byArray, 0);
                OS.MoveMemory(bITMAPINFOHEADER, byArray, 40);
                n3 = bITMAPINFOHEADER.biSizeImage;
                byte[] byArray2 = new byte[n3];
                int n13 = OS.GetProcessHeap();
                int n14 = OS.HeapAlloc(n13, 8, n3);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(n10, n4, 0, n7, n14, byArray, 0);
                OS.MoveMemory(byArray2, n14, n3);
                PaletteData paletteData = null;
                if (n5 <= 8) {
                    objectArray = new RGB[n8];
                    n2 = 40;
                    n = 0;
                    while (n < n8) {
                        objectArray[n] = new RGB(byArray[n2 + 2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2] & 0xFF);
                        n2 += 4;
                        ++n;
                    }
                    paletteData = new PaletteData((RGB[])objectArray);
                } else if (n5 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n5 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n5 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                objectArray = null;
                if (iCONINFO.hbmColor == 0) {
                    objectArray = new byte[n3];
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n10, n4, n7, n7, n14, byArray, 0);
                    OS.MoveMemory((byte[])objectArray, n14, n3);
                } else {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = 40;
                    bITMAPINFOHEADER.biWidth = n6;
                    bITMAPINFOHEADER.biHeight = -n7;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = 1;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[48];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, 40);
                    n2 = 40;
                    byArray[n2 + 6] = -1;
                    byArray[n2 + 5] = -1;
                    byArray[n2 + 4] = -1;
                    byArray[n2 + 7] = 0;
                    OS.SelectObject(n10, iCONINFO.hbmMask);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n10, iCONINFO.hbmMask, 0, n7, 0, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, 40);
                    n3 = bITMAPINFOHEADER.biSizeImage;
                    objectArray = new byte[n3];
                    n = OS.HeapAlloc(n13, 8, n3);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n10, iCONINFO.hbmMask, 0, n7, n, byArray, 0);
                    OS.MoveMemory((byte[])objectArray, n, n3);
                    OS.HeapFree(n13, 0, n);
                    int n15 = 0;
                    while (n15 < objectArray.length) {
                        int n16 = n15++;
                        objectArray[n16] = (RGB)((byte)(~objectArray[n16]));
                    }
                    int n17 = n3 / n7;
                    n15 = 1;
                    while (n15 < 128) {
                        int n18 = ((n6 + 7) / 8 + (n15 - 1)) / n15 * n15;
                        if (n18 == n17) break;
                        ++n15;
                    }
                    objectArray = ImageData.convertPad((byte[])objectArray, n6, n7, 1, n15, 2);
                }
                OS.HeapFree(n13, 0, n14);
                OS.SelectObject(n10, n11);
                if (n12 != 0) {
                    OS.SelectPalette(n10, n12, false);
                    OS.RealizePalette(n10);
                }
                OS.DeleteDC(n10);
                this.device.internal_dispose_GC(n9, null);
                if (iCONINFO.hbmColor != 0) {
                    OS.DeleteObject(iCONINFO.hbmColor);
                }
                if (iCONINFO.hbmMask != 0) {
                    OS.DeleteObject(iCONINFO.hbmMask);
                }
                ImageData imageData = new ImageData(n6, n7, n5, paletteData, 4, byArray2);
                imageData.maskData = (byte[])objectArray;
                imageData.maskPad = 2;
                return imageData;
            }
            case 0: {
                int n;
                BITMAP bITMAP = new BITMAP();
                OS.GetObject(this.handle, 24, bITMAP);
                int n19 = bITMAP.bmPlanes * bITMAP.bmBitsPixel;
                int n20 = bITMAP.bmWidth;
                int n21 = bITMAP.bmHeight;
                boolean bl = bITMAP.bmBits != 0;
                int n22 = this.device.internal_new_GC(null);
                int n23 = this.handle;
                if (OS.IsWinCE && !bl) {
                    boolean bl2 = false;
                    if (this.memGC != null && !this.memGC.isDisposed()) {
                        bl2 = true;
                        GCData gCData = this.memGC.data;
                        if (gCData.hNullBitmap != 0) {
                            OS.SelectObject(this.memGC.handle, gCData.hNullBitmap);
                            gCData.hNullBitmap = 0;
                        }
                    }
                    n23 = this.createDIBFromDDB(n22, this.handle, n20, n21);
                    if (bl2) {
                        int n24;
                        this.memGC.data.hNullBitmap = n24 = OS.SelectObject(this.memGC.handle, this.handle);
                    }
                    bl = true;
                }
                DIBSECTION dIBSECTION = null;
                if (bl) {
                    dIBSECTION = new DIBSECTION();
                    OS.GetObject(n23, 84, dIBSECTION);
                }
                int n25 = 0;
                if (n19 <= 8) {
                    n25 = bl ? dIBSECTION.biClrUsed : 1 << n19;
                }
                byte[] byArray = null;
                BITMAPINFOHEADER bITMAPINFOHEADER = null;
                if (!bl) {
                    bITMAPINFOHEADER = new BITMAPINFOHEADER();
                    bITMAPINFOHEADER.biSize = 40;
                    bITMAPINFOHEADER.biWidth = n20;
                    bITMAPINFOHEADER.biHeight = -n21;
                    bITMAPINFOHEADER.biPlanes = 1;
                    bITMAPINFOHEADER.biBitCount = (short)n19;
                    bITMAPINFOHEADER.biCompression = 0;
                    byArray = new byte[40 + n25 * 4];
                    OS.MoveMemory(byArray, bITMAPINFOHEADER, 40);
                }
                int n26 = OS.CreateCompatibleDC(n22);
                int n27 = OS.SelectObject(n26, n23);
                int n28 = 0;
                if (!bl && n19 <= 8 && (n = this.device.hPalette) != 0) {
                    n28 = OS.SelectPalette(n26, n, false);
                    OS.RealizePalette(n26);
                }
                if (bl) {
                    n = dIBSECTION.biSizeImage;
                } else {
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n26, n23, 0, n21, 0, byArray, 0);
                    OS.MoveMemory(bITMAPINFOHEADER, byArray, 40);
                    n = bITMAPINFOHEADER.biSizeImage;
                }
                byte[] byArray3 = new byte[n];
                if (bl) {
                    if (OS.IsWinCE && this.handle != n23) {
                        OS.MoveMemory(byArray3, dIBSECTION.bmBits, n);
                    } else {
                        OS.MoveMemory(byArray3, bITMAP.bmBits, n);
                    }
                } else {
                    int n29 = OS.GetProcessHeap();
                    int n30 = OS.HeapAlloc(n29, 8, n);
                    if (OS.IsWinCE) {
                        SWT.error(20);
                    }
                    OS.GetDIBits(n26, n23, 0, n21, n30, byArray, 0);
                    OS.MoveMemory(byArray3, n30, n);
                    OS.HeapFree(n29, 0, n30);
                }
                PaletteData paletteData = null;
                if (n19 <= 8) {
                    RGB[] rGBArray = new RGB[n25];
                    if (bl) {
                        if (OS.IsWinCE) {
                            int n31 = 0;
                            int n32 = 0;
                            int n33 = 0;
                            byte[] byArray4 = new byte[1];
                            OS.MoveMemory(byArray4, bITMAP.bmBits, 1);
                            byte by = byArray4[0];
                            int n34 = 255 << 8 - bITMAP.bmBitsPixel & 0xFF;
                            int n35 = 0;
                            while (n35 < n25) {
                                byArray4[0] = (byte)(n35 << 8 - bITMAP.bmBitsPixel | byArray4[0] & ~n34);
                                OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                                int n36 = OS.GetPixel(n26, 0, 0);
                                n33 = (n36 & 0xFF0000) >> 16;
                                n32 = (n36 & 0xFF00) >> 8;
                                n31 = n36 & 0xFF;
                                rGBArray[n35] = new RGB(n31, n32, n33);
                                ++n35;
                            }
                            byArray4[0] = by;
                            OS.MoveMemory(bITMAP.bmBits, byArray4, 1);
                        } else {
                            byte[] byArray5 = new byte[n25 * 4];
                            OS.GetDIBColorTable(n26, 0, n25, byArray5);
                            int n37 = 0;
                            int n38 = 0;
                            while (n38 < rGBArray.length) {
                                rGBArray[n38] = new RGB(byArray5[n37 + 2] & 0xFF, byArray5[n37 + 1] & 0xFF, byArray5[n37] & 0xFF);
                                n37 += 4;
                                ++n38;
                            }
                        }
                    } else {
                        int n39 = 40;
                        int n40 = 0;
                        while (n40 < n25) {
                            rGBArray[n40] = new RGB(byArray[n39 + 2] & 0xFF, byArray[n39 + 1] & 0xFF, byArray[n39] & 0xFF);
                            n39 += 4;
                            ++n40;
                        }
                    }
                    paletteData = new PaletteData(rGBArray);
                } else if (n19 == 16) {
                    paletteData = new PaletteData(31744, 992, 31);
                } else if (n19 == 24) {
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                } else if (n19 == 32) {
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                OS.SelectObject(n26, n27);
                if (n28 != 0) {
                    OS.SelectPalette(n26, n28, false);
                    OS.RealizePalette(n26);
                }
                if (OS.IsWinCE && n23 != this.handle) {
                    OS.DeleteObject(n23);
                }
                OS.DeleteDC(n26);
                this.device.internal_dispose_GC(n22, null);
                ImageData imageData = new ImageData(n20, n21, n19, paletteData, 4, byArray3);
                imageData.transparentPixel = this.transparentPixel;
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
                return imageData;
            }
        }
        SWT.error(42);
        return null;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        int n3 = device.internal_new_GC(null);
        this.handle = OS.CreateCompatibleBitmap(n3, n, n2);
        if (this.handle != 0) {
            int n4 = OS.CreateCompatibleDC(n3);
            int n5 = OS.SelectObject(n4, this.handle);
            OS.PatBlt(n4, 0, 0, n, n2, 15728673);
            OS.SelectObject(n4, n5);
            OS.DeleteDC(n4);
        }
        device.internal_dispose_GC(n3, null);
        if (this.handle == 0) {
            SWT.error(2, null, device.getLastError());
        }
    }

    static void GetIconInfo(Image image, ICONINFO iCONINFO) {
        int[] nArray = Image.init(image.device, null, image.data);
        iCONINFO.hbmColor = nArray[0];
        iCONINFO.hbmMask = nArray[1];
    }

    static int[] init(Device device, Image image, ImageData object) {
        int[] nArray;
        int n;
        Object object2;
        int n2;
        int n3;
        int n4;
        Object object3;
        if (image != null) {
            image.device = device;
        }
        if (((ImageData)object).depth == 1 && ((ImageData)object).getTransparencyType() != 2 || ((ImageData)object).depth == 2) {
            object3 = new ImageData(((ImageData)object).width, ((ImageData)object).height, 4, ((ImageData)object).palette);
            ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, null, null, null, 255, null, 0, 0, 0, ((ImageData)object3).data, ((ImageData)object3).depth, ((ImageData)object3).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object3).width, ((ImageData)object3).height, null, null, null, false, false);
            ((ImageData)object3).transparentPixel = ((ImageData)object).transparentPixel;
            ((ImageData)object3).maskPad = ((ImageData)object).maskPad;
            ((ImageData)object3).maskData = ((ImageData)object).maskData;
            ((ImageData)object3).alpha = ((ImageData)object).alpha;
            ((ImageData)object3).alphaData = ((ImageData)object).alphaData;
            object = object3;
        }
        if (((ImageData)object).palette.isDirect) {
            object3 = ((ImageData)object).palette;
            n4 = ((PaletteData)object3).redMask;
            int n5 = ((PaletteData)object3).greenMask;
            int n6 = ((PaletteData)object3).blueMask;
            n3 = ((ImageData)object).depth;
            n2 = 1;
            PaletteData paletteData = null;
            switch (((ImageData)object).depth) {
                case 8: {
                    n3 = 16;
                    n2 = 0;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 16: {
                    n2 = 0;
                    if (n4 == 31744 && n5 == 992 && n6 == 31) break;
                    paletteData = new PaletteData(31744, 992, 31);
                    break;
                }
                case 24: {
                    if (n4 == 255 && n5 == 65280 && n6 == 0xFF0000) break;
                    paletteData = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (n4 == 65280 && n5 == 0xFF0000 && n6 == -16777216) break;
                    paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (paletteData != null) {
                object2 = new ImageData(((ImageData)object).width, ((ImageData)object).height, n3, paletteData);
                ImageData.blit(1, ((ImageData)object).data, ((ImageData)object).depth, ((ImageData)object).bytesPerLine, ((ImageData)object).getByteOrder(), 0, 0, ((ImageData)object).width, ((ImageData)object).height, n4, n5, n6, 255, null, 0, 0, 0, ((ImageData)object2).data, ((ImageData)object2).depth, ((ImageData)object2).bytesPerLine, n2, 0, 0, ((ImageData)object2).width, ((ImageData)object2).height, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, false, false);
                if (((ImageData)object).transparentPixel != -1) {
                    ((ImageData)object2).transparentPixel = paletteData.getPixel(((PaletteData)object3).getRGB(((ImageData)object).transparentPixel));
                }
                ((ImageData)object2).maskPad = ((ImageData)object).maskPad;
                ((ImageData)object2).maskData = ((ImageData)object).maskData;
                ((ImageData)object2).alpha = ((ImageData)object).alpha;
                ((ImageData)object2).alphaData = ((ImageData)object).alphaData;
                object = object2;
            }
        }
        object3 = ((ImageData)object).palette.getRGBs();
        n4 = OS.IsWinCE && (((ImageData)object).depth == 16 || ((ImageData)object).depth == 32) ? 1 : 0;
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = 40;
        bITMAPINFOHEADER.biWidth = ((ImageData)object).width;
        bITMAPINFOHEADER.biHeight = -((ImageData)object).height;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)((ImageData)object).depth;
        bITMAPINFOHEADER.biCompression = n4 != 0 ? 3 : 0;
        int n7 = bITMAPINFOHEADER.biClrUsed = object3 == null ? 0 : ((RGB[])object3).length;
        byte[] byArray = ((ImageData)object).palette.isDirect ? new byte[40 + (n4 != 0 ? 12 : 0)] : new byte[40 + ((RGB[])object3).length * 4];
        OS.MoveMemory(byArray, bITMAPINFOHEADER, 40);
        n3 = 40;
        if (((ImageData)object).palette.isDirect) {
            if (n4 != 0) {
                PaletteData paletteData = ((ImageData)object).palette;
                int n8 = paletteData.redMask;
                int n9 = paletteData.greenMask;
                int n10 = paletteData.blueMask;
                if (((ImageData)object).getByteOrder() == 0) {
                    byArray[n3] = (byte)((n8 & 0xFF) >> 0);
                    byArray[n3 + 1] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n3 + 2] = (byte)((n8 & 0xFF0000) >> 16);
                    byArray[n3 + 3] = (byte)((n8 & 0xFF000000) >> 24);
                    byArray[n3 + 4] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n3 + 5] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n3 + 6] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n3 + 7] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n3 + 8] = (byte)((n10 & 0xFF) >> 0);
                    byArray[n3 + 9] = (byte)((n10 & 0xFF00) >> 8);
                    byArray[n3 + 10] = (byte)((n10 & 0xFF0000) >> 16);
                    byArray[n3 + 11] = (byte)((n10 & 0xFF000000) >> 24);
                } else {
                    byArray[n3] = (byte)((n8 & 0xFF000000) >> 24);
                    byArray[n3 + 1] = (byte)((n8 & 0xFF0000) >> 16);
                    byArray[n3 + 2] = (byte)((n8 & 0xFF00) >> 8);
                    byArray[n3 + 3] = (byte)((n8 & 0xFF) >> 0);
                    byArray[n3 + 4] = (byte)((n9 & 0xFF000000) >> 24);
                    byArray[n3 + 5] = (byte)((n9 & 0xFF0000) >> 16);
                    byArray[n3 + 6] = (byte)((n9 & 0xFF00) >> 8);
                    byArray[n3 + 7] = (byte)((n9 & 0xFF) >> 0);
                    byArray[n3 + 8] = (byte)((n10 & 0xFF000000) >> 24);
                    byArray[n3 + 9] = (byte)((n10 & 0xFF0000) >> 16);
                    byArray[n3 + 10] = (byte)((n10 & 0xFF00) >> 8);
                    byArray[n3 + 11] = (byte)((n10 & 0xFF) >> 0);
                }
            }
        } else {
            n2 = 0;
            while (n2 < ((RGB[])object3).length) {
                byArray[n3] = (byte)object3[n2].blue;
                byArray[n3 + 1] = (byte)((RGB)object3[n2]).green;
                byArray[n3 + 2] = (byte)((RGB)object3[n2]).red;
                byArray[n3 + 3] = 0;
                n3 += 4;
                ++n2;
            }
        }
        if ((n = OS.CreateDIBSection(0, byArray, 0, nArray = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        object2 = ((ImageData)object).data;
        if (((ImageData)object).scanlinePad != 4 && ((ImageData)object).bytesPerLine % 4 != 0) {
            object2 = ImageData.convertPad((byte[])object2, ((ImageData)object).width, ((ImageData)object).height, ((ImageData)object).depth, ((ImageData)object).scanlinePad, 4);
        }
        OS.MoveMemory(nArray[0], (byte[])object2, ((Object)object2).length);
        int[] nArray2 = null;
        if (((ImageData)object).getTransparencyType() == 2) {
            int n11 = device.internal_new_GC(null);
            int n12 = OS.CreateCompatibleDC(n11);
            OS.SelectObject(n12, n);
            int n13 = OS.CreateCompatibleBitmap(n11, ((ImageData)object).width, ((ImageData)object).height);
            if (n13 == 0) {
                SWT.error(2);
            }
            int n14 = OS.CreateCompatibleDC(n11);
            OS.SelectObject(n14, n13);
            OS.BitBlt(n14, 0, 0, ((ImageData)object).width, ((ImageData)object).height, n12, 0, 0, 0xCC0020);
            device.internal_dispose_GC(n11, null);
            byte[] byArray2 = ImageData.convertPad(((ImageData)object).maskData, ((ImageData)object).width, ((ImageData)object).height, 1, ((ImageData)object).maskPad, 2);
            int n15 = OS.CreateBitmap(((ImageData)object).width, ((ImageData)object).height, 1, 1, byArray2);
            if (n15 == 0) {
                SWT.error(2);
            }
            OS.SelectObject(n12, n15);
            OS.PatBlt(n12, 0, 0, ((ImageData)object).width, ((ImageData)object).height, 0x550009);
            OS.DeleteDC(n12);
            OS.DeleteDC(n14);
            OS.DeleteObject(n);
            if (image == null) {
                nArray2 = new int[]{n13, n15};
            } else {
                ICONINFO iCONINFO = new ICONINFO();
                iCONINFO.fIcon = true;
                iCONINFO.hbmColor = n13;
                iCONINFO.hbmMask = n15;
                int n16 = OS.CreateIconIndirect(iCONINFO);
                if (n16 == 0) {
                    SWT.error(2);
                }
                OS.DeleteObject(n13);
                OS.DeleteObject(n15);
                image.handle = n16;
                image.type = 1;
                if (OS.IsWinCE) {
                    image.data = object;
                }
            }
        } else if (image == null) {
            nArray2 = new int[]{n};
        } else {
            image.handle = n;
            image.type = 0;
            image.transparentPixel = ((ImageData)object).transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = ((ImageData)object).alpha;
                if (((ImageData)object).alpha == -1 && ((ImageData)object).alphaData != null) {
                    int n17 = ((ImageData)object).alphaData.length;
                    image.alphaData = new byte[n17];
                    System.arraycopy(((ImageData)object).alphaData, 0, image.alphaData, 0, n17);
                }
            }
        }
        return nArray2;
    }

    /*
     * Unable to fully structure code
     */
    static int[] init(Device var0, Image var1_1, ImageData var2_2, ImageData var3_3) {
        block13: {
            block12: {
                var5_4 = 0;
                if (!var2_2.palette.isDirect) break block12;
                var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, var2_2.palette);
                break block13;
            }
            var6_6 = new RGB(0, 0, 0);
            var7_7 = var2_2.getRGBs();
            if (var2_2.transparentPixel == -1) ** GOTO lbl27
            var8_8 = new RGB[var7_7.length];
            System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
            if (var2_2.transparentPixel >= var8_8.length) {
                var7_7 = new RGB[var2_2.transparentPixel + 1];
                System.arraycopy(var8_8, 0, var7_7, 0, var8_8.length);
                var9_10 = var8_8.length;
                while (var9_10 <= var2_2.transparentPixel) {
                    var7_7[var9_10] = new RGB(0, 0, 0);
                    ++var9_10;
                }
            } else {
                var8_8[var2_2.transparentPixel] = var6_6;
                var7_7 = var8_8;
            }
            var5_4 = var2_2.transparentPixel;
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
            break block13;
            while (!var7_7[var5_4].equals(var6_6)) {
                ++var5_4;
lbl27:
                // 2 sources

                if (var5_4 < var7_7.length) continue;
            }
            if (var5_4 == var7_7.length) {
                if (1 << var2_2.depth > var7_7.length) {
                    var8_8 = new RGB[var7_7.length + 1];
                    System.arraycopy(var7_7, 0, var8_8, 0, var7_7.length);
                    var8_8[var7_7.length] = var6_6;
                    var7_7 = var8_8;
                } else {
                    var5_4 = -1;
                }
            }
            var4_5 = new ImageData(var2_2.width, var2_2.height, var2_2.depth, new PaletteData(var7_7));
        }
        if (var5_4 == -1) {
            System.arraycopy(var2_2.data, 0, var4_5.data, 0, var4_5.data.length);
        } else {
            var6_6 = new int[var4_5.width];
            var7_7 = (RGB[])new int[var3_3.width];
            var8_9 = 0;
            while (var8_9 < var4_5.height) {
                var2_2.getPixels(0, var8_9, var4_5.width, (int[])var6_6, 0);
                var3_3.getPixels(0, var8_9, var3_3.width, (int[])var7_7, 0);
                var9_10 = 0;
                while (var9_10 < ((Object)var6_6).length) {
                    if (var7_7[var9_10] == false) {
                        var6_6[var9_10] = var5_4;
                    }
                    ++var9_10;
                }
                var4_5.setPixels(0, var8_9, var2_2.width, (int[])var6_6, 0);
                ++var8_9;
            }
        }
        var4_5.maskPad = var3_3.scanlinePad;
        var4_5.maskData = var3_3.data;
        return Image.init(var0, var1_1, var4_5);
    }

    void init(Device device, ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        Image.init(device, this, imageData);
    }

    public int internal_new_GC(GCData gCData) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        int n = this.device.internal_new_GC(null);
        int n2 = OS.CreateCompatibleDC(n);
        this.device.internal_dispose_GC(n, null);
        if (n2 == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.image = this;
            gCData.hFont = this.device.systemFont;
        }
        return n2;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.DeleteDC(n);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (OS.IsWinCE) {
            return;
        }
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        int n = this.device.internal_new_GC(null);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(this.handle, 24, bITMAP);
        int n2 = OS.CreateCompatibleDC(n);
        OS.SelectObject(n2, this.handle);
        int n3 = 1 << bITMAP.bmBitsPixel;
        byte[] byArray = new byte[n3 * 4];
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n4 = OS.GetDIBColorTable(n2, 0, n3, byArray);
        int n5 = this.transparentPixel * 4;
        byArray[n5] = (byte)color.getBlue();
        byArray[n5 + 1] = (byte)color.getGreen();
        byArray[n5 + 2] = (byte)color.getRed();
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        OS.SetDIBColorTable(n2, 0, n4, byArray);
        OS.DeleteDC(n2);
        this.device.internal_dispose_GC(n, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image win32_new(Device device, int n, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = n;
        image.handle = n2;
        image.device = device;
        return image;
    }
}

