/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		TCPSocket.h

	Contains:	TCP socket object
					
	
	$Log: TCPSocket.h,v $
	Revision 1.2  1999/02/19 23:13:22  ds
	Created
	
	
*/

#ifndef __TCPSOCKET_H__
#define __TCPSOCKET_H__

#include <stdio.h>
#include <stdlib.h>

#ifndef __MW_
#include <sys/types.h>
#include <sys/socket.h>
#endif 

#include "Socket.h"
#include "Task.h"
#include "StrPtrLen.h"

class TCPListenerSocket;

class TCPSocket : public Socket
{
	public:

		//TCPSocket takes an optional task object which will get notified when
		//certain events happen on this socket. Those events are:
		//
		//S_DATA:				Data is currently available on the socket.
		//S_CONNECTIONCLOSING:	Client is closing the connection. No longer necessary
		//						to call Close or Disconnect, Snd & Rcv will fail.
		TCPSocket(UInt32 inSocketType, Task *notifytask = NULL)
			: 	Socket(inSocketType, notifytask), fListener(NULL), 
				fRemoteStr(fRemoteBuffer, kIPAddrBufSize)  {}
		virtual ~TCPSocket() {}

		//Open
		QTSS_ErrorCode 	Open() { return Socket::Open(SOCK_STREAM); }

		//ACCESSORS:
		//Returns NULL if not currently available.
		
		UInt32		GetRemoteAddr() { return ntohl(fRemoteAddr.sin_addr.s_addr); }
		UInt16		GetRemotePort() { return ntohs(fRemoteAddr.sin_port); }
		//This function is NOT thread safe!
		StrPtrLen*	GetRemoteAddrStr();
		TCPSocket*	GetListener()			{ return fListener; }
		QTSS_ErrorCode  Connect(UInt32 inRemoteAddr, UInt16 inRemotePort);

		
	protected:

		void 		Set(int inSocket, struct sockaddr_in* remoteaddr, TCPSocket *listener,
							Task* inTask);
							
		enum
		{
			kIPAddrBufSize = 20	//UInt32
		};

		TCPSocket*			fListener;
		struct sockaddr_in 	fRemoteAddr;
		char fRemoteBuffer[kIPAddrBufSize];
		StrPtrLen fRemoteStr;

		
		friend class TCPListenerSocket;
};
#endif // __TCPSOCKET_H__

