/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		StreamDictionary.cpp

	Contains:	
					
	$Log: StreamDictionary.cpp,v $
	Revision 1.3  1999/06/03 01:37:49  lecroy
	added new 'pl' QTSS app packet selctor support, made sure PlayList worked on Linux
	
	Revision 1.2  1999/05/21 22:24:42  lecroy
	more RTSPPlayModule stuff
	changed IDForTag to GenerateIDForSignature
	added RTSPRequestInterface::GetTruncatedAbsoluteURL method
	
	Revision 1.1  1999/05/14 07:45:57  serenyi
	Created
	

	Created: Tue, Mar 2, 1999 @ 4:23 PM
*/


#include "StreamDictionary.h"
#include "MyAssert.h"

StreamDictionary::SigAndID StreamDictionary::sSigAndValueMap[kStdSignatureCount] = {
														{ StreamDictionary::kFractionLostPacketsSig, 0},
														{ StreamDictionary::kTotalLostPacketsSig, 0},
														{ StreamDictionary::kHighestSeqNumberReceivedSig, 0},
														{ StreamDictionary::kJitterSig, 0},
														{ StreamDictionary::kLastSenderReportTimeSig, 0},
														{ StreamDictionary::kLastSenderReportDelaySig, 0},
														{ StreamDictionary::kReceiverBitRateSig, 0},
														{ StreamDictionary::kAvgLateMillisecondsSig, 0},
														{ StreamDictionary::kPercentPacketsLostSig, 0},
														{ StreamDictionary::kAverageBufferDelayMillisecondsSig, 0},
														{ StreamDictionary::kIsGettingBetterSig, 0},
														{ StreamDictionary::kIsGettingWorseSig, 0},
														{ StreamDictionary::kNumEyesSig, 0},
														{ StreamDictionary::kNumEyesActiveSig, 0},
														{ StreamDictionary::kNumEyesPausedSig, 0},
														{ StreamDictionary::kTotalPacketsReceivedSig, 0},
														{ StreamDictionary::kTotalPacketsDroppedSig, 0},
														{ StreamDictionary::kClientBufferFillSig, 0},
														{ StreamDictionary::kFrameRateSig, 0},
														{ StreamDictionary::kExpectedFrameRateSig, 0},
														{ StreamDictionary::kAudioDryCountSig, 0},
														{ StreamDictionary::kTotalPacketsLostSig, 0}
													};


DictValueIDManager StreamDictionary::sStreamDictValueIDManager;


void StreamDictionary::Initialize()
{
	if (sSigAndValueMap[0].valueID == 0)	//hasn't been initialized yet
	{
		//Initialize the dictionary with NULL values..
		for (unsigned int i = 0; i < sizeof(sSigAndValueMap) / sizeof(SigAndID); i++)
		{
			sSigAndValueMap[i].valueID = sStreamDictValueIDManager.GenerateIDForSignature(sSigAndValueMap[i].valueSignature);
		}	
	}
}


StreamDictionary::StreamDictionary() : Dictionary(&sStreamDictValueIDManager)
{}


StreamDictionary::~StreamDictionary()
{
}

void StreamDictionary::SetStandardValue(UInt32 inStdValueIndex, const void* inValueBuffer, UInt32 inBufferLen)
{
	this->SetValue( sSigAndValueMap[inStdValueIndex].valueID, inValueBuffer, inBufferLen );
}


void* StreamDictionary::GetStandardValue(UInt32 inStdValueIndex, void* ioValueBuffer, UInt32 inBufferLen, UInt32* ioValueLen)
{
	this->GetValue( sSigAndValueMap[inStdValueIndex].valueID, ioValueBuffer, inBufferLen, ioValueLen );
	
	return ioValueBuffer;
}

UInt32 StreamDictionary::GetStandardUInt32Value(UInt32 inStdValueIndex, bool* ioWasFound)
{
	UInt32 uint32Val = 0;
	UInt32 actualValueLen = 0;

	uint32Val = *(UInt32*)(this->GetStandardValue(inStdValueIndex, &uint32Val, sizeof(uint32Val), &actualValueLen));	
	if (ioWasFound != NULL)
	{
		*ioWasFound = (actualValueLen!= 0);
	}
	
	
	return uint32Val;
}

UInt16 StreamDictionary::GetStandardUInt16Value(UInt32 inStdValueIndex, bool* ioWasFound )
{
	UInt16 uint16Val = 0;
	UInt32 actualValueLen = 0;

	uint16Val = *(UInt16*)(this->GetStandardValue(inStdValueIndex, &uint16Val, sizeof(uint16Val), &actualValueLen));	
	if (ioWasFound != NULL)
	{
		*ioWasFound = (actualValueLen!= 0);
	}
	
	
	return uint16Val;
}






