/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPWebDebugModule.h

	Contains:	A module that uses the debugging information available in the server
				to present a web page containing that information. Uses the Filter
				module feature of the RTSP API.


	$Log: RTSPWebDebugModule.h,v $
	Revision 1.2  1999/02/19 23:08:43  ds
	Created
	

*/

#ifndef __RTSPWEBDEBUGMODULE_H__
#define __RTSPWEBDEBUGMODULE_H__

#include "RTSPModule.h"


class RTSPWebDebugModule : public RTSPModule
{
	public:
		RTSPWebDebugModule() { 	fRollMask = kFilterModule; }
		virtual ~RTSPWebDebugModule() {}
		
		virtual void FilterRequest(RTSPRequestInterface *request);
		
	private:
	
		static StrPtrLen	sRequestHeader;
		static char*		sResponseHeader;
		static char*		sResponseEnd;
};
#endif __RTSPWEBDEBUGMODULE_H__

