/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPTestModule.cpp

	Contains:	Implements module defined in .h file

	$Log: RTSPTestModule.cpp,v $
	Revision 1.2  1999/02/19 23:08:40  ds
	Created
	

*/

#include "RTSPTestModule.h"

#ifndef __MW_
#include <sys/uio.h>
#endif


RTSPProtocol::RTSPStatusCode RTSPTestModule::ProcessRequest(RTSPRequestInterface *request)
{
	Assert(request != NULL);
	
	switch (request->GetMethod())
	{
		case RTSPProtocol::kDescribeMethod:
		{
			DoDescribe(request);
			break;
		}
		case RTSPProtocol::kSetupMethod:
		{
			DoSetup(request);
			break;
		}
		case RTSPProtocol::kPlayMethod:
		{
			DoPlay(request);
			break;		
		}
		default:
			break;		
	}
	request->Close();
	return RTSPProtocol::kSuccessOK;
}

void RTSPTestModule::DoDescribe(RTSPRequestInterface *request)
{
	static StrPtrLen sContentBase("rtsp://17.221.41.108/holdon.mov/", 32);
	static char* sDescribeData = "v=0\r\no=NoSpacesAllowed 1234 1234 IN IP4 17.255.0.0\r\ns=holdon.mov\r\ni=This is a QTS RTSP session.\r\nu=http://streaming.apple.com/\r\ne=qts@apple.com\r\np=+1-408-767-1234\r\nc=IN IP4 17.221.41.108\r\na=control:/\r\na=range:npt0-249.933\r\nt=0 0\r\nm=video 0 RTP/AVP 96\r\na=rtpmap:96 H263-0898/90000\r\na=control:trackID=4\r\na=x-bufferdelay:2.66\r\nm=audio 0 RTP/AVP 96\r\na=rtpmap:96 X-QT/22050/1\r\na=control:trackID=3\r\na=x-bufferdelay:0.01\r\n";

	//write content type header
	static StrPtrLen sContentType("application/sdp", 15);
	request->AppendHeader(RTSPProtocol::kContentTypeHeader, &sContentType);
	
	//write content base header
	Assert(request->GetQTSSParameter(qtssURLParam) != NULL);
	Assert(request->GetQTSSParameter(qtssURLParam)->Len > 0);
	request->AppendContentBaseHeader(request->GetQTSSParameter(qtssAbsoluteURLParam));
	
	//write content size header
	UInt32 theContentLength = ::strlen(sDescribeData);
	request->AppendContentLength(theContentLength);
	request->SendHeader();
	
	iovec theVec[2] = { 0 };
	theVec[1].iov_base = sDescribeData;
	theVec[1].iov_len = theContentLength;
	
	QTSS_ErrorCode err = request->Send(&theVec[0], 2, theContentLength);
	Assert(err == QTSS_NoErr);
}

void RTSPTestModule::DoSetup(RTSPRequestInterface *request)
{
	static StrPtrLen sServerPortA("1594", 4);
	static StrPtrLen sServerPortB("1595", 4);
	
	StrPtrLen* theAddr = request->GetSession()->GetSocket()->GetLocalAddrStr();
	request->AppendTransportHeader(theAddr, &sServerPortA, &sServerPortB);
	
	StrPtrLen* theSessionID = request->GetHeaderValue(RTSPProtocol::kSessionHeader);
	//if ((theSessionID == NULL) || (theSessionID->Len == 0))
	//{
	//	StrPtrLen newSessionID;
	////	char theSessionIDBuffer[30];
	//	UInt32 theLength = RTSPServerInterface::GenerateNewSessionID(theSessionIDBuffer);
	//	newSessionID.Ptr = theSessionIDBuffer;
	//	newSessionID.Len = theLength;
	//	request->AppendHeader(RTSPProtocol::kSessionHeader, &newSessionID);
	//}
	
	request->SendHeader();
}

void RTSPTestModule::DoPlay(RTSPRequestInterface *request)
{
	static StrPtrLen sURL1("trackID=4", 9); 
	static StrPtrLen sURL2("trackID=3", 9);
	static StrPtrLen sSeq1("18819", 5);
	static StrPtrLen sSeq2("15499", 5);
	static StrPtrLen sRTPTime1("843560749", 9);
	static StrPtrLen sRTPTime2("157045990", 9);
	static StrPtrLen sSsrc1("157018990", 9);
	static StrPtrLen sSsrc2("13432897", 8);

	request->AppendRTPInfoHeader(RTSPProtocol::kRTPInfoHeader, &sURL1, &sSeq1, &sSsrc1, &sRTPTime1);
	request->AppendRTPInfoHeader(RTSPProtocol::kSameAsLastHeader, &sURL2, &sSeq2, &sSsrc2, &sRTPTime2);
	request->SendHeader();
}	
