/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPServerInterface.h

	Contains:	This object defines an interface for getting and setting server-wide
				parameters. RTSP modules can use this interface for doing so.
				
				This object covers all the parameters that are related to the server
				itself, not to a given connection.
	
	$Log: RTSPServerInterface.h,v $
	Revision 1.2  1999/02/19 23:08:37  ds
	Created
	

*/


#ifndef __RTSPSERVERINTERFACE_H__
#define __RTSPSERVERINTERFACE_H__

#include "RTSPPrefs.h"
#include "RTSPMessages.h"
#include "OSMutex.h"
#include "TCPListenerSocket.h"
#include "atomic.h"

class RTSPServerInterface
{
	public:
	
		//getting preferences
		static RTSPPrefs*	GetRTSPPrefs()		{ return sSrvrPrefs; }
		//getting localized text strings
		static RTSPMessages*GetRTSPMessages()	{ return sSrvrMessages; }
		
		//You can signal the server that a fatal error has occurred this way
		static bool			HasFatalErrorOccurred() { return sFatalError; }
		static void			FatalErrorOccurred()	{ sFatalError = true; }
		
		//Returns the DNS name of the "default" IP address
		static StrPtrLen*	GetDefaultDNSName()		{ return sDefaultDNSName; }
		static UInt32		GetDefaultIPAddr()		{ return sDefaultIPAddr; }
	
		//Getting / Setting the number of current RTSP sessions
		static UInt32		GetCurrentSessionCount()	{ return (UInt32)sNumSessions; }
		
		static void			IncrementCurrentSessions() { (void)atomic_add(&sNumSessions, 1); }
		static void			DecrementCurrentSessions() { (void)atomic_sub(&sNumSessions, 1); }
		
		static TCPListenerSocket*	GetFirstListener() { return sFirstListener; }

	protected:

		static RTSPPrefs*			sSrvrPrefs;
		static RTSPMessages*		sSrvrMessages;
		static unsigned int			sSessionID;
		static unsigned int			sNumSessions;
		static UInt32				sDefaultIPAddr;
		static StrPtrLen*			sDefaultDNSName;
		static bool					sFatalError;
		static TCPListenerSocket*   sFirstListener;
};
#endif // __RTSPSERVERINTERFACE_H__

