/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPServer.h

	Contains:	RTSPServer is responsible for bringing up & tearing down the RTSP server,
				and managing all server-wide resources
	
	$Log: RTSPServer.h,v $
	Revision 1.2  1999/02/19 23:08:35  ds
	Created
	

*/

#ifndef __RTSPSERVER_H__
#define __RTSPSERVER_H__

#include "RTSPServerInterface.h"
#include "RTSPSession.h"
#include "RTSPModule.h"

class RTSPListenerSocket : public TCPListenerSocket
{
	public:
	
		RTSPListenerSocket() {}
		virtual ~RTSPListenerSocket() {}
		
		//sole job of this object is to implement this function
		virtual Task*	GetSessionTask(TCPSocket** outSocket);
};

//server is currently very simple. just supports one hardcoded listener.
class RTSPServer : public RTSPServerInterface, public RTSPModuleInterface
{
	public:

		RTSPServer() : fListeners(NULL) {}
		virtual ~RTSPServer();

		bool	Initialize(RTSPPrefs* inPrefs, UInt16 inPortOverride = 0);

	private:

		enum
		{
			kDefaultRTSPPort = 554	//UInt16	
		};		
		static char*			sPortPrefString;
		
		//Returns false if server couldn't listen on ANY of the ports, true otherwise
		bool 					CreateListeners(UInt16 inPortOverride);

		//currently just one listener. this will change
		RTSPListenerSocket** 	fListeners;
};
#endif // __RTSPSERVER_H__


