/*
	File:		RTCPRemoteStatusModule.h

	Contains:	
					
	Created By: Chris LeCroy
	
	Copyright:	Copyright Apple Computer, Inc. 1999
				All rights reserved

	$Log: RTCPRemoteStatusModule.h,v $

	Created: Thu, Mar 4, 1999 @ 2:38 PM
*/


#ifndef _RTCPREMOTESTATUSMODULE_H_
#define _RTCPREMOTESTATUSMODULE_H_

#include "RTPModule.h"

class TCPSocket;
class RemoteStatusPacket;
class RTCPRemoteStatusModule;

class RemoteStatusSocket : public TCPSocket
{
	private:
	
		enum
		{
			kConnecting		= 0x0200 //UInt32
		};
	
		RemoteStatusSocket();
		virtual ~RemoteStatusSocket() {}
		
		bool	IsConnecting() { return (fState & kConnecting); }
	
		virtual void ProcessEvent(Task::EventFlags theEvent);
		
	friend class RTCPRemoteStatusModule;
};

class RTCPRemoteStatusModule : public RTPModule
{
public:
	RTCPRemoteStatusModule();
	virtual ~RTCPRemoteStatusModule() {}
	
	//MODULE ROLES
	virtual void	ProcessRTCPPacket(RTPStream* inStream, StrPtrLen* inPacket);
	virtual void 	PostProcessRTSPRequest(RTSPRequestInterface* inRequest, RTPSession* inSession);
	virtual void	ProcessRTSPSessionClosing(RTSPSessionInterface* inRTSPSession);


private:

	//TIMING CONSTANTS
	
	enum
	{
		//When we attempt to connect to a remote status server, this is the max time we'll
		//wait before timing out.
		kMaxConnectTimeInMilSecs = 90000,//1.5 minutes //UInt32
	
		//When attempting to locate / connect to a remote status server, this is the
		//interval to wait between connection attempts.
		kConnectRetryIntervalInMilSecs = 240000//4 minutes //UInt32
	};

	//UTILITY FUNCTIONS
	
	bool 	CheckConnection();
	void 	CheckAndSendServerStats();
	void 	AddPacketToBuffer(RemoteStatusPacket* inPacket);
	void 	FlushBuffer();
	
	//a buffer for buffering up packets
	enum
	{
		kPacketBufferSizeInBytes = 4096,	//UInt32
		kSendAmountInBytes = 512,			//UInt32
		kServerStatsIntervalInMilSecs = 5000 //SInt64
	};
	
	char 				fPacketBuffer[kPacketBufferSizeInBytes];
	StringFormatter 	fPacketWriter;
	SInt64				fLastServerStatsTime;
	
	//This module responds in multiple roles which may preempt one another.
	OSMutex				fMutex;

	//A special type of non-blocking TCP socket
	RemoteStatusSocket*	fSocket;
	SInt64				fConnectTime;//time that last connect attempt was made
};

#endif //_RTCPREMOTESTATUSMODULE_H_
