/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		OSThread.h

	Contains:	A thread abstraction

	$Log: OSThread.h,v $
	Revision 1.2  1999/02/19 23:06:15  ds
	Created
		

*/

// OSThread.h
#ifndef __OSTHREAD__
#define __OSTHREAD__

#ifndef __MW_
#if __PTHREADS__
#include <errno.h>
#else
#include <mach/mach.h>
#include <mach/cthreads.h>
#endif
#endif

#include "OSHeaders.h"

class OSThread
{

public:
								OSThread(char* threadName);
	virtual 					~OSThread();
	virtual 	void 			Entry();
				void 			Start();
				bool 			IsRunning()			{ return fRunning; }
				bool 			IsStopRequested() 	{ return fStopRequested; }
				void 			SendStopRequest();
				char* 			GetThreadName() 	{ return fName;}
				void 			Join();
				void 			Detach();
				
				//When making a blocking system call, you can frame it
				//with these static function calls to support stop exceptions
				void			MakingBlockingCall() 	{ this->CheckForStopRequest(); }
				void			BlockingCallReturning() { this->CheckForStopRequest(); }

#if DEBUG
				//for tracking how many locks are owned by a thread
				UInt32			GetNumLocksHeld() { return fLocksHeld; }
				void			IncrementLocksHeld(UInt32 tag);
				void			DecrementLocksHeld(UInt32 tag);
				void			PrintLockTagArray();
#endif
#if __PTHREADS__
	static  int			GetErrno() { return errno; }
#else
	static	int			GetErrno() { return cthread_errno();	}	
#endif
	
private:

	void 			ThrowStopRequest();
	void 			CheckForStopRequest();	
	void			SuspendThread();
	void			ResumeThread();
	bool 		WillThrowStopRequest();

#if DEBUG
	static const UInt32 kTagArraySize = 50;
	UInt32	fLocksHeld;
	char	fLockTagArray[kTagArraySize];
#endif

	bool fStopRequested:1;
	bool fStarted:1;
	bool fRunning:1;
	bool fDetached:1;
	bool fJoined:1;
	bool fCancelThrown:1;
	bool fBlockStopRequest:1;
	bool fDoDetach:1;

	char			fName[32];
	UInt32 			fThreadID;
	
	static void		CallEntry(OSThread* thread);		
	static void* 	_Entry(void* inThread);
};

#endif

