/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		NetInfoPrefsSource.h

	Contains:	Implements the PrefsSource interface wrt NetInfo database

	Written by:	Denis Serenyi

	Copyright:	 1998 by Apple Computer, Inc., all rights reserved.

	Change History (most recent first):

	$Log: NetInfoPrefsSource.h,v $
	Revision 1.2  1999/06/08 20:35:34  serenyi
	Allow adding 2 values to one pref, have "rtsp_port" take advantage of this
	
	Revision 1.1  1999/06/01 20:50:04  serenyi
	new files for linux
	

*/

#ifndef __NETINFOPREFSSOURCE_H__
#define __NETINFOPREFSSOURCE_H__

#include "PrefsSource.h"
#include "OSHeaders.h"

class NetInfoPrefsSource : public PrefsSource
{
	public:
	
		NetInfoPrefsSource();
		virtual ~NetInfoPrefsSource() {}
	
		virtual int		GetValue(const char* inKey, char* ioValue);
		virtual int		GetValueByIndex(const char* inKey, UInt32 inIndex, char* ioValue);


		void 	SetValue(const char* inKey, const char* inValue, const char* inSecondValue);
};

#endif //__NETINFOPREFSSOURCE_H__
