########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 10 October 2007 14:20:02 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header$
#
# $Id$
#

from traceback import print_exc
## loading libraries ##
from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

from Volume.VisionInterface.VolumeNodes import vollib
masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

try:
    ## saving node UT-Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    UT_Isocontour_0 = Isocontour(constrkw = {}, name='UT-Isocontour', library=vollib)
    masterNet.addNode(UT_Isocontour_0,281,22)
    apply(UT_Isocontour_0.inputPortByName['isovalue'].widget.configure, (), {'max': 1.0, 'min': 0.0})
    UT_Isocontour_0.inputPortByName['isovalue'].widget.set(1.0, run=False)
except:
    print "WARNING: failed to restore Isocontour named UT-Isocontour in network masterNet"
    print_exc()
    UT_Isocontour_0=None

try:
    ## saving node ReadBinaryRawiv ##
    from Volume.VisionInterface.VolumeNodes import ReadRawivfile
    ReadBinaryRawiv_1 = ReadRawivfile(constrkw = {}, name='ReadBinaryRawiv', library=vollib)
    masterNet.addNode(ReadBinaryRawiv_1,4,7)
    ReadBinaryRawiv_1.inputPortByName['filename'].widget.set("../../../../Volume/Tests/Data/ct_head.rawiv", run=False)
    apply(ReadBinaryRawiv_1.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadRawivfile named ReadBinaryRawiv in network masterNet"
    print_exc()
    ReadBinaryRawiv_1=None

try:
    ## saving node indpol1 ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indpol1_2 = IndexedPolygonsNE(constrkw = {}, name='indpol1')
    masterNet.addNode(indpol1_2,21,125)
    indpol1_2.inputPortByName['name'].widget.set("indpol1", run=False)
    apply(indpol1_2.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indpol1 in network masterNet"
    print_exc()
    indpol1_2=None

try:
    ## saving node indpol2 ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    indpol2_3 = IndexedPolygonsNE(constrkw = {}, name='indpol2')
    masterNet.addNode(indpol2_3,382,204)
    indpol2_3.inputPortByName['name'].widget.set("indpol2", run=False)
    apply(indpol2_3.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore IndexedPolygonsNE named indpol2 in network masterNet"
    print_exc()
    indpol2_3=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_4 = Viewer(constrkw = {}, name='Viewer')
    masterNet.addNode(Viewer_4,233,250)
    ##
        ## Saving State for Viewer
    Viewer_4.vi.TransformRootOnly(0)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 1291, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 68, 'd1scale': 0.012999999999999999}
    apply(Viewer_4.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_4.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    ## End Root Object

    ## Material for root
    if Viewer_4.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_4.vi.rootObject:
        Viewer_4.vi.rootObject.clipP = []
        Viewer_4.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_4=None

try:
    ## saving node macro0 ##
    from NetworkEditor.macros import MacroNode
    macro0_5 = MacroNode(name='macro0')
    masterNet.addNode(macro0_5, 258, 162)
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    _2_8 = IndexedPolygonsNE(constrkw = {}, name='2', library=vizlib)
    macro0_5.macroNetwork.addNode(_2_8,212,133)
    _2_8.inputPortByName['name'].widget.set("2", run=False)
    apply(_2_8.configure, (), {'expanded': True})

    ## saving connections for network macro0 ##
    macro0_5.macroNetwork.freeze()
    input_Ports_6 = macro0_5.macroNetwork.ipNode
    if input_Ports_6 is not None and _2_8 is not None:
        try:
            macro0_5.macroNetwork.connectNodes(
                input_Ports_6, _2_8, "new", "coords", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and _2_8 in network macro0_5.macroNetwork"
    if input_Ports_6 is not None and _2_8 is not None:
        try:
            macro0_5.macroNetwork.connectNodes(
                input_Ports_6, _2_8, "new", "indices", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and _2_8 in network macro0_5.macroNetwork"
    if input_Ports_6 is not None and _2_8 is not None:
        try:
            macro0_5.macroNetwork.connectNodes(
                input_Ports_6, _2_8, "new", "vnormals", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and _2_8 in network macro0_5.macroNetwork"
    if input_Ports_6 is not None and _2_8 is not None:
        try:
            macro0_5.macroNetwork.connectNodes(
                input_Ports_6, _2_8, "new", "parent", blocking=True)
        except:
            print "WARNING: failed to restore connection between input_Ports_6 and _2_8 in network macro0_5.macroNetwork"
    output_Ports_7 = macro0_5.macroNetwork.opNode
    if _2_8 is not None and output_Ports_7 is not None:
        try:
            macro0_5.macroNetwork.connectNodes(
                _2_8, output_Ports_7, "indexedPolygons", "new", blocking=True)
        except:
            print "WARNING: failed to restore connection between _2_8 and output_Ports_7 in network macro0_5.macroNetwork"
    macro0_5.macroNetwork.unfreeze()
    macro0_5.shrink()
except:
    print "WARNING: failed to restore MacroNode named macro0 in network masterNet"
    print_exc()
    macro0_5=None

masterNet.run()
masterNet.freeze()

## saving connections for network parentsAndMacro ##
if ReadBinaryRawiv_1 is not None and UT_Isocontour_0 is not None:
    try:
        masterNet.connectNodes(
            ReadBinaryRawiv_1, UT_Isocontour_0, "grid", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadBinaryRawiv_1 and UT_Isocontour_0 in network masterNet"
if UT_Isocontour_0 is not None and indpol1_2 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, indpol1_2, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and indpol1_2 in network masterNet"
if UT_Isocontour_0 is not None and indpol1_2 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, indpol1_2, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and indpol1_2 in network masterNet"
if UT_Isocontour_0 is not None and indpol1_2 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, indpol1_2, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and indpol1_2 in network masterNet"
if UT_Isocontour_0 is not None and indpol2_3 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, indpol2_3, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and indpol2_3 in network masterNet"
if UT_Isocontour_0 is not None and indpol2_3 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, indpol2_3, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and indpol2_3 in network masterNet"
if indpol2_3 is not None and Viewer_4 is not None:
    try:
        masterNet.connectNodes(
            indpol2_3, Viewer_4, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between indpol2_3 and Viewer_4 in network masterNet"
if UT_Isocontour_0 is not None and indpol2_3 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, indpol2_3, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and indpol2_3 in network masterNet"
macro0_5 = masterNet.nodes[5]
if UT_Isocontour_0 is not None and macro0_5 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, macro0_5, "coords", "2_coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and macro0_5 in network masterNet"
if UT_Isocontour_0 is not None and macro0_5 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, macro0_5, "indices", "2_indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and macro0_5 in network masterNet"
if UT_Isocontour_0 is not None and macro0_5 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_0, macro0_5, "normals", "2_vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_0 and macro0_5 in network masterNet"
if macro0_5 is not None and Viewer_4 is not None:
    try:
        masterNet.connectNodes(
            macro0_5, Viewer_4, "2_indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between macro0_5 and Viewer_4 in network masterNet"
if indpol1_2 is not None and Viewer_4 is not None:
    try:
        masterNet.connectNodes(
            indpol1_2, Viewer_4, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between indpol1_2 and Viewer_4 in network masterNet"
if indpol1_2 is not None and macro0_5 is not None:
    try:
        masterNet.connectNodes(
            indpol1_2, macro0_5, "indexedPolygons", "2_parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between indpol1_2 and macro0_5 in network masterNet"
if macro0_5 is not None and indpol2_3 is not None:
    try:
        masterNet.connectNodes(
            macro0_5, indpol2_3, "2_indexedPolygons", "parent", blocking=True)
    except:
        print "WARNING: failed to restore connection between macro0_5 and indpol2_3 in network masterNet"
masterNet.unfreeze()


def loadSavedStates_Viewer_4(self=Viewer_4, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## End Object root

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(0)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': (0.0, 0.0, 0.0, 1.0), 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 4.0, 4.0, 4.0, 4.0, 7.0, 9.0, 12.0, 14.0, 17.0, 19.0, 22.0, 24.0, 27.0, 29.0, 32.0, 34.0, 37.0, 44.0, 51.0, 57.0, 64.0, 71.0, 78.0, 84.0, 91.0, 98.0, 105.0, 111.0, 118.0, 125.0, 126.0, 128.0, 129.0, 130.0, 132.0, 133.0, 135.0, 136.0, 137.0, 139.0, 140.0, 141.0, 143.0, 144.0, 145.0, 147.0, 148.0, 149.0, 151.0, 152.0, 154.0, 155.0, 156.0, 158.0, 159.0, 160.0, 162.0, 163.0, 164.0, 166.0, 167.0, 168.0, 170.0, 171.0, 173.0, 174.0, 175.0, 177.0, 178.0, 179.0, 181.0, 182.0, 183.0, 185.0, 186.0, 187.0, 189.0, 190.0, 192.0, 193.0, 194.0, 196.0, 197.0, 197.0, 198.0, 198.0, 199.0, 199.0, 199.0, 200.0, 200.0, 200.0, 201.0, 201.0, 202.0, 202.0, 202.0, 203.0, 203.0, 204.0, 204.0, 204.0, 205.0, 205.0, 205.0, 206.0, 206.0, 207.0, 207.0, 207.0, 208.0, 208.0, 209.0, 209.0, 209.0, 210.0, 210.0, 210.0, 211.0, 211.0, 212.0, 212.0, 212.0, 213.0, 213.0, 214.0, 214.0, 214.0, 215.0, 215.0, 215.0, 216.0, 216.0, 217.0, 217.0, 217.0, 218.0, 218.0, 219.0, 219.0, 219.0, 220.0, 220.0, 220.0, 221.0, 221.0, 222.0, 222.0, 222.0, 223.0, 223.0, 224.0, 224.0, 224.0, 225.0, 225.0, 225.0, 226.0, 226.0, 227.0, 227.0, 227.0, 228.0, 228.0, 228.0, 229.0, 229.0, 230.0, 230.0, 230.0, 231.0, 231.0, 232.0, 232.0, 232.0, 233.0, 233.0, 233.0, 234.0, 234.0, 235.0, 235.0, 235.0, 236.0, 236.0, 237.0, 237.0, 237.0, 238.0, 238.0, 238.0, 239.0, 239.0, 240.0, 240.0, 240.0, 241.0, 241.0, 242.0, 242.0, 242.0, 243.0, 243.0, 243.0, 244.0, 244.0, 245.0, 245.0, 245.0, 246.0, 246.0, 247.0, 247.0, 247.0, 248.0, 248.0, 248.0, 249.0, 249.0, 250.0, 250.0, 250.0, 251.0, 251.0, 252.0, 252.0, 252.0, 253.0, 253.0, 253.0, 254.0, 254.0, 255.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.012999999999999999}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': (0.0, 0.0, 0.0, 1.0), 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_4.restoreStates_cb = Viewer_4.restoreStatesFirstRun = loadSavedStates_Viewer_4
Viewer_4.menu.add_separator()
Viewer_4.menu.add_command(label='Restore states', command=Viewer_4.restoreStates_cb)

#masterNet.run()
