/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeUniqueIterator<T>
implements Iterator<T> {
    private final Set<Object> seenValues = new HashSet<Object>();
    private final LinkedList<Iterator<? extends T>> iterators = new LinkedList();
    private Iterator<? extends T> curr;
    private T next;
    private boolean needSeek = true;

    CompositeUniqueIterator(Iterator<? extends T> i1, Iterator<? extends T> i2) {
        assert (i1 != null);
        assert (i2 != null);
        this.curr = i1;
        this.iterators.add(i2);
    }

    void add(Iterator<? extends T> it) {
        assert (it != null);
        this.iterators.add(it);
    }

    @Override
    public boolean hasNext() {
        this.seekIfNeeded();
        return !this.needSeek;
    }

    @Override
    public T next() {
        this.seekIfNeeded();
        this.needSeek = true;
        return this.next;
    }

    @Override
    public void remove() {
        this.curr.remove();
    }

    private void seekIfNeeded() {
        if (this.needSeek) {
            while (true) {
                if (this.curr.hasNext()) {
                    this.next = this.curr.next();
                    if (!this.seenValues.add(this.getKey(this.next))) continue;
                    this.needSeek = false;
                    return;
                }
                if (this.iterators.isEmpty()) {
                    return;
                }
                this.curr = this.iterators.removeFirst();
            }
        }
    }

    protected Object getKey(Object value) {
        return value;
    }
}

