/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

public class ScriptException
extends Exception {
    private final String fileName;
    private final int lineNumber;
    private final int columnNumber;

    public ScriptException(String message) {
        this(message, null, -1, -1);
    }

    public ScriptException(Exception e) {
        super(e.getMessage(), e);
        this.fileName = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public ScriptException(String message, String fileName, int lineNumber) {
        this(message, fileName, lineNumber, -1);
    }

    public ScriptException(String message, String fileName, int lineNumber, int columnNumber) {
        super(message);
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public String getMessage() {
        if (this.fileName != null) {
            StringBuffer message = new StringBuffer(super.getMessage() == null ? "" : super.getMessage());
            if (this.lineNumber != -1) {
                message.append(" at [").append(this.lineNumber);
                if (this.columnNumber != -1) {
                    message.append(", ").append(this.columnNumber);
                }
                message.append("]");
            }
            message.append(" in file ").append(this.fileName);
            return message.toString();
        }
        return super.getMessage();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

