/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;

public class JavaSecuredFile
extends File {
    public JavaSecuredFile(File parent, String child) {
        super(parent, child);
    }

    public JavaSecuredFile(String pathname) {
        super(pathname);
    }

    public JavaSecuredFile(String parent, String child) {
        super(parent, child);
    }

    public JavaSecuredFile(URI uri) {
        super(uri);
    }

    public File getParentFile() {
        String parent = this.getParent();
        if (parent != null) {
            return new JavaSecuredFile(parent);
        }
        return null;
    }

    public File getAbsoluteFile() {
        String absolute = this.getAbsolutePath();
        if (absolute != null) {
            return new JavaSecuredFile(absolute);
        }
        return null;
    }

    public String getCanonicalPath() throws IOException {
        try {
            return super.getCanonicalPath();
        }
        catch (SecurityException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public File getCanonicalFile() throws IOException {
        String canonical = this.getCanonicalPath();
        if (canonical != null) {
            return new JavaSecuredFile(canonical);
        }
        return null;
    }

    public boolean canRead() {
        try {
            return super.canRead();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean canWrite() {
        try {
            return super.canWrite();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean exists() {
        try {
            return super.exists();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean isDirectory() {
        try {
            return super.isDirectory();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean isFile() {
        try {
            return super.isFile();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean isHidden() {
        try {
            return super.isHidden();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public long lastModified() {
        try {
            return super.lastModified();
        }
        catch (SecurityException ex) {
            return 0L;
        }
    }

    public long length() {
        try {
            return super.length();
        }
        catch (SecurityException ex) {
            return 0L;
        }
    }

    public boolean createNewFile() throws IOException {
        try {
            return super.createNewFile();
        }
        catch (SecurityException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public boolean delete() {
        try {
            return super.delete();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public String[] list() {
        try {
            return super.list();
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public String[] list(FilenameFilter filter) {
        try {
            return super.list(filter);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public File[] listFiles() {
        try {
            return super.listFiles();
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public File[] listFiles(FilenameFilter filter) {
        try {
            return super.listFiles(filter);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public File[] listFiles(FileFilter filter) {
        try {
            return super.listFiles(filter);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public boolean mkdir() {
        try {
            return super.mkdir();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean mkdirs() {
        try {
            return super.mkdirs();
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean renameTo(File dest) {
        try {
            return super.renameTo(dest);
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean setLastModified(long time) {
        try {
            return super.setLastModified(time);
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    public boolean setReadOnly() {
        try {
            return super.setReadOnly();
        }
        catch (SecurityException ex) {
            return false;
        }
    }
}

