/////////////////////////////////////////////////////////////////////////////
// Purpose:     XML resources editor
// Author:      Vaclav Slavik
// Created:     2000/05/05
// RCS-ID:      $Id: xmlhelpr.h,v 1.4.2.1 2005/06/20 17:35:35 MR Exp $
// Copyright:   (c) 2000 Vaclav Slavik
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _XMLHELPR_H_
#define _XMLHELPR_H_

// some helper functions:

void XmlWriteValue(wxXmlNode *parent, const wxString& name, const wxString& value);
wxString XmlReadValue(wxXmlNode *parent, const wxString& name);

// Finds a subnode of parent named <name>
// (may be recursive, e.g. "name1/name2" means
// <parent><name1><name2>value</name2></name1></parent>
wxXmlNode *XmlFindNode(wxXmlNode *parent, const wxString& name);
wxXmlNode *XmlFindNodeSimple(wxXmlNode *parent, const wxString& path);

wxString XmlGetClass(wxXmlNode *parent);
void XmlSetClass(wxXmlNode *parent, const wxString& classname);

#endif 
