"""
Code generator functions for wxRadioBox objects

@copyright: 2002-2007 Alberto Griggio
@copyright: 2014-2016 Carsten Grohmann
@license: MIT (see LICENSE.txt) - THIS PROGRAM COMES WITH NO WARRANTY
"""

import common
import wcodegen
import radio_box_base
from ChoicesCodeHandler import *


class PythonRadioBoxGenerator(radio_box_base.RadioBoxMixin,
                              wcodegen.PythonWidgetCodeWriter):
    tmpl = '%(name)s = %(klass)s(%(parent)s, %(id)s, %(label)s, ' \
           'choices=[%(choices)s], majorDimension=%(majorDimension)s' \
           '%(style)s)\n'

# end of class PythonRadioBoxGenerator


class CppRadioBoxGenerator(radio_box_base.RadioBoxMixin,
                           wcodegen.CppWidgetCodeWriter):
    tmpl = '%(name)s = new %(klass)s(%(parent)s, %(id)s, %(label)s, ' \
           'wxDefaultPosition, wxDefaultSize, %(choices_len)s, ' \
           '%(name)s_choices, %(majorDimension)s, %(style)s);\n'

    prefix_style = False

# end of class CppRadioBoxGenerator


def xrc_code_generator(obj):
    xrcgen = common.code_writers['XRC']

    class RadioBoxXrcObject(xrcgen.DefaultXrcObject):
        def write_property(self, name, val, outfile, tabs):
            if name == 'choices':
                xrc_write_choices_property(self, outfile, tabs)
            else:
                xrcgen.DefaultXrcObject.write_property(self, name, val,
                                                       outfile, tabs)

    # end of class RadioBoxXrcObject

    return RadioBoxXrcObject(obj)


def initialize():
    klass = 'wxRadioBox'
    common.class_names['EditRadioBox'] = klass
    common.register('python', klass, PythonRadioBoxGenerator(klass),
                    'choices', ChoicesCodeHandler)
    common.register('C++', klass, CppRadioBoxGenerator(klass),
                    'choices', ChoicesCodeHandler)
    common.register('XRC', klass, xrc_code_generator,
                    'choices', ChoicesCodeHandler)
