/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MDefs_H
#define	JT6MDefs_H

const int JT6M_SAMPLE_RATE    = 11025;
const int JT6M_SYMBOL_LENGTH  = 512;
const int JT6M_FFT_LENGTH     = JT6M_SYMBOL_LENGTH;

const int JT6M_MAX_AUDIO_DATA = 30 * JT6M_SAMPLE_RATE;

const double JT6M_SEND_VOLUME = 0.5;

const int JT6M_SYNCBIN_FIRST = 23;		// 495 Hz
const int JT6M_SYNCBIN_LAST  = 70;		// 1507 Hz

const double JT6M_SYNC_POS_COEFF =  1.0;
const double JT6M_SYNC_NEG_COEFF = -1.0;

const int JT6M_SKIP_FACTOR = 128;       // For the preliminary correlation
const int JT6M_SKIP_RATE   = JT6M_SYMBOL_LENGTH / JT6M_SKIP_FACTOR;

const int JT6M_MAX_MESSAGE_LENGTH = 30;
const int JT6M_ALPHABET_COUNT     = 43;

const int JT6M_SOUNDBUF_LENGTH = 2048;

// For the GUI
const wxString JT6M_LOGFILE_NAME  = wxT("jt6m");
const wxString JT6M_LOGFILE_EXT   = wxT("log");
const wxString JT6M_MESSAGES_NAME = wxT("jt6m");
const wxString JT6M_MESSAGES_EXT  = wxT("cum");

const wxString title = wxT("JT6M (WS Tools 0.4.8d)");

const int JT6M_MAX_MESSAGES    = 6;

const int JT6M_GRAPH_WIDTH     = 570;
const int JT6M_AUDIO_WIDTH     = 25;
const int JT6M_GRAPH_HEIGHT    = 125;
const int JT6M_MESSAGES_WIDTH  = 600;
const int JT6M_MESSAGES_HEIGHT = 150;

const int JT6M_NUM_COLOURS     = 16;

// For the configuration
const wxString JT6M_VENDOR_NAME = wxT("G4KLX");
const wxString JT6M_APPL_NAME   = wxT("JT6M");

#endif
