/*

Sound audio library
   
Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: config.c,v 1.5 1999/11/17 13:16:49 daeron Exp $

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include "wsound.h"

#include <WUtil.h>
#include <assert.h>



int makeLocalConfiguration(void);

proplist_t loadLocalConfiguration(void);
extern char *getLocalConfigurationPath (void);
extern char *getGlobalConfigurationPath (void);
extern void wAbort(void);
extern int checkForFile (char *instrpath);


void
SLoadConfig(void)
{
#ifdef DEBUG
	fprintf(stderr, "-=> Loading configuration\n");
#endif
	WMSoundDB = loadLocalConfiguration();
	if (! WMSoundDB) {
#ifdef DEBUG
		fprintf(stderr, " >> Failure trying to read local domain\n");
#endif
		/* Try to duplicate the global configuration file */
		if (makeLocalConfiguration() != 0) {
			sfatal(SMessageForError(SErrorCode));
			wAbort();
		}
	}
#ifdef DEBUG
	fprintf(stderr, "<=- Configuration loaded\n");
#endif
	WMSoundDBLoaded = True;
}


void
SSyncConfig(void)
{
	PLDeepSynchronize(WMSoundDB);
}


int makeLocalConfiguration(void)
{
	char		*globalPath = getGlobalConfigurationPath();
	char		*localPath = getLocalConfigurationPath();
	int		errorcode = -1;
	proplist_t	gdb;
	proplist_t	filename = PLMakeString(localPath);
	
#ifdef DEBUG
	fprintf(stderr, " >> Duplicating global domain\n");
#endif
	if (checkForFile(globalPath) != 0) {
		SErrorCode = SERR_NOGCONFIG;	/* Global configuration does not exist */
	}
	else {
		/* Load Global Domain file */
		gdb = PLGetProplistWithPath(globalPath);
		if (gdb) {
			if (! PLIsDictionary(gdb)) {
				PLRelease(gdb);
				gdb = NULL;
				
				SErrorCode = SERR_LOADGCONFIG;
			}
			else {
				WMSoundDB = PLSetFilename(gdb, filename);	/* Apparently we must not free gdb */
				WMSoundDBLoaded = True;
				PLSave(WMSoundDB, YES);
				errorcode = 0;
			}
		}
		else {
			SErrorCode = SERR_LOADGCONFIG;
		}
	}

	PLRelease(filename);
	if (globalPath)
		free(globalPath);
	if (localPath)
		free(localPath);
	
	return errorcode;
}



proplist_t
loadLocalConfiguration(void)
{
	proplist_t	db = NULL;
	char		*localPath = getLocalConfigurationPath();
	
	db = PLGetProplistWithPath(localPath);
	if (db) {
		if (!PLIsDictionary(db)) {
			PLRelease(db);
			db = NULL;

			SErrorCode = SERR_LOADLCONFIG;
		}
	}
	
	if (localPath)
		free(localPath);
	return db;
}

