/* Copyright 2001-2005 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM Time Scale Modification for Audio.

   MFFM Time Scale Modification for Audio is free software; you can redistribute
 it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM Time Scale Modification for Audio is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM Time Scale Modification for Audio
 */
#include <mffm/X/masterCounterInterface.H>
#include <mffm/X/XPMDigits.H>

//#include <audiere.h>
#include "WSOLA4Audiere.H"
using namespace audiere;

#define DEF_TAU 1.0 //default TSM factor 0.5 -> double speed, 2.0 -> half speed
#define TAU_DEG 2 //The max tau whole digit value
#define TAU_DEG_FRAC 1000 //The max fractional digits tau value

#define FIELDCOUNT 2

static void quit(void *wid, gpointer data){
  gtk_main_quit();
}

class tempPtrs {//Gui needs this class to pass tau changes
public:
  WSOLA4Audiere *ws;
  MasterCounterInterface<FieldInterface, FIELDCOUNT> *mc;
};

static void lockTau(void *wid, gpointer data){
  tempPtrs *tp=(tempPtrs *)data;
  cout<<tp->mc->getCount()<<endl;
  tp->ws->setTau((float)tp->mc->getCount()/(float)TAU_DEG_FRAC);
}

int main(int argc, char *argv[]){

  if (argc<2){
    cout<<"Useage:\n\t"<<argv[0]<<" audioFileName.ext"<<endl;
    return -1;
  }

  //Audiere stream stuff
  cout<<"opening stream "<<argv[1]<<endl;

  SampleSource* source=OpenSampleSource(argv[1]);
  if (!source) {
    cout<<"Error: main: couldn't open source "<<argv[1]<<endl;
    return -1;
  }
  //  source->setPosition(0);

  SampleFormat sam;
  int ftbread=1024, fps=1024, channel=1;
  source->getFormat(channel,fps,sam);

  //OutputStreamPtr stream((device, new WSOLA4Audiere(1.0)));
  int startWaveform=0, endWaveform=0;
  WSOLA4Audiere *wsolaSource=new WSOLA4Audiere(source,1.0,startWaveform,endWaveform);
  if (!wsolaSource) {
    cout<<"Error: main: couldn't open source "<<argv[1]<<endl;
    return -1;
  }


  //Gui init stuff
  gtk_init( &argc, &argv );

  GtkInterface topWindow;
  XPMDigits temp(&topWindow);
  
  //Set up an interface to the speed tau
  MasterCounterInterface<FieldInterface, FIELDCOUNT> *masterCnt=new MasterCounterInterface<FieldInterface, FIELDCOUNT>(0, TAU_DEG, TAU_DEG_FRAC);
  masterCnt->setMinCount(500);
  masterCnt->setMaxCount(2000);

  //Set up the gui ptrs
  tempPtrs tempPtr;
  tempPtr.mc=masterCnt;
  tempPtr.ws=wsolaSource;

  // Quit button
  Buttons buttons; buttons<<BUTTONLABELSTRUCT{"Quit", quit, NULL};
  buttons<<BUTTONLABELSTRUCT{"Lock Tau", lockTau, &tempPtr};

  //masterCnt->eventReSetup((void (*)())lockTau, &tempPtr);

  HBox hBox;
  hBox<< buttons.grab(1);
  hBox<< masterCnt->getWidget();
  hBox<< buttons.grab(2);
  hBox.show();
  topWindow<< hBox.getWidget();

  AudioDevicePtr device=(OpenDevice());
  if (!device) {
    cout<<"optput device open failed"<<endl;
    delete masterCnt;
    exit(-1);
  }

  //OutputStreamPtr streamWSOLA(OpenSound(device,new WSOLA4Audiere(source,DEF_TAU),true));
  //OutputStreamPtr streamWSOLA(OpenSound(device,new WSOLA4Audiere(source),true));
  OutputStreamPtr streamWSOLA(OpenSound(device,wsolaSource,true));
  //OutputStreamPtr streamFILE(OpenSound(device,source,true));
  streamWSOLA->play();
  //streamFILE->play();

  //gtk_timeout_add(100 /* 100 ms */, updateCheck, &masterCnt);
  gtk_main();

  delete masterCnt;
  
  return 0;  
}

/* old stuff

  //SampleSource* source=OpenSampleSource(argv[1]);
  //  audiere::SampleSourcePtr source = audiere::OpenSampleSource(filename);
  //if (!source) {
  //  cout<<"Error: main: couldn't open source "<<argv[1]<<endl;
  //  delete masterCnt;
  //  return -1;
  //}
  SampleSource* source;
  audiere::LoopPointSourcePtr loop_source = audiere::CreateLoopPointSource(source);
  if (loop_source) {
    source = loop_source.get();
  }
  
  //void * tempSF=new StreamFrame(this, "Stream: ", loop_source.get());
  WSOLA4Audiere wsolaSource(source,DEF_TAU);

  //audiere::OutputStreamPtr stream = audiere::OpenSound(device,source,true);
  audiere::OutputStreamPtr stream = audiere::OpenSound(device,&wsolaSource,true);
  //  OutputStreamPtr stream(OpenSound(device, argv[1], true));
  if (!stream) {
    cout<<"Error: main: couldn't open stream"<<endl;
    delete masterCnt;
    return -1;
  }


  // let's start the background music first
  stream->setRepeat(true);

  //  stream->setVolume(0.5f); // 50% volume
  stream->play();

  // now play a sound effect
  //  sound->play();
  */
