// $Id: UIGtk.cpp,v 1.5 2002/04/16 23:21:15 xfred_1 Exp $

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIGtk.h"

#include "CallbacksBrowse.h"
#include "CallbacksFile.h"
#include "CallbacksHeight.h"
#include "CallbacksEdit.h"
#include "CallbacksGround.h"

#include "ModelSelector.h"

#include "interface.h"
#include "support.h"

#include <locale.h>

#include "../Application.h"

UIGtk::UIGtk()
{}

UIGtk::~UIGtk()
{}

void
UIGtk::InitEntityOps(const EntityOpList &ops)
{
   if (!g_MainWindow)
      return; 

   ::InitEntityOps (ops);
}

void
UIGtk::InitHeightOps(const HeightOpList &ops)
{
   if (!g_MainWindow)
      return; 

   ::InitHeightOps (ops);
}

void
UIGtk::AddGroundToList (Ark::Material *mat)
{ 
   if (!g_MainWindow)
      return; 

   ::AddGroundToList (mat);
}

void
UIGtk::AddGroundsToList (const Ark::MaterialList &matlist)
{
   if (!g_MainWindow)
      return; 

   ::AddGroundsToList (matlist);
}
     
void
UIGtk::UpdateBrowseInfo (Ark::Vector3 pov, Ark::Vector3 la)
{
   if (!g_MainWindow)
      return; 

   ::UpdateBrowseInfo (pov, la);
}

// Enable/disable "Save" menu entry.
void
UIGtk::EnableSaveCommands (bool en)
{
   if (!g_MainWindow)
      return; 

   ::EnableSaveCommands (en);
}

// Enable/disable Undo/Redo commands.
void
UIGtk::EnableUndoCommands (bool en, const std::string &s)
{
   if (!g_MainWindow)
      return; 

   ::EnableUndoCommands (en, s.c_str());
}

void
UIGtk::EnableRedoCommands (bool en, const std::string &s)
{
   if (!g_MainWindow)
      return; 

   ::EnableRedoCommands (en, s.c_str());
}


// Entity edition
std::string
UIGtk::SelectModel(const std::string &prev)
{
   return g_ModelSelector.SelectModel (prev);
}

Ark::ClassDef *
UIGtk::SelectClass()
{
   return NULL;
}

std::string
UIGtk::SelectTemplate(Ark::ClassDef *cd)
{
   return "";
}

extern void EntityEditor_UpdateAll(GtkWidget *);

bool
UIGtk::EditEntity (Entity *ent)
{
   GtkWidget* widget = create_EntityEditorWindow ();
   gtk_object_set_data(GTK_OBJECT(widget), "entity", ent);
   EntityEditor_UpdateAll (widget);
   gtk_widget_show (widget);
   return false;
}

// Create the main window, and loop..
void
UIGtk::MainLoop (int argc, char **argv)
{
#ifdef ENABLE_NLS
  bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain(PACKAGE);
#endif

//  gtk_set_locale();
  gtk_init(&argc, &argv);

  add_pixmap_directory("pixmaps");

  Application* app = new Application (this);
  
  g_MainWindow = create_WorldedMainWindow();
  gtk_widget_show( g_MainWindow );
  gtk_main();

  //g_ModelSelector.SelectModel ("");

  delete app;
}

GtkWidget* g_MainWindow = 0;
