// $Id: CallbacksWorldProps.cpp,v 1.2 2003/02/09 21:07:05 mrq Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "interface.h"
#include "support.h"
#include "World.h"
#include "Application.h"

void
on_skytonemapBrowse_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_worldnameEntry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_skysizeSpin_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_fogColor_color_changed              (GtkColorSelection *colorselection,
                                        gpointer         user_data)
{
   gdouble color[3];
   gtk_color_selection_get_color(colorselection, color);

   g_Application->GetWorld()->SetFogColor(Ark::Color(scalar(color[0]),
						     scalar(color[1]),
						     scalar(color[2])));
   g_Application->GetTerrain()->Update();
}

void
on_athmoFogDensity_changed             (GtkAdjustment   *adj,
                                        gpointer         user_data)
{
   g_Application->GetWorld()->SetFogDensity(adj->value);
   g_Application->GetTerrain()->Update();
}

void
on_athmoTimeOfDay_changed             (GtkAdjustment   *adj,
                                       gpointer         user_data)
{
   g_Application->GetWorld()->SetTimeOfDay(adj->value);
   g_Application->GetTerrain()->Update();
}

void CreateWorldPropsWindow()
{
   GtkWidget *wid = create_WorldPropertiesWindow();

   // Fog density
   GtkWidget *hscale = lookup_widget (wid, "athmoFogDensity");
   gtk_adjustment_set_value(gtk_range_get_adjustment(GTK_RANGE (hscale)),
			    g_Application->GetWorld()->GetFogDensity());
   gtk_signal_connect
      (GTK_OBJECT (gtk_range_get_adjustment(GTK_RANGE (hscale))),
       "value-changed",
       GTK_SIGNAL_FUNC (on_athmoFogDensity_changed), NULL);



   // Time of day
   hscale = lookup_widget (wid, "athmoTimeOfDay");
   gtk_adjustment_set_value(gtk_range_get_adjustment(GTK_RANGE (hscale)),
			    g_Application->GetWorld()->GetTimeOfDay());
   gtk_signal_connect
      (GTK_OBJECT (gtk_range_get_adjustment(GTK_RANGE (hscale))),
       "value-changed",
       GTK_SIGNAL_FUNC (on_athmoTimeOfDay_changed), NULL);

   // Fog color
   gdouble color[3];
   Ark::Color fc = g_Application->GetWorld()->GetFogColor();
   color[0] = fc.R; color[1] = fc.G; color[2] = fc.B;

   GtkWidget *colorsel = lookup_widget (wid,"fogColor");
   gtk_color_selection_set_color(GTK_COLOR_SELECTION(colorsel), color);

   gtk_widget_show_all(wid);
}

