// $Id: ETMove.cpp,v 1.4 2003/02/08 13:14:51 mrq Exp $

#include "ETMove.h"

#include "Application.h"
#include <sstream>

ETMove::ETMove (World *world) : EntityTool (world), m_Entity (NULL)
{}

ETMove::~ETMove()
{
   if (m_Entity) m_Entity->Unref();
}

/// Apply tool at (x,z)
void
ETMove::Apply3D(Ark::Vector3 newpos, const Ark::Collision &col)
{
   if (col.GetType() == Ark::Collision::ENTITY && m_Entity == NULL)
   {
      m_Entity = static_cast<Entity*>(col.m_Entity);
      m_Entity->Ref();
      m_OldPos = m_Entity->m_MState.m_Position;
      return;
   }
   else if (m_Entity)
   {
      m_NewPos = newpos; //col.m_Pos;
      m_Entity->SetPosition(m_NewPos);
      g_Application->GetWorld()->Update(0.0);
   }
}

/// Update or reset tool
void
ETMove::Update()
{
   if (m_Entity)
   {
      m_Entity->Unref();
      m_Entity = NULL;
   }
}

/// Create a command with a correct state.
Command*
ETMove::CreateCommand()
{
   if (m_Entity == NULL)
      return NULL;
   else
   {
      m_Entity->SetPosition(m_OldPos);
      Command *c = new ECMove (g_Application->GetWorld(), m_Entity, m_NewPos);
      c->Execute();
      return c;
   }
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

ECMove::ECMove(World *world, Entity *entity, Ark::Vector3 newpos) : 
   m_World (world),
   m_Entity (entity)
{
   assert (m_Entity != 0);
   m_Entity->Ref();

   m_NewPos = newpos;
   m_OldPos = m_Entity->m_MState.m_Position;
}

ECMove::~ECMove()
{
   if (m_Entity)
      m_Entity->Unref();
}

/// Return the command type.
std::string
ECMove::Type() const
{
   return "Move entity";
}

/// Execute this command.
void
ECMove::Execute()
{
   //std::cerr << "Execute move";
   m_Entity->SetPosition(m_NewPos); 
   g_Application->GetWorld()->Update(0.0);
}

/// Undo the action done by this command.
void
ECMove::Unexecute()
{
   //std::cerr << "Unexecute move";
   m_Entity->SetPosition(m_OldPos);
   g_Application->GetWorld()->Update(0.0);
}
