// Win32InputMonitor.hh --- ActivityMonitor for Win32
//
// Copyright (C) 2002, 2004 Raymond Penners <raymond@dotsphinx.com>
// All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// $Id: Win32InputMonitor.hh,v 1.3 2004/03/11 20:02:33 dotsphinx Exp $
//

#ifndef WIN32INPUTMONITOR_HH
#define WIN32INPUTMONITOR_HH

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <windows.h>
#include "InputMonitorInterface.hh"

typedef union HarpoonEventUnion HarpoonEvent;

//! Activity monitor for a local X server.
class Win32InputMonitor :
  public InputMonitorInterface
{
public:
  //! Constructor.
  Win32InputMonitor();

  //! Destructor.
  virtual ~Win32InputMonitor();

  void init(InputMonitorListenerInterface *);
  void terminate() ;

private:
  static void on_harpoon_event(HarpoonEvent *event);
  static InputMonitorListenerInterface *listener;
};

#endif // WIN32INPUTMONITOR_HH
