/*
 * $Id: plat_aix.c,v 1.1 1999/02/09 14:58:56 dirk Exp $
 *
 * This file is part of WorkMan, the civilized CD player program
 * (c) 1991-1997 by Steven Grimm (original author)
 * (c) by Dirk F"orsterling (current 'author' = maintainer)
 * The maintainer can be contacted by his e-mail address:
 * milliByte@DeathsDoor.com 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * plat_aix - AIX 4.x IDE and SCSI support  16 Dec 1998
 *
 * AIX 4.x Port: Erik O'Shaughnessy 
 * Original AIX IDE Code: Cloyce Spradling (xmcd libdi_d/aixioc.c )
 *
 * Taken from the ascd distribution.
 *
 */


#ifdef AIXV3

static char plat_aix_id[] = "$Id: plat_aix.c,v 1.1 1999/02/09 14:58:56 dirk Exp $";

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/cdrom.h>
#include <sys/devinfo.h>
#include <sys/scsi.h>
#include <sys/scdisk.h>

#include "struct.h"
#include "config.h"
#include "proto.h"

#define LEADOUT 0xaa

extern char *cd_device;

int min_volume = 128;
int max_volume = 255;



/* NAME: gen_init
 *
 * FUNCTION:
 *
 * RETURNS: 
 */

int gen_init(struct wm_drive *d){

  return 0;
}

/* NAME: gen_get_trackcount
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_get_trackcount(struct wm_drive *d,int *tracks){ 
  struct cd_audio_cmd cmd;

  cmd.audio_cmds = CD_TRK_INFO_AUDIO;
  cmd.msf_flag = 0;

  if( ioctl(d->fd,DKAUDIO,&cmd) < 0){
    perror("DKAUDIO");
    return -1;
  }

  *tracks = cmd.indexing.track_index.last_track;

  return 0;
}


/* NAME: gen_get_cdlen
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_get_cdlen(struct wm_drive *d,int *frames){ 
  int tmp;

  return gen_get_trackinfo(d,LEADOUT,&tmp,frames);
}

/* NAME: gen_get_trackinfo
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_get_trackinfo(struct wm_drive *d,int track,int *data,int *startframe){
  struct cd_audio_cmd cmd;

  cmd.audio_cmds = CD_GET_TRK_MSF;
  cmd.msf_flag = 1;

  cmd.indexing.track_msf.track = track;
  
  if( ioctl(d->fd,DKAUDIO,&cmd) < 0)
    return -1;
  
  *startframe = cmd.indexing.track_msf.mins * 60 * 75 +
                cmd.indexing.track_msf.secs * 75 +
                cmd.indexing.track_msf.frames;

  *data = 0;

  return 0;
}

/* NAME: gen_get_drive_status
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_get_drive_status(struct wm_drive *d,
			 enum cd_modes oldmode,
			 enum cd_modes *mode,
			 int *pos,
			 int *track,
			 int *index){ 
  struct cd_audio_cmd cmd;

  *mode = EJECTED;

  if(d->fd < 0)
    switch( wmcd_open(d) ){
      case -1:
	return -1;
      case 1:
	return 0;
    }

  cmd.audio_cmds = CD_INFO_AUDIO;
  if( ioctl(d->fd,DKAUDIO,&cmd) < 0)
    return -1;

  switch(cmd.status){
    case CD_PLAY_AUDIO:
      *mode = PLAYING;
      *track = cmd.indexing.info_audio.current_track;
      *index = cmd.indexing.info_audio.current_index;
      *pos = cmd.indexing.info_audio.current_mins * 60 * 75 +
	     cmd.indexing.info_audio.current_secs * 75 +
	     cmd.indexing.info_audio.current_frames;
      break;

    case CD_PAUSE_AUDIO:
      *mode = PAUSED;
      *track = cmd.indexing.info_audio.current_track;
      *index = cmd.indexing.info_audio.current_index;
      *pos = cmd.indexing.info_audio.current_mins * 60 * 75 +
	     cmd.indexing.info_audio.current_secs * 75 +
	     cmd.indexing.info_audio.current_frames;

      break;
    case CD_NO_AUDIO:		/* no play audio in progress */
    case CD_COMPLETED:		/* play operation completed successfully */
    case CD_STATUS_ERROR:	/* invalid status or play stopped due to err */
    case CD_NOT_VALID:		/* audio status is invalid or not supported */
      *mode = STOPPED;
      break;
    default:
      *mode = UNKNOWN;
      break;
  }

  return 0;
}


int scale_volume(int vol,int max){
  return ((vol * (max_volume - min_volume)) / max + min_volume);
}

int unscale_volume(int vol,int max){
  int n;
  n = ( vol - min_volume ) * max_volume / (max - min_volume);
  return (n <0)?0:n;
}

/* NAME: gen_get_volume
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_get_volume(struct wm_drive *d,int *left,int *right){ 
  struct cd_audio_cmd cmd;
  int l,r;

  fprintf(stderr,"gen_get_volume\n");

  cmd.audio_cmds = CD_INFO_AUDIO;
  if( ioctl(d->fd,DKAUDIO,&cmd) < 0)
    return -1;

  *left = unscale_volume(cmd.out_port_0_vol,100);
  *right = unscale_volume(cmd.out_port_1_vol,100);

  return 0;
}

/* NAME: gen_set_volume
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_set_volume(struct wm_drive *d,int left,int right){ 
  struct cd_audio_cmd cmd;

  cmd.audio_cmds = CD_SET_VOLUME;
  cmd.volume_type = CD_VOLUME_CHNLS;
  
  cmd.out_port_0_vol = scale_volume(left,100);
  cmd.out_port_1_vol = scale_volume(right,100);

  if( ioctl(d->fd,DKAUDIO,&cmd) < 0){
    perror("CD_SET_VOLUME");
    return -1;
  }

  return 0;
}

/* NAME: gen_pause
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_pause(struct wm_drive *d){ 
  struct cd_audio_cmd cmd;
  
  cmd.audio_cmds = CD_PAUSE_AUDIO;

  return ioctl(d->fd,DKAUDIO,&cmd);
}

/* NAME: gen_resume
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_resume(struct wm_drive *d){ 
  struct cd_audio_cmd cmd;

  cmd.audio_cmds = CD_RESUME_AUDIO;
  return ioctl(d->fd,DKAUDIO,&cmd);
}

/* NAME: gen_stop
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_stop(struct wm_drive *d){ 
  struct cd_audio_cmd cmd;

  cmd.audio_cmds = CD_STOP_AUDIO;
  return ioctl(d->fd,DKAUDIO,&cmd);
}

/* NAME: gen_play
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_play(struct wm_drive *d,int start,int end){ 
  struct cd_audio_cmd cmd;

  cmd.audio_cmds = CD_PLAY_AUDIO;
  cmd.msf_flag = 1;

  cmd.indexing.msf.first_mins = start / (60*75);
  cmd.indexing.msf.first_secs = (start % (60*75)) / 75;
  cmd.indexing.msf.first_frames = start % 75;

  cmd.indexing.msf.last_mins = end / (60*75);
  cmd.indexing.msf.last_secs = (end % (60*75)) / 75;
  cmd.indexing.msf.last_frames = end % 75;

  if( ioctl(d->fd,DKAUDIO,&cmd) < 0){
    perror("DKAUDIO:CD_PLAY_AUDIO");
    return -1;
  }

  return 0;
}

/* NAME: gen_eject
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int gen_eject(struct wm_drive *d){ 

  return ioctl(d->fd,DKEJECT,NULL);
}

/* NAME: wm_scsi
 *
 * FUNCTION:
 *
 * RETURNS:
 */



int wm_scsi(struct wm_drive *d,
	    uchar_t *cdb, int cdblen,void *retbuf,int retbuflen,int getreply){
  return 0;
}


/* NAME: wmcd_open
 *
 * FUNCTION:
 *
 * RETURNS:
 */

int wmcd_open(struct wm_drive *d){
  char vendor[9], model[17], rev[5];
  int fd;

  if( ! d ){
    errno = EFAULT;
    return -1;
  }

  if(d->fd > -1)			/* device already open? */
    return 0;

  if( cd_device == (char *)NULL )
    cd_device = DEFAULT_CD_DEVICE;

  if( (fd=openx(cd_device,O_RDONLY,NULL,SC_SINGLE)) < 0 ){
    perror("openx");
    return 1;
  }

  vendor[0] = model[0] = rev[0] = '\0';

  *d = *(find_drive_struct(vendor, model, rev));

  d->fd = fd;
  d->init(d);

  return 0;
}

#endif /* _AIX */
