/* searchentryop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: searchentryop.cc,v 1.9 2004/10/27 21:08:56 ralf Exp $ */

#include "searchentryop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *SearchEntryOp::name="SearchEntryOp";

SearchEntryOp::SearchEntryOp() : FunctionProto()
{
  ignore_case = false;
  hasConfigure = true;
}

SearchEntryOp::~SearchEntryOp()
{
}

SearchEntryOp*
SearchEntryOp::duplicate() const
{
  SearchEntryOp *ta=new SearchEntryOp();
  ta->ignore_case = ignore_case;
  return ta;
}

bool
SearchEntryOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
SearchEntryOp::getName()
{
  return name;
}

int
SearchEntryOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodesearchentry();
    }
  }
  return 0;
}

const char *
SearchEntryOp::getDescription()
{
  return catalog.getLocaleCom(33);
}

int
SearchEntryOp::normalmodesearchentry()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  
  nm1->searchentry( ignore_case );
  return 0;
}

bool SearchEntryOp::save( Datei *fh )
{
  if ( fh == NULL ) return false;
  WConfig::configPutPairBool( fh, "ignorecase", ignore_case );
  return true;
}

void SearchEntryOp::setIgnoreCase( bool nv )
{
  ignore_case = nv;
}

int SearchEntryOp::configure()
{
  int w, h, tw, ty, tx;
  ChooseButton *cb;
  AGUIX *aguix = Worker::getAGUIX();
  AWindow *win = new AWindow( aguix );
  char *tstr;
  GUIElement *b[2];
  int ende = 0;

  w = h = 10;
  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 293 ) ) + strlen( getDescription() ) + 1 );
  sprintf( tstr, catalog.getLocale( 293 ), getDescription() );
  win->create( NULL, 10, 10, w, h, 0, tstr );
  _freesafe( tstr );
  
  ty = 5;
  tx = 5;

  cb = (ChooseButton*)win->add( new ChooseButton( aguix, tx, ty, ( ignore_case == true ) ? 1 : 0,
                                                  catalog.getLocale( 501), LABEL_RIGHT, 1, 0 ) );
  ty += cb->getHeight() + 5;
  tw = cb->getWidth() + 10;
  if ( tw > w ) w = tw;
  
  Button *okb = (Button*)win->add( new Button( aguix,
                                               5,
                                               ty,
                                               catalog.getLocale( 11 ),
                                               1,
                                               0,
                                               0 ) );
  Button *cancelb = (Button*)win->add( new Button( aguix,
                                                   5,
                                                   ty,
                                                   catalog.getLocale( 8 ),
                                                   1,
                                                   0,
                                                   0 ) );
  b[0] = okb;
  b[1] = cancelb;
  tw = AGUIX::scaleElementsW( w, 5, 5, -1, false, false, b, NULL, 2 );
  if ( tw > w ) w = tw;
  h = okb->getY() + okb->getHeight() + 5;
  win->setDoTabCycling( true );
  win->resize(w,h);
  win->setMinSize( w, h );
  win->setMaxSize( w, h );
  win->show();
  AGMessage *msg;
  while ( ( msg = aguix->GetMessage( NULL ) ) != NULL ) aguix->ReplyMessage( msg );
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() ) ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == okb ) ende = 1;
        else if ( msg->button.button == cancelb ) ende = -1;
      }
      aguix->ReplyMessage( msg );
    }
  }
  if ( ende == 1 ) {
    ignore_case = ( cb->getState() == 1 ) ? true : false;
  }
  win->close();
  delete win;
  return ( ende == 1 ) ? 0 : 1;
}

