/* worker.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: worker.h,v 1.26 2002/03/10 21:55:38 ralf Exp $ */

#ifndef WORKER_H
#define WORKER_H

#include "workerversion.h"
#include "wdefines.h"
#include <aguix/lowlevelfunc.h>
#include <aguix/aguix.h>
#include <aguix/util.h>
#include <aguix/message.h>
#include <aguix/button.h>
#include <aguix/solidbutton.h>
#include <aguix/request.h>
#include "functionproto.h"
#include "wconfig.h"
#include "dnd.h"
#include "partspace.h"

class ListerMode;
class Lister;

class Worker
{
public:
  Worker(int argc,char **argv);
  ~Worker();
  void run();
  AGUIX *getAGUIX();
  int getMaxModeNr();
  static int getID4Mode(ListerMode*);
  ListerMode *getMode4ID(int,Lister *);
  AWindow *getMainWin();
  void getGeometry(Lister*,int*,int*,int*,int*);
  void setStatebarText(const char*);
  static int getNrOfCommands();
  FunctionProto *getCommand4ID(int);
  static int getID4Command(FunctionProto*);
  Lister *getOtherLister(Lister*);
  int getSide(Lister*);
  Lister *getLister(int);
  Lister *getActiveLister();
  int interpret(List*,ActionMessage *);
  
  int quit(int mode);
  void checkfirststart( char **setlang );
  void setTitle(const char *add_infos);
  
  static Requester *getRequester();
  void activateShortkeyFromList();

  int PS_readSpace( const char*name );
  
  long PS_getBlocksize();
  long PS_getFreeSpace();
  long PS_getSpace();
  
  long PS_getFreeSpaceH(char **unit_return);
  long PS_getSpaceH(char **unit_return);
protected:
  void buildMainWin(bool);
  void resizeMainWin(int,int);
  void shufflePath();
  void shuffleButton( int dir );
  void about();
  bool configure();
  void showPathBank();
  void showButtonBank();
  void setPath(int);
  void activateShortkey(AGMessage*);
  void activateButton(int,int,int);
  int saveListerState();
  int initListerState();
  void updateTime();

  AGUIX *aguix;
  Lister *lister[2];
  AWindow *mainwin;
  Button *aboutb,*configureb,*clockbar;
  SolidButton *statebar;
  Button **pathbs;
  Button **buttons;
  int w,h;
  unsigned int oldrows,oldcolumns;
  int pbanknr,bbanknr;
  
  enum {WORKER_NORMAL,WORKER_QUIT};
  int runningmode;
  int argc;
  char **argv;
  time_t lasttimep;
  
  DNDMsg *dm;

  static Requester *req_static;
  
  static int shortkeysort(void*p1,void*p2);
  struct shortkeylisttype {WCHotkey *h;
                           WCButton *b;
                           WCPath *p;};
  PartSpace *freesp;
};

#endif

