/* scrolllisterop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: scrolllisterop.cc,v 1.8 2001/11/03 17:10:38 ralf Exp $ */

#include "scrolllisterop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ScrollListerOp::name="ScrollListerOp";

ScrollListerOp::ScrollListerOp(Worker *tworker):FunctionProto(tworker)
{
  dir=SCROLLLISTEROP_LEFT;
}

ScrollListerOp::~ScrollListerOp()
{
}

ScrollListerOp*
ScrollListerOp::duplicate()
{
  ScrollListerOp *ta=new ScrollListerOp(worker);
  ta->dir=dir;
  return ta;
}

bool
ScrollListerOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ScrollListerOp::getName()
{
  return name;
}

int
ScrollListerOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1=worker->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodescrolllister();
    }
  }
  return 0;
}

bool
ScrollListerOp::save(Datei *fh)
{
  int size=Datei::getUCharSize();
  fh->putInt(size);

  switch(dir) {
    case SCROLLLISTEROP_RIGHT:
      fh->putUChar(1);
      break;
    default:
      fh->putUChar(0);
  }
  return true;
}

int
ScrollListerOp::load(Datei *fh)
{
  int chunksize=fh->getInt();
  int cs=Datei::getUCharSize();
  unsigned char c1;
  if(chunksize>=cs) {
    c1=fh->getUChar();
    switch(c1) {
      case 1:
        dir=SCROLLLISTEROP_RIGHT;
        break;
      default:
        dir=SCROLLLISTEROP_LEFT;
        break;
    }
    chunksize-=cs;
  }
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return true;
}

const char *
ScrollListerOp::getDescription()
{
  return catalog.getLocaleCom(35);
}

void
ScrollListerOp::normalmodescrolllister()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  
  if(startlister==NULL) return;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return;
  if(lm1->isType("NormalMode")!=true) return;
  nm1=(NormalMode*)lm1;
  
  if(dir==SCROLLLISTEROP_RIGHT)
    nm1->scrolllister(1);
  else
    nm1->scrolllister(-1);
}

int
ScrollListerOp::configure()
{
  AGUIX *aguix=worker->getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  CycleButton *rcyb;
  Text *ttext;
  int tw,w,h,x,y,t1,t2;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  
  w=h=10;
  x=y=5;
  win=new AWindow(aguix);

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(35))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(35));
  win->create(NULL,10,10,w,h,0,tstr);
  _freesafe(tstr);

  ttext=(Text*)win->add(new Text(aguix,x,y,catalog.getLocale(340),1));
  x+=ttext->getWidth()+5;
  rcyb=(CycleButton*)win->add(new CycleButton(aguix,x,y,100,1,0,0));
  rcyb->addOption(catalog.getLocale(341));
  rcyb->addOption(catalog.getLocale(342));
  rcyb->resize(rcyb->getMaxSize(),rcyb->getHeight());
  switch(dir) {
    case SCROLLLISTEROP_RIGHT:
      rcyb->setOption(1);
      break;
    default:
      rcyb->setOption(0);
      break;
  }
  
  y+=rcyb->getHeight()+5;
  tw=x+rcyb->getWidth()+5;
  if(tw>w) w=tw;
  x=5;

  t1=(strlen(catalog.getLocale(11))+2);
  t1*=aguix->getCharWidth();
  t2=(strlen(catalog.getLocale(8))+2);
  t2*=aguix->getCharWidth();
  tw=5+t1+5+t2+5;
  if(tw>w) w=tw;
  okb=(Button*)win->add(new Button(aguix,
                                   5,
                                   y,
                                   t1,
                                   catalog.getLocale(11),
                                   1,
                                   0,
                                   0));
  cb=(Button*)win->add(new Button(aguix,
                                  w-5-t2,
                                  y,
                                  t2,
                                  catalog.getLocale(8),
                                  1,
                                  0,
                                  0));
  y+=okb->getHeight()+5;
  
  h=y;
  win->resize(w,h);
  win->setMaxSize(w,h);
  win->setMinSize(w,h);
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    switch(rcyb->getSelectedOption()) {
      case 1:
        dir=SCROLLLISTEROP_RIGHT;
        break;
      default:
        dir=SCROLLLISTEROP_LEFT;
        break;
    }
  }
  
  win->close();
  delete win;

  return endmode;
}

void ScrollListerOp::setDir(scrolllister_t nv)
{
  dir=nv;
}

